/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.immutable;

import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.compat.java8.JFunction1;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import strawman.collection.CanBuild;
import strawman.collection.IndexedSeqOps;
import strawman.collection.IndexedView;
import strawman.collection.Iterable;
import strawman.collection.IterableFactory;
import strawman.collection.IterableOnce;
import strawman.collection.IterableOps;
import strawman.collection.Iterator;
import strawman.collection.SeqOps;
import strawman.collection.StrictOptimizedIterableOps;
import strawman.collection.View;
import strawman.collection.View$Concat$;
import strawman.collection.View$Filter$;
import strawman.collection.View$Partition$;
import strawman.collection.View$Zip$;
import strawman.collection.immutable.ImmutableArray$;
import strawman.collection.immutable.IndexedSeq;
import strawman.collection.immutable.StrictOptimizedSeqOps;
import strawman.collection.mutable.ArrayBuffer;
import strawman.collection.mutable.Builder;

public class ImmutableArray
implements IterableOps,
SeqOps,
IndexedSeqOps,
IndexedSeq,
StrictOptimizedIterableOps,
StrictOptimizedSeqOps {
    private final Object[] elements;

    public static Builder newBuilder() {
        return ImmutableArray$.MODULE$.newBuilder();
    }

    public static ImmutableArray tabulate(int n, Function1 function1) {
        return ImmutableArray$.MODULE$.tabulate(n, function1);
    }

    public static CanBuild canBuildIterable() {
        return ImmutableArray$.MODULE$.canBuildIterable();
    }

    public static ImmutableArray fromArrayBuffer(ArrayBuffer arrayBuffer) {
        return ImmutableArray$.MODULE$.fromArrayBuffer(arrayBuffer);
    }

    public static ImmutableArray empty() {
        return ImmutableArray$.MODULE$.empty();
    }

    public static ImmutableArray fill(int n, Function0 function0) {
        return ImmutableArray$.MODULE$.fill(n, function0);
    }

    public ImmutableArray(Object[] elements) {
        this.elements = elements;
    }

    @Override
    public String toString() {
        return IterableOps.super.toString();
    }

    @Override
    public boolean equals(Object o) {
        return SeqOps.super.equals(o);
    }

    @Override
    public int hashCode() {
        return SeqOps.super.hashCode();
    }

    @Override
    public IndexedView view() {
        return IndexedSeqOps.super.view();
    }

    @Override
    public Iterable reversed() {
        return IndexedSeqOps.super.reversed();
    }

    @Override
    public Tuple2 span(Function1 p) {
        return StrictOptimizedIterableOps.super.span(p);
    }

    @Override
    public Tuple2 unzip(Predef$.less.colon.less asPair) {
        return StrictOptimizedIterableOps.super.unzip(asPair);
    }

    private Object[] elements() {
        return this.elements;
    }

    @Override
    public IterableFactory iterableFactory() {
        return ImmutableArray$.MODULE$;
    }

    @Override
    public ImmutableArray fromSpecificIterable(Iterable coll) {
        return (ImmutableArray)this.fromIterable(coll);
    }

    @Override
    public Builder newSpecificBuilder() {
        return ImmutableArray$.MODULE$.newBuilder();
    }

    @Override
    public int length() {
        return this.elements().length;
    }

    @Override
    public int knownSize() {
        return this.elements().length;
    }

    @Override
    public Object apply(int i) {
        return ScalaRunTime$.MODULE$.array_apply((Object)this.elements(), i);
    }

    @Override
    public Iterator iterator() {
        return this.view().iterator();
    }

    @Override
    public ImmutableArray updated(int index, Object elem) {
        Object[] dest = new Object[this.length()];
        System.arraycopy(this.elements(), 0, dest, 0, this.length());
        dest[index] = elem;
        return new ImmutableArray(dest);
    }

    @Override
    public ImmutableArray map(Function1 f) {
        return ImmutableArray$.MODULE$.tabulate(this.length(), (Function1)((JFunction1)arg_0 -> this.map$$anonfun$1(f, arg_0)));
    }

    @Override
    public ImmutableArray prepend(Object elem) {
        Object[] dest = new Object[this.length() + 1];
        dest[0] = elem;
        System.arraycopy(this.elements(), 0, dest, 1, this.length());
        return new ImmutableArray(dest);
    }

    @Override
    public ImmutableArray append(Object elem) {
        Object[] dest = new Object[this.length() + 1];
        System.arraycopy(this.elements(), 0, dest, 0, this.length());
        dest[this.length()] = elem;
        return new ImmutableArray(dest);
    }

    @Override
    public ImmutableArray concat(IterableOnce xs) {
        ImmutableArray immutableArray;
        IterableOnce iterableOnce = xs;
        if (iterableOnce instanceof ImmutableArray) {
            ImmutableArray immutableArray2;
            ImmutableArray bs = immutableArray2 = (ImmutableArray)iterableOnce;
            Object[] dest = new Object[this.length() + bs.length()];
            System.arraycopy(this.elements(), 0, dest, 0, this.length());
            System.arraycopy(bs.elements(), 0, dest, this.length(), bs.length());
            immutableArray = new ImmutableArray(dest);
        } else {
            immutableArray = ImmutableArray$.MODULE$.fromIterable(View$Concat$.MODULE$.apply(this.coll(), xs));
        }
        return immutableArray;
    }

    @Override
    public ImmutableArray zip(IterableOnce xs) {
        ImmutableArray immutableArray;
        IterableOnce iterableOnce = xs;
        if (iterableOnce instanceof ImmutableArray) {
            ImmutableArray immutableArray2;
            ImmutableArray bs = immutableArray2 = (ImmutableArray)iterableOnce;
            immutableArray = ImmutableArray$.MODULE$.tabulate(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.length()), bs.length()), (Function1)((JFunction1)arg_0 -> this.zip$$anonfun$1(bs, arg_0)));
        } else {
            immutableArray = ImmutableArray$.MODULE$.fromIterable(View$Zip$.MODULE$.apply(this.coll(), xs));
        }
        return immutableArray;
    }

    @Override
    public ImmutableArray filter(Function1 p) {
        return ImmutableArray$.MODULE$.fromIterable(View$Filter$.MODULE$.apply(this.coll(), p));
    }

    @Override
    public Tuple2 partition(Function1 p) {
        View.Partition pn = View$Partition$.MODULE$.apply(this.coll(), p);
        return Tuple2$.MODULE$.apply((Object)ImmutableArray$.MODULE$.fromIterable(pn.first()), (Object)ImmutableArray$.MODULE$.fromIterable(pn.second()));
    }

    @Override
    public ImmutableArray take(int n) {
        return ImmutableArray$.MODULE$.tabulate(n, (Function1)((JFunction1)this::take$$anonfun$1));
    }

    @Override
    public ImmutableArray takeRight(int n) {
        return ImmutableArray$.MODULE$.tabulate(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(n), this.length()), (Function1)((JFunction1)arg_0 -> this.takeRight$$anonfun$1(n, arg_0)));
    }

    @Override
    public ImmutableArray drop(int n) {
        return ImmutableArray$.MODULE$.tabulate(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.length() - n), 0), (Function1)((JFunction1)arg_0 -> this.drop$$anonfun$1(n, arg_0)));
    }

    @Override
    public ImmutableArray dropRight(int n) {
        return ImmutableArray$.MODULE$.tabulate(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.length() - n), 0), (Function1)((JFunction1)this::dropRight$$anonfun$1));
    }

    @Override
    public ImmutableArray tail() {
        if (this.length() <= 0) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        Object[] dest = new Object[this.length() - 1];
        System.arraycopy(this.elements(), 1, dest, 0, this.length() - 1);
        return new ImmutableArray(dest);
    }

    @Override
    public ImmutableArray reverse() {
        return ImmutableArray$.MODULE$.tabulate(this.length(), (Function1)((JFunction1)this::reverse$$anonfun$1));
    }

    private Object map$$anonfun$1(Function1 f$12, int i) {
        return f$12.apply(this.apply(i));
    }

    private Tuple2 zip$$anonfun$1(ImmutableArray bs$1, int i) {
        return Tuple2$.MODULE$.apply(this.apply(i), bs$1.apply(i));
    }

    private Object take$$anonfun$1(int i) {
        return this.apply(i);
    }

    private Object takeRight$$anonfun$1(int n$4, int i) {
        return this.apply(this.length() - RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(n$4), this.length()) + i);
    }

    private Object drop$$anonfun$1(int n$5, int i) {
        return this.apply(n$5 + i);
    }

    private Object dropRight$$anonfun$1(int i) {
        return this.apply(i);
    }

    private Object reverse$$anonfun$1(int i) {
        return this.apply(this.length() - 1 - i);
    }
}

