/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.immutable;

import java.util.NoSuchElementException;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import strawman.collection.Iterator;
import strawman.collection.immutable.RedBlackTree$;
import strawman.collection.immutable.RedBlackTree$BlackTree$;
import strawman.collection.immutable.RedBlackTree$NList$;
import strawman.collection.immutable.RedBlackTree$RedTree$;

public final class RedBlackTree {
    public static Tree nth(Tree tree, int n) {
        return RedBlackTree$.MODULE$.nth(tree, n);
    }

    public static Tree smallest(Tree tree) {
        return RedBlackTree$.MODULE$.smallest(tree);
    }

    public static boolean isBlack(Tree tree) {
        return RedBlackTree$.MODULE$.isBlack(tree);
    }

    public static boolean isEmpty(Tree tree) {
        return RedBlackTree$.MODULE$.isEmpty(tree);
    }

    public static Tree update(Tree tree, Object object, Object object2, boolean bl, Ordering ordering) {
        return RedBlackTree$.MODULE$.update(tree, object, object2, bl, ordering);
    }

    public static int count(Tree tree) {
        return RedBlackTree$.MODULE$.count(tree);
    }

    public static None$ keysIterator$default$2() {
        return RedBlackTree$.MODULE$.keysIterator$default$2();
    }

    public static Tree greatest(Tree tree) {
        return RedBlackTree$.MODULE$.greatest(tree);
    }

    public static void foreach(Tree tree, Function1 function1) {
        RedBlackTree$.MODULE$.foreach(tree, function1);
    }

    public static Tree take(Tree tree, int n, Ordering ordering) {
        return RedBlackTree$.MODULE$.take(tree, n, ordering);
    }

    public static Iterator keysIterator(Tree tree, Option option, Ordering ordering) {
        return RedBlackTree$.MODULE$.keysIterator(tree, option, ordering);
    }

    public static Tree slice(Tree tree, int n, int n2, Ordering ordering) {
        return RedBlackTree$.MODULE$.slice(tree, n, n2, ordering);
    }

    public static Iterator valuesIterator(Tree tree, Option option, Ordering ordering) {
        return RedBlackTree$.MODULE$.valuesIterator(tree, option, ordering);
    }

    public static void foreachKey(Tree tree, Function1 function1) {
        RedBlackTree$.MODULE$.foreachKey(tree, function1);
    }

    public static Tree rangeImpl(Tree tree, Option option, Option option2, Ordering ordering) {
        return RedBlackTree$.MODULE$.rangeImpl(tree, option, option2, ordering);
    }

    public static Tree drop(Tree tree, int n, Ordering ordering) {
        return RedBlackTree$.MODULE$.drop(tree, n, ordering);
    }

    public static None$ iterator$default$2() {
        return RedBlackTree$.MODULE$.iterator$default$2();
    }

    public static Tree until(Tree tree, Object object, Ordering ordering) {
        return RedBlackTree$.MODULE$.until(tree, object, ordering);
    }

    public static boolean contains(Tree tree, Object object, Ordering ordering) {
        return RedBlackTree$.MODULE$.contains(tree, object, ordering);
    }

    public static None$ valuesIterator$default$2() {
        return RedBlackTree$.MODULE$.valuesIterator$default$2();
    }

    public static Tree range(Tree tree, Object object, Object object2, Ordering ordering) {
        return RedBlackTree$.MODULE$.range(tree, object, object2, ordering);
    }

    public static Iterator iterator(Tree tree, Option option, Ordering ordering) {
        return RedBlackTree$.MODULE$.iterator(tree, option, ordering);
    }

    public static int countInRange(Tree tree, Option option, Option option2, Ordering ordering) {
        return RedBlackTree$.MODULE$.countInRange(tree, option, option2, ordering);
    }

    public static Tree from(Tree tree, Object object, Ordering ordering) {
        return RedBlackTree$.MODULE$.from(tree, object, ordering);
    }

    public static Tree to(Tree tree, Object object, Ordering ordering) {
        return RedBlackTree$.MODULE$.to(tree, object, ordering);
    }

    public static Tree lookup(Tree tree, Object object, Ordering ordering) {
        return RedBlackTree$.MODULE$.lookup(tree, object, ordering);
    }

    public static Option get(Tree tree, Object object, Ordering ordering) {
        return RedBlackTree$.MODULE$.get(tree, object, ordering);
    }

    public static Tree delete(Tree tree, Object object, Ordering ordering) {
        return RedBlackTree$.MODULE$.delete(tree, object, ordering);
    }

    public static final class BlackTree
    extends Tree {
        public static BlackTree apply(Object object, Object object2, Tree tree, Tree tree2) {
            return RedBlackTree$BlackTree$.MODULE$.apply(object, object2, tree, tree2);
        }

        public static Some unapply(BlackTree blackTree) {
            return RedBlackTree$BlackTree$.MODULE$.unapply(blackTree);
        }

        public BlackTree(Object key, Object value, Tree left, Tree right) {
            super(key, value, left, right);
        }

        public Object strawman$collection$immutable$RedBlackTree$BlackTree$$key() {
            return super.key();
        }

        public Object strawman$collection$immutable$RedBlackTree$BlackTree$$value() {
            return super.value();
        }

        public Tree strawman$collection$immutable$RedBlackTree$BlackTree$$left() {
            return super.left();
        }

        public Tree strawman$collection$immutable$RedBlackTree$BlackTree$$right() {
            return super.right();
        }

        @Override
        public Tree black() {
            return this;
        }

        @Override
        public Tree red() {
            return new RedTree(this.strawman$collection$immutable$RedBlackTree$BlackTree$$key(), this.strawman$collection$immutable$RedBlackTree$BlackTree$$value(), this.strawman$collection$immutable$RedBlackTree$BlackTree$$left(), this.strawman$collection$immutable$RedBlackTree$BlackTree$$right());
        }

        public String toString() {
            return new StringBuilder().append((Object)"BlackTree(").append(this.strawman$collection$immutable$RedBlackTree$BlackTree$$key()).append((Object)", ").append(this.strawman$collection$immutable$RedBlackTree$BlackTree$$value()).append((Object)", ").append((Object)this.strawman$collection$immutable$RedBlackTree$BlackTree$$left()).append((Object)", ").append((Object)this.strawman$collection$immutable$RedBlackTree$BlackTree$$right()).append((Object)")").toString();
        }
    }

    private static class EntriesIterator
    extends TreeIterator {
        public EntriesIterator(Tree tree, Option focus, Ordering evidence$50) {
            super(tree, focus, evidence$50);
        }

        public Tuple2 nextResult(Tree tree) {
            return Tuple2$.MODULE$.apply(tree.key(), tree.value());
        }
    }

    private static class KeysIterator
    extends TreeIterator {
        public KeysIterator(Tree tree, Option focus, Ordering evidence$51) {
            super(tree, focus, evidence$51);
        }

        @Override
        public Object nextResult(Tree tree) {
            return tree.key();
        }
    }

    private static final class NList {
        private final Object head;
        private final NList tail;

        public static Object foldLeft(NList nList, Object object, Function2 function2) {
            return RedBlackTree$NList$.MODULE$.foldLeft(nList, object, function2);
        }

        public static NList cons(Object object, NList nList) {
            return RedBlackTree$NList$.MODULE$.cons(object, nList);
        }

        public NList(Object head, NList tail) {
            this.head = head;
            this.tail = tail;
        }

        public Object head() {
            return this.head;
        }

        public NList tail() {
            return this.tail;
        }
    }

    public static final class RedTree
    extends Tree {
        public static RedTree apply(Object object, Object object2, Tree tree, Tree tree2) {
            return RedBlackTree$RedTree$.MODULE$.apply(object, object2, tree, tree2);
        }

        public static Some unapply(RedTree redTree) {
            return RedBlackTree$RedTree$.MODULE$.unapply(redTree);
        }

        public RedTree(Object key, Object value, Tree left, Tree right) {
            super(key, value, left, right);
        }

        public Object strawman$collection$immutable$RedBlackTree$RedTree$$key() {
            return super.key();
        }

        public Object strawman$collection$immutable$RedBlackTree$RedTree$$value() {
            return super.value();
        }

        public Tree strawman$collection$immutable$RedBlackTree$RedTree$$left() {
            return super.left();
        }

        public Tree strawman$collection$immutable$RedBlackTree$RedTree$$right() {
            return super.right();
        }

        @Override
        public Tree black() {
            return new BlackTree(this.strawman$collection$immutable$RedBlackTree$RedTree$$key(), this.strawman$collection$immutable$RedBlackTree$RedTree$$value(), this.strawman$collection$immutable$RedBlackTree$RedTree$$left(), this.strawman$collection$immutable$RedBlackTree$RedTree$$right());
        }

        @Override
        public Tree red() {
            return this;
        }

        public String toString() {
            return new StringBuilder().append((Object)"RedTree(").append(this.strawman$collection$immutable$RedBlackTree$RedTree$$key()).append((Object)", ").append(this.strawman$collection$immutable$RedBlackTree$RedTree$$value()).append((Object)", ").append((Object)this.strawman$collection$immutable$RedBlackTree$RedTree$$left()).append((Object)", ").append((Object)this.strawman$collection$immutable$RedBlackTree$RedTree$$right()).append((Object)")").toString();
        }
    }

    public static abstract class Tree
    implements Serializable {
        private final Object key;
        private final Object value;
        private final Tree left;
        private final Tree right;
        private final int count;

        public Tree(Object key, Object value, Tree left, Tree right) {
            this.key = key;
            this.value = value;
            this.left = left;
            this.right = right;
            this.count = 1 + RedBlackTree$.MODULE$.count(left) + RedBlackTree$.MODULE$.count(right);
        }

        public final Object key() {
            return this.key;
        }

        public final Object value() {
            return this.value;
        }

        public final Tree left() {
            return this.left;
        }

        public final Tree right() {
            return this.right;
        }

        public final int count() {
            return this.count;
        }

        public abstract Tree black();

        public abstract Tree red();
    }

    private static abstract class TreeIterator
    implements Iterator {
        private final Tree root;
        private final Ordering ordering;
        private Tree[] stackOfNexts;
        private int index;
        private Tree lookahead;

        public TreeIterator(Tree root, Option start, Ordering ordering) {
            Tree[] treeArray;
            this.root = root;
            this.ordering = ordering;
            if (root == null) {
                treeArray = null;
            } else {
                int maximumHeight = 2 * (32 - Integer.numberOfLeadingZeros(root.count() + 2 - 1)) - 2;
                treeArray = new Tree[maximumHeight];
            }
            this.stackOfNexts = treeArray;
            this.index = 0;
            this.lookahead = (Tree)start.map(this::$init$$$anonfun$4).getOrElse(() -> this.$init$$$anonfun$5(root));
        }

        public abstract Object nextResult(Tree var1);

        @Override
        public boolean hasNext() {
            return this.lookahead != null;
        }

        @Override
        public Object next() {
            Tree tree = this.lookahead;
            if (tree == null) {
                throw new NoSuchElementException("next on empty iterator");
            }
            Tree tree2 = tree;
            this.lookahead = this.findLeftMostOrPopOnEmpty(this.goRight(tree2));
            return this.nextResult(tree2);
        }

        /*
         * Enabled aggressive block sorting
         */
        private Tree findLeftMostOrPopOnEmpty(Tree tree) {
            Tree tree2 = tree;
            TreeIterator treeIterator = this;
            while (true) {
                Tree tree3;
                if (tree2 == null) {
                    tree3 = treeIterator.popNext();
                    return tree3;
                }
                if (tree2.left() == null) {
                    tree3 = tree2;
                    return tree3;
                }
                tree2 = treeIterator.goLeft(tree2);
            }
        }

        private void pushNext(Tree tree) {
            this.stackOfNexts[this.index] = tree;
            ++this.index;
        }

        private Tree popNext() {
            Tree tree;
            if (this.index == 0) {
                tree = null;
            } else {
                --this.index;
                tree = this.stackOfNexts[this.index];
            }
            return tree;
        }

        private Tree startFrom(Object key) {
            return this.root == null ? null : this.find$1(key, this.root);
        }

        private Tree goLeft(Tree tree) {
            this.pushNext(tree);
            return tree.left();
        }

        private Tree goRight(Tree tree) {
            return tree.right();
        }

        private Tree $init$$$anonfun$4(Object key) {
            return this.startFrom(key);
        }

        private Tree $init$$$anonfun$5(Tree root$1) {
            return this.findLeftMostOrPopOnEmpty(root$1);
        }

        /*
         * Enabled aggressive block sorting
         */
        private Tree find$1(Object key$1, Tree tree) {
            Tree tree2 = tree;
            while (tree2 != null) {
                tree2 = !this.ordering.lteq(key$1, tree2.key()) ? this.goRight(tree2) : this.goLeft(tree2);
            }
            return this.popNext();
        }
    }

    private static class ValuesIterator
    extends TreeIterator {
        public ValuesIterator(Tree tree, Option focus, Ordering evidence$52) {
            super(tree, focus, evidence$52);
        }

        @Override
        public Object nextResult(Tree tree) {
            return tree.value();
        }
    }
}

