/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.immutable;

import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import strawman.collection.CanBuild;
import strawman.collection.Iterable;
import strawman.collection.IterableFactory;
import strawman.collection.Iterator;
import strawman.collection.MapFactory;
import strawman.collection.MapOps;
import strawman.collection.SortedMapFactory;
import strawman.collection.SortedMapOps;
import strawman.collection.StrictOptimizedIterableOps;
import strawman.collection.immutable.List$;
import strawman.collection.immutable.Map$;
import strawman.collection.immutable.RedBlackTree;
import strawman.collection.immutable.RedBlackTree$;
import strawman.collection.immutable.SortedMap;
import strawman.collection.immutable.SortedMapOps;
import strawman.collection.immutable.TreeMap$;
import strawman.collection.mutable.Builder;

public final class TreeMap
implements MapOps,
strawman.collection.SortedMapOps,
SortedMapOps,
SortedMap,
StrictOptimizedIterableOps,
Serializable {
    private final RedBlackTree.Tree tree;
    private final Ordering ordering;

    public static Builder newBuilder(Ordering ordering) {
        return TreeMap$.MODULE$.newBuilder(ordering);
    }

    public static TreeMap sortedFromIterable(Iterable iterable, Ordering ordering) {
        return TreeMap$.MODULE$.sortedFromIterable(iterable, ordering);
    }

    public static CanBuild canBuildSortedMap(Ordering ordering) {
        return TreeMap$.MODULE$.canBuildSortedMap(ordering);
    }

    private TreeMap(RedBlackTree.Tree tree, Ordering ordering) {
        this.tree = tree;
        this.ordering = ordering;
        Function1.class.$init$((Function1)this);
        PartialFunction.class.$init$((PartialFunction)this);
    }

    public Function1 compose(Function1 g) {
        return Function1.class.compose((Function1)this, (Function1)g);
    }

    @Override
    public String toString() {
        return Function1.class.toString((Function1)this);
    }

    public PartialFunction orElse(PartialFunction that) {
        return PartialFunction.class.orElse((PartialFunction)this, (PartialFunction)that);
    }

    public PartialFunction andThen(Function1 k) {
        return PartialFunction.class.andThen((PartialFunction)this, (Function1)k);
    }

    public Function1 lift() {
        return PartialFunction.class.lift((PartialFunction)this);
    }

    public Object applyOrElse(Object x, Function1 function1) {
        return PartialFunction.class.applyOrElse((PartialFunction)this, (Object)x, (Function1)function1);
    }

    public Function1 runWith(Function1 action) {
        return PartialFunction.class.runWith((PartialFunction)this, (Function1)action);
    }

    @Override
    public boolean equals(Object o) {
        return MapOps.super.equals(o);
    }

    @Override
    public int hashCode() {
        return MapOps.super.hashCode();
    }

    @Override
    public SortedMapOps.SortedMapWithFilter withFilter(Function1 p) {
        return strawman.collection.SortedMapOps.super.withFilter(p);
    }

    @Override
    public TreeMap $plus$plus(Iterable xs) {
        return (TreeMap)strawman.collection.SortedMapOps.super.$plus$plus(xs);
    }

    @Override
    public TreeMap $plus(Tuple2 kv) {
        return (TreeMap)SortedMapOps.super.$plus(kv);
    }

    @Override
    public TreeMap concat(Iterable xs) {
        return (TreeMap)SortedMapOps.super.concat(xs);
    }

    @Override
    public Tuple2 partition(Function1 p) {
        return StrictOptimizedIterableOps.super.partition(p);
    }

    @Override
    public Tuple2 unzip(Predef$.less.colon.less asPair) {
        return StrictOptimizedIterableOps.super.unzip(asPair);
    }

    @Override
    public Ordering ordering() {
        return this.ordering;
    }

    public TreeMap(Ordering ordering) {
        this(null, ordering);
    }

    @Override
    public IterableFactory iterableFactory() {
        return List$.MODULE$;
    }

    @Override
    public MapFactory mapFactory() {
        return Map$.MODULE$;
    }

    @Override
    public SortedMapFactory sortedMapFactory() {
        return TreeMap$.MODULE$;
    }

    @Override
    public TreeMap fromSpecificIterable(Iterable coll) {
        return TreeMap$.MODULE$.sortedFromIterable(coll, this.ordering());
    }

    @Override
    public TreeMap sortedMapFromIterable(Iterable it, Ordering ordering) {
        return TreeMap$.MODULE$.sortedFromIterable(it, ordering);
    }

    @Override
    public Builder newSpecificBuilder() {
        return TreeMap$.MODULE$.newBuilder(this.ordering());
    }

    @Override
    public Iterator iterator() {
        return RedBlackTree$.MODULE$.iterator(this.tree, (Option)RedBlackTree$.MODULE$.iterator$default$2(), this.ordering());
    }

    @Override
    public Iterator keysIteratorFrom(Object start) {
        return RedBlackTree$.MODULE$.keysIterator(this.tree, (Option)Some$.MODULE$.apply(start), this.ordering());
    }

    @Override
    public Option get(Object key) {
        return RedBlackTree$.MODULE$.get(this.tree, key, this.ordering());
    }

    @Override
    public TreeMap remove(Object key) {
        return !RedBlackTree$.MODULE$.contains(this.tree, key, this.ordering()) ? this : new TreeMap(RedBlackTree$.MODULE$.delete(this.tree, key, this.ordering()), this.ordering());
    }

    @Override
    public TreeMap updated(Object key, Object value) {
        return new TreeMap(RedBlackTree$.MODULE$.update(this.tree, key, value, true, this.ordering()), this.ordering());
    }

    @Override
    public TreeMap empty() {
        return TreeMap$.MODULE$.empty(this.ordering());
    }

    @Override
    public TreeMap rangeImpl(Option from, Option until) {
        return new TreeMap(RedBlackTree$.MODULE$.rangeImpl(this.tree, from, until, this.ordering()), this.ordering());
    }

    @Override
    public TreeMap range(Object from, Object until) {
        return new TreeMap(RedBlackTree$.MODULE$.range(this.tree, from, until, this.ordering()), this.ordering());
    }

    @Override
    public void foreach(Function1 f) {
        RedBlackTree$.MODULE$.foreach(this.tree, f);
    }

    @Override
    public int size() {
        return RedBlackTree$.MODULE$.count(this.tree);
    }

    @Override
    public Object firstKey() {
        return RedBlackTree$.MODULE$.smallest(this.tree).key();
    }

    @Override
    public Object lastKey() {
        return RedBlackTree$.MODULE$.greatest(this.tree).key();
    }

    public Tuple2 head() {
        RedBlackTree.Tree smallest = RedBlackTree$.MODULE$.smallest(this.tree);
        return Tuple2$.MODULE$.apply(smallest.key(), smallest.value());
    }

    public Tuple2 last() {
        RedBlackTree.Tree greatest = RedBlackTree$.MODULE$.greatest(this.tree);
        return Tuple2$.MODULE$.apply(greatest.key(), greatest.value());
    }

    @Override
    public TreeMap tail() {
        return new TreeMap(RedBlackTree$.MODULE$.delete(this.tree, this.firstKey(), this.ordering()), this.ordering());
    }

    @Override
    public TreeMap init() {
        return new TreeMap(RedBlackTree$.MODULE$.delete(this.tree, this.lastKey(), this.ordering()), this.ordering());
    }

    @Override
    public TreeMap drop(int n) {
        return n <= 0 ? this : (n >= this.size() ? this.empty() : new TreeMap(RedBlackTree$.MODULE$.drop(this.tree, n, this.ordering()), this.ordering()));
    }

    @Override
    public TreeMap take(int n) {
        return n <= 0 ? this.empty() : (n >= this.size() ? this : new TreeMap(RedBlackTree$.MODULE$.take(this.tree, n, this.ordering()), this.ordering()));
    }

    @Override
    public TreeMap slice(int from, int until) {
        return until <= from ? this.empty() : (from <= 0 ? this.take(until) : (until >= this.size() ? this.drop(from) : new TreeMap(RedBlackTree$.MODULE$.slice(this.tree, from, until, this.ordering()), this.ordering())));
    }

    @Override
    public TreeMap dropRight(int n) {
        return this.take(this.size() - package$.MODULE$.max(n, 0));
    }

    @Override
    public TreeMap takeRight(int n) {
        return this.drop(this.size() - package$.MODULE$.max(n, 0));
    }

    /*
     * WARNING - void declaration
     */
    private int countWhile(Function1 p) {
        void var2_2;
        int result = 0;
        Iterator it = this.iterator();
        while (it.hasNext() && BoxesRunTime.unboxToBoolean((Object)p.apply(it.next()))) {
            ++result;
        }
        return (int)var2_2;
    }

    @Override
    public TreeMap dropWhile(Function1 p) {
        return this.drop(this.countWhile(p));
    }

    @Override
    public TreeMap takeWhile(Function1 p) {
        return this.take(this.countWhile(p));
    }

    @Override
    public Tuple2 span(Function1 p) {
        return this.splitAt(this.countWhile(p));
    }
}

