/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.mutable;

import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.Tuple2$;
import scala.math.Ordering;
import strawman.collection.Iterator;
import strawman.collection.mutable.RedBlackTree;
import strawman.collection.mutable.RedBlackTree$Node$;
import strawman.collection.mutable.RedBlackTree$Tree$;

public final class RedBlackTree$ {
    public static final RedBlackTree$ MODULE$;
    public final RedBlackTree$Tree$ Tree;
    public final RedBlackTree$Node$ Node;

    static {
        new RedBlackTree$();
    }

    public RedBlackTree$() {
        MODULE$ = this;
    }

    public boolean isRed(RedBlackTree.Node node) {
        return node != null && node.red();
    }

    public boolean isBlack(RedBlackTree.Node node) {
        return node == null || !node.red();
    }

    public int size(RedBlackTree.Node node) {
        return node == null ? 0 : 1 + this.size(node.left()) + this.size(node.right());
    }

    public int size(RedBlackTree.Tree tree) {
        return tree.size();
    }

    public boolean isEmpty(RedBlackTree.Tree tree) {
        return tree.root() == null;
    }

    public void clear(RedBlackTree.Tree tree) {
        tree.root_$eq(null);
        tree.size_$eq(0);
    }

    public Option get(RedBlackTree.Tree tree, Object key, Ordering evidence$61) {
        None$ none$;
        RedBlackTree.Node node = this.getNode(tree.root(), key, evidence$61);
        if (node == null) {
            none$ = None$.MODULE$;
        } else {
            RedBlackTree.Node node2 = node;
            none$ = Some$.MODULE$.apply(node2.value());
        }
        return none$;
    }

    public Option getKey(RedBlackTree.Tree tree, Object key, Ordering evidence$62) {
        None$ none$;
        RedBlackTree.Node node = this.getNode(tree.root(), key, evidence$62);
        if (node == null) {
            none$ = None$.MODULE$;
        } else {
            RedBlackTree.Node node2 = node;
            none$ = Some$.MODULE$.apply(node2.key());
        }
        return none$;
    }

    /*
     * Enabled aggressive block sorting
     */
    private RedBlackTree.Node getNode(RedBlackTree.Node node, Object key, Ordering ord) {
        Ordering ordering = ord;
        Object object = key;
        RedBlackTree.Node node2 = node;
        RedBlackTree$ redBlackTree$ = this;
        while (true) {
            block3: {
                block4: {
                    block2: {
                        if (node2 == null) {
                            return null;
                        }
                        int cmp = ordering.compare(object, node2.key());
                        if (cmp < 0) break block2;
                        if (cmp > 0) break block3;
                        break block4;
                    }
                    node2 = node2.left();
                    continue;
                }
                RedBlackTree.Node node3 = node2;
                return node3;
            }
            node2 = node2.right();
        }
    }

    public boolean contains(RedBlackTree.Tree tree, Object key, Ordering evidence$63) {
        return this.getNode(tree.root(), key, evidence$63) != null;
    }

    public Option min(RedBlackTree.Tree tree) {
        None$ none$;
        RedBlackTree.Node node = this.strawman$collection$mutable$RedBlackTree$$$minNode(tree.root());
        if (node == null) {
            none$ = None$.MODULE$;
        } else {
            RedBlackTree.Node node2 = node;
            none$ = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(node2.key(), node2.value()));
        }
        return none$;
    }

    public Option minKey(RedBlackTree.Tree tree) {
        None$ none$;
        RedBlackTree.Node node = this.strawman$collection$mutable$RedBlackTree$$$minNode(tree.root());
        if (node == null) {
            none$ = None$.MODULE$;
        } else {
            RedBlackTree.Node node2 = node;
            none$ = Some$.MODULE$.apply(node2.key());
        }
        return none$;
    }

    public RedBlackTree.Node strawman$collection$mutable$RedBlackTree$$$minNode(RedBlackTree.Node node) {
        return node == null ? null : this.minNodeNonNull(node);
    }

    /*
     * Enabled aggressive block sorting
     */
    public RedBlackTree.Node minNodeNonNull(RedBlackTree.Node node) {
        RedBlackTree.Node node2 = node;
        RedBlackTree$ redBlackTree$ = this;
        while (node2.left() != null) {
            node2 = node2.left();
        }
        return node2;
    }

    public Option max(RedBlackTree.Tree tree) {
        None$ none$;
        RedBlackTree.Node node = this.maxNode(tree.root());
        if (node == null) {
            none$ = None$.MODULE$;
        } else {
            RedBlackTree.Node node2 = node;
            none$ = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(node2.key(), node2.value()));
        }
        return none$;
    }

    public Option maxKey(RedBlackTree.Tree tree) {
        None$ none$;
        RedBlackTree.Node node = this.maxNode(tree.root());
        if (node == null) {
            none$ = None$.MODULE$;
        } else {
            RedBlackTree.Node node2 = node;
            none$ = Some$.MODULE$.apply(node2.key());
        }
        return none$;
    }

    private RedBlackTree.Node maxNode(RedBlackTree.Node node) {
        return node == null ? null : this.maxNodeNonNull(node);
    }

    /*
     * Enabled aggressive block sorting
     */
    public RedBlackTree.Node maxNodeNonNull(RedBlackTree.Node node) {
        RedBlackTree.Node node2 = node;
        RedBlackTree$ redBlackTree$ = this;
        while (node2.right() != null) {
            node2 = node2.right();
        }
        return node2;
    }

    public Option minAfter(RedBlackTree.Tree tree, Object key, Ordering ord) {
        None$ none$;
        RedBlackTree.Node node = this.strawman$collection$mutable$RedBlackTree$$$minNodeAfter(tree.root(), key, ord);
        if (node == null) {
            none$ = None$.MODULE$;
        } else {
            RedBlackTree.Node node2 = node;
            none$ = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(node2.key(), node2.value()));
        }
        return none$;
    }

    public Option minKeyAfter(RedBlackTree.Tree tree, Object key, Ordering ord) {
        None$ none$;
        RedBlackTree.Node node = this.strawman$collection$mutable$RedBlackTree$$$minNodeAfter(tree.root(), key, ord);
        if (node == null) {
            none$ = None$.MODULE$;
        } else {
            RedBlackTree.Node node2 = node;
            none$ = Some$.MODULE$.apply(node2.key());
        }
        return none$;
    }

    public RedBlackTree.Node strawman$collection$mutable$RedBlackTree$$$minNodeAfter(RedBlackTree.Node node, Object key, Ordering ord) {
        RedBlackTree.Node node2;
        if (node == null) {
            node2 = null;
        } else {
            RedBlackTree.Node y = null;
            RedBlackTree.Node x = node;
            int cmp = 1;
            while (x != null && cmp != 0) {
                y = x;
                cmp = ord.compare(key, x.key());
                x = cmp < 0 ? x.left() : x.right();
            }
            node2 = cmp <= 0 ? y : this.strawman$collection$mutable$RedBlackTree$$$successor(y);
        }
        return node2;
    }

    public Option maxBefore(RedBlackTree.Tree tree, Object key, Ordering ord) {
        None$ none$;
        RedBlackTree.Node node = this.maxNodeBefore(tree.root(), key, ord);
        if (node == null) {
            none$ = None$.MODULE$;
        } else {
            RedBlackTree.Node node2 = node;
            none$ = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(node2.key(), node2.value()));
        }
        return none$;
    }

    public Option maxKeyBefore(RedBlackTree.Tree tree, Object key, Ordering ord) {
        None$ none$;
        RedBlackTree.Node node = this.maxNodeBefore(tree.root(), key, ord);
        if (node == null) {
            none$ = None$.MODULE$;
        } else {
            RedBlackTree.Node node2 = node;
            none$ = Some$.MODULE$.apply(node2.key());
        }
        return none$;
    }

    private RedBlackTree.Node maxNodeBefore(RedBlackTree.Node node, Object key, Ordering ord) {
        RedBlackTree.Node node2;
        if (node == null) {
            node2 = null;
        } else {
            RedBlackTree.Node y = null;
            RedBlackTree.Node x = node;
            int cmp = 1;
            while (x != null && cmp != 0) {
                y = x;
                cmp = ord.compare(key, x.key());
                x = cmp < 0 ? x.left() : x.right();
            }
            node2 = cmp > 0 ? y : this.predecessor(y);
        }
        return node2;
    }

    public void insert(RedBlackTree.Tree tree, Object key, Object value, Ordering ord) {
        RedBlackTree.Node y = null;
        RedBlackTree.Node x = tree.root();
        int cmp = 1;
        while (x != null && cmp != 0) {
            y = x;
            cmp = ord.compare(key, x.key());
            x = cmp < 0 ? x.left() : x.right();
        }
        if (cmp == 0) {
            y.value_$eq(value);
        } else {
            boolean red = true;
            RedBlackTree.Node parent = y;
            RedBlackTree.Node z = new RedBlackTree.Node(key, value, red, null, null, parent);
            if (y == null) {
                tree.root_$eq(z);
            } else if (cmp < 0) {
                y.left_$eq(z);
            } else {
                y.right_$eq(z);
            }
            this.fixAfterInsert(tree, z);
            tree.size_$eq(tree.size() + 1);
        }
    }

    private void fixAfterInsert(RedBlackTree.Tree tree, RedBlackTree.Node node) {
        RedBlackTree.Node z = node;
        while (this.isRed(z.parent())) {
            if (z.parent() == z.parent().parent().left()) {
                RedBlackTree.Node y = z.parent().parent().right();
                if (this.isRed(y)) {
                    z.parent().red_$eq(false);
                    y.red_$eq(false);
                    z.parent().parent().red_$eq(true);
                    z = z.parent().parent();
                    continue;
                }
                if (z == z.parent().right()) {
                    z = z.parent();
                    this.rotateLeft(tree, z);
                }
                z.parent().red_$eq(false);
                z.parent().parent().red_$eq(true);
                this.rotateRight(tree, z.parent().parent());
                continue;
            }
            RedBlackTree.Node y = z.parent().parent().left();
            if (this.isRed(y)) {
                z.parent().red_$eq(false);
                y.red_$eq(false);
                z.parent().parent().red_$eq(true);
                z = z.parent().parent();
                continue;
            }
            if (z == z.parent().left()) {
                z = z.parent();
                this.rotateRight(tree, z);
            }
            z.parent().red_$eq(false);
            z.parent().parent().red_$eq(true);
            this.rotateLeft(tree, z.parent().parent());
        }
        tree.root().red_$eq(false);
    }

    public void delete(RedBlackTree.Tree tree, Object key, Ordering ord) {
        block7: {
            RedBlackTree.Node z = this.getNode(tree.root(), key, ord);
            if (z == null) break block7;
            RedBlackTree.Node y = z;
            boolean yIsRed = y.red();
            RedBlackTree.Node x = null;
            RedBlackTree.Node xParent = null;
            if (z.left() == null) {
                x = z.right();
                this.transplant(tree, z, z.right());
                xParent = z.parent();
            } else if (z.right() == null) {
                x = z.left();
                this.transplant(tree, z, z.left());
                xParent = z.parent();
            } else {
                y = this.minNodeNonNull(z.right());
                yIsRed = y.red();
                x = y.right();
                if (y.parent() == z) {
                    xParent = y;
                } else {
                    xParent = y.parent();
                    this.transplant(tree, y, y.right());
                    y.right_$eq(z.right());
                    y.right().parent_$eq(y);
                }
                this.transplant(tree, z, y);
                y.left_$eq(z.left());
                y.left().parent_$eq(y);
                y.red_$eq(z.red());
            }
            if (!yIsRed) {
                this.fixAfterDelete(tree, x, xParent);
            }
            tree.size_$eq(tree.size() - 1);
        }
    }

    private void fixAfterDelete(RedBlackTree.Tree tree, RedBlackTree.Node node, RedBlackTree.Node parent) {
        block11: {
            RedBlackTree.Node x = node;
            RedBlackTree.Node xParent = parent;
            while (x != tree.root() && this.isBlack(x)) {
                if (x == xParent.left()) {
                    RedBlackTree.Node w = xParent.right();
                    if (w.red()) {
                        w.red_$eq(false);
                        xParent.red_$eq(true);
                        this.rotateLeft(tree, xParent);
                        w = xParent.right();
                    }
                    if (this.isBlack(w.left()) && this.isBlack(w.right())) {
                        w.red_$eq(true);
                        x = xParent;
                    } else {
                        if (this.isBlack(w.right())) {
                            w.left().red_$eq(false);
                            w.red_$eq(true);
                            this.rotateRight(tree, w);
                            w = xParent.right();
                        }
                        w.red_$eq(xParent.red());
                        xParent.red_$eq(false);
                        w.right().red_$eq(false);
                        this.rotateLeft(tree, xParent);
                        x = tree.root();
                    }
                } else {
                    RedBlackTree.Node w = xParent.left();
                    if (w.red()) {
                        w.red_$eq(false);
                        xParent.red_$eq(true);
                        this.rotateRight(tree, xParent);
                        w = xParent.left();
                    }
                    if (this.isBlack(w.right()) && this.isBlack(w.left())) {
                        w.red_$eq(true);
                        x = xParent;
                    } else {
                        if (this.isBlack(w.left())) {
                            w.right().red_$eq(false);
                            w.red_$eq(true);
                            this.rotateLeft(tree, w);
                            w = xParent.left();
                        }
                        w.red_$eq(xParent.red());
                        xParent.red_$eq(false);
                        w.left().red_$eq(false);
                        this.rotateRight(tree, xParent);
                        x = tree.root();
                    }
                }
                xParent = x.parent();
            }
            if (x == null) break block11;
            x.red_$eq(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public RedBlackTree.Node strawman$collection$mutable$RedBlackTree$$$successor(RedBlackTree.Node node) {
        RedBlackTree.Node node2;
        if (node.right() != null) {
            node2 = this.minNodeNonNull(node.right());
        } else {
            void var3_3;
            RedBlackTree.Node x = node;
            for (RedBlackTree.Node y = x.parent(); y != null && x == y.right(); y = y.parent()) {
                x = y;
            }
            node2 = var3_3;
        }
        return node2;
    }

    /*
     * WARNING - void declaration
     */
    private RedBlackTree.Node predecessor(RedBlackTree.Node node) {
        RedBlackTree.Node node2;
        if (node.left() != null) {
            node2 = this.maxNodeNonNull(node.left());
        } else {
            void var3_3;
            RedBlackTree.Node x = node;
            for (RedBlackTree.Node y = x.parent(); y != null && x == y.left(); y = y.parent()) {
                x = y;
            }
            node2 = var3_3;
        }
        return node2;
    }

    private void rotateLeft(RedBlackTree.Tree tree, RedBlackTree.Node x) {
        block5: {
            if (x == null) break block5;
            RedBlackTree.Node y = x.right();
            x.right_$eq(y.left());
            if (y.left() != null) {
                y.left().parent_$eq(x);
            }
            y.parent_$eq(x.parent());
            if (x.parent() == null) {
                tree.root_$eq(y);
            } else if (x == x.parent().left()) {
                x.parent().left_$eq(y);
            } else {
                x.parent().right_$eq(y);
            }
            y.left_$eq(x);
            x.parent_$eq(y);
        }
    }

    private void rotateRight(RedBlackTree.Tree tree, RedBlackTree.Node x) {
        block5: {
            if (x == null) break block5;
            RedBlackTree.Node y = x.left();
            x.left_$eq(y.right());
            if (y.right() != null) {
                y.right().parent_$eq(x);
            }
            y.parent_$eq(x.parent());
            if (x.parent() == null) {
                tree.root_$eq(y);
            } else if (x == x.parent().right()) {
                x.parent().right_$eq(y);
            } else {
                x.parent().left_$eq(y);
            }
            y.right_$eq(x);
            x.parent_$eq(y);
        }
    }

    private void transplant(RedBlackTree.Tree tree, RedBlackTree.Node to, RedBlackTree.Node from) {
        block4: {
            if (to.parent() == null) {
                tree.root_$eq(from);
            } else if (to == to.parent().left()) {
                to.parent().left_$eq(from);
            } else {
                to.parent().right_$eq(from);
            }
            if (from == null) break block4;
            from.parent_$eq(to.parent());
        }
    }

    public void foreach(RedBlackTree.Tree tree, Function1 f) {
        this.foreachNode(tree.root(), f);
    }

    private void foreachNode(RedBlackTree.Node node, Function1 f) {
        block0: {
            if (node == null) break block0;
            this.foreachNodeNonNull(node, f);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void foreachNodeNonNull(RedBlackTree.Node node, Function1 f) {
        Function1 function1 = f;
        RedBlackTree.Node node2 = node;
        RedBlackTree$ redBlackTree$ = this;
        while (true) {
            if (node2.left() != null) {
                this.foreachNodeNonNull(node2.left(), function1);
            }
            function1.apply((Object)Tuple2$.MODULE$.apply(node2.key(), node2.value()));
            if (node2.right() == null) {
                return;
            }
            node2 = node2.right();
        }
    }

    public void foreachKey(RedBlackTree.Tree tree, Function1 f) {
        this.foreachNodeKey(tree.root(), f);
    }

    private void foreachNodeKey(RedBlackTree.Node node, Function1 f) {
        block0: {
            if (node == null) break block0;
            this.foreachNodeKeyNonNull(node, f);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void foreachNodeKeyNonNull(RedBlackTree.Node node, Function1 f) {
        Function1 function1 = f;
        RedBlackTree.Node node2 = node;
        RedBlackTree$ redBlackTree$ = this;
        while (true) {
            if (node2.left() != null) {
                this.foreachNodeKeyNonNull(node2.left(), function1);
            }
            function1.apply(node2.key());
            if (node2.right() == null) {
                return;
            }
            node2 = node2.right();
        }
    }

    public void transform(RedBlackTree.Tree tree, Function2 f) {
        this.transformNode(tree.root(), f);
    }

    private void transformNode(RedBlackTree.Node node, Function2 f) {
        block0: {
            if (node == null) break block0;
            this.transformNodeNonNull(node, f);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void transformNodeNonNull(RedBlackTree.Node node, Function2 f) {
        Function2 function2 = f;
        RedBlackTree.Node node2 = node;
        RedBlackTree$ redBlackTree$ = this;
        while (true) {
            if (node2.left() != null) {
                this.transformNodeNonNull(node2.left(), function2);
            }
            node2.value_$eq(function2.apply(node2.key(), node2.value()));
            if (node2.right() == null) {
                return;
            }
            node2 = node2.right();
        }
    }

    public Iterator iterator(RedBlackTree.Tree tree, Option start, Option end, Ordering evidence$64) {
        return new RedBlackTree.EntriesIterator(tree, start, end, evidence$64);
    }

    public None$ iterator$default$2() {
        return None$.MODULE$;
    }

    public None$ iterator$default$3() {
        return None$.MODULE$;
    }

    public Iterator keysIterator(RedBlackTree.Tree tree, Option start, Option end, Ordering evidence$65) {
        return new RedBlackTree.KeysIterator(tree, start, end, evidence$65);
    }

    public None$ keysIterator$default$2() {
        return None$.MODULE$;
    }

    public None$ keysIterator$default$3() {
        return None$.MODULE$;
    }

    public Iterator valuesIterator(RedBlackTree.Tree tree, Option start, Option end, Ordering evidence$66) {
        return new RedBlackTree.ValuesIterator(tree, start, end, evidence$66);
    }

    public None$ valuesIterator$default$2() {
        return None$.MODULE$;
    }

    public None$ valuesIterator$default$3() {
        return None$.MODULE$;
    }

    public boolean isValid(RedBlackTree.Tree tree, Ordering evidence$70) {
        return this.isValidBST(tree.root(), evidence$70) && this.hasProperParentRefs(tree) && this.isValidRedBlackTree(tree) && this.size(tree.root()) == tree.size();
    }

    private boolean hasProperParentRefs(RedBlackTree.Tree tree) {
        return tree.root() == null ? true : tree.root().parent() == null && this.hasProperParentRefs$1(tree.root());
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isValidBST(RedBlackTree.Node node, Ordering ord) {
        Ordering ordering = ord;
        RedBlackTree.Node node2 = node;
        RedBlackTree$ redBlackTree$ = this;
        while (node2 != null) {
            if (node2.left() != null) {
                if (ordering.compare(node2.key(), node2.left().key()) <= 0) return false;
            }
            if (node2.right() != null) {
                if (ordering.compare(node2.key(), node2.right().key()) >= 0) return false;
            }
            if (!this.isValidBST(node2.left(), ordering)) {
                return false;
            }
            node2 = node2.right();
        }
        return true;
    }

    private boolean isValidRedBlackTree(RedBlackTree.Tree tree) {
        return this.isBlack(tree.root()) && this.noRedAfterRed$1(tree.root()) && this.blackHeight$1(tree.root()) >= 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean hasProperParentRefs$1(RedBlackTree.Node node) {
        RedBlackTree.Node node2 = node;
        while (node2 != null) {
            if (node2.left() != null) {
                if (node2.left().parent() != node2) return false;
            }
            if (node2.right() != null) {
                if (node2.right().parent() != node2) return false;
            }
            if (!this.hasProperParentRefs$1(node2.left())) {
                return false;
            }
            node2 = node2.right();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean noRedAfterRed$1(RedBlackTree.Node node) {
        RedBlackTree.Node node2 = node;
        while (node2 != null) {
            if (node2.red()) {
                if (this.isRed(node2.left())) return false;
                if (this.isRed(node2.right())) return false;
            }
            if (!this.noRedAfterRed$1(node2.left())) {
                return false;
            }
            node2 = node2.right();
        }
        return true;
    }

    private int blackHeight$1(RedBlackTree.Node node) {
        int n;
        if (node == null) {
            n = 1;
        } else {
            int lh = this.blackHeight$1(node.left());
            int rh = this.blackHeight$1(node.right());
            n = lh == -1 || lh != rh ? -1 : (this.isRed(node) ? lh : lh + 1);
        }
        return n;
    }
}

