/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.mutable;

import java.util.NoSuchElementException;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import strawman.collection.Iterator;
import strawman.collection.mutable.RedBlackTree$;
import strawman.collection.mutable.RedBlackTree$Node$;
import strawman.collection.mutable.RedBlackTree$Tree$;

public final class RedBlackTree {
    public static void insert(Tree tree, Object object, Object object2, Ordering ordering) {
        RedBlackTree$.MODULE$.insert(tree, object, object2, ordering);
    }

    public static None$ iterator$default$3() {
        return RedBlackTree$.MODULE$.iterator$default$3();
    }

    public static Option max(Tree tree) {
        return RedBlackTree$.MODULE$.max(tree);
    }

    public static boolean isRed(Node node) {
        return RedBlackTree$.MODULE$.isRed(node);
    }

    public static boolean isBlack(Node node) {
        return RedBlackTree$.MODULE$.isBlack(node);
    }

    public static boolean isEmpty(Tree tree) {
        return RedBlackTree$.MODULE$.isEmpty(tree);
    }

    public static Option maxKey(Tree tree) {
        return RedBlackTree$.MODULE$.maxKey(tree);
    }

    public static Option maxKeyBefore(Tree tree, Object object, Ordering ordering) {
        return RedBlackTree$.MODULE$.maxKeyBefore(tree, object, ordering);
    }

    public static None$ keysIterator$default$2() {
        return RedBlackTree$.MODULE$.keysIterator$default$2();
    }

    public static void transform(Tree tree, Function2 function2) {
        RedBlackTree$.MODULE$.transform(tree, function2);
    }

    public static Node maxNodeNonNull(Node node) {
        return RedBlackTree$.MODULE$.maxNodeNonNull(node);
    }

    public static Node minNodeNonNull(Node node) {
        return RedBlackTree$.MODULE$.minNodeNonNull(node);
    }

    public static boolean isValid(Tree tree, Ordering ordering) {
        return RedBlackTree$.MODULE$.isValid(tree, ordering);
    }

    public static void foreach(Tree tree, Function1 function1) {
        RedBlackTree$.MODULE$.foreach(tree, function1);
    }

    public static Iterator keysIterator(Tree tree, Option option, Option option2, Ordering ordering) {
        return RedBlackTree$.MODULE$.keysIterator(tree, option, option2, ordering);
    }

    public static Iterator valuesIterator(Tree tree, Option option, Option option2, Ordering ordering) {
        return RedBlackTree$.MODULE$.valuesIterator(tree, option, option2, ordering);
    }

    public static void foreachKey(Tree tree, Function1 function1) {
        RedBlackTree$.MODULE$.foreachKey(tree, function1);
    }

    public static Option maxBefore(Tree tree, Object object, Ordering ordering) {
        return RedBlackTree$.MODULE$.maxBefore(tree, object, ordering);
    }

    public static Option minKey(Tree tree) {
        return RedBlackTree$.MODULE$.minKey(tree);
    }

    public static None$ iterator$default$2() {
        return RedBlackTree$.MODULE$.iterator$default$2();
    }

    public static boolean contains(Tree tree, Object object, Ordering ordering) {
        return RedBlackTree$.MODULE$.contains(tree, object, ordering);
    }

    public static Option minAfter(Tree tree, Object object, Ordering ordering) {
        return RedBlackTree$.MODULE$.minAfter(tree, object, ordering);
    }

    public static Option min(Tree tree) {
        return RedBlackTree$.MODULE$.min(tree);
    }

    public static None$ valuesIterator$default$2() {
        return RedBlackTree$.MODULE$.valuesIterator$default$2();
    }

    public static Option minKeyAfter(Tree tree, Object object, Ordering ordering) {
        return RedBlackTree$.MODULE$.minKeyAfter(tree, object, ordering);
    }

    public static None$ valuesIterator$default$3() {
        return RedBlackTree$.MODULE$.valuesIterator$default$3();
    }

    public static Iterator iterator(Tree tree, Option option, Option option2, Ordering ordering) {
        return RedBlackTree$.MODULE$.iterator(tree, option, option2, ordering);
    }

    public static void clear(Tree tree) {
        RedBlackTree$.MODULE$.clear(tree);
    }

    public static Option get(Tree tree, Object object, Ordering ordering) {
        return RedBlackTree$.MODULE$.get(tree, object, ordering);
    }

    public static int size(Tree tree) {
        return RedBlackTree$.MODULE$.size(tree);
    }

    public static int size(Node node) {
        return RedBlackTree$.MODULE$.size(node);
    }

    public static Option getKey(Tree tree, Object object, Ordering ordering) {
        return RedBlackTree$.MODULE$.getKey(tree, object, ordering);
    }

    public static void delete(Tree tree, Object object, Ordering ordering) {
        RedBlackTree$.MODULE$.delete(tree, object, ordering);
    }

    public static None$ keysIterator$default$3() {
        return RedBlackTree$.MODULE$.keysIterator$default$3();
    }

    private static final class EntriesIterator
    extends TreeIterator {
        public EntriesIterator(Tree tree, Option start, Option end, Ordering evidence$67) {
            super(tree, start, end, evidence$67);
        }

        public Tuple2 nextResult(Node node) {
            return Tuple2$.MODULE$.apply(node.key(), node.value());
        }
    }

    private static final class KeysIterator
    extends TreeIterator {
        public KeysIterator(Tree tree, Option start, Option end, Ordering evidence$68) {
            super(tree, start, end, evidence$68);
        }

        @Override
        public Object nextResult(Node node) {
            return node.key();
        }
    }

    public static final class Node
    implements Serializable {
        private Object key;
        private Object value;
        private boolean red;
        private Node left;
        private Node right;
        private Node parent;

        public static Node apply(Object object, Object object2, boolean bl, Node node, Node node2, Node node3) {
            return RedBlackTree$Node$.MODULE$.apply(object, object2, bl, node, node2, node3);
        }

        public static Some unapply(Node node) {
            return RedBlackTree$Node$.MODULE$.unapply(node);
        }

        public static Node leaf(Object object, Object object2, boolean bl, Node node) {
            return RedBlackTree$Node$.MODULE$.leaf(object, object2, bl, node);
        }

        public Node(Object key, Object value, boolean red, Node left, Node right, Node parent) {
            this.key = key;
            this.value = value;
            this.red = red;
            this.left = left;
            this.right = right;
            this.parent = parent;
        }

        public Object key() {
            return this.key;
        }

        public void key_$eq(Object x$1) {
            this.key = x$1;
        }

        public Object value() {
            return this.value;
        }

        public void value_$eq(Object x$1) {
            this.value = x$1;
        }

        public boolean red() {
            return this.red;
        }

        public void red_$eq(boolean x$1) {
            this.red = x$1;
        }

        public Node left() {
            return this.left;
        }

        public void left_$eq(Node x$1) {
            this.left = x$1;
        }

        public Node right() {
            return this.right;
        }

        public void right_$eq(Node x$1) {
            this.right = x$1;
        }

        public Node parent() {
            return this.parent;
        }

        public void parent_$eq(Node x$1) {
            this.parent = x$1;
        }

        public String toString() {
            return new StringBuilder().append((Object)"Node(").append(this.key()).append((Object)", ").append(this.value()).append((Object)", ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.red())).append((Object)", ").append((Object)this.left()).append((Object)", ").append((Object)this.right()).append((Object)")").toString();
        }
    }

    public static final class Tree
    implements Serializable {
        private Node root;
        private int size;

        public static Tree empty() {
            return RedBlackTree$Tree$.MODULE$.empty();
        }

        public Tree(Node root, int size) {
            this.root = root;
            this.size = size;
        }

        public Node root() {
            return this.root;
        }

        public void root_$eq(Node x$1) {
            this.root = x$1;
        }

        public int size() {
            return this.size;
        }

        public void size_$eq(int x$1) {
            this.size = x$1;
        }
    }

    private static abstract class TreeIterator
    implements Iterator {
        private final Option end;
        private final Ordering ord;
        private Node nextNode;

        public TreeIterator(Tree tree, Option start, Option end, Ordering ord) {
            Node node;
            this.end = end;
            this.ord = ord;
            Option option = start;
            if (None$.MODULE$.equals(option)) {
                node = RedBlackTree$.MODULE$.strawman$collection$mutable$RedBlackTree$$$minNode(tree.root());
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Object from = some.x();
                node = RedBlackTree$.MODULE$.strawman$collection$mutable$RedBlackTree$$$minNodeAfter(tree.root(), from, ord);
            } else {
                throw new MatchError((Object)option);
            }
            this.nextNode = node;
            this.setNullIfAfterEnd();
        }

        public abstract Object nextResult(Node var1);

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public Object next() {
            Node node = this.nextNode;
            if (node == null) {
                throw new NoSuchElementException("next on empty iterator");
            }
            Node node2 = node;
            this.nextNode = RedBlackTree$.MODULE$.strawman$collection$mutable$RedBlackTree$$$successor(node2);
            this.setNullIfAfterEnd();
            return this.nextResult(node2);
        }

        private void setNullIfAfterEnd() {
            block0: {
                if (!this.end.isDefined() || this.nextNode == null || this.ord.compare(this.nextNode.key(), this.end.get()) < 0) break block0;
                this.nextNode = null;
            }
        }
    }

    private static final class ValuesIterator
    extends TreeIterator {
        public ValuesIterator(Tree tree, Option start, Option end, Ordering evidence$69) {
            super(tree, start, end, evidence$69);
        }

        @Override
        public Object nextResult(Node node) {
            return node.value();
        }
    }
}

