/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection;

import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.compat.java8.JFunction1;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import strawman.collection.BitSet;
import strawman.collection.Iterator;
import strawman.collection.Iterator$;
import strawman.collection.SortedSetOps;
import strawman.collection.View$FlatMap$;
import strawman.collection.View$Map$;

public interface BitSetOps
extends SortedSetOps {
    @Override
    default public void $init$() {
    }

    @Override
    default public Ordering ordering() {
        package$.MODULE$.Ordering();
        return Ordering.Int$.MODULE$;
    }

    public int nwords();

    public long word(int var1);

    public BitSet fromBitMaskNoCopy(long[] var1);

    default public boolean contains(int elem) {
        return 0 <= elem && (this.word(elem >> 6) & 1L << elem) != 0L;
    }

    default public Iterator iterator() {
        return this.keysIteratorFrom(0);
    }

    default public Iterator keysIteratorFrom(int start) {
        return new Iterator(start, this){
            private int current;
            private final int end;
            private final BitSetOps $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.current = start$1;
                this.end = this.strawman$collection$BitSetOps$_$$anon$$$outer().nwords() * 64;
            }

            private int current() {
                return this.current;
            }

            private void current_$eq(int x$1) {
                this.current = x$1;
            }

            private int end() {
                return this.end;
            }

            public boolean hasNext() {
                while (this.current() != this.end() && !this.strawman$collection$BitSetOps$_$$anon$$$outer().contains(this.current())) {
                    this.current_$eq(this.current() + 1);
                }
                return this.current() != this.end();
            }

            /*
             * WARNING - void declaration
             */
            public int next() {
                int n;
                if (this.hasNext()) {
                    void var1_1;
                    int r = this.current();
                    this.current_$eq(this.current() + 1);
                    n = var1_1;
                } else {
                    n = BoxesRunTime.unboxToInt((Object)Iterator$.MODULE$.empty().next());
                }
                return n;
            }

            private BitSetOps $outer() {
                return this.$outer;
            }

            public final BitSetOps strawman$collection$BitSetOps$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    default public int size() {
        void var1_1;
        int s = 0;
        int i = this.nwords();
        while (i > 0) {
            s += Long.bitCount(this.word(--i));
        }
        return (int)var1_1;
    }

    @Override
    default public boolean isEmpty() {
        return RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.nwords()).forall((Function1)((JFunction1.mcZI.sp)this::isEmpty$$anonfun$1));
    }

    @Override
    default public void foreach(Function1 f) {
        for (int i = 0; i < this.nwords(); ++i) {
            long w = this.word(i);
            int j = i * 64;
            while (w != 0L) {
                Object object = (w & 1L) == 1L ? f.apply((Object)BoxesRunTime.boxToInteger((int)j)) : BoxedUnit.UNIT;
                w >>>= 1;
                ++j;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    default public long[] toBitMask() {
        void var1_1;
        long[] a = new long[this.nwords()];
        int i = a.length;
        while (i > 0) {
            a[--i] = this.word(i);
        }
        return var1_1;
    }

    @Override
    default public BitSet rangeImpl(Option from, Option until) {
        long[] a;
        block5: {
            a = ((BitSetOps)this.coll()).toBitMask();
            int len = a.length;
            if (from.isDefined()) {
                int pos;
                int f = BoxesRunTime.unboxToInt((Object)from.get());
                for (pos = 0; f >= 64 && pos < len; f -= 64, ++pos) {
                    a[pos] = 0L;
                }
                if (f > 0 && pos < len) {
                    int i$1 = pos;
                    a[i$1] = a[i$1] & ((1L << f) - 1L ^ 0xFFFFFFFFFFFFFFFFL);
                }
            }
            if (!until.isDefined()) break block5;
            int u = BoxesRunTime.unboxToInt((Object)until.get());
            int w = u / 64;
            int b = u % 64;
            for (int clearw = w + 1; clearw < len; ++clearw) {
                a[clearw] = 0L;
            }
            if (w < len) {
                a[w] = a[w] & (1L << b) - 1L;
            }
        }
        return ((BitSetOps)this.coll()).fromBitMaskNoCopy(a);
    }

    default public BitSet xor(BitSet other) {
        int len = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(((BitSetOps)this.coll()).nwords()), other.nwords());
        long[] words = new long[len];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).foreach((Function1)((JFunction1.mcVI.sp)arg_0 -> this.xor$$anonfun$1(other, words, arg_0)));
        return ((BitSetOps)this.coll()).fromBitMaskNoCopy(words);
    }

    default public BitSet $up(BitSet other) {
        return this.xor(other);
    }

    @Override
    default public BitSet map(Function1 f) {
        return (BitSet)this.fromSpecificIterable(View$Map$.MODULE$.apply(this.toIterable(), f));
    }

    @Override
    default public BitSet flatMap(Function1 f) {
        return (BitSet)this.fromSpecificIterable(View$FlatMap$.MODULE$.apply(this.toIterable(), f));
    }

    private boolean isEmpty$$anonfun$1(int i) {
        return this.word(i) == 0L;
    }

    private void xor$$anonfun$1(BitSet other$1, long[] words$1, int idx) {
        words$1[idx] = ((BitSetOps)this.coll()).word(idx) ^ other$1.word(idx);
    }
}

