/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection;

import dotty.runtime.Arrays$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some$;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Seq;
import scala.compat.java8.JFunction1;
import scala.compat.java8.JProcedure1;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.AbstractFunction1;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import strawman.collection.CanBuild;
import strawman.collection.Iterable;
import strawman.collection.IterableFactory;
import strawman.collection.IterableOnce;
import strawman.collection.Iterator;
import strawman.collection.View;
import strawman.collection.View$;
import strawman.collection.View$Concat$;
import strawman.collection.View$Drop$;
import strawman.collection.View$DropWhile$;
import strawman.collection.View$Empty$;
import strawman.collection.View$Filter$;
import strawman.collection.View$FlatMap$;
import strawman.collection.View$Map$;
import strawman.collection.View$Partition$;
import strawman.collection.View$ScanLeft$;
import strawman.collection.View$Single$;
import strawman.collection.View$Take$;
import strawman.collection.View$TakeWhile$;
import strawman.collection.View$Unzip$;
import strawman.collection.View$Zip$;
import strawman.collection.View$ZipWithIndex$;
import strawman.collection.immutable.List;
import strawman.collection.immutable.Map;
import strawman.collection.immutable.Map$;
import strawman.collection.immutable.Nil$;
import strawman.collection.mutable.ArrayBuffer$;
import strawman.collection.mutable.Builder;
import strawman.collection.mutable.StringBuilder;

public interface IterableOps {
    default public void $init$() {
    }

    public Iterable toIterable();

    public Object coll();

    public Object fromSpecificIterable(Iterable var1);

    default public Object fromIterable(Iterable it) {
        return this.iterableFactory().fromIterable(it);
    }

    public IterableFactory iterableFactory();

    public Builder newSpecificBuilder();

    /*
     * WARNING - void declaration
     */
    default public Iterable reversed() {
        void var1_1;
        List xs = Nil$.MODULE$;
        Iterator it = this.toIterable().iterator();
        while (it.hasNext()) {
            Object object = it.next();
            xs = xs.$colon$colon(object);
        }
        return var1_1;
    }

    default public void foreach(Function1 f) {
        this.toIterable().iterator().foreach(f);
    }

    default public boolean forall(Function1 p) {
        return this.toIterable().iterator().forall(p);
    }

    default public boolean exists(Function1 p) {
        return this.toIterable().iterator().exists(p);
    }

    default public int count(Function1 p) {
        return this.toIterable().iterator().count(p);
    }

    default public Option find(Function1 p) {
        return this.toIterable().iterator().find(p);
    }

    default public Object foldLeft(Object z, Function2 op) {
        return this.toIterable().iterator().foldLeft(z, op);
    }

    default public Object foldRight(Object z, Function2 op) {
        return this.toIterable().iterator().foldRight(z, op);
    }

    default public Object reduce(Function2 op) {
        return this.reduceLeft(op);
    }

    default public Option reduceOption(Function2 op) {
        return this.reduceLeftOption(op);
    }

    default public Object reduceLeft(Function2 op) {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("empty.reduceLeft");
        }
        BooleanRef first = BooleanRef.create((boolean)true);
        ObjectRef acc = ObjectRef.create((Object)BoxesRunTime.boxToInteger((int)0));
        this.toIterable().foreach((Function1)((JProcedure1)arg_0 -> IterableOps.reduceLeft$$anonfun$1(op, first, acc, arg_0)));
        return acc.elem;
    }

    default public Object reduceRight(Function2 op) {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("empty.reduceRight");
        }
        return this.reversed().reduceLeft((arg_0, arg_1) -> IterableOps.reduceRight$$anonfun$1(op, arg_0, arg_1));
    }

    default public Option reduceLeftOption(Function2 op) {
        return this.isEmpty() ? None$.MODULE$ : Some$.MODULE$.apply(this.reduceLeft(op));
    }

    default public Option reduceRightOption(Function2 op) {
        return this.isEmpty() ? None$.MODULE$ : Some$.MODULE$.apply(this.reduceRight(op));
    }

    default public boolean isEmpty() {
        return !this.toIterable().iterator().hasNext();
    }

    default public boolean nonEmpty() {
        return this.toIterable().iterator().hasNext();
    }

    default public Object head() {
        return this.toIterable().iterator().next();
    }

    /*
     * WARNING - void declaration
     */
    default public Object last() {
        void var2_2;
        Iterator it = this.toIterable().iterator();
        Object lst = it.next();
        while (it.hasNext()) {
            lst = it.next();
        }
        return var2_2;
    }

    default public Option lastOption() {
        return this.isEmpty() ? None$.MODULE$ : Some$.MODULE$.apply(this.last());
    }

    default public int knownSize() {
        return -1;
    }

    default public int size() {
        return this.knownSize() >= 0 ? this.knownSize() : this.toIterable().iterator().length();
    }

    default public View view() {
        return View$.MODULE$.fromIterator(this::view$$anonfun$1);
    }

    default public Object to(CanBuild f) {
        return f.fromSpecificIterable(this.toIterable());
    }

    default public Object toArray(ClassTag evidence$6) {
        return this.knownSize() >= 0 ? this.copyToArray(Arrays$.MODULE$.newGenericArray(this.knownSize(), evidence$6), 0) : ArrayBuffer$.MODULE$.fromIterable(this.toIterable()).toArray(evidence$6);
    }

    default public Object copyToArray(Object xs, int start) {
        int i = start;
        Iterator it = this.toIterable().iterator();
        while (it.hasNext()) {
            ScalaRunTime$.MODULE$.array_update(xs, i, it.next());
            ++i;
        }
        return xs;
    }

    default public int copyToArray$default$2() {
        return 0;
    }

    default public String className() {
        return this.getClass().getName();
    }

    default public String mkString(String start, String sep, String end) {
        BooleanRef first = BooleanRef.create((boolean)true);
        StringBuilder b = new StringBuilder();
        b.$plus$plus$eq(start);
        this.foreach(arg_0 -> IterableOps.mkString$$anonfun$1(sep, first, b, arg_0));
        b.$plus$plus$eq(end);
        return b.result();
    }

    default public String mkString(String sep) {
        return this.mkString("", sep, "");
    }

    default public String mkString() {
        return this.mkString("");
    }

    default public String toString() {
        return StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.className(), this.mkString(", ")}));
    }

    default public Object sum(Numeric num) {
        return this.foldLeft(num.zero(), (arg_0, arg_1) -> IterableOps.sum$$anonfun$1(num, arg_0, arg_1));
    }

    default public Object product(Numeric num) {
        return this.foldLeft(num.one(), (arg_0, arg_1) -> IterableOps.product$$anonfun$1(num, arg_0, arg_1));
    }

    default public Object min(Ordering ord) {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("empty.min");
        }
        return this.reduceLeft((arg_0, arg_1) -> IterableOps.min$$anonfun$1(ord, arg_0, arg_1));
    }

    default public Object max(Ordering ord) {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("empty.max");
        }
        return this.reduceLeft((arg_0, arg_1) -> IterableOps.max$$anonfun$1(ord, arg_0, arg_1));
    }

    default public Object maxBy(Function1 f, Ordering cmp) {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("empty.maxBy");
        }
        ObjectRef maxF = ObjectRef.create(null);
        ObjectRef maxElem = ObjectRef.create(null);
        BooleanRef first = BooleanRef.create((boolean)true);
        this.toIterable().foreach((Function1)((JProcedure1)arg_0 -> IterableOps.maxBy$$anonfun$1(f, cmp, maxF, maxElem, first, arg_0)));
        return maxElem.elem;
    }

    default public Object minBy(Function1 f, Ordering cmp) {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("empty.minBy");
        }
        ObjectRef minF = ObjectRef.create(null);
        ObjectRef minElem = ObjectRef.create(null);
        BooleanRef first = BooleanRef.create((boolean)true);
        this.toIterable().foreach((Function1)((JProcedure1)arg_0 -> IterableOps.minBy$$anonfun$1(f, cmp, minF, minElem, first, arg_0)));
        return minElem.elem;
    }

    default public Object filter(Function1 pred) {
        return this.fromSpecificIterable(View$Filter$.MODULE$.apply(this.toIterable(), pred, false));
    }

    default public Object filterNot(Function1 pred) {
        return this.fromSpecificIterable(View$Filter$.MODULE$.apply(this.toIterable(), pred, true));
    }

    default public strawman.collection.WithFilter withFilter(Function1 p) {
        return new WithFilter(this, p);
    }

    default public Tuple2 partition(Function1 p) {
        View.Partition pn = View$Partition$.MODULE$.apply(this.toIterable(), p);
        return Tuple2$.MODULE$.apply(this.fromSpecificIterable(pn.first()), this.fromSpecificIterable(pn.second()));
    }

    default public Tuple2 splitAt(int n) {
        return Tuple2$.MODULE$.apply(this.take(n), this.drop(n));
    }

    default public Object take(int n) {
        return this.fromSpecificIterable(View$Take$.MODULE$.apply(this.toIterable(), n));
    }

    default public Object takeRight(int n) {
        Builder b = this.newSpecificBuilder();
        b.sizeHintBounded(n, this.toIterable());
        Iterator lead = this.toIterable().iterator().drop(n);
        Iterator it = this.toIterable().iterator();
        while (lead.hasNext()) {
            lead.next();
            it.next();
        }
        while (it.hasNext()) {
            Object elem = it.next();
            Builder Growable_this = b;
            Growable_this.add(elem);
        }
        return b.result();
    }

    default public Object takeWhile(Function1 p) {
        return this.fromSpecificIterable(View$TakeWhile$.MODULE$.apply(this.toIterable(), p));
    }

    default public Tuple2 span(Function1 p) {
        return Tuple2$.MODULE$.apply(this.takeWhile(p), this.dropWhile(p));
    }

    default public Object drop(int n) {
        return this.fromSpecificIterable(View$Drop$.MODULE$.apply(this.toIterable(), n));
    }

    default public Object dropRight(int n) {
        Builder b = this.newSpecificBuilder();
        if (n >= 0) {
            b.sizeHint(this.toIterable(), -n);
        }
        Iterator lead = this.toIterable().iterator().drop(n);
        Iterator it = this.toIterable().iterator();
        while (lead.hasNext()) {
            Object elem = it.next();
            Builder Growable_this = b;
            Growable_this.add(elem);
            lead.next();
        }
        return b.result();
    }

    default public Object dropWhile(Function1 p) {
        return this.fromSpecificIterable(View$DropWhile$.MODULE$.apply(this.toIterable(), p));
    }

    default public Iterator grouped(int size) {
        return this.toIterable().iterator().grouped(size).map((Function1)((JFunction1)this::grouped$$anonfun$1));
    }

    default public Iterator sliding(int size) {
        return this.sliding(size, 1);
    }

    default public Iterator sliding(int size, int step) {
        return this.toIterable().iterator().sliding(size, step).map((Function1)((JFunction1)this::sliding$$anonfun$1));
    }

    default public Object tail() {
        if (this.toIterable().isEmpty()) {
            throw new UnsupportedOperationException();
        }
        return this.drop(1);
    }

    default public Object init() {
        if (this.toIterable().isEmpty()) {
            throw new UnsupportedOperationException();
        }
        return this.dropRight(1);
    }

    default public Object slice(int from, int until) {
        return this.fromSpecificIterable(View$Drop$.MODULE$.apply(View$Take$.MODULE$.apply(this.toIterable(), until), from));
    }

    default public Map groupBy(Function1 f) {
        strawman.collection.mutable.Map m = (strawman.collection.mutable.Map)strawman.collection.mutable.Map$.MODULE$.empty();
        this.toIterable().foreach(arg_0 -> this.groupBy$$anonfun$1(f, m, arg_0));
        ObjectRef result = ObjectRef.create((Object)Map$.MODULE$.empty());
        m.foreach((Function1)((JProcedure1)arg_0 -> IterableOps.groupBy$$anonfun$2(result, arg_0)));
        return (Map)result.elem;
    }

    default public Object scan(Object z, Function2 op) {
        return this.scanLeft(z, op);
    }

    default public Object scanLeft(Object z, Function2 op) {
        return this.fromIterable(View$ScanLeft$.MODULE$.apply(this.toIterable(), z, op));
    }

    default public Object scanRight(Object z, Function2 op) {
        Object object = z;
        ObjectRef scanned = ObjectRef.create((Object)Nil$.MODULE$.$colon$colon(object));
        ObjectRef acc = ObjectRef.create((Object)z);
        this.reversed().foreach((Function1)((JProcedure1)arg_0 -> IterableOps.scanRight$$anonfun$1(op, scanned, acc, arg_0)));
        return this.fromIterable((List)scanned.elem);
    }

    default public Object map(Function1 f) {
        return this.fromIterable(View$Map$.MODULE$.apply(this.toIterable(), f));
    }

    default public Object flatMap(Function1 f) {
        return this.fromIterable(View$FlatMap$.MODULE$.apply(this.toIterable(), f));
    }

    default public Object flatten(Function1 ev) {
        return this.fromIterable(View$FlatMap$.MODULE$.apply(this.toIterable(), ev));
    }

    default public Object collect(PartialFunction pf) {
        return this.flatMap(arg_0 -> IterableOps.collect$$anonfun$1(pf, arg_0));
    }

    default public Option collectFirst(PartialFunction pf) {
        Iterator i = this.toIterable().iterator();
        AbstractFunction1 sentinel = new AbstractFunction1(){

            public Object apply(Object a) {
                return this;
            }
        };
        while (i.hasNext()) {
            Object x = pf.applyOrElse(i.next(), (Function1)sentinel);
            if (x == sentinel) continue;
            return Some$.MODULE$.apply(x);
        }
        return None$.MODULE$;
    }

    default public Object concat(Iterable suffix) {
        return this.appendAll(suffix);
    }

    default public Object $plus$plus(Iterable suffix) {
        return this.appendAll(suffix);
    }

    default public Object appendAll(Iterable suffix) {
        return this.fromIterable(View$Concat$.MODULE$.apply(this.toIterable(), suffix));
    }

    default public Object $colon$plus$plus(Iterable suffix) {
        return this.appendAll(suffix);
    }

    default public Object prependAll(Iterable prefix) {
        return this.fromIterable(View$Concat$.MODULE$.apply(prefix, this.toIterable()));
    }

    default public Object $plus$plus$colon(Iterable prefix) {
        return this.prependAll(prefix);
    }

    default public Object zip(Iterable xs) {
        return this.fromIterable(View$Zip$.MODULE$.apply(this.toIterable(), xs));
    }

    default public Object zipWithIndex() {
        return this.fromIterable(View$ZipWithIndex$.MODULE$.apply(this.toIterable()));
    }

    default public Tuple2 unzip(Predef$.less.colon.less asPair) {
        View.Unzip unzipped = View$Unzip$.MODULE$.apply(this.toIterable(), asPair);
        return Tuple2$.MODULE$.apply(this.fromIterable(unzipped.first()), this.fromIterable(unzipped.second()));
    }

    private static void reduceLeft$$anonfun$1(Function2 op$1, BooleanRef first$1, ObjectRef acc$1, Object x) {
        if (first$1.elem) {
            boolean bl;
            Object object;
            acc$1.elem = object = x;
            first$1.elem = bl = false;
        } else {
            Object object;
            acc$1.elem = object = op$1.apply(acc$1.elem, x);
        }
    }

    private static Object reduceRight$$anonfun$1(Function2 op$2, Object x, Object y) {
        return op$2.apply(y, x);
    }

    private Iterator view$$anonfun$1() {
        return this.toIterable().iterator();
    }

    private static StringBuilder mkString$$anonfun$1(String sep$1, BooleanRef first$2, StringBuilder b$1, Object elem) {
        boolean bl;
        Object object = !first$2.elem ? b$1.$plus$plus$eq(sep$1) : BoxedUnit.UNIT;
        first$2.elem = bl = false;
        return b$1.$plus$plus$eq(String.valueOf(elem));
    }

    private static Object sum$$anonfun$1(Numeric num$1, Object x, Object y) {
        return num$1.plus(x, y);
    }

    private static Object product$$anonfun$1(Numeric num$2, Object x, Object y) {
        return num$2.times(x, y);
    }

    private static Object min$$anonfun$1(Ordering ord$1, Object x, Object y) {
        return ord$1.lteq(x, y) ? x : y;
    }

    private static Object max$$anonfun$1(Ordering ord$2, Object x, Object y) {
        return ord$2.gteq(x, y) ? x : y;
    }

    private static void maxBy$$anonfun$1(Function1 f$9, Ordering cmp$1, ObjectRef maxF$1, ObjectRef maxElem$1, BooleanRef first$3, Object elem) {
        block0: {
            boolean bl;
            Object object;
            Object object2;
            Object fx = f$9.apply(elem);
            if (!first$3.elem && !cmp$1.gt(fx, maxF$1.elem)) break block0;
            maxElem$1.elem = object2 = elem;
            maxF$1.elem = object = fx;
            first$3.elem = bl = false;
        }
    }

    private static void minBy$$anonfun$1(Function1 f$10, Ordering cmp$2, ObjectRef minF$1, ObjectRef minElem$1, BooleanRef first$4, Object elem) {
        block0: {
            boolean bl;
            Object object;
            Object object2;
            Object fx = f$10.apply(elem);
            if (!first$4.elem && !cmp$2.lt(fx, minF$1.elem)) break block0;
            minElem$1.elem = object2 = elem;
            minF$1.elem = object = fx;
            first$4.elem = bl = false;
        }
    }

    private Object grouped$$anonfun$1(Iterable coll) {
        return this.fromSpecificIterable(coll);
    }

    private Object sliding$$anonfun$1(Iterable coll) {
        return this.fromSpecificIterable(coll);
    }

    private Builder $anonfun$1() {
        return this.newSpecificBuilder();
    }

    private Builder groupBy$$anonfun$1(Function1 f$11, strawman.collection.mutable.Map m$1, Object elem) {
        Builder bldr;
        Object key = f$11.apply(elem);
        Builder Growable_this = bldr = (Builder)m$1.getOrElseUpdate(key, this::$anonfun$1);
        return (Builder)Growable_this.add(elem);
    }

    private static void groupBy$$anonfun$2(ObjectRef result$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object k = tuple2._1();
        Builder v = (Builder)tuple2._2();
        Map map = (Map)((Map)result$1.elem).$plus(Tuple2$.MODULE$.apply(k, v.result()));
        result$1.elem = map;
    }

    private static void scanRight$$anonfun$1(Function2 op$3, ObjectRef scanned$1, ObjectRef acc$2, Object x) {
        Object object;
        acc$2.elem = object = op$3.apply(x, acc$2.elem);
        List list = ((List)scanned$1.elem).$colon$colon(acc$2.elem);
        scanned$1.elem = list;
    }

    private static IterableOnce collect$$anonfun$1(PartialFunction pf$1, Object a) {
        return (IterableOnce)(pf$1.isDefinedAt(a) ? View$Single$.MODULE$.apply(pf$1.apply(a)) : View$Empty$.MODULE$);
    }

    public static class WithFilter
    extends strawman.collection.WithFilter {
        private final Function1 p;
        private final IterableOps $outer;

        public WithFilter(IterableOps $outer, Function1 p) {
            this.p = p;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public View.Filter filtered() {
            return View$Filter$.MODULE$.apply(this.strawman$collection$IterableOps$WithFilter$$$outer().toIterable(), this.p, false);
        }

        @Override
        public Object map(Function1 f) {
            return this.strawman$collection$IterableOps$WithFilter$$$outer().iterableFactory().fromIterable(View$Map$.MODULE$.apply(this.filtered(), f));
        }

        @Override
        public Object flatMap(Function1 f) {
            return this.strawman$collection$IterableOps$WithFilter$$$outer().iterableFactory().fromIterable(View$FlatMap$.MODULE$.apply(this.filtered(), f));
        }

        @Override
        public void foreach(Function1 f) {
            this.filtered().foreach(f);
        }

        @Override
        public WithFilter withFilter(Function1 q) {
            return new WithFilter(this.strawman$collection$IterableOps$WithFilter$$$outer(), (Function1)((JFunction1)arg_0 -> this.withFilter$$anonfun$1(q, arg_0)));
        }

        private IterableOps $outer() {
            return this.$outer;
        }

        public final IterableOps strawman$collection$IterableOps$WithFilter$$$outer() {
            return this.$outer();
        }

        private boolean withFilter$$anonfun$1(Function1 q$1, Object a) {
            return BoxesRunTime.unboxToBoolean((Object)this.p.apply(a)) && BoxesRunTime.unboxToBoolean((Object)q$1.apply(a));
        }
    }
}

