/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.immutable;

import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.Ordering;
import strawman.collection.BitSetOps;
import strawman.collection.BitSetOps$;
import strawman.collection.Iterable;
import strawman.collection.IterableFactory;
import strawman.collection.SortedIterableFactory;
import strawman.collection.SortedSetOps;
import strawman.collection.StrictOptimizedIterableOps;
import strawman.collection.immutable.BitSet$;
import strawman.collection.immutable.Set;
import strawman.collection.immutable.Set$;
import strawman.collection.immutable.SetOps;
import strawman.collection.immutable.SortedSet;
import strawman.collection.immutable.SortedSet$;
import strawman.collection.mutable.Builder;

public abstract class BitSet
implements strawman.collection.SetOps,
SetOps,
SortedSetOps,
SortedSet,
BitSetOps,
strawman.collection.BitSet,
StrictOptimizedIterableOps,
Serializable {
    public static BitSet fromBitMask(long[] lArray) {
        return BitSet$.MODULE$.fromBitMask(lArray);
    }

    public static Builder newBuilder() {
        return BitSet$.MODULE$.newBuilder();
    }

    public static Builder newBuilder(Object object) {
        return BitSet$.MODULE$.newBuilder(object);
    }

    public static Object fill(int n, Function0 function0) {
        return BitSet$.MODULE$.fill(n, function0);
    }

    public BitSet() {
        Function1.class.$init$((Function1)this);
    }

    public Function1 compose(Function1 g) {
        return Function1.class.compose((Function1)this, (Function1)g);
    }

    public Function1 andThen(Function1 g) {
        return Function1.class.andThen((Function1)this, (Function1)g);
    }

    @Override
    public boolean equals(Object that) {
        return strawman.collection.SetOps.super.equals(that);
    }

    @Override
    public int hashCode() {
        return strawman.collection.SetOps.super.hashCode();
    }

    @Override
    public String toString() {
        return strawman.collection.SetOps.super.toString();
    }

    @Override
    public BitSet concat(Iterable that) {
        return (BitSet)SetOps.super.concat(that);
    }

    @Override
    public SortedSetOps.SortedWithFilter withFilter(Function1 p) {
        return SortedSetOps.super.withFilter(p);
    }

    @Override
    public int size() {
        return BitSetOps.super.size();
    }

    @Override
    public boolean isEmpty() {
        return BitSetOps.super.isEmpty();
    }

    @Override
    public void foreach(Function1 f) {
        BitSetOps.super.foreach(f);
    }

    @Override
    public Tuple2 partition(Function1 p) {
        return StrictOptimizedIterableOps.super.partition(p);
    }

    @Override
    public Tuple2 span(Function1 p) {
        return StrictOptimizedIterableOps.super.span(p);
    }

    @Override
    public Tuple2 unzip(Predef$.less.colon.less asPair) {
        return StrictOptimizedIterableOps.super.unzip(asPair);
    }

    @Override
    public BitSet empty() {
        return BitSet$.MODULE$.empty();
    }

    @Override
    public IterableFactory iterableFactory() {
        return Set$.MODULE$;
    }

    @Override
    public SortedIterableFactory sortedIterableFactory() {
        return SortedSet$.MODULE$;
    }

    @Override
    public BitSet fromSpecificIterable(Iterable coll) {
        return BitSet$.MODULE$.fromSpecificIterable(coll);
    }

    @Override
    public SortedSet sortedFromIterable(Iterable it, Ordering evidence$58) {
        return (SortedSet)SortedSet$.MODULE$.sortedFromIterable(it, evidence$58);
    }

    @Override
    public Builder newSpecificBuilder() {
        return BitSet$.MODULE$.newBuilder();
    }

    @Override
    public BitSet fromBitMaskNoCopy(long[] elems) {
        return BitSet$.MODULE$.fromBitMaskNoCopy(elems);
    }

    public BitSet incl(int elem) {
        BitSet bitSet;
        Predef$.MODULE$.require(elem >= 0, BitSet::incl$$anonfun$1);
        if (this.contains(elem)) {
            bitSet = this;
        } else {
            int idx = elem >> 6;
            bitSet = this.updateWord(idx, this.word(idx) | 1L << elem);
        }
        return bitSet;
    }

    public BitSet excl(int elem) {
        BitSet bitSet;
        Predef$.MODULE$.require(elem >= 0, BitSet::excl$$anonfun$1);
        if (this.contains(elem)) {
            int idx = elem >> 6;
            bitSet = this.updateWord(idx, this.word(idx) & (1L << elem ^ 0xFFFFFFFFFFFFFFFFL));
        } else {
            bitSet = this;
        }
        return bitSet;
    }

    public Set unordered() {
        return this;
    }

    public abstract BitSet updateWord(int var1, long var2);

    private static String incl$$anonfun$1() {
        return "bitset element must be >= 0";
    }

    private static String excl$$anonfun$1() {
        return "bitset element must be >= 0";
    }

    public static class BitSet1
    extends BitSet {
        private final long elems;

        public BitSet1(long elems) {
            this.elems = elems;
        }

        public long elems() {
            return this.elems;
        }

        @Override
        public int nwords() {
            return 1;
        }

        @Override
        public long word(int idx) {
            return idx == 0 ? this.elems() : 0L;
        }

        @Override
        public BitSet updateWord(int idx, long w) {
            return idx == 0 ? new BitSet1(w) : (idx == 1 ? BitSet$.MODULE$.strawman$collection$immutable$BitSet$$$createSmall(this.elems(), w) : this.fromBitMaskNoCopy(BitSetOps$.MODULE$.updateArray(Array$.MODULE$.apply(this.elems(), (Seq)Predef$.MODULE$.wrapLongArray(new long[0])), idx, w)));
        }
    }

    public static class BitSet2
    extends BitSet {
        private final long elems0;
        private final long elems1;

        public BitSet2(long elems0, long elems1) {
            this.elems0 = elems0;
            this.elems1 = elems1;
        }

        public long elems0() {
            return this.elems0;
        }

        @Override
        public int nwords() {
            return 2;
        }

        @Override
        public long word(int idx) {
            return idx == 0 ? this.elems0() : (idx == 1 ? this.elems1 : 0L);
        }

        @Override
        public BitSet updateWord(int idx, long w) {
            return idx == 0 ? new BitSet2(w, this.elems1) : (idx == 1 ? BitSet$.MODULE$.strawman$collection$immutable$BitSet$$$createSmall(this.elems0(), w) : this.fromBitMaskNoCopy(BitSetOps$.MODULE$.updateArray(Array$.MODULE$.apply(this.elems0(), (Seq)Predef$.MODULE$.wrapLongArray(new long[]{this.elems1})), idx, w)));
        }
    }

    public static class BitSetN
    extends BitSet {
        private final long[] elems;

        public BitSetN(long[] elems) {
            this.elems = elems;
        }

        public long[] elems() {
            return this.elems;
        }

        @Override
        public int nwords() {
            return this.elems().length;
        }

        @Override
        public long word(int idx) {
            return idx < this.nwords() ? this.elems()[idx] : 0L;
        }

        @Override
        public BitSet updateWord(int idx, long w) {
            return this.fromBitMaskNoCopy(BitSetOps$.MODULE$.updateArray(this.elems(), idx, w));
        }
    }
}

