/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.immutable;

import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Seq;
import scala.compat.java8.JFunction1;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import strawman.collection.ArrayOps;
import strawman.collection.IndexedSeqOps;
import strawman.collection.IndexedView;
import strawman.collection.Iterable;
import strawman.collection.IterableOnce;
import strawman.collection.IterableOps;
import strawman.collection.Iterator;
import strawman.collection.SeqFactory;
import strawman.collection.SeqOps;
import strawman.collection.StrictOptimizedIterableOps;
import strawman.collection.StrictOptimizedSeqOps;
import strawman.collection.immutable.IndexedSeq;
import strawman.collection.immutable.IndexedSeq$;
import strawman.collection.immutable.Map;
import strawman.collection.immutable.Nil$;
import strawman.collection.immutable.NumericRange$;
import strawman.collection.immutable.NumericRangeIterator;
import strawman.collection.mutable.Builder;
import strawman.collection.package$;

public class NumericRange
implements IterableOps,
SeqOps,
IndexedSeqOps,
IndexedSeq,
StrictOptimizedIterableOps,
StrictOptimizedSeqOps,
strawman.collection.immutable.StrictOptimizedSeqOps,
Serializable {
    private final Object start;
    private final Object end;
    private final Object step;
    private final boolean isInclusive;
    private final Integral num;
    private int length$lzy1;
    private boolean lengthbitmap$1;
    private int hashCode$lzy1;
    private boolean hashCodebitmap$1;

    public static NumericRange inclusive(Object object, Object object2, Object object3, Integral integral) {
        return NumericRange$.MODULE$.inclusive(object, object2, object3, integral);
    }

    public static Map defaultOrdering() {
        return NumericRange$.MODULE$.defaultOrdering();
    }

    public NumericRange(Object start, Object end, Object step, boolean isInclusive, Integral num) {
        this.start = start;
        this.end = end;
        this.step = step;
        this.isInclusive = isInclusive;
        this.num = num;
    }

    @Override
    public IndexedView view() {
        return IndexedSeqOps.super.view();
    }

    @Override
    public Iterable reversed() {
        return IndexedSeqOps.super.reversed();
    }

    @Override
    public IndexedSeq takeRight(int n) {
        return (IndexedSeq)IndexedSeqOps.super.takeRight(n);
    }

    @Override
    public IndexedSeq dropRight(int n) {
        return (IndexedSeq)IndexedSeqOps.super.dropRight(n);
    }

    @Override
    public Tuple2 partition(Function1 p) {
        return StrictOptimizedIterableOps.super.partition(p);
    }

    @Override
    public Tuple2 span(Function1 p) {
        return StrictOptimizedIterableOps.super.span(p);
    }

    @Override
    public Tuple2 unzip(Predef$.less.colon.less asPair) {
        return StrictOptimizedIterableOps.super.unzip(asPair);
    }

    @Override
    public IndexedSeq distinct() {
        return (IndexedSeq)StrictOptimizedSeqOps.super.distinct();
    }

    @Override
    public IndexedSeq prepend(Object elem) {
        return (IndexedSeq)strawman.collection.immutable.StrictOptimizedSeqOps.super.prepend(elem);
    }

    @Override
    public IndexedSeq append(Object elem) {
        return (IndexedSeq)strawman.collection.immutable.StrictOptimizedSeqOps.super.append(elem);
    }

    @Override
    public IndexedSeq updated(int index, Object elem) {
        return (IndexedSeq)strawman.collection.immutable.StrictOptimizedSeqOps.super.updated(index, elem);
    }

    @Override
    public IndexedSeq patch(int from, IterableOnce other, int replaced) {
        return (IndexedSeq)strawman.collection.immutable.StrictOptimizedSeqOps.super.patch(from, other, replaced);
    }

    public Object start() {
        return this.start;
    }

    public Object end() {
        return this.end;
    }

    public Object step() {
        return this.step;
    }

    public boolean isInclusive() {
        return this.isInclusive;
    }

    @Override
    public Iterator iterator() {
        return new NumericRangeIterator(this.start(), this.step(), this.last(), this.isEmpty(), (Numeric)this.num);
    }

    @Override
    public SeqFactory iterableFactory() {
        return IndexedSeq$.MODULE$;
    }

    @Override
    public IndexedSeq fromSpecificIterable(Iterable it) {
        return (IndexedSeq)this.fromIterable(it);
    }

    @Override
    public Builder newSpecificBuilder() {
        return IndexedSeq$.MODULE$.newBuilder();
    }

    @Override
    public int length() {
        int n;
        if (this.lengthbitmap$1) {
            n = this.length$lzy1;
        } else {
            this.lengthbitmap$1 = true;
            n = this.length$lzy1 = NumericRange$.MODULE$.count(this.start(), this.end(), this.step(), this.isInclusive(), this.num);
        }
        return n;
    }

    @Override
    public int size() {
        return this.length();
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0;
    }

    @Override
    public Object last() {
        if (this.length() == 0) {
            throw Nil$.MODULE$.head();
        }
        return this.locationAfterN(this.length() - 1);
    }

    @Override
    public Object head() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.head();
        }
        return this.start();
    }

    @Override
    public NumericRange tail() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.tail();
        }
        return new NumericRange(this.num.mkNumericOps(this.start()).$plus(this.step()), this.end(), this.step(), this.isInclusive(), this.num);
    }

    public NumericRange by(Object newStep) {
        return this.copy(this.start(), this.end(), newStep);
    }

    public NumericRange copy(Object start, Object end, Object step) {
        return new NumericRange(start, end, step, this.isInclusive(), this.num);
    }

    @Override
    public Object apply(int idx) {
        if (idx < 0 || idx >= this.length()) {
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)idx)).toString());
        }
        return this.locationAfterN(idx);
    }

    @Override
    public void foreach(Function1 f) {
        Object current = this.start();
        for (int count = 0; count < this.length(); ++count) {
            f.apply(current);
            current = this.num.mkNumericOps(current).$plus(this.step());
        }
    }

    private boolean isWithinBoundaries(Object elem) {
        return !this.isEmpty() && (this.num.mkOrderingOps(this.step()).$greater(this.num.zero()) && this.num.mkOrderingOps(this.start()).$less$eq(elem) && this.num.mkOrderingOps(elem).$less$eq(this.last()) || this.num.mkOrderingOps(this.step()).$less(this.num.zero()) && this.num.mkOrderingOps(this.last()).$less$eq(elem) && this.num.mkOrderingOps(elem).$less$eq(this.start()));
    }

    private Object locationAfterN(int n) {
        return this.num.mkNumericOps(this.start()).$plus(this.num.mkNumericOps(this.step()).$times(this.num.fromInt(n)));
    }

    private NumericRange newEmptyRange(Object value) {
        return NumericRange$.MODULE$.apply(value, value, this.step(), this.num);
    }

    @Override
    public NumericRange take(int n) {
        return n <= 0 || this.length() == 0 ? this.newEmptyRange(this.start()) : (n >= this.length() ? this : new NumericRange(this.start(), this.locationAfterN(n - 1), this.step(), true, this.num));
    }

    @Override
    public NumericRange drop(int n) {
        return n <= 0 || this.length() == 0 ? this : (n >= this.length() ? this.newEmptyRange(this.end()) : this.copy(this.locationAfterN(n), this.end(), this.step()));
    }

    @Override
    public Tuple2 splitAt(int n) {
        return Tuple2$.MODULE$.apply((Object)this.take(n), (Object)this.drop(n));
    }

    @Override
    public NumericRange reverse() {
        return this.isEmpty() ? this : new NumericRange(this.last(), this.start(), this.num.mkNumericOps(this.step()).unary_$minus(), true, this.num);
    }

    @Override
    public Object min(Ordering ord) {
        return ord == this.num || NumericRange$.MODULE$.defaultOrdering().get(this.num).exists((Function1)((JFunction1)arg_0 -> NumericRange.min$$anonfun$2(ord, arg_0))) ? (this.num.signum(this.step()) > 0 ? this.head() : this.last()) : IterableOps.super.min(ord);
    }

    @Override
    public Object max(Ordering ord) {
        return ord == this.num || NumericRange$.MODULE$.defaultOrdering().get(this.num).exists((Function1)((JFunction1)arg_0 -> NumericRange.max$$anonfun$2(ord, arg_0))) ? (this.num.signum(this.step()) > 0 ? this.last() : this.head()) : IterableOps.super.max(ord);
    }

    public NumericRange mapRange(Function1 fm, Integral unum) {
        NumericRange self = this;
        return new NumericRange(fm, unum, self, this){
            private final Function1 fm$2;
            private final NumericRange self$2;
            private NumericRange underlyingRange$lzy1;
            private boolean underlyingRangebitmap$1;
            private final NumericRange $outer;
            {
                this.fm$2 = fm$1;
                this.self$2 = self$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.strawman$collection$immutable$NumericRange$mapRange$$$anon$superArg$3$1(fm$1), $outer.strawman$collection$immutable$NumericRange$mapRange$$$anon$superArg$4$1(fm$1), $outer.strawman$collection$immutable$NumericRange$mapRange$$$anon$superArg$5$1(fm$1), $outer.strawman$collection$immutable$NumericRange$mapRange$$$anon$superArg$6$1(), unum$1);
            }

            private NumericRange underlyingRange() {
                NumericRange numericRange;
                if (this.underlyingRangebitmap$1) {
                    numericRange = this.underlyingRange$lzy1;
                } else {
                    this.underlyingRangebitmap$1 = true;
                    numericRange = this.underlyingRange$lzy1 = this.self$2;
                }
                return numericRange;
            }

            public void foreach(Function1 f) {
                this.underlyingRange().foreach(arg_0 -> this.foreach$$anonfun$1(f, arg_0));
            }

            public boolean isEmpty() {
                return this.underlyingRange().isEmpty();
            }

            public Object apply(int idx) {
                return this.fm$2.apply(this.underlyingRange().apply(idx));
            }

            public boolean containsTyped(Object el) {
                return this.underlyingRange().exists((Function1)((JFunction1)arg_0 -> this.containsTyped$$anonfun$1(el, arg_0)));
            }

            public String toString() {
                String stepped = this.simpleOf$1(this.underlyingRange().step());
                return StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (using ", " of ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{super.toString(), this.underlyingRange(), stepped}));
            }

            private NumericRange $outer() {
                return this.$outer;
            }

            public final NumericRange strawman$collection$immutable$NumericRange$_$$anon$$$outer() {
                return this.$outer();
            }

            private Object foreach$$anonfun$1(Function1 f$31, Object x) {
                return f$31.apply(this.fm$2.apply(x));
            }

            private boolean containsTyped$$anonfun$1(Object el$1, Object x) {
                return BoxesRunTime.equals((Object)this.fm$2.apply(x), (Object)el$1);
            }

            private String simpleOf$1(Object x) {
                return (String)new ArrayOps(package$.MODULE$.arrayToArrayOps(x.getClass().getName().split("\\."))).last();
            }
        };
    }

    public boolean containsTyped(Object x) {
        return this.isWithinBoundaries(x) && BoxesRunTime.equals((Object)this.num.mkNumericOps(this.num.mkNumericOps(x).$minus(this.start())).$percent(this.step()), (Object)this.num.zero());
    }

    @Override
    public boolean contains(Object x) {
        boolean bl;
        try {
            bl = this.containsTyped(x);
        }
        catch (ClassCastException classCastException) {
            bl = false;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object sum(Numeric num) {
        block8: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block7: {
                                        if (!this.isEmpty()) break block7;
                                        v0 = num.zero();
                                        break block8;
                                    }
                                    if (this.size() != 1) break block9;
                                    v0 = this.head();
                                    break block8;
                                }
                                if (num == Numeric.IntIsIntegral$.MODULE$) break block10;
                                if (num == Numeric.ShortIsIntegral$.MODULE$) break block10;
                                if (num == Numeric.ByteIsIntegral$.MODULE$) break block10;
                                if (num != Numeric.CharIsIntegral$.MODULE$) break block11;
                            }
                            exact = (long)this.size() * (num.toLong(this.head()) + (long)num.toInt(this.last())) / 2L;
                            v0 = num.fromInt((int)exact);
                            break block8;
                        }
                        if (num != Numeric.LongIsIntegral$.MODULE$) break block12;
                        a = this.num.mkNumericOps(this.head()).toLong();
                        b = this.num.mkNumericOps(this.last()).toLong();
                        if ((this.size() & 1) == 0) {
                            v1 = (long)(this.size() / 2) * (a + b);
                        } else {
                            ha = a / 2L;
                            hb = b / 2L;
                            v1 = (long)this.size() * (ha + hb + (a - 2L * ha + (b - 2L * hb)) / 2L);
                        }
                        ans = v1;
                        v0 = BoxesRunTime.boxToLong((long)ans);
                        break block8;
                    }
                    if (num == Numeric.FloatAsIfIntegral$.MODULE$) break block13;
                    if (num != Numeric.DoubleAsIfIntegral$.MODULE$) break block14;
                }
                numAsIntegral = (Integral)num;
                a = scala.math.package$.MODULE$.abs(numAsIntegral.mkNumericOps(this.head()).toDouble());
                b = scala.math.package$.MODULE$.abs(numAsIntegral.mkNumericOps(this.last()).toDouble());
                two = num.fromInt(2);
                nre = num.fromInt(this.size());
                v0 = a > 1.0E38 || b > 1.0E38 ? numAsIntegral.mkNumericOps(nre).$times(numAsIntegral.mkNumericOps(numAsIntegral.mkNumericOps(this.head()).$div(two)).$plus(numAsIntegral.mkNumericOps(this.last()).$div(two))) : numAsIntegral.mkNumericOps(numAsIntegral.mkNumericOps(nre).$div(two)).$times(numAsIntegral.mkNumericOps(this.head()).$plus(this.last()));
                break block8;
            }
            if (num == Numeric.BigIntIsIntegral$.MODULE$) ** GOTO lbl-1000
            if (num == Numeric.BigDecimalIsFractional$.MODULE$) lbl-1000:
            // 2 sources

            {
                numAsIntegral = (Integral)num;
                v0 = numAsIntegral.mkNumericOps(numAsIntegral.mkNumericOps(num.fromInt(this.size())).$times(numAsIntegral.mkNumericOps(this.head()).$plus(this.last()))).$div(num.fromInt(2));
            } else if (this.isEmpty()) {
                v0 = num.zero();
            } else {
                acc = num.zero();
                i = this.head();
                for (idx = 0; idx < this.length(); ++idx) {
                    acc = num.plus(acc, i);
                    i = this.num.mkNumericOps(i).$plus(this.step());
                }
                v0 = acc;
            }
        }
        return v0;
    }

    @Override
    public int hashCode() {
        int n;
        if (this.hashCodebitmap$1) {
            n = this.hashCode$lzy1;
        } else {
            this.hashCodebitmap$1 = true;
            n = this.hashCode$lzy1 = SeqOps.super.hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object other) {
        NumericRange numericRange;
        NumericRange x;
        Object object = other;
        return object instanceof NumericRange ? (x = (numericRange = (NumericRange)object)).canEqual(this) && this.length() == x.length() && (this.length() == 0 || BoxesRunTime.equals((Object)this.start(), (Object)x.start()) && BoxesRunTime.equals((Object)this.last(), (Object)x.last())) : SeqOps.super.equals(other);
    }

    @Override
    public String toString() {
        String preposition;
        String empty;
        String string = this.isEmpty() ? "empty " : (empty = "");
        String string2 = this.isInclusive() ? "to" : (preposition = "until");
        String stepped = BoxesRunTime.equals((Object)this.step(), (Object)BoxesRunTime.boxToInteger((int)1)) ? "" : StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" by ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.step()}));
        return StringContext$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "NumericRange ", " ", " ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{empty, this.start(), preposition, this.end(), stepped}));
    }

    private static boolean min$$anonfun$2(Ordering ord$3, Ordering _$51) {
        return ord$3 == _$51;
    }

    private static boolean max$$anonfun$2(Ordering ord$4, Ordering _$52) {
        return ord$4 == _$52;
    }

    public Object strawman$collection$immutable$NumericRange$mapRange$$$anon$superArg$3$1(Function1 fm$3) {
        return fm$3.apply(this.start());
    }

    public Object strawman$collection$immutable$NumericRange$mapRange$$$anon$superArg$4$1(Function1 fm$4) {
        return fm$4.apply(this.end());
    }

    public Object strawman$collection$immutable$NumericRange$mapRange$$$anon$superArg$5$1(Function1 fm$5) {
        return fm$5.apply(this.step());
    }

    public boolean strawman$collection$immutable$NumericRange$mapRange$$$anon$superArg$6$1() {
        return this.isInclusive();
    }
}

