/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.immutable;

import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Seq;
import scala.compat.java8.JFunction1;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import strawman.collection.ArrayOps;
import strawman.collection.ArrayOps$;
import strawman.collection.IterableOps;
import strawman.collection.Iterator;
import strawman.collection.immutable.HashSet;
import strawman.collection.immutable.HashSet$;
import strawman.collection.immutable.Iterable;
import strawman.collection.mutable.ArrayBuffer;
import strawman.collection.mutable.ArrayBuffer$;
import strawman.collection.package$;

public abstract class TrieIterator
implements Iterator {
    private final Iterable[] elems;
    public int strawman$collection$immutable$TrieIterator$$depth;
    public Iterable[][] strawman$collection$immutable$TrieIterator$$arrayStack;
    public int[] strawman$collection$immutable$TrieIterator$$posStack;
    public Iterable[] strawman$collection$immutable$TrieIterator$$arrayD;
    public int strawman$collection$immutable$TrieIterator$$posD;
    public Iterator strawman$collection$immutable$TrieIterator$$subIter;

    public TrieIterator(Iterable[] elems) {
        this.elems = elems;
        this.strawman$collection$immutable$TrieIterator$$depth = this.initDepth();
        this.strawman$collection$immutable$TrieIterator$$arrayStack = this.initArrayStack();
        this.strawman$collection$immutable$TrieIterator$$posStack = this.initPosStack();
        this.strawman$collection$immutable$TrieIterator$$arrayD = this.initArrayD();
        this.strawman$collection$immutable$TrieIterator$$posD = this.initPosD();
        this.strawman$collection$immutable$TrieIterator$$subIter = this.initSubIter();
    }

    public abstract Object getElem(Object var1);

    public int initDepth() {
        return 0;
    }

    public Iterable[][] initArrayStack() {
        return new Iterable[6][];
    }

    public int[] initPosStack() {
        return new int[6];
    }

    public Iterable[] initArrayD() {
        return this.elems;
    }

    public int initPosD() {
        return 0;
    }

    public Iterator initSubIter() {
        return null;
    }

    private Iterable[] getElems(Iterable x) {
        HashSet.HashTrieSet hashTrieSet;
        Iterable iterable = x;
        if (!(iterable instanceof HashSet.HashTrieSet)) {
            throw new MatchError((Object)iterable);
        }
        HashSet.HashTrieSet x2 = hashTrieSet = (HashSet.HashTrieSet)iterable;
        return x2.elems();
    }

    private Iterable[] collisionToArray(Iterable x) {
        HashSet.HashSetCollision1 hashSetCollision1;
        Iterable iterable = x;
        if (!(iterable instanceof HashSet.HashSetCollision1)) {
            throw new MatchError((Object)iterable);
        }
        HashSet.HashSetCollision1 x2 = hashSetCollision1 = (HashSet.HashSetCollision1)iterable;
        return (HashSet[])((IterableOps)x2.ks().map((Function1)((JFunction1)TrieIterator::collisionToArray$$anonfun$1))).toArray(ClassTag$.MODULE$.apply(HashSet.class));
    }

    private boolean isTrie(Object x) {
        Object object = x;
        return false;
    }

    private boolean isContainer(Object x) {
        Object object = x;
        return false;
    }

    public TrieIterator dupIterator() {
        return new DupIterator(this, this.elems);
    }

    private TrieIterator newIterator(Iterable[] xs) {
        return new TrieIterator(xs, this){
            private final TrieIterator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(xs$11);
            }

            public final Object getElem(Object x) {
                return this.strawman$collection$immutable$TrieIterator$_$$anon$$$outer().getElem(x);
            }

            private TrieIterator $outer() {
                return this.$outer;
            }

            public final TrieIterator strawman$collection$immutable$TrieIterator$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    private Tuple2 iteratorWithSize(Iterable[] arr) {
        Object object = package$.MODULE$.arrayToArrayOps(arr);
        return Tuple2$.MODULE$.apply((Object)this.newIterator(arr), new ArrayOps(package$.MODULE$.arrayToArrayOps(ArrayOps$.MODULE$.map$extension(object, (Function1)((JFunction1)TrieIterator::iteratorWithSize$$anonfun$1), ClassTag$.MODULE$.apply(Integer.TYPE)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    private Tuple2 arrayToIterators(Iterable[] arr) {
        Tuple2 tuple2 = new ArrayOps(package$.MODULE$.arrayToArrayOps(arr)).splitAt(arr.length / 2);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable[] fst = (Iterable[])tuple2._1();
        Iterable[] snd = (Iterable[])tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)fst, (Object)snd);
        Iterable[] fst2 = (Iterable[])tuple22._1();
        Iterable[] snd2 = (Iterable[])tuple22._2();
        return Tuple2$.MODULE$.apply((Object)this.iteratorWithSize(snd2), (Object)this.newIterator(fst2));
    }

    /*
     * Enabled aggressive block sorting
     */
    private Tuple2 splitArray(Iterable[] ad) {
        Iterable[] iterableArray = ad;
        TrieIterator trieIterator = this;
        while (true) {
            Tuple2 tuple2;
            if (iterableArray.length > 1) {
                tuple2 = trieIterator.arrayToIterators(iterableArray);
                return tuple2;
            }
            Iterable iterable = iterableArray[0];
            if (iterable instanceof HashSet.HashSetCollision1) {
                HashSet.HashSetCollision1 hashSetCollision1 = (HashSet.HashSetCollision1)iterable;
                tuple2 = trieIterator.arrayToIterators(trieIterator.collisionToArray(iterableArray[0]));
                return tuple2;
            }
            iterableArray = trieIterator.getElems(iterableArray[0]);
        }
    }

    @Override
    public boolean hasNext() {
        return this.strawman$collection$immutable$TrieIterator$$subIter != null || this.strawman$collection$immutable$TrieIterator$$depth >= 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object next() {
        Object object;
        if (this.strawman$collection$immutable$TrieIterator$$subIter != null) {
            void var1_1;
            Object el = this.strawman$collection$immutable$TrieIterator$$subIter.next();
            if (!this.strawman$collection$immutable$TrieIterator$$subIter.hasNext()) {
                this.strawman$collection$immutable$TrieIterator$$subIter = null;
            }
            object = var1_1;
        } else {
            object = this.next0(this.strawman$collection$immutable$TrieIterator$$arrayD, this.strawman$collection$immutable$TrieIterator$$posD);
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object next0(Iterable[] elems, int i) {
        int n = i;
        Iterable[] iterableArray = elems;
        TrieIterator trieIterator = this;
        while (true) {
            Object object;
            if (n != iterableArray.length - 1) {
                ++trieIterator.strawman$collection$immutable$TrieIterator$$posD;
            } else {
                --trieIterator.strawman$collection$immutable$TrieIterator$$depth;
                if (trieIterator.strawman$collection$immutable$TrieIterator$$depth < 0) {
                    trieIterator.strawman$collection$immutable$TrieIterator$$arrayD = null;
                    trieIterator.strawman$collection$immutable$TrieIterator$$posD = 0;
                } else {
                    trieIterator.strawman$collection$immutable$TrieIterator$$arrayD = trieIterator.strawman$collection$immutable$TrieIterator$$arrayStack[trieIterator.strawman$collection$immutable$TrieIterator$$depth];
                    trieIterator.strawman$collection$immutable$TrieIterator$$posD = trieIterator.strawman$collection$immutable$TrieIterator$$posStack[trieIterator.strawman$collection$immutable$TrieIterator$$depth];
                    trieIterator.strawman$collection$immutable$TrieIterator$$arrayStack[trieIterator.strawman$collection$immutable$TrieIterator$$depth] = null;
                }
            }
            Iterable m = iterableArray[n];
            if (trieIterator.isContainer(m)) {
                object = trieIterator.getElem(m);
                return object;
            }
            if (!trieIterator.isTrie(m)) {
                trieIterator.strawman$collection$immutable$TrieIterator$$subIter = m.iterator();
                object = trieIterator.next();
                return object;
            }
            if (trieIterator.strawman$collection$immutable$TrieIterator$$depth >= 0) {
                trieIterator.strawman$collection$immutable$TrieIterator$$arrayStack[trieIterator.strawman$collection$immutable$TrieIterator$$depth] = trieIterator.strawman$collection$immutable$TrieIterator$$arrayD;
                trieIterator.strawman$collection$immutable$TrieIterator$$posStack[trieIterator.strawman$collection$immutable$TrieIterator$$depth] = trieIterator.strawman$collection$immutable$TrieIterator$$posD;
            }
            ++trieIterator.strawman$collection$immutable$TrieIterator$$depth;
            trieIterator.strawman$collection$immutable$TrieIterator$$arrayD = trieIterator.getElems(m);
            trieIterator.strawman$collection$immutable$TrieIterator$$posD = 0;
            n = 0;
            iterableArray = trieIterator.getElems(m);
        }
    }

    public Tuple2 split() {
        Tuple2 tuple2;
        if (this.strawman$collection$immutable$TrieIterator$$arrayD != null && this.strawman$collection$immutable$TrieIterator$$depth == 0 && this.strawman$collection$immutable$TrieIterator$$posD == 0) {
            return this.splitArray(this.strawman$collection$immutable$TrieIterator$$arrayD);
        }
        if (this.strawman$collection$immutable$TrieIterator$$subIter != null) {
            Iterator xs = this.strawman$collection$immutable$TrieIterator$$subIter;
            ArrayBuffer Growable_this = ArrayBuffer$.MODULE$.empty();
            ArrayBuffer buff = Growable_this.addAll(xs);
            this.strawman$collection$immutable$TrieIterator$$subIter = null;
            tuple2 = Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)buff.iterator(), (Object)BoxesRunTime.boxToInteger((int)buff.length())), (Object)this);
        } else if (this.strawman$collection$immutable$TrieIterator$$depth > 0) {
            if (this.strawman$collection$immutable$TrieIterator$$posStack[0] == this.strawman$collection$immutable$TrieIterator$$arrayStack[0].length - 1) {
                Iterable[] snd = (Iterable[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Iterable[]{(Iterable)new ArrayOps(package$.MODULE$.arrayToArrayOps(this.strawman$collection$immutable$TrieIterator$$arrayStack[0])).last()}), ClassTag$.MODULE$.apply(Iterable.class));
                int szsnd = snd[0].size();
                --this.strawman$collection$immutable$TrieIterator$$depth;
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.strawman$collection$immutable$TrieIterator$$arrayStack.length).foreach((Function1)((JFunction1.mcVI.sp)this::split$$anonfun$1));
                Object[] objectArray = new Iterable[1];
                objectArray[0] = null;
                this.strawman$collection$immutable$TrieIterator$$arrayStack[this.strawman$collection$immutable$TrieIterator$$arrayStack.length - 1] = (Iterable[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(objectArray), ClassTag$.MODULE$.apply(Iterable.class));
                Object object = package$.MODULE$.arrayToArrayOps(new ArrayOps(package$.MODULE$.arrayToArrayOps(this.strawman$collection$immutable$TrieIterator$$posStack)).tail());
                this.strawman$collection$immutable$TrieIterator$$posStack = (int[])ArrayOps$.MODULE$.$plus$plus$extension(object, package$.MODULE$.arrayToView(Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}), ClassTag$.MODULE$.apply(Integer.TYPE))), ClassTag$.MODULE$.apply(Integer.TYPE));
                tuple2 = Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)this.newIterator(snd), (Object)BoxesRunTime.boxToInteger((int)szsnd)), (Object)this);
            } else {
                Tuple2 tuple22 = new ArrayOps(package$.MODULE$.arrayToArrayOps(this.strawman$collection$immutable$TrieIterator$$arrayStack[0])).splitAt(this.strawman$collection$immutable$TrieIterator$$arrayStack[0].length - (this.strawman$collection$immutable$TrieIterator$$arrayStack[0].length - this.strawman$collection$immutable$TrieIterator$$posStack[0] + 1) / 2);
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                Iterable[] fst = (Iterable[])tuple22._1();
                Iterable[] snd = (Iterable[])tuple22._2();
                Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)fst, (Object)snd);
                Iterable[] fst2 = (Iterable[])tuple23._1();
                Iterable[] snd2 = (Iterable[])tuple23._2();
                this.strawman$collection$immutable$TrieIterator$$arrayStack[0] = fst2;
                tuple2 = Tuple2$.MODULE$.apply((Object)this.iteratorWithSize(snd2), (Object)this);
            }
        } else if (this.strawman$collection$immutable$TrieIterator$$posD == this.strawman$collection$immutable$TrieIterator$$arrayD.length - 1) {
            Iterable m = this.strawman$collection$immutable$TrieIterator$$arrayD[this.strawman$collection$immutable$TrieIterator$$posD];
            tuple2 = this.arrayToIterators(this.isTrie(m) ? this.getElems(m) : this.collisionToArray(m));
        } else {
            Tuple2 tuple24 = new ArrayOps(package$.MODULE$.arrayToArrayOps(this.strawman$collection$immutable$TrieIterator$$arrayD)).splitAt(this.strawman$collection$immutable$TrieIterator$$arrayD.length - (this.strawman$collection$immutable$TrieIterator$$arrayD.length - this.strawman$collection$immutable$TrieIterator$$posD + 1) / 2);
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            Iterable[] fst = (Iterable[])tuple24._1();
            Iterable[] snd = (Iterable[])tuple24._2();
            Tuple2 tuple25 = Tuple2$.MODULE$.apply((Object)fst, (Object)snd);
            Iterable[] fst3 = (Iterable[])tuple25._1();
            Iterable[] snd3 = (Iterable[])tuple25._2();
            this.strawman$collection$immutable$TrieIterator$$arrayD = fst3;
            tuple2 = Tuple2$.MODULE$.apply((Object)this.iteratorWithSize(snd3), (Object)this);
        }
        return tuple2;
    }

    private static HashSet collisionToArray$$anonfun$1(Nothing$ x) {
        return (HashSet)HashSet$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Nothing$[]{x}));
    }

    private static int iteratorWithSize$$anonfun$1(Iterable _$57) {
        return _$57.size();
    }

    private void split$$anonfun$1(int i) {
        this.strawman$collection$immutable$TrieIterator$$arrayStack[i - 1] = this.strawman$collection$immutable$TrieIterator$$arrayStack[i];
    }

    public static final class DupIterator
    extends TrieIterator {
        private final TrieIterator $outer;

        public DupIterator(TrieIterator $outer, Iterable[] xs) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(xs);
        }

        @Override
        public int initDepth() {
            return this.strawman$collection$immutable$TrieIterator$DupIterator$$$outer().strawman$collection$immutable$TrieIterator$$depth;
        }

        @Override
        public Iterable[][] initArrayStack() {
            return this.strawman$collection$immutable$TrieIterator$DupIterator$$$outer().strawman$collection$immutable$TrieIterator$$arrayStack;
        }

        @Override
        public int[] initPosStack() {
            return this.strawman$collection$immutable$TrieIterator$DupIterator$$$outer().strawman$collection$immutable$TrieIterator$$posStack;
        }

        @Override
        public Iterable[] initArrayD() {
            return this.strawman$collection$immutable$TrieIterator$DupIterator$$$outer().strawman$collection$immutable$TrieIterator$$arrayD;
        }

        @Override
        public int initPosD() {
            return this.strawman$collection$immutable$TrieIterator$DupIterator$$$outer().strawman$collection$immutable$TrieIterator$$posD;
        }

        @Override
        public Iterator initSubIter() {
            return this.strawman$collection$immutable$TrieIterator$DupIterator$$$outer().strawman$collection$immutable$TrieIterator$$subIter;
        }

        @Override
        public final Object getElem(Object x) {
            return this.strawman$collection$immutable$TrieIterator$DupIterator$$$outer().getElem(x);
        }

        private TrieIterator $outer() {
            return this.$outer;
        }

        public final TrieIterator strawman$collection$immutable$TrieIterator$DupIterator$$$outer() {
            return this.$outer();
        }
    }
}

