/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.mutable;

import java.util.Arrays;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some$;
import scala.Tuple2;
import scala.compat.java8.JFunction1;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import strawman.collection.BitSetOps;
import strawman.collection.Iterable;
import strawman.collection.IterableFactory;
import strawman.collection.Set;
import strawman.collection.SetOps;
import strawman.collection.SortedIterableFactory;
import strawman.collection.SortedSetOps;
import strawman.collection.StrictOptimizedIterableOps;
import strawman.collection.immutable.Range$;
import strawman.collection.mutable.BitSet$;
import strawman.collection.mutable.Builder;
import strawman.collection.mutable.Set$;
import strawman.collection.mutable.SortedSet;
import strawman.collection.mutable.SortedSet$;

public class BitSet
implements SetOps,
SortedSetOps,
SortedSet,
BitSetOps,
strawman.collection.BitSet,
StrictOptimizedIterableOps,
Serializable {
    private long[] elems;

    public static Builder newBuilder() {
        return BitSet$.MODULE$.newBuilder();
    }

    public static Builder newBuilder(Object object) {
        return BitSet$.MODULE$.newBuilder(object);
    }

    public static Object fill(int n, Function0 function0) {
        return BitSet$.MODULE$.fill(n, function0);
    }

    public BitSet(long[] elems) {
        this.elems = elems;
        Function1.class.$init$((Function1)this);
    }

    public Function1 compose(Function1 g) {
        return Function1.class.compose((Function1)this, (Function1)g);
    }

    public Function1 andThen(Function1 g) {
        return Function1.class.andThen((Function1)this, (Function1)g);
    }

    @Override
    public boolean equals(Object that) {
        return SetOps.super.equals(that);
    }

    @Override
    public int hashCode() {
        return SetOps.super.hashCode();
    }

    @Override
    public String toString() {
        return SetOps.super.toString();
    }

    @Override
    public SortedSetOps.SortedWithFilter withFilter(Function1 p) {
        return SortedSetOps.super.withFilter(p);
    }

    @Override
    public int size() {
        return BitSetOps.super.size();
    }

    @Override
    public boolean isEmpty() {
        return BitSetOps.super.isEmpty();
    }

    @Override
    public void foreach(Function1 f) {
        BitSetOps.super.foreach(f);
    }

    @Override
    public Tuple2 partition(Function1 p) {
        return StrictOptimizedIterableOps.super.partition(p);
    }

    @Override
    public Tuple2 span(Function1 p) {
        return StrictOptimizedIterableOps.super.span(p);
    }

    @Override
    public Tuple2 unzip(Predef$.less.colon.less asPair) {
        return StrictOptimizedIterableOps.super.unzip(asPair);
    }

    public long[] elems() {
        return this.elems;
    }

    public void elems_$eq(long[] x$1) {
        this.elems = x$1;
    }

    public BitSet(int initSize) {
        this(new long[package$.MODULE$.max(initSize + 63 >> 6, 1)]);
    }

    public BitSet() {
        this(0);
    }

    @Override
    public IterableFactory iterableFactory() {
        return Set$.MODULE$;
    }

    @Override
    public SortedIterableFactory sortedIterableFactory() {
        return SortedSet$.MODULE$;
    }

    @Override
    public SortedSet sortedFromIterable(Iterable it, Ordering evidence$59) {
        return (SortedSet)SortedSet$.MODULE$.sortedFromIterable(it, evidence$59);
    }

    @Override
    public BitSet fromSpecificIterable(Iterable coll) {
        return BitSet$.MODULE$.fromSpecificIterable(coll);
    }

    @Override
    public Builder newSpecificBuilder() {
        return BitSet$.MODULE$.newBuilder();
    }

    @Override
    public final int nwords() {
        return this.elems().length;
    }

    @Override
    public final long word(int idx) {
        return idx < this.nwords() ? this.elems()[idx] : 0L;
    }

    @Override
    public BitSet fromBitMaskNoCopy(long[] elems) {
        return new BitSet(elems);
    }

    public BitSet add(int elem) {
        block0: {
            Predef$.MODULE$.require(elem >= 0);
            if (this.contains(elem)) break block0;
            int idx = elem >> 6;
            this.updateWord(idx, this.word(idx) | 1L << elem);
        }
        return this;
    }

    public BitSet subtract(int elem) {
        block0: {
            Predef$.MODULE$.require(elem >= 0);
            if (!this.contains(elem)) break block0;
            int idx = elem >> 6;
            this.updateWord(idx, this.word(idx) & (1L << elem ^ 0xFFFFFFFFFFFFFFFFL));
        }
        return this;
    }

    @Override
    public void clear() {
        this.elems_$eq(new long[this.elems().length]);
    }

    public final void updateWord(int idx, long w) {
        this.ensureCapacity(idx);
        this.elems()[idx] = w;
    }

    public final void ensureCapacity(int idx) {
        block1: {
            Predef$.MODULE$.require(idx < 0x2000000);
            if (idx < this.nwords()) break block1;
            int newlen = this.nwords();
            while (idx >= newlen) {
                newlen = package$.MODULE$.min(newlen * 2, 0x2000000);
            }
            long[] elems1 = new long[newlen];
            Array$.MODULE$.copy((Object)this.elems(), 0, (Object)elems1, 0, this.nwords());
            this.elems_$eq(elems1);
        }
    }

    public Option get(int elem) {
        return this.contains(elem) ? Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)elem)) : None$.MODULE$;
    }

    public Set unconstrained() {
        return this;
    }

    @Override
    public BitSet empty() {
        return BitSet$.MODULE$.empty();
    }

    public BitSet $bar$eq(BitSet other) {
        this.ensureCapacity(other.nwords() - 1);
        Range$.MODULE$.apply(0, other.nwords()).foreach((Function1)((JFunction1.mcVI.sp)arg_0 -> this.$bar$eq$$anonfun$1(other, arg_0)));
        return this;
    }

    public BitSet $amp$eq(BitSet other) {
        Range$.MODULE$.apply(0, this.nwords()).foreach((Function1)((JFunction1.mcVI.sp)arg_0 -> this.$amp$eq$$anonfun$1(other, arg_0)));
        return this;
    }

    public BitSet $up$eq(BitSet other) {
        this.ensureCapacity(other.nwords() - 1);
        Range$.MODULE$.apply(0, other.nwords()).foreach((Function1)((JFunction1.mcVI.sp)arg_0 -> this.$up$eq$$anonfun$1(other, arg_0)));
        return this;
    }

    public BitSet $amp$tilde$eq(BitSet other) {
        this.ensureCapacity(other.nwords() - 1);
        Range$.MODULE$.apply(0, other.nwords()).foreach((Function1)((JFunction1.mcVI.sp)arg_0 -> this.$amp$tilde$eq$$anonfun$1(other, arg_0)));
        return this;
    }

    @Override
    public BitSet clone() {
        return new BitSet(Arrays.copyOf(this.elems(), this.elems().length));
    }

    private void $bar$eq$$anonfun$1(BitSet other$2, int i) {
        this.elems()[i] = this.elems()[i] | other$2.word(i);
    }

    private void $amp$eq$$anonfun$1(BitSet other$3, int i) {
        this.elems()[i] = this.elems()[i] & other$3.word(i);
    }

    private void $up$eq$$anonfun$1(BitSet other$4, int i) {
        this.elems()[i] = this.elems()[i] ^ other$4.word(i);
    }

    private void $amp$tilde$eq$$anonfun$1(BitSet other$5, int i) {
        this.elems()[i] = this.elems()[i] & (other$5.word(i) ^ 0xFFFFFFFFFFFFFFFFL);
    }
}

