/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.mutable;

import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.math.Ordering;
import strawman.collection.CanBuild;
import strawman.collection.Iterable;
import strawman.collection.IterableFactory;
import strawman.collection.Iterator;
import strawman.collection.Set;
import strawman.collection.SetOps;
import strawman.collection.SortedIterableFactory;
import strawman.collection.SortedSetOps;
import strawman.collection.StrictOptimizedIterableOps;
import strawman.collection.mutable.Builder;
import strawman.collection.mutable.RedBlackTree;
import strawman.collection.mutable.RedBlackTree$;
import strawman.collection.mutable.RedBlackTree$Tree$;
import strawman.collection.mutable.Set$;
import strawman.collection.mutable.SortedSet;
import strawman.collection.mutable.TreeSet$;

public class TreeSet
implements SetOps,
strawman.collection.mutable.SetOps,
SortedSetOps,
SortedSet,
StrictOptimizedIterableOps,
Serializable {
    public final RedBlackTree.Tree strawman$collection$mutable$TreeSet$$tree;
    private final Ordering ordering;

    public static Builder newBuilder(Ordering ordering) {
        return TreeSet$.MODULE$.newBuilder(ordering);
    }

    public static CanBuild canBuildSortedIterable(Ordering ordering) {
        return TreeSet$.MODULE$.canBuildSortedIterable(ordering);
    }

    public static Object fill(int n, Function0 function0, Ordering ordering) {
        return TreeSet$.MODULE$.fill(n, function0, ordering);
    }

    public TreeSet(RedBlackTree.Tree tree, Ordering ordering) {
        this.strawman$collection$mutable$TreeSet$$tree = tree;
        this.ordering = ordering;
        Function1.class.$init$((Function1)this);
        if (ordering == null) {
            throw new NullPointerException("ordering must not be null");
        }
    }

    public Function1 compose(Function1 g) {
        return Function1.class.compose((Function1)this, (Function1)g);
    }

    public Function1 andThen(Function1 g) {
        return Function1.class.andThen((Function1)this, (Function1)g);
    }

    @Override
    public boolean equals(Object that) {
        return SetOps.super.equals(that);
    }

    @Override
    public int hashCode() {
        return SetOps.super.hashCode();
    }

    @Override
    public String toString() {
        return SetOps.super.toString();
    }

    @Override
    public TreeSet clone() {
        return (TreeSet)strawman.collection.mutable.SetOps.super.clone();
    }

    @Override
    public SortedSetOps.SortedWithFilter withFilter(Function1 p) {
        return SortedSetOps.super.withFilter(p);
    }

    @Override
    public Tuple2 partition(Function1 p) {
        return StrictOptimizedIterableOps.super.partition(p);
    }

    @Override
    public Tuple2 span(Function1 p) {
        return StrictOptimizedIterableOps.super.span(p);
    }

    @Override
    public Tuple2 unzip(Predef$.less.colon.less asPair) {
        return StrictOptimizedIterableOps.super.unzip(asPair);
    }

    @Override
    public Ordering ordering() {
        return this.ordering;
    }

    public TreeSet(Ordering ord) {
        this(RedBlackTree$Tree$.MODULE$.empty(), ord);
    }

    @Override
    public Iterator iterator() {
        return RedBlackTree$.MODULE$.keysIterator(this.strawman$collection$mutable$TreeSet$$tree, (Option)RedBlackTree$.MODULE$.keysIterator$default$2(), (Option)RedBlackTree$.MODULE$.keysIterator$default$3(), this.ordering());
    }

    @Override
    public TreeSet sortedFromIterable(Iterable it, Ordering evidence$78) {
        return TreeSet$.MODULE$.sortedFromIterable(it, evidence$78);
    }

    @Override
    public TreeSet fromSpecificIterable(Iterable coll) {
        return TreeSet$.MODULE$.sortedFromIterable(coll, this.ordering());
    }

    @Override
    public Builder newSpecificBuilder() {
        return TreeSet$.MODULE$.newBuilder(this.ordering());
    }

    @Override
    public IterableFactory iterableFactory() {
        return Set$.MODULE$;
    }

    @Override
    public SortedIterableFactory sortedIterableFactory() {
        return TreeSet$.MODULE$;
    }

    @Override
    public Iterator keysIteratorFrom(Object start) {
        return RedBlackTree$.MODULE$.keysIterator(this.strawman$collection$mutable$TreeSet$$tree, (Option)Some$.MODULE$.apply(start), (Option)RedBlackTree$.MODULE$.keysIterator$default$3(), this.ordering());
    }

    @Override
    public TreeSet empty() {
        return TreeSet$.MODULE$.empty(this.ordering());
    }

    @Override
    public TreeSet add(Object elem) {
        RedBlackTree$.MODULE$.insert(this.strawman$collection$mutable$TreeSet$$tree, elem, null, this.ordering());
        return this;
    }

    @Override
    public TreeSet subtract(Object elem) {
        RedBlackTree$.MODULE$.delete(this.strawman$collection$mutable$TreeSet$$tree, elem, this.ordering());
        return this;
    }

    @Override
    public void clear() {
        RedBlackTree$.MODULE$.clear(this.strawman$collection$mutable$TreeSet$$tree);
    }

    @Override
    public boolean contains(Object elem) {
        return RedBlackTree$.MODULE$.contains(this.strawman$collection$mutable$TreeSet$$tree, elem, this.ordering());
    }

    @Override
    public Option get(Object elem) {
        return RedBlackTree$.MODULE$.getKey(this.strawman$collection$mutable$TreeSet$$tree, elem, this.ordering());
    }

    public Set unconstrained() {
        return this;
    }

    @Override
    public TreeSet rangeImpl(Option from, Option until) {
        return new TreeSetView(this, from, until);
    }

    @Override
    public String className() {
        return "TreeSet";
    }

    @Override
    public int size() {
        return RedBlackTree$.MODULE$.size(this.strawman$collection$mutable$TreeSet$$tree);
    }

    @Override
    public boolean isEmpty() {
        return RedBlackTree$.MODULE$.isEmpty(this.strawman$collection$mutable$TreeSet$$tree);
    }

    @Override
    public Object head() {
        return RedBlackTree$.MODULE$.minKey(this.strawman$collection$mutable$TreeSet$$tree).get();
    }

    @Override
    public Object last() {
        return RedBlackTree$.MODULE$.maxKey(this.strawman$collection$mutable$TreeSet$$tree).get();
    }

    @Override
    public void foreach(Function1 f) {
        RedBlackTree$.MODULE$.foreachKey(this.strawman$collection$mutable$TreeSet$$tree, f);
    }

    public RedBlackTree.Tree strawman$collection$mutable$TreeSet$$TreeSetView$superArg$1(Option from, Option until) {
        return this.strawman$collection$mutable$TreeSet$$tree;
    }

    public Ordering strawman$collection$mutable$TreeSet$$TreeSetView$superArg$2(Option from, Option until) {
        return this.ordering();
    }

    private static final class TreeSetView
    extends TreeSet
    implements strawman.collection.mutable.SetOps {
        private final Option from;
        private final Option until;
        private final TreeSet $outer;

        public TreeSetView(TreeSet $outer, Option from, Option until) {
            this.from = from;
            this.until = until;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer.strawman$collection$mutable$TreeSet$$TreeSetView$superArg$1(from, until), $outer.strawman$collection$mutable$TreeSet$$TreeSetView$superArg$2(from, until));
        }

        /*
         * Enabled aggressive block sorting
         */
        private Option pickLowerBound(Option newFrom) {
            Option option;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)this.from, (Object)newFrom);
            if (tuple2 != null) {
                Option option2;
                Option option3 = (Option)tuple2._1();
                if (!(option3 instanceof Some)) {
                    option2 = option3;
                } else {
                    Some some = (Some)option3;
                    Object fr = some.x();
                    Option option4 = (Option)tuple2._2();
                    if (option4 instanceof Some) {
                        Some some2 = (Some)option4;
                        Object newFr = some2.x();
                        option = Some$.MODULE$.apply(this.ordering().max(fr, newFr));
                        return option;
                    }
                    option2 = option3;
                }
                if (None$.MODULE$.equals(option2)) {
                    option = newFrom;
                    return option;
                }
            }
            option = this.from;
            return option;
        }

        /*
         * Enabled aggressive block sorting
         */
        private Option pickUpperBound(Option newUntil) {
            Option option;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)this.until, (Object)newUntil);
            if (tuple2 != null) {
                Option option2;
                Option option3 = (Option)tuple2._1();
                if (!(option3 instanceof Some)) {
                    option2 = option3;
                } else {
                    Some some = (Some)option3;
                    Object unt = some.x();
                    Option option4 = (Option)tuple2._2();
                    if (option4 instanceof Some) {
                        Some some2 = (Some)option4;
                        Object newUnt = some2.x();
                        option = Some$.MODULE$.apply(this.ordering().min(unt, newUnt));
                        return option;
                    }
                    option2 = option3;
                }
                if (None$.MODULE$.equals(option2)) {
                    option = newUntil;
                    return option;
                }
            }
            option = this.until;
            return option;
        }

        private boolean isInsideViewBounds(Object key) {
            boolean beforeUntil;
            boolean afterFrom;
            boolean bl = this.from.isEmpty() || this.ordering().compare(this.from.get(), key) <= 0 ? true : (afterFrom = false);
            boolean bl2 = this.until.isEmpty() || this.ordering().compare(key, this.until.get()) < 0 ? true : (beforeUntil = false);
            return afterFrom && beforeUntil;
        }

        @Override
        public TreeSet rangeImpl(Option from, Option until) {
            return new TreeSetView(this.strawman$collection$mutable$TreeSet$TreeSetView$$$outer(), this.pickLowerBound(from), this.pickUpperBound(until));
        }

        @Override
        public boolean contains(Object key) {
            return this.isInsideViewBounds(key) && RedBlackTree$.MODULE$.contains(this.strawman$collection$mutable$TreeSet$TreeSetView$$$outer().strawman$collection$mutable$TreeSet$$tree, key, this.ordering());
        }

        @Override
        public Iterator iterator() {
            return RedBlackTree$.MODULE$.keysIterator(this.strawman$collection$mutable$TreeSet$TreeSetView$$$outer().strawman$collection$mutable$TreeSet$$tree, this.from, this.until, this.ordering());
        }

        @Override
        public Iterator keysIteratorFrom(Object start) {
            return RedBlackTree$.MODULE$.keysIterator(this.strawman$collection$mutable$TreeSet$TreeSetView$$$outer().strawman$collection$mutable$TreeSet$$tree, this.pickLowerBound((Option)Some$.MODULE$.apply(start)), this.until, this.ordering());
        }

        @Override
        public int size() {
            return this.iterator().length();
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public Object head() {
            return this.headOption().get();
        }

        /*
         * Enabled aggressive block sorting
         */
        public Option headOption() {
            Option option;
            Option option2;
            Option elem = !this.from.isDefined() ? RedBlackTree$.MODULE$.minKey(this.strawman$collection$mutable$TreeSet$TreeSetView$$$outer().strawman$collection$mutable$TreeSet$$tree) : RedBlackTree$.MODULE$.minKeyAfter(this.strawman$collection$mutable$TreeSet$TreeSetView$$$outer().strawman$collection$mutable$TreeSet$$tree, this.from.get(), this.ordering());
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)elem, (Object)this.until);
            if (tuple2 != null && (option2 = (Option)tuple2._1()) instanceof Some) {
                Some some = (Some)option2;
                Object e = some.x();
                Option option3 = (Option)tuple2._2();
                if (option3 instanceof Some) {
                    Some some2 = (Some)option3;
                    Object unt = some2.x();
                    if (this.ordering().compare(e, unt) >= 0) {
                        option = None$.MODULE$;
                        return option;
                    }
                }
            }
            option = elem;
            return option;
        }

        @Override
        public Object last() {
            return this.lastOption().get();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Option lastOption() {
            Option option;
            Option option2;
            Option elem = !this.until.isDefined() ? RedBlackTree$.MODULE$.maxKey(this.strawman$collection$mutable$TreeSet$TreeSetView$$$outer().strawman$collection$mutable$TreeSet$$tree) : RedBlackTree$.MODULE$.maxKeyBefore(this.strawman$collection$mutable$TreeSet$TreeSetView$$$outer().strawman$collection$mutable$TreeSet$$tree, this.until.get(), this.ordering());
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)elem, (Object)this.from);
            if (tuple2 != null && (option2 = (Option)tuple2._1()) instanceof Some) {
                Some some = (Some)option2;
                Object e = some.x();
                Option option3 = (Option)tuple2._2();
                if (option3 instanceof Some) {
                    Some some2 = (Some)option3;
                    Object fr = some2.x();
                    if (this.ordering().compare(e, fr) < 0) {
                        option = None$.MODULE$;
                        return option;
                    }
                }
            }
            option = elem;
            return option;
        }

        @Override
        public void foreach(Function1 f) {
            this.iterator().foreach(f);
        }

        @Override
        public TreeSet clone() {
            return ((TreeSet)strawman.collection.mutable.SetOps.super.clone()).rangeImpl(this.from, this.until);
        }

        private TreeSet $outer() {
            return this.$outer;
        }

        public final TreeSet strawman$collection$mutable$TreeSet$TreeSetView$$$outer() {
            return this.$outer();
        }
    }
}

