/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection;

import java.util.NoSuchElementException;
import scala.Function0;
import scala.Function1;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import strawman.collection.AbstractIterator;
import strawman.collection.IndexedView;
import strawman.collection.Iterable;
import strawman.collection.IterableOps;
import strawman.collection.Iterator;
import strawman.collection.SeqOps;
import strawman.collection.View;
import strawman.collection.immutable.Seq;
import strawman.collection.mutable.Builder;

public final class Iterator$ {
    public static final Iterator$ MODULE$;
    private final Iterator empty;

    static {
        new Iterator$();
    }

    public Iterator$() {
        MODULE$ = this;
        this.empty = new Iterator(){

            public boolean hasNext() {
                return false;
            }

            public Nothing$ next() {
                throw new NoSuchElementException("next on empty iterator");
            }
        };
    }

    public Iterator empty() {
        return this.empty;
    }

    public Iterator single(Object a) {
        return new Iterator(a){
            private final Object a$1;
            private boolean consumed;
            {
                this.a$1 = a$2;
                this.consumed = false;
            }

            private boolean consumed() {
                return this.consumed;
            }

            private void consumed_$eq(boolean x$1) {
                this.consumed = x$1;
            }

            public boolean hasNext() {
                return !this.consumed();
            }

            public Object next() {
                Object object;
                if (this.consumed()) {
                    object = Iterator$.MODULE$.empty().next();
                } else {
                    this.consumed_$eq(true);
                    object = this.a$1;
                }
                return object;
            }
        };
    }

    public Iterator apply(scala.collection.Seq xs) {
        return new IterableOps(xs){
            private final scala.collection.Seq xs$1;
            private final int length;
            {
                this.xs$1 = xs$6;
                this.length = xs$6.length();
            }

            public View view() {
                return View.super.view();
            }

            public String toString() {
                return View.super.toString();
            }

            public String className() {
                return View.super.className();
            }

            public /* synthetic */ View strawman$collection$SeqOps$$super$concat(Iterable suffix) {
                return (View)IterableOps.super.concat(suffix);
            }

            public final View concat(Iterable suffix) {
                return (View)SeqOps.super.concat(suffix);
            }

            public final Seq toSeq() {
                return IndexedView.super.toSeq();
            }

            public IndexedView fromSpecificIterable(Iterable it) {
                return IndexedView.super.fromSpecificIterable(it);
            }

            public Builder newSpecificBuilder() {
                return IndexedView.super.newSpecificBuilder();
            }

            public int knownSize() {
                return IndexedView.super.knownSize();
            }

            public IndexedView take(int n) {
                return IndexedView.super.take(n);
            }

            public IndexedView takeRight(int n) {
                return IndexedView.super.takeRight(n);
            }

            public IndexedView drop(int n) {
                return IndexedView.super.drop(n);
            }

            public IndexedView dropRight(int n) {
                return IndexedView.super.dropRight(n);
            }

            public IndexedView map(Function1 f) {
                return IndexedView.super.map(f);
            }

            public IndexedView reverse() {
                return IndexedView.super.reverse();
            }

            public int length() {
                return this.length;
            }

            public Object apply(int n) {
                return this.xs$1.apply(n);
            }
        }.iterator();
    }

    public Iterator fill(int len, Function0 elem) {
        return new AbstractIterator(len, elem){
            private final int len$1;
            private final Function0 elem$1;
            private int i;
            {
                this.len$1 = len$2;
                this.elem$1 = elem$8;
                this.i = 0;
            }

            private int i() {
                return this.i;
            }

            private void i_$eq(int x$1) {
                this.i = x$1;
            }

            public boolean hasNext() {
                return this.i() < this.len$1;
            }

            public Object next() {
                Object object;
                if (this.hasNext()) {
                    this.i_$eq(this.i() + 1);
                    object = this.elem$1.apply();
                } else {
                    object = Iterator$.MODULE$.empty().next();
                }
                return object;
            }
        };
    }

    public Iterator tabulate(int end, Function1 f) {
        return new AbstractIterator(end, f){
            private final int end$1;
            private final Function1 f$1;
            private int i;
            {
                this.end$1 = end$4;
                this.f$1 = f$31;
                this.i = 0;
            }

            private int i() {
                return this.i;
            }

            private void i_$eq(int x$1) {
                this.i = x$1;
            }

            public boolean hasNext() {
                return this.i() < this.end$1;
            }

            /*
             * WARNING - void declaration
             */
            public Object next() {
                Object object;
                if (this.hasNext()) {
                    void var1_1;
                    Object result = this.f$1.apply((Object)BoxesRunTime.boxToInteger((int)this.i()));
                    this.i_$eq(this.i() + 1);
                    object = var1_1;
                } else {
                    object = Iterator$.MODULE$.empty().next();
                }
                return object;
            }
        };
    }

    public Iterator from(int start) {
        return this.from(start, 1);
    }

    public Iterator from(int start, int step) {
        return new Iterator(start, step){
            private final int step$1;
            private int i;
            {
                this.step$1 = step$2;
                this.i = start$2;
            }

            private int i() {
                return this.i;
            }

            private void i_$eq(int x$1) {
                this.i = x$1;
            }

            public boolean hasNext() {
                return true;
            }

            /*
             * WARNING - void declaration
             */
            public int next() {
                void var1_1;
                int result = this.i();
                this.i_$eq(this.i() + this.step$1);
                return (int)var1_1;
            }
        };
    }

    public Iterator range(int start, int end) {
        return this.range(start, end, 1);
    }

    public Iterator range(int start, int end, int step) {
        return new Iterator(start, end, step){
            private final int end$1;
            private final int step$1;
            private int i;
            {
                this.end$1 = end$2;
                this.step$1 = step$4;
                if (step$4 == 0) {
                    throw new IllegalArgumentException("zero step");
                }
                this.i = start$3;
            }

            private int i() {
                return this.i;
            }

            private void i_$eq(int x$1) {
                this.i = x$1;
            }

            public boolean hasNext() {
                return !(this.step$1 > 0 && this.i() >= this.end$1 || this.step$1 < 0 && this.i() <= this.end$1);
            }

            /*
             * WARNING - void declaration
             */
            public int next() {
                int n;
                if (this.hasNext()) {
                    void var1_1;
                    int result = this.i();
                    this.i_$eq(this.i() + this.step$1);
                    n = var1_1;
                } else {
                    n = BoxesRunTime.unboxToInt((Object)Iterator$.MODULE$.empty().next());
                }
                return n;
            }
        };
    }

    public Iterator iterate(Object start, Function1 f) {
        return new Iterator(start, f){
            private final Function1 f$1;
            private boolean first;
            private Object acc;
            {
                this.f$1 = f$26;
                this.first = true;
                this.acc = start$4;
            }

            public boolean hasNext() {
                return true;
            }

            public Object next() {
                if (this.first) {
                    this.first = false;
                } else {
                    this.acc = this.f$1.apply(this.acc);
                }
                return this.acc;
            }
        };
    }

    public Iterator continually(Function0 elem) {
        return new Iterator(elem){
            private final Function0 elem$1;
            {
                this.elem$1 = elem$9;
            }

            public boolean hasNext() {
                return true;
            }

            public Object next() {
                return this.elem$1.apply();
            }
        };
    }
}

