/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.concurrent;

import scala.Array$;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import strawman.collection.ArrayOps;
import strawman.collection.IterableFactory$;
import strawman.collection.Iterator;
import strawman.collection.Iterator$;
import strawman.collection.Seq;
import strawman.collection.Seq$;
import strawman.collection.concurrent.BasicNode;
import strawman.collection.concurrent.CNode;
import strawman.collection.concurrent.INode;
import strawman.collection.concurrent.KVNode;
import strawman.collection.concurrent.LNode;
import strawman.collection.concurrent.MainNode;
import strawman.collection.concurrent.SNode;
import strawman.collection.concurrent.TNode;
import strawman.collection.concurrent.TrieMap;
import strawman.collection.concurrent.TrieMapIterator$;
import strawman.collection.immutable.List;
import strawman.collection.immutable.List$;
import strawman.collection.package$;

public class TrieMapIterator
implements Iterator {
    private int level;
    private TrieMap ct;
    private final BasicNode[][] stack;
    private final int[] stackpos;
    private int depth;
    private Iterator subiter;
    private KVNode current;

    public static boolean $lessinit$greater$default$3() {
        return TrieMapIterator$.MODULE$.$lessinit$greater$default$3();
    }

    public TrieMapIterator(int level, TrieMap ct, boolean mustInit) {
        block0: {
            this.level = level;
            this.ct = ct;
            this.stack = new BasicNode[7][];
            this.stackpos = new int[7];
            this.depth = -1;
            this.subiter = null;
            this.current = null;
            if (!mustInit) break block0;
            this.initialize();
        }
    }

    public int level() {
        return this.level;
    }

    public void level_$eq(int x$1) {
        this.level = x$1;
    }

    private TrieMap ct() {
        return this.ct;
    }

    private void ct_$eq(TrieMap x$1) {
        this.ct = x$1;
    }

    private BasicNode[][] stack() {
        return this.stack;
    }

    private int[] stackpos() {
        return this.stackpos;
    }

    private int depth() {
        return this.depth;
    }

    private void depth_$eq(int x$1) {
        this.depth = x$1;
    }

    private Iterator subiter() {
        return this.subiter;
    }

    private void subiter_$eq(Iterator x$1) {
        this.subiter = x$1;
    }

    private KVNode current() {
        return this.current;
    }

    private void current_$eq(KVNode x$1) {
        this.current = x$1;
    }

    @Override
    public boolean hasNext() {
        return this.current() != null || this.subiter() != null;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2 next() {
        Tuple2 tuple2;
        if (this.hasNext()) {
            void var1_1;
            Tuple2 r = null;
            if (this.subiter() != null) {
                r = (Tuple2)this.subiter().next();
                this.checkSubiter();
            } else {
                r = this.current().kvPair();
                this.advance();
            }
            tuple2 = var1_1;
        } else {
            tuple2 = (Tuple2)Iterator$.MODULE$.empty().next();
        }
        return tuple2;
    }

    private void readin(INode in) {
        MainNode mainNode = in.gcasRead(this.ct());
        if (mainNode instanceof CNode) {
            CNode cNode;
            CNode cn = cNode = (CNode)mainNode;
            this.depth_$eq(this.depth() + 1);
            this.stack()[this.depth()] = cn.array();
            this.stackpos()[this.depth()] = -1;
            this.advance();
        } else if (mainNode instanceof TNode) {
            TNode tNode;
            TNode tn = tNode = (TNode)mainNode;
            this.current_$eq(tn);
        } else if (mainNode instanceof LNode) {
            LNode lNode;
            LNode ln = lNode = (LNode)mainNode;
            this.subiter_$eq(ln.entries().iterator());
            this.checkSubiter();
        } else if (mainNode == null) {
            this.current_$eq(null);
        } else {
            throw new MatchError((Object)mainNode);
        }
    }

    private void checkSubiter() {
        block0: {
            if (this.subiter().hasNext()) break block0;
            this.subiter_$eq(null);
            this.advance();
        }
    }

    private void initialize() {
        Predef$.MODULE$.assert(this.ct().isReadOnly());
        TrieMap $18$ = this.ct();
        INode r = $18$.RDCSS_READ_ROOT($18$.RDCSS_READ_ROOT$default$1());
        this.readin(r);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void advance() {
        if (this.depth() >= 0) {
            int npos = this.stackpos()[this.depth()] + 1;
            if (npos < this.stack()[this.depth()].length) {
                this.stackpos()[this.depth()] = npos;
                BasicNode basicNode = this.stack()[this.depth()][npos];
                if (basicNode instanceof SNode) {
                    SNode sNode;
                    SNode sn = sNode = (SNode)basicNode;
                    this.current_$eq(sn);
                    return;
                } else {
                    INode iNode;
                    if (!(basicNode instanceof INode)) throw new MatchError((Object)basicNode);
                    INode in = iNode = (INode)basicNode;
                    this.readin(in);
                }
                return;
            } else {
                this.depth_$eq(this.depth() - 1);
                this.advance();
            }
            return;
        } else {
            this.current_$eq(null);
        }
    }

    public TrieMapIterator newIterator(int _lev, TrieMap _ct, boolean _mustInit) {
        return new TrieMapIterator(_lev, _ct, _mustInit);
    }

    public void dupTo(TrieMapIterator it) {
        it.level_$eq(this.level());
        it.ct_$eq(this.ct());
        it.depth_$eq(this.depth());
        it.current_$eq(this.current());
        Array$.MODULE$.copy((Object)this.stack(), 0, (Object)it.stack(), 0, 7);
        Array$.MODULE$.copy((Object)this.stackpos(), 0, (Object)it.stackpos(), 0, 7);
        if (this.subiter() == null) {
            it.subiter_$eq(null);
        } else {
            List lst = (List)this.subiter().to(IterableFactory$.MODULE$.toFactory(List$.MODULE$));
            this.subiter_$eq(lst.iterator());
            it.subiter_$eq(lst.iterator());
        }
    }

    public Seq subdivide() {
        Seq seq;
        if (this.subiter() != null) {
            TrieMapIterator it = this.newIterator(this.level() + 1, this.ct(), false);
            it.depth_$eq(-1);
            it.subiter_$eq(this.subiter());
            it.current_$eq(null);
            this.subiter_$eq(null);
            this.advance();
            this.level_$eq(this.level() + 1);
            seq = (Seq)Seq$.MODULE$.apply((scala.collection.Seq)Predef$.MODULE$.wrapRefArray((Object[])new TrieMapIterator[]{it, this}));
        } else if (this.depth() == -1) {
            this.level_$eq(this.level() + 1);
            seq = (Seq)Seq$.MODULE$.apply((scala.collection.Seq)Predef$.MODULE$.wrapRefArray((Object[])new TrieMapIterator[]{this}));
        } else {
            for (int d = 0; d <= this.depth(); ++d) {
                int rem = this.stack()[d].length - 1 - this.stackpos()[d];
                if (rem <= 0) continue;
                Tuple2 tuple2 = new ArrayOps(package$.MODULE$.arrayToArrayOps(new ArrayOps(package$.MODULE$.arrayToArrayOps(this.stack()[d])).drop(this.stackpos()[d] + 1))).splitAt(rem / 2);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                BasicNode[] arr1 = (BasicNode[])tuple2._1();
                BasicNode[] arr2 = (BasicNode[])tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)arr1, (Object)arr2);
                BasicNode[] arr12 = (BasicNode[])tuple22._1();
                BasicNode[] arr22 = (BasicNode[])tuple22._2();
                this.stack()[d] = arr12;
                this.stackpos()[d] = -1;
                TrieMapIterator it = this.newIterator(this.level() + 1, this.ct(), false);
                it.stack()[0] = arr22;
                it.stackpos()[0] = -1;
                it.depth_$eq(0);
                it.advance();
                this.level_$eq(this.level() + 1);
                return (Seq)Seq$.MODULE$.apply((scala.collection.Seq)Predef$.MODULE$.wrapRefArray((Object[])new TrieMapIterator[]{this, it}));
            }
            this.level_$eq(this.level() + 1);
            seq = (Seq)Seq$.MODULE$.apply((scala.collection.Seq)Predef$.MODULE$.wrapRefArray((Object[])new TrieMapIterator[]{this}));
        }
        return seq;
    }
}

