/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.immutable;

import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.compat.java8.JFunction1;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import strawman.collection.ArrayOps;
import strawman.collection.IndexedSeqOps;
import strawman.collection.IndexedView;
import strawman.collection.Iterable;
import strawman.collection.IterableOnce;
import strawman.collection.IterableOps;
import strawman.collection.Iterator;
import strawman.collection.Iterator$;
import strawman.collection.Seq;
import strawman.collection.SeqFactory;
import strawman.collection.SeqOps;
import strawman.collection.StrictOptimizedIterableOps;
import strawman.collection.StrictOptimizedSeqOps;
import strawman.collection.immutable.IndexedSeq;
import strawman.collection.immutable.IndexedSeq$;
import strawman.collection.immutable.Map;
import strawman.collection.immutable.Nil$;
import strawman.collection.immutable.NumericRange$;
import strawman.collection.mutable.Builder;
import strawman.collection.package$;

public class NumericRange
implements IterableOps,
SeqOps,
Seq,
strawman.collection.immutable.Seq,
IndexedSeqOps,
IndexedSeq,
StrictOptimizedIterableOps,
StrictOptimizedSeqOps,
strawman.collection.immutable.StrictOptimizedSeqOps,
Serializable {
    private final Object start;
    private final Object end;
    private final Object step;
    private final boolean isInclusive;
    public final Integral strawman$collection$immutable$NumericRange$$num;
    private int length$lzy1;
    private boolean lengthbitmap$1;
    private int hashCode$lzy1;
    private boolean hashCodebitmap$1;

    public static Inclusive inclusive(Object object, Object object2, Object object3, Integral integral) {
        return NumericRange$.MODULE$.inclusive(object, object2, object3, integral);
    }

    public static Map defaultOrdering() {
        return NumericRange$.MODULE$.defaultOrdering();
    }

    public NumericRange(Object start, Object end, Object step, boolean isInclusive, Integral num) {
        this.start = start;
        this.end = end;
        this.step = step;
        this.isInclusive = isInclusive;
        this.strawman$collection$immutable$NumericRange$$num = num;
        Function1.$init$((Function1)this);
        PartialFunction.$init$((PartialFunction)this);
    }

    public Function1 compose(Function1 g) {
        return Function1.compose$((Function1)this, (Function1)g);
    }

    public PartialFunction orElse(PartialFunction that) {
        return PartialFunction.orElse$((PartialFunction)this, (PartialFunction)that);
    }

    public PartialFunction andThen(Function1 k) {
        return PartialFunction.andThen$((PartialFunction)this, (Function1)k);
    }

    public Function1 lift() {
        return PartialFunction.lift$((PartialFunction)this);
    }

    public Object applyOrElse(int x, Function1 function1) {
        return PartialFunction.applyOrElse$((PartialFunction)this, (Object)BoxesRunTime.boxToInteger((int)x), (Function1)function1);
    }

    public Function1 runWith(Function1 action) {
        return PartialFunction.runWith$((PartialFunction)this, (Function1)action);
    }

    @Override
    public /* synthetic */ IndexedSeq strawman$collection$SeqOps$$super$concat(Iterable suffix) {
        return (IndexedSeq)IterableOps.super.concat(suffix);
    }

    @Override
    public final IndexedSeq concat(Iterable suffix) {
        return (IndexedSeq)SeqOps.super.concat(suffix);
    }

    @Override
    public final NumericRange toSeq() {
        return (NumericRange)strawman.collection.immutable.Seq.super.toSeq();
    }

    @Override
    public IndexedView view() {
        return IndexedSeqOps.super.view();
    }

    @Override
    public Iterable reversed() {
        return IndexedSeqOps.super.reversed();
    }

    @Override
    public IndexedSeq takeRight(int n) {
        return (IndexedSeq)IndexedSeqOps.super.takeRight(n);
    }

    @Override
    public IndexedSeq dropRight(int n) {
        return (IndexedSeq)IndexedSeqOps.super.dropRight(n);
    }

    @Override
    public int lengthCompare(int len) {
        return IndexedSeqOps.super.lengthCompare(len);
    }

    @Override
    public Tuple2 partition(Function1 p) {
        return StrictOptimizedIterableOps.super.partition(p);
    }

    @Override
    public Tuple2 span(Function1 p) {
        return StrictOptimizedIterableOps.super.span(p);
    }

    @Override
    public Tuple2 unzip(Predef$.less.colon.less asPair) {
        return StrictOptimizedIterableOps.super.unzip(asPair);
    }

    @Override
    public IndexedSeq distinctBy(Function1 f) {
        return (IndexedSeq)StrictOptimizedSeqOps.super.distinctBy(f);
    }

    @Override
    public IndexedSeq prepended(Object elem) {
        return (IndexedSeq)strawman.collection.immutable.StrictOptimizedSeqOps.super.prepended(elem);
    }

    @Override
    public IndexedSeq appended(Object elem) {
        return (IndexedSeq)strawman.collection.immutable.StrictOptimizedSeqOps.super.appended(elem);
    }

    @Override
    public IndexedSeq updated(int index, Object elem) {
        return (IndexedSeq)strawman.collection.immutable.StrictOptimizedSeqOps.super.updated(index, elem);
    }

    @Override
    public IndexedSeq patch(int from, IterableOnce other, int replaced) {
        return (IndexedSeq)strawman.collection.immutable.StrictOptimizedSeqOps.super.patch(from, other, replaced);
    }

    public Object start() {
        return this.start;
    }

    public Object end() {
        return this.end;
    }

    public Object step() {
        return this.step;
    }

    public boolean isInclusive() {
        return this.isInclusive;
    }

    @Override
    public Iterator iterator() {
        return new Iterator(this){
            private boolean _hasNext;
            private Object _next;
            private final Object lastElement;
            private final NumericRange $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this._hasNext = !this.strawman$collection$immutable$NumericRange$_$$anon$$$outer().isEmpty();
                this._next = this.strawman$collection$immutable$NumericRange$_$$anon$$$outer().start();
                this.lastElement = this._hasNext() ? this.strawman$collection$immutable$NumericRange$_$$anon$$$outer().last() : this.strawman$collection$immutable$NumericRange$_$$anon$$$outer().start();
            }

            private boolean _hasNext() {
                return this._hasNext;
            }

            private void _hasNext_$eq(boolean x$1) {
                this._hasNext = x$1;
            }

            private Object _next() {
                return this._next;
            }

            private void _next_$eq(Object x$1) {
                this._next = x$1;
            }

            private Object lastElement() {
                return this.lastElement;
            }

            public boolean hasNext() {
                return this._hasNext();
            }

            /*
             * WARNING - void declaration
             */
            public Object next() {
                void var1_1;
                Object value;
                if (!this._hasNext()) {
                    Iterator$.MODULE$.empty().next();
                }
                this._hasNext_$eq(!BoxesRunTime.equals((Object)(value = this._next()), (Object)this.lastElement()));
                this._next_$eq(this.strawman$collection$immutable$NumericRange$_$$anon$$$outer().strawman$collection$immutable$NumericRange$$num.plus(value, this.strawman$collection$immutable$NumericRange$_$$anon$$$outer().step()));
                return var1_1;
            }

            private NumericRange $outer() {
                return this.$outer;
            }

            public final NumericRange strawman$collection$immutable$NumericRange$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    @Override
    public SeqFactory iterableFactory() {
        return IndexedSeq$.MODULE$;
    }

    @Override
    public IndexedSeq fromSpecificIterable(Iterable it) {
        return (IndexedSeq)this.fromIterable(it);
    }

    @Override
    public Builder newSpecificBuilder() {
        return IndexedSeq$.MODULE$.newBuilder();
    }

    @Override
    public int length() {
        int n;
        if (this.lengthbitmap$1) {
            n = this.length$lzy1;
        } else {
            this.lengthbitmap$1 = true;
            n = this.length$lzy1 = NumericRange$.MODULE$.count(this.start(), this.end(), this.step(), this.isInclusive(), this.strawman$collection$immutable$NumericRange$$num);
        }
        return n;
    }

    @Override
    public int size() {
        return this.length();
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0;
    }

    @Override
    public Object last() {
        if (this.length() == 0) {
            throw Nil$.MODULE$.head();
        }
        return this.locationAfterN(this.length() - 1);
    }

    @Override
    public NumericRange init() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.init();
        }
        return new NumericRange(this.start(), this.strawman$collection$immutable$NumericRange$$num.mkNumericOps(this.end()).$minus(this.step()), this.step(), this.isInclusive(), this.strawman$collection$immutable$NumericRange$$num);
    }

    @Override
    public Object head() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.head();
        }
        return this.start();
    }

    @Override
    public NumericRange tail() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.tail();
        }
        return this.isInclusive() ? new Inclusive(this.strawman$collection$immutable$NumericRange$$num.mkNumericOps(this.start()).$plus(this.step()), this.end(), this.step(), this.strawman$collection$immutable$NumericRange$$num) : new Exclusive(this.strawman$collection$immutable$NumericRange$$num.mkNumericOps(this.start()).$plus(this.step()), this.end(), this.step(), this.strawman$collection$immutable$NumericRange$$num);
    }

    public NumericRange by(Object newStep) {
        return this.copy(this.start(), this.end(), newStep);
    }

    public NumericRange copy(Object start, Object end, Object step) {
        return new NumericRange(start, end, step, this.isInclusive(), this.strawman$collection$immutable$NumericRange$$num);
    }

    @Override
    public Object apply(int idx) {
        if (idx < 0 || idx >= this.length()) {
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)idx)).toString());
        }
        return this.locationAfterN(idx);
    }

    @Override
    public void foreach(Function1 f) {
        Object current = this.start();
        for (int count = 0; count < this.length(); ++count) {
            f.apply(current);
            current = this.strawman$collection$immutable$NumericRange$$num.mkNumericOps(current).$plus(this.step());
        }
    }

    private boolean isWithinBoundaries(Object elem) {
        return !this.isEmpty() && (this.strawman$collection$immutable$NumericRange$$num.mkOrderingOps(this.step()).$greater(this.strawman$collection$immutable$NumericRange$$num.zero()) && this.strawman$collection$immutable$NumericRange$$num.mkOrderingOps(this.start()).$less$eq(elem) && this.strawman$collection$immutable$NumericRange$$num.mkOrderingOps(elem).$less$eq(this.last()) || this.strawman$collection$immutable$NumericRange$$num.mkOrderingOps(this.step()).$less(this.strawman$collection$immutable$NumericRange$$num.zero()) && this.strawman$collection$immutable$NumericRange$$num.mkOrderingOps(this.last()).$less$eq(elem) && this.strawman$collection$immutable$NumericRange$$num.mkOrderingOps(elem).$less$eq(this.start()));
    }

    private Object locationAfterN(int n) {
        return this.strawman$collection$immutable$NumericRange$$num.mkNumericOps(this.start()).$plus(this.strawman$collection$immutable$NumericRange$$num.mkNumericOps(this.step()).$times(this.strawman$collection$immutable$NumericRange$$num.fromInt(n)));
    }

    private Exclusive newEmptyRange(Object value) {
        return NumericRange$.MODULE$.apply(value, value, this.step(), this.strawman$collection$immutable$NumericRange$$num);
    }

    @Override
    public NumericRange take(int n) {
        return n <= 0 || this.length() == 0 ? this.newEmptyRange(this.start()) : (n >= this.length() ? this : new Inclusive(this.start(), this.locationAfterN(n - 1), this.step(), this.strawman$collection$immutable$NumericRange$$num));
    }

    @Override
    public NumericRange drop(int n) {
        return n <= 0 || this.length() == 0 ? this : (n >= this.length() ? this.newEmptyRange(this.end()) : this.copy(this.locationAfterN(n), this.end(), this.step()));
    }

    @Override
    public Tuple2 splitAt(int n) {
        return Tuple2$.MODULE$.apply((Object)this.take(n), (Object)this.drop(n));
    }

    @Override
    public NumericRange reverse() {
        return this.isEmpty() ? this : new Inclusive(this.last(), this.start(), this.strawman$collection$immutable$NumericRange$$num.mkNumericOps(this.step()).unary_$minus(), this.strawman$collection$immutable$NumericRange$$num);
    }

    @Override
    public Object min(Ordering ord) {
        return ord == this.strawman$collection$immutable$NumericRange$$num || NumericRange$.MODULE$.defaultOrdering().get(this.strawman$collection$immutable$NumericRange$$num).exists((Function1)((JFunction1)arg_0 -> NumericRange.min$$anonfun$1(ord, arg_0))) ? (this.strawman$collection$immutable$NumericRange$$num.signum(this.step()) > 0 ? this.head() : this.last()) : IterableOps.super.min(ord);
    }

    @Override
    public Object max(Ordering ord) {
        return ord == this.strawman$collection$immutable$NumericRange$$num || NumericRange$.MODULE$.defaultOrdering().get(this.strawman$collection$immutable$NumericRange$$num).exists((Function1)((JFunction1)arg_0 -> NumericRange.max$$anonfun$1(ord, arg_0))) ? (this.strawman$collection$immutable$NumericRange$$num.signum(this.step()) > 0 ? this.last() : this.head()) : IterableOps.super.max(ord);
    }

    public NumericRange mapRange(Function1 fm, Integral unum) {
        NumericRange self = this;
        return new NumericRange(fm, unum, self, this){
            private final Function1 fm$1;
            private final NumericRange self$1;
            private NumericRange underlyingRange$lzy1;
            private boolean underlyingRangebitmap$1;
            private final NumericRange $outer;
            {
                this.fm$1 = fm$1;
                this.self$1 = self$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.strawman$collection$immutable$NumericRange$mapRange$$$anon$superArg$3$1(fm$1), $outer.strawman$collection$immutable$NumericRange$mapRange$$$anon$superArg$4$1(fm$1), $outer.strawman$collection$immutable$NumericRange$mapRange$$$anon$superArg$5$1(fm$1), $outer.strawman$collection$immutable$NumericRange$mapRange$$$anon$superArg$6$1(), unum$1);
            }

            private NumericRange underlyingRange() {
                NumericRange numericRange;
                if (this.underlyingRangebitmap$1) {
                    numericRange = this.underlyingRange$lzy1;
                } else {
                    this.underlyingRangebitmap$1 = true;
                    numericRange = this.underlyingRange$lzy1 = this.self$1;
                }
                return numericRange;
            }

            public void foreach(Function1 f) {
                this.underlyingRange().foreach(arg_0 -> this.foreach$$anonfun$1(f, arg_0));
            }

            public boolean isEmpty() {
                return this.underlyingRange().isEmpty();
            }

            public Object apply(int idx) {
                return this.fm$1.apply(this.underlyingRange().apply(idx));
            }

            public boolean containsTyped(Object el) {
                return this.underlyingRange().exists((Function1)((JFunction1)arg_0 -> this.containsTyped$$anonfun$1(el, arg_0)));
            }

            public String toString() {
                String stepped = this.simpleOf$1(this.underlyingRange().step());
                return StringContext$.MODULE$.apply((scala.collection.Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (using ", " of ", ")"})).s((scala.collection.Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{super.toString(), this.underlyingRange(), stepped}));
            }

            private NumericRange $outer() {
                return this.$outer;
            }

            public final NumericRange strawman$collection$immutable$NumericRange$_$$anon$$$outer() {
                return this.$outer();
            }

            private Object foreach$$anonfun$1(Function1 f$60, Object x) {
                return f$60.apply(this.fm$1.apply(x));
            }

            private boolean containsTyped$$anonfun$1(Object el$1, Object x) {
                return BoxesRunTime.equals((Object)this.fm$1.apply(x), (Object)el$1);
            }

            private String simpleOf$1(Object x) {
                return (String)new ArrayOps(package$.MODULE$.arrayToArrayOps(x.getClass().getName().split("\\."))).last();
            }
        };
    }

    public boolean containsTyped(Object x) {
        return this.isWithinBoundaries(x) && BoxesRunTime.equals((Object)this.strawman$collection$immutable$NumericRange$$num.mkNumericOps(this.strawman$collection$immutable$NumericRange$$num.mkNumericOps(x).$minus(this.start())).$percent(this.step()), (Object)this.strawman$collection$immutable$NumericRange$$num.zero());
    }

    @Override
    public boolean contains(Object x) {
        boolean bl;
        try {
            bl = this.containsTyped(x);
        }
        catch (ClassCastException classCastException) {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object sum(Numeric num) {
        Object object;
        block23: {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                if (this.isEmpty()) {
                                    object = num.zero();
                                    return object;
                                }
                                if (this.size() == 1) {
                                    object = this.head();
                                    return object;
                                }
                                if (num == Numeric.IntIsIntegral$.MODULE$) break block18;
                                if (num == Numeric.ShortIsIntegral$.MODULE$) break block18;
                                if (num == Numeric.ByteIsIntegral$.MODULE$) break block18;
                                if (num != Numeric.CharIsIntegral$.MODULE$) break block19;
                            }
                            long exact = (long)this.size() * (num.toLong(this.head()) + (long)num.toInt(this.last())) / 2L;
                            object = num.fromInt((int)exact);
                            return object;
                        }
                        if (num == Numeric.LongIsIntegral$.MODULE$) {
                            long l;
                            long a = this.strawman$collection$immutable$NumericRange$$num.mkNumericOps(this.head()).toLong();
                            long b = this.strawman$collection$immutable$NumericRange$$num.mkNumericOps(this.last()).toLong();
                            if ((this.size() & 1) == 0) {
                                l = (long)(this.size() / 2) * (a + b);
                            } else {
                                long ha = a / 2L;
                                long hb = b / 2L;
                                l = (long)this.size() * (ha + hb + (a - 2L * ha + (b - 2L * hb)) / 2L);
                            }
                            long ans = l;
                            object = BoxesRunTime.boxToLong((long)ans);
                            return object;
                        }
                        if (num == Numeric.FloatAsIfIntegral$.MODULE$) break block20;
                        if (num != Numeric.DoubleAsIfIntegral$.MODULE$) break block21;
                    }
                    Integral numAsIntegral = (Integral)num;
                    double a = scala.math.package$.MODULE$.abs(numAsIntegral.mkNumericOps(this.head()).toDouble());
                    double b = scala.math.package$.MODULE$.abs(numAsIntegral.mkNumericOps(this.last()).toDouble());
                    Object two = num.fromInt(2);
                    Object nre = num.fromInt(this.size());
                    if (!(a > 1.0E38) && b <= 1.0E38) {
                        object = numAsIntegral.mkNumericOps(numAsIntegral.mkNumericOps(nre).$div(two)).$times(numAsIntegral.mkNumericOps(this.head()).$plus(this.last()));
                        return object;
                    }
                    object = numAsIntegral.mkNumericOps(nre).$times(numAsIntegral.mkNumericOps(numAsIntegral.mkNumericOps(this.head()).$div(two)).$plus(numAsIntegral.mkNumericOps(this.last()).$div(two)));
                    return object;
                }
                if (num == Numeric.BigIntIsIntegral$.MODULE$) break block22;
                if (num != Numeric.BigDecimalIsFractional$.MODULE$) break block23;
            }
            Integral numAsIntegral = (Integral)num;
            object = numAsIntegral.mkNumericOps(numAsIntegral.mkNumericOps(num.fromInt(this.size())).$times(numAsIntegral.mkNumericOps(this.head()).$plus(this.last()))).$div(num.fromInt(2));
            return object;
        }
        if (this.isEmpty()) {
            object = num.zero();
            return object;
        }
        Object acc = num.zero();
        Object i = this.head();
        int idx = 0;
        while (true) {
            if (idx >= this.length()) {
                object = acc;
                return object;
            }
            acc = num.plus(acc, i);
            i = this.strawman$collection$immutable$NumericRange$$num.mkNumericOps(i).$plus(this.step());
            ++idx;
        }
    }

    @Override
    public int hashCode() {
        int n;
        if (this.hashCodebitmap$1) {
            n = this.hashCode$lzy1;
        } else {
            this.hashCodebitmap$1 = true;
            n = this.hashCode$lzy1 = Seq.super.hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object other) {
        NumericRange numericRange;
        NumericRange x;
        Object object = other;
        return object instanceof NumericRange ? (x = (numericRange = (NumericRange)object)).canEqual(this) && this.length() == x.length() && (this.length() == 0 || BoxesRunTime.equals((Object)this.start(), (Object)x.start()) && BoxesRunTime.equals((Object)this.last(), (Object)x.last())) : Seq.super.equals(other);
    }

    @Override
    public String toString() {
        String empty = this.isEmpty() ? "empty " : "";
        String preposition = this.isInclusive() ? "to" : "until";
        String stepped = BoxesRunTime.equals((Object)this.step(), (Object)BoxesRunTime.boxToInteger((int)1)) ? "" : StringContext$.MODULE$.apply((scala.collection.Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" by ", ""})).s((scala.collection.Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.step()}));
        return StringContext$.MODULE$.apply((scala.collection.Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "NumericRange ", " ", " ", "", ""})).s((scala.collection.Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{empty, this.start(), preposition, this.end(), stepped}));
    }

    private static boolean min$$anonfun$1(Ordering ord$3, Ordering _$78) {
        return ord$3 == _$78;
    }

    private static boolean max$$anonfun$1(Ordering ord$4, Ordering _$79) {
        return ord$4 == _$79;
    }

    public Object strawman$collection$immutable$NumericRange$mapRange$$$anon$superArg$3$1(Function1 fm$3) {
        return fm$3.apply(this.start());
    }

    public Object strawman$collection$immutable$NumericRange$mapRange$$$anon$superArg$4$1(Function1 fm$4) {
        return fm$4.apply(this.end());
    }

    public Object strawman$collection$immutable$NumericRange$mapRange$$$anon$superArg$5$1(Function1 fm$5) {
        return fm$5.apply(this.step());
    }

    public boolean strawman$collection$immutable$NumericRange$mapRange$$$anon$superArg$6$1() {
        return this.isInclusive();
    }

    public static class Exclusive
    extends NumericRange {
        private final Object start;
        private final Object end;
        private final Object step;
        private final Integral num;

        public Exclusive(Object start, Object end, Object step, Integral num) {
            this.start = start;
            this.end = end;
            this.step = step;
            this.num = num;
            super(start, end, step, false, num);
        }

        @Override
        public Exclusive copy(Object start, Object end, Object step) {
            return NumericRange$.MODULE$.apply(start, end, step, this.num);
        }

        public Inclusive inclusive() {
            return NumericRange$.MODULE$.inclusive(this.start, this.end, this.step, this.num);
        }
    }

    public static class Inclusive
    extends NumericRange {
        private final Object start;
        private final Object end;
        private final Object step;
        private final Integral num;

        public Inclusive(Object start, Object end, Object step, Integral num) {
            this.start = start;
            this.end = end;
            this.step = step;
            this.num = num;
            super(start, end, step, true, num);
        }

        @Override
        public Inclusive copy(Object start, Object end, Object step) {
            return NumericRange$.MODULE$.inclusive(start, end, step, this.num);
        }

        public Exclusive exclusive() {
            return NumericRange$.MODULE$.apply(this.start, this.end, this.step, this.num);
        }
    }
}

