/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.immutable;

import java.util.Arrays;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import strawman.collection.ArrayOps;
import strawman.collection.Hashing$;
import strawman.collection.IterableFactoryLike;
import strawman.collection.IterableOnce;
import strawman.collection.Iterator;
import strawman.collection.Iterator$;
import strawman.collection.Map;
import strawman.collection.MapFactory;
import strawman.collection.MapOps;
import strawman.collection.StrictOptimizedIterableOps;
import strawman.collection.immutable.HashMap$;
import strawman.collection.immutable.Iterable;
import strawman.collection.immutable.List$;
import strawman.collection.immutable.ListMap;
import strawman.collection.immutable.ListMap$;
import strawman.collection.immutable.Seq;
import strawman.collection.immutable.Seq$;
import strawman.collection.immutable.Set;
import strawman.collection.immutable.TrieIterator;
import strawman.collection.mutable.Builder;
import strawman.collection.package$;

public interface HashMap<K, V>
extends strawman.collection.immutable.Map<K, V>,
StrictOptimizedIterableOps<Tuple2<K, V>, Iterable, HashMap<K, V>>,
Serializable {
    @Override
    default public <K, V> void $init$() {
    }

    @Override
    default public IterableFactoryLike<Iterable> iterableFactory() {
        return List$.MODULE$;
    }

    @Override
    default public MapFactory<HashMap> mapFactory() {
        return HashMap$.MODULE$;
    }

    @Override
    default public HashMap<K, V> fromSpecificIterable(strawman.collection.Iterable<Tuple2<K, V>> coll) {
        return HashMap$.MODULE$.from(coll);
    }

    @Override
    default public <K2, V2> HashMap<K2, V2> mapFromIterable(strawman.collection.Iterable<Tuple2<K2, V2>> it) {
        return HashMap$.MODULE$.from(it);
    }

    @Override
    default public Builder<Tuple2<K, V>, HashMap<K, V>> newSpecificBuilder() {
        return HashMap$.MODULE$.newBuilder();
    }

    @Override
    default public HashMap<K, V> remove(K key) {
        return this.removed0(key, Hashing$.MODULE$.computeHash(key), 0);
    }

    @Override
    default public <V1> HashMap<K, V1> updated(K key, V1 value) {
        return this.updated0(key, Hashing$.MODULE$.computeHash(key), 0, value, null, null);
    }

    @Override
    default public <V1> HashMap<K, V1> $plus(Tuple2<K, V1> kv) {
        return this.updated(kv._1(), kv._2());
    }

    @Override
    default public HashMap<K, V> empty() {
        return HashMap$.MODULE$.empty();
    }

    @Override
    default public Option<V> get(K key) {
        return this.get0(key, Hashing$.MODULE$.computeHash(key), 0);
    }

    default public Seq<HashMap<K, V>> split() {
        return (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new HashMap[]{this}));
    }

    default public <V1> HashMap<K, V1> merged(HashMap<K, V1> that, Function2<Tuple2<K, V1>, Tuple2<K, V1>, Tuple2<K, V1>> mergef) {
        return this.merge0(that, 0, HashMap$.MODULE$.strawman$collection$immutable$HashMap$$$liftMerger(mergef));
    }

    public <V1> HashMap<K, V1> updated0(K var1, int var2, int var3, V1 var4, Tuple2<K, V1> var5, Merger<K, V1> var6);

    public HashMap<K, V> removed0(K var1, int var2, int var3);

    public Option<V> get0(K var1, int var2, int var3);

    public <V1> HashMap<K, V1> merge0(HashMap<K, V1> var1, int var2, Merger<K, V1> var3);

    public HashMap<K, V> filter0(Function1<Tuple2<K, V>, Object> var1, boolean var2, int var3, HashMap<K, V>[] var4, int var5);

    public boolean contains0(K var1, int var2, int var3);

    @Override
    default public boolean contains(K key) {
        return this.contains0(key, Hashing$.MODULE$.computeHash(key), 0);
    }

    @Override
    default public HashMap<K, V> tail() {
        Object key = ((Tuple2)this.head())._1();
        HashMap MapOps_this = this;
        return MapOps_this.remove(key);
    }

    @Override
    default public HashMap<K, V> init() {
        Object key = ((Tuple2)this.last())._1();
        HashMap MapOps_this = this;
        return MapOps_this.remove(key);
    }

    @Override
    default public HashMap<K, V> filter(Function1<Tuple2<K, V>, Object> pred) {
        int size = this.size();
        HashMap[] buffer = new HashMap[scala.math.package$.MODULE$.min(size + 6, 224)];
        HashMap<K, V> m = this.filter0(pred, false, 0, buffer, 0);
        return m == null ? HashMap$.MODULE$.empty() : m;
    }

    @Override
    default public HashMap<K, V> filterNot(Function1<Tuple2<K, V>, Object> pred) {
        int size = this.size();
        HashMap[] buffer = new HashMap[scala.math.package$.MODULE$.min(size + 6, 224)];
        HashMap<K, V> m = this.filter0(pred, true, 0, buffer, 0);
        return m == null ? HashMap$.MODULE$.empty() : m;
    }

    @Override
    default public String className() {
        return "HashMap";
    }

    public static final class HashMap1<K, V>
    implements HashMap<K, V> {
        private final Object key;
        private final int hash;
        private final Object value;
        private Tuple2 kv;

        public <K, V> HashMap1(K key, int hash, V value, Tuple2<K, V> kv) {
            this.key = key;
            this.hash = hash;
            this.value = value;
            this.kv = kv;
            Function1.$init$((Function1)this);
            PartialFunction.$init$((PartialFunction)this);
        }

        public <A> Function1<A, V> compose(Function1<A, K> g) {
            return Function1.compose$((Function1)this, g);
        }

        public <A1 extends K, B1> PartialFunction<A1, B1> orElse(PartialFunction<A1, B1> that) {
            return PartialFunction.orElse$((PartialFunction)this, that);
        }

        public <C> PartialFunction<K, C> andThen(Function1<V, C> k) {
            return PartialFunction.andThen$((PartialFunction)this, k);
        }

        public Function1<K, Option<V>> lift() {
            return PartialFunction.lift$((PartialFunction)this);
        }

        public <U> Function1<K, Object> runWith(Function1<V, U> action) {
            return PartialFunction.runWith$((PartialFunction)this, action);
        }

        @Override
        public <K1 extends K, V1> V1 applyOrElse(K1 x, Function1<K1, V1> function1) {
            return MapOps.super.applyOrElse(x, function1);
        }

        @Override
        public MapOps.MapWithFilter withFilter(Function1<Tuple2<K, V>, Object> p) {
            return MapOps.super.withFilter(p);
        }

        @Override
        public String toString() {
            return MapOps.super.toString();
        }

        @Override
        public String mkString(String start, String sep, String end) {
            return MapOps.super.mkString(start, sep, end);
        }

        @Override
        public boolean equals(Object o) {
            return Map.super.equals(o);
        }

        @Override
        public int hashCode() {
            return Map.super.hashCode();
        }

        @Override
        public <V1> HashMap<K, V1> concat(strawman.collection.Iterable<Tuple2<K, V1>> that) {
            return (HashMap)strawman.collection.immutable.MapOps.super.concat(that);
        }

        @Override
        public Set<K> keySet() {
            return strawman.collection.immutable.MapOps.super.keySet();
        }

        @Override
        public Tuple2<HashMap<K, V>, HashMap<K, V>> partition(Function1<Tuple2<K, V>, Object> p) {
            return StrictOptimizedIterableOps.super.partition(p);
        }

        @Override
        public Tuple2<HashMap<K, V>, HashMap<K, V>> span(Function1<Tuple2<K, V>, Object> p) {
            return StrictOptimizedIterableOps.super.span(p);
        }

        @Override
        public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Predef$.less.colon.less<Tuple2<K, V>, Tuple2<A1, A2>> asPair) {
            return StrictOptimizedIterableOps.super.unzip(asPair);
        }

        @Override
        public <B> Iterable<B> map(Function1<Tuple2<K, V>, B> f) {
            return (Iterable)StrictOptimizedIterableOps.super.map(f);
        }

        @Override
        public <B> Iterable<B> flatMap(Function1<Tuple2<K, V>, IterableOnce<B>> f) {
            return (Iterable)StrictOptimizedIterableOps.super.flatMap(f);
        }

        @Override
        public <B> Iterable<B> collect(PartialFunction<Tuple2<K, V>, B> pf) {
            return (Iterable)StrictOptimizedIterableOps.super.collect(pf);
        }

        @Override
        public <B> Iterable<B> flatten(Function1<Tuple2<K, V>, IterableOnce<B>> toIterableOnce) {
            return (Iterable)StrictOptimizedIterableOps.super.flatten(toIterableOnce);
        }

        @Override
        public <B> Iterable<Tuple2<Tuple2<K, V>, B>> zip(strawman.collection.Iterable<B> that) {
            return (Iterable)StrictOptimizedIterableOps.super.zip(that);
        }

        @Override
        public Iterable<Tuple2<Tuple2<K, V>, Object>> zipWithIndex() {
            return (Iterable)StrictOptimizedIterableOps.super.zipWithIndex();
        }

        @Override
        public <B> Iterable<B> scanLeft(B z, Function2<B, Tuple2<K, V>, B> op) {
            return (Iterable)StrictOptimizedIterableOps.super.scanLeft(z, op);
        }

        @Override
        public final <V1> HashMap<K, V1> $plus(Tuple2<K, V1> kv) {
            return HashMap.super.$plus(kv);
        }

        @Override
        public final boolean contains(K key) {
            return HashMap.super.contains(key);
        }

        @Override
        public HashMap<K, V> tail() {
            return HashMap.super.tail();
        }

        @Override
        public HashMap<K, V> init() {
            return HashMap.super.init();
        }

        @Override
        public HashMap<K, V> filter(Function1<Tuple2<K, V>, Object> pred) {
            return HashMap.super.filter(pred);
        }

        @Override
        public HashMap<K, V> filterNot(Function1<Tuple2<K, V>, Object> pred) {
            return HashMap.super.filterNot(pred);
        }

        @Override
        public String className() {
            return HashMap.super.className();
        }

        public K key() {
            return (K)this.key;
        }

        public int hash() {
            return this.hash;
        }

        public V value() {
            return (V)this.value;
        }

        public Tuple2<K, V> kv() {
            return this.kv;
        }

        public void kv_$eq(Tuple2<K, V> x$1) {
            this.kv = x$1;
        }

        @Override
        public Iterator<Tuple2<K, V>> iterator() {
            return Iterator$.MODULE$.single(this.ensurePair());
        }

        @Override
        public Option<V> get0(K key, int hash, int level) {
            return hash == this.hash() && BoxesRunTime.equals(key, this.key()) ? Some$.MODULE$.apply(this.value()) : None$.MODULE$;
        }

        @Override
        public int size() {
            return 1;
        }

        public K getKey() {
            return this.key();
        }

        public int getHash() {
            return this.hash();
        }

        public int computeHashFor(K k) {
            return Hashing$.MODULE$.computeHash(k);
        }

        @Override
        public boolean contains0(K key, int hash, int level) {
            return hash == this.hash() && BoxesRunTime.equals(key, this.key());
        }

        @Override
        public <V1> HashMap<K, V1> updated0(K key, int hash, int level, V1 value, Tuple2<K, V1> kv, Merger<K, V1> merger) {
            HashMap<Object, Object> hashMap;
            if (hash == this.hash() && BoxesRunTime.equals(key, this.key())) {
                if (merger == null) {
                    hashMap = this.value() == value ? this : new HashMap1<K, V1>(key, hash, value, kv);
                } else {
                    Tuple2<K, V1> nkv = merger.apply(this.ensurePair(), kv != null ? kv : Tuple2$.MODULE$.apply(key, value));
                    hashMap = new HashMap1<Object, Object>(nkv._1(), hash, nkv._2(), nkv);
                }
            } else if (hash != this.hash()) {
                HashMap1<K, V1> that = new HashMap1<K, V1>(key, hash, value, kv);
                hashMap = HashMap$.MODULE$.strawman$collection$immutable$HashMap$$$makeHashTrieMap(this.hash(), this, hash, that, level, 2);
            } else {
                hashMap = new HashMapCollision1(hash, ((ListMap)((ListMap)ListMap$.MODULE$.empty()).updated((Object)this.key(), this.value())).updated((Object)key, (Object)value));
            }
            return hashMap;
        }

        @Override
        public HashMap<K, V> removed0(K key, int hash, int level) {
            return hash == this.hash() && BoxesRunTime.equals(key, this.key()) ? HashMap$.MODULE$.empty() : this;
        }

        @Override
        public HashMap<K, V> filter0(Function1<Tuple2<K, V>, Object> p, boolean negate, int level, HashMap<K, V>[] buffer, int offset0) {
            return negate ^ BoxesRunTime.unboxToBoolean((Object)p.apply(this.ensurePair())) ? this : null;
        }

        @Override
        public <U> void foreach(Function1<Tuple2<K, V>, U> f) {
            f.apply(this.ensurePair());
        }

        public Tuple2<K, V> ensurePair() {
            Tuple2<K, V> tuple2;
            if (this.kv() != null) {
                tuple2 = this.kv();
            } else {
                this.kv_$eq(Tuple2$.MODULE$.apply(this.key(), this.value()));
                tuple2 = this.kv();
            }
            return tuple2;
        }

        @Override
        public <V1> HashMap<K, V1> merge0(HashMap<K, V1> that, int level, Merger<K, V1> merger) {
            return that.updated0(this.key(), this.hash(), level, this.value(), this.kv(), merger.invert());
        }
    }

    public static class HashMapCollision1<K, V>
    implements HashMap<K, V> {
        private final int hash;
        private final ListMap kvs;

        public <K, V> HashMapCollision1(int hash, ListMap<K, V> kvs) {
            this.hash = hash;
            this.kvs = kvs;
            Function1.$init$((Function1)this);
            PartialFunction.$init$((PartialFunction)this);
        }

        public <A> Function1<A, V> compose(Function1<A, K> g) {
            return Function1.compose$((Function1)this, g);
        }

        public <A1 extends K, B1> PartialFunction<A1, B1> orElse(PartialFunction<A1, B1> that) {
            return PartialFunction.orElse$((PartialFunction)this, that);
        }

        public <C> PartialFunction<K, C> andThen(Function1<V, C> k) {
            return PartialFunction.andThen$((PartialFunction)this, k);
        }

        public Function1<K, Option<V>> lift() {
            return PartialFunction.lift$((PartialFunction)this);
        }

        public <U> Function1<K, Object> runWith(Function1<V, U> action) {
            return PartialFunction.runWith$((PartialFunction)this, action);
        }

        @Override
        public <K1 extends K, V1> V1 applyOrElse(K1 x, Function1<K1, V1> function1) {
            return MapOps.super.applyOrElse(x, function1);
        }

        @Override
        public MapOps.MapWithFilter withFilter(Function1<Tuple2<K, V>, Object> p) {
            return MapOps.super.withFilter(p);
        }

        @Override
        public String toString() {
            return MapOps.super.toString();
        }

        @Override
        public String mkString(String start, String sep, String end) {
            return MapOps.super.mkString(start, sep, end);
        }

        @Override
        public boolean equals(Object o) {
            return Map.super.equals(o);
        }

        @Override
        public int hashCode() {
            return Map.super.hashCode();
        }

        @Override
        public <V1> HashMap<K, V1> concat(strawman.collection.Iterable<Tuple2<K, V1>> that) {
            return (HashMap)strawman.collection.immutable.MapOps.super.concat(that);
        }

        @Override
        public Set<K> keySet() {
            return strawman.collection.immutable.MapOps.super.keySet();
        }

        @Override
        public Tuple2<HashMap<K, V>, HashMap<K, V>> partition(Function1<Tuple2<K, V>, Object> p) {
            return StrictOptimizedIterableOps.super.partition(p);
        }

        @Override
        public Tuple2<HashMap<K, V>, HashMap<K, V>> span(Function1<Tuple2<K, V>, Object> p) {
            return StrictOptimizedIterableOps.super.span(p);
        }

        @Override
        public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Predef$.less.colon.less<Tuple2<K, V>, Tuple2<A1, A2>> asPair) {
            return StrictOptimizedIterableOps.super.unzip(asPair);
        }

        @Override
        public <B> Iterable<B> map(Function1<Tuple2<K, V>, B> f) {
            return (Iterable)StrictOptimizedIterableOps.super.map(f);
        }

        @Override
        public <B> Iterable<B> flatMap(Function1<Tuple2<K, V>, IterableOnce<B>> f) {
            return (Iterable)StrictOptimizedIterableOps.super.flatMap(f);
        }

        @Override
        public <B> Iterable<B> collect(PartialFunction<Tuple2<K, V>, B> pf) {
            return (Iterable)StrictOptimizedIterableOps.super.collect(pf);
        }

        @Override
        public <B> Iterable<B> flatten(Function1<Tuple2<K, V>, IterableOnce<B>> toIterableOnce) {
            return (Iterable)StrictOptimizedIterableOps.super.flatten(toIterableOnce);
        }

        @Override
        public <B> Iterable<Tuple2<Tuple2<K, V>, B>> zip(strawman.collection.Iterable<B> that) {
            return (Iterable)StrictOptimizedIterableOps.super.zip(that);
        }

        @Override
        public Iterable<Tuple2<Tuple2<K, V>, Object>> zipWithIndex() {
            return (Iterable)StrictOptimizedIterableOps.super.zipWithIndex();
        }

        @Override
        public <B> Iterable<B> scanLeft(B z, Function2<B, Tuple2<K, V>, B> op) {
            return (Iterable)StrictOptimizedIterableOps.super.scanLeft(z, op);
        }

        @Override
        public final <V1> HashMap<K, V1> $plus(Tuple2<K, V1> kv) {
            return HashMap.super.$plus(kv);
        }

        @Override
        public final boolean contains(K key) {
            return HashMap.super.contains(key);
        }

        @Override
        public HashMap<K, V> tail() {
            return HashMap.super.tail();
        }

        @Override
        public HashMap<K, V> init() {
            return HashMap.super.init();
        }

        @Override
        public HashMap<K, V> filter(Function1<Tuple2<K, V>, Object> pred) {
            return HashMap.super.filter(pred);
        }

        @Override
        public HashMap<K, V> filterNot(Function1<Tuple2<K, V>, Object> pred) {
            return HashMap.super.filterNot(pred);
        }

        @Override
        public String className() {
            return HashMap.super.className();
        }

        public int hash() {
            return this.hash;
        }

        public ListMap<K, V> kvs() {
            return this.kvs;
        }

        @Override
        public int size() {
            return this.kvs().size();
        }

        @Override
        public Option<V> get0(K key, int hash, int level) {
            return hash == this.hash() ? this.kvs().get(key) : None$.MODULE$;
        }

        @Override
        public boolean contains0(K key, int hash, int level) {
            return hash == this.hash() && this.kvs().contains(key);
        }

        @Override
        public <B1> HashMap<K, B1> updated0(K key, int hash, int level, B1 value, Tuple2<K, B1> kv, Merger<K, B1> merger) {
            HashMap<K, Object> hashMap;
            if (hash == this.hash()) {
                hashMap = merger == null || !this.kvs().contains(key) ? new HashMapCollision1<K, V>(hash, this.kvs().updated((Object)key, (Object)value)) : new HashMapCollision1<K, V>(hash, (ListMap)this.kvs().$plus(merger.apply(Tuple2$.MODULE$.apply(key, this.kvs().apply(key)), kv)));
            } else {
                HashMap1<K, B1> that = new HashMap1<K, B1>(key, hash, value, kv);
                hashMap = HashMap$.MODULE$.strawman$collection$immutable$HashMap$$$makeHashTrieMap(this.hash(), this, hash, that, level, this.size() + 1);
            }
            return hashMap;
        }

        @Override
        public HashMap<K, V> removed0(K key, int hash, int level) {
            HashMapCollision1<K, V> hashMapCollision1;
            if (hash == this.hash()) {
                ListMap<K, V> MapOps_this = this.kvs();
                strawman.collection.immutable.MapOps kvs1 = MapOps_this.remove((Object)key);
                int n = ((ListMap)kvs1).size();
                if (0 == n) {
                    hashMapCollision1 = HashMap$.MODULE$.empty();
                } else if (1 == n) {
                    Tuple2 kv = (Tuple2)kvs1.head();
                    hashMapCollision1 = new HashMap1<Object, Object>(kv._1(), hash, kv._2(), kv);
                } else {
                    int x = n;
                    hashMapCollision1 = x == this.kvs().size() ? this : new HashMapCollision1<K, V>(hash, kvs1);
                }
            } else {
                hashMapCollision1 = this;
            }
            return hashMapCollision1;
        }

        @Override
        public HashMap<K, V> filter0(Function1<Tuple2<K, V>, Object> p, boolean negate, int level, HashMap<K, V>[] buffer, int offset0) {
            HashMap<Object, Object> hashMap;
            ListMap kvs1 = negate ? (ListMap)this.kvs().filterNot(p) : (ListMap)this.kvs().filter(p);
            int n = kvs1.size();
            if (0 == n) {
                hashMap = null;
            } else if (1 == n) {
                Tuple2 tuple2 = (Tuple2)kvs1.head();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object k = tuple2._1();
                Object v = tuple2._2();
                Tuple2 kv = tuple2;
                Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)kv, k, v);
                Tuple2 kv2 = (Tuple2)tuple3._1();
                Object k2 = tuple3._2();
                Object v2 = tuple3._3();
                hashMap = new HashMap1<Object, Object>(k2, this.hash(), v2, kv2);
            } else {
                int x = n;
                hashMap = x == this.kvs().size() ? this : new HashMapCollision1<K, V>(this.hash(), kvs1);
            }
            return hashMap;
        }

        @Override
        public <V1> HashMap<K, V1> merge0(HashMap<K, V1> that, int level, Merger<K, V1> merger) {
            ObjectRef m = ObjectRef.create(that);
            this.kvs().foreach(arg_0 -> this.merge0$$anonfun$1(level, merger, m, arg_0));
            return (HashMap)m.elem;
        }

        @Override
        public Iterator<Tuple2<K, V>> iterator() {
            return this.kvs().iterator();
        }

        @Override
        public <U> void foreach(Function1<Tuple2<K, V>, U> f) {
            this.kvs().foreach(f);
        }

        @Override
        public Seq<HashMap<K, V>> split() {
            Tuple2 tuple2 = this.kvs().splitAt(this.kvs().size() / 2);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            ListMap x = (ListMap)tuple2._1();
            ListMap y = (ListMap)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)x, (Object)y);
            ListMap x2 = (ListMap)tuple22._1();
            ListMap y2 = (ListMap)tuple22._2();
            return (Seq)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new HashMapCollision1[]{this.newhm$1(x2), this.newhm$1(y2)}));
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void merge0$$anonfun$1(int level$1, Merger merger$1, ObjectRef m$12, Tuple2 p) {
            HashMap<Object, Object> hashMap;
            m$12.elem = hashMap = ((HashMap)m$12.elem).updated0(p._1(), this.hash(), level$1, p._2(), p, merger$1);
        }

        private HashMapCollision1<K, V> newhm$1(ListMap<K, V> lm) {
            return new HashMapCollision1<K, V>(this.hash(), lm);
        }
    }

    public static final class HashTrieMap<K, V>
    implements HashMap<K, V> {
        private final int bitmap;
        private final HashMap[] elems;
        private final int size0;

        public <K, V> HashTrieMap(int bitmap, HashMap<K, V>[] elems, int size0) {
            this.bitmap = bitmap;
            this.elems = elems;
            this.size0 = size0;
            Function1.$init$((Function1)this);
            PartialFunction.$init$((PartialFunction)this);
        }

        public <A> Function1<A, V> compose(Function1<A, K> g) {
            return Function1.compose$((Function1)this, g);
        }

        public <A1 extends K, B1> PartialFunction<A1, B1> orElse(PartialFunction<A1, B1> that) {
            return PartialFunction.orElse$((PartialFunction)this, that);
        }

        public <C> PartialFunction<K, C> andThen(Function1<V, C> k) {
            return PartialFunction.andThen$((PartialFunction)this, k);
        }

        public Function1<K, Option<V>> lift() {
            return PartialFunction.lift$((PartialFunction)this);
        }

        public <U> Function1<K, Object> runWith(Function1<V, U> action) {
            return PartialFunction.runWith$((PartialFunction)this, action);
        }

        @Override
        public <K1 extends K, V1> V1 applyOrElse(K1 x, Function1<K1, V1> function1) {
            return MapOps.super.applyOrElse(x, function1);
        }

        @Override
        public MapOps.MapWithFilter withFilter(Function1<Tuple2<K, V>, Object> p) {
            return MapOps.super.withFilter(p);
        }

        @Override
        public String toString() {
            return MapOps.super.toString();
        }

        @Override
        public String mkString(String start, String sep, String end) {
            return MapOps.super.mkString(start, sep, end);
        }

        @Override
        public boolean equals(Object o) {
            return Map.super.equals(o);
        }

        @Override
        public int hashCode() {
            return Map.super.hashCode();
        }

        @Override
        public <V1> HashMap<K, V1> concat(strawman.collection.Iterable<Tuple2<K, V1>> that) {
            return (HashMap)strawman.collection.immutable.MapOps.super.concat(that);
        }

        @Override
        public Set<K> keySet() {
            return strawman.collection.immutable.MapOps.super.keySet();
        }

        @Override
        public Tuple2<HashMap<K, V>, HashMap<K, V>> partition(Function1<Tuple2<K, V>, Object> p) {
            return StrictOptimizedIterableOps.super.partition(p);
        }

        @Override
        public Tuple2<HashMap<K, V>, HashMap<K, V>> span(Function1<Tuple2<K, V>, Object> p) {
            return StrictOptimizedIterableOps.super.span(p);
        }

        @Override
        public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Predef$.less.colon.less<Tuple2<K, V>, Tuple2<A1, A2>> asPair) {
            return StrictOptimizedIterableOps.super.unzip(asPair);
        }

        @Override
        public <B> Iterable<B> map(Function1<Tuple2<K, V>, B> f) {
            return (Iterable)StrictOptimizedIterableOps.super.map(f);
        }

        @Override
        public <B> Iterable<B> flatMap(Function1<Tuple2<K, V>, IterableOnce<B>> f) {
            return (Iterable)StrictOptimizedIterableOps.super.flatMap(f);
        }

        @Override
        public <B> Iterable<B> collect(PartialFunction<Tuple2<K, V>, B> pf) {
            return (Iterable)StrictOptimizedIterableOps.super.collect(pf);
        }

        @Override
        public <B> Iterable<B> flatten(Function1<Tuple2<K, V>, IterableOnce<B>> toIterableOnce) {
            return (Iterable)StrictOptimizedIterableOps.super.flatten(toIterableOnce);
        }

        @Override
        public <B> Iterable<Tuple2<Tuple2<K, V>, B>> zip(strawman.collection.Iterable<B> that) {
            return (Iterable)StrictOptimizedIterableOps.super.zip(that);
        }

        @Override
        public Iterable<Tuple2<Tuple2<K, V>, Object>> zipWithIndex() {
            return (Iterable)StrictOptimizedIterableOps.super.zipWithIndex();
        }

        @Override
        public <B> Iterable<B> scanLeft(B z, Function2<B, Tuple2<K, V>, B> op) {
            return (Iterable)StrictOptimizedIterableOps.super.scanLeft(z, op);
        }

        @Override
        public final <V1> HashMap<K, V1> $plus(Tuple2<K, V1> kv) {
            return HashMap.super.$plus(kv);
        }

        @Override
        public final boolean contains(K key) {
            return HashMap.super.contains(key);
        }

        @Override
        public HashMap<K, V> tail() {
            return HashMap.super.tail();
        }

        @Override
        public HashMap<K, V> init() {
            return HashMap.super.init();
        }

        @Override
        public HashMap<K, V> filter(Function1<Tuple2<K, V>, Object> pred) {
            return HashMap.super.filter(pred);
        }

        @Override
        public HashMap<K, V> filterNot(Function1<Tuple2<K, V>, Object> pred) {
            return HashMap.super.filterNot(pred);
        }

        @Override
        public String className() {
            return HashMap.super.className();
        }

        public int bitmap() {
            return this.bitmap;
        }

        public HashMap<K, V>[] elems() {
            return this.elems;
        }

        public int size0() {
            return this.size0;
        }

        @Override
        public int size() {
            return this.size0();
        }

        @Override
        public Option<V> get0(K key, int hash, int level) {
            Option<V> option;
            int index = hash >>> level & 0x1F;
            if (this.bitmap() == -1) {
                option = this.elems()[index].get0(key, hash, level + 5);
            } else {
                int mask = 1 << index;
                if ((this.bitmap() & mask) != 0) {
                    int offset = Integer.bitCount(this.bitmap() & mask - 1);
                    option = this.elems()[offset].get0(key, hash, level + 5);
                } else {
                    option = None$.MODULE$;
                }
            }
            return option;
        }

        @Override
        public boolean contains0(K key, int hash, int level) {
            boolean bl;
            int index = hash >>> level & 0x1F;
            if (this.bitmap() == -1) {
                bl = this.elems()[index].contains0(key, hash, level + 5);
            } else {
                int mask = 1 << index;
                if ((this.bitmap() & mask) != 0) {
                    int offset = Integer.bitCount(this.bitmap() & mask - 1);
                    bl = this.elems()[offset].contains0(key, hash, level + 5);
                } else {
                    bl = false;
                }
            }
            return bl;
        }

        @Override
        public <V1> HashMap<K, V1> updated0(K key, int hash, int level, V1 value, Tuple2<K, V1> kv, Merger<K, V1> merger) {
            HashTrieMap hashTrieMap;
            int index = hash >>> level & 0x1F;
            int mask = 1 << index;
            int offset = Integer.bitCount(this.bitmap() & mask - 1);
            if ((this.bitmap() & mask) != 0) {
                HashMap<K, V> sub = this.elems()[offset];
                HashMap<K, V1> subNew = sub.updated0(key, hash, level + 5, value, kv, merger);
                if (subNew == sub) {
                    hashTrieMap = this;
                } else {
                    HashMap[] elemsNew = new HashMap[this.elems().length];
                    Array$.MODULE$.copy(this.elems(), 0, (Object)elemsNew, 0, this.elems().length);
                    elemsNew[offset] = subNew;
                    hashTrieMap = new HashTrieMap<K, V>(this.bitmap(), elemsNew, this.size() + (subNew.size() - sub.size()));
                }
            } else {
                HashMap[] elemsNew = new HashMap[this.elems().length + 1];
                Array$.MODULE$.copy(this.elems(), 0, (Object)elemsNew, 0, offset);
                elemsNew[offset] = new HashMap1<K, V1>(key, hash, value, kv);
                Array$.MODULE$.copy(this.elems(), offset, (Object)elemsNew, offset + 1, this.elems().length - offset);
                hashTrieMap = new HashTrieMap<K, V>(this.bitmap() | mask, elemsNew, this.size() + 1);
            }
            return hashTrieMap;
        }

        @Override
        public HashMap<K, V> removed0(K key, int hash, int level) {
            HashMap hashMap;
            int index = hash >>> level & 0x1F;
            int mask = 1 << index;
            int offset = Integer.bitCount(this.bitmap() & mask - 1);
            if ((this.bitmap() & mask) != 0) {
                HashMap<K, V> sub = this.elems()[offset];
                HashMap<K, V> subNew = sub.removed0(key, hash, level + 5);
                if (subNew == sub) {
                    hashMap = this;
                } else if (subNew.isEmpty()) {
                    int bitmapNew = this.bitmap() ^ mask;
                    if (bitmapNew != 0) {
                        HashMap[] elemsNew = new HashMap[this.elems().length - 1];
                        Array$.MODULE$.copy(this.elems(), 0, (Object)elemsNew, 0, offset);
                        Array$.MODULE$.copy(this.elems(), offset + 1, (Object)elemsNew, offset, this.elems().length - offset - 1);
                        int sizeNew = this.size() - sub.size();
                        hashMap = elemsNew.length == 1 && !(elemsNew[0] instanceof HashTrieMap) ? elemsNew[0] : new HashTrieMap<K, V>(bitmapNew, elemsNew, sizeNew);
                    } else {
                        hashMap = HashMap$.MODULE$.empty();
                    }
                } else if (this.elems().length == 1 && !(subNew instanceof HashTrieMap)) {
                    hashMap = subNew;
                } else {
                    HashMap<K, V>[] elemsNew = Arrays.copyOf(this.elems(), this.elems().length);
                    elemsNew[offset] = subNew;
                    int sizeNew = this.size() + (subNew.size() - sub.size());
                    hashMap = new HashTrieMap<K, V>(this.bitmap(), elemsNew, sizeNew);
                }
            } else {
                hashMap = this;
            }
            return hashMap;
        }

        @Override
        public HashMap<K, V> filter0(Function1<Tuple2<K, V>, Object> p, boolean negate, int level, HashMap<K, V>[] buffer, int offset0) {
            HashMap<K, V> hashMap;
            int offset = offset0;
            int rs = 0;
            int kept = 0;
            for (int i = 0; i < this.elems().length; ++i) {
                HashMap<K, V> result = this.elems()[i].filter0(p, negate, level + 5, buffer, offset);
                if (result == null) continue;
                buffer[offset] = result;
                ++offset;
                rs += result.size();
                kept |= 1 << i;
            }
            if (offset == offset0) {
                hashMap = null;
            } else if (rs == this.size0()) {
                hashMap = this;
            } else if (offset == offset0 + 1 && !(buffer[offset0] instanceof HashTrieMap)) {
                hashMap = buffer[offset0];
            } else {
                int length = offset - offset0;
                HashMap[] elems1 = new HashMap[length];
                System.arraycopy(buffer, offset0, elems1, 0, length);
                int bitmap1 = length == this.elems().length ? this.bitmap() : Hashing$.MODULE$.keepBits(this.bitmap(), kept);
                hashMap = new HashTrieMap<K, V>(bitmap1, elems1, rs);
            }
            return hashMap;
        }

        @Override
        public Iterator<Tuple2<K, V>> iterator() {
            return new TrieIterator<Tuple2<K, V>>(this){
                private final HashTrieMap $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.strawman$collection$immutable$HashMap$HashTrieMap$$_$$anon$superArg$1$1());
                }

                public final Tuple2<K, V> getElem(Object cc) {
                    return ((HashMap1)cc).ensurePair();
                }

                private HashTrieMap<K, V> $outer() {
                    return this.$outer;
                }

                public final HashTrieMap<K, V> strawman$collection$immutable$HashMap$HashTrieMap$_$$anon$$$outer() {
                    return this.$outer();
                }
            };
        }

        @Override
        public <U> void foreach(Function1<Tuple2<K, V>, U> f) {
            for (int i = 0; i < this.elems().length; ++i) {
                this.elems()[i].foreach(f);
            }
        }

        private int posOf(int n, int bm) {
            int left = n;
            int i = -1;
            int b = bm;
            while (left >= 0) {
                ++i;
                if ((b & 1) != 0) {
                    --left;
                }
                b >>>= 1;
            }
            return i;
        }

        @Override
        public Seq<HashMap<K, V>> split() {
            Seq seq;
            if (this.size() == 1) {
                seq = (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new HashTrieMap[]{this}));
            } else {
                int nodesize = Integer.bitCount(this.bitmap());
                if (nodesize > 1) {
                    int splitpoint = nodesize / 2;
                    int bitsplitpoint = this.posOf(nodesize / 2, this.bitmap());
                    int bm1 = this.bitmap() & -1 << bitsplitpoint;
                    int bm2 = this.bitmap() & -1 >>> 32 - bitsplitpoint;
                    Tuple2 tuple2 = new ArrayOps(package$.MODULE$.arrayToArrayOps(this.elems())).splitAt(splitpoint);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    HashMap[] e1 = (HashMap[])tuple2._1();
                    HashMap[] e2 = (HashMap[])tuple2._2();
                    Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)e1, (Object)e2);
                    HashMap[] e12 = (HashMap[])tuple22._1();
                    HashMap[] e22 = (HashMap[])tuple22._2();
                    HashTrieMap<K, V> hm1 = new HashTrieMap<K, V>(bm1, e12, BoxesRunTime.unboxToInt((Object)new ArrayOps(package$.MODULE$.arrayToArrayOps(e12)).foldLeft(BoxesRunTime.boxToInteger((int)0), this::$anonfun$adapted$1)));
                    HashTrieMap<K, V> hm2 = new HashTrieMap<K, V>(bm2, e22, BoxesRunTime.unboxToInt((Object)new ArrayOps(package$.MODULE$.arrayToArrayOps(e22)).foldLeft(BoxesRunTime.boxToInteger((int)0), this::$anonfun$adapted$2)));
                    seq = (Seq)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new HashTrieMap[]{hm1, hm2}));
                } else {
                    seq = this.elems()[0].split();
                }
            }
            return seq;
        }

        @Override
        public <V1> HashMap<K, V1> merge0(HashMap<K, V1> that, int level, Merger<K, V1> merger) {
            HashMap<K, Object> hashMap;
            HashMap<K, V1> hashMap2 = that;
            if (hashMap2 instanceof HashMap1) {
                HashMap1 hashMap1;
                HashMap1 hm = hashMap1 = (HashMap1)hashMap2;
                hashMap = this.updated0(hm.key(), hm.hash(), level, hm.value(), hm.kv(), merger);
            } else if (hashMap2 instanceof HashTrieMap) {
                HashTrieMap hashTrieMap;
                HashTrieMap hm;
                HashTrieMap that2 = hm = (hashTrieMap = (HashTrieMap)hashMap2);
                HashMap<K, V>[] thiselems = this.elems();
                HashMap<K, V>[] thatelems = that2.elems();
                int thisbm = this.bitmap();
                int thatbm = that2.bitmap();
                int subcount = Integer.bitCount(thisbm | thatbm);
                HashMap[] merged = new HashMap[subcount];
                int thisi = 0;
                int thati = 0;
                int totalelems = 0;
                for (int i = 0; i < subcount; ++i) {
                    int thislsb = thisbm ^ thisbm & thisbm - 1;
                    int thatlsb = thatbm ^ thatbm & thatbm - 1;
                    if (thislsb == thatlsb) {
                        HashMap<K, V> m = thiselems[thisi].merge0(thatelems[thati], level + 5, merger);
                        totalelems += m.size();
                        merged[i] = m;
                        thisbm &= ~thislsb;
                        thatbm &= ~thatlsb;
                        ++thati;
                        ++thisi;
                        continue;
                    }
                    if (Integer.compareUnsigned(thislsb - 1, thatlsb - 1) < 0) {
                        HashMap<K, V> m = thiselems[thisi];
                        totalelems += m.size();
                        merged[i] = m;
                        thisbm &= ~thislsb;
                        ++thisi;
                        continue;
                    }
                    HashMap<K, V> m = thatelems[thati];
                    totalelems += m.size();
                    merged[i] = m;
                    thatbm &= ~thatlsb;
                    ++thati;
                }
                hashMap = new HashTrieMap<K, V>(this.bitmap() | that2.bitmap(), merged, totalelems);
            } else if (hashMap2 instanceof HashMapCollision1) {
                HashMapCollision1 hashMapCollision1;
                HashMapCollision1 hm = hashMapCollision1 = (HashMapCollision1)hashMap2;
                hashMap = that.merge0(this, level, merger.invert());
            } else if (hashMap2 instanceof HashMap) {
                HashMap<K, V1> hashMap3;
                HashMap<K, V1> hm = hashMap3 = hashMap2;
                hashMap = this;
            } else {
                throw new MatchError(hashMap2);
            }
            return hashMap;
        }

        public Iterable<Tuple2<K, V>>[] strawman$collection$immutable$HashMap$HashTrieMap$$_$$anon$superArg$1$1() {
            return this.elems();
        }

        private int $anonfun$1(int _$67, HashMap<K, V> _$68) {
            return _$67 + _$68.size();
        }

        private int $anonfun$adapted$1(Object _$67, Object _$68) {
            return this.$anonfun$1(BoxesRunTime.unboxToInt((Object)_$67), (HashMap)_$68);
        }

        private int $anonfun$2(int _$69, HashMap<K, V> _$70) {
            return _$69 + _$70.size();
        }

        private int $anonfun$adapted$2(Object _$69, Object _$70) {
            return this.$anonfun$2(BoxesRunTime.unboxToInt((Object)_$69), (HashMap)_$70);
        }
    }

    public static abstract class Merger<A, B> {
        public abstract Tuple2<A, B> apply(Tuple2<A, B> var1, Tuple2<A, B> var2);

        public abstract Merger<A, B> invert();
    }
}

