/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.immutable;

import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.compat.java8.JFunction1;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import strawman.collection.ArrayOps;
import strawman.collection.IndexedSeqOps;
import strawman.collection.IndexedView;
import strawman.collection.Iterable;
import strawman.collection.IterableOnce;
import strawman.collection.IterableOps;
import strawman.collection.Iterator;
import strawman.collection.Iterator$;
import strawman.collection.Seq;
import strawman.collection.SeqFactory;
import strawman.collection.SeqOps;
import strawman.collection.StrictOptimizedIterableOps;
import strawman.collection.StrictOptimizedSeqOps;
import strawman.collection.immutable.IndexedSeq;
import strawman.collection.immutable.IndexedSeq$;
import strawman.collection.immutable.Map;
import strawman.collection.immutable.Nil$;
import strawman.collection.immutable.NumericRange$;
import strawman.collection.mutable.Builder;
import strawman.collection.package$;

public class NumericRange<T>
implements IndexedSeq<T>,
strawman.collection.immutable.StrictOptimizedSeqOps<T, IndexedSeq, IndexedSeq<T>>,
Serializable {
    private final Object start;
    private final Object end;
    private final Object step;
    private final boolean isInclusive;
    public final Integral<T> strawman$collection$immutable$NumericRange$$num;
    private int length$lzy1;
    private boolean lengthbitmap$1;
    private int hashCode$lzy1;
    private boolean hashCodebitmap$1;

    public static Map defaultOrdering() {
        return NumericRange$.MODULE$.defaultOrdering();
    }

    public static <T> Inclusive<T> inclusive(T t, T t2, T t3, Integral<T> integral) {
        return NumericRange$.MODULE$.inclusive(t, t2, t3, integral);
    }

    public <T> NumericRange(T start, T end, T step, boolean isInclusive, Integral<T> num) {
        this.start = start;
        this.end = end;
        this.step = step;
        this.isInclusive = isInclusive;
        this.strawman$collection$immutable$NumericRange$$num = num;
        Function1.$init$((Function1)this);
        PartialFunction.$init$((PartialFunction)this);
    }

    public <A> Function1<A, T> compose(Function1<A, Object> g) {
        return Function1.compose$((Function1)this, g);
    }

    public <A1, B1> PartialFunction<A1, B1> orElse(PartialFunction<A1, B1> that) {
        return PartialFunction.orElse$((PartialFunction)this, that);
    }

    public <C> PartialFunction<Object, C> andThen(Function1<T, C> k) {
        return PartialFunction.andThen$((PartialFunction)this, k);
    }

    public Function1<Object, Option<T>> lift() {
        return PartialFunction.lift$((PartialFunction)this);
    }

    public <A1, B1> B1 applyOrElse(A1 x, Function1<A1, B1> function1) {
        return (B1)PartialFunction.applyOrElse$((PartialFunction)this, (Object)BoxesRunTime.boxToInteger(x), function1);
    }

    public <U> Function1<Object, Object> runWith(Function1<T, U> action) {
        return PartialFunction.runWith$((PartialFunction)this, action);
    }

    @Override
    public /* synthetic */ IndexedSeq strawman$collection$SeqOps$$super$concat(Iterable suffix) {
        return (IndexedSeq)IterableOps.super.concat(suffix);
    }

    @Override
    public final <B> IndexedSeq<B> concat(Iterable<B> suffix) {
        return (IndexedSeq)SeqOps.super.concat(suffix);
    }

    @Override
    public final NumericRange toSeq() {
        return (NumericRange)strawman.collection.immutable.Seq.super.toSeq();
    }

    @Override
    public IndexedView<T> view() {
        return IndexedSeqOps.super.view();
    }

    @Override
    public Iterable<T> reversed() {
        return IndexedSeqOps.super.reversed();
    }

    @Override
    public IndexedSeq<T> takeRight(int n) {
        return (IndexedSeq)IndexedSeqOps.super.takeRight(n);
    }

    @Override
    public IndexedSeq<T> dropRight(int n) {
        return (IndexedSeq)IndexedSeqOps.super.dropRight(n);
    }

    @Override
    public int lengthCompare(int len) {
        return IndexedSeqOps.super.lengthCompare(len);
    }

    @Override
    public Tuple2<IndexedSeq<T>, IndexedSeq<T>> partition(Function1<T, Object> p) {
        return StrictOptimizedIterableOps.super.partition(p);
    }

    @Override
    public Tuple2<IndexedSeq<T>, IndexedSeq<T>> span(Function1<T, Object> p) {
        return StrictOptimizedIterableOps.super.span(p);
    }

    @Override
    public <A1, A2> Tuple2<IndexedSeq<A1>, IndexedSeq<A2>> unzip(Predef$.less.colon.less<T, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.super.unzip(asPair);
    }

    @Override
    public <B> IndexedSeq<B> map(Function1<T, B> f) {
        return (IndexedSeq)StrictOptimizedIterableOps.super.map(f);
    }

    @Override
    public <B> IndexedSeq<B> flatMap(Function1<T, IterableOnce<B>> f) {
        return (IndexedSeq)StrictOptimizedIterableOps.super.flatMap(f);
    }

    @Override
    public <B> IndexedSeq<B> collect(PartialFunction<T, B> pf) {
        return (IndexedSeq)StrictOptimizedIterableOps.super.collect(pf);
    }

    @Override
    public <B> IndexedSeq<B> flatten(Function1<T, IterableOnce<B>> toIterableOnce) {
        return (IndexedSeq)StrictOptimizedIterableOps.super.flatten(toIterableOnce);
    }

    @Override
    public <B> IndexedSeq<Tuple2<T, B>> zip(Iterable<B> that) {
        return (IndexedSeq)StrictOptimizedIterableOps.super.zip(that);
    }

    @Override
    public IndexedSeq<Tuple2<T, Object>> zipWithIndex() {
        return (IndexedSeq)StrictOptimizedIterableOps.super.zipWithIndex();
    }

    @Override
    public <B> IndexedSeq<B> scanLeft(B z, Function2<B, T, B> op) {
        return (IndexedSeq)StrictOptimizedIterableOps.super.scanLeft(z, op);
    }

    @Override
    public IndexedSeq<T> filter(Function1<T, Object> pred) {
        return (IndexedSeq)StrictOptimizedIterableOps.super.filter(pred);
    }

    @Override
    public IndexedSeq<T> filterNot(Function1<T, Object> pred) {
        return (IndexedSeq)StrictOptimizedIterableOps.super.filterNot(pred);
    }

    @Override
    public <B> IndexedSeq<T> distinctBy(Function1<T, B> f) {
        return (IndexedSeq)StrictOptimizedSeqOps.super.distinctBy(f);
    }

    @Override
    public <B> IndexedSeq<B> prepended(B elem) {
        return (IndexedSeq)StrictOptimizedSeqOps.super.prepended(elem);
    }

    @Override
    public <B> IndexedSeq<B> appended(B elem) {
        return (IndexedSeq)StrictOptimizedSeqOps.super.appended(elem);
    }

    @Override
    public <B> IndexedSeq<B> appendedAll(Iterable<B> suffix) {
        return (IndexedSeq)StrictOptimizedSeqOps.super.appendedAll(suffix);
    }

    @Override
    public <B> IndexedSeq<B> prependedAll(Iterable<B> prefix) {
        return (IndexedSeq)StrictOptimizedSeqOps.super.prependedAll(prefix);
    }

    @Override
    public <B> IndexedSeq<B> padTo(int len, B elem) {
        return (IndexedSeq)StrictOptimizedSeqOps.super.padTo(len, elem);
    }

    @Override
    public <B> IndexedSeq<B> updated(int index, B elem) {
        return (IndexedSeq)strawman.collection.immutable.StrictOptimizedSeqOps.super.updated(index, elem);
    }

    @Override
    public <B> IndexedSeq<B> patch(int from, IterableOnce<B> other, int replaced) {
        return (IndexedSeq)strawman.collection.immutable.StrictOptimizedSeqOps.super.patch(from, other, replaced);
    }

    public T start() {
        return (T)this.start;
    }

    public T end() {
        return (T)this.end;
    }

    public T step() {
        return (T)this.step;
    }

    public boolean isInclusive() {
        return this.isInclusive;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(this){
            private boolean _hasNext;
            private Object _next;
            private final Object lastElement;
            private final NumericRange $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this._hasNext = !this.strawman$collection$immutable$NumericRange$_$$anon$$$outer().isEmpty();
                this._next = this.strawman$collection$immutable$NumericRange$_$$anon$$$outer().start();
                this.lastElement = this._hasNext() ? this.strawman$collection$immutable$NumericRange$_$$anon$$$outer().last() : this.strawman$collection$immutable$NumericRange$_$$anon$$$outer().start();
            }

            private boolean _hasNext() {
                return this._hasNext;
            }

            private void _hasNext_$eq(boolean x$1) {
                this._hasNext = x$1;
            }

            private T _next() {
                return (T)this._next;
            }

            private void _next_$eq(T x$1) {
                this._next = x$1;
            }

            private T lastElement() {
                return (T)this.lastElement;
            }

            public boolean hasNext() {
                return this._hasNext();
            }

            /*
             * WARNING - void declaration
             */
            public T next() {
                void var1_1;
                T value;
                if (!this._hasNext()) {
                    Iterator$.MODULE$.empty().next();
                }
                this._hasNext_$eq(!BoxesRunTime.equals(value = this._next(), this.lastElement()));
                this._next_$eq(this.strawman$collection$immutable$NumericRange$_$$anon$$$outer().strawman$collection$immutable$NumericRange$$num.plus(value, this.strawman$collection$immutable$NumericRange$_$$anon$$$outer().step()));
                return var1_1;
            }

            private NumericRange<T> $outer() {
                return this.$outer;
            }

            public final NumericRange<T> strawman$collection$immutable$NumericRange$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    @Override
    public SeqFactory<IndexedSeq> iterableFactory() {
        return IndexedSeq$.MODULE$;
    }

    @Override
    public IndexedSeq<T> fromSpecificIterable(Iterable<T> it) {
        return (IndexedSeq)this.fromIterable(it);
    }

    @Override
    public Builder<T, IndexedSeq<T>> newSpecificBuilder() {
        return IndexedSeq$.MODULE$.newBuilder();
    }

    @Override
    public int length() {
        int n;
        if (this.lengthbitmap$1) {
            n = this.length$lzy1;
        } else {
            this.lengthbitmap$1 = true;
            n = this.length$lzy1 = NumericRange$.MODULE$.count(this.start(), this.end(), this.step(), this.isInclusive(), this.strawman$collection$immutable$NumericRange$$num);
        }
        return n;
    }

    @Override
    public int size() {
        return this.length();
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0;
    }

    @Override
    public T last() {
        if (this.length() == 0) {
            throw Nil$.MODULE$.head();
        }
        return this.locationAfterN(this.length() - 1);
    }

    @Override
    public NumericRange<T> init() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.init();
        }
        return new NumericRange<Object>(this.start(), this.strawman$collection$immutable$NumericRange$$num.mkNumericOps(this.end()).$minus(this.step()), this.step(), this.isInclusive(), this.strawman$collection$immutable$NumericRange$$num);
    }

    @Override
    public T head() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.head();
        }
        return this.start();
    }

    @Override
    public NumericRange<T> tail() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.tail();
        }
        return this.isInclusive() ? new Inclusive<Object>(this.strawman$collection$immutable$NumericRange$$num.mkNumericOps(this.start()).$plus(this.step()), this.end(), this.step(), this.strawman$collection$immutable$NumericRange$$num) : new Exclusive<Object>(this.strawman$collection$immutable$NumericRange$$num.mkNumericOps(this.start()).$plus(this.step()), this.end(), this.step(), this.strawman$collection$immutable$NumericRange$$num);
    }

    public NumericRange<T> by(T newStep) {
        return this.copy(this.start(), this.end(), newStep);
    }

    public NumericRange<T> copy(T start, T end, T step) {
        return new NumericRange<T>(start, end, step, this.isInclusive(), this.strawman$collection$immutable$NumericRange$$num);
    }

    @Override
    public T apply(int idx) {
        if (idx < 0 || idx >= this.length()) {
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)idx)).toString());
        }
        return this.locationAfterN(idx);
    }

    @Override
    public <U> void foreach(Function1<T, U> f) {
        Object current = this.start();
        for (int count = 0; count < this.length(); ++count) {
            f.apply(current);
            current = this.strawman$collection$immutable$NumericRange$$num.mkNumericOps(current).$plus(this.step());
        }
    }

    private boolean isWithinBoundaries(T elem) {
        return !this.isEmpty() && (this.strawman$collection$immutable$NumericRange$$num.mkOrderingOps(this.step()).$greater(this.strawman$collection$immutable$NumericRange$$num.zero()) && this.strawman$collection$immutable$NumericRange$$num.mkOrderingOps(this.start()).$less$eq(elem) && this.strawman$collection$immutable$NumericRange$$num.mkOrderingOps(elem).$less$eq(this.last()) || this.strawman$collection$immutable$NumericRange$$num.mkOrderingOps(this.step()).$less(this.strawman$collection$immutable$NumericRange$$num.zero()) && this.strawman$collection$immutable$NumericRange$$num.mkOrderingOps(this.last()).$less$eq(elem) && this.strawman$collection$immutable$NumericRange$$num.mkOrderingOps(elem).$less$eq(this.start()));
    }

    private T locationAfterN(int n) {
        return (T)this.strawman$collection$immutable$NumericRange$$num.mkNumericOps(this.start()).$plus(this.strawman$collection$immutable$NumericRange$$num.mkNumericOps(this.step()).$times(this.strawman$collection$immutable$NumericRange$$num.fromInt(n)));
    }

    private Exclusive<T> newEmptyRange(T value) {
        return NumericRange$.MODULE$.apply(value, value, this.step(), this.strawman$collection$immutable$NumericRange$$num);
    }

    @Override
    public NumericRange<T> take(int n) {
        return n <= 0 || this.length() == 0 ? this.newEmptyRange(this.start()) : (n >= this.length() ? this : new Inclusive<T>(this.start(), this.locationAfterN(n - 1), this.step(), this.strawman$collection$immutable$NumericRange$$num));
    }

    @Override
    public NumericRange<T> drop(int n) {
        return n <= 0 || this.length() == 0 ? this : (n >= this.length() ? this.newEmptyRange(this.end()) : ((NumericRange)this).copy(super.locationAfterN(n), this.end(), this.step()));
    }

    @Override
    public Tuple2<NumericRange<T>, NumericRange<T>> splitAt(int n) {
        return Tuple2$.MODULE$.apply(this.take(n), this.drop(n));
    }

    @Override
    public NumericRange<T> reverse() {
        return this.isEmpty() ? this : new Inclusive<Object>(this.last(), this.start(), this.strawman$collection$immutable$NumericRange$$num.mkNumericOps(this.step()).unary_$minus(), this.strawman$collection$immutable$NumericRange$$num);
    }

    @Override
    public <T1> T min(Ordering<T1> ord) {
        return (T)(ord == this.strawman$collection$immutable$NumericRange$$num || NumericRange$.MODULE$.defaultOrdering().get((Numeric<?>)this.strawman$collection$immutable$NumericRange$$num).exists((Function1)((JFunction1)arg_0 -> NumericRange.min$$anonfun$1(ord, arg_0))) ? (this.strawman$collection$immutable$NumericRange$$num.signum(this.step()) > 0 ? this.head() : this.last()) : IterableOps.super.min(ord));
    }

    @Override
    public <T1> T max(Ordering<T1> ord) {
        return (T)(ord == this.strawman$collection$immutable$NumericRange$$num || NumericRange$.MODULE$.defaultOrdering().get((Numeric<?>)this.strawman$collection$immutable$NumericRange$$num).exists((Function1)((JFunction1)arg_0 -> NumericRange.max$$anonfun$1(ord, arg_0))) ? (this.strawman$collection$immutable$NumericRange$$num.signum(this.step()) > 0 ? this.last() : this.head()) : IterableOps.super.max(ord));
    }

    public <A> NumericRange<A> mapRange(Function1<T, A> fm, Integral<A> unum) {
        NumericRange self = this;
        return new NumericRange<A>(fm, unum, self, this){
            private NumericRange underlyingRange$lzy1;
            private boolean underlyingRangebitmap$1;
            private final NumericRange $outer;
            private final Function1 fm$1;
            private final NumericRange self$1;
            {
                this.fm$1 = fm$1;
                this.self$1 = self$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.strawman$collection$immutable$NumericRange$$_$$anon$superArg$3$1(fm$1), $outer.strawman$collection$immutable$NumericRange$$_$$anon$superArg$4$1(fm$1), $outer.strawman$collection$immutable$NumericRange$$_$$anon$superArg$5$1(fm$1), $outer.strawman$collection$immutable$NumericRange$$_$$anon$superArg$6$1(), unum$1);
            }

            private NumericRange<T> underlyingRange() {
                NumericRange numericRange;
                if (this.underlyingRangebitmap$1) {
                    numericRange = this.underlyingRange$lzy1;
                } else {
                    this.underlyingRangebitmap$1 = true;
                    numericRange = this.underlyingRange$lzy1 = this.self$1;
                }
                return numericRange;
            }

            public <U> void foreach(Function1<A, U> f) {
                this.underlyingRange().foreach(arg_0 -> this.foreach$$anonfun$1(f, arg_0));
            }

            public boolean isEmpty() {
                return this.underlyingRange().isEmpty();
            }

            public A apply(int idx) {
                return (A)this.fm$1.apply(this.underlyingRange().apply(idx));
            }

            public boolean containsTyped(A el) {
                return this.underlyingRange().exists(arg_0 -> this.containsTyped$$anonfun$1(el, arg_0));
            }

            public String toString() {
                String stepped = this.simpleOf$1(this.underlyingRange().step());
                return StringContext$.MODULE$.apply((scala.collection.Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (using ", " of ", ")"})).s((scala.collection.Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{super.toString(), this.underlyingRange(), stepped}));
            }

            private NumericRange<T> $outer() {
                return this.$outer;
            }

            public final NumericRange<T> strawman$collection$immutable$NumericRange$_$$anon$$$outer() {
                return this.$outer();
            }

            private U foreach$$anonfun$1(Function1 f$59, T x) {
                return (U)f$59.apply(this.fm$1.apply(x));
            }

            private boolean containsTyped$$anonfun$1(Object el$1, T x) {
                return BoxesRunTime.equals((Object)this.fm$1.apply(x), (Object)el$1);
            }

            private String simpleOf$1(Object x) {
                return (String)new ArrayOps(package$.MODULE$.arrayToArrayOps(x.getClass().getName().split("\\."))).last();
            }
        };
    }

    public boolean containsTyped(T x) {
        return this.isWithinBoundaries(x) && BoxesRunTime.equals((Object)this.strawman$collection$immutable$NumericRange$$num.mkNumericOps(this.strawman$collection$immutable$NumericRange$$num.mkNumericOps(x).$minus(this.start())).$percent(this.step()), (Object)this.strawman$collection$immutable$NumericRange$$num.zero());
    }

    @Override
    public <A1> boolean contains(A1 x) {
        boolean bl;
        try {
            bl = this.containsTyped(x);
        }
        catch (ClassCastException classCastException) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public <B> B sum(Numeric<B> num) {
        Object object;
        block23: {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                if (this.isEmpty()) {
                                    object = num.zero();
                                    return (B)object;
                                }
                                if (this.size() == 1) {
                                    object = this.head();
                                    return (B)object;
                                }
                                if (num == Numeric.IntIsIntegral$.MODULE$) break block18;
                                if (num == Numeric.ShortIsIntegral$.MODULE$) break block18;
                                if (num == Numeric.ByteIsIntegral$.MODULE$) break block18;
                                if (num != Numeric.CharIsIntegral$.MODULE$) break block19;
                            }
                            long exact = (long)this.size() * (num.toLong(this.head()) + (long)num.toInt(this.last())) / 2L;
                            object = num.fromInt((int)exact);
                            return (B)object;
                        }
                        if (num == Numeric.LongIsIntegral$.MODULE$) {
                            long l;
                            long a = this.strawman$collection$immutable$NumericRange$$num.mkNumericOps(this.head()).toLong();
                            long b = this.strawman$collection$immutable$NumericRange$$num.mkNumericOps(this.last()).toLong();
                            if ((this.size() & 1) == 0) {
                                l = (long)(this.size() / 2) * (a + b);
                            } else {
                                long ha = a / 2L;
                                long hb = b / 2L;
                                l = (long)this.size() * (ha + hb + (a - 2L * ha + (b - 2L * hb)) / 2L);
                            }
                            long ans = l;
                            object = BoxesRunTime.boxToLong((long)ans);
                            return (B)object;
                        }
                        if (num == Numeric.FloatAsIfIntegral$.MODULE$) break block20;
                        if (num != Numeric.DoubleAsIfIntegral$.MODULE$) break block21;
                    }
                    Integral numAsIntegral = (Integral)num;
                    double a = scala.math.package$.MODULE$.abs(numAsIntegral.mkNumericOps(this.head()).toDouble());
                    double b = scala.math.package$.MODULE$.abs(numAsIntegral.mkNumericOps(this.last()).toDouble());
                    Object two = num.fromInt(2);
                    Object nre = num.fromInt(this.size());
                    if (!(a > 1.0E38) && b <= 1.0E38) {
                        object = numAsIntegral.mkNumericOps(numAsIntegral.mkNumericOps(nre).$div(two)).$times(numAsIntegral.mkNumericOps(this.head()).$plus(this.last()));
                        return (B)object;
                    }
                    object = numAsIntegral.mkNumericOps(nre).$times(numAsIntegral.mkNumericOps(numAsIntegral.mkNumericOps(this.head()).$div(two)).$plus(numAsIntegral.mkNumericOps(this.last()).$div(two)));
                    return (B)object;
                }
                if (num == Numeric.BigIntIsIntegral$.MODULE$) break block22;
                if (num != Numeric.BigDecimalIsFractional$.MODULE$) break block23;
            }
            Integral numAsIntegral = (Integral)num;
            object = numAsIntegral.mkNumericOps(numAsIntegral.mkNumericOps(num.fromInt(this.size())).$times(numAsIntegral.mkNumericOps(this.head()).$plus(this.last()))).$div(num.fromInt(2));
            return (B)object;
        }
        if (this.isEmpty()) {
            object = num.zero();
            return (B)object;
        }
        Object acc = num.zero();
        T t = this.head();
        int idx = 0;
        while (true) {
            void var23_16;
            if (idx >= this.length()) {
                object = acc;
                return (B)object;
            }
            acc = num.plus(acc, (Object)var23_16);
            Object object2 = this.strawman$collection$immutable$NumericRange$$num.mkNumericOps((Object)var23_16).$plus(this.step());
            ++idx;
        }
    }

    @Override
    public int hashCode() {
        int n;
        if (this.hashCodebitmap$1) {
            n = this.hashCode$lzy1;
        } else {
            this.hashCodebitmap$1 = true;
            n = this.hashCode$lzy1 = Seq.super.hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object other) {
        NumericRange numericRange;
        NumericRange x;
        Object object = other;
        return object instanceof NumericRange ? (x = (numericRange = (NumericRange)object)).canEqual(this) && this.length() == x.length() && (this.length() == 0 || BoxesRunTime.equals(this.start(), x.start()) && BoxesRunTime.equals(this.last(), x.last())) : Seq.super.equals(other);
    }

    @Override
    public String toString() {
        String empty = this.isEmpty() ? "empty " : "";
        String preposition = this.isInclusive() ? "to" : "until";
        String stepped = BoxesRunTime.equals(this.step(), (Object)BoxesRunTime.boxToInteger((int)1)) ? "" : StringContext$.MODULE$.apply((scala.collection.Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" by ", ""})).s((scala.collection.Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.step()}));
        return StringContext$.MODULE$.apply((scala.collection.Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "NumericRange ", " ", " ", "", ""})).s((scala.collection.Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{empty, this.start(), preposition, this.end(), stepped}));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private static boolean min$$anonfun$1(Ordering ord$3, Ordering _$78) {
        return ord$3 == _$78;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private static boolean max$$anonfun$1(Ordering ord$4, Ordering _$79) {
        return ord$4 == _$79;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public Object strawman$collection$immutable$NumericRange$$_$$anon$superArg$3$1(Function1 fm$3) {
        return fm$3.apply(this.start());
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public Object strawman$collection$immutable$NumericRange$$_$$anon$superArg$4$1(Function1 fm$4) {
        return fm$4.apply(this.end());
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public Object strawman$collection$immutable$NumericRange$$_$$anon$superArg$5$1(Function1 fm$5) {
        return fm$5.apply(this.step());
    }

    public boolean strawman$collection$immutable$NumericRange$$_$$anon$superArg$6$1() {
        return this.isInclusive();
    }

    public static class Exclusive<T>
    extends NumericRange<T> {
        private final T start;
        private final T end;
        private final T step;
        private final Integral<T> num;

        public <T> Exclusive(T start, T end, T step, Integral<T> num) {
            this.start = start;
            this.end = end;
            this.step = step;
            this.num = num;
            super(start, end, step, false, num);
        }

        @Override
        public Exclusive<T> copy(T start, T end, T step) {
            return NumericRange$.MODULE$.apply(start, end, step, this.num);
        }

        public Inclusive<T> inclusive() {
            return NumericRange$.MODULE$.inclusive(this.start, this.end, this.step, this.num);
        }
    }

    public static class Inclusive<T>
    extends NumericRange<T> {
        private final T start;
        private final T end;
        private final T step;
        private final Integral<T> num;

        public <T> Inclusive(T start, T end, T step, Integral<T> num) {
            this.start = start;
            this.end = end;
            this.step = step;
            this.num = num;
            super(start, end, step, true, num);
        }

        @Override
        public Inclusive<T> copy(T start, T end, T step) {
            return NumericRange$.MODULE$.inclusive(start, end, step, this.num);
        }

        public Exclusive<T> exclusive() {
            return NumericRange$.MODULE$.apply(this.start, this.end, this.step, this.num);
        }
    }
}

