/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.immutable;

import java.util.NoSuchElementException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import strawman.collection.Iterator;
import strawman.collection.immutable.RedBlackTree;
import strawman.collection.immutable.RedBlackTree$BlackTree$;
import strawman.collection.immutable.RedBlackTree$NList$;
import strawman.collection.immutable.RedBlackTree$RedTree$;

public final class RedBlackTree$ {
    public static final RedBlackTree$ MODULE$;
    private final RedBlackTree$NList$ NList;
    public final RedBlackTree$RedTree$ RedTree;
    public final RedBlackTree$BlackTree$ BlackTree;

    static {
        new RedBlackTree$();
    }

    public RedBlackTree$() {
        MODULE$ = this;
    }

    public boolean isEmpty(RedBlackTree.Tree<?, ?> tree) {
        return tree == null;
    }

    public <A> boolean contains(RedBlackTree.Tree<A, ?> tree, A x, Ordering<A> evidence$44) {
        return this.lookup(tree, x, evidence$44) != null;
    }

    public <A, B> Option<B> get(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> evidence$45) {
        None$ none$;
        RedBlackTree.Tree<A, B> tree2 = this.lookup(tree, x, evidence$45);
        if (tree2 == null) {
            none$ = None$.MODULE$;
        } else {
            RedBlackTree.Tree<A, B> tree3 = tree2;
            none$ = Some$.MODULE$.apply(tree3.value());
        }
        return none$;
    }

    /*
     * Enabled aggressive block sorting
     */
    public <A, B> RedBlackTree.Tree<A, B> lookup(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> ordering) {
        Ordering<A> ordering2 = ordering;
        A a = x;
        RedBlackTree.Tree<A, B> tree2 = tree;
        RedBlackTree$ redBlackTree$ = this;
        while (tree2 != null) {
            int cmp = ordering2.compare(a, tree2.key());
            if (cmp < 0) {
                tree2 = tree2.left();
                continue;
            }
            if (cmp <= 0) {
                RedBlackTree.Tree<A, B> tree3 = tree2;
                return tree3;
            }
            tree2 = tree2.right();
        }
        return null;
    }

    public int count(RedBlackTree.Tree<?, ?> tree) {
        return tree == null ? 0 : tree.count();
    }

    /*
     * Enabled aggressive block sorting
     */
    public <A> int countInRange(RedBlackTree.Tree<A, ?> tree, Option<A> from, Option<A> to, Ordering<A> ordering) {
        int n;
        Ordering<A> ordering2 = ordering;
        Option<A> option = to;
        Option<A> option2 = from;
        RedBlackTree.Tree<A, ?> tree2 = tree;
        RedBlackTree$ redBlackTree$ = this;
        while (true) {
            Option option3;
            Option option4;
            if (tree2 == null) {
                return 0;
            }
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(option2, option);
            if (tuple2 == null) break;
            Option option5 = (Option)tuple2._1();
            if (None$.MODULE$.equals(option5)) {
                if (None$.MODULE$.equals(tuple2._2())) {
                    n = tree2.count();
                    return n;
                }
                option4 = option5;
            } else {
                option4 = option5;
            }
            if (option4 instanceof Some) {
                Some some = (Some)option4;
                Object lb = some.value();
                if (ordering2.lt(tree2.key(), lb)) {
                    tree2 = tree2.right();
                    continue;
                }
            }
            if (!((option3 = (Option)tuple2._2()) instanceof Some)) break;
            Some some = (Some)option3;
            Object ub = some.value();
            if (!ordering2.gteq(tree2.key(), ub)) break;
            tree2 = tree2.left();
        }
        n = 1 + this.countInRange(tree2.left(), option2, (Option<A>)None$.MODULE$, ordering2) + this.countInRange(tree2.right(), (Option<A>)None$.MODULE$, option, ordering2);
        return n;
    }

    public <A, B, B1> RedBlackTree.Tree<A, B1> update(RedBlackTree.Tree<A, B> tree, A k, B1 v, boolean overwrite, Ordering<A> evidence$46) {
        return this.blacken(this.upd(tree, k, v, overwrite, evidence$46));
    }

    public <A, B> RedBlackTree.Tree<A, B> delete(RedBlackTree.Tree<A, B> tree, A k, Ordering<A> evidence$47) {
        return this.blacken(this.del(tree, k, evidence$47));
    }

    /*
     * Enabled aggressive block sorting
     */
    public <A, B> RedBlackTree.Tree<A, B> rangeImpl(RedBlackTree.Tree<A, B> tree, Option<A> from, Option<A> until, Ordering<A> evidence$48) {
        Option option;
        Option option2;
        Option option3;
        RedBlackTree.Tree<Object, B> tree2;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(from, until);
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Option option4 = (Option)tuple2._1();
        if (option4 instanceof Some) {
            Some some = (Some)option4;
            Object from2 = some.value();
            Option option5 = (Option)tuple2._2();
            if (option5 instanceof Some) {
                Some some2 = (Some)option5;
                Object until2 = some2.value();
                tree2 = this.range(tree, from2, until2, evidence$48);
                return tree2;
            }
            option3 = option4;
        } else {
            option3 = option4;
        }
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            Object from3 = some.value();
            if (None$.MODULE$.equals(tuple2._2())) {
                tree2 = this.from(tree, from3, evidence$48);
                return tree2;
            }
            option2 = option3;
        } else {
            option2 = option3;
        }
        if (None$.MODULE$.equals(option2)) {
            Option option6 = (Option)tuple2._2();
            if (option6 instanceof Some) {
                Some some = (Some)option6;
                Object until3 = some.value();
                tree2 = this.until(tree, until3, evidence$48);
                return tree2;
            }
            option = option2;
        } else {
            option = option2;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
        if (!None$.MODULE$.equals(tuple2._2())) throw new MatchError((Object)tuple2);
        tree2 = tree;
        return tree2;
    }

    public <A, B> RedBlackTree.Tree<A, B> range(RedBlackTree.Tree<A, B> tree, A from, A until, Ordering<A> evidence$49) {
        return this.blacken(this.doRange(tree, from, until, evidence$49));
    }

    public <A, B> RedBlackTree.Tree<A, B> from(RedBlackTree.Tree<A, B> tree, A from, Ordering<A> evidence$50) {
        return this.blacken(this.doFrom(tree, from, evidence$50));
    }

    public <A, B> RedBlackTree.Tree<A, B> to(RedBlackTree.Tree<A, B> tree, A to, Ordering<A> evidence$51) {
        return this.blacken(this.doTo(tree, to, evidence$51));
    }

    public <A, B> RedBlackTree.Tree<A, B> until(RedBlackTree.Tree<A, B> tree, A key, Ordering<A> evidence$52) {
        return this.blacken(this.doUntil(tree, key, evidence$52));
    }

    public <A, B> RedBlackTree.Tree<A, B> drop(RedBlackTree.Tree<A, B> tree, int n, Ordering<A> evidence$53) {
        return this.blacken(this.doDrop(tree, n));
    }

    public <A, B> RedBlackTree.Tree<A, B> take(RedBlackTree.Tree<A, B> tree, int n, Ordering<A> evidence$54) {
        return this.blacken(this.doTake(tree, n));
    }

    public <A, B> RedBlackTree.Tree<A, B> slice(RedBlackTree.Tree<A, B> tree, int from, int until, Ordering<A> evidence$55) {
        return this.blacken(this.doSlice(tree, from, until));
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> RedBlackTree.Tree<A, B> smallest(RedBlackTree.Tree<A, B> tree) {
        void var2_2;
        if (tree == null) {
            throw new NoSuchElementException("empty map");
        }
        RedBlackTree.Tree<A, B> result = tree;
        while (result.left() != null) {
            result = result.left();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> RedBlackTree.Tree<A, B> greatest(RedBlackTree.Tree<A, B> tree) {
        void var2_2;
        if (tree == null) {
            throw new NoSuchElementException("empty map");
        }
        RedBlackTree.Tree<A, B> result = tree;
        while (result.right() != null) {
            result = result.right();
        }
        return var2_2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public <A, B> RedBlackTree.Tree<A, B> minAfter(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> ordering) {
        Ordering<A> ordering2 = ordering;
        A a = x;
        RedBlackTree.Tree<A, B> tree2 = tree;
        RedBlackTree$ redBlackTree$ = this;
        while (tree2 != null) {
            RedBlackTree.Tree<A, B> tree3;
            int cmp = ordering2.compare(a, tree2.key());
            if (cmp == 0) {
                tree3 = tree2;
                return tree3;
            }
            if (cmp < 0) {
                RedBlackTree.Tree<A, B> l = this.minAfter(tree2.left(), a, ordering2);
                if (l != null) {
                    tree3 = l;
                    return tree3;
                }
                tree3 = tree2;
                return tree3;
            }
            tree2 = tree2.right();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public <A, B> RedBlackTree.Tree<A, B> maxBefore(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> ordering) {
        RedBlackTree.Tree<A, B> tree2;
        Ordering<A> ordering2 = ordering;
        A a = x;
        RedBlackTree.Tree<A, B> tree3 = tree;
        RedBlackTree$ redBlackTree$ = this;
        while (true) {
            if (tree3 == null) {
                return null;
            }
            int cmp = ordering2.compare(a, tree3.key());
            if (cmp > 0) break;
            tree3 = tree3.left();
        }
        RedBlackTree.Tree<A, B> r = this.maxBefore(tree3.right(), a, ordering2);
        if (r != null) {
            tree2 = r;
            return tree2;
        }
        tree2 = tree3;
        return tree2;
    }

    public <A, B, U> void foreach(RedBlackTree.Tree<A, B> tree, Function1<Tuple2<A, B>, U> f) {
        block0: {
            if (tree == null) break block0;
            this._foreach(tree, f);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private <A, B, U> void _foreach(RedBlackTree.Tree<A, B> tree, Function1<Tuple2<A, B>, U> f) {
        Function1<Tuple2<A, B>, U> function1 = f;
        RedBlackTree.Tree<A, B> tree2 = tree;
        RedBlackTree$ redBlackTree$ = this;
        while (true) {
            if (tree2.left() != null) {
                this._foreach(tree2.left(), function1);
            }
            function1.apply((Object)Tuple2$.MODULE$.apply(tree2.key(), tree2.value()));
            if (tree2.right() == null) {
                return;
            }
            tree2 = tree2.right();
        }
    }

    public <A, U> void foreachKey(RedBlackTree.Tree<A, ?> tree, Function1<A, U> f) {
        block0: {
            if (tree == null) break block0;
            this._foreachKey(tree, f);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private <A, U> void _foreachKey(RedBlackTree.Tree<A, ?> tree, Function1<A, U> f) {
        Function1<A, U> function1 = f;
        RedBlackTree.Tree<A, ?> tree2 = tree;
        RedBlackTree$ redBlackTree$ = this;
        while (true) {
            if (tree2.left() != null) {
                this._foreachKey(tree2.left(), function1);
            }
            function1.apply(tree2.key());
            if (tree2.right() == null) {
                return;
            }
            tree2 = tree2.right();
        }
    }

    public <A, B> Iterator<Tuple2<A, B>> iterator(RedBlackTree.Tree<A, B> tree, Option<A> start, Ordering<A> evidence$56) {
        return new RedBlackTree.EntriesIterator<A, B>(tree, start, evidence$56);
    }

    public <A, B> None$ iterator$default$2() {
        return None$.MODULE$;
    }

    public <A> Iterator<A> keysIterator(RedBlackTree.Tree<A, ?> tree, Option<A> start, Ordering<A> evidence$57) {
        return new RedBlackTree.KeysIterator(tree, start, evidence$57);
    }

    public <A> None$ keysIterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> Iterator<B> valuesIterator(RedBlackTree.Tree<A, B> tree, Option<A> start, Ordering<A> evidence$58) {
        return new RedBlackTree.ValuesIterator<A, B>(tree, start, evidence$58);
    }

    public <A, B> None$ valuesIterator$default$2() {
        return None$.MODULE$;
    }

    /*
     * Enabled aggressive block sorting
     */
    public <A, B> RedBlackTree.Tree<A, B> nth(RedBlackTree.Tree<A, B> tree, int n) {
        int n2 = n;
        RedBlackTree.Tree<A, B> tree2 = tree;
        RedBlackTree$ redBlackTree$ = this;
        while (true) {
            int count;
            if (n2 < (count = redBlackTree$.count(tree2.left()))) {
                tree2 = tree2.left();
                continue;
            }
            if (n2 <= count) {
                return tree2;
            }
            n2 = n2 - count - 1;
            tree2 = tree2.right();
        }
    }

    public boolean isBlack(RedBlackTree.Tree<?, ?> tree) {
        return tree == null || this.isBlackTree(tree);
    }

    private boolean isRedTree(RedBlackTree.Tree<?, ?> tree) {
        return tree instanceof RedBlackTree.RedTree;
    }

    private boolean isBlackTree(RedBlackTree.Tree<?, ?> tree) {
        return tree instanceof RedBlackTree.BlackTree;
    }

    private <A, B> RedBlackTree.Tree<A, B> blacken(RedBlackTree.Tree<A, B> t) {
        return t == null ? null : t.black();
    }

    private <A, B> RedBlackTree.Tree<A, B> mkTree(boolean isBlack, A k, B v, RedBlackTree.Tree<A, B> l, RedBlackTree.Tree<A, B> r) {
        return isBlack ? new RedBlackTree.BlackTree<A, B>(k, v, l, r) : new RedBlackTree.RedTree<A, B>(k, v, l, r);
    }

    private <A, B, B1> RedBlackTree.Tree<A, B1> balanceLeft(boolean isBlack, A z, B zv, RedBlackTree.Tree<A, B1> l, RedBlackTree.Tree<A, B1> d) {
        RedBlackTree.RedTree<A, B1> redTree;
        if (this.isRedTree(l) && this.isRedTree(l.left())) {
            RedBlackTree.BlackTree<A, B1> left = new RedBlackTree.BlackTree<A, B1>(l.left().key(), l.left().value(), l.left().left(), l.left().right());
            RedBlackTree.BlackTree<A, B> right = new RedBlackTree.BlackTree<A, B>(z, zv, l.right(), d);
            redTree = new RedBlackTree.RedTree<A, B1>(l.key(), l.value(), left, right);
        } else if (this.isRedTree(l) && this.isRedTree(l.right())) {
            RedBlackTree.BlackTree<A, B1> left = new RedBlackTree.BlackTree<A, B1>(l.key(), l.value(), l.left(), l.right().left());
            RedBlackTree.BlackTree<A, B> right = new RedBlackTree.BlackTree<A, B>(z, zv, l.right().right(), d);
            redTree = new RedBlackTree.RedTree<A, B1>(l.right().key(), l.right().value(), left, right);
        } else {
            redTree = this.mkTree(isBlack, z, zv, l, d);
        }
        return redTree;
    }

    private <A, B, B1> RedBlackTree.Tree<A, B1> balanceRight(boolean isBlack, A x, B xv, RedBlackTree.Tree<A, B1> a, RedBlackTree.Tree<A, B1> r) {
        RedBlackTree.RedTree<A, B1> redTree;
        if (this.isRedTree(r) && this.isRedTree(r.left())) {
            RedBlackTree.BlackTree<A, B> left = new RedBlackTree.BlackTree<A, B>(x, xv, a, r.left().left());
            RedBlackTree.BlackTree<A, B1> right = new RedBlackTree.BlackTree<A, B1>(r.key(), r.value(), r.left().right(), r.right());
            redTree = new RedBlackTree.RedTree<A, B1>(r.left().key(), r.left().value(), left, right);
        } else if (this.isRedTree(r) && this.isRedTree(r.right())) {
            RedBlackTree.BlackTree<A, B> left = new RedBlackTree.BlackTree<A, B>(x, xv, a, r.left());
            RedBlackTree.BlackTree<A, B1> right = new RedBlackTree.BlackTree<A, B1>(r.right().key(), r.right().value(), r.right().left(), r.right().right());
            redTree = new RedBlackTree.RedTree<A, B1>(r.key(), r.value(), left, right);
        } else {
            redTree = this.mkTree(isBlack, x, xv, a, r);
        }
        return redTree;
    }

    private <A, B, B1> RedBlackTree.Tree<A, B1> upd(RedBlackTree.Tree<A, B> tree, A k, B1 v, boolean overwrite, Ordering<A> ordering) {
        RedBlackTree.Tree tree2;
        if (tree == null) {
            Object left = null;
            Object right = null;
            tree2 = new RedBlackTree.RedTree<A, B1>(k, v, null, null);
        } else {
            int cmp = ordering.compare(k, tree.key());
            tree2 = cmp < 0 ? this.balanceLeft(this.isBlackTree(tree), tree.key(), tree.value(), this.upd(tree.left(), k, v, overwrite, ordering), tree.right()) : (cmp > 0 ? this.balanceRight(this.isBlackTree(tree), tree.key(), tree.value(), tree.left(), this.upd(tree.right(), k, v, overwrite, ordering)) : (overwrite || !BoxesRunTime.equals(k, tree.key()) ? this.mkTree(this.isBlackTree(tree), k, v, tree.left(), tree.right()) : tree));
        }
        return tree2;
    }

    private <A, B, B1> RedBlackTree.Tree<A, B1> updNth(RedBlackTree.Tree<A, B> tree, int idx, A k, B1 v, boolean overwrite) {
        RedBlackTree.Tree tree2;
        if (tree == null) {
            Object left = null;
            Object right = null;
            tree2 = new RedBlackTree.RedTree<A, B1>(k, v, null, null);
        } else {
            int rank = this.count(tree.left()) + 1;
            tree2 = idx < rank ? this.balanceLeft(this.isBlackTree(tree), tree.key(), tree.value(), this.updNth(tree.left(), idx, k, v, overwrite), tree.right()) : (idx > rank ? this.balanceRight(this.isBlackTree(tree), tree.key(), tree.value(), tree.left(), this.updNth(tree.right(), idx - rank, k, v, overwrite)) : (overwrite ? this.mkTree(this.isBlackTree(tree), k, v, tree.left(), tree.right()) : tree));
        }
        return tree2;
    }

    private <A, B> RedBlackTree.Tree<A, B> del(RedBlackTree.Tree<A, B> tree, A k, Ordering<A> ordering) {
        int cmp;
        return tree == null ? null : ((cmp = ordering.compare(k, tree.key())) < 0 ? this.delLeft$1(tree, k, ordering) : (cmp > 0 ? this.delRight$1(tree, k, ordering) : this.append$1(tree.left(), tree.right())));
    }

    private <A, B> RedBlackTree.Tree<A, B> doFrom(RedBlackTree.Tree<A, B> tree, A from, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lt(tree.key(), from)) {
            return this.doFrom(tree.right(), from, ordering);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doFrom(tree.left(), from, ordering);
        return newLeft == tree.left() ? tree : (newLeft == null ? this.upd(tree.right(), tree.key(), tree.value(), false, ordering) : this.rebalance(tree, newLeft, tree.right()));
    }

    private <A, B> RedBlackTree.Tree<A, B> doTo(RedBlackTree.Tree<A, B> tree, A to, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lt(to, tree.key())) {
            return this.doTo(tree.left(), to, ordering);
        }
        RedBlackTree.Tree<A, B> newRight = this.doTo(tree.right(), to, ordering);
        return newRight == tree.right() ? tree : (newRight == null ? this.upd(tree.left(), tree.key(), tree.value(), false, ordering) : this.rebalance(tree, tree.left(), newRight));
    }

    private <A, B> RedBlackTree.Tree<A, B> doUntil(RedBlackTree.Tree<A, B> tree, A until, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lteq(until, tree.key())) {
            return this.doUntil(tree.left(), until, ordering);
        }
        RedBlackTree.Tree<A, B> newRight = this.doUntil(tree.right(), until, ordering);
        return newRight == tree.right() ? tree : (newRight == null ? this.upd(tree.left(), tree.key(), tree.value(), false, ordering) : this.rebalance(tree, tree.left(), newRight));
    }

    private <A, B> RedBlackTree.Tree<A, B> doRange(RedBlackTree.Tree<A, B> tree, A from, A until, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lt(tree.key(), from)) {
            return this.doRange(tree.right(), from, until, ordering);
        }
        if (ordering.lteq(until, tree.key())) {
            return this.doRange(tree.left(), from, until, ordering);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doFrom(tree.left(), from, ordering);
        RedBlackTree.Tree<A, B> newRight = this.doUntil(tree.right(), until, ordering);
        return newLeft == tree.left() && newRight == tree.right() ? tree : (newLeft == null ? this.upd(newRight, tree.key(), tree.value(), false, ordering) : (newRight == null ? this.upd(newLeft, tree.key(), tree.value(), false, ordering) : this.rebalance(tree, newLeft, newRight)));
    }

    private <A, B> RedBlackTree.Tree<A, B> doDrop(RedBlackTree.Tree<A, B> tree, int n) {
        if (n <= 0) {
            return tree;
        }
        if (n >= this.count(tree)) {
            return null;
        }
        int count = this.count(tree.left());
        if (n > count) {
            return this.doDrop(tree.right(), n - count - 1);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doDrop(tree.left(), n);
        return newLeft == tree.left() ? tree : (newLeft == null ? this.updNth(tree.right(), n - count - 1, tree.key(), tree.value(), false) : this.rebalance(tree, newLeft, tree.right()));
    }

    private <A, B> RedBlackTree.Tree<A, B> doTake(RedBlackTree.Tree<A, B> tree, int n) {
        if (n <= 0) {
            return null;
        }
        if (n >= this.count(tree)) {
            return tree;
        }
        int count = this.count(tree.left());
        if (n <= count) {
            return this.doTake(tree.left(), n);
        }
        RedBlackTree.Tree<A, B> newRight = this.doTake(tree.right(), n - count - 1);
        return newRight == tree.right() ? tree : (newRight == null ? this.updNth(tree.left(), n, tree.key(), tree.value(), false) : this.rebalance(tree, tree.left(), newRight));
    }

    private <A, B> RedBlackTree.Tree<A, B> doSlice(RedBlackTree.Tree<A, B> tree, int from, int until) {
        if (tree == null) {
            return null;
        }
        int count = this.count(tree.left());
        if (from > count) {
            return this.doSlice(tree.right(), from - count - 1, until - count - 1);
        }
        if (until <= count) {
            return this.doSlice(tree.left(), from, until);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doDrop(tree.left(), from);
        RedBlackTree.Tree<A, B> newRight = this.doTake(tree.right(), until - count - 1);
        return newLeft == tree.left() && newRight == tree.right() ? tree : (newLeft == null ? this.updNth(newRight, from - count - 1, tree.key(), tree.value(), false) : (newRight == null ? this.updNth(newLeft, until, tree.key(), tree.value(), false) : this.rebalance(tree, newLeft, newRight)));
    }

    private <A, B> Tuple4<RedBlackTree.NList<RedBlackTree.Tree<A, B>>, Object, Object, Object> compareDepth(RedBlackTree.Tree<A, B> left, RedBlackTree.Tree<A, B> right) {
        return this.unzipBoth$1(left, right, null, null, 0);
    }

    private <A, B> RedBlackTree.Tree<A, B> rebalance(RedBlackTree.Tree<A, B> tree, RedBlackTree.Tree<A, B> newLeft, RedBlackTree.Tree<A, B> newRight) {
        RedBlackTree.Tree tree2;
        RedBlackTree.Tree<A, B> blkNewRight;
        RedBlackTree.Tree<A, B> blkNewLeft = this.blacken(newLeft);
        Tuple4<RedBlackTree.NList<RedBlackTree.Tree<A, B>>, Object, Object, Object> tuple4 = this.compareDepth(blkNewLeft, blkNewRight = this.blacken(newRight));
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        RedBlackTree.NList zipper = (RedBlackTree.NList)tuple4._1();
        boolean levelled = BoxesRunTime.unboxToBoolean((Object)tuple4._2());
        boolean leftMost = BoxesRunTime.unboxToBoolean((Object)tuple4._3());
        int smallerDepth = BoxesRunTime.unboxToInt((Object)tuple4._4());
        Tuple4 tuple42 = Tuple4$.MODULE$.apply((Object)zipper, (Object)BoxesRunTime.boxToBoolean((boolean)levelled), (Object)BoxesRunTime.boxToBoolean((boolean)leftMost), (Object)BoxesRunTime.boxToInteger((int)smallerDepth));
        RedBlackTree.NList zipper2 = (RedBlackTree.NList)tuple42._1();
        boolean levelled2 = BoxesRunTime.unboxToBoolean((Object)tuple42._2());
        boolean leftMost2 = BoxesRunTime.unboxToBoolean((Object)tuple42._3());
        int smallerDepth2 = BoxesRunTime.unboxToInt((Object)tuple42._4());
        if (levelled2) {
            tree2 = new RedBlackTree.BlackTree<A, B>(tree.key(), tree.value(), blkNewLeft, blkNewRight);
        } else {
            RedBlackTree.NList<RedBlackTree.Tree<A, B>> zipFrom = this.findDepth$1(zipper2, smallerDepth2);
            RedBlackTree.RedTree<A, B> union = leftMost2 ? new RedBlackTree.RedTree<A, B>(tree.key(), tree.value(), blkNewLeft, zipFrom.head()) : new RedBlackTree.RedTree<A, B>(tree.key(), tree.value(), zipFrom.head(), blkNewRight);
            RedBlackTree.Tree zippedTree = RedBlackTree$NList$.MODULE$.foldLeft(zipFrom.tail(), union, (arg_0, arg_1) -> this.$anonfun$1(leftMost2, arg_0, arg_1));
            tree2 = zippedTree;
        }
        return tree2;
    }

    private RedBlackTree.Tree<A, B> balance$1(A x, B xv, RedBlackTree.Tree<A, B> tl, RedBlackTree.Tree<A, B> tr) {
        RedBlackTree.Tree tree;
        if (this.isRedTree(tl)) {
            if (this.isRedTree(tr)) {
                RedBlackTree.Tree left = tl.black();
                RedBlackTree.Tree right = tr.black();
                tree = new RedBlackTree.RedTree(x, xv, left, right);
            } else if (this.isRedTree(tl.left())) {
                RedBlackTree.Tree left = tl.left().black();
                RedBlackTree.BlackTree right = new RedBlackTree.BlackTree(x, xv, tl.right(), tr);
                tree = new RedBlackTree.RedTree(tl.key(), tl.value(), left, right);
            } else if (this.isRedTree(tl.right())) {
                RedBlackTree.BlackTree left = new RedBlackTree.BlackTree(tl.key(), tl.value(), tl.left(), tl.right().left());
                RedBlackTree.BlackTree right = new RedBlackTree.BlackTree(x, xv, tl.right().right(), tr);
                tree = new RedBlackTree.RedTree(tl.right().key(), tl.right().value(), left, right);
            } else {
                tree = new RedBlackTree.BlackTree(x, xv, tl, tr);
            }
        } else if (this.isRedTree(tr)) {
            if (this.isRedTree(tr.right())) {
                RedBlackTree.BlackTree left = new RedBlackTree.BlackTree(x, xv, tl, tr.left());
                RedBlackTree.Tree right = tr.right().black();
                tree = new RedBlackTree.RedTree(tr.key(), tr.value(), left, right);
            } else if (this.isRedTree(tr.left())) {
                RedBlackTree.BlackTree left = new RedBlackTree.BlackTree(x, xv, tl, tr.left().left());
                RedBlackTree.BlackTree right = new RedBlackTree.BlackTree(tr.key(), tr.value(), tr.left().right(), tr.right());
                tree = new RedBlackTree.RedTree(tr.left().key(), tr.left().value(), left, right);
            } else {
                tree = new RedBlackTree.BlackTree(x, xv, tl, tr);
            }
        } else {
            tree = new RedBlackTree.BlackTree(x, xv, tl, tr);
        }
        return tree;
    }

    private RedBlackTree.Tree<A, B> subl$1(RedBlackTree.Tree<A, B> t) {
        if (!(t instanceof RedBlackTree.BlackTree)) {
            throw package$.MODULE$.error("Defect: invariance violation; expected black, got " + t);
        }
        return t.red();
    }

    private RedBlackTree.Tree<A, B> balLeft$1(A x, B xv, RedBlackTree.Tree<A, B> tl, RedBlackTree.Tree<A, B> tr) {
        RedBlackTree.RedTree redTree;
        if (this.isRedTree(tl)) {
            RedBlackTree.Tree left = tl.black();
            redTree = new RedBlackTree.RedTree(x, xv, left, tr);
        } else if (this.isBlackTree(tr)) {
            redTree = this.balance$1(x, xv, tl, tr.red());
        } else if (this.isRedTree(tr) && this.isBlackTree(tr.left())) {
            RedBlackTree.BlackTree left = new RedBlackTree.BlackTree(x, xv, tl, tr.left().left());
            RedBlackTree.Tree right = this.balance$1(tr.key(), tr.value(), tr.left().right(), this.subl$1(tr.right()));
            redTree = new RedBlackTree.RedTree(tr.left().key(), tr.left().value(), left, right);
        } else {
            throw package$.MODULE$.error("Defect: invariance violation");
        }
        return redTree;
    }

    private RedBlackTree.Tree<A, B> balRight$1(A x, B xv, RedBlackTree.Tree<A, B> tl, RedBlackTree.Tree<A, B> tr) {
        RedBlackTree.RedTree redTree;
        if (this.isRedTree(tr)) {
            RedBlackTree.Tree right = tr.black();
            redTree = new RedBlackTree.RedTree(x, xv, tl, right);
        } else if (this.isBlackTree(tl)) {
            redTree = this.balance$1(x, xv, tl.red(), tr);
        } else if (this.isRedTree(tl) && this.isBlackTree(tl.right())) {
            RedBlackTree.Tree left = this.balance$1(tl.key(), tl.value(), this.subl$1(tl.left()), tl.right().left());
            RedBlackTree.BlackTree right = new RedBlackTree.BlackTree(x, xv, tl.right().right(), tr);
            redTree = new RedBlackTree.RedTree(tl.right().key(), tl.right().value(), left, right);
        } else {
            throw package$.MODULE$.error("Defect: invariance violation");
        }
        return redTree;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private RedBlackTree.Tree delLeft$1(RedBlackTree.Tree tree$1, Object k$10, Ordering ordering$1) {
        RedBlackTree.Tree tree;
        if (this.isBlackTree(tree$1.left())) {
            tree = this.balLeft$1(tree$1.key(), tree$1.value(), this.del(tree$1.left(), k$10, ordering$1), tree$1.right());
        } else {
            RedBlackTree.Tree left = this.del(tree$1.left(), k$10, ordering$1);
            tree = new RedBlackTree.RedTree(tree$1.key(), tree$1.value(), left, tree$1.right());
        }
        return tree;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private RedBlackTree.Tree delRight$1(RedBlackTree.Tree tree$2, Object k$11, Ordering ordering$2) {
        RedBlackTree.Tree tree;
        if (this.isBlackTree(tree$2.right())) {
            tree = this.balRight$1(tree$2.key(), tree$2.value(), tree$2.left(), this.del(tree$2.right(), k$11, ordering$2));
        } else {
            RedBlackTree.Tree right = this.del(tree$2.right(), k$11, ordering$2);
            tree = new RedBlackTree.RedTree(tree$2.key(), tree$2.value(), tree$2.left(), right);
        }
        return tree;
    }

    private RedBlackTree.Tree<A, B> append$1(RedBlackTree.Tree<A, B> tl, RedBlackTree.Tree<A, B> tr) {
        RedBlackTree.RedTree redTree;
        if (tl == null) {
            redTree = tr;
        } else if (tr == null) {
            redTree = tl;
        } else if (this.isRedTree(tl) && this.isRedTree(tr)) {
            RedBlackTree.Tree bc = this.append$1(tl.right(), tr.left());
            if (this.isRedTree(bc)) {
                RedBlackTree.RedTree left = new RedBlackTree.RedTree(tl.key(), tl.value(), tl.left(), bc.left());
                RedBlackTree.RedTree right = new RedBlackTree.RedTree(tr.key(), tr.value(), bc.right(), tr.right());
                redTree = new RedBlackTree.RedTree(bc.key(), bc.value(), left, right);
            } else {
                RedBlackTree.RedTree right = new RedBlackTree.RedTree(tr.key(), tr.value(), bc, tr.right());
                redTree = new RedBlackTree.RedTree(tl.key(), tl.value(), tl.left(), right);
            }
        } else if (this.isBlackTree(tl) && this.isBlackTree(tr)) {
            RedBlackTree.Tree bc = this.append$1(tl.right(), tr.left());
            if (this.isRedTree(bc)) {
                RedBlackTree.BlackTree left = new RedBlackTree.BlackTree(tl.key(), tl.value(), tl.left(), bc.left());
                RedBlackTree.BlackTree right = new RedBlackTree.BlackTree(tr.key(), tr.value(), bc.right(), tr.right());
                redTree = new RedBlackTree.RedTree(bc.key(), bc.value(), left, right);
            } else {
                redTree = this.balLeft$1(tl.key(), tl.value(), tl.left(), new RedBlackTree.BlackTree(tr.key(), tr.value(), bc, tr.right()));
            }
        } else if (this.isRedTree(tr)) {
            RedBlackTree.Tree left = this.append$1(tl, tr.left());
            redTree = new RedBlackTree.RedTree(tr.key(), tr.value(), left, tr.right());
        } else if (this.isRedTree(tl)) {
            RedBlackTree.Tree right = this.append$1(tl.right(), tr);
            redTree = new RedBlackTree.RedTree(tl.key(), tl.value(), tl.left(), right);
        } else {
            throw package$.MODULE$.error("unmatched tree on append: " + tl + ", " + tr);
        }
        return redTree;
    }

    /*
     * Enabled aggressive block sorting
     */
    private RedBlackTree.NList<RedBlackTree.Tree<A, B>> unzip$1(RedBlackTree.NList<RedBlackTree.Tree<A, B>> zipper, boolean leftMost) {
        boolean bl = leftMost;
        RedBlackTree.NList nList = zipper;
        while (true) {
            RedBlackTree.Tree next;
            RedBlackTree.Tree tree = next = bl ? nList.head().left() : nList.head().right();
            if (next == null) {
                return nList;
            }
            nList = RedBlackTree$NList$.MODULE$.cons(next, nList);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Tuple4<RedBlackTree.NList<RedBlackTree.Tree<A, B>>, Object, Object, Object> unzipBoth$1(RedBlackTree.Tree<A, B> left, RedBlackTree.Tree<A, B> right, RedBlackTree.NList<RedBlackTree.Tree<A, B>> leftZipper, RedBlackTree.NList<RedBlackTree.Tree<A, B>> rightZipper, int smallerDepth) {
        Tuple4 tuple4;
        int n = smallerDepth;
        RedBlackTree.NList nList = rightZipper;
        RedBlackTree.NList nList2 = leftZipper;
        RedBlackTree.Tree tree = right;
        RedBlackTree.Tree tree2 = left;
        while (true) {
            if (this.isBlackTree(tree2) && this.isBlackTree(tree)) {
                ++n;
                nList = RedBlackTree$NList$.MODULE$.cons(tree, nList);
                nList2 = RedBlackTree$NList$.MODULE$.cons(tree2, nList2);
                tree = tree.left();
                tree2 = tree2.right();
                continue;
            }
            if (this.isRedTree(tree2) && this.isRedTree(tree)) {
                nList = RedBlackTree$NList$.MODULE$.cons(tree, nList);
                nList2 = RedBlackTree$NList$.MODULE$.cons(tree2, nList2);
                tree = tree.left();
                tree2 = tree2.right();
                continue;
            }
            if (this.isRedTree(tree)) {
                nList = RedBlackTree$NList$.MODULE$.cons(tree, nList);
                tree = tree.left();
                continue;
            }
            if (!this.isRedTree(tree2)) break;
            nList2 = RedBlackTree$NList$.MODULE$.cons(tree2, nList2);
            tree2 = tree2.right();
        }
        if (tree2 == null && tree == null) {
            tuple4 = Tuple4$.MODULE$.apply(null, (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)n));
            return tuple4;
        }
        if (tree2 == null && this.isBlackTree(tree)) {
            boolean leftMost = true;
            tuple4 = Tuple4$.MODULE$.apply(this.unzip$1(RedBlackTree$NList$.MODULE$.cons(tree, nList), leftMost), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)leftMost), (Object)BoxesRunTime.boxToInteger((int)n));
            return tuple4;
        }
        if (!this.isBlackTree(tree2)) throw package$.MODULE$.error("unmatched trees in unzip: " + tree2 + ", " + tree);
        if (tree != null) throw package$.MODULE$.error("unmatched trees in unzip: " + tree2 + ", " + tree);
        boolean leftMost = false;
        tuple4 = Tuple4$.MODULE$.apply(this.unzip$1(RedBlackTree$NList$.MODULE$.cons(tree2, nList2), leftMost), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)leftMost), (Object)BoxesRunTime.boxToInteger((int)n));
        return tuple4;
    }

    /*
     * Enabled aggressive block sorting
     */
    private RedBlackTree.NList<RedBlackTree.Tree<A, B>> findDepth$1(RedBlackTree.NList<RedBlackTree.Tree<A, B>> zipper, int depth) {
        int n = depth;
        RedBlackTree.NList nList = zipper;
        while (true) {
            if (nList == null) {
                throw package$.MODULE$.error("Defect: unexpected empty zipper while computing range");
            }
            if (this.isBlackTree(nList.head())) {
                if (n == 1) {
                    return nList;
                }
                --n;
                nList = nList.tail();
                continue;
            }
            nList = nList.tail();
        }
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private RedBlackTree.Tree $anonfun$1(boolean leftMost$1, RedBlackTree.Tree tree, RedBlackTree.Tree node) {
        return leftMost$1 ? this.balanceLeft(this.isBlackTree(node), node.key(), node.value(), tree, node.right()) : this.balanceRight(this.isBlackTree(node), node.key(), node.value(), node.left(), tree);
    }
}

