/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.immutable;

import java.util.NoSuchElementException;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple4;
import scala.math.Ordering;
import strawman.collection.Iterator;
import strawman.collection.immutable.RedBlackTree$;
import strawman.collection.immutable.RedBlackTree$BlackTree$;
import strawman.collection.immutable.RedBlackTree$NList$;
import strawman.collection.immutable.RedBlackTree$RedTree$;

public final class RedBlackTree {
    public static <A, B, U> void foreach(Tree<A, B> tree, Function1<Tuple2<A, B>, U> function1) {
        RedBlackTree$.MODULE$.foreach(tree, function1);
    }

    public static <A, B> Tree<A, B> drop(Tree<A, B> tree, int n, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.drop(tree, n, ordering);
    }

    public static <A, B> Tree<A, B> slice(Tree<A, B> tree, int n, int n2, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.slice(tree, n, n2, ordering);
    }

    public static <A, B> Tree<A, B> to(Tree<A, B> tree, A a, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.to(tree, a, ordering);
    }

    public static None$ valuesIterator$default$2() {
        return RedBlackTree$.MODULE$.valuesIterator$default$2();
    }

    public static <A, B> Tree<A, B> maxBefore(Tree<A, B> tree, A a, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.maxBefore(tree, a, ordering);
    }

    public static <A, B> Option<B> get(Tree<A, B> tree, A a, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.get(tree, a, ordering);
    }

    public static None$ keysIterator$default$2() {
        return RedBlackTree$.MODULE$.keysIterator$default$2();
    }

    public static <A, B> Tree<A, B> until(Tree<A, B> tree, A a, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.until(tree, a, ordering);
    }

    public static int count(Tree<?, ?> tree) {
        return RedBlackTree$.MODULE$.count(tree);
    }

    public static <A, B> Tree<A, B> greatest(Tree<A, B> tree) {
        return RedBlackTree$.MODULE$.greatest(tree);
    }

    public static <A, B> Tree<A, B> nth(Tree<A, B> tree, int n) {
        return RedBlackTree$.MODULE$.nth(tree, n);
    }

    public static <A, B> Tree<A, B> delete(Tree<A, B> tree, A a, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.delete(tree, a, ordering);
    }

    public static <A, B> Tree<A, B> from(Tree<A, B> tree, A a, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.from(tree, a, ordering);
    }

    public static <A, B> Tree<A, B> minAfter(Tree<A, B> tree, A a, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.minAfter(tree, a, ordering);
    }

    public static <A, B> Iterator<B> valuesIterator(Tree<A, B> tree, Option<A> option, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.valuesIterator(tree, option, ordering);
    }

    public static <A, B> Tree<A, B> take(Tree<A, B> tree, int n, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.take(tree, n, ordering);
    }

    public static <A, B> Iterator<Tuple2<A, B>> iterator(Tree<A, B> tree, Option<A> option, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.iterator(tree, option, ordering);
    }

    public static <A> int countInRange(Tree<A, ?> tree, Option<A> option, Option<A> option2, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.countInRange(tree, option, option2, ordering);
    }

    public static <A, U> void foreachKey(Tree<A, ?> tree, Function1<A, U> function1) {
        RedBlackTree$.MODULE$.foreachKey(tree, function1);
    }

    public static None$ iterator$default$2() {
        return RedBlackTree$.MODULE$.iterator$default$2();
    }

    public static <A> Iterator<A> keysIterator(Tree<A, ?> tree, Option<A> option, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.keysIterator(tree, option, ordering);
    }

    public static boolean isEmpty(Tree<?, ?> tree) {
        return RedBlackTree$.MODULE$.isEmpty(tree);
    }

    public static <A> boolean contains(Tree<A, ?> tree, A a, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.contains(tree, a, ordering);
    }

    public static <A, B> Tree<A, B> rangeImpl(Tree<A, B> tree, Option<A> option, Option<A> option2, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.rangeImpl(tree, option, option2, ordering);
    }

    public static <A, B> Tree<A, B> smallest(Tree<A, B> tree) {
        return RedBlackTree$.MODULE$.smallest(tree);
    }

    public static <A, B, B1> Tree<A, B1> update(Tree<A, B> tree, A a, B1 B1, boolean bl, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.update(tree, a, B1, bl, ordering);
    }

    public static <A, B> Tree<A, B> range(Tree<A, B> tree, A a, A a2, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.range(tree, a, a2, ordering);
    }

    public static <A, B> Tree<A, B> lookup(Tree<A, B> tree, A a, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.lookup(tree, a, ordering);
    }

    public static boolean isBlack(Tree<?, ?> tree) {
        return RedBlackTree$.MODULE$.isBlack(tree);
    }

    public static final class BlackTree<A, B>
    extends Tree<A, B> {
        public static <A, B> BlackTree<A, B> apply(A a, B b, Tree<A, B> tree, Tree<A, B> tree2) {
            return RedBlackTree$BlackTree$.MODULE$.apply(a, b, tree, tree2);
        }

        public static <A, B> Some<Tuple4<A, B, Tree<A, B>, Tree<A, B>>> unapply(BlackTree<A, B> blackTree) {
            return RedBlackTree$BlackTree$.MODULE$.unapply(blackTree);
        }

        public <A, B> BlackTree(A key, B value, Tree<A, B> left, Tree<A, B> right) {
            super(key, value, left, right);
        }

        public A strawman$collection$immutable$RedBlackTree$BlackTree$$key() {
            return super.key();
        }

        public B strawman$collection$immutable$RedBlackTree$BlackTree$$value() {
            return super.value();
        }

        public Tree<A, B> strawman$collection$immutable$RedBlackTree$BlackTree$$left() {
            return super.left();
        }

        public Tree<A, B> strawman$collection$immutable$RedBlackTree$BlackTree$$right() {
            return super.right();
        }

        @Override
        public Tree<A, B> black() {
            return this;
        }

        @Override
        public Tree<A, B> red() {
            return new RedTree<A, B>(this.strawman$collection$immutable$RedBlackTree$BlackTree$$key(), this.strawman$collection$immutable$RedBlackTree$BlackTree$$value(), this.strawman$collection$immutable$RedBlackTree$BlackTree$$left(), this.strawman$collection$immutable$RedBlackTree$BlackTree$$right());
        }

        public String toString() {
            return "BlackTree(" + this.strawman$collection$immutable$RedBlackTree$BlackTree$$key() + ", " + this.strawman$collection$immutable$RedBlackTree$BlackTree$$value() + ", " + this.strawman$collection$immutable$RedBlackTree$BlackTree$$left() + ", " + this.strawman$collection$immutable$RedBlackTree$BlackTree$$right() + ")";
        }
    }

    private static class EntriesIterator<A, B>
    extends TreeIterator<A, B, Tuple2<A, B>> {
        public <A, B> EntriesIterator(Tree<A, B> tree, Option<A> focus, Ordering<A> evidence$59) {
            super(tree, focus, evidence$59);
        }

        @Override
        public Tuple2<A, B> nextResult(Tree<A, B> tree) {
            return Tuple2$.MODULE$.apply(tree.key(), tree.value());
        }
    }

    private static class KeysIterator<A, B>
    extends TreeIterator<A, B, A> {
        public <A, B> KeysIterator(Tree<A, B> tree, Option<A> focus, Ordering<A> evidence$60) {
            super(tree, focus, evidence$60);
        }

        @Override
        public A nextResult(Tree<A, B> tree) {
            return tree.key();
        }
    }

    private static final class NList<A> {
        private final Object head;
        private final NList tail;

        public static <B> NList<B> cons(B b, NList<B> nList) {
            return RedBlackTree$NList$.MODULE$.cons(b, nList);
        }

        public static <A, B> B foldLeft(NList<A> nList, B b, Function2<B, A, B> function2) {
            return RedBlackTree$NList$.MODULE$.foldLeft(nList, b, function2);
        }

        public <A> NList(A head, NList<A> tail) {
            this.head = head;
            this.tail = tail;
        }

        public A head() {
            return (A)this.head;
        }

        public NList<A> tail() {
            return this.tail;
        }
    }

    public static final class RedTree<A, B>
    extends Tree<A, B> {
        public static <A, B> RedTree<A, B> apply(A a, B b, Tree<A, B> tree, Tree<A, B> tree2) {
            return RedBlackTree$RedTree$.MODULE$.apply(a, b, tree, tree2);
        }

        public static <A, B> Some<Tuple4<A, B, Tree<A, B>, Tree<A, B>>> unapply(RedTree<A, B> redTree) {
            return RedBlackTree$RedTree$.MODULE$.unapply(redTree);
        }

        public <A, B> RedTree(A key, B value, Tree<A, B> left, Tree<A, B> right) {
            super(key, value, left, right);
        }

        public A strawman$collection$immutable$RedBlackTree$RedTree$$key() {
            return super.key();
        }

        public B strawman$collection$immutable$RedBlackTree$RedTree$$value() {
            return super.value();
        }

        public Tree<A, B> strawman$collection$immutable$RedBlackTree$RedTree$$left() {
            return super.left();
        }

        public Tree<A, B> strawman$collection$immutable$RedBlackTree$RedTree$$right() {
            return super.right();
        }

        @Override
        public Tree<A, B> black() {
            return new BlackTree<A, B>(this.strawman$collection$immutable$RedBlackTree$RedTree$$key(), this.strawman$collection$immutable$RedBlackTree$RedTree$$value(), this.strawman$collection$immutable$RedBlackTree$RedTree$$left(), this.strawman$collection$immutable$RedBlackTree$RedTree$$right());
        }

        @Override
        public Tree<A, B> red() {
            return this;
        }

        public String toString() {
            return "RedTree(" + this.strawman$collection$immutable$RedBlackTree$RedTree$$key() + ", " + this.strawman$collection$immutable$RedBlackTree$RedTree$$value() + ", " + this.strawman$collection$immutable$RedBlackTree$RedTree$$left() + ", " + this.strawman$collection$immutable$RedBlackTree$RedTree$$right() + ")";
        }
    }

    public static abstract class Tree<A, B>
    implements Serializable {
        private final Object key;
        private final Object value;
        private final Tree left;
        private final Tree right;
        private final int count;

        public <A, B> Tree(A key, B value, Tree<A, B> left, Tree<A, B> right) {
            this.key = key;
            this.value = value;
            this.left = left;
            this.right = right;
            this.count = 1 + RedBlackTree$.MODULE$.count(left) + RedBlackTree$.MODULE$.count(right);
        }

        public final A key() {
            return (A)this.key;
        }

        public final B value() {
            return (B)this.value;
        }

        public final Tree<A, B> left() {
            return this.left;
        }

        public final Tree<A, B> right() {
            return this.right;
        }

        public final int count() {
            return this.count;
        }

        public abstract Tree<A, B> black();

        public abstract Tree<A, B> red();
    }

    private static abstract class TreeIterator<A, B, R>
    implements Iterator<R> {
        private final Tree<A, B> root;
        private final Ordering<A> ordering;
        private Tree<A, B>[] stackOfNexts;
        private int index;
        private Tree<A, B> lookahead;

        public <A, B, R> TreeIterator(Tree<A, B> root, Option<A> start, Ordering<A> ordering) {
            Tree[] treeArray;
            this.root = root;
            this.ordering = ordering;
            if (root == null) {
                treeArray = null;
            } else {
                int maximumHeight = 2 * (32 - Integer.numberOfLeadingZeros(root.count() + 2 - 1)) - 2;
                treeArray = new Tree[maximumHeight];
            }
            this.stackOfNexts = treeArray;
            this.index = 0;
            this.lookahead = (Tree)start.map(this::$init$$$anonfun$1).getOrElse(() -> this.$init$$$anonfun$2(root));
        }

        public abstract R nextResult(Tree<A, B> var1);

        @Override
        public boolean hasNext() {
            return this.lookahead != null;
        }

        @Override
        public R next() {
            Tree<A, B> tree = this.lookahead;
            if (tree == null) {
                throw new NoSuchElementException("next on empty iterator");
            }
            Tree<A, B> tree2 = tree;
            this.lookahead = this.findLeftMostOrPopOnEmpty(this.goRight(tree2));
            return this.nextResult(tree2);
        }

        /*
         * Enabled aggressive block sorting
         */
        private Tree<A, B> findLeftMostOrPopOnEmpty(Tree<A, B> tree) {
            Tree<A, B> tree2 = tree;
            TreeIterator treeIterator = this;
            while (true) {
                Tree<A, B> tree3;
                if (tree2 == null) {
                    tree3 = treeIterator.popNext();
                    return tree3;
                }
                if (tree2.left() == null) {
                    tree3 = tree2;
                    return tree3;
                }
                tree2 = treeIterator.goLeft(tree2);
            }
        }

        private void pushNext(Tree<A, B> tree) {
            this.stackOfNexts[this.index] = tree;
            ++this.index;
        }

        private Tree<A, B> popNext() {
            Tree<A, B> tree;
            if (this.index == 0) {
                tree = null;
            } else {
                --this.index;
                tree = this.stackOfNexts[this.index];
            }
            return tree;
        }

        private Tree<A, B> startFrom(A key) {
            return this.root == null ? null : this.find$1(key, this.root);
        }

        private Tree<A, B> goLeft(Tree<A, B> tree) {
            this.pushNext(tree);
            return tree.left();
        }

        private Tree<A, B> goRight(Tree<A, B> tree) {
            return tree.right();
        }

        private Tree<A, B> $init$$$anonfun$1(A key) {
            return this.startFrom(key);
        }

        private Tree<A, B> $init$$$anonfun$2(Tree root$1) {
            return this.findLeftMostOrPopOnEmpty(root$1);
        }

        /*
         * Enabled aggressive block sorting
         */
        private Tree<A, B> find$1(Object key$3, Tree<A, B> tree) {
            Tree<A, B> tree2 = tree;
            while (tree2 != null) {
                tree2 = this.ordering.lteq(key$3, tree2.key()) ? this.goLeft(tree2) : this.goRight(tree2);
            }
            return this.popNext();
        }
    }

    private static class ValuesIterator<A, B>
    extends TreeIterator<A, B, B> {
        public <A, B> ValuesIterator(Tree<A, B> tree, Option<A> focus, Ordering<A> evidence$61) {
            super(tree, focus, evidence$61);
        }

        @Override
        public B nextResult(Tree<A, B> tree) {
            return tree.value();
        }
    }
}

