/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.immutable;

import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Seq;
import scala.compat.java8.JFunction1;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import strawman.collection.ArrayOps;
import strawman.collection.ArrayOps$;
import strawman.collection.IterableOnce;
import strawman.collection.IterableOps;
import strawman.collection.Iterator;
import strawman.collection.immutable.HashMap;
import strawman.collection.immutable.HashMap$;
import strawman.collection.immutable.HashSet;
import strawman.collection.immutable.HashSet$;
import strawman.collection.immutable.Iterable;
import strawman.collection.mutable.ArrayBuffer;
import strawman.collection.mutable.ArrayBuffer$;
import strawman.collection.mutable.Growable;
import strawman.collection.package$;

public abstract class TrieIterator<T>
implements Iterator<T> {
    private final Iterable<T>[] elems;
    public int strawman$collection$immutable$TrieIterator$$depth;
    public Iterable<T>[][] strawman$collection$immutable$TrieIterator$$arrayStack;
    public int[] strawman$collection$immutable$TrieIterator$$posStack;
    public Iterable<T>[] strawman$collection$immutable$TrieIterator$$arrayD;
    public int strawman$collection$immutable$TrieIterator$$posD;
    public Iterator<T> strawman$collection$immutable$TrieIterator$$subIter;

    public <T> TrieIterator(Iterable<T>[] elems) {
        this.elems = elems;
        this.strawman$collection$immutable$TrieIterator$$depth = this.initDepth();
        this.strawman$collection$immutable$TrieIterator$$arrayStack = this.initArrayStack();
        this.strawman$collection$immutable$TrieIterator$$posStack = this.initPosStack();
        this.strawman$collection$immutable$TrieIterator$$arrayD = this.initArrayD();
        this.strawman$collection$immutable$TrieIterator$$posD = this.initPosD();
        this.strawman$collection$immutable$TrieIterator$$subIter = this.initSubIter();
    }

    public abstract T getElem(Object var1);

    public int initDepth() {
        return 0;
    }

    public Iterable<T>[][] initArrayStack() {
        return new Iterable[6][];
    }

    public int[] initPosStack() {
        return new int[6];
    }

    public Iterable<T>[] initArrayD() {
        return this.elems;
    }

    public int initPosD() {
        return 0;
    }

    public Iterator<T> initSubIter() {
        return null;
    }

    private Iterable<T>[] getElems(Iterable<T> x) {
        Serializable[] serializableArray;
        Iterable<T> iterable = x;
        if (iterable instanceof HashMap.HashTrieMap) {
            HashMap.HashTrieMap hashTrieMap;
            HashMap.HashTrieMap x2 = hashTrieMap = (HashMap.HashTrieMap)iterable;
            serializableArray = x2.elems();
        } else if (iterable instanceof HashSet.HashTrieSet) {
            HashSet.HashTrieSet hashTrieSet;
            HashSet.HashTrieSet x3 = hashTrieSet = (HashSet.HashTrieSet)iterable;
            serializableArray = x3.elems();
        } else {
            throw new MatchError(iterable);
        }
        return (Iterable[])serializableArray;
    }

    private Iterable<T>[] collisionToArray(Iterable<T> x) {
        Serializable[] serializableArray;
        Iterable<T> iterable = x;
        if (iterable instanceof HashMap.HashMapCollision1) {
            HashMap.HashMapCollision1 hashMapCollision1;
            HashMap.HashMapCollision1 x2 = hashMapCollision1 = (HashMap.HashMapCollision1)iterable;
            serializableArray = (Serializable[])((IterableOps)x2.kvs().map(TrieIterator::collisionToArray$$anonfun$1)).toArray(ClassTag$.MODULE$.apply(HashMap.class));
        } else if (iterable instanceof HashSet.HashSetCollision1) {
            HashSet.HashSetCollision1 hashSetCollision1;
            HashSet.HashSetCollision1 x3 = hashSetCollision1 = (HashSet.HashSetCollision1)iterable;
            serializableArray = (Serializable[])((IterableOps)x3.ks().map(TrieIterator::collisionToArray$$anonfun$2)).toArray(ClassTag$.MODULE$.apply(HashSet.class));
        } else {
            throw new MatchError(iterable);
        }
        return (Iterable[])serializableArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isTrie(Object x) {
        Object object = x;
        if (object instanceof HashMap.HashTrieMap) {
            HashMap.HashTrieMap hashTrieMap = (HashMap.HashTrieMap)object;
            return true;
        }
        if (!(object instanceof HashSet.HashTrieSet)) return false;
        HashSet.HashTrieSet hashTrieSet = (HashSet.HashTrieSet)object;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isContainer(Object x) {
        Object object = x;
        if (object instanceof HashMap.HashMap1) {
            HashMap.HashMap1 hashMap1 = (HashMap.HashMap1)object;
            return true;
        }
        if (!(object instanceof HashSet.HashSet1)) return false;
        HashSet.HashSet1 hashSet1 = (HashSet.HashSet1)object;
        return true;
    }

    public TrieIterator<T> dupIterator() {
        return new DupIterator(this, this.elems);
    }

    private TrieIterator<T> newIterator(Iterable<T>[] xs) {
        return new TrieIterator<T>(xs, this){
            private final TrieIterator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(xs$9);
            }

            public final T getElem(Object x) {
                return this.strawman$collection$immutable$TrieIterator$_$$anon$$$outer().getElem(x);
            }

            private TrieIterator<T> $outer() {
                return this.$outer;
            }

            public final TrieIterator<T> strawman$collection$immutable$TrieIterator$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    private Tuple2<Iterator<T>, Object> iteratorWithSize(Iterable<T>[] arr) {
        Object object = package$.MODULE$.arrayToArrayOps(arr);
        return Tuple2$.MODULE$.apply(this.newIterator(arr), new ArrayOps(package$.MODULE$.arrayToArrayOps((int[])ArrayOps$.MODULE$.map$extension(object, (Function1)((JFunction1)TrieIterator::iteratorWithSize$$anonfun$1), ClassTag$.MODULE$.apply(Integer.TYPE)))).sum(Numeric.IntIsIntegral$.MODULE$));
    }

    private Tuple2<Tuple2<Iterator<T>, Object>, Iterator<T>> arrayToIterators(Iterable<T>[] arr) {
        Tuple2 tuple2 = new ArrayOps(package$.MODULE$.arrayToArrayOps(arr)).splitAt(arr.length / 2);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Iterable[] fst = (Iterable[])tuple2._1();
        Iterable[] snd = (Iterable[])tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)fst, (Object)snd);
        Iterable[] fst2 = (Iterable[])tuple22._1();
        Iterable[] snd2 = (Iterable[])tuple22._2();
        return Tuple2$.MODULE$.apply(this.iteratorWithSize(snd2), this.newIterator(fst2));
    }

    /*
     * Enabled aggressive block sorting
     */
    private Tuple2<Tuple2<Iterator<T>, Object>, Iterator<T>> splitArray(Iterable<T>[] ad) {
        Iterable<T>[] iterableArray = ad;
        TrieIterator trieIterator = this;
        while (true) {
            block7: {
                Tuple2<Tuple2<Iterator<T>, Object>, Iterator<T>> tuple2;
                block6: {
                    Iterable<T> iterable;
                    block5: {
                        if (iterableArray.length > 1) {
                            tuple2 = trieIterator.arrayToIterators(iterableArray);
                            return tuple2;
                        }
                        iterable = iterableArray[0];
                        if (!(iterable instanceof HashMap.HashMapCollision1)) break block5;
                        HashMap.HashMapCollision1 hashMapCollision1 = (HashMap.HashMapCollision1)iterable;
                        break block6;
                    }
                    if (!(iterable instanceof HashSet.HashSetCollision1)) break block7;
                    HashSet.HashSetCollision1 hashSetCollision1 = (HashSet.HashSetCollision1)iterable;
                }
                tuple2 = trieIterator.arrayToIterators(trieIterator.collisionToArray(iterableArray[0]));
                return tuple2;
            }
            iterableArray = trieIterator.getElems(iterableArray[0]);
        }
    }

    @Override
    public boolean hasNext() {
        return this.strawman$collection$immutable$TrieIterator$$subIter != null || this.strawman$collection$immutable$TrieIterator$$depth >= 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T next() {
        T t;
        if (this.strawman$collection$immutable$TrieIterator$$subIter != null) {
            void var1_1;
            T el = this.strawman$collection$immutable$TrieIterator$$subIter.next();
            if (!this.strawman$collection$immutable$TrieIterator$$subIter.hasNext()) {
                this.strawman$collection$immutable$TrieIterator$$subIter = null;
            }
            t = var1_1;
        } else {
            t = this.next0(this.strawman$collection$immutable$TrieIterator$$arrayD, this.strawman$collection$immutable$TrieIterator$$posD);
        }
        return t;
    }

    /*
     * Enabled aggressive block sorting
     */
    private T next0(Iterable<T>[] elems, int i) {
        int n = i;
        Iterable<T>[] iterableArray = elems;
        TrieIterator trieIterator = this;
        while (true) {
            T t;
            if (n == iterableArray.length - 1) {
                --trieIterator.strawman$collection$immutable$TrieIterator$$depth;
                if (trieIterator.strawman$collection$immutable$TrieIterator$$depth >= 0) {
                    trieIterator.strawman$collection$immutable$TrieIterator$$arrayD = trieIterator.strawman$collection$immutable$TrieIterator$$arrayStack[trieIterator.strawman$collection$immutable$TrieIterator$$depth];
                    trieIterator.strawman$collection$immutable$TrieIterator$$posD = trieIterator.strawman$collection$immutable$TrieIterator$$posStack[trieIterator.strawman$collection$immutable$TrieIterator$$depth];
                    trieIterator.strawman$collection$immutable$TrieIterator$$arrayStack[trieIterator.strawman$collection$immutable$TrieIterator$$depth] = null;
                } else {
                    trieIterator.strawman$collection$immutable$TrieIterator$$arrayD = null;
                    trieIterator.strawman$collection$immutable$TrieIterator$$posD = 0;
                }
            } else {
                ++trieIterator.strawman$collection$immutable$TrieIterator$$posD;
            }
            Iterable<T> m = iterableArray[n];
            if (trieIterator.isContainer(m)) {
                t = trieIterator.getElem(m);
                return t;
            }
            if (!trieIterator.isTrie(m)) {
                trieIterator.strawman$collection$immutable$TrieIterator$$subIter = m.iterator();
                t = trieIterator.next();
                return t;
            }
            if (trieIterator.strawman$collection$immutable$TrieIterator$$depth >= 0) {
                trieIterator.strawman$collection$immutable$TrieIterator$$arrayStack[trieIterator.strawman$collection$immutable$TrieIterator$$depth] = trieIterator.strawman$collection$immutable$TrieIterator$$arrayD;
                trieIterator.strawman$collection$immutable$TrieIterator$$posStack[trieIterator.strawman$collection$immutable$TrieIterator$$depth] = trieIterator.strawman$collection$immutable$TrieIterator$$posD;
            }
            ++trieIterator.strawman$collection$immutable$TrieIterator$$depth;
            trieIterator.strawman$collection$immutable$TrieIterator$$arrayD = trieIterator.getElems(m);
            trieIterator.strawman$collection$immutable$TrieIterator$$posD = 0;
            n = 0;
            iterableArray = trieIterator.getElems(m);
        }
    }

    public Tuple2<Tuple2<Iterator<T>, Object>, Iterator<T>> split() {
        Tuple2 tuple2;
        if (this.strawman$collection$immutable$TrieIterator$$arrayD != null && this.strawman$collection$immutable$TrieIterator$$depth == 0 && this.strawman$collection$immutable$TrieIterator$$posD == 0) {
            return this.splitArray(this.strawman$collection$immutable$TrieIterator$$arrayD);
        }
        if (this.strawman$collection$immutable$TrieIterator$$subIter != null) {
            Iterator<T> xs = this.strawman$collection$immutable$TrieIterator$$subIter;
            Object Growable_this = ArrayBuffer$.MODULE$.empty();
            Growable buff = ((ArrayBuffer)Growable_this).addAll((IterableOnce)xs);
            this.strawman$collection$immutable$TrieIterator$$subIter = null;
            tuple2 = Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(buff.iterator(), (Object)BoxesRunTime.boxToInteger((int)((ArrayBuffer)buff).length())), (Object)this);
        } else if (this.strawman$collection$immutable$TrieIterator$$depth > 0) {
            if (this.strawman$collection$immutable$TrieIterator$$posStack[0] == this.strawman$collection$immutable$TrieIterator$$arrayStack[0].length - 1) {
                Iterable[] snd = (Iterable[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Iterable[]{(Iterable)new ArrayOps(package$.MODULE$.arrayToArrayOps(this.strawman$collection$immutable$TrieIterator$$arrayStack[0])).last()}), ClassTag$.MODULE$.apply(Iterable.class));
                int szsnd = snd[0].size();
                --this.strawman$collection$immutable$TrieIterator$$depth;
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.strawman$collection$immutable$TrieIterator$$arrayStack.length).foreach((Function1)((JFunction1.mcVI.sp)this::split$$anonfun$1));
                this.strawman$collection$immutable$TrieIterator$$arrayStack[this.strawman$collection$immutable$TrieIterator$$arrayStack.length - 1] = (Iterable[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Iterable[]{null}), ClassTag$.MODULE$.apply(Iterable.class));
                Object object = package$.MODULE$.arrayToArrayOps(new ArrayOps(package$.MODULE$.arrayToArrayOps(this.strawman$collection$immutable$TrieIterator$$posStack)).tail());
                this.strawman$collection$immutable$TrieIterator$$posStack = (int[])ArrayOps$.MODULE$.$plus$plus$extension(object, package$.MODULE$.arrayToView(Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}), ClassTag$.MODULE$.apply(Integer.TYPE))), ClassTag$.MODULE$.apply(Integer.TYPE));
                tuple2 = Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(this.newIterator(snd), (Object)BoxesRunTime.boxToInteger((int)szsnd)), (Object)this);
            } else {
                Tuple2 tuple22 = new ArrayOps(package$.MODULE$.arrayToArrayOps(this.strawman$collection$immutable$TrieIterator$$arrayStack[0])).splitAt(this.strawman$collection$immutable$TrieIterator$$arrayStack[0].length - (this.strawman$collection$immutable$TrieIterator$$arrayStack[0].length - this.strawman$collection$immutable$TrieIterator$$posStack[0] + 1) / 2);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                Iterable[] fst = (Iterable[])tuple22._1();
                Iterable[] snd = (Iterable[])tuple22._2();
                Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)fst, (Object)snd);
                Iterable[] fst2 = (Iterable[])tuple23._1();
                Iterable[] snd2 = (Iterable[])tuple23._2();
                this.strawman$collection$immutable$TrieIterator$$arrayStack[0] = fst2;
                tuple2 = Tuple2$.MODULE$.apply(this.iteratorWithSize(snd2), (Object)this);
            }
        } else if (this.strawman$collection$immutable$TrieIterator$$posD == this.strawman$collection$immutable$TrieIterator$$arrayD.length - 1) {
            Iterable<T> m = this.strawman$collection$immutable$TrieIterator$$arrayD[this.strawman$collection$immutable$TrieIterator$$posD];
            tuple2 = this.arrayToIterators(this.isTrie(m) ? this.getElems(m) : this.collisionToArray(m));
        } else {
            Tuple2 tuple24 = new ArrayOps(package$.MODULE$.arrayToArrayOps(this.strawman$collection$immutable$TrieIterator$$arrayD)).splitAt(this.strawman$collection$immutable$TrieIterator$$arrayD.length - (this.strawman$collection$immutable$TrieIterator$$arrayD.length - this.strawman$collection$immutable$TrieIterator$$posD + 1) / 2);
            if (tuple24 == null) {
                throw new MatchError(tuple24);
            }
            Iterable[] fst = (Iterable[])tuple24._1();
            Iterable[] snd = (Iterable[])tuple24._2();
            Tuple2 tuple25 = Tuple2$.MODULE$.apply((Object)fst, (Object)snd);
            Iterable[] fst3 = (Iterable[])tuple25._1();
            Iterable[] snd3 = (Iterable[])tuple25._2();
            this.strawman$collection$immutable$TrieIterator$$arrayD = fst3;
            tuple2 = Tuple2$.MODULE$.apply(this.iteratorWithSize(snd3), (Object)this);
        }
        return tuple2;
    }

    private static HashMap<Object, Object> collisionToArray$$anonfun$1(Tuple2<Object, Object> x) {
        return (HashMap)HashMap$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{x}));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private static HashSet collisionToArray$$anonfun$2(Nothing$ x) {
        return (HashSet)HashSet$.MODULE$.apply(Predef$.MODULE$.genericWrapArray((Object)new Nothing$[]{x}));
    }

    private static int iteratorWithSize$$anonfun$1(Iterable<T> _$84) {
        return _$84.size();
    }

    private void split$$anonfun$1(int i) {
        this.strawman$collection$immutable$TrieIterator$$arrayStack[i - 1] = this.strawman$collection$immutable$TrieIterator$$arrayStack[i];
    }

    public static final class DupIterator
    extends TrieIterator<T> {
        private final TrieIterator $outer;

        public DupIterator(TrieIterator $outer, Iterable<T>[] xs) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(xs);
        }

        @Override
        public int initDepth() {
            return this.strawman$collection$immutable$TrieIterator$DupIterator$$$outer().strawman$collection$immutable$TrieIterator$$depth;
        }

        @Override
        public Iterable<T>[][] initArrayStack() {
            return this.strawman$collection$immutable$TrieIterator$DupIterator$$$outer().strawman$collection$immutable$TrieIterator$$arrayStack;
        }

        @Override
        public int[] initPosStack() {
            return this.strawman$collection$immutable$TrieIterator$DupIterator$$$outer().strawman$collection$immutable$TrieIterator$$posStack;
        }

        @Override
        public Iterable<T>[] initArrayD() {
            return this.strawman$collection$immutable$TrieIterator$DupIterator$$$outer().strawman$collection$immutable$TrieIterator$$arrayD;
        }

        @Override
        public int initPosD() {
            return this.strawman$collection$immutable$TrieIterator$DupIterator$$$outer().strawman$collection$immutable$TrieIterator$$posD;
        }

        @Override
        public Iterator<T> initSubIter() {
            return this.strawman$collection$immutable$TrieIterator$DupIterator$$$outer().strawman$collection$immutable$TrieIterator$$subIter;
        }

        @Override
        public final T getElem(Object x) {
            return this.strawman$collection$immutable$TrieIterator$DupIterator$$$outer().getElem(x);
        }

        private TrieIterator<T> $outer() {
            return this.$outer;
        }

        public final TrieIterator<T> strawman$collection$immutable$TrieIterator$DupIterator$$$outer() {
            return this.$outer();
        }
    }
}

