/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.mutable;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.compat.java8.JFunction1;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import strawman.collection.ArrayOps;
import strawman.collection.Iterator;
import strawman.collection.Iterator$;
import strawman.collection.mutable.FlatHashTable$;
import strawman.collection.mutable.FlatHashTable$NullSentinel$;
import strawman.collection.mutable.HashTable$;
import strawman.collection.package$;

public final class FlatHashTable<A>
implements HashUtils<A> {
    private transient int _loadFactor = FlatHashTable$.MODULE$.defaultLoadFactor();
    private transient Object[] table = new Object[this.initialCapacity()];
    private transient int tableSize = 0;
    private transient int threshold = FlatHashTable$.MODULE$.newThreshold(this._loadFactor(), this.initialCapacity());
    private transient int[] sizemap = null;
    private transient int seedvalue = this.tableSizeSeed();

    public static int sizeForThreshold(int n, int n2) {
        return FlatHashTable$.MODULE$.sizeForThreshold(n, n2);
    }

    public static ThreadLocal seedGenerator() {
        return FlatHashTable$.MODULE$.seedGenerator();
    }

    public static int loadFactorDenum() {
        return FlatHashTable$.MODULE$.loadFactorDenum();
    }

    public static int defaultLoadFactor() {
        return FlatHashTable$.MODULE$.defaultLoadFactor();
    }

    public static int newThreshold(int n, int n2) {
        return FlatHashTable$.MODULE$.newThreshold(n, n2);
    }

    private boolean tableDebug() {
        return false;
    }

    public int _loadFactor() {
        return this._loadFactor;
    }

    public void _loadFactor_$eq(int x$1) {
        this._loadFactor = x$1;
    }

    public Object[] table() {
        return this.table;
    }

    public void table_$eq(Object[] x$1) {
        this.table = x$1;
    }

    public int tableSize() {
        return this.tableSize;
    }

    public void tableSize_$eq(int x$1) {
        this.tableSize = x$1;
    }

    public int threshold() {
        return this.threshold;
    }

    public void threshold_$eq(int x$1) {
        this.threshold = x$1;
    }

    public int[] sizemap() {
        return this.sizemap;
    }

    public void sizemap_$eq(int[] x$1) {
        this.sizemap = x$1;
    }

    public int seedvalue() {
        return this.seedvalue;
    }

    public void seedvalue_$eq(int x$1) {
        this.seedvalue = x$1;
    }

    public int capacity(int expectedSize) {
        return HashTable$.MODULE$.nextPositivePowerOfTwo(expectedSize);
    }

    public int initialSize() {
        return 32;
    }

    private int initialCapacity() {
        return this.capacity(this.initialSize());
    }

    public int randomSeed() {
        return FlatHashTable$.MODULE$.seedGenerator().get().nextInt();
    }

    public int tableSizeSeed() {
        return Integer.bitCount(this.table().length - 1);
    }

    public void init(ObjectInputStream in, Function1<A, BoxedUnit> f) {
        in.defaultReadObject();
        this._loadFactor_$eq(in.readInt());
        Predef$.MODULE$.assert(this._loadFactor() > 0);
        int size = in.readInt();
        this.tableSize_$eq(0);
        Predef$.MODULE$.assert(size >= 0);
        this.table_$eq(new Object[this.capacity(FlatHashTable$.MODULE$.sizeForThreshold(size, this._loadFactor()))]);
        this.threshold_$eq(FlatHashTable$.MODULE$.newThreshold(this._loadFactor(), this.table().length));
        this.seedvalue_$eq(in.readInt());
        boolean smDefined = in.readBoolean();
        if (smDefined) {
            this.sizeMapInit(this.table().length);
        } else {
            this.sizemap_$eq(null);
        }
        for (int index = 0; index < size; ++index) {
            Object elem = this.entryToElem(in.readObject());
            f.apply(elem);
            this.addElem(elem);
        }
    }

    public void serializeTo(ObjectOutputStream out) {
        out.defaultWriteObject();
        out.writeInt(this._loadFactor());
        out.writeInt(this.tableSize());
        out.writeInt(this.seedvalue());
        out.writeBoolean(this.isSizeMapDefined());
        this.iterator().foreach(arg_0 -> FlatHashTable.serializeTo$$anonfun$1(out, arg_0));
    }

    public Option<A> findEntry(A elem) {
        None$ none$;
        Object object = this.findElemImpl(elem);
        if (object == null) {
            none$ = None$.MODULE$;
        } else {
            Object entry = object;
            none$ = Some$.MODULE$.apply(this.entryToElem(entry));
        }
        return none$;
    }

    public boolean containsElem(A elem) {
        return this.findElemImpl(elem) != null;
    }

    private Object findElemImpl(A elem) {
        Object searchEntry = this.elemToEntry(elem);
        int h = this.index(searchEntry.hashCode());
        Object curEntry = this.table()[h];
        while (curEntry != null && !BoxesRunTime.equals((Object)curEntry, (Object)searchEntry)) {
            h = (h + 1) % this.table().length;
            curEntry = this.table()[h];
        }
        return curEntry;
    }

    public boolean addElem(A elem) {
        return this.addEntry(this.elemToEntry(elem));
    }

    public boolean addEntry(Object newEntry) {
        block2: {
            int h = this.index(newEntry.hashCode());
            Object curEntry = this.table()[h];
            while (curEntry != null) {
                if (BoxesRunTime.equals((Object)curEntry, (Object)newEntry)) {
                    return false;
                }
                h = (h + 1) % this.table().length;
                curEntry = this.table()[h];
            }
            this.table()[h] = newEntry;
            this.tableSize_$eq(this.tableSize() + 1);
            this.nnSizeMapAdd(h);
            if (this.tableSize() < this.threshold()) break block2;
            this.growTable();
        }
        return true;
    }

    public boolean removeElem(A elem) {
        if (this.tableDebug()) {
            this.checkConsistent();
        }
        Object removalEntry = this.elemToEntry(elem);
        int h = this.index(removalEntry.hashCode());
        Object curEntry = this.table()[h];
        while (curEntry != null) {
            if (BoxesRunTime.equals((Object)curEntry, (Object)removalEntry)) {
                int h0 = h;
                int h1 = (h0 + 1) % this.table().length;
                while (this.table()[h1] != null) {
                    int h2 = this.index(this.table()[h1].hashCode());
                    if (h2 != h1 && this.precedes$1(h2, h0)) {
                        this.table()[h0] = this.table()[h1];
                        h0 = h1;
                    }
                    h1 = (h1 + 1) % this.table().length;
                }
                this.table()[h0] = null;
                this.tableSize_$eq(this.tableSize() - 1);
                this.nnSizeMapRemove(h0);
                if (this.tableDebug()) {
                    this.checkConsistent();
                }
                return true;
            }
            h = (h + 1) % this.table().length;
            curEntry = this.table()[h];
        }
        return false;
    }

    public Iterator<A> iterator() {
        return new Iterator<A>(this){
            private int i;
            private final FlatHashTable $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.i = 0;
            }

            private int i() {
                return this.i;
            }

            private void i_$eq(int x$1) {
                this.i = x$1;
            }

            public boolean hasNext() {
                while (this.i() < this.strawman$collection$mutable$FlatHashTable$_$$anon$$$outer().table().length && this.strawman$collection$mutable$FlatHashTable$_$$anon$$$outer().table()[this.i()] == null) {
                    this.i_$eq(this.i() + 1);
                }
                return this.i() < this.strawman$collection$mutable$FlatHashTable$_$$anon$$$outer().table().length;
            }

            public A next() {
                Object object;
                if (this.hasNext()) {
                    this.i_$eq(this.i() + 1);
                    object = this.strawman$collection$mutable$FlatHashTable$_$$anon$$$outer().entryToElem(this.strawman$collection$mutable$FlatHashTable$_$$anon$$$outer().table()[this.i() - 1]);
                } else {
                    object = Iterator$.MODULE$.empty().next();
                }
                return (A)object;
            }

            private FlatHashTable<A> $outer() {
                return this.$outer;
            }

            public final FlatHashTable<A> strawman$collection$mutable$FlatHashTable$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    private void growTable() {
        block1: {
            Object[] oldtable = this.table();
            this.table_$eq(new Object[this.table().length * 2]);
            this.tableSize_$eq(0);
            this.nnSizeMapReset(this.table().length);
            this.seedvalue_$eq(this.tableSizeSeed());
            this.threshold_$eq(FlatHashTable$.MODULE$.newThreshold(this._loadFactor(), this.table().length));
            for (int i = 0; i < oldtable.length; ++i) {
                Object entry = oldtable[i];
                Object object = entry != null ? BoxesRunTime.boxToBoolean((boolean)this.addEntry(entry)) : BoxedUnit.UNIT;
            }
            if (!this.tableDebug()) break block1;
            this.checkConsistent();
        }
    }

    private void checkConsistent() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.table().length).foreach((Function1)((JFunction1.mcVI.sp)this::checkConsistent$$anonfun$1));
    }

    public final void nnSizeMapAdd(int h) {
        block0: {
            if (this.sizemap() == null) break block0;
            int p = h >> this.sizeMapBucketBitSize();
            int[] $61$ = this.sizemap();
            $61$[p] = $61$[p] + 1;
        }
    }

    public final void nnSizeMapRemove(int h) {
        block0: {
            if (this.sizemap() == null) break block0;
            int[] $62$ = this.sizemap();
            int i$4 = h >> this.sizeMapBucketBitSize();
            $62$[i$4] = $62$[i$4] - 1;
        }
    }

    public final void nnSizeMapReset(int tableLength) {
        block2: {
            if (this.sizemap() == null) break block2;
            int nsize = this.calcSizeMapSize(tableLength);
            if (this.sizemap().length != nsize) {
                this.sizemap_$eq(new int[nsize]);
            } else {
                Arrays.fill(this.sizemap(), 0);
            }
        }
    }

    public final int totalSizeMapBuckets() {
        return (this.table().length - 1) / this.sizeMapBucketSize() + 1;
    }

    public final int calcSizeMapSize(int tableLength) {
        return (tableLength >> this.sizeMapBucketBitSize()) + 1;
    }

    public final void sizeMapInit(int tableLength) {
        this.sizemap_$eq(new int[this.calcSizeMapSize(tableLength)]);
    }

    public final void sizeMapInitAndRebuild() {
        this.sizeMapInit(this.table().length);
        int totalbuckets = this.totalSizeMapBuckets();
        int tableidx = 0;
        Object[] tbl = this.table();
        int tableuntil = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.sizeMapBucketSize()), tbl.length);
        for (int bucketidx = 0; bucketidx < totalbuckets; ++bucketidx) {
            int currbucketsz = 0;
            while (tableidx < tableuntil) {
                if (tbl[tableidx] != null) {
                    ++currbucketsz;
                }
                ++tableidx;
            }
            this.sizemap()[bucketidx] = currbucketsz;
            tableuntil += this.sizeMapBucketSize();
        }
    }

    public void printSizeMap() {
        Predef$.MODULE$.println((Object)new ArrayOps(package$.MODULE$.arrayToArrayOps(this.sizemap())).mkString("szmap: [", ", ", "]"));
    }

    public void printContents() {
        Predef$.MODULE$.println((Object)new ArrayOps(package$.MODULE$.arrayToArrayOps(this.table())).mkString("[", ", ", "]"));
    }

    public void sizeMapDisable() {
        this.sizemap_$eq(null);
    }

    public boolean isSizeMapDefined() {
        return this.sizemap() != null;
    }

    public boolean alwaysInitSizeMap() {
        return false;
    }

    public int index(int hcode) {
        int improved = this.improve(hcode, this.seedvalue());
        int ones = this.table().length - 1;
        return improved >>> 32 - Integer.bitCount(ones) & ones;
    }

    public void clearTable() {
        for (int i = this.table().length - 1; i >= 0; --i) {
            this.table()[i] = null;
        }
        this.tableSize_$eq(0);
        this.nnSizeMapReset(this.table().length);
    }

    public Contents<A> hashTableContents() {
        return new Contents(this._loadFactor(), this.table(), this.tableSize(), this.threshold(), this.seedvalue(), this.sizemap());
    }

    public void initWithContents(Contents<A> c) {
        block1: {
            if (c != null) {
                this._loadFactor_$eq(c.loadFactor());
                this.table_$eq(c.table());
                this.tableSize_$eq(c.tableSize());
                this.threshold_$eq(c.threshold());
                this.seedvalue_$eq(c.seedvalue());
                this.sizemap_$eq(c.sizemap());
            }
            if (!this.alwaysInitSizeMap() || this.sizemap() != null) break block1;
            this.sizeMapInitAndRebuild();
        }
    }

    private static void serializeTo$$anonfun$1(ObjectOutputStream out$1, Object x$0) {
        out$1.writeObject(x$0);
    }

    private boolean precedes$1(int i, int j) {
        int d = this.table().length >> 1;
        return i <= j ? j - i < d : i - j > d;
    }

    private String checkConsistent$$anonfun$2$$anonfun$1(int i$15) {
        return i$15 + " " + this.table()[i$15] + " " + new ArrayOps(package$.MODULE$.arrayToArrayOps(this.table())).mkString();
    }

    private void checkConsistent$$anonfun$1(int i) {
        block0: {
            if (this.table()[i] == null || this.containsElem(this.entryToElem(this.table()[i]))) break block0;
            Predef$.MODULE$.assert(false, () -> this.checkConsistent$$anonfun$2$$anonfun$1(i));
        }
    }

    public static class Contents<A> {
        private final int loadFactor;
        private final Object[] table;
        private final int tableSize;
        private final int threshold;
        private final int seedvalue;
        private final int[] sizemap;

        public <A> Contents(int loadFactor, Object[] table, int tableSize, int threshold, int seedvalue, int[] sizemap) {
            this.loadFactor = loadFactor;
            this.table = table;
            this.tableSize = tableSize;
            this.threshold = threshold;
            this.seedvalue = seedvalue;
            this.sizemap = sizemap;
        }

        public int loadFactor() {
            return this.loadFactor;
        }

        public Object[] table() {
            return this.table;
        }

        public int tableSize() {
            return this.tableSize;
        }

        public int threshold() {
            return this.threshold;
        }

        public int seedvalue() {
            return this.seedvalue;
        }

        public int[] sizemap() {
            return this.sizemap;
        }
    }

    public static interface HashUtils<A> {
        default public <A> void $init$() {
        }

        default public int sizeMapBucketBitSize() {
            return 5;
        }

        default public int sizeMapBucketSize() {
            return 1 << this.sizeMapBucketBitSize();
        }

        default public int improve(int hcode, int seed) {
            return Integer.rotateRight(scala.util.hashing.package$.MODULE$.byteswap32(hcode), seed);
        }

        default public Object elemToEntry(A elem) {
            return elem == null ? FlatHashTable$NullSentinel$.MODULE$ : elem;
        }

        default public A entryToElem(Object entry) {
            return (A)(entry == FlatHashTable$NullSentinel$.MODULE$ ? null : entry);
        }
    }
}

