/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.mutable;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some$;
import scala.compat.java8.JProcedure1;
import scala.math.Integral;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing;
import strawman.collection.Iterable;
import strawman.collection.IterableFactory;
import strawman.collection.IterableOnce;
import strawman.collection.Iterator;
import strawman.collection.Iterator$;
import strawman.collection.Set;
import strawman.collection.SetOps;
import strawman.collection.mutable.Builder;
import strawman.collection.mutable.HashEntry;
import strawman.collection.mutable.HashTable;
import strawman.collection.mutable.LinkedHashSet$;

public class LinkedHashSet<A>
implements strawman.collection.mutable.Set<A>,
Serializable {
    private transient Entry firstEntry;
    private transient Entry lastEntry;
    private HashTable<A, Object, Entry<A>> table;

    public static <E> LinkedHashSet<E> from(IterableOnce<E> iterableOnce) {
        return LinkedHashSet$.MODULE$.from(iterableOnce);
    }

    public static Object iterate(Object object, int n, Function1 function1) {
        return LinkedHashSet$.MODULE$.iterate(object, n, function1);
    }

    public static <A> Builder<A, LinkedHashSet<A>> newBuilder() {
        return LinkedHashSet$.MODULE$.newBuilder();
    }

    public static Object range(Object object, Object object2, Object object3, Integral integral) {
        return LinkedHashSet$.MODULE$.range(object, object2, object3, integral);
    }

    public static Object range(Object object, Object object2, Integral integral) {
        return LinkedHashSet$.MODULE$.range(object, object2, integral);
    }

    public <A> LinkedHashSet() {
        Function1.$init$((Function1)this);
        this.firstEntry = null;
        this.lastEntry = null;
        this.table = new HashTable<A, Object, Entry<A>>(this){
            private final LinkedHashSet $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            /*
             * WARNING - void declaration
             */
            public Entry<A> createNewEntry(A key, Object value) {
                void var3_3;
                Entry<A> e = new Entry<A>(key);
                if (this.strawman$collection$mutable$LinkedHashSet$_$$anon$$$outer().firstEntry() == null) {
                    this.strawman$collection$mutable$LinkedHashSet$_$$anon$$$outer().firstEntry_$eq(e);
                } else {
                    this.strawman$collection$mutable$LinkedHashSet$_$$anon$$$outer().lastEntry().later_$eq(e);
                    e.earlier_$eq(this.strawman$collection$mutable$LinkedHashSet$_$$anon$$$outer().lastEntry());
                }
                this.strawman$collection$mutable$LinkedHashSet$_$$anon$$$outer().lastEntry_$eq(e);
                return var3_3;
            }

            public <U> void foreachEntry(Function1<Entry<A>, U> f) {
                for (Entry<A> cur = this.strawman$collection$mutable$LinkedHashSet$_$$anon$$$outer().firstEntry(); cur != null; cur = cur.later()) {
                    f.apply((Object)cur);
                }
            }

            private LinkedHashSet<A> $outer() {
                return this.$outer;
            }

            public final LinkedHashSet<A> strawman$collection$mutable$LinkedHashSet$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    public <A> Function1<A, Object> compose(Function1<A, A> g) {
        return Function1.compose$((Function1)this, g);
    }

    public <A> Function1<A, A> andThen(Function1<Object, A> g) {
        return Function1.andThen$((Function1)this, g);
    }

    @Override
    public String toString() {
        return SetOps.super.toString();
    }

    @Override
    public boolean equals(Object that) {
        return Set.super.equals(that);
    }

    @Override
    public int hashCode() {
        return Set.super.hashCode();
    }

    @Override
    public LinkedHashSet<A> clone() {
        return (LinkedHashSet)strawman.collection.mutable.SetOps.super.clone();
    }

    @Override
    public IterableFactory<LinkedHashSet> iterableFactory() {
        return LinkedHashSet$.MODULE$;
    }

    public Entry firstEntry() {
        return this.firstEntry;
    }

    public void firstEntry_$eq(Entry x$1) {
        this.firstEntry = x$1;
    }

    public Entry lastEntry() {
        return this.lastEntry;
    }

    public void lastEntry_$eq(Entry x$1) {
        this.lastEntry = x$1;
    }

    @Override
    public Option<A> get(A elem) {
        Entry<A> entry = this.table.findEntry(elem);
        return entry != null ? Some$.MODULE$.apply(entry.key()) : None$.MODULE$;
    }

    @Override
    public LinkedHashSet<A> empty() {
        return LinkedHashSet$.MODULE$.empty();
    }

    @Override
    public LinkedHashSet<A> fromSpecificIterable(Iterable<A> coll) {
        return (LinkedHashSet)this.fromIterable(coll);
    }

    @Override
    public Builder<A, LinkedHashSet<A>> newSpecificBuilder() {
        return this.iterableFactory().newBuilder();
    }

    @Override
    public int size() {
        return this.table.tableSize();
    }

    @Override
    public boolean contains(A elem) {
        return this.table.findEntry(elem) != null;
    }

    @Override
    public LinkedHashSet add(A elem) {
        this.table.findOrAddEntry(elem, null);
        return this;
    }

    @Override
    public LinkedHashSet subtract(A elem) {
        this.remove(elem);
        return this;
    }

    @Override
    public Option<A> remove(A elem) {
        None$ none$;
        Entry e = this.table.removeEntry(elem);
        if (e == null) {
            none$ = None$.MODULE$;
        } else {
            if (e.earlier() == null) {
                this.firstEntry_$eq(e.later());
            } else {
                e.earlier().later_$eq(e.later());
            }
            if (e.later() == null) {
                this.lastEntry_$eq(e.earlier());
            } else {
                e.later().earlier_$eq(e.earlier());
            }
            e.earlier_$eq(null);
            e.later_$eq(null);
            none$ = Some$.MODULE$.apply(e.key());
        }
        return none$;
    }

    @Override
    public Iterator<A> iterator() {
        return new Iterator<A>(this){
            private Entry cur;
            private final LinkedHashSet $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.cur = this.strawman$collection$mutable$LinkedHashSet$_$$anon$$$outer().firstEntry();
            }

            private Entry cur() {
                return this.cur;
            }

            private void cur_$eq(Entry x$1) {
                this.cur = x$1;
            }

            public boolean hasNext() {
                return this.cur() != null;
            }

            /*
             * WARNING - void declaration
             */
            public A next() {
                Nothing nothing;
                if (this.hasNext()) {
                    void var1_1;
                    A res = this.cur().key();
                    this.cur_$eq(this.cur().later());
                    nothing = var1_1;
                } else {
                    nothing = Iterator$.MODULE$.empty().next();
                }
                return (A)nothing;
            }

            private LinkedHashSet<A> $outer() {
                return this.$outer;
            }

            public final LinkedHashSet<A> strawman$collection$mutable$LinkedHashSet$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    @Override
    public <U> void foreach(Function1<A, U> f) {
        for (Entry cur = this.firstEntry(); cur != null; cur = cur.later()) {
            f.apply(cur.key());
        }
    }

    @Override
    public void clear() {
        this.table.clearTable();
        this.firstEntry_$eq(null);
        this.lastEntry_$eq(null);
    }

    private void writeObject(ObjectOutputStream out) {
        this.table.serializeTo(out, (Function1<Entry<A>, BoxedUnit>)((JProcedure1)arg_0 -> LinkedHashSet.writeObject$$anonfun$1(out, arg_0)));
    }

    private void readObject(ObjectInputStream in) {
        this.firstEntry_$eq(null);
        this.lastEntry_$eq(null);
        this.table.init(in, () -> this.readObject$$anonfun$1(in));
    }

    private static void writeObject$$anonfun$1(ObjectOutputStream out$4, Entry e) {
        out$4.writeObject(e.key());
    }

    private Entry readObject$$anonfun$1(ObjectInputStream in$3) {
        return this.table.createNewEntry(in$3.readObject(), null);
    }

    public static final class Entry<A>
    implements HashEntry<A, Entry<A>>,
    Serializable {
        private HashEntry next;
        private final Object key;
        private Entry earlier;
        private Entry later;

        public <A> Entry(A key) {
            this.key = key;
            this.next = HashEntry.super.initial$next();
            this.earlier = null;
            this.later = null;
        }

        @Override
        public HashEntry next() {
            return this.next;
        }

        @Override
        public void next_$eq(HashEntry x$1) {
            this.next = x$1;
        }

        @Override
        public A key() {
            return (A)this.key;
        }

        public Entry<A> earlier() {
            return this.earlier;
        }

        public void earlier_$eq(Entry<A> x$1) {
            this.earlier = x$1;
        }

        public Entry<A> later() {
            return this.later;
        }

        public void later_$eq(Entry<A> x$1) {
            this.later = x$1;
        }
    }
}

