/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection;

import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import strawman.collection.IndexedView;
import strawman.collection.Iterable;
import strawman.collection.IterableFactoryLike;
import strawman.collection.IterableOnce;
import strawman.collection.Iterator;
import strawman.collection.Iterator$;
import strawman.collection.View$;
import strawman.collection.View$Append$;
import strawman.collection.View$Concat$;
import strawman.collection.View$DistinctBy$;
import strawman.collection.View$Drop$;
import strawman.collection.View$DropWhile$;
import strawman.collection.View$Elems$;
import strawman.collection.View$Fill$;
import strawman.collection.View$Filter$;
import strawman.collection.View$FilterKeys$;
import strawman.collection.View$FlatMap$;
import strawman.collection.View$Map$;
import strawman.collection.View$MapValues$;
import strawman.collection.View$PadTo$;
import strawman.collection.View$Partition$;
import strawman.collection.View$Partitioned$;
import strawman.collection.View$Prepend$;
import strawman.collection.View$ScanLeft$;
import strawman.collection.View$Single$;
import strawman.collection.View$Tabulate$;
import strawman.collection.View$Take$;
import strawman.collection.View$TakeWhile$;
import strawman.collection.View$Unzip$;
import strawman.collection.View$Updated$;
import strawman.collection.View$Zip$;
import strawman.collection.View$ZipWithIndex$;
import strawman.collection.immutable.IndexedSeq;
import strawman.collection.immutable.IndexedSeq$;
import strawman.collection.mutable.Builder;

public interface View<A>
extends Iterable<A> {
    @Override
    default public <A> void $init$() {
    }

    @Override
    default public View<A> view() {
        return this;
    }

    @Override
    default public IterableFactoryLike<View> iterableFactory() {
        return View$.MODULE$;
    }

    @Override
    default public View<A> fromSpecificIterable(Iterable<A> coll) {
        View IterableOps_this = this;
        return IterableOps_this.iterableFactory().from(coll);
    }

    @Override
    default public Builder<A, View<A>> newSpecificBuilder() {
        return IndexedSeq$.MODULE$.newBuilder().mapResult(View::newSpecificBuilder$$anonfun$1);
    }

    @Override
    default public String toString() {
        return "View(?)";
    }

    @Override
    default public String className() {
        return "View";
    }

    private static IndexedView<A> newSpecificBuilder$$anonfun$1(IndexedSeq<A> _$59) {
        return _$59.view();
    }

    public static class Append<A>
    implements View<A>,
    Product {
        private final Iterable underlying;
        private final Object elem;

        public static <A> Append<A> apply(Iterable<A> iterable, A a) {
            return View$Append$.MODULE$.apply(iterable, a);
        }

        public static <A> Append<A> unapply(Append<A> append) {
            return View$Append$.MODULE$.unapply(append);
        }

        public <A> Append(Iterable<A> underlying, A elem) {
            this.underlying = underlying;
            this.elem = elem;
            Product.$init$((Product)this);
        }

        @Override
        public View<A> view() {
            return View.super.view();
        }

        @Override
        public String toString() {
            return View.super.toString();
        }

        @Override
        public String className() {
            return View.super.className();
        }

        public scala.collection.Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterable<A> underlying() {
            return this.underlying;
        }

        public A elem() {
            return (A)this.elem;
        }

        @Override
        public Iterator<A> iterator() {
            return View$Concat$.MODULE$.apply(this.underlying(), View$Single$.MODULE$.apply(this.elem())).iterator();
        }

        @Override
        public int knownSize() {
            return this.underlying().knownSize() >= 0 ? this.underlying().knownSize() + 1 : -1;
        }

        public <A> Append<A> copy(Iterable<A> underlying, A elem) {
            return new Append<A>(underlying, elem);
        }

        public <A> Iterable<A> copy$default$1() {
            return this.underlying();
        }

        public <A> A copy$default$2() {
            return this.elem();
        }

        public Iterable<A> _1() {
            return this.underlying();
        }

        public A _2() {
            return this.elem();
        }

        public int hashCode() {
            int n = 1784330302;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.underlying()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.elem()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (object instanceof Append) {
                Append append;
                Append append2 = append = (Append)object;
                Iterable<A> iterable = this.underlying();
                Iterable<A> iterable2 = append2.underlying();
                if (iterable == null) {
                    if (iterable2 != null) {
                        return false;
                    }
                } else if (!iterable.equals(iterable2)) return false;
                if (!BoxesRunTime.equals(this.elem(), append2.elem())) return false;
                return true;
            }
            if (!(object instanceof Object)) throw new MatchError(object);
            Object object2 = object;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Append;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Append";
        }

        public Object productElement(int n) {
            Iterable<A> iterable;
            int n2 = n;
            if (0 == n2) {
                iterable = this._1();
            } else if (1 == n2) {
                iterable = this._2();
            } else {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            return iterable;
        }
    }

    public static class Concat<A>
    implements View<A>,
    Product {
        private final Iterable prefix;
        private final Iterable suffix;

        public static <A> Concat<A> apply(Iterable<A> iterable, Iterable<A> iterable2) {
            return View$Concat$.MODULE$.apply(iterable, iterable2);
        }

        public static <A> Concat<A> unapply(Concat<A> concat) {
            return View$Concat$.MODULE$.unapply(concat);
        }

        public <A> Concat(Iterable<A> prefix, Iterable<A> suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
            Product.$init$((Product)this);
        }

        @Override
        public View<A> view() {
            return View.super.view();
        }

        @Override
        public String toString() {
            return View.super.toString();
        }

        @Override
        public String className() {
            return View.super.className();
        }

        public scala.collection.Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterable<A> prefix() {
            return this.prefix;
        }

        public Iterable<A> suffix() {
            return this.suffix;
        }

        @Override
        public Iterator<A> iterator() {
            Iterator Iterator_this = this.prefix().iterator();
            return Iterator_this.concat(this::iterator$$anonfun$1);
        }

        @Override
        public int knownSize() {
            return this.prefix().knownSize() >= 0 && this.suffix().knownSize() >= 0 ? this.prefix().knownSize() + this.prefix().knownSize() : -1;
        }

        public <A> Concat<A> copy(Iterable<A> prefix, Iterable<A> suffix) {
            return new Concat<A>(prefix, suffix);
        }

        public <A> Iterable<A> copy$default$1() {
            return this.prefix();
        }

        public <A> Iterable<A> copy$default$2() {
            return this.suffix();
        }

        public Iterable<A> _1() {
            return this.prefix();
        }

        public Iterable<A> _2() {
            return this.suffix();
        }

        public int hashCode() {
            int n = 1840603192;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.prefix()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.suffix()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (object instanceof Concat) {
                Concat concat;
                Concat concat2 = concat = (Concat)object;
                Iterable<A> iterable = this.prefix();
                Iterable<A> iterable2 = concat2.prefix();
                if (iterable == null) {
                    if (iterable2 != null) {
                        return false;
                    }
                } else if (!iterable.equals(iterable2)) return false;
                Iterable<A> iterable3 = this.suffix();
                Iterable<A> iterable4 = concat2.suffix();
                if (iterable3 == null) {
                    if (iterable4 == null) return true;
                    return false;
                } else {
                    if (!iterable3.equals(iterable4)) return false;
                    return true;
                }
            }
            if (!(object instanceof Object)) throw new MatchError(object);
            Object object2 = object;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Concat;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Concat";
        }

        public Object productElement(int n) {
            Iterable<A> iterable;
            int n2 = n;
            if (0 == n2) {
                iterable = this._1();
            } else if (1 == n2) {
                iterable = this._2();
            } else {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            return iterable;
        }

        private Iterator<A> xs$1() {
            return this.suffix().iterator();
        }

        private Iterator<A> iterator$$anonfun$1() {
            return this.xs$1();
        }
    }

    public static class DistinctBy<A, B>
    implements View<A>,
    Product {
        private final Iterable underlying;
        private final Function1 f;

        public static <A, B> DistinctBy<A, B> apply(Iterable<A> iterable, Function1<A, B> function1) {
            return View$DistinctBy$.MODULE$.apply(iterable, function1);
        }

        public static <A, B> DistinctBy<A, B> unapply(DistinctBy<A, B> distinctBy) {
            return View$DistinctBy$.MODULE$.unapply(distinctBy);
        }

        public <A, B> DistinctBy(Iterable<A> underlying, Function1<A, B> f) {
            this.underlying = underlying;
            this.f = f;
            Product.$init$((Product)this);
        }

        @Override
        public View<A> view() {
            return View.super.view();
        }

        @Override
        public String toString() {
            return View.super.toString();
        }

        @Override
        public String className() {
            return View.super.className();
        }

        public scala.collection.Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterable<A> underlying() {
            return this.underlying;
        }

        public Function1<A, B> f() {
            return this.f;
        }

        @Override
        public Iterator<A> iterator() {
            return this.underlying().iterator().distinctBy(this.f());
        }

        public <A, B> DistinctBy<A, B> copy(Iterable<A> underlying, Function1<A, B> f) {
            return new DistinctBy<A, B>(underlying, f);
        }

        public <A, B> Iterable<A> copy$default$1() {
            return this.underlying();
        }

        public <A, B> Function1<A, B> copy$default$2() {
            return this.f();
        }

        public Iterable<A> _1() {
            return this.underlying();
        }

        public Function1<A, B> _2() {
            return this.f();
        }

        public int hashCode() {
            int n = -369483881;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.underlying()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.f()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (object instanceof DistinctBy) {
                DistinctBy distinctBy;
                DistinctBy distinctBy2 = distinctBy = (DistinctBy)object;
                Iterable<A> iterable = this.underlying();
                Iterable<A> iterable2 = distinctBy2.underlying();
                if (iterable == null) {
                    if (iterable2 != null) {
                        return false;
                    }
                } else if (!iterable.equals(iterable2)) return false;
                Function1<A, B> function1 = this.f();
                Function1<A, B> function12 = distinctBy2.f();
                if (function1 == null) {
                    if (function12 == null) return true;
                    return false;
                } else {
                    if (!function1.equals(function12)) return false;
                    return true;
                }
            }
            if (!(object instanceof Object)) throw new MatchError(object);
            Object object2 = object;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof DistinctBy;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "DistinctBy";
        }

        public Object productElement(int n) {
            Iterable<A> iterable;
            int n2 = n;
            if (0 == n2) {
                iterable = this._1();
            } else if (1 == n2) {
                iterable = this._2();
            } else {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            return iterable;
        }
    }

    public static class Drop<A>
    implements View<A>,
    Product {
        private final Iterable underlying;
        private final int n;
        private final int normN;

        public static <A> Drop<A> apply(Iterable<A> iterable, int n) {
            return View$Drop$.MODULE$.apply(iterable, n);
        }

        public static <A> Drop<A> unapply(Drop<A> drop) {
            return View$Drop$.MODULE$.unapply(drop);
        }

        public <A> Drop(Iterable<A> underlying, int n) {
            this.underlying = underlying;
            this.n = n;
            Product.$init$((Product)this);
            this.normN = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(n), 0);
        }

        @Override
        public View<A> view() {
            return View.super.view();
        }

        @Override
        public String toString() {
            return View.super.toString();
        }

        @Override
        public String className() {
            return View.super.className();
        }

        public scala.collection.Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterable<A> underlying() {
            return this.underlying;
        }

        public int n() {
            return this.n;
        }

        @Override
        public Iterator<A> iterator() {
            return this.underlying().iterator().drop(this.n());
        }

        public int normN() {
            return this.normN;
        }

        @Override
        public int knownSize() {
            return this.underlying().knownSize() >= 0 ? RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.underlying().knownSize() - this.normN()), 0) : -1;
        }

        public <A> Drop<A> copy(Iterable<A> underlying, int n) {
            return new Drop<A>(underlying, n);
        }

        public <A> Iterable<A> copy$default$1() {
            return this.underlying();
        }

        public <A> int copy$default$2() {
            return this.n();
        }

        public Iterable<A> _1() {
            return this.underlying();
        }

        public int _2() {
            return this.n();
        }

        public int hashCode() {
            int n = 1083511059;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.underlying()));
            n = Statics.mix((int)n, (int)this.n());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (object instanceof Drop) {
                Drop drop;
                Drop drop2 = drop = (Drop)object;
                Iterable<A> iterable = this.underlying();
                Iterable<A> iterable2 = drop2.underlying();
                if (iterable == null) {
                    if (iterable2 != null) {
                        return false;
                    }
                } else if (!iterable.equals(iterable2)) return false;
                Integer n = BoxesRunTime.boxToInteger((int)this.n());
                Integer n2 = BoxesRunTime.boxToInteger((int)drop2.n());
                if (n == null) {
                    if (n2 == null) return true;
                    return false;
                } else {
                    if (!((Object)n).equals(n2)) return false;
                    return true;
                }
            }
            if (!(object instanceof Object)) throw new MatchError(object);
            Object object2 = object;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Drop;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Drop";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = BoxesRunTime.boxToInteger((int)this._2());
            } else {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            return object;
        }
    }

    public static class DropWhile<A>
    implements View<A>,
    Product {
        private final Iterable underlying;
        private final Function1 p;

        public static <A> DropWhile<A> apply(Iterable<A> iterable, Function1<A, Object> function1) {
            return View$DropWhile$.MODULE$.apply(iterable, function1);
        }

        public static <A> DropWhile<A> unapply(DropWhile<A> dropWhile) {
            return View$DropWhile$.MODULE$.unapply(dropWhile);
        }

        public <A> DropWhile(Iterable<A> underlying, Function1<A, Object> p) {
            this.underlying = underlying;
            this.p = p;
            Product.$init$((Product)this);
        }

        @Override
        public View<A> view() {
            return View.super.view();
        }

        @Override
        public String toString() {
            return View.super.toString();
        }

        @Override
        public String className() {
            return View.super.className();
        }

        public scala.collection.Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterable<A> underlying() {
            return this.underlying;
        }

        public Function1<A, Object> p() {
            return this.p;
        }

        @Override
        public Iterator<A> iterator() {
            return this.underlying().iterator().dropWhile(this.p());
        }

        public <A> DropWhile<A> copy(Iterable<A> underlying, Function1<A, Object> p) {
            return new DropWhile<A>(underlying, p);
        }

        public <A> Iterable<A> copy$default$1() {
            return this.underlying();
        }

        public <A> Function1<A, Object> copy$default$2() {
            return this.p();
        }

        public Iterable<A> _1() {
            return this.underlying();
        }

        public Function1<A, Object> _2() {
            return this.p();
        }

        public int hashCode() {
            int n = -61571618;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.underlying()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.p()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (object instanceof DropWhile) {
                DropWhile dropWhile;
                DropWhile dropWhile2 = dropWhile = (DropWhile)object;
                Iterable<A> iterable = this.underlying();
                Iterable<A> iterable2 = dropWhile2.underlying();
                if (iterable == null) {
                    if (iterable2 != null) {
                        return false;
                    }
                } else if (!iterable.equals(iterable2)) return false;
                Function1<A, Object> function1 = this.p();
                Function1<A, Object> function12 = dropWhile2.p();
                if (function1 == null) {
                    if (function12 == null) return true;
                    return false;
                } else {
                    if (!function1.equals(function12)) return false;
                    return true;
                }
            }
            if (!(object instanceof Object)) throw new MatchError(object);
            Object object2 = object;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof DropWhile;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "DropWhile";
        }

        public Object productElement(int n) {
            Iterable<A> iterable;
            int n2 = n;
            if (0 == n2) {
                iterable = this._1();
            } else if (1 == n2) {
                iterable = this._2();
            } else {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            return iterable;
        }
    }

    public static class Elems<A>
    implements View<A>,
    Product {
        private final Seq xs;

        public static <A> Elems<A> apply(Seq<A> seq) {
            return View$Elems$.MODULE$.apply(seq);
        }

        public static <A> Elems<A> unapply(Elems<A> elems) {
            return View$Elems$.MODULE$.unapply(elems);
        }

        public <A> Elems(Seq<A> xs) {
            this.xs = xs;
            Product.$init$((Product)this);
        }

        @Override
        public View<A> view() {
            return View.super.view();
        }

        @Override
        public String toString() {
            return View.super.toString();
        }

        @Override
        public String className() {
            return View.super.className();
        }

        public scala.collection.Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Seq<A> xs() {
            return this.xs;
        }

        @Override
        public Iterator<A> iterator() {
            return Iterator$.MODULE$.apply(this.xs());
        }

        @Override
        public int knownSize() {
            return this.xs().length();
        }

        public Seq<A> _1() {
            return this.xs();
        }

        public int hashCode() {
            int n = -770160352;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.xs()));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (object instanceof Elems) {
                Elems elems;
                Elems elems2 = elems = (Elems)object;
                Seq<A> seq = this.xs();
                Seq<A> seq2 = elems2.xs();
                if (seq != null) {
                    if (!seq.equals(seq2)) return false;
                    return true;
                }
                if (seq2 == null) return true;
                return false;
            }
            if (!(object instanceof Object)) throw new MatchError(object);
            Object object2 = object;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Elems;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Elems";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            return this._1();
        }
    }

    public static class Fill<A>
    implements View<A>,
    Product {
        private final int n;
        private final Function0<A> elem;

        public static <A> Fill<A> apply(int n, Function0<A> function0) {
            return View$Fill$.MODULE$.apply(n, function0);
        }

        public static <A> Fill<A> unapply(Fill<A> fill) {
            return View$Fill$.MODULE$.unapply(fill);
        }

        public <A> Fill(int n, Function0<A> elem) {
            this.n = n;
            this.elem = elem;
            Product.$init$((Product)this);
        }

        @Override
        public View<A> view() {
            return View.super.view();
        }

        @Override
        public String toString() {
            return View.super.toString();
        }

        @Override
        public String className() {
            return View.super.className();
        }

        public scala.collection.Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public int n() {
            return this.n;
        }

        @Override
        public Iterator<A> iterator() {
            return Iterator$.MODULE$.fill(this.n(), this.elem);
        }

        @Override
        public int knownSize() {
            return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(0), this.n());
        }

        public <A> Fill<A> copy(int n, Function0<A> elem) {
            return new Fill<A>(n, elem);
        }

        public <A> int copy$default$1() {
            return this.n();
        }

        public int _1() {
            return this.n();
        }

        public int hashCode() {
            int n = 1083561895;
            n = Statics.mix((int)n, (int)this.n());
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (object instanceof Fill) {
                Fill fill;
                Fill fill2 = fill = (Fill)object;
                Integer n = BoxesRunTime.boxToInteger((int)this.n());
                Integer n2 = BoxesRunTime.boxToInteger((int)fill2.n());
                if (n != null) {
                    if (!((Object)n).equals(n2)) return false;
                    return true;
                }
                if (n2 == null) return true;
                return false;
            }
            if (!(object instanceof Object)) throw new MatchError(object);
            Object object2 = object;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Fill;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Fill";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            return BoxesRunTime.boxToInteger((int)this._1());
        }
    }

    public static class Filter<A>
    implements View<A> {
        private final Iterable underlying;
        private final Function1 p;
        private final boolean isFlipped;

        public static <A> Filter<A> apply(Iterable<A> iterable, Function1<A, Object> function1, boolean bl) {
            return View$Filter$.MODULE$.apply(iterable, function1, bl);
        }

        public <A> Filter(Iterable<A> underlying, Function1<A, Object> p, boolean isFlipped) {
            this.underlying = underlying;
            this.p = p;
            this.isFlipped = isFlipped;
        }

        @Override
        public View<A> view() {
            return View.super.view();
        }

        @Override
        public String toString() {
            return View.super.toString();
        }

        @Override
        public String className() {
            return View.super.className();
        }

        public Iterable<A> underlying() {
            return this.underlying;
        }

        public Function1<A, Object> p() {
            return this.p;
        }

        public boolean isFlipped() {
            return this.isFlipped;
        }

        @Override
        public Iterator<A> iterator() {
            return this.underlying().iterator().filterImpl(this.p(), this.isFlipped());
        }
    }

    public static class FilterKeys<K, V>
    implements View<Tuple2<K, V>>,
    Product {
        private final Iterable underlying;
        private final Function1 p;

        public static <K, V> FilterKeys<K, V> apply(Iterable<Tuple2<K, V>> iterable, Function1<K, Object> function1) {
            return View$FilterKeys$.MODULE$.apply(iterable, function1);
        }

        public static <K, V> FilterKeys<K, V> unapply(FilterKeys<K, V> filterKeys) {
            return View$FilterKeys$.MODULE$.unapply(filterKeys);
        }

        public <K, V> FilterKeys(Iterable<Tuple2<K, V>> underlying, Function1<K, Object> p) {
            this.underlying = underlying;
            this.p = p;
            Product.$init$((Product)this);
        }

        @Override
        public View<Tuple2<K, V>> view() {
            return View.super.view();
        }

        @Override
        public String toString() {
            return View.super.toString();
        }

        @Override
        public String className() {
            return View.super.className();
        }

        public scala.collection.Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterable<Tuple2<K, V>> underlying() {
            return this.underlying;
        }

        public Function1<K, Object> p() {
            return this.p;
        }

        @Override
        public Iterator<Tuple2<K, V>> iterator() {
            return this.underlying().iterator().filter(this::iterator$$anonfun$1);
        }

        public <K, V> FilterKeys<K, V> copy(Iterable<Tuple2<K, V>> underlying, Function1<K, Object> p) {
            return new FilterKeys<K, V>(underlying, p);
        }

        public <K, V> Iterable<Tuple2<K, V>> copy$default$1() {
            return this.underlying();
        }

        public <K, V> Function1<K, Object> copy$default$2() {
            return this.p();
        }

        public Iterable<Tuple2<K, V>> _1() {
            return this.underlying();
        }

        public Function1<K, Object> _2() {
            return this.p();
        }

        public int hashCode() {
            int n = -188831568;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.underlying()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.p()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (object instanceof FilterKeys) {
                FilterKeys filterKeys;
                FilterKeys filterKeys2 = filterKeys = (FilterKeys)object;
                Iterable<Tuple2<K, V>> iterable = this.underlying();
                Iterable<Tuple2<K, V>> iterable2 = filterKeys2.underlying();
                if (iterable == null) {
                    if (iterable2 != null) {
                        return false;
                    }
                } else if (!iterable.equals(iterable2)) return false;
                Function1<K, Object> function1 = this.p();
                Function1<K, Object> function12 = filterKeys2.p();
                if (function1 == null) {
                    if (function12 == null) return true;
                    return false;
                } else {
                    if (!function1.equals(function12)) return false;
                    return true;
                }
            }
            if (!(object instanceof Object)) throw new MatchError(object);
            Object object2 = object;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof FilterKeys;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "FilterKeys";
        }

        public Object productElement(int n) {
            Iterable<Tuple2<K, V>> iterable;
            int n2 = n;
            if (0 == n2) {
                iterable = this._1();
            } else if (1 == n2) {
                iterable = this._2();
            } else {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            return iterable;
        }

        private boolean iterator$$anonfun$1(Tuple2<K, V> kv) {
            return BoxesRunTime.unboxToBoolean((Object)this.p().apply(kv._1()));
        }
    }

    public static class FlatMap<A, B>
    implements View<B>,
    Product {
        private final Iterable underlying;
        private final Function1 f;

        public static <A, B> FlatMap<A, B> apply(Iterable<A> iterable, Function1<A, IterableOnce<B>> function1) {
            return View$FlatMap$.MODULE$.apply(iterable, function1);
        }

        public static <A, B> FlatMap<A, B> unapply(FlatMap<A, B> flatMap) {
            return View$FlatMap$.MODULE$.unapply(flatMap);
        }

        public <A, B> FlatMap(Iterable<A> underlying, Function1<A, IterableOnce<B>> f) {
            this.underlying = underlying;
            this.f = f;
            Product.$init$((Product)this);
        }

        @Override
        public View<B> view() {
            return View.super.view();
        }

        @Override
        public String toString() {
            return View.super.toString();
        }

        @Override
        public String className() {
            return View.super.className();
        }

        public scala.collection.Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterable<A> underlying() {
            return this.underlying;
        }

        public Function1<A, IterableOnce<B>> f() {
            return this.f;
        }

        @Override
        public Iterator<B> iterator() {
            return this.underlying().iterator().flatMap(this.f());
        }

        public <A, B> FlatMap<A, B> copy(Iterable<A> underlying, Function1<A, IterableOnce<B>> f) {
            return new FlatMap<A, B>(underlying, f);
        }

        public <A, B> Iterable<A> copy$default$1() {
            return this.underlying();
        }

        public <A, B> Function1<A, IterableOnce<B>> copy$default$2() {
            return this.f();
        }

        public Iterable<A> _1() {
            return this.underlying();
        }

        public Function1<A, IterableOnce<B>> _2() {
            return this.f();
        }

        public int hashCode() {
            int n = -505738625;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.underlying()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.f()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (object instanceof FlatMap) {
                FlatMap flatMap;
                FlatMap flatMap2 = flatMap = (FlatMap)object;
                Iterable<A> iterable = this.underlying();
                Iterable<A> iterable2 = flatMap2.underlying();
                if (iterable == null) {
                    if (iterable2 != null) {
                        return false;
                    }
                } else if (!iterable.equals(iterable2)) return false;
                Function1<A, IterableOnce<B>> function1 = this.f();
                Function1<A, IterableOnce<B>> function12 = flatMap2.f();
                if (function1 == null) {
                    if (function12 == null) return true;
                    return false;
                } else {
                    if (!function1.equals(function12)) return false;
                    return true;
                }
            }
            if (!(object instanceof Object)) throw new MatchError(object);
            Object object2 = object;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof FlatMap;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "FlatMap";
        }

        public Object productElement(int n) {
            Iterable<A> iterable;
            int n2 = n;
            if (0 == n2) {
                iterable = this._1();
            } else if (1 == n2) {
                iterable = this._2();
            } else {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            return iterable;
        }
    }

    public static class Iterate<A>
    implements View<A> {
        private final A start;
        private final int len;
        private final Function1<A, A> f;

        public <A> Iterate(A start, int len, Function1<A, A> f) {
            this.start = start;
            this.len = len;
            this.f = f;
        }

        @Override
        public View<A> view() {
            return View.super.view();
        }

        @Override
        public String toString() {
            return View.super.toString();
        }

        @Override
        public String className() {
            return View.super.className();
        }

        @Override
        public Iterator<A> iterator() {
            return Iterator$.MODULE$.iterate(this.start, this.f).take(this.len);
        }

        @Override
        public int knownSize() {
            return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(0), this.len);
        }
    }

    public static class Map<A, B>
    implements View<B>,
    Product {
        private final Iterable underlying;
        private final Function1 f;

        public static <A, B> Map<A, B> apply(Iterable<A> iterable, Function1<A, B> function1) {
            return View$Map$.MODULE$.apply(iterable, function1);
        }

        public static <A, B> Map<A, B> unapply(Map<A, B> map) {
            return View$Map$.MODULE$.unapply(map);
        }

        public <A, B> Map(Iterable<A> underlying, Function1<A, B> f) {
            this.underlying = underlying;
            this.f = f;
            Product.$init$((Product)this);
        }

        @Override
        public View<B> view() {
            return View.super.view();
        }

        @Override
        public String toString() {
            return View.super.toString();
        }

        @Override
        public String className() {
            return View.super.className();
        }

        public scala.collection.Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterable<A> underlying() {
            return this.underlying;
        }

        public Function1<A, B> f() {
            return this.f;
        }

        @Override
        public Iterator<B> iterator() {
            return this.underlying().iterator().map(this.f());
        }

        @Override
        public int knownSize() {
            return this.underlying().knownSize();
        }

        public <A, B> Map<A, B> copy(Iterable<A> underlying, Function1<A, B> f) {
            return new Map<A, B>(underlying, f);
        }

        public <A, B> Iterable<A> copy$default$1() {
            return this.underlying();
        }

        public <A, B> Function1<A, B> copy$default$2() {
            return this.f();
        }

        public Iterable<A> _1() {
            return this.underlying();
        }

        public Function1<A, B> _2() {
            return this.f();
        }

        public int hashCode() {
            int n = -1073418568;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.underlying()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.f()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (object instanceof Map) {
                Map map;
                Map map2 = map = (Map)object;
                Iterable<A> iterable = this.underlying();
                Iterable<A> iterable2 = map2.underlying();
                if (iterable == null) {
                    if (iterable2 != null) {
                        return false;
                    }
                } else if (!iterable.equals(iterable2)) return false;
                Function1<A, B> function1 = this.f();
                Function1<A, B> function12 = map2.f();
                if (function1 == null) {
                    if (function12 == null) return true;
                    return false;
                } else {
                    if (!function1.equals(function12)) return false;
                    return true;
                }
            }
            if (!(object instanceof Object)) throw new MatchError(object);
            Object object2 = object;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Map;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Map";
        }

        public Object productElement(int n) {
            Iterable<A> iterable;
            int n2 = n;
            if (0 == n2) {
                iterable = this._1();
            } else if (1 == n2) {
                iterable = this._2();
            } else {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            return iterable;
        }
    }

    public static class MapValues<K, V, W>
    implements View<Tuple2<K, W>>,
    Product {
        private final Iterable underlying;
        private final Function1 f;

        public static <K, V, W> MapValues<K, V, W> apply(Iterable<Tuple2<K, V>> iterable, Function1<V, W> function1) {
            return View$MapValues$.MODULE$.apply(iterable, function1);
        }

        public static <K, V, W> MapValues<K, V, W> unapply(MapValues<K, V, W> mapValues) {
            return View$MapValues$.MODULE$.unapply(mapValues);
        }

        public <K, V, W> MapValues(Iterable<Tuple2<K, V>> underlying, Function1<V, W> f) {
            this.underlying = underlying;
            this.f = f;
            Product.$init$((Product)this);
        }

        @Override
        public View<Tuple2<K, W>> view() {
            return View.super.view();
        }

        @Override
        public String toString() {
            return View.super.toString();
        }

        @Override
        public String className() {
            return View.super.className();
        }

        public scala.collection.Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterable<Tuple2<K, V>> underlying() {
            return this.underlying;
        }

        public Function1<V, W> f() {
            return this.f;
        }

        @Override
        public Iterator<Tuple2<K, W>> iterator() {
            return this.underlying().iterator().map(this::iterator$$anonfun$1);
        }

        @Override
        public int knownSize() {
            return this.underlying().knownSize();
        }

        public <K, V, W> MapValues<K, V, W> copy(Iterable<Tuple2<K, V>> underlying, Function1<V, W> f) {
            return new MapValues<K, V, W>(underlying, f);
        }

        public <K, V, W> Iterable<Tuple2<K, V>> copy$default$1() {
            return this.underlying();
        }

        public <K, V, W> Function1<V, W> copy$default$2() {
            return this.f();
        }

        public Iterable<Tuple2<K, V>> _1() {
            return this.underlying();
        }

        public Function1<V, W> _2() {
            return this.f();
        }

        public int hashCode() {
            int n = 1440714234;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.underlying()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.f()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (object instanceof MapValues) {
                MapValues mapValues;
                MapValues mapValues2 = mapValues = (MapValues)object;
                Iterable<Tuple2<K, V>> iterable = this.underlying();
                Iterable<Tuple2<K, V>> iterable2 = mapValues2.underlying();
                if (iterable == null) {
                    if (iterable2 != null) {
                        return false;
                    }
                } else if (!iterable.equals(iterable2)) return false;
                Function1<V, W> function1 = this.f();
                Function1<V, W> function12 = mapValues2.f();
                if (function1 == null) {
                    if (function12 == null) return true;
                    return false;
                } else {
                    if (!function1.equals(function12)) return false;
                    return true;
                }
            }
            if (!(object instanceof Object)) throw new MatchError(object);
            Object object2 = object;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof MapValues;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "MapValues";
        }

        public Object productElement(int n) {
            Iterable<Tuple2<K, V>> iterable;
            int n2 = n;
            if (0 == n2) {
                iterable = this._1();
            } else if (1 == n2) {
                iterable = this._2();
            } else {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            return iterable;
        }

        private Tuple2<K, W> iterator$$anonfun$1(Tuple2<K, V> kv) {
            return Tuple2$.MODULE$.apply(kv._1(), this.f().apply(kv._2()));
        }
    }

    public static class PadTo<A>
    implements View<A>,
    Product {
        private final Iterable underlying;
        private final int len;
        private final Object elem;

        public static <A> PadTo<A> apply(Iterable<A> iterable, int n, A a) {
            return View$PadTo$.MODULE$.apply(iterable, n, a);
        }

        public static <A> PadTo<A> unapply(PadTo<A> padTo) {
            return View$PadTo$.MODULE$.unapply(padTo);
        }

        public <A> PadTo(Iterable<A> underlying, int len, A elem) {
            this.underlying = underlying;
            this.len = len;
            this.elem = elem;
            Product.$init$((Product)this);
        }

        @Override
        public View<A> view() {
            return View.super.view();
        }

        @Override
        public String toString() {
            return View.super.toString();
        }

        @Override
        public String className() {
            return View.super.className();
        }

        public scala.collection.Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterable<A> underlying() {
            return this.underlying;
        }

        public int len() {
            return this.len;
        }

        public A elem() {
            return (A)this.elem;
        }

        @Override
        public Iterator<A> iterator() {
            return new Iterator<A>(this){
                private int i;
                private final Iterator it;
                private final PadTo $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.i = 0;
                    this.it = this.strawman$collection$View$PadTo$_$$anon$$$outer().underlying().iterator();
                }

                private int i() {
                    return this.i;
                }

                private void i_$eq(int x$1) {
                    this.i = x$1;
                }

                private Iterator<A> it() {
                    return this.it;
                }

                /*
                 * WARNING - void declaration
                 */
                public A next() {
                    void var1_1;
                    A a = this.it().hasNext() ? this.it().next() : (this.i() < this.strawman$collection$View$PadTo$_$$anon$$$outer().len() ? this.strawman$collection$View$PadTo$_$$anon$$$outer().elem() : Iterator$.MODULE$.empty().next());
                    this.i_$eq(this.i() + 1);
                    return var1_1;
                }

                public boolean hasNext() {
                    return this.it().hasNext() || this.i() < this.strawman$collection$View$PadTo$_$$anon$$$outer().len();
                }

                private PadTo<A> $outer() {
                    return this.$outer;
                }

                public final PadTo<A> strawman$collection$View$PadTo$_$$anon$$$outer() {
                    return this.$outer();
                }
            };
        }

        @Override
        public int knownSize() {
            return this.underlying().knownSize() >= 0 ? RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.underlying().knownSize()), this.len()) : -1;
        }

        public <A> PadTo<A> copy(Iterable<A> underlying, int len, A elem) {
            return new PadTo<A>(underlying, len, elem);
        }

        public <A> Iterable<A> copy$default$1() {
            return this.underlying();
        }

        public <A> int copy$default$2() {
            return this.len();
        }

        public <A> A copy$default$3() {
            return this.elem();
        }

        public Iterable<A> _1() {
            return this.underlying();
        }

        public int _2() {
            return this.len();
        }

        public A _3() {
            return this.elem();
        }

        public int hashCode() {
            int n = -760331062;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.underlying()));
            n = Statics.mix((int)n, (int)this.len());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.elem()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (object instanceof PadTo) {
                PadTo padTo;
                PadTo padTo2 = padTo = (PadTo)object;
                Iterable<A> iterable = this.underlying();
                Iterable<A> iterable2 = padTo2.underlying();
                if (iterable == null) {
                    if (iterable2 != null) {
                        return false;
                    }
                } else if (!iterable.equals(iterable2)) return false;
                Integer n = BoxesRunTime.boxToInteger((int)this.len());
                Integer n2 = BoxesRunTime.boxToInteger((int)padTo2.len());
                if (n == null) {
                    if (n2 != null) {
                        return false;
                    }
                } else if (!((Object)n).equals(n2)) return false;
                if (!BoxesRunTime.equals(this.elem(), padTo2.elem())) return false;
                return true;
            }
            if (!(object instanceof Object)) throw new MatchError(object);
            Object object2 = object;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof PadTo;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "PadTo";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this._2());
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                }
            }
            return object;
        }
    }

    public static class Partition<A>
    implements Product {
        private final Iterable underlying;
        private final Function1 p;
        private final Partitioned first;
        private final Partitioned second;

        public static <A> Partition<A> apply(Iterable<A> iterable, Function1<A, Object> function1) {
            return View$Partition$.MODULE$.apply(iterable, function1);
        }

        public static <A> Partition<A> unapply(Partition<A> partition) {
            return View$Partition$.MODULE$.unapply(partition);
        }

        public <A> Partition(Iterable<A> underlying, Function1<A, Object> p) {
            this.underlying = underlying;
            this.p = p;
            Product.$init$((Product)this);
            this.first = View$Partitioned$.MODULE$.apply(this, true);
            this.second = View$Partitioned$.MODULE$.apply(this, false);
        }

        public scala.collection.Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterable<A> underlying() {
            return this.underlying;
        }

        public Function1<A, Object> p() {
            return this.p;
        }

        public Partitioned<A> first() {
            return this.first;
        }

        public Partitioned<A> second() {
            return this.second;
        }

        public <A> Partition<A> copy(Iterable<A> underlying, Function1<A, Object> p) {
            return new Partition<A>(underlying, p);
        }

        public <A> Iterable<A> copy$default$1() {
            return this.underlying();
        }

        public <A> Function1<A, Object> copy$default$2() {
            return this.p();
        }

        public Iterable<A> _1() {
            return this.underlying();
        }

        public Function1<A, Object> _2() {
            return this.p();
        }

        public int hashCode() {
            int n = -1340151994;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.underlying()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.p()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (object instanceof Partition) {
                Partition partition;
                Partition partition2 = partition = (Partition)object;
                Iterable<A> iterable = this.underlying();
                Iterable<A> iterable2 = partition2.underlying();
                if (iterable == null) {
                    if (iterable2 != null) {
                        return false;
                    }
                } else if (!iterable.equals(iterable2)) return false;
                Function1<A, Object> function1 = this.p();
                Function1<A, Object> function12 = partition2.p();
                if (function1 == null) {
                    if (function12 == null) return true;
                    return false;
                } else {
                    if (!function1.equals(function12)) return false;
                    return true;
                }
            }
            if (!(object instanceof Object)) throw new MatchError(object);
            Object object2 = object;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Partition;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Partition";
        }

        public Object productElement(int n) {
            Iterable<A> iterable;
            int n2 = n;
            if (0 == n2) {
                iterable = this._1();
            } else if (1 == n2) {
                iterable = this._2();
            } else {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            return iterable;
        }
    }

    public static class Partitioned<A>
    implements View<A>,
    Product {
        private final Partition partition;
        private final boolean cond;

        public static <A> Partitioned<A> apply(Partition<A> partition, boolean bl) {
            return View$Partitioned$.MODULE$.apply(partition, bl);
        }

        public static <A> Partitioned<A> unapply(Partitioned<A> partitioned) {
            return View$Partitioned$.MODULE$.unapply(partitioned);
        }

        public <A> Partitioned(Partition<A> partition, boolean cond) {
            this.partition = partition;
            this.cond = cond;
            Product.$init$((Product)this);
        }

        @Override
        public View<A> view() {
            return View.super.view();
        }

        @Override
        public String toString() {
            return View.super.toString();
        }

        @Override
        public String className() {
            return View.super.className();
        }

        public scala.collection.Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Partition<A> partition() {
            return this.partition;
        }

        public boolean cond() {
            return this.cond;
        }

        @Override
        public Iterator<A> iterator() {
            return this.partition().underlying().iterator().filter(this::iterator$$anonfun$1);
        }

        public <A> Partitioned<A> copy(Partition<A> partition, boolean cond) {
            return new Partitioned<A>(partition, cond);
        }

        public <A> Partition<A> copy$default$1() {
            return this.partition();
        }

        public <A> boolean copy$default$2() {
            return this.cond();
        }

        public Partition<A> _1() {
            return this.partition();
        }

        public boolean _2() {
            return this.cond();
        }

        public int hashCode() {
            int n = 604125797;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.partition()));
            n = Statics.mix((int)n, (int)(this.cond() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (object instanceof Partitioned) {
                Partitioned partitioned;
                Partitioned partitioned2 = partitioned = (Partitioned)object;
                Partition<A> partition = this.partition();
                Partition<A> partition2 = partitioned2.partition();
                if (partition == null) {
                    if (partition2 != null) {
                        return false;
                    }
                } else if (!((Object)partition).equals(partition2)) return false;
                Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.cond());
                Boolean bl2 = BoxesRunTime.boxToBoolean((boolean)partitioned2.cond());
                if (bl == null) {
                    if (bl2 == null) return true;
                    return false;
                } else {
                    if (!((Object)bl).equals(bl2)) return false;
                    return true;
                }
            }
            if (!(object instanceof Object)) throw new MatchError(object);
            Object object2 = object;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Partitioned;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Partitioned";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = BoxesRunTime.boxToBoolean((boolean)this._2());
            } else {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            return object;
        }

        private boolean iterator$$anonfun$1(A x) {
            return BoxesRunTime.unboxToBoolean((Object)this.partition().p().apply(x)) == this.cond();
        }
    }

    public static class Patched<A>
    implements View<A> {
        private final Iterable<A> underlying;
        private final int from;
        private final IterableOnce<A> other;
        private final int replaced;

        public <A> Patched(Iterable<A> underlying, int from, IterableOnce<A> other, int replaced) {
            this.underlying = underlying;
            this.from = from;
            this.other = other;
            this.replaced = replaced;
            if (from < 0 || this.knownSize() > -1 && from > this.knownSize()) {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)from)).toString());
            }
        }

        @Override
        public View<A> view() {
            return View.super.view();
        }

        @Override
        public String toString() {
            return View.super.toString();
        }

        @Override
        public String className() {
            return View.super.className();
        }

        @Override
        public Iterator<A> iterator() {
            return this.underlying.iterator().patch(this.from, this.other.iterator(), this.replaced);
        }
    }

    public static class Prepend<A>
    implements View<A>,
    Product {
        private final Object elem;
        private final Iterable underlying;

        public static <A> Prepend<A> apply(A a, Iterable<A> iterable) {
            return View$Prepend$.MODULE$.apply(a, iterable);
        }

        public static <A> Prepend<A> unapply(Prepend<A> prepend) {
            return View$Prepend$.MODULE$.unapply(prepend);
        }

        public <A> Prepend(A elem, Iterable<A> underlying) {
            this.elem = elem;
            this.underlying = underlying;
            Product.$init$((Product)this);
        }

        @Override
        public View<A> view() {
            return View.super.view();
        }

        @Override
        public String toString() {
            return View.super.toString();
        }

        @Override
        public String className() {
            return View.super.className();
        }

        public scala.collection.Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public A elem() {
            return (A)this.elem;
        }

        public Iterable<A> underlying() {
            return this.underlying;
        }

        @Override
        public Iterator<A> iterator() {
            return View$Concat$.MODULE$.apply(View$Single$.MODULE$.apply(this.elem()), this.underlying()).iterator();
        }

        @Override
        public int knownSize() {
            return this.underlying().knownSize() >= 0 ? this.underlying().knownSize() + 1 : -1;
        }

        public <A> Prepend<A> copy(A elem, Iterable<A> underlying) {
            return new Prepend<A>(elem, underlying);
        }

        public <A> A copy$default$1() {
            return this.elem();
        }

        public <A> Iterable<A> copy$default$2() {
            return this.underlying();
        }

        public A _1() {
            return this.elem();
        }

        public Iterable<A> _2() {
            return this.underlying();
        }

        public int hashCode() {
            int n = -45263126;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.elem()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.underlying()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (object instanceof Prepend) {
                Prepend prepend;
                Prepend prepend2 = prepend = (Prepend)object;
                if (!BoxesRunTime.equals(this.elem(), prepend2.elem())) return false;
                Iterable<A> iterable = this.underlying();
                Iterable<A> iterable2 = prepend2.underlying();
                if (iterable != null) {
                    if (!iterable.equals(iterable2)) return false;
                    return true;
                }
                if (iterable2 == null) return true;
                return false;
            }
            if (!(object instanceof Object)) throw new MatchError(object);
            Object object2 = object;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Prepend;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Prepend";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = this._2();
            } else {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            return object;
        }
    }

    public static class ScanLeft<A, B>
    implements View<B>,
    Product {
        private final Iterable underlying;
        private final Object z;
        private final Function2 op;

        public static <A, B> ScanLeft<A, B> apply(Iterable<A> iterable, B b, Function2<B, A, B> function2) {
            return View$ScanLeft$.MODULE$.apply(iterable, b, function2);
        }

        public static <A, B> ScanLeft<A, B> unapply(ScanLeft<A, B> scanLeft) {
            return View$ScanLeft$.MODULE$.unapply(scanLeft);
        }

        public <A, B> ScanLeft(Iterable<A> underlying, B z, Function2<B, A, B> op) {
            this.underlying = underlying;
            this.z = z;
            this.op = op;
            Product.$init$((Product)this);
        }

        @Override
        public View<B> view() {
            return View.super.view();
        }

        @Override
        public String toString() {
            return View.super.toString();
        }

        @Override
        public String className() {
            return View.super.className();
        }

        public scala.collection.Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterable<A> underlying() {
            return this.underlying;
        }

        public B z() {
            return (B)this.z;
        }

        public Function2<B, A, B> op() {
            return this.op;
        }

        @Override
        public Iterator<B> iterator() {
            return this.underlying().iterator().scanLeft(this.z(), this.op());
        }

        @Override
        public int knownSize() {
            return this.underlying().knownSize() >= 0 ? this.underlying().knownSize() + 1 : -1;
        }

        public <A, B> ScanLeft<A, B> copy(Iterable<A> underlying, B z, Function2<B, A, B> op) {
            return new ScanLeft<A, B>(underlying, z, op);
        }

        public <A, B> Iterable<A> copy$default$1() {
            return this.underlying();
        }

        public <A, B> B copy$default$2() {
            return this.z();
        }

        public <A, B> Function2<B, A, B> copy$default$3() {
            return this.op();
        }

        public Iterable<A> _1() {
            return this.underlying();
        }

        public B _2() {
            return this.z();
        }

        public Function2<B, A, B> _3() {
            return this.op();
        }

        public int hashCode() {
            int n = -1014463416;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.underlying()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.z()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.op()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (object instanceof ScanLeft) {
                ScanLeft scanLeft;
                ScanLeft scanLeft2 = scanLeft = (ScanLeft)object;
                Iterable<A> iterable = this.underlying();
                Iterable<A> iterable2 = scanLeft2.underlying();
                if (iterable == null) {
                    if (iterable2 != null) {
                        return false;
                    }
                } else if (!iterable.equals(iterable2)) return false;
                if (!BoxesRunTime.equals(this.z(), scanLeft2.z())) return false;
                Function2<B, A, B> function2 = this.op();
                Function2<B, A, B> function22 = scanLeft2.op();
                if (function2 == null) {
                    if (function22 == null) return true;
                    return false;
                } else {
                    if (!function2.equals(function22)) return false;
                    return true;
                }
            }
            if (!(object instanceof Object)) throw new MatchError(object);
            Object object2 = object;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof ScanLeft;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "ScanLeft";
        }

        public Object productElement(int n) {
            Iterable<Object> iterable;
            int n2 = n;
            switch (n2) {
                case 0: {
                    iterable = this._1();
                    break;
                }
                case 1: {
                    iterable = this._2();
                    break;
                }
                case 2: {
                    iterable = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                }
            }
            return iterable;
        }
    }

    public static class Single<A>
    implements View<A>,
    Product {
        private final Object a;

        public static <A> Single<A> apply(A a) {
            return View$Single$.MODULE$.apply(a);
        }

        public static <A> Single<A> unapply(Single<A> single) {
            return View$Single$.MODULE$.unapply(single);
        }

        public <A> Single(A a) {
            this.a = a;
            Product.$init$((Product)this);
        }

        @Override
        public View<A> view() {
            return View.super.view();
        }

        @Override
        public String toString() {
            return View.super.toString();
        }

        @Override
        public String className() {
            return View.super.className();
        }

        public scala.collection.Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public A a() {
            return (A)this.a;
        }

        @Override
        public Iterator<A> iterator() {
            return new Iterator<A>(this){
                private boolean notConsumed;
                private final Single $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.notConsumed = true;
                }

                private boolean notConsumed() {
                    return this.notConsumed;
                }

                private void notConsumed_$eq(boolean x$1) {
                    this.notConsumed = x$1;
                }

                public A next() {
                    Object object;
                    if (this.notConsumed()) {
                        this.notConsumed_$eq(false);
                        object = this.strawman$collection$View$Single$_$$anon$$$outer().a();
                    } else {
                        object = Iterator$.MODULE$.empty().next();
                    }
                    return (A)object;
                }

                public boolean hasNext() {
                    return this.notConsumed();
                }

                private Single<A> $outer() {
                    return this.$outer;
                }

                public final Single<A> strawman$collection$View$Single$_$$anon$$$outer() {
                    return this.$outer();
                }
            };
        }

        @Override
        public int knownSize() {
            return 1;
        }

        public <A> Single<A> copy(A a) {
            return new Single<A>(a);
        }

        public <A> A copy$default$1() {
            return this.a();
        }

        public A _1() {
            return this.a();
        }

        public int hashCode() {
            int n = -2001834644;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.a()));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (object instanceof Single) {
                Single single;
                Single single2 = single = (Single)object;
                if (!BoxesRunTime.equals(this.a(), single2.a())) return false;
                return true;
            }
            if (!(object instanceof Object)) throw new MatchError(object);
            Object object2 = object;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Single;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Single";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            return this._1();
        }
    }

    public static class Tabulate<A>
    implements View<A>,
    Product {
        private final int n;
        private final Function1<Object, A> f;

        public static <A> Tabulate<A> apply(int n, Function1<Object, A> function1) {
            return View$Tabulate$.MODULE$.apply(n, function1);
        }

        public static <A> Tabulate<A> unapply(Tabulate<A> tabulate) {
            return View$Tabulate$.MODULE$.unapply(tabulate);
        }

        public <A> Tabulate(int n, Function1<Object, A> f) {
            this.n = n;
            this.f = f;
            Product.$init$((Product)this);
        }

        @Override
        public View<A> view() {
            return View.super.view();
        }

        @Override
        public String toString() {
            return View.super.toString();
        }

        @Override
        public String className() {
            return View.super.className();
        }

        public scala.collection.Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public int n() {
            return this.n;
        }

        @Override
        public Iterator<A> iterator() {
            return Iterator$.MODULE$.tabulate(this.n(), this.f);
        }

        @Override
        public int knownSize() {
            return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(0), this.n());
        }

        public <A> Tabulate<A> copy(int n, Function1<Object, A> f) {
            return new Tabulate<A>(n, f);
        }

        public <A> int copy$default$1() {
            return this.n();
        }

        public int _1() {
            return this.n();
        }

        public int hashCode() {
            int n = -1010616758;
            n = Statics.mix((int)n, (int)this.n());
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (object instanceof Tabulate) {
                Tabulate tabulate;
                Tabulate tabulate2 = tabulate = (Tabulate)object;
                Integer n = BoxesRunTime.boxToInteger((int)this.n());
                Integer n2 = BoxesRunTime.boxToInteger((int)tabulate2.n());
                if (n != null) {
                    if (!((Object)n).equals(n2)) return false;
                    return true;
                }
                if (n2 == null) return true;
                return false;
            }
            if (!(object instanceof Object)) throw new MatchError(object);
            Object object2 = object;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Tabulate;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Tabulate";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            return BoxesRunTime.boxToInteger((int)this._1());
        }
    }

    public static class Take<A>
    implements View<A>,
    Product {
        private final Iterable underlying;
        private final int n;
        private final int normN;

        public static <A> Take<A> apply(Iterable<A> iterable, int n) {
            return View$Take$.MODULE$.apply(iterable, n);
        }

        public static <A> Take<A> unapply(Take<A> take) {
            return View$Take$.MODULE$.unapply(take);
        }

        public <A> Take(Iterable<A> underlying, int n) {
            this.underlying = underlying;
            this.n = n;
            Product.$init$((Product)this);
            this.normN = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(n), 0);
        }

        @Override
        public View<A> view() {
            return View.super.view();
        }

        @Override
        public String toString() {
            return View.super.toString();
        }

        @Override
        public String className() {
            return View.super.className();
        }

        public scala.collection.Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterable<A> underlying() {
            return this.underlying;
        }

        public int n() {
            return this.n;
        }

        @Override
        public Iterator<A> iterator() {
            return this.underlying().iterator().take(this.n());
        }

        public int normN() {
            return this.normN;
        }

        @Override
        public int knownSize() {
            return this.underlying().knownSize() >= 0 ? RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.underlying().knownSize()), this.normN()) : -1;
        }

        public <A> Take<A> copy(Iterable<A> underlying, int n) {
            return new Take<A>(underlying, n);
        }

        public <A> Iterable<A> copy$default$1() {
            return this.underlying();
        }

        public <A> int copy$default$2() {
            return this.n();
        }

        public Iterable<A> _1() {
            return this.underlying();
        }

        public int _2() {
            return this.n();
        }

        public int hashCode() {
            int n = 1083971243;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.underlying()));
            n = Statics.mix((int)n, (int)this.n());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (object instanceof Take) {
                Take take;
                Take take2 = take = (Take)object;
                Iterable<A> iterable = this.underlying();
                Iterable<A> iterable2 = take2.underlying();
                if (iterable == null) {
                    if (iterable2 != null) {
                        return false;
                    }
                } else if (!iterable.equals(iterable2)) return false;
                Integer n = BoxesRunTime.boxToInteger((int)this.n());
                Integer n2 = BoxesRunTime.boxToInteger((int)take2.n());
                if (n == null) {
                    if (n2 == null) return true;
                    return false;
                } else {
                    if (!((Object)n).equals(n2)) return false;
                    return true;
                }
            }
            if (!(object instanceof Object)) throw new MatchError(object);
            Object object2 = object;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Take;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Take";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = BoxesRunTime.boxToInteger((int)this._2());
            } else {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            return object;
        }
    }

    public static class TakeWhile<A>
    implements View<A>,
    Product {
        private final Iterable underlying;
        private final Function1 p;

        public static <A> TakeWhile<A> apply(Iterable<A> iterable, Function1<A, Object> function1) {
            return View$TakeWhile$.MODULE$.apply(iterable, function1);
        }

        public static <A> TakeWhile<A> unapply(TakeWhile<A> takeWhile) {
            return View$TakeWhile$.MODULE$.unapply(takeWhile);
        }

        public <A> TakeWhile(Iterable<A> underlying, Function1<A, Object> p) {
            this.underlying = underlying;
            this.p = p;
            Product.$init$((Product)this);
        }

        @Override
        public View<A> view() {
            return View.super.view();
        }

        @Override
        public String toString() {
            return View.super.toString();
        }

        @Override
        public String className() {
            return View.super.className();
        }

        public scala.collection.Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterable<A> underlying() {
            return this.underlying;
        }

        public Function1<A, Object> p() {
            return this.p;
        }

        @Override
        public Iterator<A> iterator() {
            return this.underlying().iterator().takeWhile(this.p());
        }

        public <A> TakeWhile<A> copy(Iterable<A> underlying, Function1<A, Object> p) {
            return new TakeWhile<A>(underlying, p);
        }

        public <A> Iterable<A> copy$default$1() {
            return this.underlying();
        }

        public <A> Function1<A, Object> copy$default$2() {
            return this.p();
        }

        public Iterable<A> _1() {
            return this.underlying();
        }

        public Function1<A, Object> _2() {
            return this.p();
        }

        public int hashCode() {
            int n = 1950955334;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.underlying()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.p()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (object instanceof TakeWhile) {
                TakeWhile takeWhile;
                TakeWhile takeWhile2 = takeWhile = (TakeWhile)object;
                Iterable<A> iterable = this.underlying();
                Iterable<A> iterable2 = takeWhile2.underlying();
                if (iterable == null) {
                    if (iterable2 != null) {
                        return false;
                    }
                } else if (!iterable.equals(iterable2)) return false;
                Function1<A, Object> function1 = this.p();
                Function1<A, Object> function12 = takeWhile2.p();
                if (function1 == null) {
                    if (function12 == null) return true;
                    return false;
                } else {
                    if (!function1.equals(function12)) return false;
                    return true;
                }
            }
            if (!(object instanceof Object)) throw new MatchError(object);
            Object object2 = object;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof TakeWhile;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "TakeWhile";
        }

        public Object productElement(int n) {
            Iterable<A> iterable;
            int n2 = n;
            if (0 == n2) {
                iterable = this._1();
            } else if (1 == n2) {
                iterable = this._2();
            } else {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            return iterable;
        }
    }

    public static class Unzip<A, A1, A2>
    implements Product {
        private final Iterable underlying;
        public final Predef$.less.colon.less<A, Tuple2<A1, A2>> strawman$collection$View$Unzip$$asPair;
        private final View first;
        private final View second;

        public static <A, A1, A2> Unzip<A, A1, A2> apply(Iterable<A> iterable, Predef$.less.colon.less<A, Tuple2<A1, A2>> less2) {
            return View$Unzip$.MODULE$.apply(iterable, less2);
        }

        public static <A, A1, A2> Unzip<A, A1, A2> unapply(Unzip<A, A1, A2> unzip) {
            return View$Unzip$.MODULE$.unapply(unzip);
        }

        public <A, A1, A2> Unzip(Iterable<A> underlying, Predef$.less.colon.less<A, Tuple2<A1, A2>> asPair) {
            this.underlying = underlying;
            this.strawman$collection$View$Unzip$$asPair = asPair;
            Product.$init$((Product)this);
            this.first = new View<A1>(this){
                private final Unzip $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public View<A1> view() {
                    return View.super.view();
                }

                public String toString() {
                    return View.super.toString();
                }

                public String className() {
                    return View.super.className();
                }

                public Iterator<A1> iterator() {
                    return this.strawman$collection$View$Unzip$_$$anon$$$outer().underlying().iterator().map(this::iterator$$anonfun$1);
                }

                public int knownSize() {
                    return this.strawman$collection$View$Unzip$_$$anon$$$outer().underlying().knownSize();
                }

                private Unzip<A, A1, A2> $outer() {
                    return this.$outer;
                }

                public final Unzip<A, A1, A2> strawman$collection$View$Unzip$_$$anon$$$outer() {
                    return this.$outer();
                }

                private A1 iterator$$anonfun$1(A _$60) {
                    return (A1)((Tuple2)this.strawman$collection$View$Unzip$_$$anon$$$outer().strawman$collection$View$Unzip$$asPair.apply(_$60))._1();
                }
            };
            this.second = new View<A2>(this){
                private final Unzip $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public View<A2> view() {
                    return View.super.view();
                }

                public String toString() {
                    return View.super.toString();
                }

                public String className() {
                    return View.super.className();
                }

                public Iterator<A2> iterator() {
                    return this.strawman$collection$View$Unzip$_$$anon$$$outer().underlying().iterator().map(this::iterator$$anonfun$1);
                }

                public int knownSize() {
                    return this.strawman$collection$View$Unzip$_$$anon$$$outer().underlying().knownSize();
                }

                private Unzip<A, A1, A2> $outer() {
                    return this.$outer;
                }

                public final Unzip<A, A1, A2> strawman$collection$View$Unzip$_$$anon$$$outer() {
                    return this.$outer();
                }

                private A2 iterator$$anonfun$1(A _$61) {
                    return (A2)((Tuple2)this.strawman$collection$View$Unzip$_$$anon$$$outer().strawman$collection$View$Unzip$$asPair.apply(_$61))._2();
                }
            };
        }

        public scala.collection.Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterable<A> underlying() {
            return this.underlying;
        }

        public View<A1> first() {
            return this.first;
        }

        public View<A2> second() {
            return this.second;
        }

        public <A, A1, A2> Unzip<A, A1, A2> copy(Iterable<A> underlying, Predef$.less.colon.less<A, Tuple2<A1, A2>> asPair) {
            return new Unzip<A, A1, A2>(underlying, asPair);
        }

        public <A, A1, A2> Iterable<A> copy$default$1() {
            return this.underlying();
        }

        public Iterable<A> _1() {
            return this.underlying();
        }

        public int hashCode() {
            int n = -755304380;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.underlying()));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (object instanceof Unzip) {
                Unzip unzip;
                Unzip unzip2 = unzip = (Unzip)object;
                Iterable<A> iterable = this.underlying();
                Iterable<A> iterable2 = unzip2.underlying();
                if (iterable != null) {
                    if (!iterable.equals(iterable2)) return false;
                    return true;
                }
                if (iterable2 == null) return true;
                return false;
            }
            if (!(object instanceof Object)) throw new MatchError(object);
            Object object2 = object;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Unzip;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Unzip";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            return this._1();
        }
    }

    public static class Updated<A>
    implements View<A>,
    Product {
        private final Iterable underlying;
        private final int index;
        private final Object elem;

        public static <A> Updated<A> apply(Iterable<A> iterable, int n, A a) {
            return View$Updated$.MODULE$.apply(iterable, n, a);
        }

        public static <A> Updated<A> unapply(Updated<A> updated) {
            return View$Updated$.MODULE$.unapply(updated);
        }

        public <A> Updated(Iterable<A> underlying, int index, A elem) {
            this.underlying = underlying;
            this.index = index;
            this.elem = elem;
            Product.$init$((Product)this);
        }

        @Override
        public View<A> view() {
            return View.super.view();
        }

        @Override
        public String toString() {
            return View.super.toString();
        }

        @Override
        public String className() {
            return View.super.className();
        }

        public scala.collection.Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterable<A> underlying() {
            return this.underlying;
        }

        public int index() {
            return this.index;
        }

        public A elem() {
            return (A)this.elem;
        }

        @Override
        public Iterator<A> iterator() {
            return new Iterator<A>(this){
                private final Iterator it;
                private int i;
                private final Updated $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.it = this.strawman$collection$View$Updated$_$$anon$$$outer().underlying().iterator();
                    this.i = 0;
                }

                private Iterator<A> it() {
                    return this.it;
                }

                private int i() {
                    return this.i;
                }

                private void i_$eq(int x$1) {
                    this.i = x$1;
                }

                /*
                 * WARNING - void declaration
                 */
                public A next() {
                    void var1_1;
                    A a;
                    if (this.i() == this.strawman$collection$View$Updated$_$$anon$$$outer().index()) {
                        this.it().next();
                        a = this.strawman$collection$View$Updated$_$$anon$$$outer().elem();
                    } else {
                        a = this.it().next();
                    }
                    A value = a;
                    this.i_$eq(this.i() + 1);
                    return var1_1;
                }

                public boolean hasNext() {
                    return this.it().hasNext();
                }

                private Updated<A> $outer() {
                    return this.$outer;
                }

                public final Updated<A> strawman$collection$View$Updated$_$$anon$$$outer() {
                    return this.$outer();
                }
            };
        }

        @Override
        public int knownSize() {
            return this.underlying().knownSize();
        }

        public <A> Updated<A> copy(Iterable<A> underlying, int index, A elem) {
            return new Updated<A>(underlying, index, elem);
        }

        public <A> Iterable<A> copy$default$1() {
            return this.underlying();
        }

        public <A> int copy$default$2() {
            return this.index();
        }

        public <A> A copy$default$3() {
            return this.elem();
        }

        public Iterable<A> _1() {
            return this.underlying();
        }

        public int _2() {
            return this.index();
        }

        public A _3() {
            return this.elem();
        }

        public int hashCode() {
            int n = 38673431;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.underlying()));
            n = Statics.mix((int)n, (int)this.index());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.elem()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (object instanceof Updated) {
                Updated updated;
                Updated updated2 = updated = (Updated)object;
                Iterable<A> iterable = this.underlying();
                Iterable<A> iterable2 = updated2.underlying();
                if (iterable == null) {
                    if (iterable2 != null) {
                        return false;
                    }
                } else if (!iterable.equals(iterable2)) return false;
                Integer n = BoxesRunTime.boxToInteger((int)this.index());
                Integer n2 = BoxesRunTime.boxToInteger((int)updated2.index());
                if (n == null) {
                    if (n2 != null) {
                        return false;
                    }
                } else if (!((Object)n).equals(n2)) return false;
                if (!BoxesRunTime.equals(this.elem(), updated2.elem())) return false;
                return true;
            }
            if (!(object instanceof Object)) throw new MatchError(object);
            Object object2 = object;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Updated;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Updated";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this._2());
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                }
            }
            return object;
        }
    }

    public static class Zip<A, B>
    implements View<Tuple2<A, B>>,
    Product {
        private final Iterable underlying;
        private final Iterable other;

        public static <A, B> Zip<A, B> apply(Iterable<A> iterable, Iterable<B> iterable2) {
            return View$Zip$.MODULE$.apply(iterable, iterable2);
        }

        public static <A, B> Zip<A, B> unapply(Zip<A, B> zip) {
            return View$Zip$.MODULE$.unapply(zip);
        }

        public <A, B> Zip(Iterable<A> underlying, Iterable<B> other) {
            this.underlying = underlying;
            this.other = other;
            Product.$init$((Product)this);
        }

        @Override
        public View<Tuple2<A, B>> view() {
            return View.super.view();
        }

        @Override
        public String toString() {
            return View.super.toString();
        }

        @Override
        public String className() {
            return View.super.className();
        }

        public scala.collection.Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterable<A> underlying() {
            return this.underlying;
        }

        public Iterable<B> other() {
            return this.other;
        }

        @Override
        public Iterator<Tuple2<A, B>> iterator() {
            return this.underlying().iterator().zip(this.other());
        }

        @Override
        public int knownSize() {
            return RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.underlying().knownSize()), this.other().knownSize());
        }

        public <A, B> Zip<A, B> copy(Iterable<A> underlying, Iterable<B> other) {
            return new Zip<A, B>(underlying, other);
        }

        public <A, B> Iterable<A> copy$default$1() {
            return this.underlying();
        }

        public <A, B> Iterable<B> copy$default$2() {
            return this.other();
        }

        public Iterable<A> _1() {
            return this.underlying();
        }

        public Iterable<B> _2() {
            return this.other();
        }

        public int hashCode() {
            int n = -1073405827;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.underlying()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.other()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (object instanceof Zip) {
                Zip zip;
                Zip zip2 = zip = (Zip)object;
                Iterable<A> iterable = this.underlying();
                Iterable<A> iterable2 = zip2.underlying();
                if (iterable == null) {
                    if (iterable2 != null) {
                        return false;
                    }
                } else if (!iterable.equals(iterable2)) return false;
                Iterable<B> iterable3 = this.other();
                Iterable<B> iterable4 = zip2.other();
                if (iterable3 == null) {
                    if (iterable4 == null) return true;
                    return false;
                } else {
                    if (!iterable3.equals(iterable4)) return false;
                    return true;
                }
            }
            if (!(object instanceof Object)) throw new MatchError(object);
            Object object2 = object;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Zip;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Zip";
        }

        public Object productElement(int n) {
            Iterable<Object> iterable;
            int n2 = n;
            if (0 == n2) {
                iterable = this._1();
            } else if (1 == n2) {
                iterable = this._2();
            } else {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            return iterable;
        }
    }

    public static class ZipWithIndex<A>
    implements View<Tuple2<A, Object>>,
    Product {
        private final Iterable underlying;

        public static <A> ZipWithIndex<A> apply(Iterable<A> iterable) {
            return View$ZipWithIndex$.MODULE$.apply(iterable);
        }

        public static <A> ZipWithIndex<A> unapply(ZipWithIndex<A> zipWithIndex) {
            return View$ZipWithIndex$.MODULE$.unapply(zipWithIndex);
        }

        public <A> ZipWithIndex(Iterable<A> underlying) {
            this.underlying = underlying;
            Product.$init$((Product)this);
        }

        @Override
        public View<Tuple2<A, Object>> view() {
            return View.super.view();
        }

        @Override
        public String toString() {
            return View.super.toString();
        }

        @Override
        public String className() {
            return View.super.className();
        }

        public scala.collection.Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterable<A> underlying() {
            return this.underlying;
        }

        @Override
        public Iterator<Tuple2<A, Object>> iterator() {
            return this.underlying().iterator().zipWithIndex();
        }

        @Override
        public int knownSize() {
            return this.underlying().knownSize();
        }

        public <A> ZipWithIndex<A> copy(Iterable<A> underlying) {
            return new ZipWithIndex<A>(underlying);
        }

        public <A> Iterable<A> copy$default$1() {
            return this.underlying();
        }

        public Iterable<A> _1() {
            return this.underlying();
        }

        public int hashCode() {
            int n = -1740943441;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.underlying()));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (object instanceof ZipWithIndex) {
                ZipWithIndex zipWithIndex;
                ZipWithIndex zipWithIndex2 = zipWithIndex = (ZipWithIndex)object;
                Iterable<A> iterable = this.underlying();
                Iterable<A> iterable2 = zipWithIndex2.underlying();
                if (iterable != null) {
                    if (!iterable.equals(iterable2)) return false;
                    return true;
                }
                if (iterable2 == null) return true;
                return false;
            }
            if (!(object instanceof Object)) throw new MatchError(object);
            Object object2 = object;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof ZipWithIndex;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ZipWithIndex";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            return this._1();
        }
    }
}

