/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.convert;

import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import scala.Function0;
import strawman.collection.Iterable;
import strawman.collection.Iterator;
import strawman.collection.JavaConverters$;
import strawman.collection.mutable.Map;

public final class Decorators {

    public static class AsJava<A> {
        private final Function0<A> op;

        public <A> AsJava(Function0<A> op) {
            this.op = op;
        }

        public A asJava() {
            return (A)this.op.apply();
        }
    }

    public static class AsJavaCollection<A> {
        private final Iterable<A> i;

        public <A> AsJavaCollection(Iterable<A> i) {
            this.i = i;
        }

        public Collection<A> asJavaCollection() {
            return JavaConverters$.MODULE$.asJavaCollection(this.i);
        }
    }

    public static class AsJavaDictionary<A, B> {
        private final Map<A, B> m;

        public <A, B> AsJavaDictionary(Map<A, B> m) {
            this.m = m;
        }

        public Dictionary<A, B> asJavaDictionary() {
            return JavaConverters$.MODULE$.asJavaDictionary(this.m);
        }
    }

    public static class AsJavaEnumeration<A> {
        private final Iterator<A> i;

        public <A> AsJavaEnumeration(Iterator<A> i) {
            this.i = i;
        }

        public Enumeration<A> asJavaEnumeration() {
            return JavaConverters$.MODULE$.asJavaEnumeration(this.i);
        }
    }

    public static class AsScala<A> {
        private final Function0<A> op;

        public <A> AsScala(Function0<A> op) {
            this.op = op;
        }

        public A asScala() {
            return (A)this.op.apply();
        }
    }
}

