/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.immutable;

import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import strawman.collection.IndexedSeqOps;
import strawman.collection.IndexedView;
import strawman.collection.Iterable;
import strawman.collection.IterableOnce;
import strawman.collection.IterableOps;
import strawman.collection.Iterator;
import strawman.collection.Seq;
import strawman.collection.SeqFactory;
import strawman.collection.SeqOps;
import strawman.collection.StrictOptimizedIterableOps;
import strawman.collection.StrictOptimizedSeqOps;
import strawman.collection.immutable.IndexedSeq;
import strawman.collection.immutable.IndexedSeq$;
import strawman.collection.immutable.Nil$;
import strawman.collection.immutable.Range$;
import strawman.collection.immutable.Range$Partial$;
import strawman.collection.immutable.RangeIterator;
import strawman.collection.mutable.Builder;

public abstract class Range
implements IndexedSeq<Object>,
strawman.collection.immutable.StrictOptimizedSeqOps<Object, IndexedSeq, IndexedSeq<Object>>,
Serializable {
    private final int start;
    private final int end;
    private final int step;
    private final boolean isEmpty;
    private final int numRangeElements;
    private final int lastElement;

    public Range(int start, int end, int step) {
        int remainder;
        long len;
        this.start = start;
        this.end = end;
        this.step = step;
        Function1.$init$((Function1)this);
        PartialFunction.$init$((PartialFunction)this);
        boolean bl = this.isEmpty = start > end && step > 0 || start < end && step < 0 || start == end && !this.isInclusive();
        if (step == 0) {
            throw new IllegalArgumentException("step cannot be 0.");
        }
        this.numRangeElements = this.isEmpty() ? 0 : ((len = this.longLength()) > Integer.MAX_VALUE ? -1 : (int)len);
        int n = step;
        int n2 = 1 == n ? (this.isInclusive() ? end : end - 1) : (-1 == n ? (this.isInclusive() ? end : end + 1) : ((remainder = (int)(this.gap() % (long)step)) != 0 ? end - remainder : (this.isInclusive() ? end : end - step)));
        this.lastElement = n2;
    }

    public <A> Function1<A, Object> compose(Function1<A, Object> g) {
        return Function1.compose$((Function1)this, g);
    }

    public <A1, B1> PartialFunction<A1, B1> orElse(PartialFunction<A1, B1> that) {
        return PartialFunction.orElse$((PartialFunction)this, that);
    }

    public <C> PartialFunction<Object, C> andThen(Function1<Object, C> k) {
        return PartialFunction.andThen$((PartialFunction)this, k);
    }

    public Function1<Object, Option<Object>> lift() {
        return PartialFunction.lift$((PartialFunction)this);
    }

    public <A1, B1> B1 applyOrElse(A1 x, Function1<A1, B1> function1) {
        return (B1)PartialFunction.applyOrElse$((PartialFunction)this, (Object)BoxesRunTime.boxToInteger(x), function1);
    }

    public <U> Function1<Object, Object> runWith(Function1<Object, U> action) {
        return PartialFunction.runWith$((PartialFunction)this, action);
    }

    @Override
    public /* synthetic */ IndexedSeq strawman$collection$SeqOps$$super$concat(Iterable suffix) {
        return (IndexedSeq)IterableOps.super.concat(suffix);
    }

    @Override
    public final <B> IndexedSeq<B> concat(Iterable<B> suffix) {
        return (IndexedSeq)SeqOps.super.concat(suffix);
    }

    @Override
    public final int size() {
        return SeqOps.super.size();
    }

    @Override
    public boolean nonEmpty() {
        return SeqOps.super.nonEmpty();
    }

    @Override
    public int hashCode() {
        return Seq.super.hashCode();
    }

    @Override
    public final Range toSeq() {
        return (Range)strawman.collection.immutable.Seq.super.toSeq();
    }

    @Override
    public IndexedView<Object> view() {
        return IndexedSeqOps.super.view();
    }

    @Override
    public Iterable<Object> reversed() {
        return IndexedSeqOps.super.reversed();
    }

    @Override
    public int lengthCompare(int len) {
        return IndexedSeqOps.super.lengthCompare(len);
    }

    @Override
    public final int knownSize() {
        return IndexedSeqOps.super.knownSize();
    }

    @Override
    public Tuple2<IndexedSeq<Object>, IndexedSeq<Object>> partition(Function1<Object, Object> p) {
        return StrictOptimizedIterableOps.super.partition(p);
    }

    @Override
    public <A1, A2> Tuple2<IndexedSeq<A1>, IndexedSeq<A2>> unzip(Predef$.less.colon.less<Object, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.super.unzip(asPair);
    }

    @Override
    public <B> IndexedSeq<B> map(Function1<Object, B> f) {
        return (IndexedSeq)StrictOptimizedIterableOps.super.map(f);
    }

    @Override
    public <B> IndexedSeq<B> flatMap(Function1<Object, IterableOnce<B>> f) {
        return (IndexedSeq)StrictOptimizedIterableOps.super.flatMap(f);
    }

    @Override
    public <B> IndexedSeq<B> collect(PartialFunction<Object, B> pf) {
        return (IndexedSeq)StrictOptimizedIterableOps.super.collect(pf);
    }

    @Override
    public <B> IndexedSeq<B> flatten(Function1<Object, IterableOnce<B>> toIterableOnce) {
        return (IndexedSeq)StrictOptimizedIterableOps.super.flatten(toIterableOnce);
    }

    @Override
    public <B> IndexedSeq<Tuple2<Object, B>> zip(Iterable<B> that) {
        return (IndexedSeq)StrictOptimizedIterableOps.super.zip(that);
    }

    @Override
    public IndexedSeq<Tuple2<Object, Object>> zipWithIndex() {
        return (IndexedSeq)StrictOptimizedIterableOps.super.zipWithIndex();
    }

    @Override
    public <B> IndexedSeq<B> scanLeft(B z, Function2<B, Object, B> op) {
        return (IndexedSeq)StrictOptimizedIterableOps.super.scanLeft(z, op);
    }

    @Override
    public IndexedSeq<Object> filter(Function1<Object, Object> pred) {
        return (IndexedSeq)StrictOptimizedIterableOps.super.filter(pred);
    }

    @Override
    public IndexedSeq<Object> filterNot(Function1<Object, Object> pred) {
        return (IndexedSeq)StrictOptimizedIterableOps.super.filterNot(pred);
    }

    @Override
    public <B> IndexedSeq<Object> distinctBy(Function1<Object, B> f) {
        return (IndexedSeq)StrictOptimizedSeqOps.super.distinctBy(f);
    }

    @Override
    public <B> IndexedSeq<B> prepended(B elem) {
        return (IndexedSeq)StrictOptimizedSeqOps.super.prepended(elem);
    }

    @Override
    public <B> IndexedSeq<B> appended(B elem) {
        return (IndexedSeq)StrictOptimizedSeqOps.super.appended(elem);
    }

    @Override
    public <B> IndexedSeq<B> appendedAll(Iterable<B> suffix) {
        return (IndexedSeq)StrictOptimizedSeqOps.super.appendedAll(suffix);
    }

    @Override
    public <B> IndexedSeq<B> prependedAll(Iterable<B> prefix) {
        return (IndexedSeq)StrictOptimizedSeqOps.super.prependedAll(prefix);
    }

    @Override
    public <B> IndexedSeq<B> padTo(int len, B elem) {
        return (IndexedSeq)StrictOptimizedSeqOps.super.padTo(len, elem);
    }

    @Override
    public <B> IndexedSeq<B> updated(int index, B elem) {
        return (IndexedSeq)strawman.collection.immutable.StrictOptimizedSeqOps.super.updated(index, elem);
    }

    @Override
    public <B> IndexedSeq<B> patch(int from, IterableOnce<B> other, int replaced) {
        return (IndexedSeq)strawman.collection.immutable.StrictOptimizedSeqOps.super.patch(from, other, replaced);
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public int step() {
        return this.step;
    }

    @Override
    public SeqFactory<IndexedSeq> iterableFactory() {
        return IndexedSeq$.MODULE$;
    }

    @Override
    public IndexedSeq<Object> fromSpecificIterable(Iterable<Object> coll) {
        Range IterableOps_this = this;
        return (IndexedSeq)IterableOps_this.iterableFactory().from(coll);
    }

    @Override
    public Builder<Object, IndexedSeq<Object>> newSpecificBuilder() {
        return IndexedSeq$.MODULE$.newBuilder();
    }

    @Override
    public Iterator<Object> iterator() {
        return new RangeIterator(this.start(), this.step(), this.lastElement(), this.isEmpty());
    }

    private long gap() {
        return (long)this.end() - (long)this.start();
    }

    private boolean isExact() {
        return this.gap() % (long)this.step() == 0L;
    }

    private boolean hasStub() {
        return this.isInclusive() || !this.isExact();
    }

    private long longLength() {
        return this.gap() / (long)this.step() + (long)(this.hasStub() ? 1 : 0);
    }

    public abstract boolean isInclusive();

    @Override
    public boolean isEmpty() {
        return this.isEmpty;
    }

    public int numRangeElements() {
        return this.numRangeElements;
    }

    @Override
    public int length() {
        if (this.numRangeElements() < 0) {
            throw this.fail();
        }
        return this.numRangeElements();
    }

    private int lastElement() {
        return this.lastElement;
    }

    @Override
    public int last() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.head();
        }
        return this.lastElement();
    }

    @Override
    public int head() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.head();
        }
        return this.start();
    }

    @Override
    public Range init() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.init();
        }
        return this.dropRight(1);
    }

    @Override
    public Range tail() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.tail();
        }
        return this.numRangeElements() == 1 ? this.newEmptyRange(this.end()) : (this.isInclusive() ? new Inclusive(this.start() + this.step(), this.end(), this.step()) : new Exclusive(this.start() + this.step(), this.end(), this.step()));
    }

    public Range copy(int start, int end, int step, boolean isInclusive) {
        return isInclusive ? new Inclusive(start, end, step) : new Exclusive(start, end, step);
    }

    public int copy$default$1() {
        return this.start();
    }

    public int copy$default$2() {
        return this.end();
    }

    public int copy$default$3() {
        return this.step();
    }

    public boolean copy$default$4() {
        return this.isInclusive();
    }

    public Range by(int step) {
        return this.copy(this.start(), this.end(), step, this.copy$default$4());
    }

    private void validateMaxLength() {
        if (this.numRangeElements() < 0) {
            throw this.fail();
        }
    }

    private String description() {
        return new StringOps(Predef$.MODULE$.augmentString("%d %s %d by %s")).format((scala.collection.Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.start()), this.isInclusive() ? "to" : "until", BoxesRunTime.boxToInteger((int)this.end()), BoxesRunTime.boxToInteger((int)this.step())}));
    }

    private Nothing$ fail() {
        throw new IllegalArgumentException(this.description() + ": seqs cannot contain more than Int.MaxValue elements.");
    }

    @Override
    public int apply(int idx) {
        this.validateMaxLength();
        if (idx < 0 || idx >= this.numRangeElements()) {
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)idx)).toString());
        }
        return this.start() + this.step() * idx;
    }

    @Override
    public <U> void foreach(Function1<Object, U> f) {
        if (!this.isEmpty()) {
            int i = this.start();
            while (true) {
                f.apply((Object)BoxesRunTime.boxToInteger((int)i));
                if (i == this.lastElement()) {
                    return;
                }
                i += this.step();
            }
        }
    }

    @Override
    public Range take(int n) {
        return n <= 0 || this.isEmpty() ? this.newEmptyRange(this.start()) : (n >= this.numRangeElements() && this.numRangeElements() >= 0 ? this : new Inclusive(this.start(), this.locationAfterN(n - 1), this.step()));
    }

    @Override
    public Range drop(int n) {
        return n <= 0 || this.isEmpty() ? this : (n >= this.numRangeElements() && this.numRangeElements() >= 0 ? this.newEmptyRange(this.end()) : this.copy(this.locationAfterN(n), this.end(), this.step(), this.copy$default$4()));
    }

    @Override
    public Range takeRight(int n) {
        Range range;
        if (n <= 0) {
            range = this.newEmptyRange(this.start());
        } else if (this.numRangeElements() >= 0) {
            range = this.drop(this.numRangeElements() - n);
        } else {
            int y = this.last();
            long x = (long)y - (long)this.step() * (long)(n - 1);
            range = this.step() > 0 && x < (long)this.start() || this.step() < 0 && x > (long)this.start() ? this : Range$.MODULE$.inclusive((int)x, y, this.step());
        }
        return range;
    }

    @Override
    public Range dropRight(int n) {
        Range range;
        if (n <= 0) {
            range = this;
        } else if (this.numRangeElements() >= 0) {
            range = this.take(this.numRangeElements() - n);
        } else {
            int y = this.last() - this.step() * n;
            range = this.step() > 0 && y < this.start() || this.step() < 0 && y > this.start() ? this.newEmptyRange(this.start()) : Range$.MODULE$.inclusive(this.start(), y, this.step());
        }
        return range;
    }

    private long argTakeWhile(Function1<Object, Object> p) {
        long l;
        if (this.isEmpty()) {
            l = Int$.MODULE$.int2long(this.start());
        } else {
            int current;
            int stop = this.last();
            for (current = this.start(); current != stop && BoxesRunTime.unboxToBoolean((Object)p.apply((Object)BoxesRunTime.boxToInteger((int)current))); current += this.step()) {
            }
            l = current != stop || !BoxesRunTime.unboxToBoolean((Object)p.apply((Object)BoxesRunTime.boxToInteger((int)current))) ? Int$.MODULE$.int2long(current) : (long)current + (long)this.step();
        }
        return l;
    }

    @Override
    public Range takeWhile(Function1<Object, Object> p) {
        int x;
        long stop = this.argTakeWhile(p);
        return stop == (long)this.start() ? this.newEmptyRange(this.start()) : ((x = (int)(stop - (long)this.step())) == this.last() ? this : Range$.MODULE$.inclusive(this.start(), x, this.step()));
    }

    @Override
    public Range dropWhile(Function1<Object, Object> p) {
        int x;
        long stop = this.argTakeWhile(p);
        return stop == (long)this.start() ? this : ((x = (int)(stop - (long)this.step())) == this.last() ? this.newEmptyRange(this.last()) : Range$.MODULE$.inclusive(x + this.step(), this.last(), this.step()));
    }

    @Override
    public Tuple2<Range, Range> span(Function1<Object, Object> p) {
        int x;
        long border = this.argTakeWhile(p);
        return border == (long)this.start() ? Tuple2$.MODULE$.apply((Object)this.newEmptyRange(this.start()), (Object)this) : ((x = (int)(border - (long)this.step())) == this.last() ? Tuple2$.MODULE$.apply((Object)this, (Object)this.newEmptyRange(this.last())) : Tuple2$.MODULE$.apply((Object)Range$.MODULE$.inclusive(this.start(), x, this.step()), (Object)Range$.MODULE$.inclusive(x + this.step(), this.last(), this.step())));
    }

    @Override
    public Range slice(int from, int until) {
        Range range;
        if (from <= 0) {
            range = this.take(until);
        } else if (until >= this.numRangeElements() && this.numRangeElements() >= 0) {
            range = this.drop(from);
        } else {
            int fromValue = this.locationAfterN(from);
            range = from >= until ? this.newEmptyRange(fromValue) : Range$.MODULE$.inclusive(fromValue, this.locationAfterN(until - 1), this.step());
        }
        return range;
    }

    @Override
    public Tuple2<Range, Range> splitAt(int n) {
        return Tuple2$.MODULE$.apply((Object)this.take(n), (Object)this.drop(n));
    }

    private int locationAfterN(int n) {
        return this.start() + this.step() * n;
    }

    private Exclusive newEmptyRange(int value) {
        return new Exclusive(value, value, this.step());
    }

    @Override
    public Range reverse() {
        return this.isEmpty() ? this : new Inclusive(this.last(), this.start(), -this.step());
    }

    public Range inclusive() {
        return this.isInclusive() ? this : new Inclusive(this.start(), this.end(), this.step());
    }

    @Override
    public boolean contains(int x) {
        return x == this.end() && !this.isInclusive() ? false : (this.step() > 0 ? (x < this.start() || x > this.end() ? false : this.step() == 1 || (x - this.start()) % this.step() == 0) : (x < this.end() || x > this.start() ? false : this.step() == -1 || (x - this.start()) % this.step() == 0));
    }

    @Override
    public <B> int sum(Numeric<B> num) {
        int n;
        if (num == Numeric.IntIsIntegral$.MODULE$) {
            n = this.isEmpty() ? 0 : (this.size() == 1 ? this.head() : (int)((long)this.size() * ((long)this.head() + (long)this.last()) / 2L));
        } else if (this.isEmpty()) {
            n = num.toInt(num.zero());
        } else {
            Object acc = num.zero();
            int i = this.head();
            while (true) {
                acc = num.plus(acc, (Object)BoxesRunTime.boxToInteger((int)i));
                if (i == this.lastElement()) {
                    return num.toInt(acc);
                }
                i += this.step();
            }
        }
        return n;
    }

    @Override
    public <A1> int min(Ordering<A1> ord) {
        package$.MODULE$.Ordering();
        return ord == Ordering.Int$.MODULE$ ? (this.step() > 0 ? this.head() : this.last()) : BoxesRunTime.unboxToInt(IterableOps.super.min(ord));
    }

    @Override
    public <A1> int max(Ordering<A1> ord) {
        package$.MODULE$.Ordering();
        return ord == Ordering.Int$.MODULE$ ? (this.step() > 0 ? this.last() : this.head()) : BoxesRunTime.unboxToInt(IterableOps.super.max(ord));
    }

    @Override
    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof Range) {
            int l0;
            Range range;
            Range x = range = (Range)object;
            bl = this.isEmpty() ? x.isEmpty() : x.nonEmpty() && this.start() == x.start() && (l0 = this.last()) == x.last() && (this.start() == l0 || this.step() == x.step());
        } else {
            bl = Seq.super.equals(other);
        }
        return bl;
    }

    @Override
    public String toString() {
        String stepped;
        String preposition = this.isInclusive() ? "to" : "until";
        String string = stepped = this.step() == 1 ? "" : StringContext$.MODULE$.apply((scala.collection.Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" by ", ""})).s((scala.collection.Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.step())}));
        String prefix = this.isEmpty() ? "empty " : (!this.isExact() ? "inexact " : "");
        return StringContext$.MODULE$.apply((scala.collection.Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "Range ", " ", " ", "", ""})).s((scala.collection.Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix, BoxesRunTime.boxToInteger((int)this.start()), preposition, BoxesRunTime.boxToInteger((int)this.end()), stepped}));
    }

    public static final class Exclusive
    extends Range {
        public Exclusive(int start, int end, int step) {
            super(start, end, step);
        }

        public int strawman$collection$immutable$Range$Exclusive$$start() {
            return super.start();
        }

        public int strawman$collection$immutable$Range$Exclusive$$end() {
            return super.end();
        }

        public int strawman$collection$immutable$Range$Exclusive$$step() {
            return super.step();
        }

        @Override
        public boolean isInclusive() {
            return false;
        }
    }

    public static final class Inclusive
    extends Range {
        public Inclusive(int start, int end, int step) {
            super(start, end, step);
        }

        public int strawman$collection$immutable$Range$Inclusive$$start() {
            return super.start();
        }

        public int strawman$collection$immutable$Range$Inclusive$$end() {
            return super.end();
        }

        public int strawman$collection$immutable$Range$Inclusive$$step() {
            return super.step();
        }

        @Override
        public boolean isInclusive() {
            return true;
        }
    }

    public static final class Partial<T, U> {
        private final Function1 f;

        public static Object by$extension(Function1 function1, Object object) {
            return Range$Partial$.MODULE$.by$extension(function1, object);
        }

        public static boolean equals$extension(Function1 function1, Object object) {
            return Range$Partial$.MODULE$.equals$extension(function1, object);
        }

        public static String toString$extension(Function1 function1) {
            return Range$Partial$.MODULE$.toString$extension(function1);
        }

        public static int hashCode$extension(Function1 function1) {
            return Range$Partial$.MODULE$.hashCode$extension(function1);
        }

        public <T, U> Partial(Function1<T, U> f) {
            this.f = f;
        }

        public Function1<T, U> strawman$collection$immutable$Range$Partial$$f() {
            return this.f;
        }

        public U by(T x) {
            return Range$Partial$.MODULE$.by$extension(this.strawman$collection$immutable$Range$Partial$$f(), x);
        }

        public String toString() {
            return Range$Partial$.MODULE$.toString$extension(this.strawman$collection$immutable$Range$Partial$$f());
        }

        public int hashCode() {
            return Range$Partial$.MODULE$.hashCode$extension(this.strawman$collection$immutable$Range$Partial$$f());
        }

        public boolean equals(Object x$0) {
            return Range$Partial$.MODULE$.equals$extension(this.strawman$collection$immutable$Range$Partial$$f(), x$0);
        }
    }
}

