/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.mutable;

import java.util.Arrays;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some$;
import scala.Tuple2;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import strawman.collection.BitSetOps;
import strawman.collection.Iterable;
import strawman.collection.IterableFactoryLike;
import strawman.collection.IterableOnce;
import strawman.collection.Set;
import strawman.collection.SetOps;
import strawman.collection.SortedIterableFactory;
import strawman.collection.SortedSetOps;
import strawman.collection.StrictOptimizedIterableOps;
import strawman.collection.immutable.Range$;
import strawman.collection.mutable.BitSet$;
import strawman.collection.mutable.Builder;
import strawman.collection.mutable.Set$;
import strawman.collection.mutable.SortedSet;
import strawman.collection.mutable.SortedSet$;

public class BitSet
implements SortedSet<Object>,
strawman.collection.BitSet,
StrictOptimizedIterableOps<Object, strawman.collection.mutable.Set, BitSet>,
Serializable {
    private long[] elems;

    public static Object fill(int n, Function0 function0) {
        return BitSet$.MODULE$.fill(n, function0);
    }

    public static Builder<Object, BitSet> newBuilder() {
        return BitSet$.MODULE$.newBuilder();
    }

    public static BitSet fromSpecific(IterableOnce<Object> iterableOnce) {
        return BitSet$.MODULE$.fromSpecific((IterableOnce)iterableOnce);
    }

    public BitSet(long[] elems) {
        this.elems = elems;
        Function1.$init$((Function1)this);
    }

    public <A> Function1<A, Object> compose(Function1<A, Object> g) {
        return Function1.compose$((Function1)this, g);
    }

    public <A> Function1<Object, A> andThen(Function1<Object, A> g) {
        return Function1.andThen$((Function1)this, g);
    }

    @Override
    public String toString() {
        return SetOps.super.toString();
    }

    @Override
    public boolean equals(Object that) {
        return Set.super.equals(that);
    }

    @Override
    public int hashCode() {
        return Set.super.hashCode();
    }

    @Override
    public SortedSetOps.SortedWithFilter withFilter(Function1<Object, Object> p) {
        return SortedSetOps.super.withFilter(p);
    }

    @Override
    public int size() {
        return BitSetOps.super.size();
    }

    @Override
    public boolean isEmpty() {
        return BitSetOps.super.isEmpty();
    }

    @Override
    public <U> void foreach(Function1<Object, U> f) {
        BitSetOps.super.foreach(f);
    }

    @Override
    public Tuple2<BitSet, BitSet> partition(Function1<Object, Object> p) {
        return StrictOptimizedIterableOps.super.partition(p);
    }

    @Override
    public Tuple2<BitSet, BitSet> span(Function1<Object, Object> p) {
        return StrictOptimizedIterableOps.super.span(p);
    }

    @Override
    public <A1, A2> Tuple2<strawman.collection.mutable.Set<A1>, strawman.collection.mutable.Set<A2>> unzip(Predef$.less.colon.less<Object, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.super.unzip(asPair);
    }

    @Override
    public <B> strawman.collection.mutable.Set<B> map(Function1<Object, B> f) {
        return (strawman.collection.mutable.Set)StrictOptimizedIterableOps.super.map(f);
    }

    @Override
    public <B> strawman.collection.mutable.Set<B> flatMap(Function1<Object, IterableOnce<B>> f) {
        return (strawman.collection.mutable.Set)StrictOptimizedIterableOps.super.flatMap(f);
    }

    @Override
    public <B> strawman.collection.mutable.Set<B> collect(PartialFunction<Object, B> pf) {
        return (strawman.collection.mutable.Set)StrictOptimizedIterableOps.super.collect(pf);
    }

    @Override
    public <B> strawman.collection.mutable.Set<B> flatten(Function1<Object, IterableOnce<B>> toIterableOnce) {
        return (strawman.collection.mutable.Set)StrictOptimizedIterableOps.super.flatten(toIterableOnce);
    }

    @Override
    public <B> strawman.collection.mutable.Set<Tuple2<Object, B>> zip(Iterable<B> that) {
        return (strawman.collection.mutable.Set)StrictOptimizedIterableOps.super.zip(that);
    }

    @Override
    public strawman.collection.mutable.Set<Tuple2<Object, Object>> zipWithIndex() {
        return (strawman.collection.mutable.Set)StrictOptimizedIterableOps.super.zipWithIndex();
    }

    @Override
    public <B> strawman.collection.mutable.Set<B> scanLeft(B z, Function2<B, Object, B> op) {
        return (strawman.collection.mutable.Set)StrictOptimizedIterableOps.super.scanLeft(z, op);
    }

    @Override
    public BitSet filter(Function1<Object, Object> pred) {
        return (BitSet)StrictOptimizedIterableOps.super.filter(pred);
    }

    @Override
    public BitSet filterNot(Function1<Object, Object> pred) {
        return (BitSet)StrictOptimizedIterableOps.super.filterNot(pred);
    }

    public long[] elems() {
        return this.elems;
    }

    public void elems_$eq(long[] x$1) {
        this.elems = x$1;
    }

    public BitSet(int initSize) {
        this(new long[package$.MODULE$.max(initSize + 63 >> 6, 1)]);
    }

    public BitSet() {
        this(0);
    }

    @Override
    public IterableFactoryLike<strawman.collection.mutable.Set> iterableFactory() {
        return Set$.MODULE$;
    }

    @Override
    public SortedIterableFactory<SortedSet> sortedIterableFactory() {
        return SortedSet$.MODULE$;
    }

    @Override
    public <B> SortedSet<B> sortedFromIterable(Iterable<B> it, Ordering<B> evidence$68) {
        return (SortedSet)SortedSet$.MODULE$.from(it, evidence$68);
    }

    @Override
    public BitSet fromSpecificIterable(Iterable<Object> coll) {
        return BitSet$.MODULE$.fromSpecific((IterableOnce)coll);
    }

    @Override
    public Builder<Object, BitSet> newSpecificBuilder() {
        return BitSet$.MODULE$.newBuilder();
    }

    @Override
    public final int nwords() {
        return this.elems().length;
    }

    @Override
    public final long word(int idx) {
        return idx < this.nwords() ? this.elems()[idx] : 0L;
    }

    @Override
    public BitSet fromBitMaskNoCopy(long[] elems) {
        return new BitSet(elems);
    }

    public BitSet add(int elem) {
        block0: {
            Predef$.MODULE$.require(elem >= 0);
            if (this.contains(elem)) break block0;
            int idx = elem >> 6;
            this.updateWord(idx, this.word(idx) | 1L << elem);
        }
        return this;
    }

    public BitSet subtract(int elem) {
        block0: {
            Predef$.MODULE$.require(elem >= 0);
            if (!this.contains(elem)) break block0;
            int idx = elem >> 6;
            this.updateWord(idx, this.word(idx) & (1L << elem ^ 0xFFFFFFFFFFFFFFFFL));
        }
        return this;
    }

    @Override
    public void clear() {
        this.elems_$eq(new long[this.elems().length]);
    }

    public final void updateWord(int idx, long w) {
        this.ensureCapacity(idx);
        this.elems()[idx] = w;
    }

    public final void ensureCapacity(int idx) {
        block1: {
            Predef$.MODULE$.require(idx < 0x2000000);
            if (idx < this.nwords()) break block1;
            int newlen = this.nwords();
            while (idx >= newlen) {
                newlen = package$.MODULE$.min(newlen * 2, 0x2000000);
            }
            long[] elems1 = new long[newlen];
            Array$.MODULE$.copy((Object)this.elems(), 0, (Object)elems1, 0, this.nwords());
            this.elems_$eq(elems1);
        }
    }

    @Override
    public Option<Object> get(int elem) {
        return this.contains(elem) ? Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)elem)) : None$.MODULE$;
    }

    public Set<Object> unconstrained() {
        return this;
    }

    @Override
    public BitSet empty() {
        return BitSet$.MODULE$.empty();
    }

    public BitSet $bar$eq(BitSet other) {
        this.ensureCapacity(other.nwords() - 1);
        Range$.MODULE$.apply(0, other.nwords()).foreach(arg_0 -> this.$bar$eq$$anonfun$1(other, arg_0));
        return this;
    }

    public BitSet $amp$eq(BitSet other) {
        Range$.MODULE$.apply(0, this.nwords()).foreach(arg_0 -> this.$amp$eq$$anonfun$1(other, arg_0));
        return this;
    }

    public BitSet $up$eq(BitSet other) {
        this.ensureCapacity(other.nwords() - 1);
        Range$.MODULE$.apply(0, other.nwords()).foreach(arg_0 -> this.$up$eq$$anonfun$1(other, arg_0));
        return this;
    }

    public BitSet $amp$tilde$eq(BitSet other) {
        this.ensureCapacity(other.nwords() - 1);
        Range$.MODULE$.apply(0, other.nwords()).foreach(arg_0 -> this.$amp$tilde$eq$$anonfun$1(other, arg_0));
        return this;
    }

    @Override
    public BitSet clone() {
        return new BitSet(Arrays.copyOf(this.elems(), this.elems().length));
    }

    public strawman.collection.immutable.BitSet toImmutable() {
        return strawman.collection.immutable.BitSet$.MODULE$.fromBitMask(this.elems());
    }

    private void $bar$eq$$anonfun$1(BitSet other$2, int i) {
        this.elems()[i] = this.elems()[i] | other$2.word(i);
    }

    private void $amp$eq$$anonfun$1(BitSet other$3, int i) {
        this.elems()[i] = this.elems()[i] & other$3.word(i);
    }

    private void $up$eq$$anonfun$1(BitSet other$4, int i) {
        this.elems()[i] = this.elems()[i] ^ other$4.word(i);
    }

    private void $amp$tilde$eq$$anonfun$1(BitSet other$5, int i) {
        this.elems()[i] = this.elems()[i] & (other$5.word(i) ^ 0xFFFFFFFFFFFFFFFFL);
    }
}

