/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.mutable;

import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.math.Ordering;
import strawman.collection.Iterator;
import strawman.collection.mutable.RedBlackTree;
import strawman.collection.mutable.RedBlackTree$Node$;
import strawman.collection.mutable.RedBlackTree$Tree$;

public final class RedBlackTree$ {
    public static final RedBlackTree$ MODULE$;
    public final RedBlackTree$Tree$ Tree;
    public final RedBlackTree$Node$ Node;

    static {
        new RedBlackTree$();
    }

    public RedBlackTree$() {
        MODULE$ = this;
    }

    public boolean isRed(RedBlackTree.Node<?, ?> node) {
        return node != null && node.red();
    }

    public boolean isBlack(RedBlackTree.Node<?, ?> node) {
        return node == null || !node.red();
    }

    public int size(RedBlackTree.Node<?, ?> node) {
        return node == null ? 0 : 1 + this.size(node.left()) + this.size(node.right());
    }

    public int size(RedBlackTree.Tree<?, ?> tree) {
        return tree.size();
    }

    public boolean isEmpty(RedBlackTree.Tree<?, ?> tree) {
        return tree.root() == null;
    }

    public void clear(RedBlackTree.Tree<?, ?> tree) {
        tree.root_$eq(null);
        tree.size_$eq(0);
    }

    public <A, B> Option<B> get(RedBlackTree.Tree<A, B> tree, A key, Ordering<A> evidence$74) {
        None$ none$;
        RedBlackTree.Node<A, B> node = this.getNode(tree.root(), key, evidence$74);
        if (node == null) {
            none$ = None$.MODULE$;
        } else {
            RedBlackTree.Node<A, B> node2 = node;
            none$ = Some$.MODULE$.apply(node2.value());
        }
        return none$;
    }

    public <A> Option<A> getKey(RedBlackTree.Tree<A, ?> tree, A key, Ordering<A> evidence$75) {
        None$ none$;
        RedBlackTree.Node<A, ?> node = this.getNode(tree.root(), key, evidence$75);
        if (node == null) {
            none$ = None$.MODULE$;
        } else {
            RedBlackTree.Node<A, ?> node2 = node;
            none$ = Some$.MODULE$.apply(node2.key());
        }
        return none$;
    }

    /*
     * Enabled aggressive block sorting
     */
    private <A, B> RedBlackTree.Node<A, B> getNode(RedBlackTree.Node<A, B> node, A key, Ordering<A> ord) {
        Ordering<A> ordering = ord;
        A a = key;
        RedBlackTree.Node<A, B> node2 = node;
        RedBlackTree$ redBlackTree$ = this;
        while (node2 != null) {
            int cmp = ordering.compare(a, node2.key());
            if (cmp < 0) {
                node2 = node2.left();
                continue;
            }
            if (cmp <= 0) {
                RedBlackTree.Node<A, B> node3 = node2;
                return node3;
            }
            node2 = node2.right();
        }
        return null;
    }

    public <A> boolean contains(RedBlackTree.Tree<A, ?> tree, A key, Ordering<A> evidence$76) {
        return this.getNode(tree.root(), key, evidence$76) != null;
    }

    public <A, B> Option<Tuple2<A, B>> min(RedBlackTree.Tree<A, B> tree) {
        None$ none$;
        RedBlackTree.Node<A, B> node = this.strawman$collection$mutable$RedBlackTree$$$minNode(tree.root());
        if (node == null) {
            none$ = None$.MODULE$;
        } else {
            RedBlackTree.Node<A, B> node2 = node;
            none$ = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(node2.key(), node2.value()));
        }
        return none$;
    }

    public <A> Option<A> minKey(RedBlackTree.Tree<A, ?> tree) {
        None$ none$;
        RedBlackTree.Node<A, ?> node = this.strawman$collection$mutable$RedBlackTree$$$minNode(tree.root());
        if (node == null) {
            none$ = None$.MODULE$;
        } else {
            RedBlackTree.Node<A, ?> node2 = node;
            none$ = Some$.MODULE$.apply(node2.key());
        }
        return none$;
    }

    public <A, B> RedBlackTree.Node<A, B> strawman$collection$mutable$RedBlackTree$$$minNode(RedBlackTree.Node<A, B> node) {
        return node == null ? null : this.minNodeNonNull(node);
    }

    /*
     * Enabled aggressive block sorting
     */
    public <A, B> RedBlackTree.Node<A, B> minNodeNonNull(RedBlackTree.Node<A, B> node) {
        RedBlackTree.Node<A, B> node2 = node;
        RedBlackTree$ redBlackTree$ = this;
        while (node2.left() != null) {
            node2 = node2.left();
        }
        return node2;
    }

    public <A, B> Option<Tuple2<A, B>> max(RedBlackTree.Tree<A, B> tree) {
        None$ none$;
        RedBlackTree.Node<A, B> node = this.maxNode(tree.root());
        if (node == null) {
            none$ = None$.MODULE$;
        } else {
            RedBlackTree.Node<A, B> node2 = node;
            none$ = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(node2.key(), node2.value()));
        }
        return none$;
    }

    public <A> Option<A> maxKey(RedBlackTree.Tree<A, ?> tree) {
        None$ none$;
        RedBlackTree.Node<A, ?> node = this.maxNode(tree.root());
        if (node == null) {
            none$ = None$.MODULE$;
        } else {
            RedBlackTree.Node<A, ?> node2 = node;
            none$ = Some$.MODULE$.apply(node2.key());
        }
        return none$;
    }

    private <A, B> RedBlackTree.Node<A, B> maxNode(RedBlackTree.Node<A, B> node) {
        return node == null ? null : this.maxNodeNonNull(node);
    }

    /*
     * Enabled aggressive block sorting
     */
    public <A, B> RedBlackTree.Node<A, B> maxNodeNonNull(RedBlackTree.Node<A, B> node) {
        RedBlackTree.Node<A, B> node2 = node;
        RedBlackTree$ redBlackTree$ = this;
        while (node2.right() != null) {
            node2 = node2.right();
        }
        return node2;
    }

    public <A, B> Option<Tuple2<A, B>> minAfter(RedBlackTree.Tree<A, B> tree, A key, Ordering<A> ord) {
        None$ none$;
        RedBlackTree.Node<A, B> node = this.strawman$collection$mutable$RedBlackTree$$$minNodeAfter(tree.root(), key, ord);
        if (node == null) {
            none$ = None$.MODULE$;
        } else {
            RedBlackTree.Node<A, B> node2 = node;
            none$ = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(node2.key(), node2.value()));
        }
        return none$;
    }

    public <A> Option<A> minKeyAfter(RedBlackTree.Tree<A, ?> tree, A key, Ordering<A> ord) {
        None$ none$;
        RedBlackTree.Node<A, ?> node = this.strawman$collection$mutable$RedBlackTree$$$minNodeAfter(tree.root(), key, ord);
        if (node == null) {
            none$ = None$.MODULE$;
        } else {
            RedBlackTree.Node<A, ?> node2 = node;
            none$ = Some$.MODULE$.apply(node2.key());
        }
        return none$;
    }

    public <A, B> RedBlackTree.Node<A, B> strawman$collection$mutable$RedBlackTree$$$minNodeAfter(RedBlackTree.Node<A, B> node, A key, Ordering<A> ord) {
        RedBlackTree.Node<A, B> node2;
        if (node == null) {
            node2 = null;
        } else {
            RedBlackTree.Node<A, B> y = null;
            RedBlackTree.Node<A, B> x = node;
            int cmp = 1;
            while (x != null && cmp != 0) {
                y = x;
                cmp = ord.compare(key, x.key());
                x = cmp < 0 ? x.left() : x.right();
            }
            node2 = cmp <= 0 ? y : this.strawman$collection$mutable$RedBlackTree$$$successor(y);
        }
        return node2;
    }

    public <A, B> Option<Tuple2<A, B>> maxBefore(RedBlackTree.Tree<A, B> tree, A key, Ordering<A> ord) {
        None$ none$;
        RedBlackTree.Node<A, B> node = this.maxNodeBefore(tree.root(), key, ord);
        if (node == null) {
            none$ = None$.MODULE$;
        } else {
            RedBlackTree.Node<A, B> node2 = node;
            none$ = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(node2.key(), node2.value()));
        }
        return none$;
    }

    public <A> Option<A> maxKeyBefore(RedBlackTree.Tree<A, ?> tree, A key, Ordering<A> ord) {
        None$ none$;
        RedBlackTree.Node<A, ?> node = this.maxNodeBefore(tree.root(), key, ord);
        if (node == null) {
            none$ = None$.MODULE$;
        } else {
            RedBlackTree.Node<A, ?> node2 = node;
            none$ = Some$.MODULE$.apply(node2.key());
        }
        return none$;
    }

    private <A, B> RedBlackTree.Node<A, B> maxNodeBefore(RedBlackTree.Node<A, B> node, A key, Ordering<A> ord) {
        RedBlackTree.Node<A, B> node2;
        if (node == null) {
            node2 = null;
        } else {
            RedBlackTree.Node<A, B> y = null;
            RedBlackTree.Node<A, B> x = node;
            int cmp = 1;
            while (x != null && cmp != 0) {
                y = x;
                cmp = ord.compare(key, x.key());
                x = cmp < 0 ? x.left() : x.right();
            }
            node2 = cmp > 0 ? y : this.predecessor(y);
        }
        return node2;
    }

    public <A, B> void insert(RedBlackTree.Tree<A, B> tree, A key, B value, Ordering<A> ord) {
        RedBlackTree.Node<A, B> y = null;
        RedBlackTree.Node<A, B> x = tree.root();
        int cmp = 1;
        while (x != null && cmp != 0) {
            y = x;
            cmp = ord.compare(key, x.key());
            x = cmp < 0 ? x.left() : x.right();
        }
        if (cmp == 0) {
            y.value_$eq(value);
        } else {
            RedBlackTree.Node<A, B> parent = y;
            RedBlackTree.Node<A, B> z = new RedBlackTree.Node<A, B>(key, value, true, null, null, parent);
            if (y == null) {
                tree.root_$eq(z);
            } else if (cmp < 0) {
                y.left_$eq(z);
            } else {
                y.right_$eq(z);
            }
            this.fixAfterInsert(tree, z);
            tree.size_$eq(tree.size() + 1);
        }
    }

    private <A, B> void fixAfterInsert(RedBlackTree.Tree<A, B> tree, RedBlackTree.Node<A, B> node) {
        RedBlackTree.Node<A, B> z = node;
        while (this.isRed(z.parent())) {
            if (z.parent() == z.parent().parent().left()) {
                RedBlackTree.Node<A, B> y = z.parent().parent().right();
                if (this.isRed(y)) {
                    z.parent().red_$eq(false);
                    y.red_$eq(false);
                    z.parent().parent().red_$eq(true);
                    z = z.parent().parent();
                    continue;
                }
                if (z == z.parent().right()) {
                    z = z.parent();
                    this.rotateLeft(tree, z);
                }
                z.parent().red_$eq(false);
                z.parent().parent().red_$eq(true);
                this.rotateRight(tree, z.parent().parent());
                continue;
            }
            RedBlackTree.Node<A, B> y = z.parent().parent().left();
            if (this.isRed(y)) {
                z.parent().red_$eq(false);
                y.red_$eq(false);
                z.parent().parent().red_$eq(true);
                z = z.parent().parent();
                continue;
            }
            if (z == z.parent().left()) {
                z = z.parent();
                this.rotateRight(tree, z);
            }
            z.parent().red_$eq(false);
            z.parent().parent().red_$eq(true);
            this.rotateLeft(tree, z.parent().parent());
        }
        tree.root().red_$eq(false);
    }

    public <A, B> void delete(RedBlackTree.Tree<A, B> tree, A key, Ordering<A> ord) {
        block7: {
            RedBlackTree.Node<A, B> z = this.getNode(tree.root(), key, ord);
            if (z == null) break block7;
            RedBlackTree.Node<A, B> y = z;
            boolean yIsRed = y.red();
            RedBlackTree.Node<A, B> x = null;
            RedBlackTree.Node<A, B> xParent = null;
            if (z.left() == null) {
                x = z.right();
                this.transplant(tree, z, z.right());
                xParent = z.parent();
            } else if (z.right() == null) {
                x = z.left();
                this.transplant(tree, z, z.left());
                xParent = z.parent();
            } else {
                y = this.minNodeNonNull(z.right());
                yIsRed = y.red();
                x = y.right();
                if (y.parent() == z) {
                    xParent = y;
                } else {
                    xParent = y.parent();
                    this.transplant(tree, y, y.right());
                    y.right_$eq(z.right());
                    y.right().parent_$eq(y);
                }
                this.transplant(tree, z, y);
                y.left_$eq(z.left());
                y.left().parent_$eq(y);
                y.red_$eq(z.red());
            }
            if (!yIsRed) {
                this.fixAfterDelete(tree, x, xParent);
            }
            tree.size_$eq(tree.size() - 1);
        }
    }

    private <A, B> void fixAfterDelete(RedBlackTree.Tree<A, B> tree, RedBlackTree.Node<A, B> node, RedBlackTree.Node<A, B> parent) {
        block11: {
            RedBlackTree.Node<A, B> x = node;
            RedBlackTree.Node<A, B> xParent = parent;
            while (x != tree.root() && this.isBlack(x)) {
                if (x == xParent.left()) {
                    RedBlackTree.Node<A, B> w = xParent.right();
                    if (w.red()) {
                        w.red_$eq(false);
                        xParent.red_$eq(true);
                        this.rotateLeft(tree, xParent);
                        w = xParent.right();
                    }
                    if (this.isBlack(w.left()) && this.isBlack(w.right())) {
                        w.red_$eq(true);
                        x = xParent;
                    } else {
                        if (this.isBlack(w.right())) {
                            w.left().red_$eq(false);
                            w.red_$eq(true);
                            this.rotateRight(tree, w);
                            w = xParent.right();
                        }
                        w.red_$eq(xParent.red());
                        xParent.red_$eq(false);
                        w.right().red_$eq(false);
                        this.rotateLeft(tree, xParent);
                        x = tree.root();
                    }
                } else {
                    RedBlackTree.Node<A, B> w = xParent.left();
                    if (w.red()) {
                        w.red_$eq(false);
                        xParent.red_$eq(true);
                        this.rotateRight(tree, xParent);
                        w = xParent.left();
                    }
                    if (this.isBlack(w.right()) && this.isBlack(w.left())) {
                        w.red_$eq(true);
                        x = xParent;
                    } else {
                        if (this.isBlack(w.left())) {
                            w.right().red_$eq(false);
                            w.red_$eq(true);
                            this.rotateLeft(tree, w);
                            w = xParent.left();
                        }
                        w.red_$eq(xParent.red());
                        xParent.red_$eq(false);
                        w.left().red_$eq(false);
                        this.rotateRight(tree, xParent);
                        x = tree.root();
                    }
                }
                xParent = x.parent();
            }
            if (x == null) break block11;
            x.red_$eq(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> RedBlackTree.Node<A, B> strawman$collection$mutable$RedBlackTree$$$successor(RedBlackTree.Node<A, B> node) {
        RedBlackTree.Node<A, B> node2;
        if (node.right() != null) {
            node2 = this.minNodeNonNull(node.right());
        } else {
            void var3_3;
            RedBlackTree.Node<A, B> x = node;
            for (RedBlackTree.Node<A, B> y = x.parent(); y != null && x == y.right(); y = y.parent()) {
                x = y;
            }
            node2 = var3_3;
        }
        return node2;
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> RedBlackTree.Node<A, B> predecessor(RedBlackTree.Node<A, B> node) {
        RedBlackTree.Node<A, B> node2;
        if (node.left() != null) {
            node2 = this.maxNodeNonNull(node.left());
        } else {
            void var3_3;
            RedBlackTree.Node<A, B> x = node;
            for (RedBlackTree.Node<A, B> y = x.parent(); y != null && x == y.left(); y = y.parent()) {
                x = y;
            }
            node2 = var3_3;
        }
        return node2;
    }

    private <A, B> void rotateLeft(RedBlackTree.Tree<A, B> tree, RedBlackTree.Node<A, B> x) {
        block5: {
            if (x == null) break block5;
            RedBlackTree.Node<A, B> y = x.right();
            x.right_$eq(y.left());
            if (y.left() != null) {
                y.left().parent_$eq(x);
            }
            y.parent_$eq(x.parent());
            if (x.parent() == null) {
                tree.root_$eq(y);
            } else if (x == x.parent().left()) {
                x.parent().left_$eq(y);
            } else {
                x.parent().right_$eq(y);
            }
            y.left_$eq(x);
            x.parent_$eq(y);
        }
    }

    private <A, B> void rotateRight(RedBlackTree.Tree<A, B> tree, RedBlackTree.Node<A, B> x) {
        block5: {
            if (x == null) break block5;
            RedBlackTree.Node<A, B> y = x.left();
            x.left_$eq(y.right());
            if (y.right() != null) {
                y.right().parent_$eq(x);
            }
            y.parent_$eq(x.parent());
            if (x.parent() == null) {
                tree.root_$eq(y);
            } else if (x == x.parent().right()) {
                x.parent().right_$eq(y);
            } else {
                x.parent().left_$eq(y);
            }
            y.right_$eq(x);
            x.parent_$eq(y);
        }
    }

    private <A, B> void transplant(RedBlackTree.Tree<A, B> tree, RedBlackTree.Node<A, B> to, RedBlackTree.Node<A, B> from) {
        block4: {
            if (to.parent() == null) {
                tree.root_$eq(from);
            } else if (to == to.parent().left()) {
                to.parent().left_$eq(from);
            } else {
                to.parent().right_$eq(from);
            }
            if (from == null) break block4;
            from.parent_$eq(to.parent());
        }
    }

    public <A, B, U> void foreach(RedBlackTree.Tree<A, B> tree, Function1<Tuple2<A, B>, U> f) {
        this.foreachNode(tree.root(), f);
    }

    private <A, B, U> void foreachNode(RedBlackTree.Node<A, B> node, Function1<Tuple2<A, B>, U> f) {
        block0: {
            if (node == null) break block0;
            this.foreachNodeNonNull(node, f);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private <A, B, U> void foreachNodeNonNull(RedBlackTree.Node<A, B> node, Function1<Tuple2<A, B>, U> f) {
        Function1<Tuple2<A, B>, U> function1 = f;
        RedBlackTree.Node<A, B> node2 = node;
        RedBlackTree$ redBlackTree$ = this;
        while (true) {
            if (node2.left() != null) {
                this.foreachNodeNonNull(node2.left(), function1);
            }
            function1.apply((Object)Tuple2$.MODULE$.apply(node2.key(), node2.value()));
            if (node2.right() == null) {
                return;
            }
            node2 = node2.right();
        }
    }

    public <A, U> void foreachKey(RedBlackTree.Tree<A, ?> tree, Function1<A, U> f) {
        this.foreachNodeKey(tree.root(), f);
    }

    private <A, U> void foreachNodeKey(RedBlackTree.Node<A, ?> node, Function1<A, U> f) {
        block0: {
            if (node == null) break block0;
            this.foreachNodeKeyNonNull(node, f);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private <A, U> void foreachNodeKeyNonNull(RedBlackTree.Node<A, ?> node, Function1<A, U> f) {
        Function1<A, U> function1 = f;
        RedBlackTree.Node<A, ?> node2 = node;
        RedBlackTree$ redBlackTree$ = this;
        while (true) {
            if (node2.left() != null) {
                this.foreachNodeKeyNonNull(node2.left(), function1);
            }
            function1.apply(node2.key());
            if (node2.right() == null) {
                return;
            }
            node2 = node2.right();
        }
    }

    public <A, B> void transform(RedBlackTree.Tree<A, B> tree, Function2<A, B, B> f) {
        this.transformNode(tree.root(), f);
    }

    private <A, B, U> void transformNode(RedBlackTree.Node<A, B> node, Function2<A, B, B> f) {
        block0: {
            if (node == null) break block0;
            this.transformNodeNonNull(node, f);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private <A, B, U> void transformNodeNonNull(RedBlackTree.Node<A, B> node, Function2<A, B, B> f) {
        Function2<A, B, B> function2 = f;
        RedBlackTree.Node<A, Object> node2 = node;
        RedBlackTree$ redBlackTree$ = this;
        while (true) {
            if (node2.left() != null) {
                this.transformNodeNonNull(node2.left(), function2);
            }
            node2.value_$eq(function2.apply(node2.key(), node2.value()));
            if (node2.right() == null) {
                return;
            }
            node2 = node2.right();
        }
    }

    public <A, B> Iterator<Tuple2<A, B>> iterator(RedBlackTree.Tree<A, B> tree, Option<A> start, Option<A> end, Ordering<A> evidence$77) {
        return new RedBlackTree.EntriesIterator<A, B>(tree, start, end, evidence$77);
    }

    public <A, B> None$ iterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> None$ iterator$default$3() {
        return None$.MODULE$;
    }

    public <A> Iterator<A> keysIterator(RedBlackTree.Tree<A, ?> tree, Option<A> start, Option<A> end, Ordering<A> evidence$78) {
        return new RedBlackTree.KeysIterator(tree, start, end, evidence$78);
    }

    public <A> None$ keysIterator$default$2() {
        return None$.MODULE$;
    }

    public <A> None$ keysIterator$default$3() {
        return None$.MODULE$;
    }

    public <A, B> Iterator<B> valuesIterator(RedBlackTree.Tree<A, B> tree, Option<A> start, Option<A> end, Ordering<A> evidence$79) {
        return new RedBlackTree.ValuesIterator<A, B>(tree, start, end, evidence$79);
    }

    public <A, B> None$ valuesIterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> None$ valuesIterator$default$3() {
        return None$.MODULE$;
    }

    public <A, B> boolean isValid(RedBlackTree.Tree<A, B> tree, Ordering<A> evidence$83) {
        return this.isValidBST(tree.root(), evidence$83) && this.hasProperParentRefs(tree) && this.isValidRedBlackTree(tree) && this.size(tree.root()) == tree.size();
    }

    private <A, B> boolean hasProperParentRefs(RedBlackTree.Tree<A, B> tree) {
        return tree.root() == null ? true : tree.root().parent() == null && this.hasProperParentRefs$1(tree.root());
    }

    /*
     * Enabled aggressive block sorting
     */
    private <A, B> boolean isValidBST(RedBlackTree.Node<A, B> node, Ordering<A> ord) {
        Ordering<A> ordering = ord;
        RedBlackTree.Node<A, B> node2 = node;
        RedBlackTree$ redBlackTree$ = this;
        while (node2 != null) {
            if (node2.left() != null) {
                if (ordering.compare(node2.key(), node2.left().key()) <= 0) return false;
            }
            if (node2.right() != null && ordering.compare(node2.key(), node2.right().key()) >= 0) {
                return false;
            }
            if (!this.isValidBST(node2.left(), ordering)) {
                return false;
            }
            node2 = node2.right();
        }
        return true;
    }

    private <A, B> boolean isValidRedBlackTree(RedBlackTree.Tree<A, B> tree) {
        return this.isBlack(tree.root()) && this.noRedAfterRed$1(tree.root()) && this.blackHeight$1(tree.root()) >= 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean hasProperParentRefs$1(RedBlackTree.Node<A, B> node) {
        RedBlackTree.Node node2 = node;
        while (node2 != null) {
            if (node2.left() != null) {
                if (node2.left().parent() != node2) return false;
            }
            if (node2.right() != null && node2.right().parent() != node2) {
                return false;
            }
            if (!this.hasProperParentRefs$1(node2.left())) {
                return false;
            }
            node2 = node2.right();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean noRedAfterRed$1(RedBlackTree.Node<A, B> node) {
        RedBlackTree.Node node2 = node;
        while (node2 != null) {
            if (node2.red()) {
                if (this.isRed(node2.left())) return false;
                if (this.isRed(node2.right())) {
                    return false;
                }
            }
            if (!this.noRedAfterRed$1(node2.left())) {
                return false;
            }
            node2 = node2.right();
        }
        return true;
    }

    private int blackHeight$1(RedBlackTree.Node<A, B> node) {
        int n;
        if (node == null) {
            n = 1;
        } else {
            int lh = this.blackHeight$1(node.left());
            int rh = this.blackHeight$1(node.right());
            n = lh == -1 || lh != rh ? -1 : (this.isRed(node) ? lh : lh + 1);
        }
        return n;
    }
}

