/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.mutable;

import java.util.NoSuchElementException;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple5;
import scala.math.Ordering;
import strawman.collection.Iterator;
import strawman.collection.mutable.RedBlackTree$;
import strawman.collection.mutable.RedBlackTree$Node$;
import strawman.collection.mutable.RedBlackTree$Tree$;

public final class RedBlackTree {
    public static <A, B, U> void foreach(Tree<A, B> tree, Function1<Tuple2<A, B>, U> function1) {
        RedBlackTree$.MODULE$.foreach(tree, function1);
    }

    public static <A> Option<A> getKey(Tree<A, ?> tree, A a, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.getKey(tree, a, ordering);
    }

    public static boolean isBlack(Node<?, ?> node) {
        return RedBlackTree$.MODULE$.isBlack(node);
    }

    public static None$ keysIterator$default$2() {
        return RedBlackTree$.MODULE$.keysIterator$default$2();
    }

    public static <A, B> Node<A, B> strawman$collection$mutable$RedBlackTree$$$successor(Node<A, B> node) {
        return RedBlackTree$.MODULE$.strawman$collection$mutable$RedBlackTree$$$successor(node);
    }

    public static int size(Tree<?, ?> tree) {
        return RedBlackTree$.MODULE$.size(tree);
    }

    public static int size(Node<?, ?> node) {
        return RedBlackTree$.MODULE$.size(node);
    }

    public static <A, B> Option<Tuple2<A, B>> minAfter(Tree<A, B> tree, A a, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.minAfter(tree, a, ordering);
    }

    public static <A> Option<A> maxKeyBefore(Tree<A, ?> tree, A a, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.maxKeyBefore(tree, a, ordering);
    }

    public static <A, B> Option<B> get(Tree<A, B> tree, A a, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.get(tree, a, ordering);
    }

    public static <A, B> Iterator<B> valuesIterator(Tree<A, B> tree, Option<A> option, Option<A> option2, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.valuesIterator(tree, option, option2, ordering);
    }

    public static <A, U> void foreachKey(Tree<A, ?> tree, Function1<A, U> function1) {
        RedBlackTree$.MODULE$.foreachKey(tree, function1);
    }

    public static <A> Option<A> maxKey(Tree<A, ?> tree) {
        return RedBlackTree$.MODULE$.maxKey(tree);
    }

    public static <A> Option<A> minKeyAfter(Tree<A, ?> tree, A a, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.minKeyAfter(tree, a, ordering);
    }

    public static None$ valuesIterator$default$3() {
        return RedBlackTree$.MODULE$.valuesIterator$default$3();
    }

    public static <A, B> Option<Tuple2<A, B>> max(Tree<A, B> tree) {
        return RedBlackTree$.MODULE$.max(tree);
    }

    public static <A, B> void transform(Tree<A, B> tree, Function2<A, B, B> function2) {
        RedBlackTree$.MODULE$.transform(tree, function2);
    }

    public static <A, B> Iterator<Tuple2<A, B>> iterator(Tree<A, B> tree, Option<A> option, Option<A> option2, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.iterator(tree, option, option2, ordering);
    }

    public static <A, B> void insert(Tree<A, B> tree, A a, B b, Ordering<A> ordering) {
        RedBlackTree$.MODULE$.insert(tree, a, b, ordering);
    }

    public static None$ valuesIterator$default$2() {
        return RedBlackTree$.MODULE$.valuesIterator$default$2();
    }

    public static <A> Option<A> minKey(Tree<A, ?> tree) {
        return RedBlackTree$.MODULE$.minKey(tree);
    }

    public static <A> Iterator<A> keysIterator(Tree<A, ?> tree, Option<A> option, Option<A> option2, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.keysIterator(tree, option, option2, ordering);
    }

    public static boolean isRed(Node<?, ?> node) {
        return RedBlackTree$.MODULE$.isRed(node);
    }

    public static <A, B> Node<A, B> maxNodeNonNull(Node<A, B> node) {
        return RedBlackTree$.MODULE$.maxNodeNonNull(node);
    }

    public static <A, B> void delete(Tree<A, B> tree, A a, Ordering<A> ordering) {
        RedBlackTree$.MODULE$.delete(tree, a, ordering);
    }

    public static <A, B> Option<Tuple2<A, B>> min(Tree<A, B> tree) {
        return RedBlackTree$.MODULE$.min(tree);
    }

    public static <A> boolean contains(Tree<A, ?> tree, A a, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.contains(tree, a, ordering);
    }

    public static <A, B> Option<Tuple2<A, B>> maxBefore(Tree<A, B> tree, A a, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.maxBefore(tree, a, ordering);
    }

    public static None$ iterator$default$3() {
        return RedBlackTree$.MODULE$.iterator$default$3();
    }

    public static void clear(Tree<?, ?> tree) {
        RedBlackTree$.MODULE$.clear(tree);
    }

    public static boolean isEmpty(Tree<?, ?> tree) {
        return RedBlackTree$.MODULE$.isEmpty(tree);
    }

    public static None$ keysIterator$default$3() {
        return RedBlackTree$.MODULE$.keysIterator$default$3();
    }

    public static <A, B> Node<A, B> minNodeNonNull(Node<A, B> node) {
        return RedBlackTree$.MODULE$.minNodeNonNull(node);
    }

    public static <A, B> Node<A, B> strawman$collection$mutable$RedBlackTree$$$minNode(Node<A, B> node) {
        return RedBlackTree$.MODULE$.strawman$collection$mutable$RedBlackTree$$$minNode(node);
    }

    public static <A, B> Node<A, B> strawman$collection$mutable$RedBlackTree$$$minNodeAfter(Node<A, B> node, A a, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.strawman$collection$mutable$RedBlackTree$$$minNodeAfter(node, a, ordering);
    }

    public static None$ iterator$default$2() {
        return RedBlackTree$.MODULE$.iterator$default$2();
    }

    public static <A, B> boolean isValid(Tree<A, B> tree, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.isValid(tree, ordering);
    }

    private static final class EntriesIterator<A, B>
    extends TreeIterator<A, B, Tuple2<A, B>> {
        public <A, B> EntriesIterator(Tree<A, B> tree, Option<A> start, Option<A> end, Ordering<A> evidence$80) {
            super(tree, start, end, evidence$80);
        }

        @Override
        public Tuple2<A, B> nextResult(Node<A, B> node) {
            return Tuple2$.MODULE$.apply(node.key(), node.value());
        }
    }

    private static final class KeysIterator<A, B>
    extends TreeIterator<A, B, A> {
        public <A, B> KeysIterator(Tree<A, B> tree, Option<A> start, Option<A> end, Ordering<A> evidence$81) {
            super(tree, start, end, evidence$81);
        }

        @Override
        public A nextResult(Node<A, B> node) {
            return node.key();
        }
    }

    public static final class Node<A, B>
    implements Serializable {
        private Object key;
        private Object value;
        private boolean red;
        private Node left;
        private Node right;
        private Node parent;

        public static <A, B> Node<A, B> leaf(A a, B b, boolean bl, Node<A, B> node) {
            return RedBlackTree$Node$.MODULE$.leaf(a, b, bl, node);
        }

        public static <A, B> Node<A, B> apply(A a, B b, boolean bl, Node<A, B> node, Node<A, B> node2, Node<A, B> node3) {
            return RedBlackTree$Node$.MODULE$.apply(a, b, bl, node, node2, node3);
        }

        public static <A, B> Some<Tuple5<A, B, Node<A, B>, Node<A, B>, Node<A, B>>> unapply(Node<A, B> node) {
            return RedBlackTree$Node$.MODULE$.unapply(node);
        }

        public <A, B> Node(A key, B value, boolean red, Node<A, B> left, Node<A, B> right, Node<A, B> parent) {
            this.key = key;
            this.value = value;
            this.red = red;
            this.left = left;
            this.right = right;
            this.parent = parent;
        }

        public A key() {
            return (A)this.key;
        }

        public void key_$eq(A x$1) {
            this.key = x$1;
        }

        public B value() {
            return (B)this.value;
        }

        public void value_$eq(B x$1) {
            this.value = x$1;
        }

        public boolean red() {
            return this.red;
        }

        public void red_$eq(boolean x$1) {
            this.red = x$1;
        }

        public Node<A, B> left() {
            return this.left;
        }

        public void left_$eq(Node<A, B> x$1) {
            this.left = x$1;
        }

        public Node<A, B> right() {
            return this.right;
        }

        public void right_$eq(Node<A, B> x$1) {
            this.right = x$1;
        }

        public Node<A, B> parent() {
            return this.parent;
        }

        public void parent_$eq(Node<A, B> x$1) {
            this.parent = x$1;
        }

        public String toString() {
            return "Node(" + this.key() + ", " + this.value() + ", " + this.red() + ", " + this.left() + ", " + this.right() + ")";
        }
    }

    public static final class Tree<A, B>
    implements Serializable {
        private Node root;
        private int size;

        public static Tree empty() {
            return RedBlackTree$Tree$.MODULE$.empty();
        }

        public <A, B> Tree(Node<A, B> root, int size) {
            this.root = root;
            this.size = size;
        }

        public Node<A, B> root() {
            return this.root;
        }

        public void root_$eq(Node<A, B> x$1) {
            this.root = x$1;
        }

        public int size() {
            return this.size;
        }

        public void size_$eq(int x$1) {
            this.size = x$1;
        }
    }

    private static abstract class TreeIterator<A, B, R>
    implements Iterator<R> {
        private final Option<A> end;
        private final Ordering<A> ord;
        private Node<A, B> nextNode;

        public <A, B, R> TreeIterator(Tree<A, B> tree, Option<A> start, Option<A> end, Ordering<A> ord) {
            Node<Object, B> node;
            this.end = end;
            this.ord = ord;
            Option<A> option = start;
            if (None$.MODULE$.equals(option)) {
                node = RedBlackTree$.MODULE$.strawman$collection$mutable$RedBlackTree$$$minNode(tree.root());
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Object from = some.value();
                node = RedBlackTree$.MODULE$.strawman$collection$mutable$RedBlackTree$$$minNodeAfter(tree.root(), from, ord);
            } else {
                throw new MatchError(option);
            }
            this.nextNode = node;
            this.setNullIfAfterEnd();
        }

        public abstract R nextResult(Node<A, B> var1);

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public R next() {
            Node<A, B> node = this.nextNode;
            if (node == null) {
                throw new NoSuchElementException("next on empty iterator");
            }
            Node<A, B> node2 = node;
            this.nextNode = RedBlackTree$.MODULE$.strawman$collection$mutable$RedBlackTree$$$successor(node2);
            this.setNullIfAfterEnd();
            return this.nextResult(node2);
        }

        private void setNullIfAfterEnd() {
            block0: {
                if (!this.end.isDefined() || this.nextNode == null || this.ord.compare(this.nextNode.key(), this.end.get()) < 0) break block0;
                this.nextNode = null;
            }
        }
    }

    private static final class ValuesIterator<A, B>
    extends TreeIterator<A, B, B> {
        public <A, B> ValuesIterator(Tree<A, B> tree, Option<A> start, Option<A> end, Ordering<A> evidence$82) {
            super(tree, start, end, evidence$82);
        }

        @Override
        public B nextResult(Node<A, B> node) {
            return node.value();
        }
    }
}

