/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.mutable;

import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.math.Ordering;
import scala.runtime.Null;
import strawman.collection.Iterable;
import strawman.collection.IterableFactoryLike;
import strawman.collection.IterableOnce;
import strawman.collection.Iterator;
import strawman.collection.Set;
import strawman.collection.SetOps;
import strawman.collection.SortedIterableFactory;
import strawman.collection.SortedSetOps;
import strawman.collection.StrictOptimizedIterableOps;
import strawman.collection.StrictOptimizedSortedSetOps;
import strawman.collection.mutable.Builder;
import strawman.collection.mutable.RedBlackTree;
import strawman.collection.mutable.RedBlackTree$;
import strawman.collection.mutable.RedBlackTree$Tree$;
import strawman.collection.mutable.Set$;
import strawman.collection.mutable.SortedSet;
import strawman.collection.mutable.TreeSet$;

public class TreeSet<A>
implements SortedSet<A>,
StrictOptimizedSortedSetOps<A, TreeSet, TreeSet<A>>,
Serializable {
    public final RedBlackTree.Tree<A, Null> strawman$collection$mutable$TreeSet$$tree;
    private final Ordering ordering;

    public static Object fill(int n, Function0 function0, Ordering ordering) {
        return TreeSet$.MODULE$.fill(n, function0, ordering);
    }

    public static <A> Builder<A, TreeSet<A>> newBuilder(Ordering<A> ordering) {
        return TreeSet$.MODULE$.newBuilder(ordering);
    }

    public <A> TreeSet(RedBlackTree.Tree<A, Null> tree, Ordering<A> ordering) {
        this.strawman$collection$mutable$TreeSet$$tree = tree;
        this.ordering = ordering;
        Function1.$init$((Function1)this);
        if (ordering == null) {
            throw new NullPointerException("ordering must not be null");
        }
    }

    public <A> Function1<A, Object> compose(Function1<A, A> g) {
        return Function1.compose$((Function1)this, g);
    }

    public <A> Function1<A, A> andThen(Function1<Object, A> g) {
        return Function1.andThen$((Function1)this, g);
    }

    @Override
    public String toString() {
        return SetOps.super.toString();
    }

    @Override
    public boolean equals(Object that) {
        return Set.super.equals(that);
    }

    @Override
    public int hashCode() {
        return Set.super.hashCode();
    }

    @Override
    public TreeSet<A> clone() {
        return (TreeSet)strawman.collection.mutable.SetOps.super.clone();
    }

    @Override
    public SortedSetOps.SortedWithFilter withFilter(Function1<A, Object> p) {
        return SortedSetOps.super.withFilter(p);
    }

    @Override
    public Tuple2<TreeSet<A>, TreeSet<A>> partition(Function1<A, Object> p) {
        return StrictOptimizedIterableOps.super.partition(p);
    }

    @Override
    public Tuple2<TreeSet<A>, TreeSet<A>> span(Function1<A, Object> p) {
        return StrictOptimizedIterableOps.super.span(p);
    }

    @Override
    public <A1, A2> Tuple2<strawman.collection.mutable.Set<A1>, strawman.collection.mutable.Set<A2>> unzip(Predef$.less.colon.less<A, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.super.unzip(asPair);
    }

    @Override
    public <B> strawman.collection.mutable.Set<B> map(Function1<A, B> f) {
        return (strawman.collection.mutable.Set)StrictOptimizedIterableOps.super.map(f);
    }

    @Override
    public <B> strawman.collection.mutable.Set<B> flatMap(Function1<A, IterableOnce<B>> f) {
        return (strawman.collection.mutable.Set)StrictOptimizedIterableOps.super.flatMap(f);
    }

    @Override
    public <B> strawman.collection.mutable.Set<B> collect(PartialFunction<A, B> pf) {
        return (strawman.collection.mutable.Set)StrictOptimizedIterableOps.super.collect(pf);
    }

    @Override
    public <B> strawman.collection.mutable.Set<B> flatten(Function1<A, IterableOnce<B>> toIterableOnce) {
        return (strawman.collection.mutable.Set)StrictOptimizedIterableOps.super.flatten(toIterableOnce);
    }

    @Override
    public <B> strawman.collection.mutable.Set<Tuple2<A, B>> zip(Iterable<B> that) {
        return (strawman.collection.mutable.Set)StrictOptimizedIterableOps.super.zip(that);
    }

    @Override
    public strawman.collection.mutable.Set<Tuple2<A, Object>> zipWithIndex() {
        return (strawman.collection.mutable.Set)StrictOptimizedIterableOps.super.zipWithIndex();
    }

    @Override
    public <B> strawman.collection.mutable.Set<B> scanLeft(B z, Function2<B, A, B> op) {
        return (strawman.collection.mutable.Set)StrictOptimizedIterableOps.super.scanLeft(z, op);
    }

    @Override
    public TreeSet<A> filter(Function1<A, Object> pred) {
        return (TreeSet)StrictOptimizedIterableOps.super.filter(pred);
    }

    @Override
    public TreeSet<A> filterNot(Function1<A, Object> pred) {
        return (TreeSet)StrictOptimizedIterableOps.super.filterNot(pred);
    }

    @Override
    public <B> TreeSet<B> map(Function1<A, B> f, Ordering<B> evidence$64) {
        return (TreeSet)StrictOptimizedSortedSetOps.super.map(f, evidence$64);
    }

    @Override
    public <B> TreeSet<B> flatMap(Function1<A, IterableOnce<B>> f, Ordering<B> evidence$65) {
        return (TreeSet)StrictOptimizedSortedSetOps.super.flatMap(f, evidence$65);
    }

    @Override
    public <B> TreeSet<Tuple2<A, B>> zip(Iterable<B> that, Ordering<Tuple2<A, B>> ev) {
        return (TreeSet)StrictOptimizedSortedSetOps.super.zip(that, ev);
    }

    @Override
    public <B> TreeSet<B> collect(PartialFunction<A, B> pf, Ordering<B> evidence$66) {
        return (TreeSet)StrictOptimizedSortedSetOps.super.collect(pf, evidence$66);
    }

    @Override
    public Ordering<A> ordering() {
        return this.ordering;
    }

    public <A> TreeSet(Ordering<A> ord) {
        this(RedBlackTree$Tree$.MODULE$.empty(), ord);
    }

    @Override
    public Iterator<A> iterator() {
        return RedBlackTree$.MODULE$.keysIterator(this.strawman$collection$mutable$TreeSet$$tree, RedBlackTree$.MODULE$.keysIterator$default$2(), RedBlackTree$.MODULE$.keysIterator$default$3(), this.ordering());
    }

    @Override
    public <B> TreeSet<B> sortedFromIterable(Iterable<B> it, Ordering<B> evidence$90) {
        return TreeSet$.MODULE$.from(it, (Ordering)evidence$90);
    }

    @Override
    public TreeSet<A> fromSpecificIterable(Iterable<A> coll) {
        return TreeSet$.MODULE$.from(coll, (Ordering)this.ordering());
    }

    @Override
    public Builder<A, TreeSet<A>> newSpecificBuilder() {
        return TreeSet$.MODULE$.newBuilder(this.ordering());
    }

    @Override
    public IterableFactoryLike<strawman.collection.mutable.Set> iterableFactory() {
        return Set$.MODULE$;
    }

    @Override
    public SortedIterableFactory<TreeSet> sortedIterableFactory() {
        return TreeSet$.MODULE$;
    }

    @Override
    public Iterator<A> iteratorFrom(A start) {
        return RedBlackTree$.MODULE$.keysIterator(this.strawman$collection$mutable$TreeSet$$tree, Some$.MODULE$.apply(start), RedBlackTree$.MODULE$.keysIterator$default$3(), this.ordering());
    }

    @Override
    public TreeSet<A> empty() {
        return TreeSet$.MODULE$.empty((Ordering)this.ordering());
    }

    @Override
    public TreeSet add(A elem) {
        RedBlackTree$.MODULE$.insert(this.strawman$collection$mutable$TreeSet$$tree, elem, null, this.ordering());
        return this;
    }

    @Override
    public TreeSet subtract(A elem) {
        RedBlackTree$.MODULE$.delete(this.strawman$collection$mutable$TreeSet$$tree, elem, this.ordering());
        return this;
    }

    @Override
    public void clear() {
        RedBlackTree$.MODULE$.clear(this.strawman$collection$mutable$TreeSet$$tree);
    }

    @Override
    public boolean contains(A elem) {
        return RedBlackTree$.MODULE$.contains(this.strawman$collection$mutable$TreeSet$$tree, elem, this.ordering());
    }

    @Override
    public Option<A> get(A elem) {
        return RedBlackTree$.MODULE$.getKey(this.strawman$collection$mutable$TreeSet$$tree, elem, this.ordering());
    }

    public Set<A> unconstrained() {
        return this;
    }

    @Override
    public TreeSet<A> rangeImpl(Option<A> from, Option<A> until) {
        return new TreeSetProjection(this, from, until);
    }

    @Override
    public String className() {
        return "TreeSet";
    }

    @Override
    public int size() {
        return RedBlackTree$.MODULE$.size(this.strawman$collection$mutable$TreeSet$$tree);
    }

    @Override
    public boolean isEmpty() {
        return RedBlackTree$.MODULE$.isEmpty(this.strawman$collection$mutable$TreeSet$$tree);
    }

    @Override
    public A head() {
        return (A)RedBlackTree$.MODULE$.minKey(this.strawman$collection$mutable$TreeSet$$tree).get();
    }

    @Override
    public A last() {
        return (A)RedBlackTree$.MODULE$.maxKey(this.strawman$collection$mutable$TreeSet$$tree).get();
    }

    @Override
    public Option<A> minAfter(A key) {
        return RedBlackTree$.MODULE$.minKeyAfter(this.strawman$collection$mutable$TreeSet$$tree, key, this.ordering());
    }

    @Override
    public Option<A> maxBefore(A key) {
        return RedBlackTree$.MODULE$.maxKeyBefore(this.strawman$collection$mutable$TreeSet$$tree, key, this.ordering());
    }

    @Override
    public <U> void foreach(Function1<A, U> f) {
        RedBlackTree$.MODULE$.foreachKey(this.strawman$collection$mutable$TreeSet$$tree, f);
    }

    public RedBlackTree.Tree strawman$collection$mutable$TreeSet$$TreeSetProjection$superArg$1(Option<A> from, Option<A> until) {
        return this.strawman$collection$mutable$TreeSet$$tree;
    }

    public Ordering strawman$collection$mutable$TreeSet$$TreeSetProjection$superArg$2(Option<A> from, Option<A> until) {
        return this.ordering();
    }

    private static final class TreeSetProjection
    extends TreeSet<A> {
        private final Option<A> from;
        private final Option<A> until;
        private final TreeSet $outer;

        public TreeSetProjection(TreeSet $outer, Option<A> from, Option<A> until) {
            this.from = from;
            this.until = until;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer.strawman$collection$mutable$TreeSet$$TreeSetProjection$superArg$1(from, until), $outer.strawman$collection$mutable$TreeSet$$TreeSetProjection$superArg$2(from, until));
        }

        /*
         * Enabled aggressive block sorting
         */
        private Option<A> pickLowerBound(Option<A> newFrom) {
            Some some;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(this.from, newFrom);
            if (tuple2 != null) {
                Option option;
                Option option2 = (Option)tuple2._1();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Object fr = some2.value();
                    Option option3 = (Option)tuple2._2();
                    if (option3 instanceof Some) {
                        Some some3 = (Some)option3;
                        Object newFr = some3.value();
                        some = Some$.MODULE$.apply(this.ordering().max(fr, newFr));
                        return some;
                    }
                    option = option2;
                } else {
                    option = option2;
                }
                if (None$.MODULE$.equals(option)) {
                    some = newFrom;
                    return some;
                }
            }
            some = this.from;
            return some;
        }

        /*
         * Enabled aggressive block sorting
         */
        private Option<A> pickUpperBound(Option<A> newUntil) {
            Some some;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(this.until, newUntil);
            if (tuple2 != null) {
                Option option;
                Option option2 = (Option)tuple2._1();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Object unt = some2.value();
                    Option option3 = (Option)tuple2._2();
                    if (option3 instanceof Some) {
                        Some some3 = (Some)option3;
                        Object newUnt = some3.value();
                        some = Some$.MODULE$.apply(this.ordering().min(unt, newUnt));
                        return some;
                    }
                    option = option2;
                } else {
                    option = option2;
                }
                if (None$.MODULE$.equals(option)) {
                    some = newUntil;
                    return some;
                }
            }
            some = this.until;
            return some;
        }

        private boolean isInsideViewBounds(A key) {
            boolean afterFrom = this.from.isEmpty() || this.ordering().compare(this.from.get(), key) <= 0;
            boolean beforeUntil = this.until.isEmpty() || this.ordering().compare(key, this.until.get()) < 0;
            return afterFrom && beforeUntil;
        }

        @Override
        public TreeSet<A> rangeImpl(Option<A> from, Option<A> until) {
            return new TreeSetProjection(this.strawman$collection$mutable$TreeSet$TreeSetProjection$$$outer(), this.pickLowerBound(from), this.pickUpperBound(until));
        }

        @Override
        public boolean contains(A key) {
            return this.isInsideViewBounds(key) && RedBlackTree$.MODULE$.contains(this.strawman$collection$mutable$TreeSet$TreeSetProjection$$$outer().strawman$collection$mutable$TreeSet$$tree, key, this.ordering());
        }

        @Override
        public Iterator<A> iterator() {
            return RedBlackTree$.MODULE$.keysIterator(this.strawman$collection$mutable$TreeSet$TreeSetProjection$$$outer().strawman$collection$mutable$TreeSet$$tree, this.from, this.until, this.ordering());
        }

        @Override
        public Iterator<A> iteratorFrom(A start) {
            return RedBlackTree$.MODULE$.keysIterator(this.strawman$collection$mutable$TreeSet$TreeSetProjection$$$outer().strawman$collection$mutable$TreeSet$$tree, this.pickLowerBound((Option)Some$.MODULE$.apply(start)), this.until, this.ordering());
        }

        @Override
        public int size() {
            return this.iterator().length();
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public A head() {
            return this.headOption().get();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Option<A> headOption() {
            None$ none$;
            Option option;
            Object object = this.from.isDefined() ? RedBlackTree$.MODULE$.minKeyAfter(this.strawman$collection$mutable$TreeSet$TreeSetProjection$$$outer().strawman$collection$mutable$TreeSet$$tree, this.from.get(), this.ordering()) : RedBlackTree$.MODULE$.minKey(this.strawman$collection$mutable$TreeSet$TreeSetProjection$$$outer().strawman$collection$mutable$TreeSet$$tree);
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(object, this.until);
            if (tuple2 != null && (option = (Option)tuple2._1()) instanceof Some) {
                Some some = (Some)option;
                Object e = some.value();
                Option option2 = (Option)tuple2._2();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Object unt = some2.value();
                    if (this.ordering().compare(e, unt) >= 0) {
                        none$ = None$.MODULE$;
                        return none$;
                    }
                }
            }
            none$ = object;
            return none$;
        }

        @Override
        public A last() {
            return this.lastOption().get();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Option<A> lastOption() {
            None$ none$;
            Option option;
            Object object = this.until.isDefined() ? RedBlackTree$.MODULE$.maxKeyBefore(this.strawman$collection$mutable$TreeSet$TreeSetProjection$$$outer().strawman$collection$mutable$TreeSet$$tree, this.until.get(), this.ordering()) : RedBlackTree$.MODULE$.maxKey(this.strawman$collection$mutable$TreeSet$TreeSetProjection$$$outer().strawman$collection$mutable$TreeSet$$tree);
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(object, this.from);
            if (tuple2 != null && (option = (Option)tuple2._1()) instanceof Some) {
                Some some = (Some)option;
                Object e = some.value();
                Option option2 = (Option)tuple2._2();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Object fr = some2.value();
                    if (this.ordering().compare(e, fr) < 0) {
                        none$ = None$.MODULE$;
                        return none$;
                    }
                }
            }
            none$ = object;
            return none$;
        }

        @Override
        public <U> void foreach(Function1<A, U> f) {
            this.iterator().foreach(f);
        }

        @Override
        public TreeSet<A> clone() {
            return ((TreeSet)strawman.collection.mutable.SetOps.super.clone()).rangeImpl(this.from, this.until);
        }

        private TreeSet<A> $outer() {
            return this.$outer;
        }

        public final TreeSet<A> strawman$collection$mutable$TreeSet$TreeSetProjection$$$outer() {
            return this.$outer();
        }
    }
}

