/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection;

import java.util.NoSuchElementException;
import scala.Function0;
import scala.Function1;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing;
import scala.runtime.Nothing$;
import strawman.collection.AbstractIterator;
import strawman.collection.IndexedView;
import strawman.collection.Iterable;
import strawman.collection.IterableOps;
import strawman.collection.Iterator;
import strawman.collection.SeqOps;
import strawman.collection.View;

public final class Iterator$ {
    public static final Iterator$ MODULE$;
    private final Iterator empty;

    static {
        new Iterator$();
    }

    public Iterator$() {
        MODULE$ = this;
        this.empty = new Iterator<Nothing>(){

            public boolean hasNext() {
                return false;
            }

            public Nothing$ next() {
                throw new NoSuchElementException("next on empty iterator");
            }
        };
    }

    public Iterator<Nothing> empty() {
        return this.empty;
    }

    public <A> Iterator<A> single(A a) {
        return new Iterator<A>(a){
            private boolean consumed;
            private final Object a$1;
            {
                this.a$1 = a$2;
                this.consumed = false;
            }

            private boolean consumed() {
                return this.consumed;
            }

            private void consumed_$eq(boolean x$1) {
                this.consumed = x$1;
            }

            public boolean hasNext() {
                return !this.consumed();
            }

            public A next() {
                Object object;
                if (this.consumed()) {
                    object = Iterator$.MODULE$.empty().next();
                } else {
                    this.consumed_$eq(true);
                    object = this.a$1;
                }
                return (A)object;
            }
        };
    }

    public <A> Iterator<A> apply(Seq<A> xs) {
        return new IndexedView<A>(xs){
            private final int length;
            private final Seq xs$1;
            {
                this.xs$1 = xs$6;
                this.length = xs$6.length();
            }

            public View<A> view() {
                return View.super.view();
            }

            public String toString() {
                return View.super.toString();
            }

            public String className() {
                return View.super.className();
            }

            public /* synthetic */ View strawman$collection$SeqOps$$super$concat(Iterable suffix) {
                return (View)IterableOps.super.concat(suffix);
            }

            public final <B> View<B> concat(Iterable<B> suffix) {
                return (View)SeqOps.super.concat(suffix);
            }

            public final int size() {
                return SeqOps.super.size();
            }

            public boolean isEmpty() {
                return SeqOps.super.isEmpty();
            }

            public boolean nonEmpty() {
                return SeqOps.super.nonEmpty();
            }

            public int knownSize() {
                return IndexedView.super.knownSize();
            }

            public IndexedView<A> take(int n) {
                return IndexedView.super.take(n);
            }

            public IndexedView<A> takeRight(int n) {
                return IndexedView.super.takeRight(n);
            }

            public IndexedView<A> drop(int n) {
                return IndexedView.super.drop(n);
            }

            public IndexedView<A> dropRight(int n) {
                return IndexedView.super.dropRight(n);
            }

            public <B> IndexedView<B> map(Function1<A, B> f) {
                return IndexedView.super.map(f);
            }

            public IndexedView<A> reverse() {
                return IndexedView.super.reverse();
            }

            public int length() {
                return this.length;
            }

            public A apply(int n) {
                return (A)this.xs$1.apply(n);
            }
        }.iterator();
    }

    public <A> Iterator<A> fill(int len, Function0<A> elem) {
        return new AbstractIterator<A>(len, elem){
            private int i;
            private final int len$1;
            private final Function0 elem$1;
            {
                this.len$1 = len$2;
                this.elem$1 = elem$8;
                this.i = 0;
            }

            private int i() {
                return this.i;
            }

            private void i_$eq(int x$1) {
                this.i = x$1;
            }

            public boolean hasNext() {
                return this.i() < this.len$1;
            }

            public A next() {
                Object object;
                if (this.hasNext()) {
                    this.i_$eq(this.i() + 1);
                    object = this.elem$1.apply();
                } else {
                    object = Iterator$.MODULE$.empty().next();
                }
                return (A)object;
            }
        };
    }

    public <A> Iterator<A> tabulate(int end, Function1<Object, A> f) {
        return new AbstractIterator<A>(end, f){
            private int i;
            private final int end$1;
            private final Function1 f$1;
            {
                this.end$1 = end$4;
                this.f$1 = f$30;
                this.i = 0;
            }

            private int i() {
                return this.i;
            }

            private void i_$eq(int x$1) {
                this.i = x$1;
            }

            public boolean hasNext() {
                return this.i() < this.end$1;
            }

            /*
             * WARNING - void declaration
             */
            public A next() {
                Nothing nothing;
                if (this.hasNext()) {
                    void var1_1;
                    Object result = this.f$1.apply((Object)BoxesRunTime.boxToInteger((int)this.i()));
                    this.i_$eq(this.i() + 1);
                    nothing = var1_1;
                } else {
                    nothing = Iterator$.MODULE$.empty().next();
                }
                return (A)nothing;
            }
        };
    }

    public Iterator<Object> from(int start) {
        return this.from(start, 1);
    }

    public Iterator<Object> from(int start, int step) {
        return new Iterator<Object>(start, step){
            private int i;
            private final int step$1;
            {
                this.step$1 = step$2;
                this.i = start$2;
            }

            private int i() {
                return this.i;
            }

            private void i_$eq(int x$1) {
                this.i = x$1;
            }

            public boolean hasNext() {
                return true;
            }

            /*
             * WARNING - void declaration
             */
            public int next() {
                void var1_1;
                int result = this.i();
                this.i_$eq(this.i() + this.step$1);
                return (int)var1_1;
            }
        };
    }

    public Iterator<Object> range(int start, int end) {
        return this.range(start, end, 1);
    }

    public Iterator<Object> range(int start, int end, int step) {
        return new Iterator<Object>(start, end, step){
            private int i;
            private final int end$1;
            private final int step$1;
            {
                this.end$1 = end$2;
                this.step$1 = step$4;
                if (step$4 == 0) {
                    throw new IllegalArgumentException("zero step");
                }
                this.i = start$3;
            }

            private int i() {
                return this.i;
            }

            private void i_$eq(int x$1) {
                this.i = x$1;
            }

            public boolean hasNext() {
                return !(this.step$1 > 0 && this.i() >= this.end$1 || this.step$1 < 0 && this.i() <= this.end$1);
            }

            /*
             * WARNING - void declaration
             */
            public int next() {
                int n;
                if (this.hasNext()) {
                    void var1_1;
                    int result = this.i();
                    this.i_$eq(this.i() + this.step$1);
                    n = var1_1;
                } else {
                    n = BoxesRunTime.unboxToInt((Object)Iterator$.MODULE$.empty().next());
                }
                return n;
            }
        };
    }

    public <T> Iterator<T> iterate(T start, Function1<T, T> f) {
        return new Iterator<T>(start, f){
            private boolean first;
            private T acc;
            private final Function1 f$1;
            {
                this.f$1 = f$25;
                this.first = true;
                this.acc = start$4;
            }

            public boolean hasNext() {
                return true;
            }

            public T next() {
                if (this.first) {
                    this.first = false;
                } else {
                    this.acc = this.f$1.apply(this.acc);
                }
                return this.acc;
            }
        };
    }

    public <A> Iterator<A> continually(Function0<A> elem) {
        return new Iterator<A>(elem){
            private final Function0 elem$1;
            {
                this.elem$1 = elem$9;
            }

            public boolean hasNext() {
                return true;
            }

            public A next() {
                return (A)this.elem$1.apply();
            }
        };
    }
}

