/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection;

import dotty.runtime.LazyBoolean;
import dotty.runtime.LazyInt;
import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some$;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.compat.java8.JFunction1;
import scala.compat.java8.JProcedure1;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.AbstractFunction1;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import strawman.collection.AbstractIterator;
import strawman.collection.BufferedIterator;
import strawman.collection.Factory;
import strawman.collection.Iterable;
import strawman.collection.IterableOnce;
import strawman.collection.Iterator$;
import strawman.collection.Seq;
import strawman.collection.immutable.ImmutableArray;
import strawman.collection.immutable.ImmutableArray$;
import strawman.collection.immutable.List;
import strawman.collection.immutable.Nil$;
import strawman.collection.mutable.ArrayBuffer;
import strawman.collection.mutable.ArrayBuffer$;
import strawman.collection.mutable.HashSet;
import strawman.collection.mutable.HashSet$;
import strawman.collection.mutable.StringBuilder;

public interface Iterator<A>
extends IterableOnce<A> {
    public boolean hasNext();

    public A next();

    @Override
    default public Iterator<A> iterator() {
        return this;
    }

    @Override
    default public int knownSize() {
        return -1;
    }

    default public boolean isEmpty() {
        return !this.hasNext();
    }

    default public boolean nonEmpty() {
        return this.hasNext();
    }

    default public Option<A> nextOption() {
        return this.hasNext() ? Some$.MODULE$.apply(this.next()) : None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    default public boolean forall(Function1<A, Object> p) {
        void var2_2;
        boolean res = true;
        while (res && this.hasNext()) {
            res = BoxesRunTime.unboxToBoolean((Object)p.apply(this.next()));
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    default public boolean exists(Function1<A, Object> p) {
        void var2_2;
        boolean res = false;
        while (!res && this.hasNext()) {
            res = BoxesRunTime.unboxToBoolean((Object)p.apply(this.next()));
        }
        return (boolean)var2_2;
    }

    default public boolean contains(Object elem) {
        return this.exists((Function1<A, Object>)((JFunction1)arg_0 -> Iterator.contains$$anonfun$1(elem, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    default public int count(Function1<A, Object> p) {
        void var2_2;
        int res = 0;
        while (this.hasNext()) {
            if (!BoxesRunTime.unboxToBoolean((Object)p.apply(this.next()))) continue;
            ++res;
        }
        return (int)var2_2;
    }

    default public Option<A> find(Function1<A, Object> p) {
        while (this.hasNext()) {
            A a = this.next();
            if (!BoxesRunTime.unboxToBoolean((Object)p.apply(a))) continue;
            return Some$.MODULE$.apply(a);
        }
        return None$.MODULE$;
    }

    default public <B> Option<B> collectFirst(PartialFunction<A, B> pf) {
        AbstractFunction1 sentinel = new AbstractFunction1<A, Object>(){

            public Object apply(A a) {
                return this;
            }
        };
        while (this.hasNext()) {
            Object x = pf.applyOrElse(this.next(), (Function1)sentinel);
            if (x == sentinel) continue;
            return Some$.MODULE$.apply(x);
        }
        return None$.MODULE$;
    }

    default public BufferedIterator<A> buffered() {
        return new BufferedIterator<A>(this){
            private Object hd;
            private boolean hdDefined;
            private final Iterator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.hdDefined = false;
            }

            public $anon$2 buffered() {
                return BufferedIterator.super.buffered();
            }

            private A hd() {
                return (A)this.hd;
            }

            private void hd_$eq(A x$1) {
                this.hd = x$1;
            }

            private boolean hdDefined() {
                return this.hdDefined;
            }

            private void hdDefined_$eq(boolean x$1) {
                this.hdDefined = x$1;
            }

            public A head() {
                block0: {
                    if (this.hdDefined()) break block0;
                    this.hd_$eq(this.next());
                    this.hdDefined_$eq(true);
                }
                return this.hd();
            }

            public boolean hasNext() {
                return this.hdDefined() || this.strawman$collection$Iterator$_$$anon$$$outer().hasNext();
            }

            public A next() {
                A a;
                if (this.hdDefined()) {
                    this.hdDefined_$eq(false);
                    a = this.hd();
                } else {
                    a = this.strawman$collection$Iterator$_$$anon$$$outer().next();
                }
                return a;
            }

            private Iterator<A> $outer() {
                return this.$outer;
            }

            public final Iterator<A> strawman$collection$Iterator$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    default public <B> GroupedIterator<B> grouped(int size) {
        return new GroupedIterator(this, this, size, size);
    }

    default public <B> GroupedIterator<B> sliding(int size, int step) {
        return new GroupedIterator(this, this, size, step);
    }

    default public <B> int sliding$default$2() {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    default public <B> B foldLeft(B z, Function2<B, A, B> op) {
        void var3_3;
        Object result = z;
        while (this.hasNext()) {
            result = op.apply(result, this.next());
        }
        return var3_3;
    }

    default public <B> B foldRight(B z, Function2<A, B, B> op) {
        List reversed = Nil$.MODULE$;
        while (this.hasNext()) {
            A a = this.next();
            reversed = reversed.$colon$colon(a);
        }
        return reversed.foldLeft(z, (arg_0, arg_1) -> Iterator.foldRight$$anonfun$1(op, arg_0, arg_1));
    }

    default public <B> Iterator<B> scanLeft(B z, Function2<B, A, B> op) {
        return new Iterator<B>(z, op, this){
            private Iterator current;
            private final Iterator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.current = new Iterator<B>(z$1, op$3, this){
                    private final $anon$3 $outer;
                    private final Object z$1;
                    public final Function2 strawman$collection$Iterator$$anon$16$$op$1;
                    {
                        this.z$1 = z$4;
                        this.strawman$collection$Iterator$$anon$16$$op$1 = op$6;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public boolean hasNext() {
                        return true;
                    }

                    public B next() {
                        this.strawman$collection$Iterator$_$$anon$_$$anon$$$outer().strawman$collection$Iterator$$anon$3$$current_$eq(new Iterator<B>(this.z$1, this){
                            private Object acc;
                            private final $anon$16 $outer;
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.acc = z$3;
                            }

                            private B acc() {
                                return (B)this.acc;
                            }

                            private void acc_$eq(B x$1) {
                                this.acc = x$1;
                            }

                            public B next() {
                                this.acc_$eq(this.strawman$collection$Iterator$_$$anon$_$$anon$_$$anon$$$outer().strawman$collection$Iterator$$anon$16$$op$1.apply(this.acc(), this.strawman$collection$Iterator$_$$anon$_$$anon$_$$anon$$$outer().strawman$collection$Iterator$_$$anon$_$$anon$$$outer().strawman$collection$Iterator$_$$anon$$$outer().next()));
                                return this.acc();
                            }

                            public boolean hasNext() {
                                return this.strawman$collection$Iterator$_$$anon$_$$anon$_$$anon$$$outer().strawman$collection$Iterator$_$$anon$_$$anon$$$outer().strawman$collection$Iterator$_$$anon$$$outer().hasNext();
                            }

                            private $anon$16 $outer() {
                                return this.$outer;
                            }

                            public final $anon$16 strawman$collection$Iterator$_$$anon$_$$anon$_$$anon$$$outer() {
                                return this.$outer();
                            }
                        });
                        return (B)this.z$1;
                    }

                    private $anon$3 $outer() {
                        return this.$outer;
                    }

                    public final $anon$3 strawman$collection$Iterator$_$$anon$_$$anon$$$outer() {
                        return this.$outer();
                    }
                };
            }

            private Iterator<B> current() {
                return this.current;
            }

            public void strawman$collection$Iterator$$anon$3$$current_$eq(Iterator<B> x$1) {
                this.current = x$1;
            }

            public B next() {
                return this.current().next();
            }

            public boolean hasNext() {
                return this.current().hasNext();
            }

            private Iterator<A> $outer() {
                return this.$outer;
            }

            public final Iterator<A> strawman$collection$Iterator$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    default public <U> void foreach(Function1<A, U> f) {
        while (this.hasNext()) {
            f.apply(this.next());
        }
    }

    default public int indexWhere(Function1<A, Object> p, int from) {
        int i = package$.MODULE$.max(from, 0);
        this.drop(from);
        while (this.hasNext()) {
            if (BoxesRunTime.unboxToBoolean((Object)p.apply(this.next()))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    default public int indexWhere$default$2() {
        return 0;
    }

    default public <B> int indexOf(B elem) {
        return this.indexOf(elem, 0);
    }

    default public <B> int indexOf(B elem, int from) {
        int i;
        for (i = 0; i < from && this.hasNext(); ++i) {
            this.next();
        }
        while (this.hasNext()) {
            if (BoxesRunTime.equals(this.next(), elem)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    default public <B> B reduce(Function2<B, B, B> op) {
        return this.reduceLeft(op);
    }

    default public <B> Option<B> reduceOption(Function2<B, B, B> op) {
        return this.reduceLeftOption(op);
    }

    /*
     * WARNING - void declaration
     */
    default public <B> B reduceLeft(Function2<B, A, B> op) {
        void var3_3;
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("empty.reduceLeft");
        }
        boolean first = true;
        Object acc = BoxesRunTime.boxToInteger((int)0);
        while (this.hasNext()) {
            A x = this.next();
            if (first) {
                acc = x;
                first = false;
                continue;
            }
            acc = op.apply(acc, x);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    default public Iterable<A> reversed() {
        void var1_1;
        List xs = Nil$.MODULE$;
        Iterator<A> it = this.iterator();
        while (it.hasNext()) {
            A a = it.next();
            xs = xs.$colon$colon(a);
        }
        return var1_1;
    }

    default public <B> B reduceRight(Function2<A, B, B> op) {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("empty.reduceRight");
        }
        return this.reversed().reduceLeft((arg_0, arg_1) -> Iterator.reduceRight$$anonfun$1(op, arg_0, arg_1));
    }

    default public <B> Option<B> reduceLeftOption(Function2<B, A, B> op) {
        return this.isEmpty() ? None$.MODULE$ : Some$.MODULE$.apply(this.reduceLeft(op));
    }

    default public <B> Option<B> reduceRightOption(Function2<A, B, B> op) {
        return this.isEmpty() ? None$.MODULE$ : Some$.MODULE$.apply(this.reduceRight(op));
    }

    default public <B> B sum(Numeric<B> num) {
        return (B)this.foldLeft(num.zero(), (arg_0, arg_1) -> Iterator.sum$$anonfun$1(num, arg_0, arg_1));
    }

    default public <B> B product(Numeric<B> num) {
        return (B)this.foldLeft(num.one(), (arg_0, arg_1) -> Iterator.product$$anonfun$1(num, arg_0, arg_1));
    }

    default public <B> A min(Ordering<B> ord) {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("empty.min");
        }
        return (A)this.reduceLeft((arg_0, arg_1) -> Iterator.min$$anonfun$1(ord, arg_0, arg_1));
    }

    default public <B> A max(Ordering<B> ord) {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("empty.max");
        }
        return (A)this.reduceLeft((arg_0, arg_1) -> Iterator.max$$anonfun$1(ord, arg_0, arg_1));
    }

    default public <B> A maxBy(Function1<A, B> f, Ordering<B> cmp) {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("empty.maxBy");
        }
        ObjectRef maxF = ObjectRef.create(null);
        ObjectRef maxElem = ObjectRef.create(null);
        BooleanRef first = BooleanRef.create((boolean)true);
        this.foreach((Function1)((JProcedure1)arg_0 -> Iterator.maxBy$$anonfun$1(f, cmp, maxF, maxElem, first, arg_0)));
        return (A)maxElem.elem;
    }

    default public <B> A minBy(Function1<A, B> f, Ordering<B> cmp) {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("empty.minBy");
        }
        ObjectRef minF = ObjectRef.create(null);
        ObjectRef minElem = ObjectRef.create(null);
        BooleanRef first = BooleanRef.create((boolean)true);
        this.foreach((Function1)((JProcedure1)arg_0 -> Iterator.minBy$$anonfun$1(f, cmp, minF, minElem, first, arg_0)));
        return (A)minElem.elem;
    }

    /*
     * WARNING - void declaration
     */
    default public int length() {
        void var1_1;
        int len = 0;
        while (this.hasNext()) {
            ++len;
            this.next();
        }
        return (int)var1_1;
    }

    default public int size() {
        return this.length();
    }

    default public Iterator<A> filter(Function1<A, Object> p) {
        return this.filterImpl(p, false);
    }

    default public Iterator<A> filterNot(Function1<A, Object> p) {
        return this.filterImpl(p, true);
    }

    default public Iterator<A> filterImpl(Function1<A, Object> p, boolean isFlipped) {
        return new Iterator<A>(p, isFlipped, this){
            private Object hd;
            private boolean hdDefined;
            private final Iterator $outer;
            private final Function1 p$1;
            private final boolean isFlipped$1;
            {
                this.p$1 = p$4;
                this.isFlipped$1 = isFlipped$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.hdDefined = false;
            }

            private A hd() {
                return (A)this.hd;
            }

            private void hd_$eq(A x$1) {
                this.hd = x$1;
            }

            private boolean hdDefined() {
                return this.hdDefined;
            }

            private void hdDefined_$eq(boolean x$1) {
                this.hdDefined = x$1;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean hasNext() {
                if (this.hdDefined()) return true;
                do {
                    if (!this.strawman$collection$Iterator$_$$anon$$$outer().hasNext()) {
                        return false;
                    }
                    this.hd_$eq(this.strawman$collection$Iterator$_$$anon$$$outer().next());
                } while (BoxesRunTime.unboxToBoolean((Object)this.p$1.apply(this.hd())) == this.isFlipped$1);
                this.hdDefined_$eq(true);
                if (!true) return false;
                return true;
            }

            public A next() {
                Object object;
                if (this.hasNext()) {
                    this.hdDefined_$eq(false);
                    object = this.hd();
                } else {
                    object = Iterator$.MODULE$.empty().next();
                }
                return (A)object;
            }

            private Iterator<A> $outer() {
                return this.$outer;
            }

            public final Iterator<A> strawman$collection$Iterator$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    default public Iterator<A> withFilter(Function1<A, Object> p) {
        return this.filter(p);
    }

    default public <B> Iterator<B> collect(PartialFunction<A, B> pf) {
        return new Iterator<B>(pf, this){
            private A hd;
            private int status;
            private final Iterator $outer;
            private final PartialFunction pf$1;
            {
                this.pf$1 = pf$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.status = 0;
            }

            public boolean hasNext() {
                while (this.status == 0) {
                    if (this.strawman$collection$Iterator$_$$anon$$$outer().hasNext()) {
                        this.hd = this.strawman$collection$Iterator$_$$anon$$$outer().next();
                        if (!this.pf$1.isDefinedAt(this.hd)) continue;
                        this.status = 1;
                        continue;
                    }
                    this.status = -1;
                }
                return this.status == 1;
            }

            public B next() {
                Object object;
                if (this.hasNext()) {
                    this.status = 0;
                    object = this.pf$1.apply(this.hd);
                } else {
                    object = Iterator$.MODULE$.empty().next();
                }
                return (B)object;
            }

            private Iterator<A> $outer() {
                return this.$outer;
            }

            public final Iterator<A> strawman$collection$Iterator$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    default public Iterator<A> distinct() {
        return this.distinctBy(Iterator::distinct$$anonfun$1);
    }

    default public <B> Iterator<A> distinctBy(Function1<A, B> f) {
        return new Iterator<A>(f, this){
            private final HashSet traversedValues;
            private boolean nextElementDefined;
            private Object nextElement;
            private final Iterator $outer;
            private final Function1 f$1;
            {
                this.f$1 = f$27;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.traversedValues = HashSet$.MODULE$.empty();
                this.nextElementDefined = false;
            }

            private HashSet<B> traversedValues() {
                return this.traversedValues;
            }

            private boolean nextElementDefined() {
                return this.nextElementDefined;
            }

            private void nextElementDefined_$eq(boolean x$1) {
                this.nextElementDefined = x$1;
            }

            private A nextElement() {
                return (A)this.nextElement;
            }

            private void nextElement_$eq(A x$1) {
                this.nextElement = x$1;
            }

            public boolean hasNext() {
                return this.nextElementDefined() || this.loop$1();
            }

            public A next() {
                Object object;
                if (this.hasNext()) {
                    this.nextElementDefined_$eq(false);
                    object = this.nextElement();
                } else {
                    object = Iterator$.MODULE$.empty().next();
                }
                return (A)object;
            }

            private Iterator<A> $outer() {
                return this.$outer;
            }

            public final Iterator<A> strawman$collection$Iterator$_$$anon$$$outer() {
                return this.$outer();
            }

            private boolean loop$1() {
                boolean bl;
                block2: {
                    Object y;
                    do {
                        if (!this.strawman$collection$Iterator$_$$anon$$$outer().hasNext()) {
                            bl = false;
                            break block2;
                        }
                        this.nextElement_$eq(this.strawman$collection$Iterator$_$$anon$$$outer().next());
                        y = this.f$1.apply(this.nextElement());
                    } while (this.traversedValues().contains(y));
                    HashSet<B> Growable_this = this.traversedValues();
                    Growable_this.addOne(y);
                    this.nextElementDefined_$eq(true);
                    bl = true;
                }
                return bl;
            }
        };
    }

    default public <B> Iterator<B> map(Function1<A, B> f) {
        return new Iterator<B>(f, this){
            private final Iterator $outer;
            private final Function1 f$1;
            {
                this.f$1 = f$28;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public boolean hasNext() {
                return this.strawman$collection$Iterator$_$$anon$$$outer().hasNext();
            }

            public B next() {
                return (B)this.f$1.apply(this.strawman$collection$Iterator$_$$anon$$$outer().next());
            }

            private Iterator<A> $outer() {
                return this.$outer;
            }

            public final Iterator<A> strawman$collection$Iterator$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    default public <B> Iterator<B> flatMap(Function1<A, IterableOnce<B>> f) {
        return new Iterator<B>(f, this){
            private Iterator myCurrent;
            private final Iterator $outer;
            private final Function1 f$1;
            {
                this.f$1 = f$29;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.myCurrent = Iterator$.MODULE$.empty();
            }

            private Iterator<B> myCurrent() {
                return this.myCurrent;
            }

            private void myCurrent_$eq(Iterator<B> x$1) {
                this.myCurrent = x$1;
            }

            private Iterator<B> current() {
                while (!this.myCurrent().hasNext() && this.strawman$collection$Iterator$_$$anon$$$outer().hasNext()) {
                    this.myCurrent_$eq(((IterableOnce)this.f$1.apply(this.strawman$collection$Iterator$_$$anon$$$outer().next())).iterator());
                }
                return this.myCurrent();
            }

            public boolean hasNext() {
                return this.current().hasNext();
            }

            public B next() {
                return this.current().next();
            }

            private Iterator<A> $outer() {
                return this.$outer;
            }

            public final Iterator<A> strawman$collection$Iterator$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    default public <B> Iterator<B> flatten(Function1<A, IterableOnce<B>> ev) {
        return this.flatMap(ev);
    }

    default public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
        return new ConcatIterator(this).concat(xs);
    }

    default public <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
        return this.concat(xs);
    }

    default public Iterator<A> take(int n) {
        return new Iterator<A>(n, this){
            private int i;
            private final Iterator $outer;
            private final int n$1;
            {
                this.n$1 = n$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.i = 0;
            }

            private int i() {
                return this.i;
            }

            private void i_$eq(int x$1) {
                this.i = x$1;
            }

            public boolean hasNext() {
                return this.strawman$collection$Iterator$_$$anon$$$outer().hasNext() && this.i() < this.n$1;
            }

            public A next() {
                Object object;
                if (this.hasNext()) {
                    this.i_$eq(this.i() + 1);
                    object = this.strawman$collection$Iterator$_$$anon$$$outer().next();
                } else {
                    object = Iterator$.MODULE$.empty().next();
                }
                return (A)object;
            }

            private Iterator<A> $outer() {
                return this.$outer;
            }

            public final Iterator<A> strawman$collection$Iterator$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    default public Iterator<A> takeWhile(Function1<A, Object> p) {
        return new Iterator<A>(p, this){
            private Object hd;
            private boolean hdDefined;
            private Iterator tail;
            private final Iterator $outer;
            private final Function1 p$1;
            {
                this.p$1 = p$5;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.hdDefined = false;
                this.tail = this.strawman$collection$Iterator$_$$anon$$$outer();
            }

            private A hd() {
                return (A)this.hd;
            }

            private void hd_$eq(A x$1) {
                this.hd = x$1;
            }

            private boolean hdDefined() {
                return this.hdDefined;
            }

            private void hdDefined_$eq(boolean x$1) {
                this.hdDefined = x$1;
            }

            private Iterator<A> tail() {
                return this.tail;
            }

            private void tail_$eq(Iterator<A> x$1) {
                this.tail = x$1;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean hasNext() {
                if (this.hdDefined()) return true;
                if (!this.tail().hasNext()) return false;
                this.hd_$eq(this.tail().next());
                if (BoxesRunTime.unboxToBoolean((Object)this.p$1.apply(this.hd()))) {
                    this.hdDefined_$eq(true);
                } else {
                    this.tail_$eq(Iterator$.MODULE$.empty());
                }
                if (!this.hdDefined()) return false;
                return true;
            }

            public A next() {
                Object object;
                if (this.hasNext()) {
                    this.hdDefined_$eq(false);
                    object = this.hd();
                } else {
                    object = Iterator$.MODULE$.empty().next();
                }
                return (A)object;
            }

            private Iterator<A> $outer() {
                return this.$outer;
            }

            public final Iterator<A> strawman$collection$Iterator$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    default public Iterator<A> drop(int n) {
        for (int i = 0; i < n && this.hasNext(); ++i) {
            this.next();
        }
        return this;
    }

    default public Iterator<A> dropWhile(Function1<A, Object> p) {
        return new Iterator<A>(p, this){
            private int status;
            private A fst;
            private final Iterator $outer;
            private final Function1 p$1;
            {
                this.p$1 = p$6;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.status = -1;
            }

            public boolean hasNext() {
                boolean bl;
                if (this.status == 1) {
                    bl = this.strawman$collection$Iterator$_$$anon$$$outer().hasNext();
                } else if (this.status == 0) {
                    bl = true;
                } else {
                    while (this.strawman$collection$Iterator$_$$anon$$$outer().hasNext()) {
                        A a = this.strawman$collection$Iterator$_$$anon$$$outer().next();
                        if (BoxesRunTime.unboxToBoolean((Object)this.p$1.apply(a))) continue;
                        this.fst = a;
                        this.status = 0;
                        return true;
                    }
                    this.status = 1;
                    bl = false;
                }
                return bl;
            }

            public A next() {
                Object object;
                if (this.hasNext()) {
                    if (this.status == 1) {
                        object = this.strawman$collection$Iterator$_$$anon$$$outer().next();
                    } else {
                        this.status = 1;
                        object = this.fst;
                    }
                } else {
                    object = Iterator$.MODULE$.empty().next();
                }
                return (A)object;
            }

            private Iterator<A> $outer() {
                return this.$outer;
            }

            public final Iterator<A> strawman$collection$Iterator$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    default public Iterator<A> slice(int from, int until) {
        return this.sliceIterator(from, RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(until), 0));
    }

    default public Iterator<A> sliceIterator(int from, int until) {
        int lo = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(from), 0);
        int rest = until < 0 ? -1 : (until <= lo ? 0 : until - lo);
        return rest == 0 ? Iterator$.MODULE$.empty() : new SliceIterator(this, lo, rest);
    }

    default public <B> Iterator<Tuple2<A, B>> zip(IterableOnce<B> that) {
        return new Iterator<Tuple2<A, B>>(that, this){
            private final Iterator thatIterator;
            private final Iterator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.thatIterator = that$1.iterator();
            }

            public Iterator<B> thatIterator() {
                return this.thatIterator;
            }

            public boolean hasNext() {
                return this.strawman$collection$Iterator$_$$anon$$$outer().hasNext() && this.thatIterator().hasNext();
            }

            public Tuple2<A, B> next() {
                return Tuple2$.MODULE$.apply(this.strawman$collection$Iterator$_$$anon$$$outer().next(), this.thatIterator().next());
            }

            private Iterator<A> $outer() {
                return this.$outer;
            }

            public final Iterator<A> strawman$collection$Iterator$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    default public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
        return new Iterator<Tuple2<A1, B>>(that, thisElem, thatElem, this){
            private final Iterator thatIterator;
            private final Iterator $outer;
            private final Object thisElem$1;
            private final Object thatElem$1;
            {
                this.thisElem$1 = thisElem$1;
                this.thatElem$1 = thatElem$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.thatIterator = that$2.iterator();
            }

            public Iterator<B> thatIterator() {
                return this.thatIterator;
            }

            public boolean hasNext() {
                return this.strawman$collection$Iterator$_$$anon$$$outer().hasNext() || this.thatIterator().hasNext();
            }

            public Tuple2<A1, B> next() {
                boolean next1 = this.strawman$collection$Iterator$_$$anon$$$outer().hasNext();
                boolean next2 = this.thatIterator().hasNext();
                if (!next1 && !next2) {
                    throw new NoSuchElementException();
                }
                return Tuple2$.MODULE$.apply(next1 ? this.strawman$collection$Iterator$_$$anon$$$outer().next() : this.thisElem$1, next2 ? this.thatIterator().next() : this.thatElem$1);
            }

            private Iterator<A> $outer() {
                return this.$outer;
            }

            public final Iterator<A> strawman$collection$Iterator$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    default public Iterator<Tuple2<A, Object>> zipWithIndex() {
        return new Iterator<Tuple2<A, Object>>(this){
            private int idx;
            private final Iterator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.idx = 0;
            }

            public int idx() {
                return this.idx;
            }

            public void idx_$eq(int x$1) {
                this.idx = x$1;
            }

            public boolean hasNext() {
                return this.strawman$collection$Iterator$_$$anon$$$outer().hasNext();
            }

            /*
             * WARNING - void declaration
             */
            public Tuple2<A, Object> next() {
                void var1_1;
                Tuple2 ret = Tuple2$.MODULE$.apply(this.strawman$collection$Iterator$_$$anon$$$outer().next(), (Object)BoxesRunTime.boxToInteger((int)this.idx()));
                this.idx_$eq(this.idx() + 1);
                return var1_1;
            }

            private Iterator<A> $outer() {
                return this.$outer;
            }

            public final Iterator<A> strawman$collection$Iterator$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    default public <B> boolean sameElements(IterableOnce<B> that) {
        Iterator<B> those = that.iterator();
        while (this.hasNext() && those.hasNext()) {
            if (BoxesRunTime.equals(this.next(), those.next())) continue;
            return false;
        }
        return this.hasNext() == those.hasNext();
    }

    default public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
        return new Iterator<B>(from, patchElems, replaced, this){
            private Iterator origElems;
            private int i;
            private final Iterator $outer;
            private final Iterator patchElems$1;
            private final int replaced$1;
            {
                this.patchElems$1 = patchElems$1;
                this.replaced$1 = replaced$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.origElems = this.strawman$collection$Iterator$_$$anon$$$outer();
                this.i = from$1 > 0 ? from$1 : 0;
            }

            private Iterator<A> origElems() {
                return this.origElems;
            }

            private void origElems_$eq(Iterator<A> x$1) {
                this.origElems = x$1;
            }

            private int i() {
                return this.i;
            }

            private void i_$eq(int x$1) {
                this.i = x$1;
            }

            public boolean hasNext() {
                if (this.i() == 0) {
                    this.origElems_$eq(this.origElems().drop(this.replaced$1));
                    this.i_$eq(-1);
                }
                return this.origElems().hasNext() || this.patchElems$1.hasNext();
            }

            public B next() {
                A a;
                if (this.i() == 0) {
                    this.origElems_$eq(this.origElems().drop(this.replaced$1));
                    this.i_$eq(-1);
                }
                if (this.i() < 0) {
                    a = this.patchElems$1.hasNext() ? this.patchElems$1.next() : this.origElems().next();
                } else if (this.origElems().hasNext()) {
                    this.i_$eq(this.i() - 1);
                    a = this.origElems().next();
                } else {
                    this.i_$eq(-1);
                    a = this.patchElems$1.next();
                }
                return (B)a;
            }

            private Iterator<A> $outer() {
                return this.$outer;
            }

            public final Iterator<A> strawman$collection$Iterator$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    default public String mkString(String start, String sep, String end) {
        return this.addString(new StringBuilder(), start, sep, end).toString();
    }

    default public String mkString(String sep) {
        return this.mkString("", sep, "");
    }

    default public String mkString() {
        return this.mkString("");
    }

    default public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
        BooleanRef first = BooleanRef.create((boolean)true);
        b.addAll(start);
        this.foreach(arg_0 -> Iterator.addString$$anonfun$1(b, sep, first, arg_0));
        b.addAll(end);
        return b;
    }

    default public <C> C to(Factory<A, C> factory) {
        return factory.fromSpecific(this);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private static boolean contains$$anonfun$1(Object elem$5, Object _$44) {
        return BoxesRunTime.equals((Object)_$44, (Object)elem$5);
    }

    public static String strawman$collection$Iterator$GroupedIterator$$_$$init$$$anonfun$1(int size$1, int step$1) {
        return StringContext$.MODULE$.apply((scala.collection.Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"size=", "%d and step=", "%d, but both must be positive"})).f((scala.collection.Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size$1), BoxesRunTime.boxToInteger((int)step$1)}));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static Object strawman$collection$Iterator$GroupedIterator$$_$withPadding$$anonfun$1(Function0 x$1) {
        return x$1.apply();
    }

    public static boolean strawman$collection$Iterator$GroupedIterator$$_$isFirst$1(int prevSize$1) {
        return prevSize$1 == 0;
    }

    private static int len$lzyINIT1$1(Seq xs$1, LazyInt len$lzy1$1) {
        Integer n;
        LazyInt lazyInt = len$lzy1$1;
        synchronized (lazyInt) {
            int n2;
            if (len$lzy1$1.initialized()) {
                n2 = len$lzy1$1.value();
            } else {
                len$lzy1$1.initialized_$eq(true);
                len$lzy1$1.value_$eq(xs$1.length());
                n2 = len$lzy1$1.value();
            }
            n = BoxesRunTime.boxToInteger((int)n2);
        }
        return BoxesRunTime.unboxToInt((Object)n);
    }

    public static int strawman$collection$Iterator$GroupedIterator$$_$len$1(Seq xs$2, LazyInt len$lzy1$2) {
        return len$lzy1$2.initialized() ? len$lzy1$2.value() : Iterator.len$lzyINIT1$1(xs$2, len$lzy1$2);
    }

    private static boolean incomplete$lzyINIT1$1(int count$1, Seq xs$3, LazyInt len$lzy1$3, LazyBoolean incomplete$lzy1$1) {
        Boolean bl;
        LazyBoolean lazyBoolean = incomplete$lzy1$1;
        synchronized (lazyBoolean) {
            boolean bl2;
            if (incomplete$lzy1$1.initialized()) {
                bl2 = incomplete$lzy1$1.value();
            } else {
                incomplete$lzy1$1.initialized_$eq(true);
                incomplete$lzy1$1.value_$eq(Iterator.strawman$collection$Iterator$GroupedIterator$$_$len$1(xs$3, len$lzy1$3) < count$1);
                bl2 = incomplete$lzy1$1.value();
            }
            bl = BoxesRunTime.boxToBoolean((boolean)bl2);
        }
        return BoxesRunTime.unboxToBoolean((Object)bl);
    }

    public static boolean strawman$collection$Iterator$GroupedIterator$$_$incomplete$1(int count$2, Seq xs$4, LazyInt len$lzy1$4, LazyBoolean incomplete$lzy1$2) {
        return incomplete$lzy1$2.initialized() ? incomplete$lzy1$2.value() : Iterator.incomplete$lzyINIT1$1(count$2, xs$4, len$lzy1$4, incomplete$lzy1$2);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private static Object foldRight$$anonfun$1(Function2 op$2, Object b, Object a) {
        return op$2.apply(a, b);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private static Object reduceRight$$anonfun$1(Function2 op$5, Object x, Object y) {
        return op$5.apply(y, x);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private static Object sum$$anonfun$1(Numeric num$1, Object x, Object y) {
        return num$1.plus(x, y);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private static Object product$$anonfun$1(Numeric num$2, Object x, Object y) {
        return num$2.times(x, y);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private static Object min$$anonfun$1(Ordering ord$1, Object x, Object y) {
        return ord$1.lteq(x, y) ? x : y;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private static Object max$$anonfun$1(Ordering ord$2, Object x, Object y) {
        return ord$2.gteq(x, y) ? x : y;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private static void maxBy$$anonfun$1(Function1 f$19, Ordering cmp$1, ObjectRef maxF$1, ObjectRef maxElem$1, BooleanRef first$2, Object elem) {
        block0: {
            boolean bl;
            Object object;
            Object object2;
            Object fx = f$19.apply(elem);
            if (!first$2.elem && !cmp$1.gt(fx, maxF$1.elem)) break block0;
            maxElem$1.elem = object2 = elem;
            maxF$1.elem = object = fx;
            first$2.elem = bl = false;
        }
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private static void minBy$$anonfun$1(Function1 f$20, Ordering cmp$2, ObjectRef minF$1, ObjectRef minElem$1, BooleanRef first$3, Object elem) {
        block0: {
            boolean bl;
            Object object;
            Object object2;
            Object fx = f$20.apply(elem);
            if (!first$3.elem && !cmp$2.lt(fx, minF$1.elem)) break block0;
            minElem$1.elem = object2 = elem;
            minF$1.elem = object = fx;
            first$3.elem = bl = false;
        }
    }

    private static A distinct$$anonfun$1(A x) {
        return Predef$.MODULE$.identity(x);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private static Object addString$$anonfun$1(StringBuilder b$2, String sep$2, BooleanRef first$4, Object x) {
        StringBuilder stringBuilder;
        if (first$4.elem) {
            boolean bl;
            b$2.addAll(x.toString());
            first$4.elem = bl = false;
            stringBuilder = BoxedUnit.UNIT;
        } else {
            b$2.addAll(sep$2);
            stringBuilder = b$2.addAll(x.toString());
        }
        return stringBuilder;
    }

    private static final class ConcatIterator<A>
    implements Iterator<A> {
        private Iterator current;
        private ConcatIteratorCell tail;
        private ConcatIteratorCell last;
        private boolean currentHasNextChecked;

        public <A> ConcatIterator(Iterator<A> current) {
            this.current = current;
            this.tail = null;
            this.last = null;
            this.currentHasNextChecked = false;
        }

        private Iterator<A> current() {
            return this.current;
        }

        private void current_$eq(Iterator<A> x$1) {
            this.current = x$1;
        }

        private ConcatIteratorCell<A> tail() {
            return this.tail;
        }

        private void tail_$eq(ConcatIteratorCell<A> x$1) {
            this.tail = x$1;
        }

        private ConcatIteratorCell<A> last() {
            return this.last;
        }

        private void last_$eq(ConcatIteratorCell<A> x$1) {
            this.last = x$1;
        }

        private boolean currentHasNextChecked() {
            return this.currentHasNextChecked;
        }

        private void currentHasNextChecked_$eq(boolean x$1) {
            this.currentHasNextChecked = x$1;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean advance() {
            ConcatIterator concatIterator = this;
            do {
                if (concatIterator.tail() == null) {
                    concatIterator.current_$eq(null);
                    concatIterator.last_$eq(null);
                    return false;
                }
                concatIterator.current_$eq(concatIterator.tail().headIterator());
                concatIterator.tail_$eq(concatIterator.tail().tail());
                concatIterator.merge();
                if (!concatIterator.currentHasNextChecked()) continue;
                return true;
            } while (!concatIterator.current().hasNext());
            concatIterator.currentHasNextChecked_$eq(true);
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void merge() {
            ConcatIterator concatIterator = this;
            while (concatIterator.current() instanceof ConcatIterator) {
                ConcatIterator c = (ConcatIterator)concatIterator.current();
                concatIterator.current_$eq(c.current());
                concatIterator.currentHasNextChecked_$eq(c.currentHasNextChecked());
                if (c.tail() == null) continue;
                c.last().tail_$eq(concatIterator.tail());
                concatIterator.tail_$eq(c.tail());
            }
            return;
        }

        @Override
        public boolean hasNext() {
            boolean bl;
            if (this.currentHasNextChecked()) {
                bl = true;
            } else if (this.current() == null) {
                bl = false;
            } else if (this.current().hasNext()) {
                this.currentHasNextChecked_$eq(true);
                bl = true;
            } else {
                bl = this.advance();
            }
            return bl;
        }

        @Override
        public A next() {
            Object object;
            if (this.hasNext()) {
                this.currentHasNextChecked_$eq(false);
                object = this.current().next();
            } else {
                object = Iterator$.MODULE$.empty().next();
            }
            return (A)object;
        }

        @Override
        public <B> Iterator<B> concat(Function0<IterableOnce<B>> that) {
            block2: {
                ConcatIteratorCell<B> c = new ConcatIteratorCell<B>(that, null);
                if (this.tail() == null) {
                    this.tail_$eq(c);
                    this.last_$eq(c);
                } else {
                    this.last().tail_$eq(c);
                    this.last_$eq(c);
                }
                if (this.current() != null) break block2;
                this.current_$eq(Iterator$.MODULE$.empty());
            }
            return this;
        }
    }

    private static final class ConcatIteratorCell<A> {
        private final Function0<IterableOnce<A>> head;
        private ConcatIteratorCell tail;

        public <A> ConcatIteratorCell(Function0<IterableOnce<A>> head, ConcatIteratorCell<A> tail) {
            this.head = head;
            this.tail = tail;
        }

        public ConcatIteratorCell<A> tail() {
            return this.tail;
        }

        public void tail_$eq(ConcatIteratorCell<A> x$1) {
            this.tail = x$1;
        }

        public Iterator<A> headIterator() {
            return ((IterableOnce)this.head.apply()).iterator();
        }
    }

    public static class GroupedIterator<B>
    implements Iterator<Seq<B>> {
        private final Iterator<B> self;
        private final int size;
        private final int step;
        private ArrayBuffer<B> buffer;
        private boolean filled;
        private boolean _partial;
        private Option<Function0<B>> pad;
        private final Iterator $outer;

        public <B> GroupedIterator(Iterator $outer, Iterator<B> self, int size, int step) {
            this.self = self;
            this.size = size;
            this.step = step;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Predef$.MODULE$.require(size >= 1 && step >= 1, () -> Iterator.strawman$collection$Iterator$GroupedIterator$$_$$init$$$anonfun$1(size, step));
            this.buffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            this.filled = false;
            this._partial = true;
            this.pad = None$.MODULE$;
        }

        public GroupedIterator withPadding(Function0<B> x) {
            this.pad = Some$.MODULE$.apply(() -> Iterator.strawman$collection$Iterator$GroupedIterator$$_$withPadding$$anonfun$1(x));
            return this;
        }

        public GroupedIterator withPartial(boolean x) {
            block0: {
                this._partial = x;
                if (!this._partial) break block0;
                this.pad = None$.MODULE$;
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private Seq<B> takeDestructively(int size) {
            void var2_2;
            ArrayBuffer buf = new ArrayBuffer();
            for (int i = 0; i < size && this.self.hasNext(); ++i) {
                B elem = this.self.next();
                ArrayBuffer Growable_this = buf;
                Growable_this.addOne(elem);
            }
            return var2_2;
        }

        private ImmutableArray<B> padding(int x) {
            return ImmutableArray$.MODULE$.fill(x, this::padding$$anonfun$1);
        }

        private int gap() {
            return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.step - this.size), 0);
        }

        private boolean go(int count) {
            Seq xs;
            Seq seq;
            LazyInt lazyInt = new LazyInt();
            LazyBoolean lazyBoolean = new LazyBoolean();
            int prevSize = this.buffer.size();
            Seq res = this.takeDestructively(count);
            int shortBy = count - res.length();
            if (shortBy > 0 && this.pad.isDefined()) {
                Seq IterableOps_this;
                ImmutableArray<B> suffix = this.padding(shortBy);
                Seq SeqOps_this = IterableOps_this = res;
                seq = (Seq)SeqOps_this.appendedAll(suffix);
            } else {
                seq = xs = res;
            }
            return xs.isEmpty() ? false : (this._partial ? this.deliver$1(prevSize, xs, lazyInt, RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(Iterator.strawman$collection$Iterator$GroupedIterator$$_$len$1(xs, lazyInt)), this.size)) : (Iterator.strawman$collection$Iterator$GroupedIterator$$_$incomplete$1(count, xs, lazyInt, lazyBoolean) ? false : (Iterator.strawman$collection$Iterator$GroupedIterator$$_$isFirst$1(prevSize) ? this.deliver$1(prevSize, xs, lazyInt, Iterator.strawman$collection$Iterator$GroupedIterator$$_$len$1(xs, lazyInt)) : this.deliver$1(prevSize, xs, lazyInt, RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.step), this.size)))));
        }

        private boolean fill() {
            return !this.self.hasNext() ? false : (this.buffer.isEmpty() ? this.go(this.size) : this.go(this.step));
        }

        @Override
        public boolean hasNext() {
            return this.filled || this.fill();
        }

        @Override
        public Seq<B> next() {
            Object object = !this.filled ? BoxesRunTime.boxToBoolean((boolean)this.fill()) : BoxedUnit.UNIT;
            if (!this.filled) {
                throw new NoSuchElementException("next on empty iterator");
            }
            this.filled = false;
            return ImmutableArray$.MODULE$.fromArrayBuffer(this.buffer);
        }

        private Iterator<A> $outer() {
            return this.$outer;
        }

        public final Iterator<A> strawman$collection$Iterator$GroupedIterator$$$outer() {
            return this.$outer();
        }

        private B padding$$anonfun$1() {
            return (B)((Function0)this.pad.get()).apply();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean deliver$1(int prevSize$2, Seq xs$5, LazyInt len$lzy1$5, int howMany) {
            if (howMany <= 0) return false;
            if (!Iterator.strawman$collection$Iterator$GroupedIterator$$_$isFirst$1(prevSize$2)) {
                if (Iterator.strawman$collection$Iterator$GroupedIterator$$_$len$1(xs$5, len$lzy1$5) <= this.gap()) return false;
            }
            Object object = !Iterator.strawman$collection$Iterator$GroupedIterator$$_$isFirst$1(prevSize$2) ? (Serializable)((Object)this.buffer.dropInPlace(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.step), prevSize$2))) : BoxedUnit.UNIT;
            int available = Iterator.strawman$collection$Iterator$GroupedIterator$$_$isFirst$1(prevSize$2) ? Iterator.strawman$collection$Iterator$GroupedIterator$$_$len$1(xs$5, len$lzy1$5) : RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(howMany), Iterator.strawman$collection$Iterator$GroupedIterator$$_$len$1(xs$5, len$lzy1$5) - this.gap());
            Seq xs = (Seq)xs$5.takeRight(available);
            ArrayBuffer<B> Growable_this = this.buffer;
            Growable_this.addAll((IterableOnce)xs);
            this.filled = true;
            if (!true) return false;
            return true;
        }
    }

    public static final class SliceIterator<A>
    extends AbstractIterator<A> {
        private final Iterator underlying;
        private int remaining;
        private int dropping;

        public <A> SliceIterator(Iterator<A> underlying, int start, int limit) {
            this.underlying = underlying;
            this.remaining = limit;
            this.dropping = start;
        }

        public Iterator<A> underlying() {
            return this.underlying;
        }

        private int remaining() {
            return this.remaining;
        }

        private void remaining_$eq(int x$1) {
            this.remaining = x$1;
        }

        private int dropping() {
            return this.dropping;
        }

        private void dropping_$eq(int x$1) {
            this.dropping = x$1;
        }

        private boolean unbounded() {
            return this.unbounded$_inlineAccessor_$1() < 0;
        }

        public int unbounded$_inlineAccessor_$1() {
            return this.remaining();
        }

        private void skip() {
            while (this.dropping() > 0) {
                if (this.underlying().hasNext()) {
                    this.underlying().next();
                    this.dropping_$eq(this.dropping() - 1);
                    continue;
                }
                this.dropping_$eq(0);
            }
        }

        @Override
        public boolean hasNext() {
            this.skip();
            return this.remaining() != 0 && this.underlying().hasNext();
        }

        @Override
        public A next() {
            Object object;
            this.skip();
            if (this.remaining() > 0) {
                this.remaining_$eq(this.remaining() - 1);
                object = this.underlying().next();
            } else {
                object = this.unbounded$_inlineAccessor_$1() < 0 ? this.underlying().next() : Iterator$.MODULE$.empty().next();
            }
            return object;
        }

        @Override
        public Iterator<A> sliceIterator(int from, int until) {
            SliceIterator sliceIterator;
            int rest;
            int lo = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(from), 0);
            int n = until < 0 ? this.adjustedBound$1(lo) : (until <= lo ? 0 : (rest = this.unbounded$_inlineAccessor_$1() < 0 ? until - lo : RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.adjustedBound$1(lo)), until - lo)));
            if (rest == 0) {
                sliceIterator = Iterator$.MODULE$.empty();
            } else {
                this.dropping_$eq(this.dropping() + lo);
                this.remaining_$eq(rest);
                sliceIterator = this;
            }
            return sliceIterator;
        }

        private int adjustedBound$1(int lo$1) {
            return this.unbounded$_inlineAccessor_$1() < 0 ? -1 : RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(0), this.remaining() - lo$1);
        }
    }
}

