/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.concurrent;

import java.util.concurrent.ThreadLocalRandom;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.compat.java8.JFunction1;
import scala.math.Equiv;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import strawman.collection.ArrayOps;
import strawman.collection.ArrayOps$;
import strawman.collection.IterableFactory$;
import strawman.collection.IterableOnce;
import strawman.collection.IterableOps;
import strawman.collection.Seq;
import strawman.collection.StringOps$;
import strawman.collection.concurrent.BasicNode;
import strawman.collection.concurrent.CNode$;
import strawman.collection.concurrent.CNodeBase;
import strawman.collection.concurrent.Gen;
import strawman.collection.concurrent.INode;
import strawman.collection.concurrent.LNode;
import strawman.collection.concurrent.MainNode;
import strawman.collection.concurrent.SNode;
import strawman.collection.concurrent.TNode;
import strawman.collection.concurrent.TrieMap;
import strawman.collection.immutable.List$;
import strawman.collection.package$;

public final class CNode<K, V>
extends CNodeBase<K, V> {
    private final int bitmap;
    private final BasicNode[] array;
    private final Gen gen;

    public static <K, V> MainNode<K, V> dual(SNode<K, V> sNode, int n, SNode<K, V> sNode2, int n2, int n3, Gen gen, Equiv<K> equiv) {
        return CNode$.MODULE$.dual(sNode, n, sNode2, n2, n3, gen, equiv);
    }

    public <K, V> CNode(int bitmap, BasicNode[] array, Gen gen) {
        this.bitmap = bitmap;
        this.array = array;
        this.gen = gen;
    }

    public int bitmap() {
        return this.bitmap;
    }

    public BasicNode[] array() {
        return this.array;
    }

    public Gen gen() {
        return this.gen;
    }

    @Override
    public int cachedSize(Object ct) {
        int n;
        int currsz = this.READ_SIZE();
        if (currsz != -1) {
            n = currsz;
        } else {
            int sz = this.computeSize((TrieMap)ct);
            while (this.READ_SIZE() == -1) {
                this.CAS_SIZE(-1, sz);
            }
            n = this.READ_SIZE();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private int computeSize(TrieMap<K, V> ct) {
        void var3_3;
        int sz = 0;
        int offset = this.array().length > 0 ? ThreadLocalRandom.current().nextInt(0, this.array().length) : 0;
        for (int i = 0; i < this.array().length; ++i) {
            int pos = (i + offset) % this.array().length;
            BasicNode basicNode = this.array()[pos];
            if (basicNode instanceof SNode) {
                SNode sNode;
                SNode sn = sNode = (SNode)basicNode;
                ++sz;
                continue;
            }
            if (basicNode instanceof INode) {
                INode iNode;
                INode in = iNode = (INode)basicNode;
                sz += in.cachedSize(ct);
                continue;
            }
            throw new MatchError((Object)basicNode);
        }
        return (int)var3_3;
    }

    public CNode<K, V> updatedAt(int pos, BasicNode nn, Gen gen) {
        int len = this.array().length;
        BasicNode[] narr = new BasicNode[len];
        Array$.MODULE$.copy((Object)this.array(), 0, (Object)narr, 0, len);
        narr[pos] = nn;
        return new CNode<K, V>(this.bitmap(), narr, gen);
    }

    public CNode<K, V> removedAt(int pos, int flag, Gen gen) {
        BasicNode[] arr = this.array();
        int len = arr.length;
        BasicNode[] narr = new BasicNode[len - 1];
        Array$.MODULE$.copy((Object)arr, 0, (Object)narr, 0, pos);
        Array$.MODULE$.copy((Object)arr, pos + 1, (Object)narr, pos, len - pos - 1);
        return new CNode<K, V>(this.bitmap() ^ flag, narr, gen);
    }

    public CNode<K, V> insertedAt(int pos, int flag, BasicNode nn, Gen gen) {
        int len = this.array().length;
        int bmp = this.bitmap();
        BasicNode[] narr = new BasicNode[len + 1];
        Array$.MODULE$.copy((Object)this.array(), 0, (Object)narr, 0, pos);
        narr[pos] = nn;
        Array$.MODULE$.copy((Object)this.array(), pos, (Object)narr, pos + 1, len - pos);
        return new CNode<K, V>(bmp | flag, narr, gen);
    }

    public CNode<K, V> renewed(Gen ngen, TrieMap<K, V> ct) {
        BasicNode[] arr = this.array();
        int len = arr.length;
        BasicNode[] narr = new BasicNode[len];
        for (int i = 0; i < len; ++i) {
            BasicNode basicNode = arr[i];
            if (basicNode instanceof INode) {
                INode iNode;
                INode in = iNode = (INode)basicNode;
                narr[i] = in.copyToGen(ngen, ct);
                continue;
            }
            if (basicNode != null) {
                BasicNode basicNode2;
                BasicNode bn;
                narr[i] = bn = (basicNode2 = basicNode);
                continue;
            }
            throw new MatchError((Object)basicNode);
        }
        return new CNode<K, V>(this.bitmap(), narr, ngen);
    }

    private BasicNode resurrect(INode<K, V> inode, Object inodemain) {
        BasicNode basicNode;
        Object object = inodemain;
        if (object instanceof TNode) {
            TNode tNode;
            TNode tn = tNode = (TNode)object;
            basicNode = tn.copyUntombed();
        } else {
            basicNode = inode;
        }
        return basicNode;
    }

    public MainNode<K, V> toContracted(int lev) {
        MainNode mainNode;
        if (this.array().length == 1 && lev > 0) {
            BasicNode basicNode = this.array()[0];
            if (basicNode instanceof SNode) {
                SNode sNode;
                SNode sn = sNode = (SNode)basicNode;
                mainNode = sn.copyTombed();
            } else {
                mainNode = this;
            }
        } else {
            mainNode = this;
        }
        return mainNode;
    }

    public MainNode<K, V> toCompressed(TrieMap<K, V> ct, int lev, Gen gen) {
        int bmp = this.bitmap();
        BasicNode[] arr = this.array();
        BasicNode[] tmparray = new BasicNode[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            BasicNode sub = arr[i];
            BasicNode basicNode = sub;
            if (basicNode instanceof INode) {
                INode iNode = (INode)basicNode;
                INode in = iNode;
                MainNode<K, V> inodemain = in.gcasRead(ct);
                Predef$.MODULE$.assert(inodemain != null);
                tmparray[i] = this.resurrect(in, inodemain);
                continue;
            }
            if (basicNode instanceof SNode) {
                SNode sNode;
                SNode sn = sNode = (SNode)basicNode;
                tmparray[i] = sn;
                continue;
            }
            throw new MatchError((Object)basicNode);
        }
        return new CNode<K, V>(bmp, tmparray, gen).toContracted(lev);
    }

    @Override
    public String string(int lev) {
        Object[] objectArray = new Object[2];
        objectArray[0] = BoxesRunTime.boxToInteger((int)this.bitmap());
        Object object = package$.MODULE$.arrayToArrayOps(this.array());
        objectArray[1] = new ArrayOps(package$.MODULE$.arrayToArrayOps(ArrayOps$.MODULE$.map$extension(object, (Function1)((JFunction1)arg_0 -> CNode.string$$anonfun$1(lev, arg_0)), ClassTag$.MODULE$.apply(String.class)))).mkString("\n");
        return StringOps$.MODULE$.format$extension(package$.MODULE$.stringToStringOps("CNode %x\n%s"), (scala.collection.Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)objectArray));
    }

    private Seq<Tuple2<K, V>> collectElems() {
        Object object = package$.MODULE$.arrayToArrayOps(this.array());
        return package$.MODULE$.arrayToWrappedArray(ArrayOps$.MODULE$.flatMap$extension(object, (Function1)((JFunction1)CNode::collectElems$$anonfun$1), ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    private Seq<String> collectLocalElems() {
        Object object = package$.MODULE$.arrayToArrayOps(this.array());
        return package$.MODULE$.arrayToWrappedArray(ArrayOps$.MODULE$.flatMap$extension(object, (Function1)((JFunction1)CNode::collectLocalElems$$anonfun$1), ClassTag$.MODULE$.apply(String.class)));
    }

    public String toString() {
        Seq<String> elems = this.collectLocalElems();
        return StringOps$.MODULE$.format$extension(package$.MODULE$.stringToStringOps("CNode(sz: %d; %s)"), (scala.collection.Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)elems.size()), ((IterableOps)elems.sorted(Ordering.String$.MODULE$)).mkString(", ")}));
    }

    private static String string$$anonfun$1(int lev$3, BasicNode _$64) {
        return _$64.string(lev$3 + 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IterableOnce<Tuple2<K, V>> collectElems$$anonfun$1(BasicNode x$1) {
        IterableOnce<Object> iterableOnce;
        BasicNode basicNode = x$1;
        if (basicNode instanceof SNode) {
            SNode sNode;
            SNode sn = sNode = (SNode)basicNode;
            iterableOnce = package$.MODULE$.optionToIterableOnce(Some$.MODULE$.apply(sn.kvPair()));
            return iterableOnce;
        } else {
            INode iNode;
            if (!(basicNode instanceof INode)) throw new MatchError((Object)basicNode);
            INode in = iNode = (INode)basicNode;
            MainNode mainNode = in.mainnode;
            if (mainNode instanceof TNode) {
                TNode tNode;
                TNode tn = tNode = (TNode)mainNode;
                iterableOnce = package$.MODULE$.optionToIterableOnce(Some$.MODULE$.apply(tn.kvPair()));
                return iterableOnce;
            } else if (mainNode instanceof LNode) {
                LNode lNode;
                LNode ln = lNode = (LNode)mainNode;
                iterableOnce = (IterableOnce)ln.entries().to(IterableFactory$.MODULE$.toFactory(List$.MODULE$));
                return iterableOnce;
            } else {
                CNode cNode;
                if (!(mainNode instanceof CNode)) throw new MatchError((Object)mainNode);
                CNode cn = cNode = (CNode)mainNode;
                iterableOnce = cn.collectElems();
            }
        }
        return iterableOnce;
    }

    private static IterableOnce<String> collectLocalElems$$anonfun$1(BasicNode x$1) {
        IterableOnce<String> iterableOnce;
        BasicNode basicNode = x$1;
        if (basicNode instanceof SNode) {
            SNode sNode;
            SNode sn = sNode = (SNode)basicNode;
            iterableOnce = package$.MODULE$.optionToIterableOnce(Some$.MODULE$.apply((Object)sn.kvPair()._2().toString()));
        } else if (basicNode instanceof INode) {
            INode iNode;
            INode in = iNode = (INode)basicNode;
            iterableOnce = package$.MODULE$.optionToIterableOnce(Some$.MODULE$.apply((Object)((String)new StringOps(Predef$.MODULE$.augmentString(in.toString())).drop(14) + "(" + in.gen + ")")));
        } else {
            throw new MatchError((Object)basicNode);
        }
        return iterableOnce;
    }
}

