/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.immutable;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.math.Integral;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import strawman.collection.Hashing$;
import strawman.collection.IterableFactoryLike;
import strawman.collection.IterableOnce;
import strawman.collection.Iterator;
import strawman.collection.Iterator$;
import strawman.collection.Set;
import strawman.collection.StrictOptimizedIterableOps;
import strawman.collection.immutable.HashSet$;
import strawman.collection.immutable.Iterable;
import strawman.collection.immutable.ListSet;
import strawman.collection.immutable.ListSet$;
import strawman.collection.immutable.SetOps;
import strawman.collection.immutable.TrieIterator;
import strawman.collection.mutable.Builder;

public abstract class HashSet<A>
implements strawman.collection.immutable.Set<A>,
StrictOptimizedIterableOps<A, HashSet, HashSet<A>>,
Serializable {
    public static Object iterate(Object object, int n, Function1 function1) {
        return HashSet$.MODULE$.iterate(object, n, function1);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, int n5, Function5 function5) {
        return HashSet$.MODULE$.tabulate(n, n2, n3, n4, n5, function5);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, Function4 function4) {
        return HashSet$.MODULE$.tabulate(n, n2, n3, n4, function4);
    }

    public static Object tabulate(int n, int n2, int n3, Function3 function3) {
        return HashSet$.MODULE$.tabulate(n, n2, n3, function3);
    }

    public static Object tabulate(int n, int n2, Function2 function2) {
        return HashSet$.MODULE$.tabulate(n, n2, function2);
    }

    public static Object tabulate(int n, Function1 function1) {
        return HashSet$.MODULE$.tabulate(n, function1);
    }

    public static <A> HashTrieSet<A> strawman$collection$immutable$HashSet$$$makeHashTrieSet(int n, HashSet<A> hashSet, int n2, HashSet<A> hashSet2, int n3) {
        return HashSet$.MODULE$.strawman$collection$immutable$HashSet$$$makeHashTrieSet(n, hashSet, n2, hashSet2, n3);
    }

    public static <A> Builder<A, HashSet<A>> newBuilder() {
        return HashSet$.MODULE$.newBuilder();
    }

    public static Object fill(int n, int n2, int n3, int n4, int n5, Function0 function0) {
        return HashSet$.MODULE$.fill(n, n2, n3, n4, n5, function0);
    }

    public static Object fill(int n, int n2, int n3, int n4, Function0 function0) {
        return HashSet$.MODULE$.fill(n, n2, n3, n4, function0);
    }

    public static Object fill(int n, int n2, int n3, Function0 function0) {
        return HashSet$.MODULE$.fill(n, n2, n3, function0);
    }

    public static Object fill(int n, int n2, Function0 function0) {
        return HashSet$.MODULE$.fill(n, n2, function0);
    }

    public static Object fill(int n, Function0 function0) {
        return HashSet$.MODULE$.fill(n, function0);
    }

    public static <A> HashSet<A> from(IterableOnce<A> iterableOnce) {
        return HashSet$.MODULE$.from(iterableOnce);
    }

    public static Object range(Object object, Object object2, Object object3, Integral integral) {
        return HashSet$.MODULE$.range(object, object2, object3, integral);
    }

    public static Object range(Object object, Object object2, Integral integral) {
        return HashSet$.MODULE$.range(object, object2, integral);
    }

    public <A> HashSet() {
        Function1.$init$((Function1)this);
    }

    public <A> Function1<A, Object> compose(Function1<A, A> g) {
        return Function1.compose$((Function1)this, g);
    }

    public <A> Function1<A, A> andThen(Function1<Object, A> g) {
        return Function1.andThen$((Function1)this, g);
    }

    @Override
    public String toString() {
        return strawman.collection.SetOps.super.toString();
    }

    @Override
    public boolean equals(Object that) {
        return Set.super.equals(that);
    }

    @Override
    public int hashCode() {
        return Set.super.hashCode();
    }

    @Override
    public HashSet<A> concat(strawman.collection.Iterable<A> that) {
        return (HashSet)SetOps.super.concat(that);
    }

    @Override
    public final <B> strawman.collection.immutable.Set<B> toSet() {
        return strawman.collection.immutable.Set.super.toSet();
    }

    @Override
    public Tuple2<HashSet<A>, HashSet<A>> partition(Function1<A, Object> p) {
        return StrictOptimizedIterableOps.super.partition(p);
    }

    @Override
    public Tuple2<HashSet<A>, HashSet<A>> span(Function1<A, Object> p) {
        return StrictOptimizedIterableOps.super.span(p);
    }

    @Override
    public <A1, A2> Tuple2<HashSet<A1>, HashSet<A2>> unzip(Function1<A, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.super.unzip(asPair);
    }

    @Override
    public <B> HashSet<B> map(Function1<A, B> f) {
        return (HashSet)StrictOptimizedIterableOps.super.map(f);
    }

    @Override
    public <B> HashSet<B> flatMap(Function1<A, IterableOnce<B>> f) {
        return (HashSet)StrictOptimizedIterableOps.super.flatMap(f);
    }

    @Override
    public <B> HashSet<B> collect(PartialFunction<A, B> pf) {
        return (HashSet)StrictOptimizedIterableOps.super.collect(pf);
    }

    @Override
    public <B> HashSet<B> flatten(Function1<A, IterableOnce<B>> toIterableOnce) {
        return (HashSet)StrictOptimizedIterableOps.super.flatten(toIterableOnce);
    }

    @Override
    public <B> HashSet<Tuple2<A, B>> zip(strawman.collection.Iterable<B> that) {
        return (HashSet)StrictOptimizedIterableOps.super.zip(that);
    }

    @Override
    public HashSet<Tuple2<A, Object>> zipWithIndex() {
        return (HashSet)StrictOptimizedIterableOps.super.zipWithIndex();
    }

    @Override
    public <B> HashSet<B> scanLeft(B z, Function2<B, A, B> op) {
        return (HashSet)StrictOptimizedIterableOps.super.scanLeft(z, op);
    }

    @Override
    public HashSet<A> filter(Function1<A, Object> pred) {
        return (HashSet)StrictOptimizedIterableOps.super.filter(pred);
    }

    @Override
    public HashSet<A> filterNot(Function1<A, Object> pred) {
        return (HashSet)StrictOptimizedIterableOps.super.filterNot(pred);
    }

    @Override
    public IterableFactoryLike<HashSet> iterableFactory() {
        return HashSet$.MODULE$;
    }

    @Override
    public HashSet<A> fromSpecificIterable(strawman.collection.Iterable<A> coll) {
        HashSet IterableOps_this = this;
        return IterableOps_this.iterableFactory().from(coll);
    }

    @Override
    public Builder<A, HashSet<A>> newSpecificBuilder() {
        return HashSet$.MODULE$.newBuilder();
    }

    @Override
    public boolean contains(A elem) {
        return this.get0(elem, Hashing$.MODULE$.computeHash(elem), 0);
    }

    @Override
    public HashSet<A> incl(A elem) {
        return this.updated0(elem, Hashing$.MODULE$.computeHash(elem), 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HashSet<A> excl(A elem) {
        void var2_2;
        HashSet<A> s = this.removed0(elem, Hashing$.MODULE$.computeHash(elem), 0);
        return s == null ? HashSet$.MODULE$.empty() : var2_2;
    }

    @Override
    public HashSet<A> empty() {
        return HashSet$.MODULE$.empty();
    }

    @Override
    public HashSet<A> tail() {
        Object elem = this.head();
        HashSet SetOps_this = this;
        return SetOps_this.excl(elem);
    }

    @Override
    public HashSet<A> init() {
        Object elem = this.last();
        HashSet SetOps_this = this;
        return SetOps_this.excl(elem);
    }

    public abstract boolean get0(A var1, int var2, int var3);

    public abstract HashSet<A> updated0(A var1, int var2, int var3);

    public abstract HashSet<A> removed0(A var1, int var2, int var3);

    public static final class HashSet1<A>
    extends LeafHashSet<A> {
        private final Object key;
        private final int hash;

        public <A> HashSet1(A key, int hash) {
            this.key = key;
            this.hash = hash;
        }

        public A key() {
            return (A)this.key;
        }

        @Override
        public int hash() {
            return this.hash;
        }

        @Override
        public Iterator<A> iterator() {
            return Iterator$.MODULE$.single(this.key());
        }

        @Override
        public <U> void foreach(Function1<A, U> f) {
            f.apply(this.key());
        }

        @Override
        public A head() {
            return this.key();
        }

        @Override
        public Some<A> headOption() {
            return Some$.MODULE$.apply(this.key());
        }

        @Override
        public HashSet<A> tail() {
            return HashSet$.MODULE$.empty();
        }

        @Override
        public A last() {
            return this.key();
        }

        @Override
        public HashSet<A> init() {
            return HashSet$.MODULE$.empty();
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean get0(A key, int hash, int level) {
            return hash == this.hash() && BoxesRunTime.equals(key, this.key());
        }

        @Override
        public HashSet<A> updated0(A key, int hash, int level) {
            HashSet hashSet;
            if (hash == this.hash() && BoxesRunTime.equals(key, this.key())) {
                hashSet = this;
            } else if (hash != this.hash()) {
                hashSet = HashSet$.MODULE$.strawman$collection$immutable$HashSet$$$makeHashTrieSet(this.hash(), this, hash, new HashSet1<A>(key, hash), level);
            } else {
                Object SetOps_this = ListSet$.MODULE$.empty();
                SetOps SetOps_this2 = ((ListSet)SetOps_this).incl((Object)this.key());
                HashSetCollision1 hashSetCollision1 = new HashSetCollision1(hash, ((ListSet)SetOps_this2).incl((Object)key));
                hashSet = hashSetCollision1;
            }
            return hashSet;
        }

        @Override
        public HashSet<A> removed0(A key, int hash, int level) {
            return hash == this.hash() && BoxesRunTime.equals(key, this.key()) ? null : this;
        }
    }

    public static final class HashSetCollision1<A>
    extends LeafHashSet<A> {
        private final int hash;
        private final ListSet ks;

        public <A> HashSetCollision1(int hash, ListSet<A> ks) {
            this.hash = hash;
            this.ks = ks;
        }

        @Override
        public int hash() {
            return this.hash;
        }

        public ListSet<A> ks() {
            return this.ks;
        }

        @Override
        public int size() {
            return this.ks().size();
        }

        @Override
        public Iterator<A> iterator() {
            return this.ks().iterator();
        }

        @Override
        public <U> void foreach(Function1<A, U> f) {
            this.ks().foreach(f);
        }

        @Override
        public boolean get0(A key, int hash, int level) {
            return hash == this.hash() ? this.ks().contains(key) : false;
        }

        @Override
        public HashSet<A> updated0(A key, int hash, int level) {
            HashSet hashSet;
            if (hash == this.hash()) {
                ListSet<A> SetOps_this = this.ks();
                HashSetCollision1<A> hashSetCollision1 = new HashSetCollision1<A>(hash, SetOps_this.incl((Object)key));
                hashSet = hashSetCollision1;
            } else {
                hashSet = HashSet$.MODULE$.strawman$collection$immutable$HashSet$$$makeHashTrieSet(this.hash(), this, hash, new HashSet1<A>(key, hash), level);
            }
            return hashSet;
        }

        @Override
        public HashSet<A> removed0(A key, int hash, int level) {
            int size;
            ListSet<A> SetOps_this;
            SetOps ks1;
            int n;
            return hash == this.hash() ? (0 == (n = ((ListSet)(ks1 = (SetOps_this = this.ks()).excl((Object)key))).size()) ? null : (1 == n ? new HashSet1(ks1.head(), hash) : ((size = n) == this.ks().size() ? this : new HashSetCollision1<A>(hash, ks1)))) : this;
        }

        private void writeObject(ObjectOutputStream out) {
            throw package$.MODULE$.error("cannot serialize an immutable.HashSet where all items have the same 32-bit hash code");
        }

        private void readObject(ObjectInputStream in) {
            throw package$.MODULE$.error("cannot deserialize an immutable.HashSet where all items have the same 32-bit hash code");
        }
    }

    public static final class HashTrieSet<A>
    extends HashSet<A> {
        private final int bitmap;
        private final HashSet[] elems;
        private final int size0;

        public <A> HashTrieSet(int bitmap, HashSet<A>[] elems, int size0) {
            this.bitmap = bitmap;
            this.elems = elems;
            this.size0 = size0;
            Predef$.MODULE$.assert(Integer.bitCount(bitmap) == elems.length);
        }

        private int bitmap() {
            return this.bitmap;
        }

        public HashSet<A>[] elems() {
            return this.elems;
        }

        private int size0() {
            return this.size0;
        }

        @Override
        public int size() {
            return this.size0();
        }

        @Override
        public Iterator<A> iterator() {
            return new TrieIterator<A>(this){
                private final HashTrieSet $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.strawman$collection$immutable$HashSet$HashTrieSet$$_$$anon$superArg$2$1());
                }

                public final A getElem(Object cc) {
                    return ((HashSet1)cc).key();
                }

                private HashTrieSet<A> $outer() {
                    return this.$outer;
                }

                public final HashTrieSet<A> strawman$collection$immutable$HashSet$HashTrieSet$_$$anon$$$outer() {
                    return this.$outer();
                }
            };
        }

        @Override
        public <U> void foreach(Function1<A, U> f) {
            for (int i = 0; i < this.elems().length; ++i) {
                this.elems()[i].foreach(f);
            }
        }

        @Override
        public boolean get0(A key, int hash, int level) {
            boolean bl;
            int index = hash >>> level & 0x1F;
            int mask = 1 << index;
            if (this.bitmap() == -1) {
                bl = this.elems()[index & 0x1F].get0(key, hash, level + 5);
            } else if ((this.bitmap() & mask) != 0) {
                int offset = Integer.bitCount(this.bitmap() & mask - 1);
                bl = this.elems()[offset].get0(key, hash, level + 5);
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public HashSet<A> updated0(A key, int hash, int level) {
            HashTrieSet hashTrieSet;
            int index = hash >>> level & 0x1F;
            int mask = 1 << index;
            int offset = Integer.bitCount(this.bitmap() & mask - 1);
            if ((this.bitmap() & mask) != 0) {
                HashSet<A> subNew;
                HashSet<A> sub = this.elems()[offset];
                if (sub == (subNew = sub.updated0(key, hash, level + 5))) {
                    hashTrieSet = this;
                } else {
                    HashSet<A>[] elemsNew = Arrays.copyOf(this.elems(), this.elems().length);
                    elemsNew[offset] = subNew;
                    hashTrieSet = new HashTrieSet<A>(this.bitmap(), elemsNew, this.size() + (subNew.size() - sub.size()));
                }
            } else {
                HashSet[] elemsNew = new HashSet[this.elems().length + 1];
                Array$.MODULE$.copy(this.elems(), 0, (Object)elemsNew, 0, offset);
                elemsNew[offset] = new HashSet1<A>(key, hash);
                Array$.MODULE$.copy(this.elems(), offset, (Object)elemsNew, offset + 1, this.elems().length - offset);
                int bitmapNew = this.bitmap() | mask;
                hashTrieSet = new HashTrieSet<A>(bitmapNew, elemsNew, this.size() + 1);
            }
            return hashTrieSet;
        }

        @Override
        public HashSet<A> removed0(A key, int hash, int level) {
            HashSet hashSet;
            int index = hash >>> level & 0x1F;
            int mask = 1 << index;
            int offset = Integer.bitCount(this.bitmap() & mask - 1);
            if ((this.bitmap() & mask) != 0) {
                HashSet<A> subNew;
                HashSet<A> sub = this.elems()[offset];
                if (sub == (subNew = sub.removed0(key, hash, level + 5))) {
                    hashSet = this;
                } else if (subNew == null) {
                    int bitmapNew = this.bitmap() ^ mask;
                    if (bitmapNew != 0) {
                        HashSet[] elemsNew = new HashSet[this.elems().length - 1];
                        Array$.MODULE$.copy(this.elems(), 0, (Object)elemsNew, 0, offset);
                        Array$.MODULE$.copy(this.elems(), offset + 1, (Object)elemsNew, offset, this.elems().length - offset - 1);
                        int sizeNew = this.size() - sub.size();
                        hashSet = elemsNew.length == 1 && !(elemsNew[0] instanceof HashTrieSet) ? elemsNew[0] : new HashTrieSet<A>(bitmapNew, elemsNew, sizeNew);
                    } else {
                        hashSet = null;
                    }
                } else if (this.elems().length == 1 && !(subNew instanceof HashTrieSet)) {
                    hashSet = subNew;
                } else {
                    HashSet<A>[] elemsNew = Arrays.copyOf(this.elems(), this.elems().length);
                    elemsNew[offset] = subNew;
                    int sizeNew = this.size() + (subNew.size() - sub.size());
                    hashSet = new HashTrieSet<A>(this.bitmap(), elemsNew, sizeNew);
                }
            } else {
                hashSet = this;
            }
            return hashSet;
        }

        public Iterable<A>[] strawman$collection$immutable$HashSet$HashTrieSet$$_$$anon$superArg$2$1() {
            return this.elems();
        }
    }

    public static abstract class LeafHashSet<A>
    extends HashSet<A> {
        public abstract int hash();
    }
}

