/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.immutable;

import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import strawman.collection.IterableFactoryLike;
import strawman.collection.IterableOnce;
import strawman.collection.Iterator;
import strawman.collection.Map;
import strawman.collection.MapFactory;
import strawman.collection.MapOps;
import strawman.collection.SortedMapFactory;
import strawman.collection.SortedMapOps;
import strawman.collection.StrictOptimizedIterableOps;
import strawman.collection.immutable.Iterable;
import strawman.collection.immutable.List$;
import strawman.collection.immutable.Map$;
import strawman.collection.immutable.RedBlackTree;
import strawman.collection.immutable.RedBlackTree$;
import strawman.collection.immutable.SortedMap;
import strawman.collection.immutable.SortedMapOps;
import strawman.collection.immutable.SortedSet;
import strawman.collection.immutable.TreeMap$;
import strawman.collection.mutable.Builder;

public final class TreeMap<K, V>
implements SortedMap<K, V>,
StrictOptimizedIterableOps<Tuple2<K, V>, Iterable, TreeMap<K, V>>,
Serializable {
    private final RedBlackTree.Tree<K, V> tree;
    private final Ordering ordering;

    public static <K, V> Builder<Tuple2<K, V>, TreeMap<K, V>> newBuilder(Ordering<K> ordering) {
        return TreeMap$.MODULE$.newBuilder(ordering);
    }

    private <K, V> TreeMap(RedBlackTree.Tree<K, V> tree, Ordering<K> ordering) {
        this.tree = tree;
        this.ordering = ordering;
        Function1.$init$((Function1)this);
        PartialFunction.$init$((PartialFunction)this);
    }

    public <A> Function1<A, V> compose(Function1<A, K> g) {
        return Function1.compose$((Function1)this, g);
    }

    public <A1 extends K, B1> PartialFunction<A1, B1> orElse(PartialFunction<A1, B1> that) {
        return PartialFunction.orElse$((PartialFunction)this, that);
    }

    public <C> PartialFunction<K, C> andThen(Function1<V, C> k) {
        return PartialFunction.andThen$((PartialFunction)this, k);
    }

    public Function1<K, Option<V>> lift() {
        return PartialFunction.lift$((PartialFunction)this);
    }

    public <U> Function1<K, Object> runWith(Function1<V, U> action) {
        return PartialFunction.runWith$((PartialFunction)this, action);
    }

    @Override
    public <K1 extends K, V1> V1 applyOrElse(K1 x, Function1<K1, V1> function1) {
        return MapOps.super.applyOrElse(x, function1);
    }

    @Override
    public String toString() {
        return MapOps.super.toString();
    }

    @Override
    public String mkString(String start, String sep, String end) {
        return MapOps.super.mkString(start, sep, end);
    }

    @Override
    public boolean equals(Object o) {
        return Map.super.equals(o);
    }

    @Override
    public int hashCode() {
        return Map.super.hashCode();
    }

    @Override
    public final <K2, V2> strawman.collection.immutable.Map<K2, V2> toMap(Predef$.less.colon.less<Tuple2<K, V>, Tuple2<K2, V2>> ev) {
        return strawman.collection.immutable.Map.super.toMap(ev);
    }

    @Override
    public SortedMapOps.SortedMapWithFilter withFilter(Function1<Tuple2<K, V>, Object> p) {
        return strawman.collection.SortedMapOps.super.withFilter(p);
    }

    @Override
    public <V2> TreeMap<K, V2> $plus$plus(strawman.collection.Iterable<Tuple2<K, V2>> xs) {
        return (TreeMap)strawman.collection.SortedMapOps.super.$plus$plus(xs);
    }

    @Override
    public SortedSet<K> keySet() {
        return SortedMapOps.super.keySet();
    }

    @Override
    public final <V1> TreeMap<K, V1> $plus(Tuple2<K, V1> kv) {
        return (TreeMap)SortedMapOps.super.$plus(kv);
    }

    @Override
    public <V2> TreeMap<K, V2> concat(strawman.collection.Iterable<Tuple2<K, V2>> xs) {
        return (TreeMap)SortedMapOps.super.concat(xs);
    }

    @Override
    public Tuple2<TreeMap<K, V>, TreeMap<K, V>> partition(Function1<Tuple2<K, V>, Object> p) {
        return StrictOptimizedIterableOps.super.partition(p);
    }

    @Override
    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<Tuple2<K, V>, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.super.unzip(asPair);
    }

    @Override
    public <B> Iterable<B> map(Function1<Tuple2<K, V>, B> f) {
        return (Iterable)StrictOptimizedIterableOps.super.map(f);
    }

    @Override
    public <B> Iterable<B> flatMap(Function1<Tuple2<K, V>, IterableOnce<B>> f) {
        return (Iterable)StrictOptimizedIterableOps.super.flatMap(f);
    }

    @Override
    public <B> Iterable<B> collect(PartialFunction<Tuple2<K, V>, B> pf) {
        return (Iterable)StrictOptimizedIterableOps.super.collect(pf);
    }

    @Override
    public <B> Iterable<B> flatten(Function1<Tuple2<K, V>, IterableOnce<B>> toIterableOnce) {
        return (Iterable)StrictOptimizedIterableOps.super.flatten(toIterableOnce);
    }

    @Override
    public <B> Iterable<Tuple2<Tuple2<K, V>, B>> zip(strawman.collection.Iterable<B> that) {
        return (Iterable)StrictOptimizedIterableOps.super.zip(that);
    }

    @Override
    public Iterable<Tuple2<Tuple2<K, V>, Object>> zipWithIndex() {
        return (Iterable)StrictOptimizedIterableOps.super.zipWithIndex();
    }

    @Override
    public <B> Iterable<B> scanLeft(B z, Function2<B, Tuple2<K, V>, B> op) {
        return (Iterable)StrictOptimizedIterableOps.super.scanLeft(z, op);
    }

    @Override
    public TreeMap<K, V> filter(Function1<Tuple2<K, V>, Object> pred) {
        return (TreeMap)StrictOptimizedIterableOps.super.filter(pred);
    }

    @Override
    public TreeMap<K, V> filterNot(Function1<Tuple2<K, V>, Object> pred) {
        return (TreeMap)StrictOptimizedIterableOps.super.filterNot(pred);
    }

    @Override
    public Ordering<K> ordering() {
        return this.ordering;
    }

    public <K, V> TreeMap(Ordering<K> ordering) {
        this(null, ordering);
    }

    @Override
    public IterableFactoryLike<Iterable> iterableFactory() {
        return List$.MODULE$;
    }

    @Override
    public MapFactory<strawman.collection.immutable.Map> mapFactory() {
        return Map$.MODULE$;
    }

    @Override
    public SortedMapFactory<TreeMap> sortedMapFactory() {
        return TreeMap$.MODULE$;
    }

    @Override
    public TreeMap<K, V> fromSpecificIterable(strawman.collection.Iterable<Tuple2<K, V>> coll) {
        return TreeMap$.MODULE$.from(coll, (Ordering)this.ordering());
    }

    @Override
    public <K2, V2> TreeMap<K2, V2> sortedMapFromIterable(strawman.collection.Iterable<Tuple2<K2, V2>> it, Ordering<K2> ordering) {
        return TreeMap$.MODULE$.from(it, (Ordering)ordering);
    }

    @Override
    public Builder<Tuple2<K, V>, TreeMap<K, V>> newSpecificBuilder() {
        return TreeMap$.MODULE$.newBuilder(this.ordering());
    }

    @Override
    public Iterator<Tuple2<K, V>> iterator() {
        return RedBlackTree$.MODULE$.iterator(this.tree, RedBlackTree$.MODULE$.iterator$default$2(), this.ordering());
    }

    @Override
    public Iterator<K> keysIteratorFrom(K start) {
        return RedBlackTree$.MODULE$.keysIterator(this.tree, Some$.MODULE$.apply(start), this.ordering());
    }

    @Override
    public Iterator<Tuple2<K, V>> iteratorFrom(K start) {
        return RedBlackTree$.MODULE$.iterator(this.tree, Some$.MODULE$.apply(start), this.ordering());
    }

    @Override
    public Iterator<V> valuesIteratorFrom(K start) {
        return RedBlackTree$.MODULE$.valuesIterator(this.tree, Some$.MODULE$.apply(start), this.ordering());
    }

    @Override
    public Option<V> get(K key) {
        return RedBlackTree$.MODULE$.get(this.tree, key, this.ordering());
    }

    @Override
    public TreeMap<K, V> remove(K key) {
        return !RedBlackTree$.MODULE$.contains(this.tree, key, this.ordering()) ? this : new TreeMap<K, V>(RedBlackTree$.MODULE$.delete(this.tree, key, this.ordering()), this.ordering());
    }

    @Override
    public <V1> TreeMap<K, V1> updated(K key, V1 value) {
        return new TreeMap<K, V1>(RedBlackTree$.MODULE$.update(this.tree, key, value, true, this.ordering()), this.ordering());
    }

    @Override
    public TreeMap<K, V> empty() {
        return TreeMap$.MODULE$.empty((Ordering)this.ordering());
    }

    @Override
    public TreeMap<K, V> rangeImpl(Option<K> from, Option<K> until) {
        return new TreeMap<K, V>(RedBlackTree$.MODULE$.rangeImpl(this.tree, from, until, this.ordering()), this.ordering());
    }

    @Override
    public Option<Tuple2<K, V>> minAfter(K key) {
        Option option;
        RedBlackTree.Tree<K, V> tree = RedBlackTree$.MODULE$.minAfter(this.tree, key, this.ordering());
        if (tree == null) {
            option = Option$.MODULE$.empty();
        } else {
            RedBlackTree.Tree<K, V> x = tree;
            option = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(x.key(), x.value()));
        }
        return option;
    }

    @Override
    public Option<Tuple2<K, V>> maxBefore(K key) {
        Option option;
        RedBlackTree.Tree<K, V> tree = RedBlackTree$.MODULE$.maxBefore(this.tree, key, this.ordering());
        if (tree == null) {
            option = Option$.MODULE$.empty();
        } else {
            RedBlackTree.Tree<K, V> x = tree;
            option = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(x.key(), x.value()));
        }
        return option;
    }

    @Override
    public TreeMap<K, V> range(K from, K until) {
        return new TreeMap<K, V>(RedBlackTree$.MODULE$.range(this.tree, from, until, this.ordering()), this.ordering());
    }

    @Override
    public <U> void foreach(Function1<Tuple2<K, V>, U> f) {
        RedBlackTree$.MODULE$.foreach(this.tree, f);
    }

    @Override
    public int size() {
        return RedBlackTree$.MODULE$.count(this.tree);
    }

    @Override
    public K firstKey() {
        return RedBlackTree$.MODULE$.smallest(this.tree).key();
    }

    @Override
    public K lastKey() {
        return RedBlackTree$.MODULE$.greatest(this.tree).key();
    }

    @Override
    public Tuple2<K, V> head() {
        RedBlackTree.Tree<K, V> smallest = RedBlackTree$.MODULE$.smallest(this.tree);
        return Tuple2$.MODULE$.apply(smallest.key(), smallest.value());
    }

    @Override
    public Tuple2<K, V> last() {
        RedBlackTree.Tree<K, V> greatest = RedBlackTree$.MODULE$.greatest(this.tree);
        return Tuple2$.MODULE$.apply(greatest.key(), greatest.value());
    }

    @Override
    public TreeMap<K, V> tail() {
        return new TreeMap<K, V>(RedBlackTree$.MODULE$.delete(this.tree, this.firstKey(), this.ordering()), this.ordering());
    }

    @Override
    public TreeMap<K, V> init() {
        return new TreeMap<K, V>(RedBlackTree$.MODULE$.delete(this.tree, this.lastKey(), this.ordering()), this.ordering());
    }

    @Override
    public TreeMap<K, V> drop(int n) {
        return n <= 0 ? this : (n >= this.size() ? this.empty() : new TreeMap<K, V>(RedBlackTree$.MODULE$.drop(this.tree, n, this.ordering()), this.ordering()));
    }

    @Override
    public TreeMap<K, V> take(int n) {
        return n <= 0 ? this.empty() : (n >= this.size() ? this : new TreeMap<K, V>(RedBlackTree$.MODULE$.take(this.tree, n, this.ordering()), this.ordering()));
    }

    @Override
    public TreeMap<K, V> slice(int from, int until) {
        return until <= from ? this.empty() : (from <= 0 ? this.take(until) : (until >= this.size() ? this.drop(from) : new TreeMap<K, V>(RedBlackTree$.MODULE$.slice(this.tree, from, until, this.ordering()), this.ordering())));
    }

    @Override
    public TreeMap<K, V> dropRight(int n) {
        return this.take(this.size() - package$.MODULE$.max(n, 0));
    }

    @Override
    public TreeMap<K, V> takeRight(int n) {
        return this.drop(this.size() - package$.MODULE$.max(n, 0));
    }

    /*
     * WARNING - void declaration
     */
    private int countWhile(Function1<Tuple2<K, V>, Object> p) {
        void var2_2;
        int result = 0;
        Iterator<Tuple2<K, V>> it = this.iterator();
        while (it.hasNext() && BoxesRunTime.unboxToBoolean((Object)p.apply(it.next()))) {
            ++result;
        }
        return (int)var2_2;
    }

    @Override
    public TreeMap<K, V> dropWhile(Function1<Tuple2<K, V>, Object> p) {
        return this.drop(this.countWhile(p));
    }

    @Override
    public TreeMap<K, V> takeWhile(Function1<Tuple2<K, V>, Object> p) {
        return this.take(this.countWhile(p));
    }

    @Override
    public Tuple2<TreeMap<K, V>, TreeMap<K, V>> span(Function1<Tuple2<K, V>, Object> p) {
        return this.splitAt(this.countWhile(p));
    }
}

