/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.immutable;

import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some$;
import scala.Tuple2;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import strawman.collection.Iterable;
import strawman.collection.IterableFactoryLike;
import strawman.collection.IterableOnce;
import strawman.collection.Iterator;
import strawman.collection.Set;
import strawman.collection.SortedIterableFactory;
import strawman.collection.SortedSetOps;
import strawman.collection.StrictOptimizedIterableOps;
import strawman.collection.StrictOptimizedSortedSetOps;
import strawman.collection.immutable.RedBlackTree;
import strawman.collection.immutable.RedBlackTree$;
import strawman.collection.immutable.Set$;
import strawman.collection.immutable.SetOps;
import strawman.collection.immutable.SortedSet;
import strawman.collection.immutable.TreeSet$;
import strawman.collection.mutable.Builder;

public final class TreeSet<A>
implements SortedSet<A>,
StrictOptimizedSortedSetOps<A, TreeSet, TreeSet<A>> {
    private final RedBlackTree.Tree<A, BoxedUnit> tree;
    private final Ordering ordering;

    public static <A> Builder<A, TreeSet<A>> newBuilder(Ordering<A> ordering) {
        return TreeSet$.MODULE$.newBuilder(ordering);
    }

    public static Object fill(int n, Function0 function0, Ordering ordering) {
        return TreeSet$.MODULE$.fill(n, function0, ordering);
    }

    private <A> TreeSet(RedBlackTree.Tree<A, BoxedUnit> tree, Ordering<A> ordering) {
        this.tree = tree;
        this.ordering = ordering;
        Function1.$init$((Function1)this);
        if (ordering == null) {
            throw new NullPointerException("ordering must not be null");
        }
    }

    public <A> Function1<A, Object> compose(Function1<A, A> g) {
        return Function1.compose$((Function1)this, g);
    }

    public <A> Function1<A, A> andThen(Function1<Object, A> g) {
        return Function1.andThen$((Function1)this, g);
    }

    @Override
    public String toString() {
        return strawman.collection.SetOps.super.toString();
    }

    @Override
    public boolean equals(Object that) {
        return Set.super.equals(that);
    }

    @Override
    public int hashCode() {
        return Set.super.hashCode();
    }

    @Override
    public TreeSet<A> concat(Iterable<A> that) {
        return (TreeSet)SetOps.super.concat(that);
    }

    @Override
    public final <B> strawman.collection.immutable.Set<B> toSet() {
        return strawman.collection.immutable.Set.super.toSet();
    }

    @Override
    public SortedSetOps.SortedWithFilter withFilter(Function1<A, Object> p) {
        return SortedSetOps.super.withFilter(p);
    }

    @Override
    public Tuple2<TreeSet<A>, TreeSet<A>> partition(Function1<A, Object> p) {
        return StrictOptimizedIterableOps.super.partition(p);
    }

    @Override
    public <A1, A2> Tuple2<strawman.collection.immutable.Set<A1>, strawman.collection.immutable.Set<A2>> unzip(Function1<A, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.super.unzip(asPair);
    }

    @Override
    public <B> strawman.collection.immutable.Set<B> map(Function1<A, B> f) {
        return (strawman.collection.immutable.Set)StrictOptimizedIterableOps.super.map(f);
    }

    @Override
    public <B> strawman.collection.immutable.Set<B> flatMap(Function1<A, IterableOnce<B>> f) {
        return (strawman.collection.immutable.Set)StrictOptimizedIterableOps.super.flatMap(f);
    }

    @Override
    public <B> strawman.collection.immutable.Set<B> collect(PartialFunction<A, B> pf) {
        return (strawman.collection.immutable.Set)StrictOptimizedIterableOps.super.collect(pf);
    }

    @Override
    public <B> strawman.collection.immutable.Set<B> flatten(Function1<A, IterableOnce<B>> toIterableOnce) {
        return (strawman.collection.immutable.Set)StrictOptimizedIterableOps.super.flatten(toIterableOnce);
    }

    @Override
    public <B> strawman.collection.immutable.Set<Tuple2<A, B>> zip(Iterable<B> that) {
        return (strawman.collection.immutable.Set)StrictOptimizedIterableOps.super.zip(that);
    }

    @Override
    public strawman.collection.immutable.Set<Tuple2<A, Object>> zipWithIndex() {
        return (strawman.collection.immutable.Set)StrictOptimizedIterableOps.super.zipWithIndex();
    }

    @Override
    public <B> strawman.collection.immutable.Set<B> scanLeft(B z, Function2<B, A, B> op) {
        return (strawman.collection.immutable.Set)StrictOptimizedIterableOps.super.scanLeft(z, op);
    }

    @Override
    public TreeSet<A> filter(Function1<A, Object> pred) {
        return (TreeSet)StrictOptimizedIterableOps.super.filter(pred);
    }

    @Override
    public TreeSet<A> filterNot(Function1<A, Object> pred) {
        return (TreeSet)StrictOptimizedIterableOps.super.filterNot(pred);
    }

    @Override
    public <B> TreeSet<B> map(Function1<A, B> f, Ordering<B> evidence$81) {
        return (TreeSet)StrictOptimizedSortedSetOps.super.map(f, evidence$81);
    }

    @Override
    public <B> TreeSet<B> flatMap(Function1<A, IterableOnce<B>> f, Ordering<B> evidence$82) {
        return (TreeSet)StrictOptimizedSortedSetOps.super.flatMap(f, evidence$82);
    }

    @Override
    public <B> TreeSet<Tuple2<A, B>> zip(Iterable<B> that, Ordering<Tuple2<A, B>> ev) {
        return (TreeSet)StrictOptimizedSortedSetOps.super.zip(that, ev);
    }

    @Override
    public <B> TreeSet<B> collect(PartialFunction<A, B> pf, Ordering<B> evidence$83) {
        return (TreeSet)StrictOptimizedSortedSetOps.super.collect(pf, evidence$83);
    }

    @Override
    public Ordering<A> ordering() {
        return this.ordering;
    }

    public <A> TreeSet(Ordering<A> ordering) {
        this(null, ordering);
    }

    @Override
    public IterableFactoryLike<strawman.collection.immutable.Set> iterableFactory() {
        return Set$.MODULE$;
    }

    @Override
    public SortedIterableFactory<TreeSet> sortedIterableFactory() {
        return TreeSet$.MODULE$;
    }

    @Override
    public TreeSet<A> fromSpecificIterable(Iterable<A> coll) {
        return TreeSet$.MODULE$.from(coll, (Ordering)this.ordering());
    }

    @Override
    public <B> TreeSet<B> sortedFromIterable(Iterable<B> coll, Ordering<B> evidence$89) {
        return TreeSet$.MODULE$.from(coll, (Ordering)evidence$89);
    }

    @Override
    public Builder<A, TreeSet<A>> newSpecificBuilder() {
        return TreeSet$.MODULE$.newBuilder(this.ordering());
    }

    private TreeSet<A> newSet(RedBlackTree.Tree<A, BoxedUnit> t) {
        return new TreeSet<A>(t, this.ordering());
    }

    @Override
    public int size() {
        return RedBlackTree$.MODULE$.count(this.tree);
    }

    @Override
    public A head() {
        return RedBlackTree$.MODULE$.smallest(this.tree).key();
    }

    @Override
    public A last() {
        return RedBlackTree$.MODULE$.greatest(this.tree).key();
    }

    @Override
    public TreeSet<A> tail() {
        return new TreeSet<A>(RedBlackTree$.MODULE$.delete(this.tree, this.firstKey(), this.ordering()), this.ordering());
    }

    @Override
    public TreeSet<A> init() {
        return new TreeSet<A>(RedBlackTree$.MODULE$.delete(this.tree, this.lastKey(), this.ordering()), this.ordering());
    }

    @Override
    public TreeSet<A> drop(int n) {
        return n <= 0 ? this : (n >= this.size() ? this.empty() : this.newSet(RedBlackTree$.MODULE$.drop(this.tree, n, this.ordering())));
    }

    @Override
    public TreeSet<A> take(int n) {
        return n <= 0 ? this.empty() : (n >= this.size() ? this : this.newSet(RedBlackTree$.MODULE$.take(this.tree, n, this.ordering())));
    }

    @Override
    public TreeSet<A> slice(int from, int until) {
        return until <= from ? this.empty() : (from <= 0 ? this.take(until) : (until >= this.size() ? this.drop(from) : this.newSet(RedBlackTree$.MODULE$.slice(this.tree, from, until, this.ordering()))));
    }

    @Override
    public TreeSet<A> dropRight(int n) {
        return this.take(this.size() - package$.MODULE$.max(n, 0));
    }

    @Override
    public TreeSet<A> takeRight(int n) {
        return this.drop(this.size() - package$.MODULE$.max(n, 0));
    }

    /*
     * WARNING - void declaration
     */
    private int countWhile(Function1<A, Object> p) {
        void var2_2;
        int result = 0;
        Iterator<A> it = this.iterator();
        while (it.hasNext() && BoxesRunTime.unboxToBoolean((Object)p.apply(it.next()))) {
            ++result;
        }
        return (int)var2_2;
    }

    @Override
    public TreeSet<A> dropWhile(Function1<A, Object> p) {
        return this.drop(this.countWhile(p));
    }

    @Override
    public TreeSet<A> takeWhile(Function1<A, Object> p) {
        return this.take(this.countWhile(p));
    }

    @Override
    public Tuple2<TreeSet<A>, TreeSet<A>> span(Function1<A, Object> p) {
        return this.splitAt(this.countWhile(p));
    }

    @Override
    public <U> void foreach(Function1<A, U> f) {
        RedBlackTree$.MODULE$.foreachKey(this.tree, f);
    }

    @Override
    public Option<A> minAfter(A key) {
        RedBlackTree.Tree<A, BoxedUnit> v = RedBlackTree$.MODULE$.minAfter(this.tree, key, this.ordering());
        return v == null ? Option$.MODULE$.empty() : Some$.MODULE$.apply(v.key());
    }

    @Override
    public Option<A> maxBefore(A key) {
        RedBlackTree.Tree<A, BoxedUnit> v = RedBlackTree$.MODULE$.maxBefore(this.tree, key, this.ordering());
        return v == null ? Option$.MODULE$.empty() : Some$.MODULE$.apply(v.key());
    }

    @Override
    public Iterator<A> iterator() {
        return RedBlackTree$.MODULE$.keysIterator(this.tree, RedBlackTree$.MODULE$.keysIterator$default$2(), this.ordering());
    }

    @Override
    public Iterator<A> iteratorFrom(A start) {
        return RedBlackTree$.MODULE$.keysIterator(this.tree, Some$.MODULE$.apply(start), this.ordering());
    }

    @Override
    public boolean contains(A elem) {
        return RedBlackTree$.MODULE$.contains(this.tree, elem, this.ordering());
    }

    @Override
    public TreeSet<A> empty() {
        return TreeSet$.MODULE$.empty((Ordering)this.ordering());
    }

    @Override
    public TreeSet<A> range(A from, A until) {
        return this.newSet(RedBlackTree$.MODULE$.range(this.tree, from, until, this.ordering()));
    }

    @Override
    public TreeSet<A> rangeImpl(Option<A> from, Option<A> until) {
        return this.newSet(RedBlackTree$.MODULE$.rangeImpl(this.tree, from, until, this.ordering()));
    }

    @Override
    public TreeSet<A> incl(A elem) {
        return this.newSet(RedBlackTree$.MODULE$.update(this.tree, elem, BoxedUnit.UNIT, false, this.ordering()));
    }

    @Override
    public TreeSet<A> excl(A elem) {
        return !RedBlackTree$.MODULE$.contains(this.tree, elem, this.ordering()) ? this : this.newSet(RedBlackTree$.MODULE$.delete(this.tree, elem, this.ordering()));
    }
}

