/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.mutable;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.compat.java8.JProcedure1;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import strawman.collection.ArrayOps;
import strawman.collection.IterableFactory$;
import strawman.collection.Iterator;
import strawman.collection.immutable.List$;
import strawman.collection.mutable.HashEntry;
import strawman.collection.mutable.HashTable$;
import strawman.collection.package$;
import strawman.collection.package$DebugUtils$;

public abstract class HashTable<A, B, Entry extends HashEntry<A, Entry>>
implements HashUtils<A> {
    private transient int _loadFactor = HashTable$.MODULE$.defaultLoadFactor();
    private transient HashEntry[] table = new HashEntry[this.initialCapacity()];
    private transient int tableSize = 0;
    private transient int threshold = this.initialThreshold(this._loadFactor());
    private transient int[] sizemap = null;
    private transient int seedvalue = this.tableSizeSeed();

    public static int sizeForThreshold(int n, int n2) {
        return HashTable$.MODULE$.sizeForThreshold(n, n2);
    }

    public static int newThreshold(int n, int n2) {
        return HashTable$.MODULE$.newThreshold(n, n2);
    }

    public static int nextPositivePowerOfTwo(int n) {
        return HashTable$.MODULE$.nextPositivePowerOfTwo(n);
    }

    public static int loadFactorDenum() {
        return HashTable$.MODULE$.loadFactorDenum();
    }

    public static int defaultLoadFactor() {
        return HashTable$.MODULE$.defaultLoadFactor();
    }

    public static int capacity(int n) {
        return HashTable$.MODULE$.capacity(n);
    }

    public int _loadFactor() {
        return this._loadFactor;
    }

    public void _loadFactor_$eq(int x$1) {
        this._loadFactor = x$1;
    }

    public HashEntry<A, Entry>[] table() {
        return this.table;
    }

    public void table_$eq(HashEntry<A, Entry>[] x$1) {
        this.table = x$1;
    }

    public int tableSize() {
        return this.tableSize;
    }

    public void tableSize_$eq(int x$1) {
        this.tableSize = x$1;
    }

    public final int size() {
        return this.tableSize();
    }

    public int threshold() {
        return this.threshold;
    }

    public void threshold_$eq(int x$1) {
        this.threshold = x$1;
    }

    public int[] sizemap() {
        return this.sizemap;
    }

    public void sizemap_$eq(int[] x$1) {
        this.sizemap = x$1;
    }

    public int seedvalue() {
        return this.seedvalue;
    }

    public void seedvalue_$eq(int x$1) {
        this.seedvalue = x$1;
    }

    public int tableSizeSeed() {
        return Integer.bitCount(this.table().length - 1);
    }

    public int initialSize() {
        return 16;
    }

    private int initialThreshold(int _loadFactor) {
        return HashTable$.MODULE$.newThreshold(_loadFactor, this.initialCapacity());
    }

    private int initialCapacity() {
        return HashTable$.MODULE$.capacity(this.initialSize());
    }

    /*
     * WARNING - void declaration
     */
    public int strawman$collection$mutable$HashTable$$lastPopulatedIndex() {
        void var1_1;
        for (int idx = this.table().length - 1; this.table()[idx] == null && idx > 0; --idx) {
        }
        return (int)var1_1;
    }

    public void init(ObjectInputStream in, Function0<Entry> readEntry) {
        in.defaultReadObject();
        this._loadFactor_$eq(in.readInt());
        Predef$.MODULE$.assert(this._loadFactor() > 0);
        int size = in.readInt();
        this.tableSize_$eq(0);
        Predef$.MODULE$.assert(size >= 0);
        this.seedvalue_$eq(in.readInt());
        boolean smDefined = in.readBoolean();
        this.table_$eq(new HashEntry[HashTable$.MODULE$.capacity(HashTable$.MODULE$.sizeForThreshold(this._loadFactor(), size))]);
        this.threshold_$eq(HashTable$.MODULE$.newThreshold(this._loadFactor(), this.table().length));
        if (smDefined) {
            this.sizeMapInit(this.table().length);
        } else {
            this.sizemap_$eq(null);
        }
        for (int index = 0; index < size; ++index) {
            this.addEntry((HashEntry)readEntry.apply());
        }
    }

    public void serializeTo(ObjectOutputStream out, Function1<Entry, BoxedUnit> writeEntry) {
        out.defaultWriteObject();
        out.writeInt(this._loadFactor());
        out.writeInt(this.tableSize());
        out.writeInt(this.seedvalue());
        out.writeBoolean(this.isSizeMapDefined());
        this.foreachEntry(writeEntry);
    }

    public final Entry findEntry(A key) {
        return this.findEntry0(key, this.index(this.elemHashCode(key)));
    }

    /*
     * WARNING - void declaration
     */
    public final Entry findEntry0(A key, int h) {
        void var3_3;
        for (HashEntry<A, Object> e = this.table()[h]; e != null && !this.elemEquals(e.key(), key); e = e.next()) {
        }
        return var3_3;
    }

    public final void addEntry(Entry e) {
        this.addEntry0(e, this.index(this.elemHashCode(e.key())));
    }

    public final void addEntry0(Entry e, int h) {
        block0: {
            e.next_$eq(this.table()[h]);
            this.table()[h] = e;
            this.tableSize_$eq(this.tableSize() + 1);
            this.nnSizeMapAdd(h);
            if (this.tableSize() <= this.threshold()) break block0;
            this.resize(2 * this.table().length);
        }
    }

    public void addEntry2(Entry e, int h) {
        e.next_$eq(this.table()[h]);
        this.table()[h] = e;
        this.tableSize_$eq(this.tableSize() + 1);
        this.nnSizeMapAdd(h);
    }

    public Entry findOrAddEntry(A key, B value) {
        Entry Entry2;
        int h = this.index(this.elemHashCode(key));
        Entry e = this.findEntry0(key, h);
        if (e != null) {
            Entry2 = e;
        } else {
            this.addEntry0(this.createNewEntry(key, value), h);
            Entry2 = null;
        }
        return Entry2;
    }

    public abstract Entry createNewEntry(A var1, B var2);

    public final Entry removeEntry(A key) {
        int h = this.index(this.elemHashCode(key));
        HashEntry<A, Object> e = this.table()[h];
        if (e != null) {
            Object e1;
            if (this.elemEquals(e.key(), key)) {
                this.table()[h] = e.next();
                this.tableSize_$eq(this.tableSize() - 1);
                this.nnSizeMapRemove(h);
                e.next_$eq(null);
                return (Entry)e;
            }
            for (e1 = e.next(); e1 != null && !this.elemEquals(e1.key(), key); e1 = e1.next()) {
                e = e1;
            }
            if (e1 != null) {
                e.next_$eq(e1.next());
                this.tableSize_$eq(this.tableSize() - 1);
                this.nnSizeMapRemove(h);
                e1.next_$eq(null);
                return (Entry)e1;
            }
        }
        return null;
    }

    public Iterator<Entry> entriesIterator() {
        return new Iterator<Entry>(this){
            private final HashEntry[] iterTable;
            private int idx;
            private HashEntry es;
            private final HashTable $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.iterTable = this.strawman$collection$mutable$HashTable$_$$anon$$$outer().table();
                this.idx = this.strawman$collection$mutable$HashTable$_$$anon$$$outer().strawman$collection$mutable$HashTable$$lastPopulatedIndex();
                this.es = this.iterTable()[this.idx()];
            }

            public HashEntry<A, Entry>[] iterTable() {
                return this.iterTable;
            }

            public int idx() {
                return this.idx;
            }

            public void idx_$eq(int x$1) {
                this.idx = x$1;
            }

            public HashEntry<A, Entry> es() {
                return this.es;
            }

            public void es_$eq(HashEntry<A, Entry> x$1) {
                this.es = x$1;
            }

            public boolean hasNext() {
                return this.es() != null;
            }

            public Entry next() {
                HashEntry<A, Entry> res = this.es();
                this.es_$eq((HashEntry<A, Entry>)this.es().next());
                while (this.es() == null && this.idx() > 0) {
                    this.idx_$eq(this.idx() - 1);
                    this.es_$eq(this.iterTable()[this.idx()]);
                }
                return (Entry)res;
            }

            private HashTable<A, B, Entry> $outer() {
                return this.$outer;
            }

            public final HashTable<A, B, Entry> strawman$collection$mutable$HashTable$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    public <U> void foreachEntry(Function1<Entry, U> f) {
        HashEntry<A, Entry>[] iterTable = this.table();
        int idx = this.strawman$collection$mutable$HashTable$$lastPopulatedIndex();
        HashEntry<A, Object> es = iterTable[idx];
        while (es != null) {
            Entry next = es.next();
            f.apply(es);
            es = next;
            while (es == null && idx > 0) {
                es = iterTable[--idx];
            }
        }
    }

    public void clearTable() {
        for (int i = this.table().length - 1; i >= 0; --i) {
            this.table()[i] = null;
        }
        this.tableSize_$eq(0);
        this.nnSizeMapReset(0);
    }

    private void resize(int newSize) {
        HashEntry<A, Entry>[] oldTable = this.table();
        this.table_$eq(new HashEntry[newSize]);
        this.nnSizeMapReset(this.table().length);
        for (int i = oldTable.length - 1; i >= 0; --i) {
            HashEntry<A, Object> e = oldTable[i];
            while (e != null) {
                int h = this.index(this.elemHashCode(e.key()));
                Entry e1 = e.next();
                e.next_$eq(this.table()[h]);
                this.table()[h] = e;
                e = e1;
                this.nnSizeMapAdd(h);
            }
        }
        this.threshold_$eq(HashTable$.MODULE$.newThreshold(this._loadFactor(), newSize));
    }

    public final void nnSizeMapAdd(int h) {
        block0: {
            if (this.sizemap() == null) break block0;
            int[] $65$ = this.sizemap();
            int i$5 = h >> this.sizeMapBucketBitSize();
            $65$[i$5] = $65$[i$5] + 1;
        }
    }

    public final void nnSizeMapRemove(int h) {
        block0: {
            if (this.sizemap() == null) break block0;
            int[] $66$ = this.sizemap();
            int i$6 = h >> this.sizeMapBucketBitSize();
            $66$[i$6] = $66$[i$6] - 1;
        }
    }

    public final void nnSizeMapReset(int tableLength) {
        block2: {
            if (this.sizemap() == null) break block2;
            int nsize = this.calcSizeMapSize(tableLength);
            if (this.sizemap().length != nsize) {
                this.sizemap_$eq(new int[nsize]);
            } else {
                Arrays.fill(this.sizemap(), 0);
            }
        }
    }

    public final int totalSizeMapBuckets() {
        return this.sizeMapBucketSize() < this.table().length ? 1 : this.table().length / this.sizeMapBucketSize();
    }

    public final int calcSizeMapSize(int tableLength) {
        return (tableLength >> this.sizeMapBucketBitSize()) + 1;
    }

    public void sizeMapInit(int tableLength) {
        this.sizemap_$eq(new int[this.calcSizeMapSize(tableLength)]);
    }

    public final void sizeMapInitAndRebuild() {
        this.sizeMapInit(this.table().length);
        int tableidx = 0;
        HashEntry<A, Entry>[] tbl = this.table();
        int tableuntil = 0;
        tableuntil = tbl.length < this.sizeMapBucketSize() ? tbl.length : this.sizeMapBucketSize();
        int totalbuckets = this.totalSizeMapBuckets();
        for (int bucketidx = 0; bucketidx < totalbuckets; ++bucketidx) {
            int currbucketsize = 0;
            while (tableidx < tableuntil) {
                for (HashEntry<A, Object> e = tbl[tableidx]; e != null; e = e.next()) {
                    ++currbucketsize;
                }
                ++tableidx;
            }
            this.sizemap()[bucketidx] = currbucketsize;
            tableuntil += this.sizeMapBucketSize();
        }
    }

    public void printSizeMap() {
        Predef$.MODULE$.println(new ArrayOps(package$.MODULE$.arrayToArrayOps(this.sizemap())).to(IterableFactory$.MODULE$.toFactory(List$.MODULE$)));
    }

    public final void sizeMapDisable() {
        this.sizemap_$eq(null);
    }

    public final boolean isSizeMapDefined() {
        return this.sizemap() != null;
    }

    public boolean alwaysInitSizeMap() {
        return false;
    }

    public boolean elemEquals(A key1, A key2) {
        return BoxesRunTime.equals(key1, key2);
    }

    public final int index(int hcode) {
        int ones = this.table().length - 1;
        int exponent = Integer.numberOfLeadingZeros(ones);
        return this.improve(hcode, this.seedvalue()) >>> exponent & ones;
    }

    public void initWithContents(Contents<A, Entry> c) {
        block1: {
            if (c != null) {
                this._loadFactor_$eq(c.loadFactor());
                this.table_$eq(c.table());
                this.tableSize_$eq(c.tableSize());
                this.threshold_$eq(c.threshold());
                this.seedvalue_$eq(c.seedvalue());
                this.sizemap_$eq(c.sizemap());
            }
            if (!this.alwaysInitSizeMap() || this.sizemap() != null) break block1;
            this.sizeMapInitAndRebuild();
        }
    }

    public Contents<A, Entry> hashTableContents() {
        return new Contents<A, Entry>(this._loadFactor(), this.table(), this.tableSize(), this.threshold(), this.seedvalue(), this.sizemap());
    }

    public static class Contents<A, Entry extends HashEntry<A, Entry>> {
        private final int loadFactor;
        private final HashEntry[] table;
        private final int tableSize;
        private final int threshold;
        private final int seedvalue;
        private final int[] sizemap;

        public <A, Entry extends HashEntry<A, Entry>> Contents(int loadFactor, HashEntry<A, Entry>[] table, int tableSize, int threshold, int seedvalue, int[] sizemap) {
            this.loadFactor = loadFactor;
            this.table = table;
            this.tableSize = tableSize;
            this.threshold = threshold;
            this.seedvalue = seedvalue;
            this.sizemap = sizemap;
        }

        public int loadFactor() {
            return this.loadFactor;
        }

        public HashEntry<A, Entry>[] table() {
            return this.table;
        }

        public int tableSize() {
            return this.tableSize;
        }

        public int threshold() {
            return this.threshold;
        }

        public int seedvalue() {
            return this.seedvalue;
        }

        public int[] sizemap() {
            return this.sizemap;
        }

        public String debugInformation() {
            return package$DebugUtils$.MODULE$.buildString((Function1<Function1<Object, BoxedUnit>, BoxedUnit>)((JProcedure1)this::debugInformation$$anonfun$1));
        }

        private void debugInformation$$anonfun$1(Function1<Object, BoxedUnit> append) {
            append.apply((Object)"Hash table contents");
            append.apply((Object)"-------------------");
            append.apply((Object)("Table: [" + package$DebugUtils$.MODULE$.arrayString(this.table(), 0, this.table().length) + "]"));
            append.apply((Object)("Table size: " + this.tableSize()));
            append.apply((Object)("Load factor: " + this.loadFactor()));
            append.apply((Object)("Seedvalue: " + this.seedvalue()));
            append.apply((Object)("Threshold: " + this.threshold()));
            append.apply((Object)("Sizemap: [" + package$DebugUtils$.MODULE$.arrayString(this.sizemap(), 0, this.sizemap().length) + "]"));
        }
    }

    public static interface HashUtils<KeyType> {
        default public int sizeMapBucketBitSize() {
            return 5;
        }

        default public int sizeMapBucketSize() {
            return 1 << this.sizeMapBucketBitSize();
        }

        default public int elemHashCode(KeyType key) {
            return Statics.anyHash(key);
        }

        default public int improve(int hcode, int seed) {
            return Integer.rotateRight(scala.util.hashing.package$.MODULE$.byteswap32(hcode), seed);
        }
    }
}

