/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.mutable;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.compat.java8.JProcedure1;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing;
import strawman.collection.IterableFactory;
import strawman.collection.IterableOnce;
import strawman.collection.Iterator;
import strawman.collection.Iterator$;
import strawman.collection.Map;
import strawman.collection.MapFactory;
import strawman.collection.MapOps;
import strawman.collection.Set;
import strawman.collection.StrictOptimizedIterableOps;
import strawman.collection.mutable.Builder;
import strawman.collection.mutable.HashEntry;
import strawman.collection.mutable.HashTable;
import strawman.collection.mutable.Iterable;
import strawman.collection.mutable.LinkedHashMap$;
import strawman.collection.mutable.LinkedHashSet$;

public class LinkedHashMap<K, V>
implements strawman.collection.mutable.Map<K, V>,
StrictOptimizedIterableOps<Tuple2<K, V>, Iterable, LinkedHashMap<K, V>>,
Serializable {
    private final HashTable<K, V, LinkedEntry<K, V>> table;
    private transient LinkedEntry firstEntry;
    private transient LinkedEntry lastEntry;

    public static <K, V> Builder<Tuple2<K, V>, LinkedHashMap<K, V>> newBuilder() {
        return LinkedHashMap$.MODULE$.newBuilder();
    }

    public static <K, V> LinkedHashMap<K, V> from(IterableOnce<Tuple2<K, V>> iterableOnce) {
        return LinkedHashMap$.MODULE$.from((IterableOnce)iterableOnce);
    }

    public <K, V> LinkedHashMap() {
        Function1.$init$((Function1)this);
        PartialFunction.$init$((PartialFunction)this);
        this.table = new HashTable<K, V, LinkedEntry<K, V>>(this){
            private final LinkedHashMap $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            /*
             * WARNING - void declaration
             */
            public LinkedEntry<K, V> createNewEntry(K key, V value) {
                void var3_3;
                LinkedEntry<K, V> e = new LinkedEntry<K, V>(key, value);
                if (this.strawman$collection$mutable$LinkedHashMap$_$$anon$$$outer().firstEntry() == null) {
                    this.strawman$collection$mutable$LinkedHashMap$_$$anon$$$outer().firstEntry_$eq(e);
                } else {
                    this.strawman$collection$mutable$LinkedHashMap$_$$anon$$$outer().lastEntry().later_$eq(e);
                    e.earlier_$eq(this.strawman$collection$mutable$LinkedHashMap$_$$anon$$$outer().lastEntry());
                }
                this.strawman$collection$mutable$LinkedHashMap$_$$anon$$$outer().lastEntry_$eq(e);
                return var3_3;
            }

            public <U> void foreachEntry(Function1<LinkedEntry<K, V>, U> f) {
                for (LinkedEntry<K, V> cur = this.strawman$collection$mutable$LinkedHashMap$_$$anon$$$outer().firstEntry(); cur != null; cur = cur.later()) {
                    f.apply((Object)cur);
                }
            }

            private LinkedHashMap<K, V> $outer() {
                return this.$outer;
            }

            public final LinkedHashMap<K, V> strawman$collection$mutable$LinkedHashMap$_$$anon$$$outer() {
                return this.$outer();
            }
        };
        this.firstEntry = null;
        this.lastEntry = null;
    }

    public <A> Function1<A, V> compose(Function1<A, K> g) {
        return Function1.compose$((Function1)this, g);
    }

    public <A1 extends K, B1> PartialFunction<A1, B1> orElse(PartialFunction<A1, B1> that) {
        return PartialFunction.orElse$((PartialFunction)this, that);
    }

    public <C> PartialFunction<K, C> andThen(Function1<V, C> k) {
        return PartialFunction.andThen$((PartialFunction)this, k);
    }

    public Function1<K, Option<V>> lift() {
        return PartialFunction.lift$((PartialFunction)this);
    }

    public <U> Function1<K, Object> runWith(Function1<V, U> action) {
        return PartialFunction.runWith$((PartialFunction)this, action);
    }

    @Override
    public <K1 extends K, V1> V1 applyOrElse(K1 x, Function1<K1, V1> function1) {
        return MapOps.super.applyOrElse(x, function1);
    }

    @Override
    public MapOps.MapWithFilter withFilter(Function1<Tuple2<K, V>, Object> p) {
        return MapOps.super.withFilter(p);
    }

    @Override
    public String toString() {
        return MapOps.super.toString();
    }

    @Override
    public String mkString(String start, String sep, String end) {
        return MapOps.super.mkString(start, sep, end);
    }

    @Override
    public boolean equals(Object o) {
        return Map.super.equals(o);
    }

    @Override
    public int hashCode() {
        return Map.super.hashCode();
    }

    @Override
    public /* synthetic */ Object strawman$collection$mutable$Cloneable$$super$clone() {
        return super.clone();
    }

    @Override
    public LinkedHashMap<K, V> clone() {
        return (LinkedHashMap)strawman.collection.mutable.MapOps.super.clone();
    }

    @Override
    public Tuple2<LinkedHashMap<K, V>, LinkedHashMap<K, V>> partition(Function1<Tuple2<K, V>, Object> p) {
        return StrictOptimizedIterableOps.super.partition(p);
    }

    @Override
    public Tuple2<LinkedHashMap<K, V>, LinkedHashMap<K, V>> span(Function1<Tuple2<K, V>, Object> p) {
        return StrictOptimizedIterableOps.super.span(p);
    }

    @Override
    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<Tuple2<K, V>, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.super.unzip(asPair);
    }

    @Override
    public <B> Iterable<B> map(Function1<Tuple2<K, V>, B> f) {
        return (Iterable)StrictOptimizedIterableOps.super.map(f);
    }

    @Override
    public <B> Iterable<B> flatMap(Function1<Tuple2<K, V>, IterableOnce<B>> f) {
        return (Iterable)StrictOptimizedIterableOps.super.flatMap(f);
    }

    @Override
    public <B> Iterable<B> collect(PartialFunction<Tuple2<K, V>, B> pf) {
        return (Iterable)StrictOptimizedIterableOps.super.collect(pf);
    }

    @Override
    public <B> Iterable<B> flatten(Function1<Tuple2<K, V>, IterableOnce<B>> toIterableOnce) {
        return (Iterable)StrictOptimizedIterableOps.super.flatten(toIterableOnce);
    }

    @Override
    public <B> Iterable<Tuple2<Tuple2<K, V>, B>> zip(strawman.collection.Iterable<B> that) {
        return (Iterable)StrictOptimizedIterableOps.super.zip(that);
    }

    @Override
    public Iterable<Tuple2<Tuple2<K, V>, Object>> zipWithIndex() {
        return (Iterable)StrictOptimizedIterableOps.super.zipWithIndex();
    }

    @Override
    public <B> Iterable<B> scanLeft(B z, Function2<B, Tuple2<K, V>, B> op) {
        return (Iterable)StrictOptimizedIterableOps.super.scanLeft(z, op);
    }

    @Override
    public LinkedHashMap<K, V> filter(Function1<Tuple2<K, V>, Object> pred) {
        return (LinkedHashMap)StrictOptimizedIterableOps.super.filter(pred);
    }

    @Override
    public LinkedHashMap<K, V> filterNot(Function1<Tuple2<K, V>, Object> pred) {
        return (LinkedHashMap)StrictOptimizedIterableOps.super.filterNot(pred);
    }

    @Override
    public LinkedHashMap<K, V> empty() {
        return LinkedHashMap$.MODULE$.empty();
    }

    @Override
    public int size() {
        return this.table.tableSize();
    }

    public LinkedEntry firstEntry() {
        return this.firstEntry;
    }

    public void firstEntry_$eq(LinkedEntry x$1) {
        this.firstEntry = x$1;
    }

    public LinkedEntry lastEntry() {
        return this.lastEntry;
    }

    public void lastEntry_$eq(LinkedEntry x$1) {
        this.lastEntry = x$1;
    }

    @Override
    public MapFactory<LinkedHashMap> mapFactory() {
        return LinkedHashMap$.MODULE$;
    }

    @Override
    public LinkedHashMap<K, V> fromSpecificIterable(strawman.collection.Iterable<Tuple2<K, V>> coll) {
        return this.mapFromIterable(coll);
    }

    @Override
    public <K2, V2> LinkedHashMap<K2, V2> mapFromIterable(strawman.collection.Iterable<Tuple2<K2, V2>> it) {
        return this.mapFactory().from(it);
    }

    @Override
    public Builder<Tuple2<K, V>, LinkedHashMap<K, V>> newSpecificBuilder() {
        return this.mapFactory().newBuilder();
    }

    @Override
    public Option<V> get(K key) {
        LinkedEntry<K, V> e = this.table.findEntry(key);
        return e == null ? None$.MODULE$ : Some$.MODULE$.apply(e.value());
    }

    @Override
    public Option<V> put(K key, V value) {
        None$ none$;
        LinkedEntry<K, V> e = this.table.findOrAddEntry(key, value);
        if (e == null) {
            none$ = None$.MODULE$;
        } else {
            V v = e.value();
            e.value_$eq(value);
            none$ = Some$.MODULE$.apply(v);
        }
        return none$;
    }

    @Override
    public Option<V> remove(K key) {
        None$ none$;
        LinkedEntry e = this.table.removeEntry(key);
        if (e == null) {
            none$ = None$.MODULE$;
        } else {
            if (e.earlier() == null) {
                this.firstEntry_$eq(e.later());
            } else {
                e.earlier().later_$eq(e.later());
            }
            if (e.later() == null) {
                this.lastEntry_$eq(e.earlier());
            } else {
                e.later().earlier_$eq(e.earlier());
            }
            e.earlier_$eq(null);
            e.later_$eq(null);
            none$ = Some$.MODULE$.apply(e.value());
        }
        return none$;
    }

    public LinkedHashMap addOne(Tuple2<K, V> kv) {
        this.put(kv._1(), kv._2());
        return this;
    }

    public LinkedHashMap subtractOne(K key) {
        this.remove(key);
        return this;
    }

    @Override
    public Iterator<Tuple2<K, V>> iterator() {
        return new Iterator<Tuple2<K, V>>(this){
            private LinkedEntry cur;
            private final LinkedHashMap $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.cur = this.strawman$collection$mutable$LinkedHashMap$_$$anon$$$outer().firstEntry();
            }

            private LinkedEntry cur() {
                return this.cur;
            }

            private void cur_$eq(LinkedEntry x$1) {
                this.cur = x$1;
            }

            public boolean hasNext() {
                return this.cur() != null;
            }

            /*
             * WARNING - void declaration
             */
            public Tuple2<K, V> next() {
                Tuple2 tuple2;
                if (this.hasNext()) {
                    void var1_1;
                    Tuple2 res = Tuple2$.MODULE$.apply(this.cur().key(), this.cur().value());
                    this.cur_$eq(this.cur().later());
                    tuple2 = var1_1;
                } else {
                    tuple2 = (Tuple2)Iterator$.MODULE$.empty().next();
                }
                return tuple2;
            }

            private LinkedHashMap<K, V> $outer() {
                return this.$outer;
            }

            public final LinkedHashMap<K, V> strawman$collection$mutable$LinkedHashMap$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    @Override
    public Set<K> keySet() {
        return new LinkedKeySet(this);
    }

    @Override
    public Iterator<K> keysIterator() {
        return new Iterator<K>(this){
            private LinkedEntry cur;
            private final LinkedHashMap $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.cur = this.strawman$collection$mutable$LinkedHashMap$_$$anon$$$outer().firstEntry();
            }

            private LinkedEntry cur() {
                return this.cur;
            }

            private void cur_$eq(LinkedEntry x$1) {
                this.cur = x$1;
            }

            public boolean hasNext() {
                return this.cur() != null;
            }

            /*
             * WARNING - void declaration
             */
            public K next() {
                Nothing nothing;
                if (this.hasNext()) {
                    void var1_1;
                    K res = this.cur().key();
                    this.cur_$eq(this.cur().later());
                    nothing = var1_1;
                } else {
                    nothing = Iterator$.MODULE$.empty().next();
                }
                return (K)nothing;
            }

            private LinkedHashMap<K, V> $outer() {
                return this.$outer;
            }

            public final LinkedHashMap<K, V> strawman$collection$mutable$LinkedHashMap$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    @Override
    public Iterator<V> valuesIterator() {
        return new Iterator<V>(this){
            private LinkedEntry cur;
            private final LinkedHashMap $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.cur = this.strawman$collection$mutable$LinkedHashMap$_$$anon$$$outer().firstEntry();
            }

            private LinkedEntry cur() {
                return this.cur;
            }

            private void cur_$eq(LinkedEntry x$1) {
                this.cur = x$1;
            }

            public boolean hasNext() {
                return this.cur() != null;
            }

            /*
             * WARNING - void declaration
             */
            public V next() {
                Nothing nothing;
                if (this.hasNext()) {
                    void var1_1;
                    V res = this.cur().value();
                    this.cur_$eq(this.cur().later());
                    nothing = var1_1;
                } else {
                    nothing = Iterator$.MODULE$.empty().next();
                }
                return (V)nothing;
            }

            private LinkedHashMap<K, V> $outer() {
                return this.$outer;
            }

            public final LinkedHashMap<K, V> strawman$collection$mutable$LinkedHashMap$_$$anon$$$outer() {
                return this.$outer();
            }
        };
    }

    @Override
    public <U> void foreach(Function1<Tuple2<K, V>, U> f) {
        for (LinkedEntry cur = this.firstEntry(); cur != null; cur = cur.later()) {
            f.apply((Object)Tuple2$.MODULE$.apply(cur.key(), cur.value()));
        }
    }

    @Override
    public void clear() {
        this.table.clearTable();
        this.firstEntry_$eq(null);
        this.lastEntry_$eq(null);
    }

    private void writeObject(ObjectOutputStream out) {
        this.table.serializeTo(out, (Function1<LinkedEntry<K, V>, BoxedUnit>)((JProcedure1)arg_0 -> LinkedHashMap.writeObject$$anonfun$1(out, arg_0)));
    }

    private void readObject(ObjectInputStream in) {
        this.firstEntry_$eq(null);
        this.lastEntry_$eq(null);
        this.table.init(in, () -> this.readObject$$anonfun$1(in));
    }

    private static void writeObject$$anonfun$1(ObjectOutputStream out$3, LinkedEntry entry) {
        out$3.writeObject(entry.key());
        out$3.writeObject(entry.value());
    }

    private LinkedEntry readObject$$anonfun$1(ObjectInputStream in$2) {
        return this.table.createNewEntry(in$2.readObject(), in$2.readObject());
    }

    public static final class LinkedEntry<K, V>
    implements HashEntry<K, LinkedEntry<K, V>>,
    Serializable {
        private HashEntry next;
        private final Object key;
        private Object value;
        private LinkedEntry earlier;
        private LinkedEntry later;

        public <K, V> LinkedEntry(K key, V value) {
            this.key = key;
            this.value = value;
            this.next = HashEntry.super.initial$next();
            this.earlier = null;
            this.later = null;
        }

        @Override
        public HashEntry next() {
            return this.next;
        }

        @Override
        public void next_$eq(HashEntry x$1) {
            this.next = x$1;
        }

        @Override
        public K key() {
            return (K)this.key;
        }

        public V value() {
            return (V)this.value;
        }

        public void value_$eq(V x$1) {
            this.value = x$1;
        }

        public LinkedEntry<K, V> earlier() {
            return this.earlier;
        }

        public void earlier_$eq(LinkedEntry<K, V> x$1) {
            this.earlier = x$1;
        }

        public LinkedEntry<K, V> later() {
            return this.later;
        }

        public void later_$eq(LinkedEntry<K, V> x$1) {
            this.later = x$1;
        }
    }

    public static class LinkedKeySet
    extends MapOps.KeySet {
        private final LinkedHashMap $outer;

        public LinkedKeySet(LinkedHashMap $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer);
        }

        @Override
        public IterableFactory<Set> iterableFactory() {
            return LinkedHashSet$.MODULE$;
        }

        private LinkedHashMap<K, V> $outer() {
            return this.$outer;
        }

        public final LinkedHashMap<K, V> strawman$collection$mutable$LinkedHashMap$LinkedKeySet$$$outer() {
            return this.$outer();
        }
    }
}

