/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.mutable;

import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.math.Ordering;
import strawman.collection.IterableOnce;
import strawman.collection.Iterator;
import strawman.collection.Map;
import strawman.collection.MapFactory;
import strawman.collection.MapOps;
import strawman.collection.SortedMapFactory;
import strawman.collection.SortedMapOps;
import strawman.collection.SortedSet;
import strawman.collection.StrictOptimizedIterableOps;
import strawman.collection.mutable.Builder;
import strawman.collection.mutable.Iterable;
import strawman.collection.mutable.Map$;
import strawman.collection.mutable.RedBlackTree;
import strawman.collection.mutable.RedBlackTree$;
import strawman.collection.mutable.RedBlackTree$Tree$;
import strawman.collection.mutable.SortedMap;
import strawman.collection.mutable.TreeMap$;

public class TreeMap<K, V>
implements SortedMap<K, V>,
StrictOptimizedIterableOps<Tuple2<K, V>, Iterable, TreeMap<K, V>>,
Serializable {
    public final RedBlackTree.Tree<K, V> strawman$collection$mutable$TreeMap$$tree;
    private final Ordering ordering;

    public static <K, V> Builder<Tuple2<K, V>, TreeMap<K, V>> newBuilder(Ordering<K> ordering) {
        return TreeMap$.MODULE$.newBuilder(ordering);
    }

    public <K, V> TreeMap(RedBlackTree.Tree<K, V> tree, Ordering<K> ordering) {
        this.strawman$collection$mutable$TreeMap$$tree = tree;
        this.ordering = ordering;
        Function1.$init$((Function1)this);
        PartialFunction.$init$((PartialFunction)this);
    }

    public <A> Function1<A, V> compose(Function1<A, K> g) {
        return Function1.compose$((Function1)this, g);
    }

    public <A1 extends K, B1> PartialFunction<A1, B1> orElse(PartialFunction<A1, B1> that) {
        return PartialFunction.orElse$((PartialFunction)this, that);
    }

    public <C> PartialFunction<K, C> andThen(Function1<V, C> k) {
        return PartialFunction.andThen$((PartialFunction)this, k);
    }

    public Function1<K, Option<V>> lift() {
        return PartialFunction.lift$((PartialFunction)this);
    }

    public <U> Function1<K, Object> runWith(Function1<V, U> action) {
        return PartialFunction.runWith$((PartialFunction)this, action);
    }

    @Override
    public <K1 extends K, V1> V1 applyOrElse(K1 x, Function1<K1, V1> function1) {
        return MapOps.super.applyOrElse(x, function1);
    }

    @Override
    public String toString() {
        return MapOps.super.toString();
    }

    @Override
    public String mkString(String start, String sep, String end) {
        return MapOps.super.mkString(start, sep, end);
    }

    @Override
    public boolean equals(Object o) {
        return Map.super.equals(o);
    }

    @Override
    public int hashCode() {
        return Map.super.hashCode();
    }

    @Override
    public SortedSet<K> keySet() {
        return SortedMapOps.super.keySet();
    }

    @Override
    public SortedMapOps.SortedMapWithFilter withFilter(Function1<Tuple2<K, V>, Object> p) {
        return SortedMapOps.super.withFilter(p);
    }

    @Override
    public <V2> TreeMap<K, V2> concat(strawman.collection.Iterable<Tuple2<K, V2>> xs) {
        return (TreeMap)SortedMapOps.super.concat(xs);
    }

    @Override
    public <V2> TreeMap<K, V2> $plus$plus(strawman.collection.Iterable<Tuple2<K, V2>> xs) {
        return (TreeMap)SortedMapOps.super.$plus$plus(xs);
    }

    @Override
    public /* synthetic */ Object strawman$collection$mutable$Cloneable$$super$clone() {
        return super.clone();
    }

    @Override
    public TreeMap<K, V> clone() {
        return (TreeMap)strawman.collection.mutable.MapOps.super.clone();
    }

    @Override
    public Tuple2<TreeMap<K, V>, TreeMap<K, V>> partition(Function1<Tuple2<K, V>, Object> p) {
        return StrictOptimizedIterableOps.super.partition(p);
    }

    @Override
    public Tuple2<TreeMap<K, V>, TreeMap<K, V>> span(Function1<Tuple2<K, V>, Object> p) {
        return StrictOptimizedIterableOps.super.span(p);
    }

    @Override
    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<Tuple2<K, V>, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.super.unzip(asPair);
    }

    @Override
    public <B> Iterable<B> map(Function1<Tuple2<K, V>, B> f) {
        return (Iterable)StrictOptimizedIterableOps.super.map(f);
    }

    @Override
    public <B> Iterable<B> flatMap(Function1<Tuple2<K, V>, IterableOnce<B>> f) {
        return (Iterable)StrictOptimizedIterableOps.super.flatMap(f);
    }

    @Override
    public <B> Iterable<B> collect(PartialFunction<Tuple2<K, V>, B> pf) {
        return (Iterable)StrictOptimizedIterableOps.super.collect(pf);
    }

    @Override
    public <B> Iterable<B> flatten(Function1<Tuple2<K, V>, IterableOnce<B>> toIterableOnce) {
        return (Iterable)StrictOptimizedIterableOps.super.flatten(toIterableOnce);
    }

    @Override
    public <B> Iterable<Tuple2<Tuple2<K, V>, B>> zip(strawman.collection.Iterable<B> that) {
        return (Iterable)StrictOptimizedIterableOps.super.zip(that);
    }

    @Override
    public Iterable<Tuple2<Tuple2<K, V>, Object>> zipWithIndex() {
        return (Iterable)StrictOptimizedIterableOps.super.zipWithIndex();
    }

    @Override
    public <B> Iterable<B> scanLeft(B z, Function2<B, Tuple2<K, V>, B> op) {
        return (Iterable)StrictOptimizedIterableOps.super.scanLeft(z, op);
    }

    @Override
    public TreeMap<K, V> filter(Function1<Tuple2<K, V>, Object> pred) {
        return (TreeMap)StrictOptimizedIterableOps.super.filter(pred);
    }

    @Override
    public TreeMap<K, V> filterNot(Function1<Tuple2<K, V>, Object> pred) {
        return (TreeMap)StrictOptimizedIterableOps.super.filterNot(pred);
    }

    @Override
    public Ordering<K> ordering() {
        return this.ordering;
    }

    @Override
    public MapFactory<strawman.collection.mutable.Map> mapFactory() {
        return Map$.MODULE$;
    }

    @Override
    public SortedMapFactory<TreeMap> sortedMapFactory() {
        return TreeMap$.MODULE$;
    }

    public <K, V> TreeMap(Ordering<K> ord) {
        this(RedBlackTree$Tree$.MODULE$.empty(), ord);
    }

    @Override
    public TreeMap<K, V> fromSpecificIterable(strawman.collection.Iterable<Tuple2<K, V>> coll) {
        return TreeMap$.MODULE$.from(coll, (Ordering)this.ordering());
    }

    @Override
    public <K2, V2> TreeMap<K2, V2> sortedMapFromIterable(strawman.collection.Iterable<Tuple2<K2, V2>> it, Ordering<K2> ordering) {
        return TreeMap$.MODULE$.from(it, (Ordering)ordering);
    }

    @Override
    public Builder<Tuple2<K, V>, TreeMap<K, V>> newSpecificBuilder() {
        return TreeMap$.MODULE$.newBuilder(this.ordering());
    }

    @Override
    public Iterator<Tuple2<K, V>> iterator() {
        return RedBlackTree$.MODULE$.iterator(this.strawman$collection$mutable$TreeMap$$tree, RedBlackTree$.MODULE$.iterator$default$2(), RedBlackTree$.MODULE$.iterator$default$3(), this.ordering());
    }

    @Override
    public Iterator<K> keysIteratorFrom(K start) {
        return RedBlackTree$.MODULE$.keysIterator(this.strawman$collection$mutable$TreeMap$$tree, Some$.MODULE$.apply(start), RedBlackTree$.MODULE$.keysIterator$default$3(), this.ordering());
    }

    @Override
    public Iterator<Tuple2<K, V>> iteratorFrom(K start) {
        return RedBlackTree$.MODULE$.iterator(this.strawman$collection$mutable$TreeMap$$tree, Some$.MODULE$.apply(start), RedBlackTree$.MODULE$.iterator$default$3(), this.ordering());
    }

    @Override
    public Iterator<V> valuesIteratorFrom(K start) {
        return RedBlackTree$.MODULE$.valuesIterator(this.strawman$collection$mutable$TreeMap$$tree, Some$.MODULE$.apply(start), RedBlackTree$.MODULE$.valuesIterator$default$3(), this.ordering());
    }

    @Override
    public TreeMap<K, V> empty() {
        return TreeMap$.MODULE$.empty((Ordering)this.ordering());
    }

    public TreeMap addOne(Tuple2<K, V> elem) {
        RedBlackTree$.MODULE$.insert(this.strawman$collection$mutable$TreeMap$$tree, elem._1(), elem._2(), this.ordering());
        return this;
    }

    public TreeMap subtractOne(K elem) {
        RedBlackTree$.MODULE$.delete(this.strawman$collection$mutable$TreeMap$$tree, elem, this.ordering());
        return this;
    }

    @Override
    public void clear() {
        RedBlackTree$.MODULE$.clear(this.strawman$collection$mutable$TreeMap$$tree);
    }

    @Override
    public Option<V> get(K key) {
        return RedBlackTree$.MODULE$.get(this.strawman$collection$mutable$TreeMap$$tree, key, this.ordering());
    }

    @Override
    public TreeMap<K, V> rangeImpl(Option<K> from, Option<K> until) {
        return new TreeMapProjection(this, from, until);
    }

    @Override
    public <U> void foreach(Function1<Tuple2<K, V>, U> f) {
        RedBlackTree$.MODULE$.foreach(this.strawman$collection$mutable$TreeMap$$tree, f);
    }

    @Override
    public int size() {
        return RedBlackTree$.MODULE$.size(this.strawman$collection$mutable$TreeMap$$tree);
    }

    @Override
    public boolean isEmpty() {
        return RedBlackTree$.MODULE$.isEmpty(this.strawman$collection$mutable$TreeMap$$tree);
    }

    @Override
    public boolean contains(K key) {
        return RedBlackTree$.MODULE$.contains(this.strawman$collection$mutable$TreeMap$$tree, key, this.ordering());
    }

    @Override
    public Tuple2<K, V> head() {
        return (Tuple2)RedBlackTree$.MODULE$.min(this.strawman$collection$mutable$TreeMap$$tree).get();
    }

    @Override
    public Tuple2<K, V> last() {
        return (Tuple2)RedBlackTree$.MODULE$.max(this.strawman$collection$mutable$TreeMap$$tree).get();
    }

    @Override
    public Option<Tuple2<K, V>> minAfter(K key) {
        return RedBlackTree$.MODULE$.minAfter(this.strawman$collection$mutable$TreeMap$$tree, key, this.ordering());
    }

    @Override
    public Option<Tuple2<K, V>> maxBefore(K key) {
        return RedBlackTree$.MODULE$.maxBefore(this.strawman$collection$mutable$TreeMap$$tree, key, this.ordering());
    }

    @Override
    public String className() {
        return "TreeMap";
    }

    public RedBlackTree.Tree strawman$collection$mutable$TreeMap$$TreeMapProjection$superArg$1(Option<K> from, Option<K> until) {
        return this.strawman$collection$mutable$TreeMap$$tree;
    }

    public Ordering strawman$collection$mutable$TreeMap$$TreeMapProjection$superArg$2(Option<K> from, Option<K> until) {
        return this.ordering();
    }

    private static final class TreeMapProjection
    extends TreeMap<K, V> {
        private final Option<K> from;
        private final Option<K> until;
        private final TreeMap $outer;

        public TreeMapProjection(TreeMap $outer, Option<K> from, Option<K> until) {
            this.from = from;
            this.until = until;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer.strawman$collection$mutable$TreeMap$$TreeMapProjection$superArg$1(from, until), $outer.strawman$collection$mutable$TreeMap$$TreeMapProjection$superArg$2(from, until));
        }

        /*
         * Enabled aggressive block sorting
         */
        private Option<K> pickLowerBound(Option<K> newFrom) {
            Some some;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(this.from, newFrom);
            if (tuple2 != null) {
                Option option;
                Option option2 = (Option)tuple2._1();
                Option option3 = (Option)tuple2._2();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Object fr = some2.value();
                    if (option3 instanceof Some) {
                        Some some3 = (Some)option3;
                        Object newFr = some3.value();
                        some = Some$.MODULE$.apply(this.ordering().max(fr, newFr));
                        return some;
                    }
                    option = option2;
                } else {
                    option = option2;
                }
                if (None$.MODULE$.equals(option)) {
                    some = newFrom;
                    return some;
                }
            }
            some = this.from;
            return some;
        }

        /*
         * Enabled aggressive block sorting
         */
        private Option<K> pickUpperBound(Option<K> newUntil) {
            Some some;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(this.until, newUntil);
            if (tuple2 != null) {
                Option option;
                Option option2 = (Option)tuple2._1();
                Option option3 = (Option)tuple2._2();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Object unt = some2.value();
                    if (option3 instanceof Some) {
                        Some some3 = (Some)option3;
                        Object newUnt = some3.value();
                        some = Some$.MODULE$.apply(this.ordering().min(unt, newUnt));
                        return some;
                    }
                    option = option2;
                } else {
                    option = option2;
                }
                if (None$.MODULE$.equals(option)) {
                    some = newUntil;
                    return some;
                }
            }
            some = this.until;
            return some;
        }

        private boolean isInsideViewBounds(K key) {
            boolean afterFrom = this.from.isEmpty() || this.ordering().compare(this.from.get(), key) <= 0;
            boolean beforeUntil = this.until.isEmpty() || this.ordering().compare(key, this.until.get()) < 0;
            return afterFrom && beforeUntil;
        }

        @Override
        public TreeMap<K, V> rangeImpl(Option<K> from, Option<K> until) {
            return new TreeMapProjection(this.strawman$collection$mutable$TreeMap$TreeMapProjection$$$outer(), this.pickLowerBound(from), this.pickUpperBound(until));
        }

        @Override
        public Option<V> get(K key) {
            return this.isInsideViewBounds(key) ? RedBlackTree$.MODULE$.get(this.strawman$collection$mutable$TreeMap$TreeMapProjection$$$outer().strawman$collection$mutable$TreeMap$$tree, key, this.ordering()) : None$.MODULE$;
        }

        @Override
        public Iterator<Tuple2<K, V>> iterator() {
            return RedBlackTree$.MODULE$.iterator(this.strawman$collection$mutable$TreeMap$TreeMapProjection$$$outer().strawman$collection$mutable$TreeMap$$tree, this.from, this.until, this.ordering());
        }

        @Override
        public Iterator<K> keysIteratorFrom(K start) {
            return RedBlackTree$.MODULE$.keysIterator(this.strawman$collection$mutable$TreeMap$TreeMapProjection$$$outer().strawman$collection$mutable$TreeMap$$tree, this.pickLowerBound((Option)Some$.MODULE$.apply(start)), this.until, this.ordering());
        }

        @Override
        public Iterator<Tuple2<K, V>> iteratorFrom(K start) {
            return RedBlackTree$.MODULE$.iterator(this.strawman$collection$mutable$TreeMap$TreeMapProjection$$$outer().strawman$collection$mutable$TreeMap$$tree, this.pickLowerBound((Option)Some$.MODULE$.apply(start)), this.until, this.ordering());
        }

        @Override
        public Iterator<V> valuesIteratorFrom(K start) {
            return RedBlackTree$.MODULE$.valuesIterator(this.strawman$collection$mutable$TreeMap$TreeMapProjection$$$outer().strawman$collection$mutable$TreeMap$$tree, this.pickLowerBound((Option)Some$.MODULE$.apply(start)), this.until, this.ordering());
        }

        @Override
        public int size() {
            return this.iterator().length();
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public boolean contains(K key) {
            return this.isInsideViewBounds(key) && RedBlackTree$.MODULE$.contains(this.strawman$collection$mutable$TreeMap$TreeMapProjection$$$outer().strawman$collection$mutable$TreeMap$$tree, key, this.ordering());
        }

        @Override
        public Tuple2<K, V> head() {
            return (Tuple2)this.headOption().get();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Option<Tuple2<K, V>> headOption() {
            None$ none$;
            Object object = this.from.isDefined() ? RedBlackTree$.MODULE$.minAfter(this.strawman$collection$mutable$TreeMap$TreeMapProjection$$$outer().strawman$collection$mutable$TreeMap$$tree, this.from.get(), this.ordering()) : RedBlackTree$.MODULE$.min(this.strawman$collection$mutable$TreeMap$TreeMapProjection$$$outer().strawman$collection$mutable$TreeMap$$tree);
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(object, this.until);
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Tuple2 e = (Tuple2)some.value();
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        Object unt = some2.value();
                        if (this.ordering().compare(e._1(), unt) >= 0) {
                            none$ = None$.MODULE$;
                            return none$;
                        }
                    }
                }
            }
            none$ = object;
            return none$;
        }

        @Override
        public Tuple2<K, V> last() {
            return (Tuple2)this.lastOption().get();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Option<Tuple2<K, V>> lastOption() {
            None$ none$;
            Object object = this.until.isDefined() ? RedBlackTree$.MODULE$.maxBefore(this.strawman$collection$mutable$TreeMap$TreeMapProjection$$$outer().strawman$collection$mutable$TreeMap$$tree, this.until.get(), this.ordering()) : RedBlackTree$.MODULE$.max(this.strawman$collection$mutable$TreeMap$TreeMapProjection$$$outer().strawman$collection$mutable$TreeMap$$tree);
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(object, this.from);
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Tuple2 e = (Tuple2)some.value();
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        Object fr = some2.value();
                        if (this.ordering().compare(e._1(), fr) < 0) {
                            none$ = None$.MODULE$;
                            return none$;
                        }
                    }
                }
            }
            none$ = object;
            return none$;
        }

        @Override
        public <U> void foreach(Function1<Tuple2<K, V>, U> f) {
            this.iterator().foreach(f);
        }

        @Override
        public TreeMap<K, V> clone() {
            return ((TreeMap)strawman.collection.mutable.MapOps.super.clone()).rangeImpl(this.from, this.until);
        }

        private TreeMap<K, V> $outer() {
            return this.$outer;
        }

        public final TreeMap<K, V> strawman$collection$mutable$TreeMap$TreeMapProjection$$$outer() {
            return this.$outer();
        }
    }
}

