/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.immutable;

import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import strawman.collection.FromSpecificIterable;
import strawman.collection.IndexedSeqOps;
import strawman.collection.IndexedView;
import strawman.collection.Iterable;
import strawman.collection.IterableFactory;
import strawman.collection.IterableOnce;
import strawman.collection.IterableOps;
import strawman.collection.Iterator;
import strawman.collection.Seq;
import strawman.collection.StrictOptimizedIterableOps;
import strawman.collection.immutable.IndexedSeq;
import strawman.collection.immutable.IndexedSeq$;
import strawman.collection.immutable.Map;
import strawman.collection.immutable.Nil$;
import strawman.collection.immutable.Range$;
import strawman.collection.immutable.RangeIterator;
import strawman.collection.immutable.SeqOps;
import strawman.collection.mutable.Builder;

@ScalaSignature(bytes="\u0006\u0001\r\ra\u0001B\u0001\u0003\u0005%\u0011QAU1oO\u0016T!a\u0001\u0003\u0002\u0013%lW.\u001e;bE2,'BA\u0003\u0007\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002\u000f\u0005A1\u000f\u001e:bo6\fgn\u0001\u0001\u0014\r\u0001Q\u0001cF\u000e !\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fMB\u0019\u0011C\u0005\u000b\u000e\u0003\tI!a\u0005\u0002\u0003\u0015%sG-\u001a=fIN+\u0017\u000f\u0005\u0002\f+%\u0011a\u0003\u0004\u0002\u0004\u0013:$\b#B\t\u0019)i\u0001\u0012BA\r\u0003\u00055Ie\u000eZ3yK\u0012\u001cV-](qgB\u0011\u0011C\u0005\t\u00059u!\u0002#D\u0001\u0005\u0013\tqBA\u0001\u000eTiJL7\r^(qi&l\u0017N_3e\u0013R,'/\u00192mK>\u00038\u000f\u0005\u0002\fA%\u0011\u0011\u0005\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tG\u0001\u0011)\u0019!C\u0001I\u0005)1\u000f^1siV\tA\u0003\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003\u0015\u0003\u0019\u0019H/\u0019:uA!A\u0001\u0006\u0001BC\u0002\u0013\u0005A%A\u0002f]\u0012D\u0001B\u000b\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\u0005K:$\u0007\u0005\u0003\u0005-\u0001\t\u0015\r\u0011\"\u0001%\u0003\u0011\u0019H/\u001a9\t\u00119\u0002!\u0011!Q\u0001\nQ\tQa\u001d;fa\u0002B\u0001\u0002\r\u0001\u0003\u0006\u0004%\t!M\u0001\fSNLen\u00197vg&4X-F\u00013!\tY1'\u0003\u00025\u0019\t9!i\\8mK\u0006t\u0007\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\u0002\u0019%\u001c\u0018J\\2mkNLg/\u001a\u0011\t\u000ba\u0002A\u0011A\u001d\u0002\rqJg.\u001b;?)\u0015Q4\bP\u001f?!\t\t\u0002\u0001C\u0003$o\u0001\u0007A\u0003C\u0003)o\u0001\u0007A\u0003C\u0003-o\u0001\u0007A\u0003C\u00031o\u0001\u0007!\u0007C\u0003A\u0001\u0011\u0005\u0011)A\bji\u0016\u0014\u0018M\u00197f\r\u0006\u001cGo\u001c:z+\u0005\u0011\u0005c\u0001\u000fD5%\u0011A\t\u0002\u0002\u0010\u0013R,'/\u00192mK\u001a\u000b7\r^8ss\"1a\t\u0001Q\u0005\u0012\u001d\u000bAC\u001a:p[N\u0003XmY5gS\u000eLE/\u001a:bE2,GC\u0001\tI\u0011\u0015IU\t1\u0001K\u0003\u0011\u0019w\u000e\u001c7\u0011\u0007qYE#\u0003\u0002M\t\tA\u0011\n^3sC\ndW\r\u0003\u0004O\u0001\u0001&\tbT\u0001\u0013]\u0016<8\u000b]3dS\u001aL7MQ;jY\u0012,'\u000fF\u0001Q!\u0011\tF\u000b\u0006\t\u000e\u0003IS!a\u0015\u0003\u0002\u000f5,H/\u00192mK&\u0011QK\u0015\u0002\b\u0005VLG\u000eZ3s\u0011\u00159\u0006\u0001\"\u0001Y\u0003!IG/\u001a:bi>\u0014H#A-\u0011\u0007qQF#\u0003\u0002\\\t\tA\u0011\n^3sCR|'\u000fC\u0003^\u0001\u0011%a,A\u0002hCB,\u0012a\u0018\t\u0003\u0017\u0001L!!\u0019\u0007\u0003\t1{gn\u001a\u0005\u0006G\u0002!I!M\u0001\bSN,\u00050Y2u\u0011\u0015)\u0007\u0001\"\u00032\u0003\u001dA\u0017m]*uk\nDQa\u001a\u0001\u0005\ny\u000b!\u0002\\8oO2+gn\u001a;i\u0011\u001dI\u0007A1A\u0005BE\nq![:F[B$\u0018\u0010\u0003\u0004l\u0001\u0001\u0006IAM\u0001\tSN,U\u000e\u001d;zA!9Q\u000e\u0001b\u0001\n\u0003!\u0013A\u00027f]\u001e$\b\u000e\u0003\u0004p\u0001\u0001\u0006I\u0001F\u0001\bY\u0016tw\r\u001e5!\u0011\u001d\t\bA1A\u0005\n\u0011\n1\u0002\\1ti\u0016cW-\\3oi\"11\u000f\u0001Q\u0001\nQ\tA\u0002\\1ti\u0016cW-\\3oi\u0002BQ!\u001e\u0001\u0005B\u0011\nA\u0001\\1ti\")q\u000f\u0001C!I\u0005!\u0001.Z1e\u0011\u0015I\b\u0001\"\u0011{\u0003\u0011Ig.\u001b;\u0016\u0003iBQ\u0001 \u0001\u0005Bi\fA\u0001^1jY\")a\u0010\u0001C\t\u007f\u0006!1m\u001c9z)%Q\u0014\u0011AA\u0002\u0003\u000b\t9\u0001C\u0004${B\u0005\t\u0019\u0001\u000b\t\u000f!j\b\u0013!a\u0001)!9A& I\u0001\u0002\u0004!\u0002b\u0002\u0019~!\u0003\u0005\rA\r\u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0003\t\u0011\u0017\u0010F\u0002;\u0003\u001fAa\u0001LA\u0005\u0001\u0004!\u0002BBA\n\u0001\u0011\u0005C%\u0001\u0003tSj,\u0007bBA\f\u0001\u0011%\u0011\u0011D\u0001\u0012m\u0006d\u0017\u000eZ1uK6\u000b\u0007\u0010T3oORDGCAA\u000e!\rY\u0011QD\u0005\u0004\u0003?a!\u0001B+oSRDq!a\t\u0001\t\u0013\t)#A\u0006eKN\u001c'/\u001b9uS>tWCAA\u0014!\u0011\tI#a\u000e\u000f\t\u0005-\u00121\u0007\t\u0004\u0003[aQBAA\u0018\u0015\r\t\t\u0004C\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005UB\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003s\tYD\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003ka\u0001bBA \u0001\u0011%\u0011\u0011I\u0001\u0005M\u0006LG\u000e\u0006\u0002\u0002DA\u00191\"!\u0012\n\u0007\u0005\u001dCBA\u0004O_RD\u0017N\\4\t\u000f\u0005-\u0003\u0001\"\u0001\u0002N\u0005)\u0011\r\u001d9msR\u0019A#a\u0014\t\u000f\u0005E\u0013\u0011\na\u0001)\u0005\u0019\u0011\u000e\u001a=\t\u000f\u0005U\u0003\u0001\"\u0011\u0002X\u00059am\u001c:fC\u000eDW\u0003BA-\u0003S\"B!a\u0007\u0002\\!A\u0011QLA*\u0001\u0004\ty&A\u0001g!\u0019Y\u0011\u0011\r\u000b\u0002f%\u0019\u00111\r\u0007\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BA4\u0003Sb\u0001\u0001\u0002\u0007\u0002l\u0005M\u0003\u0015!A\u0001\u0006\u0004\tiGA\u0001V#\u0011\t\u0019%a\u001c\u0011\u0007-\t\t(C\u0002\u0002t1\u00111!\u00118zQ\u0019\tI'a\u001e\u0002~A\u00191\"!\u001f\n\u0007\u0005mDBA\u0006ta\u0016\u001c\u0017.\u00197ju\u0016$\u0017'C\u0012\u0002\u0000\u0005\u0005\u0015QQAB\u001d\rY\u0011\u0011Q\u0005\u0004\u0003\u0007c\u0011\u0001B+oSR\fd\u0001JAD\u0003\u0013ka\u0002BA\u0017\u0003\u0013K\u0011!\u0004\u0005\b\u0003\u001b\u0003A\u0011IAH\u0003\u0011!\u0018m[3\u0015\u0007i\n\t\nC\u0004\u0002\u0014\u0006-\u0005\u0019\u0001\u000b\u0002\u00039Dq!a&\u0001\t\u0003\nI*\u0001\u0003ee>\u0004Hc\u0001\u001e\u0002\u001c\"9\u00111SAK\u0001\u0004!\u0002bBAP\u0001\u0011\u0005\u0013\u0011U\u0001\ni\u0006\\WMU5hQR$2AOAR\u0011\u001d\t\u0019*!(A\u0002QAq!a*\u0001\t\u0003\nI+A\u0005ee>\u0004(+[4iiR\u0019!(a+\t\u000f\u0005M\u0015Q\u0015a\u0001)!9\u0011q\u0016\u0001\u0005\n\u0005E\u0016\u0001D1sOR\u000b7.Z,iS2,GcA0\u00024\"A\u0011QWAW\u0001\u0004\t9,A\u0001q!\u0015Y\u0011\u0011\r\u000b3\u0011\u001d\tY\f\u0001C!\u0003{\u000b\u0011\u0002^1lK^C\u0017\u000e\\3\u0015\u0007i\ny\f\u0003\u0005\u00026\u0006e\u0006\u0019AA\\\u0011\u001d\t\u0019\r\u0001C!\u0003\u000b\f\u0011\u0002\u001a:pa^C\u0017\u000e\\3\u0015\u0007i\n9\r\u0003\u0005\u00026\u0006\u0005\u0007\u0019AA\\\u0011\u001d\tY\r\u0001C!\u0003\u001b\fAa\u001d9b]R!\u0011qZAk!\u0015Y\u0011\u0011\u001b\u001e;\u0013\r\t\u0019\u000e\u0004\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005U\u0016\u0011\u001aa\u0001\u0003oCq!!7\u0001\t\u0003\nY.A\u0003tY&\u001cW\rF\u0003;\u0003;\f\t\u000fC\u0004\u0002`\u0006]\u0007\u0019\u0001\u000b\u0002\t\u0019\u0014x.\u001c\u0005\b\u0003G\f9\u000e1\u0001\u0015\u0003\u0015)h\u000e^5m\u0011\u001d\t9\u000f\u0001C!\u0003S\fqa\u001d9mSR\fE\u000f\u0006\u0003\u0002P\u0006-\bbBAJ\u0003K\u0004\r\u0001\u0006\u0005\b\u0003_\u0004A\u0011BAy\u00039awnY1uS>t\u0017I\u001a;fe:#2\u0001FAz\u0011\u001d\t\u0019*!<A\u0002QAq!a>\u0001\t\u0013\tI0A\u0007oK^,U\u000e\u001d;z%\u0006tw-\u001a\u000b\u0004u\u0005m\bbBA\u007f\u0003k\u0004\r\u0001F\u0001\u0006m\u0006dW/\u001a\u0005\u0007\u0005\u0003\u0001A\u0011\t>\u0002\u000fI,g/\u001a:tK\"1!Q\u0001\u0001\u0005\u0002i\f\u0011\"\u001b8dYV\u001c\u0018N^3\t\u000f\t%\u0001\u0001\"\u0001\u0003\f\u0005A1m\u001c8uC&t7\u000fF\u00023\u0005\u001bAqAa\u0004\u0003\b\u0001\u0007A#A\u0001y\u0011\u001d\u0011\u0019\u0002\u0001C!\u0005+\t1a];n+\u0011\u00119B!\f\u0015\u0007Q\u0011I\u0002\u0003\u0005\u0003\u001c\tE\u00019\u0001B\u000f\u0003\rqW/\u001c\t\u0007\u0005?\u0011)Ca\u000b\u000f\t\u0005\u001d%\u0011E\u0005\u0004\u0005Ga\u0011a\u00029bG.\fw-Z\u0005\u0005\u0005O\u0011ICA\u0004Ok6,'/[2\u000b\u0007\t\rB\u0002\u0005\u0003\u0002h\t5B\u0001\u0003B\u0018\u0005#\u0011\rA!\r\u0003\u0003\t\u000b2\u0001FA8\u0011\u001d\u0011)\u0004\u0001C!\u0005o\t1!\\5o+\u0011\u0011IDa\u0012\u0015\u0007Q\u0011Y\u0004\u0003\u0005\u0003>\tM\u00029\u0001B \u0003\ry'\u000f\u001a\t\u0007\u0005?\u0011\tE!\u0012\n\t\t\r#\u0011\u0006\u0002\t\u001fJ$WM]5oOB!\u0011q\rB$\t!\u0011IEa\rC\u0002\tE\"AA!2\u0011\u001d\u0011i\u0005\u0001C!\u0005\u001f\n1!\\1y+\u0011\u0011\tF!\u0017\u0015\u0007Q\u0011\u0019\u0006\u0003\u0005\u0003>\t-\u00039\u0001B+!\u0019\u0011yB!\u0011\u0003XA!\u0011q\rB-\t!\u0011IEa\u0013C\u0002\tE\u0002b\u0002B/\u0001\u0011\u0005#qL\u0001\u0007KF,\u0018\r\\:\u0015\u0007I\u0012\t\u0007\u0003\u0005\u0003d\tm\u0003\u0019AA8\u0003\u0015yG\u000f[3s\u0011\u001d\u00119\u0007\u0001C!\u0005S\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005W\u0002BA!\u001c\u0003x5\u0011!q\u000e\u0006\u0005\u0005c\u0012\u0019(\u0001\u0003mC:<'B\u0001B;\u0003\u0011Q\u0017M^1\n\t\u0005e\"q\u000e\u0005\n\u0005w\u0002\u0011\u0013!C\t\u0005{\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\u0000)\u001aAC!!,\u0005\t\r\u0005\u0003\u0002BC\u0005\u001fk!Aa\"\u000b\t\t%%1R\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!$\r\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005#\u00139IA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011B!&\u0001#\u0003%\tB! \u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!I!\u0011\u0014\u0001\u0012\u0002\u0013E!QP\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0011%\u0011i\nAI\u0001\n#\u0011y*\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t\u0005&f\u0001\u001a\u0003\u0002\":\u0001A!*\u0002~\n-\u0006cA\u0006\u0003(&\u0019!\u0011\u0016\u0007\u0003!M+'/[1m-\u0016\u00148/[8o+&#e\u0004C5<HS[[CM\u0007\b\u000f\t=&\u0001#\u0001\u00032\u0006)!+\u00198hKB\u0019\u0011Ca-\u0007\r\u0005\u0011\u0001\u0012\u0001B['\u0011\u0011\u0019LC\u0010\t\u000fa\u0012\u0019\f\"\u0001\u0003:R\u0011!\u0011\u0017\u0005\t\u0005{\u0013\u0019\f\"\u0001\u0003@\u0006)1m\\;oiRIAC!1\u0003D\n\u0015'q\u0019\u0005\u0007G\tm\u0006\u0019\u0001\u000b\t\r!\u0012Y\f1\u0001\u0015\u0011\u0019a#1\u0018a\u0001)!1\u0001Ga/A\u0002IB\u0001B!0\u00034\u0012\u0005!1\u001a\u000b\b)\t5'q\u001aBi\u0011\u0019\u0019#\u0011\u001aa\u0001)!1\u0001F!3A\u0002QAa\u0001\fBe\u0001\u0004!\u0002\u0002CA&\u0005g#\tA!6\u0015\u000fi\u00129N!7\u0003\\\"11Ea5A\u0002QAa\u0001\u000bBj\u0001\u0004!\u0002B\u0002\u0017\u0003T\u0002\u0007A\u0003\u0003\u0005\u0002L\tMF\u0011\u0001Bp)\u0015Q$\u0011\u001dBr\u0011\u0019\u0019#Q\u001ca\u0001)!1\u0001F!8A\u0002QA\u0001B!\u0002\u00034\u0012\u0005!q\u001d\u000b\bu\t%(1\u001eBw\u0011\u0019\u0019#Q\u001da\u0001)!1\u0001F!:A\u0002QAa\u0001\fBs\u0001\u0004!\u0002\u0002\u0003B\u0003\u0005g#\tA!=\u0015\u000bi\u0012\u0019P!>\t\r\r\u0012y\u000f1\u0001\u0015\u0011\u0019A#q\u001ea\u0001)!Q!\u0011 BZ\u0003\u0003%IAa?\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005{\u0004BA!\u001c\u0003\u0000&!1\u0011\u0001B8\u0005\u0019y%M[3di\u0002")
public final class Range
implements IndexedSeq<Object>,
StrictOptimizedIterableOps<Object, IndexedSeq<Object>>,
Serializable {
    public static final long serialVersionUID = 7618862778670199309L;
    private final int start;
    private final int end;
    private final int step;
    private final boolean isInclusive;
    private final boolean isEmpty;
    private final int length;
    private final int strawman$collection$immutable$Range$$lastElement;

    @Override
    public Tuple2<IndexedSeq<Object>, IndexedSeq<Object>> partition(Function1<Object, Object> p) {
        return StrictOptimizedIterableOps.partition$(this, p);
    }

    @Override
    public IndexedView<Object> view() {
        return IndexedSeqOps.view$(this);
    }

    @Override
    public Iterable<Object> reversed() {
        return IndexedSeqOps.reversed$(this);
    }

    @Override
    public Object prepend(Object elem) {
        return SeqOps.prepend$(this, elem);
    }

    @Override
    public final Object $plus$colon(Object elem) {
        return SeqOps.$plus$colon$(this, elem);
    }

    @Override
    public Object append(Object elem) {
        return SeqOps.append$(this, elem);
    }

    @Override
    public final Object $colon$plus(Object elem) {
        return SeqOps.$colon$plus$(this, elem);
    }

    @Override
    public Object updated(int index, Object elem) {
        return SeqOps.updated$(this, index, elem);
    }

    @Override
    public Seq<Object> c() {
        return Seq.c$(this);
    }

    @Override
    public Seq<Object> seq() {
        return Seq.seq$(this);
    }

    @Override
    public Iterator<Object> reverseIterator() {
        return strawman.collection.SeqOps.reverseIterator$(this);
    }

    @Override
    public <B> boolean startsWith(Seq<B> that, int offset) {
        return strawman.collection.SeqOps.startsWith$(this, that, offset);
    }

    @Override
    public <B> boolean endsWith(Seq<B> that) {
        return strawman.collection.SeqOps.endsWith$(this, that);
    }

    @Override
    public Object padTo(int len, Object elem) {
        return strawman.collection.SeqOps.padTo$(this, len, elem);
    }

    @Override
    public int indexWhere(Function1<Object, Object> p, int from) {
        return strawman.collection.SeqOps.indexWhere$(this, p, from);
    }

    @Override
    public <B> int indexOf(B elem, int from) {
        return strawman.collection.SeqOps.indexOf$(this, elem, from);
    }

    @Override
    public <B> int lastIndexOf(B elem, int end) {
        return strawman.collection.SeqOps.lastIndexOf$(this, elem, end);
    }

    @Override
    public int lastIndexWhere(Function1<Object, Object> p, int end) {
        return strawman.collection.SeqOps.lastIndexWhere$(this, p, end);
    }

    @Override
    public <B> int indexOfSlice(Seq<B> that, int from) {
        return strawman.collection.SeqOps.indexOfSlice$(this, that, from);
    }

    @Override
    public <B> int lastIndexOfSlice(Seq<B> that, int end) {
        return strawman.collection.SeqOps.lastIndexOfSlice$(this, that, end);
    }

    @Override
    public <B> boolean containsSlice(Seq<B> that) {
        return strawman.collection.SeqOps.containsSlice$(this, that);
    }

    @Override
    public <A1> boolean contains(A1 elem) {
        return strawman.collection.SeqOps.contains$(this, elem);
    }

    @Override
    public Iterator<IndexedSeq<Object>> permutations() {
        return strawman.collection.SeqOps.permutations$(this);
    }

    @Override
    public Iterator<IndexedSeq<Object>> combinations(int n) {
        return strawman.collection.SeqOps.combinations$(this, n);
    }

    @Override
    public Object sorted(Ordering ord) {
        return strawman.collection.SeqOps.sorted$(this, ord);
    }

    @Override
    public Object sortWith(Function2 lt) {
        return strawman.collection.SeqOps.sortWith$(this, lt);
    }

    @Override
    public Object sortBy(Function1 f, Ordering ord) {
        return strawman.collection.SeqOps.sortBy$(this, f, ord);
    }

    @Override
    public Range indices() {
        return strawman.collection.SeqOps.indices$(this);
    }

    @Override
    public <B> boolean sameElements(IterableOnce<B> that) {
        return strawman.collection.SeqOps.sameElements$(this, that);
    }

    @Override
    public boolean canEqual(Object that) {
        return strawman.collection.SeqOps.canEqual$(this, that);
    }

    @Override
    public int hashCode() {
        return strawman.collection.SeqOps.hashCode$(this);
    }

    @Override
    public <B> int startsWith$default$2() {
        return strawman.collection.SeqOps.startsWith$default$2$(this);
    }

    @Override
    public int indexWhere$default$2() {
        return strawman.collection.SeqOps.indexWhere$default$2$(this);
    }

    @Override
    public <B> int indexOf$default$2() {
        return strawman.collection.SeqOps.indexOf$default$2$(this);
    }

    @Override
    public <B> int lastIndexOf$default$2() {
        return strawman.collection.SeqOps.lastIndexOf$default$2$(this);
    }

    @Override
    public int lastIndexWhere$default$2() {
        return strawman.collection.SeqOps.lastIndexWhere$default$2$(this);
    }

    @Override
    public <B> int indexOfSlice$default$2() {
        return strawman.collection.SeqOps.indexOfSlice$default$2$(this);
    }

    @Override
    public <B> int lastIndexOfSlice$default$2() {
        return strawman.collection.SeqOps.lastIndexOfSlice$default$2$(this);
    }

    @Override
    public Iterable<Object> coll() {
        return Iterable.coll$(this);
    }

    @Override
    public Object fromIterable(Iterable it) {
        return IterableOps.fromIterable$(this, it);
    }

    @Override
    public boolean forall(Function1<Object, Object> p) {
        return IterableOps.forall$(this, p);
    }

    @Override
    public boolean exists(Function1<Object, Object> p) {
        return IterableOps.exists$(this, p);
    }

    @Override
    public int count(Function1<Object, Object> p) {
        return IterableOps.count$(this, p);
    }

    @Override
    public Option<Object> find(Function1<Object, Object> p) {
        return IterableOps.find$(this, p);
    }

    @Override
    public <B> B foldLeft(B z, Function2<B, Object, B> op) {
        return (B)IterableOps.foldLeft$(this, z, op);
    }

    @Override
    public <B> B foldRight(B z, Function2<Object, B, B> op) {
        return (B)IterableOps.foldRight$(this, z, op);
    }

    @Override
    public <B> B reduce(Function2<B, B, B> op) {
        return (B)IterableOps.reduce$(this, op);
    }

    @Override
    public <B> Option<B> reduceOption(Function2<B, B, B> op) {
        return IterableOps.reduceOption$(this, op);
    }

    @Override
    public <B> B reduceLeft(Function2<B, Object, B> op) {
        return (B)IterableOps.reduceLeft$(this, op);
    }

    @Override
    public <B> B reduceRight(Function2<Object, B, B> op) {
        return (B)IterableOps.reduceRight$(this, op);
    }

    @Override
    public <B> Option<B> reduceLeftOption(Function2<B, Object, B> op) {
        return IterableOps.reduceLeftOption$(this, op);
    }

    @Override
    public <B> Option<B> reduceRightOption(Function2<Object, B, B> op) {
        return IterableOps.reduceRightOption$(this, op);
    }

    @Override
    public boolean nonEmpty() {
        return IterableOps.nonEmpty$(this);
    }

    @Override
    public Option<Object> lastOption() {
        return IterableOps.lastOption$(this);
    }

    @Override
    public int knownSize() {
        return IterableOps.knownSize$(this);
    }

    @Override
    public <C1> C1 to(FromSpecificIterable<Object, C1> f) {
        return (C1)IterableOps.to$(this, f);
    }

    @Override
    public <B> Object toArray(ClassTag<B> evidence$1) {
        return IterableOps.toArray$(this, evidence$1);
    }

    @Override
    public <B> Object copyToArray(Object xs, int start) {
        return IterableOps.copyToArray$(this, xs, start);
    }

    @Override
    public String className() {
        return IterableOps.className$(this);
    }

    @Override
    public String mkString(String start, String sep, String end) {
        return IterableOps.mkString$(this, start, sep, end);
    }

    @Override
    public String mkString(String sep) {
        return IterableOps.mkString$(this, sep);
    }

    @Override
    public String mkString() {
        return IterableOps.mkString$(this);
    }

    @Override
    public <B> B product(Numeric<B> num) {
        return (B)IterableOps.product$(this, num);
    }

    @Override
    public Object maxBy(Function1 f, Ordering cmp) {
        return IterableOps.maxBy$(this, f, cmp);
    }

    @Override
    public Object minBy(Function1 f, Ordering cmp) {
        return IterableOps.minBy$(this, f, cmp);
    }

    @Override
    public Object filter(Function1 pred) {
        return IterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return IterableOps.filterNot$(this, pred);
    }

    @Override
    public Iterator<IndexedSeq<Object>> grouped(int size) {
        return IterableOps.grouped$(this, size);
    }

    @Override
    public Iterator<IndexedSeq<Object>> sliding(int size) {
        return IterableOps.sliding$(this, size);
    }

    @Override
    public Iterator<IndexedSeq<Object>> sliding(int size, int step) {
        return IterableOps.sliding$(this, size, step);
    }

    @Override
    public <K> Map<K, IndexedSeq<Object>> groupBy(Function1<Object, K> f) {
        return IterableOps.groupBy$(this, f);
    }

    @Override
    public Object scan(Object z, Function2 op) {
        return IterableOps.scan$(this, z, op);
    }

    @Override
    public Object scanLeft(Object z, Function2 op) {
        return IterableOps.scanLeft$(this, z, op);
    }

    @Override
    public Object scanRight(Object z, Function2 op) {
        return IterableOps.scanRight$(this, z, op);
    }

    @Override
    public Object map(Function1 f) {
        return IterableOps.map$(this, f);
    }

    @Override
    public Object flatMap(Function1 f) {
        return IterableOps.flatMap$(this, f);
    }

    @Override
    public Object flatten(Function1 ev) {
        return IterableOps.flatten$(this, ev);
    }

    @Override
    public Object collect(PartialFunction pf) {
        return IterableOps.collect$(this, pf);
    }

    @Override
    public Object concat(IterableOnce xs) {
        return IterableOps.concat$(this, xs);
    }

    @Override
    public final Object $plus$plus(IterableOnce xs) {
        return IterableOps.$plus$plus$(this, xs);
    }

    @Override
    public Object zip(IterableOnce xs) {
        return IterableOps.zip$(this, xs);
    }

    @Override
    public Object zipWithIndex() {
        return IterableOps.zipWithIndex$(this);
    }

    @Override
    public <A1, A2> Tuple2<IndexedSeq<A1>, IndexedSeq<A2>> unzip(Predef$.less.colon.less<Object, Tuple2<A1, A2>> asPair) {
        return IterableOps.unzip$(this, asPair);
    }

    @Override
    public <B> int copyToArray$default$2() {
        return IterableOps.copyToArray$default$2$(this);
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public int step() {
        return this.step;
    }

    public boolean isInclusive() {
        return this.isInclusive;
    }

    @Override
    public IterableFactory<IndexedSeq> iterableFactory() {
        return IndexedSeq$.MODULE$;
    }

    @Override
    public IndexedSeq<Object> fromSpecificIterable(Iterable<Object> coll) {
        return (IndexedSeq)this.fromIterable(coll);
    }

    @Override
    public Builder<Object, IndexedSeq<Object>> newSpecificBuilder() {
        return IndexedSeq$.MODULE$.newBuilder();
    }

    @Override
    public Iterator<Object> iterator() {
        return new RangeIterator(this.start(), this.step(), this.strawman$collection$immutable$Range$$lastElement(), this.isEmpty());
    }

    private long gap() {
        return (long)this.end() - (long)this.start();
    }

    private boolean isExact() {
        return this.gap() % (long)this.step() == 0L;
    }

    private boolean hasStub() {
        return this.isInclusive() || !this.isExact();
    }

    private long longLength() {
        return this.gap() / (long)this.step() + (long)(this.hasStub() ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public int length() {
        return this.length;
    }

    public int strawman$collection$immutable$Range$$lastElement() {
        return this.strawman$collection$immutable$Range$$lastElement;
    }

    @Override
    public int last() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.head();
        }
        return this.strawman$collection$immutable$Range$$lastElement();
    }

    @Override
    public int head() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.head();
        }
        return this.start();
    }

    @Override
    public Range init() {
        Object object = this.isEmpty() ? Nil$.MODULE$.init() : BoxedUnit.UNIT;
        return this.dropRight(1);
    }

    @Override
    public Range tail() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.tail();
        }
        return this.length() == 1 ? this.newEmptyRange(this.end()) : new Range(this.start() + this.step(), this.end(), this.step(), this.isInclusive());
    }

    public Range copy(int start, int end, int step, boolean isInclusive) {
        return new Range(start, end, step, isInclusive);
    }

    public int copy$default$1() {
        return this.start();
    }

    public int copy$default$2() {
        return this.end();
    }

    public int copy$default$3() {
        return this.step();
    }

    public boolean copy$default$4() {
        return this.isInclusive();
    }

    public Range by(int step) {
        return this.copy(this.start(), this.end(), step, this.copy$default$4());
    }

    @Override
    public int size() {
        return this.length();
    }

    private void validateMaxLength() {
        if (this.length() < 0) {
            throw this.fail();
        }
    }

    private String description() {
        return new StringOps(Predef$.MODULE$.augmentString("%d %s %d by %s")).format((scala.collection.Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.start()), this.isInclusive() ? "to" : "until", BoxesRunTime.boxToInteger((int)this.end()), BoxesRunTime.boxToInteger((int)this.step())}));
    }

    private Nothing$ fail() {
        throw new IllegalArgumentException(this.description() + ": seqs cannot contain more than Int.MaxValue elements.");
    }

    @Override
    public int apply(int idx) {
        this.validateMaxLength();
        if (idx < 0 || idx >= this.length()) {
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)idx)).toString());
        }
        return this.start() + this.step() * idx;
    }

    @Override
    public <U> void foreach(Function1<Object, U> f) {
        if (!this.isEmpty()) {
            int i = this.start();
            while (true) {
                f.apply((Object)BoxesRunTime.boxToInteger((int)i));
                if (i == this.strawman$collection$immutable$Range$$lastElement()) {
                    return;
                }
                i += this.step();
            }
        }
    }

    @Override
    public Range take(int n) {
        return n <= 0 || this.isEmpty() ? this.newEmptyRange(this.start()) : (n >= this.length() && this.length() >= 0 ? this : new Range(this.start(), this.locationAfterN(n - 1), this.step(), true));
    }

    @Override
    public Range drop(int n) {
        return n <= 0 || this.isEmpty() ? this : (n >= this.length() && this.length() >= 0 ? this.newEmptyRange(this.end()) : this.copy(this.locationAfterN(n), this.end(), this.step(), this.copy$default$4()));
    }

    @Override
    public Range takeRight(int n) {
        Range range;
        if (n <= 0) {
            range = this.newEmptyRange(this.start());
        } else if (this.length() >= 0) {
            range = this.drop(this.length() - n);
        } else {
            int y = this.last();
            long x = (long)y - (long)this.step() * (long)(n - 1);
            range = this.step() > 0 && x < (long)this.start() || this.step() < 0 && x > (long)this.start() ? this : Range$.MODULE$.inclusive((int)x, y, this.step());
        }
        return range;
    }

    @Override
    public Range dropRight(int n) {
        Range range;
        if (n <= 0) {
            range = this;
        } else if (this.length() >= 0) {
            range = this.take(this.length() - n);
        } else {
            int y = this.last() - this.step() * n;
            range = this.step() > 0 && y < this.start() || this.step() < 0 && y > this.start() ? this.newEmptyRange(this.start()) : Range$.MODULE$.inclusive(this.start(), y, this.step());
        }
        return range;
    }

    private long argTakeWhile(Function1<Object, Object> p) {
        long l;
        if (this.isEmpty()) {
            l = this.start();
        } else {
            int current;
            int stop = this.last();
            for (current = this.start(); current != stop && p.apply$mcZI$sp(current); current += this.step()) {
            }
            l = current != stop || !p.apply$mcZI$sp(current) ? (long)current : (long)current + (long)this.step();
        }
        return l;
    }

    @Override
    public Range takeWhile(Function1<Object, Object> p) {
        int x;
        long stop = this.argTakeWhile(p);
        return stop == (long)this.start() ? this.newEmptyRange(this.start()) : ((x = (int)(stop - (long)this.step())) == this.last() ? this : Range$.MODULE$.inclusive(this.start(), x, this.step()));
    }

    @Override
    public Range dropWhile(Function1<Object, Object> p) {
        int x;
        long stop = this.argTakeWhile(p);
        return stop == (long)this.start() ? this : ((x = (int)(stop - (long)this.step())) == this.last() ? this.newEmptyRange(this.last()) : Range$.MODULE$.inclusive(x + this.step(), this.last(), this.step()));
    }

    @Override
    public Tuple2<Range, Range> span(Function1<Object, Object> p) {
        int x;
        long border = this.argTakeWhile(p);
        return border == (long)this.start() ? new Tuple2((Object)this.newEmptyRange(this.start()), (Object)this) : ((x = (int)(border - (long)this.step())) == this.last() ? new Tuple2((Object)this, (Object)this.newEmptyRange(this.last())) : new Tuple2((Object)Range$.MODULE$.inclusive(this.start(), x, this.step()), (Object)Range$.MODULE$.inclusive(x + this.step(), this.last(), this.step())));
    }

    @Override
    public Range slice(int from, int until) {
        Range range;
        if (from <= 0) {
            range = this.take(until);
        } else if (until >= this.length() && this.length() >= 0) {
            range = this.drop(from);
        } else {
            int fromValue = this.locationAfterN(from);
            range = from >= until ? this.newEmptyRange(fromValue) : Range$.MODULE$.inclusive(fromValue, this.locationAfterN(until - 1), this.step());
        }
        return range;
    }

    @Override
    public Tuple2<Range, Range> splitAt(int n) {
        return new Tuple2((Object)this.take(n), (Object)this.drop(n));
    }

    private int locationAfterN(int n) {
        return this.start() + this.step() * n;
    }

    private Range newEmptyRange(int value) {
        return new Range(value, value, this.step(), false);
    }

    @Override
    public Range reverse() {
        return this.isEmpty() ? this : new Range(this.last(), this.start(), -this.step(), true);
    }

    public Range inclusive() {
        return this.isInclusive() ? this : new Range(this.start(), this.end(), this.step(), true);
    }

    @Override
    public boolean contains(int x) {
        return x == this.end() && !this.isInclusive() ? false : (this.step() > 0 ? (x < this.start() || x > this.end() ? false : this.step() == 1 || (x - this.start()) % this.step() == 0) : (x < this.end() || x > this.start() ? false : this.step() == -1 || (x - this.start()) % this.step() == 0));
    }

    @Override
    public <B> int sum(Numeric<B> num) {
        int n;
        if (num == Numeric.IntIsIntegral$.MODULE$) {
            n = this.isEmpty() ? 0 : (this.size() == 1 ? this.head() : (int)((long)this.size() * ((long)this.head() + (long)this.last()) / 2L));
        } else if (this.isEmpty()) {
            n = num.toInt(num.zero());
        } else {
            Object acc = num.zero();
            int i = this.head();
            while (true) {
                acc = num.plus(acc, (Object)BoxesRunTime.boxToInteger((int)i));
                if (i == this.strawman$collection$immutable$Range$$lastElement()) {
                    return num.toInt(acc);
                }
                i += this.step();
            }
        }
        return n;
    }

    @Override
    public <A1> int min(Ordering<A1> ord) {
        return ord == Ordering.Int$.MODULE$ ? (this.step() > 0 ? this.head() : this.last()) : BoxesRunTime.unboxToInt((Object)IterableOps.min$(this, ord));
    }

    @Override
    public <A1> int max(Ordering<A1> ord) {
        return ord == Ordering.Int$.MODULE$ ? (this.step() > 0 ? this.last() : this.head()) : BoxesRunTime.unboxToInt((Object)IterableOps.max$(this, ord));
    }

    @Override
    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof Range) {
            int l0;
            Range range = (Range)object;
            bl = this.isEmpty() ? range.isEmpty() : range.nonEmpty() && this.start() == range.start() && (l0 = this.last()) == range.last() && (this.start() == l0 || this.step() == range.step());
        } else {
            bl = strawman.collection.SeqOps.equals$(this, other);
        }
        return bl;
    }

    @Override
    public String toString() {
        String stepped;
        String preposition = this.isInclusive() ? "to" : "until";
        String string = stepped = this.step() == 1 ? "" : new StringContext((scala.collection.Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" by ", ""})).s((scala.collection.Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.step())}));
        String prefix = this.isEmpty() ? "empty " : (!this.isExact() ? "inexact " : "");
        return new StringContext((scala.collection.Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "Range ", " ", " ", "", ""})).s((scala.collection.Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix, BoxesRunTime.boxToInteger((int)this.start()), preposition, BoxesRunTime.boxToInteger((int)this.end()), stepped}));
    }

    public void foreach$mVc$sp(Function1<Object, BoxedUnit> f) {
        if (!this.isEmpty()) {
            int i = this.start();
            while (true) {
                f.apply$mcVI$sp(i);
                if (i == this.strawman$collection$immutable$Range$$lastElement()) {
                    return;
                }
                i += this.step();
            }
        }
    }

    public Range(int start, int end, int step, boolean isInclusive) {
        int n;
        long len;
        this.start = start;
        this.end = end;
        this.step = step;
        this.isInclusive = isInclusive;
        IterableOps.$init$(this);
        Iterable.$init$(this);
        strawman.collection.SeqOps.$init$(this);
        Seq.$init$(this);
        SeqOps.$init$(this);
        IndexedSeqOps.$init$(this);
        StrictOptimizedIterableOps.$init$(this);
        boolean bl = this.isEmpty = start > end && step > 0 || start < end && step < 0 || start == end && !isInclusive;
        if (step == 0) {
            throw new IllegalArgumentException("step cannot be 0.");
        }
        this.length = this.isEmpty() ? 0 : ((len = this.longLength()) > Integer.MAX_VALUE ? -1 : (int)len);
        int n2 = step;
        switch (n2) {
            case 1: {
                if (isInclusive) {
                    n = end;
                    break;
                }
                n = end - 1;
                break;
            }
            case -1: {
                if (isInclusive) {
                    n = end;
                    break;
                }
                n = end + 1;
                break;
            }
            default: {
                int remainder = (int)(this.gap() % (long)step);
                if (remainder != 0) {
                    n = end - remainder;
                    break;
                }
                if (isInclusive) {
                    n = end;
                    break;
                }
                n = end - step;
                break;
            }
        }
        this.strawman$collection$immutable$Range$$lastElement = n;
    }
}

