/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.immutable;

import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import strawman.collection.CanBuild;
import strawman.collection.IndexedSeqOps;
import strawman.collection.IndexedView;
import strawman.collection.Iterable;
import strawman.collection.IterableFactory;
import strawman.collection.IterableOnce;
import strawman.collection.IterableOps;
import strawman.collection.Iterator;
import strawman.collection.Seq;
import strawman.collection.StrictOptimizedIterableOps;
import strawman.collection.immutable.IndexedSeq;
import strawman.collection.immutable.IndexedSeq$;
import strawman.collection.immutable.Map;
import strawman.collection.immutable.Nil$;
import strawman.collection.immutable.Range$;
import strawman.collection.immutable.RangeIterator;
import strawman.collection.immutable.SeqOps;
import strawman.collection.immutable.StrictOptimizedSeqOps;
import strawman.collection.mutable.Builder;

@ScalaSignature(bytes="\u0006\u0001\reb\u0001B\u0001\u0003\u0005%\u0011QAU1oO\u0016T!a\u0001\u0003\u0002\u0013%lW.\u001e;bE2,'BA\u0003\u0007\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002\u000f\u0005A1\u000f\u001e:bo6\fgn\u0001\u0001\u0014\r\u0001Q\u0001cF\u000e\u001f!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fMB\u0019\u0011C\u0005\u000b\u000e\u0003\tI!a\u0005\u0002\u0003\u0015%sG-\u001a=fIN+\u0017\u000f\u0005\u0002\f+%\u0011a\u0003\u0004\u0002\u0004\u0013:$\b#B\t\u0019)i\u0001\u0012BA\r\u0003\u00055Ie\u000eZ3yK\u0012\u001cV-](qgB\u0011\u0011C\u0005\t\u0006#q!\"\u0004E\u0005\u0003;\t\u0011Qc\u0015;sS\u000e$x\n\u001d;j[&TX\rZ*fc>\u00038\u000f\u0005\u0002\f?%\u0011\u0001\u0005\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tE\u0001\u0011)\u0019!C\u0001G\u0005)1\u000f^1siV\tA\u0003\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003\u0015\u0003\u0019\u0019H/\u0019:uA!Aq\u0005\u0001BC\u0002\u0013\u00051%A\u0002f]\u0012D\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\u0005K:$\u0007\u0005\u0003\u0005,\u0001\t\u0015\r\u0011\"\u0001$\u0003\u0011\u0019H/\u001a9\t\u00115\u0002!\u0011!Q\u0001\nQ\tQa\u001d;fa\u0002B\u0001b\f\u0001\u0003\u0006\u0004%\t\u0001M\u0001\fSNLen\u00197vg&4X-F\u00012!\tY!'\u0003\u00024\u0019\t9!i\\8mK\u0006t\u0007\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002\u0019%\u001c\u0018J\\2mkNLg/\u001a\u0011\t\u000b]\u0002A\u0011\u0001\u001d\u0002\rqJg.\u001b;?)\u0015I$h\u000f\u001f>!\t\t\u0002\u0001C\u0003#m\u0001\u0007A\u0003C\u0003(m\u0001\u0007A\u0003C\u0003,m\u0001\u0007A\u0003C\u00030m\u0001\u0007\u0011\u0007C\u0003@\u0001\u0011\u0005\u0001)A\bji\u0016\u0014\u0018M\u00197f\r\u0006\u001cGo\u001c:z+\u0005\t\u0005c\u0001\"D55\tA!\u0003\u0002E\t\ty\u0011\n^3sC\ndWMR1di>\u0014\u0018\u0010\u0003\u0004G\u0001\u0001&\tbR\u0001\u0015MJ|Wn\u00159fG&4\u0017nY%uKJ\f'\r\\3\u0015\u0005AA\u0005\"B%F\u0001\u0004Q\u0015\u0001B2pY2\u00042AQ&\u0015\u0013\taEA\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u0019q\u0005\u0001)C\t\u001f\u0006\u0011b.Z<Ta\u0016\u001c\u0017NZ5d\u0005VLG\u000eZ3s)\u0005\u0001\u0006\u0003B)U)Ai\u0011A\u0015\u0006\u0003'\u0012\tq!\\;uC\ndW-\u0003\u0002V%\n9!)^5mI\u0016\u0014\b\"B,\u0001\t\u0003A\u0016\u0001C5uKJ\fGo\u001c:\u0015\u0003e\u00032A\u0011.\u0015\u0013\tYFA\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011\u0015i\u0006\u0001\"\u0003_\u0003\r9\u0017\r]\u000b\u0002?B\u00111\u0002Y\u0005\u0003C2\u0011A\u0001T8oO\")1\r\u0001C\u0005a\u00059\u0011n]#yC\u000e$\b\"B3\u0001\t\u0013\u0001\u0014a\u00025bgN#XO\u0019\u0005\u0006O\u0002!IAX\u0001\u000bY>tw\rT3oORD\u0007bB5\u0001\u0005\u0004%\t\u0005M\u0001\bSN,U\u000e\u001d;z\u0011\u0019Y\u0007\u0001)A\u0005c\u0005A\u0011n]#naRL\b\u0005C\u0004n\u0001\t\u0007I\u0011A\u0012\u0002\r1,gn\u001a;i\u0011\u0019y\u0007\u0001)A\u0005)\u00059A.\u001a8hi\"\u0004\u0003bB9\u0001\u0005\u0004%IaI\u0001\fY\u0006\u001cH/\u00127f[\u0016tG\u000f\u0003\u0004t\u0001\u0001\u0006I\u0001F\u0001\rY\u0006\u001cH/\u00127f[\u0016tG\u000f\t\u0005\u0006k\u0002!\teI\u0001\u0005Y\u0006\u001cH\u000fC\u0003x\u0001\u0011\u00053%\u0001\u0003iK\u0006$\u0007\"B=\u0001\t\u0003R\u0018\u0001B5oSR,\u0012!\u000f\u0005\u0006y\u0002!\tE_\u0001\u0005i\u0006LG\u000eC\u0003\u007f\u0001\u0011Eq0\u0001\u0003d_BLH#C\u001d\u0002\u0002\u0005\r\u0011QAA\u0004\u0011\u001d\u0011S\u0010%AA\u0002QAqaJ?\u0011\u0002\u0003\u0007A\u0003C\u0004,{B\u0005\t\u0019\u0001\u000b\t\u000f=j\b\u0013!a\u0001c!9\u00111\u0002\u0001\u0005\u0002\u00055\u0011A\u00012z)\rI\u0014q\u0002\u0005\u0007W\u0005%\u0001\u0019\u0001\u000b\t\r\u0005M\u0001\u0001\"\u0011$\u0003\u0011\u0019\u0018N_3\t\u000f\u0005]\u0001\u0001\"\u0003\u0002\u001a\u0005\tb/\u00197jI\u0006$X-T1y\u0019\u0016tw\r\u001e5\u0015\u0005\u0005m\u0001cA\u0006\u0002\u001e%\u0019\u0011q\u0004\u0007\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003G\u0001A\u0011BA\u0013\u0003-!Wm]2sSB$\u0018n\u001c8\u0016\u0005\u0005\u001d\u0002\u0003BA\u0015\u0003oqA!a\u000b\u00024A\u0019\u0011Q\u0006\u0007\u000e\u0005\u0005=\"bAA\u0019\u0011\u00051AH]8pizJ1!!\u000e\r\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011HA\u001e\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0007\u0007\t\u000f\u0005}\u0002\u0001\"\u0003\u0002B\u0005!a-Y5m)\t\t\u0019\u0005E\u0002\f\u0003\u000bJ1!a\u0012\r\u0005\u001dqu\u000e\u001e5j]\u001eDq!a\u0013\u0001\t\u0003\ti%A\u0003baBd\u0017\u0010F\u0002\u0015\u0003\u001fBq!!\u0015\u0002J\u0001\u0007A#A\u0002jIbDc!!\u0013\u0002V\u00055\u0004#B\u0006\u0002X\u0005m\u0013bAA-\u0019\t1A\u000f\u001b:poN\u0004B!!\u0018\u0002h9!\u0011qLA2\u001d\u0011\ti#!\u0019\n\u00035I1!!\u001a\r\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u001b\u0002l\tI\u0012J\u001c3fq>+Ho\u00144C_VtGm]#yG\u0016\u0004H/[8o\u0015\r\t)\u0007D\u0019\b=\u0005\u001d\u0012qNAJc%\u0019\u0013\u0011OA<\u0003\u0013\u000bI(\u0006\u0003\u0002&\u0005MDaBA;\u0011\t\u0007\u0011q\u0010\u0002\u0002)&!\u0011\u0011PA>\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0019\u0011Q\u0010\u0007\u0002\rQD'o\\<t#\u0011\t\u0019%!!\u0011\t\u0005\r\u0015Q\u0011\b\u0004\u0017\u0005\r\u0014\u0002BAD\u0003W\u0012\u0011\u0002\u00165s_^\f'\r\\32\u0013\r\nY)!$\u0002\u0010\u0006udbA\u0006\u0002\u000e&\u0019\u0011Q\u0010\u00072\u000b\tZA\"!%\u0003\u000bM\u001c\u0017\r\\12\u0007\u0019\nY\u0006C\u0004\u0002\u0018\u0002!\t%!'\u0002\u000f\u0019|'/Z1dQV!\u00111TAV)\u0011\tY\"!(\t\u0011\u0005}\u0015Q\u0013a\u0001\u0003C\u000b\u0011A\u001a\t\u0007\u0017\u0005\rF#a*\n\u0007\u0005\u0015FBA\u0005Gk:\u001cG/[8ocA!\u0011\u0011VAV\u0019\u0001!A\"!,\u0002\u0016\u0002\u0006\t\u0011!b\u0001\u0003_\u0013\u0011!V\t\u0005\u0003\u0007\n\t\fE\u0002\f\u0003gK1!!.\r\u0005\r\te.\u001f\u0015\u0007\u0003W\u000bI,a0\u0011\u0007-\tY,C\u0002\u0002>2\u00111b\u001d9fG&\fG.\u001b>fIFJ1%!1\u0002D\u0006\u001d\u0017Q\u0019\b\u0004\u0017\u0005\r\u0017bAAc\u0019\u0005!QK\\5uc\u0019!\u0013qLA1\u001b!9\u00111\u001a\u0001\u0005B\u00055\u0017\u0001\u0002;bW\u0016$2!OAh\u0011\u001d\t\t.!3A\u0002Q\t\u0011A\u001c\u0005\b\u0003+\u0004A\u0011IAl\u0003\u0011!'o\u001c9\u0015\u0007e\nI\u000eC\u0004\u0002R\u0006M\u0007\u0019\u0001\u000b\t\u000f\u0005u\u0007\u0001\"\u0011\u0002`\u0006IA/Y6f%&<\u0007\u000e\u001e\u000b\u0004s\u0005\u0005\bbBAi\u00037\u0004\r\u0001\u0006\u0005\b\u0003K\u0004A\u0011IAt\u0003%!'o\u001c9SS\u001eDG\u000fF\u0002:\u0003SDq!!5\u0002d\u0002\u0007A\u0003C\u0004\u0002n\u0002!I!a<\u0002\u0019\u0005\u0014x\rV1lK^C\u0017\u000e\\3\u0015\u0007}\u000b\t\u0010\u0003\u0005\u0002t\u0006-\b\u0019AA{\u0003\u0005\u0001\b#B\u0006\u0002$R\t\u0004bBA}\u0001\u0011\u0005\u00131`\u0001\ni\u0006\\Wm\u00165jY\u0016$2!OA\u007f\u0011!\t\u00190a>A\u0002\u0005U\bb\u0002B\u0001\u0001\u0011\u0005#1A\u0001\nIJ|\u0007o\u00165jY\u0016$2!\u000fB\u0003\u0011!\t\u00190a@A\u0002\u0005U\bb\u0002B\u0005\u0001\u0011\u0005#1B\u0001\u0005gB\fg\u000e\u0006\u0003\u0003\u000e\tM\u0001#B\u0006\u0003\u0010eJ\u0014b\u0001B\t\u0019\t1A+\u001e9mKJB\u0001\"a=\u0003\b\u0001\u0007\u0011Q\u001f\u0005\b\u0005/\u0001A\u0011\tB\r\u0003\u0015\u0019H.[2f)\u0015I$1\u0004B\u0010\u0011\u001d\u0011iB!\u0006A\u0002Q\tAA\u001a:p[\"9!\u0011\u0005B\u000b\u0001\u0004!\u0012!B;oi&d\u0007b\u0002B\u0013\u0001\u0011\u0005#qE\u0001\bgBd\u0017\u000e^!u)\u0011\u0011iA!\u000b\t\u000f\u0005E'1\u0005a\u0001)!9!Q\u0006\u0001\u0005\n\t=\u0012A\u00047pG\u0006$\u0018n\u001c8BMR,'O\u0014\u000b\u0004)\tE\u0002bBAi\u0005W\u0001\r\u0001\u0006\u0005\b\u0005k\u0001A\u0011\u0002B\u001c\u00035qWm^#naRL(+\u00198hKR\u0019\u0011H!\u000f\t\u000f\tm\"1\u0007a\u0001)\u0005)a/\u00197vK\"1!q\b\u0001\u0005Bi\fqA]3wKJ\u001cX\r\u0003\u0004\u0003D\u0001!\tA_\u0001\nS:\u001cG.^:jm\u0016DqAa\u0012\u0001\t\u0003\u0011I%\u0001\u0005d_:$\u0018-\u001b8t)\r\t$1\n\u0005\b\u0005\u001b\u0012)\u00051\u0001\u0015\u0003\u0005A\bb\u0002B)\u0001\u0011\u0005#1K\u0001\u0004gVlW\u0003\u0002B+\u0005G\"2\u0001\u0006B,\u0011!\u0011IFa\u0014A\u0004\tm\u0013a\u00018v[B1\u0011Q\fB/\u0005CJAAa\u0018\u0002l\t9a*^7fe&\u001c\u0007\u0003BAU\u0005G\"\u0001B!\u001a\u0003P\t\u0007!q\r\u0002\u0002\u0005F\u0019A#!-\t\u000f\t-\u0004\u0001\"\u0011\u0003n\u0005\u0019Q.\u001b8\u0016\t\t=$Q\u0010\u000b\u0004)\tE\u0004\u0002\u0003B:\u0005S\u0002\u001dA!\u001e\u0002\u0007=\u0014H\r\u0005\u0004\u0002^\t]$1P\u0005\u0005\u0005s\nYG\u0001\u0005Pe\u0012,'/\u001b8h!\u0011\tIK! \u0005\u0011\t}$\u0011\u000eb\u0001\u0005O\u0012!!Q\u0019\t\u000f\t\r\u0005\u0001\"\u0011\u0003\u0006\u0006\u0019Q.\u0019=\u0016\t\t\u001d%q\u0012\u000b\u0004)\t%\u0005\u0002\u0003B:\u0005\u0003\u0003\u001dAa#\u0011\r\u0005u#q\u000fBG!\u0011\tIKa$\u0005\u0011\t}$\u0011\u0011b\u0001\u0005OBqAa%\u0001\t\u0003\u0012)*\u0001\u0004fcV\fGn\u001d\u000b\u0004c\t]\u0005\u0002\u0003BM\u0005#\u0003\r!!-\u0002\u000b=$\b.\u001a:\t\u000f\tu\u0005\u0001\"\u0011\u0003 \u0006AAo\\*ue&tw\r\u0006\u0002\u0003\"B!!1\u0015BW\u001b\t\u0011)K\u0003\u0003\u0003(\n%\u0016\u0001\u00027b]\u001eT!Aa+\u0002\t)\fg/Y\u0005\u0005\u0003s\u0011)\u000bC\u0005\u00032\u0002\t\n\u0011\"\u0005\u00034\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B[U\r!\"qW\u0016\u0003\u0005s\u0003BAa/\u0003F6\u0011!Q\u0018\u0006\u0005\u0005\u007f\u0013\t-A\u0005v]\u000eDWmY6fI*\u0019!1\u0019\u0007\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003H\nu&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!1\u001a\u0001\u0012\u0002\u0013E!1W\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011%\u0011y\rAI\u0001\n#\u0011\u0019,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\t\u0013\tM\u0007!%A\u0005\u0012\tU\u0017AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005/T3!\rB\\Q\u001d\u0001!1\u001cB\u001e\u0005C\u00042a\u0003Bo\u0013\r\u0011y\u000e\u0004\u0002\u0011'\u0016\u0014\u0018.\u00197WKJ\u001c\u0018n\u001c8V\u0013\u0012s\u0002\"[^$*..\"'D\u0004\b\u0005K\u0014\u0001\u0012\u0001Bt\u0003\u0015\u0011\u0016M\\4f!\r\t\"\u0011\u001e\u0004\u0007\u0003\tA\tAa;\u0014\t\t%(B\b\u0005\bo\t%H\u0011\u0001Bx)\t\u00119\u000f\u0003\u0005\u0003t\n%H\u0011\u0001B{\u0003\u0015\u0019w.\u001e8u)%!\"q\u001fB}\u0005w\u0014i\u0010\u0003\u0004#\u0005c\u0004\r\u0001\u0006\u0005\u0007O\tE\b\u0019\u0001\u000b\t\r-\u0012\t\u00101\u0001\u0015\u0011\u0019y#\u0011\u001fa\u0001c!A!1\u001fBu\t\u0003\u0019\t\u0001F\u0004\u0015\u0007\u0007\u0019)aa\u0002\t\r\t\u0012y\u00101\u0001\u0015\u0011\u00199#q a\u0001)!11Fa@A\u0002QA\u0001\"a\u0013\u0003j\u0012\u000511\u0002\u000b\bs\r51qBB\t\u0011\u0019\u00113\u0011\u0002a\u0001)!1qe!\u0003A\u0002QAaaKB\u0005\u0001\u0004!\u0002\u0002CA&\u0005S$\ta!\u0006\u0015\u000be\u001a9b!\u0007\t\r\t\u001a\u0019\u00021\u0001\u0015\u0011\u0019931\u0003a\u0001)!A!1\tBu\t\u0003\u0019i\u0002F\u0004:\u0007?\u0019\tca\t\t\r\t\u001aY\u00021\u0001\u0015\u0011\u0019931\u0004a\u0001)!11fa\u0007A\u0002QA\u0001Ba\u0011\u0003j\u0012\u00051q\u0005\u000b\u0006s\r%21\u0006\u0005\u0007E\r\u0015\u0002\u0019\u0001\u000b\t\r\u001d\u001a)\u00031\u0001\u0015\u0011)\u0019yC!;\u0002\u0002\u0013%1\u0011G\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u00044A!!1UB\u001b\u0013\u0011\u00199D!*\u0003\r=\u0013'.Z2u\u0001")
public final class Range
implements IndexedSeq<Object>,
StrictOptimizedSeqOps<Object, IndexedSeq, IndexedSeq<Object>>,
Serializable {
    public static final long serialVersionUID = 7618862778670199309L;
    private final int start;
    private final int end;
    private final int step;
    private final boolean isInclusive;
    private final boolean isEmpty;
    private final int length;
    private final int strawman$collection$immutable$Range$$lastElement;

    @Override
    public Object prepend(Object elem) {
        return StrictOptimizedSeqOps.prepend$(this, elem);
    }

    @Override
    public Object append(Object elem) {
        return StrictOptimizedSeqOps.append$(this, elem);
    }

    @Override
    public Object updated(int index, Object elem) {
        return StrictOptimizedSeqOps.updated$(this, index, elem);
    }

    @Override
    public Tuple2<IndexedSeq<Object>, IndexedSeq<Object>> partition(Function1<Object, Object> p) {
        return StrictOptimizedIterableOps.partition$(this, p);
    }

    @Override
    public <A1, A2> Tuple2<IndexedSeq<A1>, IndexedSeq<A2>> unzip(Predef$.less.colon.less<Object, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.unzip$(this, asPair);
    }

    @Override
    public IndexedView<Object> view() {
        return IndexedSeqOps.view$(this);
    }

    @Override
    public Iterable<Object> reversed() {
        return IndexedSeqOps.reversed$(this);
    }

    @Override
    public final Object $plus$colon(Object elem) {
        return SeqOps.$plus$colon$(this, elem);
    }

    @Override
    public final Object $colon$plus(Object elem) {
        return SeqOps.$colon$plus$(this, elem);
    }

    @Override
    public Seq<Object> c() {
        return Seq.c$(this);
    }

    @Override
    public Seq<Object> seq() {
        return Seq.seq$(this);
    }

    @Override
    public Iterator<Object> reverseIterator() {
        return strawman.collection.SeqOps.reverseIterator$(this);
    }

    @Override
    public <B> boolean startsWith(Seq<B> that, int offset) {
        return strawman.collection.SeqOps.startsWith$(this, that, offset);
    }

    @Override
    public <B> boolean endsWith(Seq<B> that) {
        return strawman.collection.SeqOps.endsWith$(this, that);
    }

    @Override
    public Object padTo(int len, Object elem) {
        return strawman.collection.SeqOps.padTo$(this, len, elem);
    }

    @Override
    public int indexWhere(Function1<Object, Object> p, int from) {
        return strawman.collection.SeqOps.indexWhere$(this, p, from);
    }

    @Override
    public <B> int indexOf(B elem, int from) {
        return strawman.collection.SeqOps.indexOf$(this, elem, from);
    }

    @Override
    public <B> int lastIndexOf(B elem, int end) {
        return strawman.collection.SeqOps.lastIndexOf$(this, elem, end);
    }

    @Override
    public int lastIndexWhere(Function1<Object, Object> p, int end) {
        return strawman.collection.SeqOps.lastIndexWhere$(this, p, end);
    }

    @Override
    public <B> int indexOfSlice(Seq<B> that, int from) {
        return strawman.collection.SeqOps.indexOfSlice$(this, that, from);
    }

    @Override
    public <B> int lastIndexOfSlice(Seq<B> that, int end) {
        return strawman.collection.SeqOps.lastIndexOfSlice$(this, that, end);
    }

    @Override
    public <B> boolean containsSlice(Seq<B> that) {
        return strawman.collection.SeqOps.containsSlice$(this, that);
    }

    @Override
    public <A1> boolean contains(A1 elem) {
        return strawman.collection.SeqOps.contains$(this, elem);
    }

    @Override
    public Iterator<IndexedSeq<Object>> permutations() {
        return strawman.collection.SeqOps.permutations$(this);
    }

    @Override
    public Iterator<IndexedSeq<Object>> combinations(int n) {
        return strawman.collection.SeqOps.combinations$(this, n);
    }

    @Override
    public Object sorted(Ordering ord) {
        return strawman.collection.SeqOps.sorted$(this, ord);
    }

    @Override
    public Object sortWith(Function2 lt) {
        return strawman.collection.SeqOps.sortWith$(this, lt);
    }

    @Override
    public Object sortBy(Function1 f, Ordering ord) {
        return strawman.collection.SeqOps.sortBy$(this, f, ord);
    }

    @Override
    public Range indices() {
        return strawman.collection.SeqOps.indices$(this);
    }

    @Override
    public <B> boolean sameElements(IterableOnce<B> that) {
        return strawman.collection.SeqOps.sameElements$(this, that);
    }

    @Override
    public boolean canEqual(Object that) {
        return strawman.collection.SeqOps.canEqual$(this, that);
    }

    @Override
    public int hashCode() {
        return strawman.collection.SeqOps.hashCode$(this);
    }

    @Override
    public <B> int startsWith$default$2() {
        return strawman.collection.SeqOps.startsWith$default$2$(this);
    }

    @Override
    public int indexWhere$default$2() {
        return strawman.collection.SeqOps.indexWhere$default$2$(this);
    }

    @Override
    public <B> int indexOf$default$2() {
        return strawman.collection.SeqOps.indexOf$default$2$(this);
    }

    @Override
    public <B> int lastIndexOf$default$2() {
        return strawman.collection.SeqOps.lastIndexOf$default$2$(this);
    }

    @Override
    public int lastIndexWhere$default$2() {
        return strawman.collection.SeqOps.lastIndexWhere$default$2$(this);
    }

    @Override
    public <B> int indexOfSlice$default$2() {
        return strawman.collection.SeqOps.indexOfSlice$default$2$(this);
    }

    @Override
    public <B> int lastIndexOfSlice$default$2() {
        return strawman.collection.SeqOps.lastIndexOfSlice$default$2$(this);
    }

    @Override
    public Iterable<Object> coll() {
        return Iterable.coll$(this);
    }

    @Override
    public Object fromIterable(Iterable it) {
        return IterableOps.fromIterable$(this, it);
    }

    @Override
    public boolean forall(Function1<Object, Object> p) {
        return IterableOps.forall$(this, p);
    }

    @Override
    public boolean exists(Function1<Object, Object> p) {
        return IterableOps.exists$(this, p);
    }

    @Override
    public int count(Function1<Object, Object> p) {
        return IterableOps.count$(this, p);
    }

    @Override
    public Option<Object> find(Function1<Object, Object> p) {
        return IterableOps.find$(this, p);
    }

    @Override
    public <B> B foldLeft(B z, Function2<B, Object, B> op) {
        return (B)IterableOps.foldLeft$(this, z, op);
    }

    @Override
    public <B> B foldRight(B z, Function2<Object, B, B> op) {
        return (B)IterableOps.foldRight$(this, z, op);
    }

    @Override
    public <B> B reduce(Function2<B, B, B> op) {
        return (B)IterableOps.reduce$(this, op);
    }

    @Override
    public <B> Option<B> reduceOption(Function2<B, B, B> op) {
        return IterableOps.reduceOption$(this, op);
    }

    @Override
    public <B> B reduceLeft(Function2<B, Object, B> op) {
        return (B)IterableOps.reduceLeft$(this, op);
    }

    @Override
    public <B> B reduceRight(Function2<Object, B, B> op) {
        return (B)IterableOps.reduceRight$(this, op);
    }

    @Override
    public <B> Option<B> reduceLeftOption(Function2<B, Object, B> op) {
        return IterableOps.reduceLeftOption$(this, op);
    }

    @Override
    public <B> Option<B> reduceRightOption(Function2<Object, B, B> op) {
        return IterableOps.reduceRightOption$(this, op);
    }

    @Override
    public boolean nonEmpty() {
        return IterableOps.nonEmpty$(this);
    }

    @Override
    public Option<Object> lastOption() {
        return IterableOps.lastOption$(this);
    }

    @Override
    public int knownSize() {
        return IterableOps.knownSize$(this);
    }

    @Override
    public <C1> C1 to(CanBuild<Object, C1> f) {
        return (C1)IterableOps.to$(this, f);
    }

    @Override
    public <B> Object toArray(ClassTag<B> evidence$1) {
        return IterableOps.toArray$(this, evidence$1);
    }

    @Override
    public <B> Object copyToArray(Object xs, int start) {
        return IterableOps.copyToArray$(this, xs, start);
    }

    @Override
    public String className() {
        return IterableOps.className$(this);
    }

    @Override
    public String mkString(String start, String sep, String end) {
        return IterableOps.mkString$(this, start, sep, end);
    }

    @Override
    public String mkString(String sep) {
        return IterableOps.mkString$(this, sep);
    }

    @Override
    public String mkString() {
        return IterableOps.mkString$(this);
    }

    @Override
    public <B> B product(Numeric<B> num) {
        return (B)IterableOps.product$(this, num);
    }

    @Override
    public Object maxBy(Function1 f, Ordering cmp) {
        return IterableOps.maxBy$(this, f, cmp);
    }

    @Override
    public Object minBy(Function1 f, Ordering cmp) {
        return IterableOps.minBy$(this, f, cmp);
    }

    @Override
    public Object filter(Function1 pred) {
        return IterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return IterableOps.filterNot$(this, pred);
    }

    @Override
    public IterableOps.WithFilter withFilter(Function1<Object, Object> p) {
        return IterableOps.withFilter$(this, p);
    }

    @Override
    public Iterator<IndexedSeq<Object>> grouped(int size) {
        return IterableOps.grouped$(this, size);
    }

    @Override
    public Iterator<IndexedSeq<Object>> sliding(int size) {
        return IterableOps.sliding$(this, size);
    }

    @Override
    public Iterator<IndexedSeq<Object>> sliding(int size, int step) {
        return IterableOps.sliding$(this, size, step);
    }

    @Override
    public <K> Map<K, IndexedSeq<Object>> groupBy(Function1<Object, K> f) {
        return IterableOps.groupBy$(this, f);
    }

    @Override
    public Object scan(Object z, Function2 op) {
        return IterableOps.scan$(this, z, op);
    }

    @Override
    public Object scanLeft(Object z, Function2 op) {
        return IterableOps.scanLeft$(this, z, op);
    }

    @Override
    public Object scanRight(Object z, Function2 op) {
        return IterableOps.scanRight$(this, z, op);
    }

    @Override
    public Object map(Function1 f) {
        return IterableOps.map$(this, f);
    }

    @Override
    public Object flatMap(Function1 f) {
        return IterableOps.flatMap$(this, f);
    }

    @Override
    public Object flatten(Function1 ev) {
        return IterableOps.flatten$(this, ev);
    }

    @Override
    public Object collect(PartialFunction pf) {
        return IterableOps.collect$(this, pf);
    }

    @Override
    public Object concat(IterableOnce suffix) {
        return IterableOps.concat$(this, suffix);
    }

    @Override
    public final Object $plus$plus(IterableOnce suffix) {
        return IterableOps.$plus$plus$(this, suffix);
    }

    @Override
    public Object prependAll(Iterable prefix) {
        return IterableOps.prependAll$(this, prefix);
    }

    @Override
    public final Object $plus$plus$colon(Iterable prefix) {
        return IterableOps.$plus$plus$colon$(this, prefix);
    }

    @Override
    public Object zip(IterableOnce xs) {
        return IterableOps.zip$(this, xs);
    }

    @Override
    public Object zipWithIndex() {
        return IterableOps.zipWithIndex$(this);
    }

    @Override
    public <B> int copyToArray$default$2() {
        return IterableOps.copyToArray$default$2$(this);
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public int step() {
        return this.step;
    }

    public boolean isInclusive() {
        return this.isInclusive;
    }

    @Override
    public IterableFactory<IndexedSeq> iterableFactory() {
        return IndexedSeq$.MODULE$;
    }

    @Override
    public IndexedSeq<Object> fromSpecificIterable(Iterable<Object> coll) {
        return (IndexedSeq)this.fromIterable(coll);
    }

    @Override
    public Builder<Object, IndexedSeq<Object>> newSpecificBuilder() {
        return IndexedSeq$.MODULE$.newBuilder();
    }

    @Override
    public Iterator<Object> iterator() {
        return new RangeIterator(this.start(), this.step(), this.strawman$collection$immutable$Range$$lastElement(), this.isEmpty());
    }

    private long gap() {
        return (long)this.end() - (long)this.start();
    }

    private boolean isExact() {
        return this.gap() % (long)this.step() == 0L;
    }

    private boolean hasStub() {
        return this.isInclusive() || !this.isExact();
    }

    private long longLength() {
        return this.gap() / (long)this.step() + (long)(this.hasStub() ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public int length() {
        return this.length;
    }

    public int strawman$collection$immutable$Range$$lastElement() {
        return this.strawman$collection$immutable$Range$$lastElement;
    }

    @Override
    public int last() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.head();
        }
        return this.strawman$collection$immutable$Range$$lastElement();
    }

    @Override
    public int head() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.head();
        }
        return this.start();
    }

    @Override
    public Range init() {
        Object object = this.isEmpty() ? Nil$.MODULE$.init() : BoxedUnit.UNIT;
        return this.dropRight(1);
    }

    @Override
    public Range tail() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.tail();
        }
        return this.length() == 1 ? this.newEmptyRange(this.end()) : new Range(this.start() + this.step(), this.end(), this.step(), this.isInclusive());
    }

    public Range copy(int start, int end, int step, boolean isInclusive) {
        return new Range(start, end, step, isInclusive);
    }

    public int copy$default$1() {
        return this.start();
    }

    public int copy$default$2() {
        return this.end();
    }

    public int copy$default$3() {
        return this.step();
    }

    public boolean copy$default$4() {
        return this.isInclusive();
    }

    public Range by(int step) {
        return this.copy(this.start(), this.end(), step, this.copy$default$4());
    }

    @Override
    public int size() {
        return this.length();
    }

    private void validateMaxLength() {
        if (this.length() < 0) {
            throw this.fail();
        }
    }

    private String description() {
        return new StringOps(Predef$.MODULE$.augmentString("%d %s %d by %s")).format((scala.collection.Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.start()), this.isInclusive() ? "to" : "until", BoxesRunTime.boxToInteger((int)this.end()), BoxesRunTime.boxToInteger((int)this.step())}));
    }

    private Nothing$ fail() {
        throw new IllegalArgumentException(this.description() + ": seqs cannot contain more than Int.MaxValue elements.");
    }

    @Override
    public int apply(int idx) throws IndexOutOfBoundsException {
        this.validateMaxLength();
        if (idx < 0 || idx >= this.length()) {
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)idx)).toString());
        }
        return this.start() + this.step() * idx;
    }

    @Override
    public <U> void foreach(Function1<Object, U> f) {
        if (!this.isEmpty()) {
            int i = this.start();
            while (true) {
                f.apply((Object)BoxesRunTime.boxToInteger((int)i));
                if (i == this.strawman$collection$immutable$Range$$lastElement()) {
                    return;
                }
                i += this.step();
            }
        }
    }

    @Override
    public Range take(int n) {
        return n <= 0 || this.isEmpty() ? this.newEmptyRange(this.start()) : (n >= this.length() && this.length() >= 0 ? this : new Range(this.start(), this.locationAfterN(n - 1), this.step(), true));
    }

    @Override
    public Range drop(int n) {
        return n <= 0 || this.isEmpty() ? this : (n >= this.length() && this.length() >= 0 ? this.newEmptyRange(this.end()) : this.copy(this.locationAfterN(n), this.end(), this.step(), this.copy$default$4()));
    }

    @Override
    public Range takeRight(int n) {
        Range range;
        if (n <= 0) {
            range = this.newEmptyRange(this.start());
        } else if (this.length() >= 0) {
            range = this.drop(this.length() - n);
        } else {
            int y = this.last();
            long x = (long)y - (long)this.step() * (long)(n - 1);
            range = this.step() > 0 && x < (long)this.start() || this.step() < 0 && x > (long)this.start() ? this : Range$.MODULE$.inclusive((int)x, y, this.step());
        }
        return range;
    }

    @Override
    public Range dropRight(int n) {
        Range range;
        if (n <= 0) {
            range = this;
        } else if (this.length() >= 0) {
            range = this.take(this.length() - n);
        } else {
            int y = this.last() - this.step() * n;
            range = this.step() > 0 && y < this.start() || this.step() < 0 && y > this.start() ? this.newEmptyRange(this.start()) : Range$.MODULE$.inclusive(this.start(), y, this.step());
        }
        return range;
    }

    private long argTakeWhile(Function1<Object, Object> p) {
        long l;
        if (this.isEmpty()) {
            l = this.start();
        } else {
            int current;
            int stop = this.last();
            for (current = this.start(); current != stop && p.apply$mcZI$sp(current); current += this.step()) {
            }
            l = current != stop || !p.apply$mcZI$sp(current) ? (long)current : (long)current + (long)this.step();
        }
        return l;
    }

    @Override
    public Range takeWhile(Function1<Object, Object> p) {
        int x;
        long stop = this.argTakeWhile(p);
        return stop == (long)this.start() ? this.newEmptyRange(this.start()) : ((x = (int)(stop - (long)this.step())) == this.last() ? this : Range$.MODULE$.inclusive(this.start(), x, this.step()));
    }

    @Override
    public Range dropWhile(Function1<Object, Object> p) {
        int x;
        long stop = this.argTakeWhile(p);
        return stop == (long)this.start() ? this : ((x = (int)(stop - (long)this.step())) == this.last() ? this.newEmptyRange(this.last()) : Range$.MODULE$.inclusive(x + this.step(), this.last(), this.step()));
    }

    @Override
    public Tuple2<Range, Range> span(Function1<Object, Object> p) {
        int x;
        long border = this.argTakeWhile(p);
        return border == (long)this.start() ? new Tuple2((Object)this.newEmptyRange(this.start()), (Object)this) : ((x = (int)(border - (long)this.step())) == this.last() ? new Tuple2((Object)this, (Object)this.newEmptyRange(this.last())) : new Tuple2((Object)Range$.MODULE$.inclusive(this.start(), x, this.step()), (Object)Range$.MODULE$.inclusive(x + this.step(), this.last(), this.step())));
    }

    @Override
    public Range slice(int from, int until) {
        Range range;
        if (from <= 0) {
            range = this.take(until);
        } else if (until >= this.length() && this.length() >= 0) {
            range = this.drop(from);
        } else {
            int fromValue = this.locationAfterN(from);
            range = from >= until ? this.newEmptyRange(fromValue) : Range$.MODULE$.inclusive(fromValue, this.locationAfterN(until - 1), this.step());
        }
        return range;
    }

    @Override
    public Tuple2<Range, Range> splitAt(int n) {
        return new Tuple2((Object)this.take(n), (Object)this.drop(n));
    }

    private int locationAfterN(int n) {
        return this.start() + this.step() * n;
    }

    private Range newEmptyRange(int value) {
        return new Range(value, value, this.step(), false);
    }

    @Override
    public Range reverse() {
        return this.isEmpty() ? this : new Range(this.last(), this.start(), -this.step(), true);
    }

    public Range inclusive() {
        return this.isInclusive() ? this : new Range(this.start(), this.end(), this.step(), true);
    }

    @Override
    public boolean contains(int x) {
        return x == this.end() && !this.isInclusive() ? false : (this.step() > 0 ? (x < this.start() || x > this.end() ? false : this.step() == 1 || (x - this.start()) % this.step() == 0) : (x < this.end() || x > this.start() ? false : this.step() == -1 || (x - this.start()) % this.step() == 0));
    }

    @Override
    public <B> int sum(Numeric<B> num) {
        int n;
        if (num == Numeric.IntIsIntegral$.MODULE$) {
            n = this.isEmpty() ? 0 : (this.size() == 1 ? this.head() : (int)((long)this.size() * ((long)this.head() + (long)this.last()) / 2L));
        } else if (this.isEmpty()) {
            n = num.toInt(num.zero());
        } else {
            Object acc = num.zero();
            int i = this.head();
            while (true) {
                acc = num.plus(acc, (Object)BoxesRunTime.boxToInteger((int)i));
                if (i == this.strawman$collection$immutable$Range$$lastElement()) {
                    return num.toInt(acc);
                }
                i += this.step();
            }
        }
        return n;
    }

    @Override
    public <A1> int min(Ordering<A1> ord) {
        return ord == Ordering.Int$.MODULE$ ? (this.step() > 0 ? this.head() : this.last()) : BoxesRunTime.unboxToInt((Object)IterableOps.min$(this, ord));
    }

    @Override
    public <A1> int max(Ordering<A1> ord) {
        return ord == Ordering.Int$.MODULE$ ? (this.step() > 0 ? this.last() : this.head()) : BoxesRunTime.unboxToInt((Object)IterableOps.max$(this, ord));
    }

    @Override
    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof Range) {
            int l0;
            Range range = (Range)object;
            bl = this.isEmpty() ? range.isEmpty() : range.nonEmpty() && this.start() == range.start() && (l0 = this.last()) == range.last() && (this.start() == l0 || this.step() == range.step());
        } else {
            bl = strawman.collection.SeqOps.equals$(this, other);
        }
        return bl;
    }

    @Override
    public String toString() {
        String stepped;
        String preposition = this.isInclusive() ? "to" : "until";
        String string = stepped = this.step() == 1 ? "" : new StringContext((scala.collection.Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" by ", ""})).s((scala.collection.Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.step())}));
        String prefix = this.isEmpty() ? "empty " : (!this.isExact() ? "inexact " : "");
        return new StringContext((scala.collection.Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "Range ", " ", " ", "", ""})).s((scala.collection.Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix, BoxesRunTime.boxToInteger((int)this.start()), preposition, BoxesRunTime.boxToInteger((int)this.end()), stepped}));
    }

    public void foreach$mVc$sp(Function1<Object, BoxedUnit> f) {
        if (!this.isEmpty()) {
            int i = this.start();
            while (true) {
                f.apply$mcVI$sp(i);
                if (i == this.strawman$collection$immutable$Range$$lastElement()) {
                    return;
                }
                i += this.step();
            }
        }
    }

    public Range(int start, int end, int step, boolean isInclusive) {
        int n;
        long len;
        this.start = start;
        this.end = end;
        this.step = step;
        this.isInclusive = isInclusive;
        IterableOps.$init$(this);
        Iterable.$init$(this);
        strawman.collection.SeqOps.$init$(this);
        Seq.$init$(this);
        SeqOps.$init$(this);
        IndexedSeqOps.$init$(this);
        StrictOptimizedIterableOps.$init$(this);
        StrictOptimizedSeqOps.$init$(this);
        boolean bl = this.isEmpty = start > end && step > 0 || start < end && step < 0 || start == end && !isInclusive;
        if (step == 0) {
            throw new IllegalArgumentException("step cannot be 0.");
        }
        this.length = this.isEmpty() ? 0 : ((len = this.longLength()) > Integer.MAX_VALUE ? -1 : (int)len);
        int n2 = step;
        switch (n2) {
            case 1: {
                if (isInclusive) {
                    n = end;
                    break;
                }
                n = end - 1;
                break;
            }
            case -1: {
                if (isInclusive) {
                    n = end;
                    break;
                }
                n = end + 1;
                break;
            }
            default: {
                int remainder = (int)(this.gap() % (long)step);
                if (remainder != 0) {
                    n = end - remainder;
                    break;
                }
                if (isInclusive) {
                    n = end;
                    break;
                }
                n = end - step;
                break;
            }
        }
        this.strawman$collection$immutable$Range$$lastElement = n;
    }
}

