/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.immutable;

import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import strawman.collection.immutable.Map;
import strawman.collection.immutable.Map$;
import strawman.collection.immutable.NumericRange;
import strawman.collection.immutable.Range$;

public final class NumericRange$
implements Serializable {
    public static NumericRange$ MODULE$;
    private final Map<Numeric<?>, Ordering<?>> defaultOrdering;

    static {
        new NumericRange$();
    }

    public <T> int count(T start, T end, T step, boolean isInclusive, Integral<T> num) {
        int n;
        Object zero = num.zero();
        boolean upward = num.lt(start, end);
        boolean posStep = num.gt(step, zero);
        if (BoxesRunTime.equals(step, (Object)zero)) {
            throw new IllegalArgumentException("step cannot be 0.");
        }
        if (BoxesRunTime.equals(start, end)) {
            n = isInclusive ? 1 : 0;
        } else if (upward != posStep) {
            n = 0;
        } else {
            Object object;
            int endside;
            int stepint;
            int endint;
            int startint = num.toInt(start);
            if (BoxesRunTime.equals(start, (Object)num.fromInt(startint)) && BoxesRunTime.equals(end, (Object)num.fromInt(endint = num.toInt(end))) && BoxesRunTime.equals(step, (Object)num.fromInt(stepint = num.toInt(step)))) {
                return isInclusive ? Range$.MODULE$.inclusive(startint, endint, stepint).length() : Range$.MODULE$.apply(startint, endint, stepint).length();
            }
            Object one = num.one();
            Object limit = num.fromInt(Integer.MAX_VALUE);
            int startside = num.signum(start);
            if (startside * (endside = num.signum(end)) >= 0) {
                Object diff = num.minus(end, start);
                Object quotient = NumericRange$.check$1(num.quot(diff, step), num, limit);
                Object remainder = num.minus(diff, num.times(quotient, step));
                object = !isInclusive && BoxesRunTime.equals((Object)zero, (Object)remainder) ? quotient : NumericRange$.check$1(num.plus(quotient, one), num, limit);
            } else {
                Object object2;
                Object negone = num.fromInt(-1);
                Object startlim = posStep ? negone : one;
                Object startdiff = num.minus(startlim, start);
                Object startq = NumericRange$.check$1(num.quot(startdiff, step), num, limit);
                Object waypointA = BoxesRunTime.equals((Object)startq, (Object)zero) ? start : num.plus(start, num.times(startq, step));
                Object waypointB = num.plus(waypointA, step);
                if (num.lt(waypointB, end) != upward) {
                    object2 = isInclusive && BoxesRunTime.equals((Object)waypointB, end) ? num.plus(startq, num.fromInt(2)) : num.plus(startq, one);
                } else {
                    Object enddiff = num.minus(end, waypointB);
                    Object endq = NumericRange$.check$1(num.quot(enddiff, step), num, limit);
                    Object last = BoxesRunTime.equals((Object)endq, (Object)zero) ? waypointB : num.plus(waypointB, num.times(endq, step));
                    object2 = num.plus(startq, num.plus(endq, !isInclusive && BoxesRunTime.equals((Object)last, end) ? one : num.fromInt(2)));
                }
                object = NumericRange$.check$1(object2, num, limit);
            }
            n = num.toInt(object);
        }
        return n;
    }

    public <T> NumericRange<T> apply(T start, T end, T step, Integral<T> num) {
        return new NumericRange<T>(start, end, step, false, num);
    }

    public <T> NumericRange<T> inclusive(T start, T end, T step, Integral<T> num) {
        return new NumericRange<T>(start, end, step, true, num);
    }

    public Map<Numeric<?>, Ordering<?>> defaultOrdering() {
        return this.defaultOrdering;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final Object check$1(Object t, Integral num$1, Object limit$1) {
        if (num$1.gt(t, limit$1)) {
            throw new IllegalArgumentException("More than Int.MaxValue elements.");
        }
        return t;
    }

    private NumericRange$() {
        MODULE$ = this;
        this.defaultOrdering = (Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Numeric.BigIntIsIntegral$.MODULE$), (Object)Ordering.BigInt$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Numeric.IntIsIntegral$.MODULE$), (Object)Ordering.Int$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Numeric.ShortIsIntegral$.MODULE$), (Object)Ordering.Short$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Numeric.ByteIsIntegral$.MODULE$), (Object)Ordering.Byte$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Numeric.CharIsIntegral$.MODULE$), (Object)Ordering.Char$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Numeric.LongIsIntegral$.MODULE$), (Object)Ordering.Long$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Numeric.FloatAsIfIntegral$.MODULE$), (Object)Ordering.Float$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Numeric.DoubleAsIfIntegral$.MODULE$), (Object)Ordering.Double$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Numeric.BigDecimalAsIfIntegral$.MODULE$), (Object)Ordering.BigDecimal$.MODULE$)}));
    }
}

