/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.concurrent;

import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.math.Equiv;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import strawman.collection.ArrayOps;
import strawman.collection.ArrayOps$;
import strawman.collection.IterableFactory$;
import strawman.collection.IterableOnce;
import strawman.collection.IterableOps;
import strawman.collection.Seq;
import strawman.collection.concurrent.BasicNode;
import strawman.collection.concurrent.CNode$;
import strawman.collection.concurrent.CNodeBase;
import strawman.collection.concurrent.Gen;
import strawman.collection.concurrent.INode;
import strawman.collection.concurrent.LNode;
import strawman.collection.concurrent.MainNode;
import strawman.collection.concurrent.SNode;
import strawman.collection.concurrent.TNode;
import strawman.collection.concurrent.TrieMap;
import strawman.collection.immutable.List$;
import strawman.collection.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005%f!B\u0001\u0003\u0005\u0011A!!B\"O_\u0012,'BA\u0002\u0005\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u000b\u0019\t!bY8mY\u0016\u001cG/[8o\u0015\u00059\u0011\u0001C:ue\u0006<X.\u00198\u0016\u0007%\u0001bd\u0005\u0002\u0001\u0015A!1\u0002\u0004\b\u001e\u001b\u0005\u0011\u0011BA\u0007\u0003\u0005%\u0019ej\u001c3f\u0005\u0006\u001cX\r\u0005\u0002\u0010!1\u0001A!B\t\u0001\u0005\u0004\u0019\"!A&\u0004\u0001E\u0011AC\u0007\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\b\u001d>$\b.\u001b8h!\t)2$\u0003\u0002\u001d-\t\u0019\u0011I\\=\u0011\u0005=qB!B\u0010\u0001\u0005\u0004\u0019\"!\u0001,\t\u0011\u0005\u0002!Q1A\u0005\u0002\t\naAY5u[\u0006\u0004X#A\u0012\u0011\u0005U!\u0013BA\u0013\u0017\u0005\rIe\u000e\u001e\u0005\tO\u0001\u0011\t\u0011)A\u0005G\u00059!-\u001b;nCB\u0004\u0003\u0002C\u0015\u0001\u0005\u000b\u0007I\u0011\u0001\u0016\u0002\u000b\u0005\u0014(/Y=\u0016\u0003-\u00022!\u0006\u0017/\u0013\ticCA\u0003BeJ\f\u0017\u0010\u0005\u0002\f_%\u0011\u0001G\u0001\u0002\n\u0005\u0006\u001c\u0018n\u0019(pI\u0016D\u0001B\r\u0001\u0003\u0002\u0003\u0006IaK\u0001\u0007CJ\u0014\u0018-\u001f\u0011\t\u0011Q\u0002!Q1A\u0005\u0002U\n1aZ3o+\u00051\u0004CA\u00068\u0013\tA$AA\u0002HK:D\u0001B\u000f\u0001\u0003\u0002\u0003\u0006IAN\u0001\u0005O\u0016t\u0007\u0005C\u0003=\u0001\u0011\u0005Q(\u0001\u0004=S:LGO\u0010\u000b\u0005}}\u0002\u0015\t\u0005\u0003\f\u00019i\u0002\"B\u0011<\u0001\u0004\u0019\u0003\"B\u0015<\u0001\u0004Y\u0003\"\u0002\u001b<\u0001\u00041\u0004\"B\"\u0001\t\u0003!\u0015AC2bG\",GmU5{KR\u00111%\u0012\u0005\u0006\r\n\u0003\raR\u0001\u0003GR\u0004\"!\u0006%\n\u0005%3\"AB!osJ+g\rC\u0003L\u0001\u0011%A*A\u0006d_6\u0004X\u000f^3TSj,GCA\u0012N\u0011\u00151%\n1\u0001O!\u0011YqJD\u000f\n\u0005A\u0013!a\u0002+sS\u0016l\u0015\r\u001d\u0005\u0006%\u0002!\taU\u0001\nkB$\u0017\r^3e\u0003R$BA\u0010+W1\")Q+\u0015a\u0001G\u0005\u0019\u0001o\\:\t\u000b]\u000b\u0006\u0019\u0001\u0018\u0002\u00059t\u0007\"\u0002\u001bR\u0001\u00041\u0004\"\u0002.\u0001\t\u0003Y\u0016!\u0003:f[>4X\rZ!u)\u0011qD,X0\t\u000bUK\u0006\u0019A\u0012\t\u000byK\u0006\u0019A\u0012\u0002\t\u0019d\u0017m\u001a\u0005\u0006ie\u0003\rA\u000e\u0005\u0006C\u0002!\tAY\u0001\u000bS:\u001cXM\u001d;fI\u0006#H#\u0002 dI\u00164\u0007\"B+a\u0001\u0004\u0019\u0003\"\u00020a\u0001\u0004\u0019\u0003\"B,a\u0001\u0004q\u0003\"\u0002\u001ba\u0001\u00041\u0004\"\u00025\u0001\t\u0003I\u0017a\u0002:f]\u0016<X\r\u001a\u000b\u0004})d\u0007\"B6h\u0001\u00041\u0014\u0001\u00028hK:DQAR4A\u00029CQA\u001c\u0001\u0005\n=\f\u0011B]3tkJ\u0014Xm\u0019;\u0015\u00079\u0002X\u000fC\u0003r[\u0002\u0007!/A\u0003j]>$W\r\u0005\u0003\fg:i\u0012B\u0001;\u0003\u0005\u0015Iej\u001c3f\u0011\u00151X\u000e1\u0001H\u0003%Ign\u001c3f[\u0006Lg\u000eC\u0003y\u0001\u0011\u0005\u00110\u0001\u0007u_\u000e{g\u000e\u001e:bGR,G\r\u0006\u0002{{B!1b\u001f\b\u001e\u0013\ta(A\u0001\u0005NC&tgj\u001c3f\u0011\u0015qx\u000f1\u0001$\u0003\raWM\u001e\u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u00031!xnQ8naJ,7o]3e)\u001dQ\u0018QAA\u0004\u0003\u0013AQAR@A\u00029CQA`@A\u0002\rBQ\u0001N@A\u0002YB\u0001\"!\u0004\u0001\t\u0003\u0011\u0011qB\u0001\u0007gR\u0014\u0018N\\4\u0015\t\u0005E\u0011\u0011\u0005\t\u0005\u0003'\ti\"\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003\u0011a\u0017M\\4\u000b\u0005\u0005m\u0011\u0001\u00026bm\u0006LA!a\b\u0002\u0016\t11\u000b\u001e:j]\u001eDaA`A\u0006\u0001\u0004\u0019\u0003bBA\u0013\u0001\u0011%\u0011qE\u0001\rG>dG.Z2u\u000b2,Wn]\u000b\u0003\u0003S\u0001b!a\u000b\u0002.\u0005ER\"\u0001\u0003\n\u0007\u0005=BAA\u0002TKF\u0004R!FA\u001a\u001duI1!!\u000e\u0017\u0005\u0019!V\u000f\u001d7fe!9\u0011\u0011\b\u0001\u0005\n\u0005m\u0012!E2pY2,7\r\u001e'pG\u0006dW\t\\3ngV\u0011\u0011Q\b\t\u0007\u0003W\ti#!\u0005\t\u000f\u0005\u0005\u0003\u0001\"\u0011\u0002D\u0005AAo\\*ue&tw\r\u0006\u0002\u0002FA!\u0011qIA+\u001d\u0011\tI%!\u0015\u0011\u0007\u0005-c#\u0004\u0002\u0002N)\u0019\u0011q\n\n\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019FF\u0001\u0007!J,G-\u001a4\n\t\u0005}\u0011q\u000b\u0006\u0004\u0003'2r\u0001CA.\u0005!\u0005!!!\u0018\u0002\u000b\rsu\u000eZ3\u0011\u0007-\tyFB\u0004\u0002\u0005!\u0005!!!\u0019\u0014\u0007\u0005}s\tC\u0004=\u0003?\"\t!!\u001a\u0015\u0005\u0005u\u0003\u0002CA5\u0003?\"\t!a\u001b\u0002\t\u0011,\u0018\r\\\u000b\u0007\u0003[\n\u0019(a\u001e\u0015!\u0005=\u0014\u0011PAB\u0003\u000f\u000bY)a$\u0002\u0012\u0006M\u0005CB\u0006|\u0003c\n)\bE\u0002\u0010\u0003g\"a!EA4\u0005\u0004\u0019\u0002cA\b\u0002x\u00111q$a\u001aC\u0002MA\u0001\"a\u001f\u0002h\u0001\u0007\u0011QP\u0001\u0002qB91\"a \u0002r\u0005U\u0014bAAA\u0005\t)1KT8eK\"9\u0011QQA4\u0001\u0004\u0019\u0013a\u0001=iG\"A\u0011\u0011RA4\u0001\u0004\ti(A\u0001z\u0011\u001d\ti)a\u001aA\u0002\r\n1!\u001f5d\u0011\u0019q\u0018q\ra\u0001G!1A'a\u001aA\u0002YB\u0001\"!&\u0002h\u0001\u0007\u0011qS\u0001\u0006KF,\u0018N\u001e\t\u0007\u00033\u000b\u0019+!\u001d\u000f\t\u0005m\u0015q\u0014\b\u0005\u0003\u0017\ni*C\u0001\u0018\u0013\r\t\tKF\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)+a*\u0003\u000b\u0015\u000bX/\u001b<\u000b\u0007\u0005\u0005f\u0003")
public final class CNode<K, V>
extends CNodeBase<K, V> {
    private final int bitmap;
    private final BasicNode[] array;
    private final Gen gen;

    public static <K, V> MainNode<K, V> dual(SNode<K, V> sNode, int n, SNode<K, V> sNode2, int n2, int n3, Gen gen, Equiv<K> equiv) {
        return CNode$.MODULE$.dual(sNode, n, sNode2, n2, n3, gen, equiv);
    }

    public int bitmap() {
        return this.bitmap;
    }

    public BasicNode[] array() {
        return this.array;
    }

    public Gen gen() {
        return this.gen;
    }

    @Override
    public int cachedSize(Object ct) {
        int n;
        int currsz = this.READ_SIZE();
        if (currsz != -1) {
            n = currsz;
        } else {
            int sz = this.computeSize((TrieMap)ct);
            while (this.READ_SIZE() == -1) {
                this.CAS_SIZE(-1, sz);
            }
            n = this.READ_SIZE();
        }
        return n;
    }

    private int computeSize(TrieMap<K, V> ct) {
        int offset;
        int sz = 0;
        int n = offset = this.array().length > 0 ? ThreadLocalRandom.current().nextInt(0, this.array().length) : 0;
        for (int i = 0; i < this.array().length; ++i) {
            BoxedUnit boxedUnit;
            int pos = (i + offset) % this.array().length;
            BasicNode basicNode = this.array()[pos];
            if (basicNode instanceof SNode) {
                ++sz;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (basicNode instanceof INode) {
                INode iNode = (INode)basicNode;
                sz += iNode.cachedSize(ct);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            throw new MatchError((Object)basicNode);
        }
        return sz;
    }

    public CNode<K, V> updatedAt(int pos, BasicNode nn, Gen gen) {
        int len = this.array().length;
        BasicNode[] narr = new BasicNode[len];
        Array$.MODULE$.copy((Object)this.array(), 0, (Object)narr, 0, len);
        narr[pos] = nn;
        return new CNode<K, V>(this.bitmap(), narr, gen);
    }

    public CNode<K, V> removedAt(int pos, int flag, Gen gen) {
        BasicNode[] arr = this.array();
        int len = arr.length;
        BasicNode[] narr = new BasicNode[len - 1];
        Array$.MODULE$.copy((Object)arr, 0, (Object)narr, 0, pos);
        Array$.MODULE$.copy((Object)arr, pos + 1, (Object)narr, pos, len - pos - 1);
        return new CNode<K, V>(this.bitmap() ^ flag, narr, gen);
    }

    public CNode<K, V> insertedAt(int pos, int flag, BasicNode nn, Gen gen) {
        int len = this.array().length;
        int bmp = this.bitmap();
        BasicNode[] narr = new BasicNode[len + 1];
        Array$.MODULE$.copy((Object)this.array(), 0, (Object)narr, 0, pos);
        narr[pos] = nn;
        Array$.MODULE$.copy((Object)this.array(), pos, (Object)narr, pos + 1, len - pos);
        return new CNode<K, V>(bmp | flag, narr, gen);
    }

    public CNode<K, V> renewed(Gen ngen, TrieMap<K, V> ct) {
        BasicNode[] arr = this.array();
        int len = arr.length;
        BasicNode[] narr = new BasicNode[len];
        for (int i = 0; i < len; ++i) {
            BoxedUnit boxedUnit;
            BasicNode basicNode = arr[i];
            if (basicNode instanceof INode) {
                INode iNode = (INode)basicNode;
                narr[i] = iNode.copyToGen(ngen, ct);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (basicNode != null) {
                BasicNode basicNode2;
                narr[i] = basicNode2 = basicNode;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            throw new MatchError((Object)basicNode);
        }
        return new CNode<K, V>(this.bitmap(), narr, ngen);
    }

    private BasicNode resurrect(INode<K, V> inode, Object inodemain) {
        BasicNode basicNode;
        Object object = inodemain;
        if (object instanceof TNode) {
            TNode tNode = (TNode)object;
            basicNode = tNode.copyUntombed();
        } else {
            basicNode = inode;
        }
        return basicNode;
    }

    public MainNode<K, V> toContracted(int lev) {
        CNode cNode;
        if (this.array().length == 1 && lev > 0) {
            MainNode mainNode;
            BasicNode basicNode = this.array()[0];
            if (basicNode instanceof SNode) {
                SNode sNode = (SNode)basicNode;
                mainNode = sNode.copyTombed();
            } else {
                mainNode = this;
            }
            cNode = mainNode;
        } else {
            cNode = this;
        }
        return cNode;
    }

    public MainNode<K, V> toCompressed(TrieMap<K, V> ct, int lev, Gen gen) {
        int bmp = this.bitmap();
        BasicNode[] arr = this.array();
        BasicNode[] tmparray = new BasicNode[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            BoxedUnit boxedUnit;
            BasicNode sub = arr[i];
            BasicNode basicNode = sub;
            if (basicNode instanceof INode) {
                INode iNode = (INode)basicNode;
                MainNode<K, V> inodemain = iNode.gcasRead(ct);
                Predef$.MODULE$.assert(inodemain != null);
                tmparray[i] = this.resurrect(iNode, inodemain);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (basicNode instanceof SNode) {
                SNode sNode = (SNode)basicNode;
                tmparray[i] = sNode;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            throw new MatchError((Object)basicNode);
        }
        return new CNode<K, V>(bmp, tmparray, gen).toContracted(lev);
    }

    @Override
    public String string(int lev) {
        return new StringOps(Predef$.MODULE$.augmentString("CNode %x\n%s")).format((scala.collection.Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.bitmap()), new ArrayOps(package$.MODULE$.arrayToArrayOps(ArrayOps$.MODULE$.map$extension(package$.MODULE$.arrayToArrayOps(this.array()), (Function1 & Serializable & scala.Serializable)x$8 -> x$8.string(lev + 1), ClassTag$.MODULE$.apply(String.class)))).mkString("\n")}));
    }

    private Seq<Tuple2<K, V>> collectElems() {
        return (Seq)new ArrayOps(package$.MODULE$.arrayToArrayOps(this.array())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            IterableOnce iterableOnce;
            BasicNode basicNode = x0$1;
            if (basicNode instanceof SNode) {
                SNode sNode = (SNode)basicNode;
                iterableOnce = package$.MODULE$.optionToIterableOnce(new Some(sNode.kvPair()));
            } else if (basicNode instanceof INode) {
                IterableOnce iterableOnce2;
                INode iNode = (INode)basicNode;
                MainNode mainNode = iNode.mainnode;
                if (mainNode instanceof TNode) {
                    TNode tNode = (TNode)mainNode;
                    iterableOnce2 = package$.MODULE$.optionToIterableOnce(new Some(tNode.kvPair()));
                } else if (mainNode instanceof LNode) {
                    LNode lNode = (LNode)mainNode;
                    iterableOnce2 = lNode.entries().to(IterableFactory$.MODULE$.toFactory(List$.MODULE$));
                } else if (mainNode instanceof CNode) {
                    CNode cNode = (CNode)mainNode;
                    iterableOnce2 = cNode.collectElems();
                } else {
                    throw new MatchError((Object)mainNode);
                }
                iterableOnce = iterableOnce2;
            } else {
                throw new MatchError((Object)basicNode);
            }
            return iterableOnce;
        });
    }

    private Seq<String> collectLocalElems() {
        return (Seq)new ArrayOps(package$.MODULE$.arrayToArrayOps(this.array())).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            IterableOnce iterableOnce;
            BasicNode basicNode = x0$2;
            if (basicNode instanceof SNode) {
                SNode sNode = (SNode)basicNode;
                iterableOnce = package$.MODULE$.optionToIterableOnce(new Some((Object)sNode.kvPair()._2().toString()));
            } else if (basicNode instanceof INode) {
                INode iNode = (INode)basicNode;
                iterableOnce = package$.MODULE$.optionToIterableOnce(new Some((Object)((String)new StringOps(Predef$.MODULE$.augmentString(iNode.toString())).drop(14) + "(" + iNode.gen + ")")));
            } else {
                throw new MatchError((Object)basicNode);
            }
            return iterableOnce;
        });
    }

    public String toString() {
        Seq<String> elems = this.collectLocalElems();
        return new StringOps(Predef$.MODULE$.augmentString("CNode(sz: %d; %s)")).format((scala.collection.Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)elems.size()), ((IterableOps)elems.sorted(Ordering.String$.MODULE$)).mkString(", ")}));
    }

    public CNode(int bitmap, BasicNode[] array, Gen gen) {
        this.bitmap = bitmap;
        this.array = array;
        this.gen = gen;
    }
}

