/*
 * Decompiled with CFR 0.152.
 */
package strawman.collection.immutable;

import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import strawman.collection.Iterator;
import strawman.collection.immutable.RedBlackTree;
import strawman.collection.immutable.RedBlackTree$BlackTree$;
import strawman.collection.immutable.RedBlackTree$NList$;
import strawman.collection.immutable.RedBlackTree$RedTree$;

public final class RedBlackTree$ {
    public static RedBlackTree$ MODULE$;

    static {
        new RedBlackTree$();
    }

    public boolean isEmpty(RedBlackTree.Tree<?, ?> tree) {
        return tree == null;
    }

    public <A> boolean contains(RedBlackTree.Tree<A, ?> tree, A x, Ordering<A> evidence$1) {
        return this.lookup(tree, x, evidence$1) != null;
    }

    public <A, B> Option<B> get(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> evidence$2) {
        RedBlackTree.Tree<A, B> tree2 = this.lookup(tree, x, evidence$2);
        Object object = tree2 == null ? None$.MODULE$ : new Some(tree2.value());
        return object;
    }

    public <A, B> RedBlackTree.Tree<A, B> lookup(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> ordering) {
        RedBlackTree.Tree<A, B> tree2;
        block3: {
            while (true) {
                if (tree == null) {
                    tree2 = null;
                    break block3;
                }
                int cmp = ordering.compare(x, tree.key());
                if (cmp < 0) {
                    tree = tree.left();
                    continue;
                }
                if (cmp <= 0) break;
                tree = tree.right();
            }
            tree2 = tree;
        }
        return tree2;
    }

    public int count(RedBlackTree.Tree<?, ?> tree) {
        return tree == null ? 0 : tree.count();
    }

    public <A> int countInRange(RedBlackTree.Tree<A, ?> tree, Option<A> from, Option<A> to, Ordering<A> ordering) {
        int n;
        block6: {
            int n2;
            block7: {
                while (true) {
                    Option option;
                    Option option2;
                    if (tree == null) {
                        n = 0;
                        break block6;
                    }
                    Tuple2 tuple2 = new Tuple2(from, to);
                    if (tuple2 != null) {
                        Option option3 = (Option)tuple2._1();
                        Option option4 = (Option)tuple2._2();
                        if (None$.MODULE$.equals(option3) && None$.MODULE$.equals(option4)) {
                            n2 = tree.count();
                            break block7;
                        }
                    }
                    if (tuple2 != null && (option2 = (Option)tuple2._1()) instanceof Some) {
                        Some some = (Some)option2;
                        Object lb = some.value();
                        if (ordering.lt(tree.key(), lb)) {
                            tree = tree.right();
                            continue;
                        }
                    }
                    if (tuple2 == null || !((option = (Option)tuple2._2()) instanceof Some)) break;
                    Some some = (Some)option;
                    Object ub = some.value();
                    if (!ordering.gteq(tree.key(), ub)) break;
                    tree = tree.left();
                }
                n2 = 1 + this.countInRange(tree.left(), from, (Option<A>)None$.MODULE$, ordering) + this.countInRange(tree.right(), (Option<A>)None$.MODULE$, to, ordering);
            }
            n = n2;
        }
        return n;
    }

    public <A, B, B1> RedBlackTree.Tree<A, B1> update(RedBlackTree.Tree<A, B> tree, A k, B1 v, boolean overwrite, Ordering<A> evidence$3) {
        return this.blacken(this.upd(tree, k, v, overwrite, evidence$3));
    }

    public <A, B> RedBlackTree.Tree<A, B> delete(RedBlackTree.Tree<A, B> tree, A k, Ordering<A> evidence$4) {
        return this.blacken(this.del(tree, k, evidence$4));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public <A, B> RedBlackTree.Tree<A, B> rangeImpl(RedBlackTree.Tree<A, B> tree, Option<A> from, Option<A> until, Ordering<A> evidence$5) {
        void var5_16;
        Tuple2 tuple2 = new Tuple2(from, until);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Object from2 = some.value();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Object until2 = some2.value();
                    RedBlackTree.Tree<Object, B> tree2 = this.range(tree, from2, until2, evidence$5);
                    return var5_16;
                }
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Object from3 = some.value();
                if (None$.MODULE$.equals(option3)) {
                    RedBlackTree.Tree<Object, B> tree3 = this.from(tree, from3, evidence$5);
                    return var5_16;
                }
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option4 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && option4 instanceof Some) {
                Some some = (Some)option4;
                Object until3 = some.value();
                RedBlackTree.Tree<Object, B> tree4 = this.until(tree, until3, evidence$5);
                return var5_16;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Option option = (Option)tuple2._1();
        Option option5 = (Option)tuple2._2();
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
        if (!None$.MODULE$.equals(option5)) throw new MatchError((Object)tuple2);
        RedBlackTree.Tree<A, B> tree5 = tree;
        return var5_16;
    }

    public <A, B> RedBlackTree.Tree<A, B> range(RedBlackTree.Tree<A, B> tree, A from, A until, Ordering<A> evidence$6) {
        return this.blacken(this.doRange(tree, from, until, evidence$6));
    }

    public <A, B> RedBlackTree.Tree<A, B> from(RedBlackTree.Tree<A, B> tree, A from, Ordering<A> evidence$7) {
        return this.blacken(this.doFrom(tree, from, evidence$7));
    }

    public <A, B> RedBlackTree.Tree<A, B> to(RedBlackTree.Tree<A, B> tree, A to, Ordering<A> evidence$8) {
        return this.blacken(this.doTo(tree, to, evidence$8));
    }

    public <A, B> RedBlackTree.Tree<A, B> until(RedBlackTree.Tree<A, B> tree, A key, Ordering<A> evidence$9) {
        return this.blacken(this.doUntil(tree, key, evidence$9));
    }

    public <A, B> RedBlackTree.Tree<A, B> drop(RedBlackTree.Tree<A, B> tree, int n, Ordering<A> evidence$10) {
        return this.blacken(this.doDrop(tree, n));
    }

    public <A, B> RedBlackTree.Tree<A, B> take(RedBlackTree.Tree<A, B> tree, int n, Ordering<A> evidence$11) {
        return this.blacken(this.doTake(tree, n));
    }

    public <A, B> RedBlackTree.Tree<A, B> slice(RedBlackTree.Tree<A, B> tree, int from, int until, Ordering<A> evidence$12) {
        return this.blacken(this.doSlice(tree, from, until));
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> RedBlackTree.Tree<A, B> smallest(RedBlackTree.Tree<A, B> tree) {
        void var2_2;
        if (tree == null) {
            throw new NoSuchElementException("empty map");
        }
        RedBlackTree.Tree<A, B> result = tree;
        while (result.left() != null) {
            result = result.left();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> RedBlackTree.Tree<A, B> greatest(RedBlackTree.Tree<A, B> tree) {
        void var2_2;
        if (tree == null) {
            throw new NoSuchElementException("empty map");
        }
        RedBlackTree.Tree<A, B> result = tree;
        while (result.right() != null) {
            result = result.right();
        }
        return var2_2;
    }

    public <A, B> RedBlackTree.Tree<A, B> minAfter(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> ordering) {
        RedBlackTree.Tree<A, B> tree2;
        while (true) {
            if (tree == null) {
                tree2 = null;
                break;
            }
            int cmp = ordering.compare(x, tree.key());
            if (cmp == 0) {
                tree2 = tree;
                break;
            }
            if (cmp < 0) {
                RedBlackTree.Tree<A, B> l = this.minAfter(tree.left(), x, ordering);
                if (l != null) {
                    tree2 = l;
                    break;
                }
                tree2 = tree;
                break;
            }
            tree = tree.right();
        }
        return tree2;
    }

    public <A, B> RedBlackTree.Tree<A, B> maxBefore(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> ordering) {
        RedBlackTree.Tree<A, B> tree2;
        block2: {
            while (true) {
                if (tree == null) {
                    tree2 = null;
                    break block2;
                }
                int cmp = ordering.compare(x, tree.key());
                if (cmp > 0) break;
                tree = tree.left();
            }
            RedBlackTree.Tree<A, B> r = this.maxBefore(tree.right(), x, ordering);
            tree2 = r != null ? r : tree;
        }
        return tree2;
    }

    public <A, B, U> void foreach(RedBlackTree.Tree<A, B> tree, Function1<Tuple2<A, B>, U> f) {
        block0: {
            if (tree == null) break block0;
            this._foreach(tree, f);
        }
    }

    private <A, B, U> void _foreach(RedBlackTree.Tree<A, B> tree, Function1<Tuple2<A, B>, U> f) {
        while (true) {
            if (tree.left() != null) {
                this._foreach(tree.left(), f);
            }
            f.apply((Object)new Tuple2(tree.key(), tree.value()));
            if (tree.right() == null) break;
            tree = tree.right();
        }
    }

    public <A, U> void foreachKey(RedBlackTree.Tree<A, ?> tree, Function1<A, U> f) {
        block0: {
            if (tree == null) break block0;
            this._foreachKey(tree, f);
        }
    }

    private <A, U> void _foreachKey(RedBlackTree.Tree<A, ?> tree, Function1<A, U> f) {
        while (true) {
            if (tree.left() != null) {
                this._foreachKey(tree.left(), f);
            }
            f.apply(tree.key());
            if (tree.right() == null) break;
            tree = tree.right();
        }
    }

    public <A, B> Iterator<Tuple2<A, B>> iterator(RedBlackTree.Tree<A, B> tree, Option<A> start, Ordering<A> evidence$13) {
        return new RedBlackTree.EntriesIterator<A, B>(tree, start, evidence$13);
    }

    public <A, B> None$ iterator$default$2() {
        return None$.MODULE$;
    }

    public <A> Iterator<A> keysIterator(RedBlackTree.Tree<A, ?> tree, Option<A> start, Ordering<A> evidence$14) {
        return new RedBlackTree.KeysIterator(tree, start, evidence$14);
    }

    public <A> None$ keysIterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> Iterator<B> valuesIterator(RedBlackTree.Tree<A, B> tree, Option<A> start, Ordering<A> evidence$15) {
        return new RedBlackTree.ValuesIterator<A, B>(tree, start, evidence$15);
    }

    public <A, B> None$ valuesIterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> RedBlackTree.Tree<A, B> nth(RedBlackTree.Tree<A, B> tree, int n) {
        while (true) {
            int count;
            if (n < (count = this.count(tree.left()))) {
                tree = tree.left();
                continue;
            }
            if (n <= count) break;
            n = n - count - 1;
            tree = tree.right();
        }
        return tree;
    }

    public boolean isBlack(RedBlackTree.Tree<?, ?> tree) {
        return tree == null || this.isBlackTree(tree);
    }

    private boolean isRedTree(RedBlackTree.Tree<?, ?> tree) {
        return tree instanceof RedBlackTree.RedTree;
    }

    private boolean isBlackTree(RedBlackTree.Tree<?, ?> tree) {
        return tree instanceof RedBlackTree.BlackTree;
    }

    private <A, B> RedBlackTree.Tree<A, B> blacken(RedBlackTree.Tree<A, B> t) {
        return t == null ? null : t.black();
    }

    private <A, B> RedBlackTree.Tree<A, B> mkTree(boolean isBlack, A k, B v, RedBlackTree.Tree<A, B> l, RedBlackTree.Tree<A, B> r) {
        return isBlack ? RedBlackTree$BlackTree$.MODULE$.apply(k, v, l, r) : RedBlackTree$RedTree$.MODULE$.apply(k, v, l, r);
    }

    private <A, B, B1> RedBlackTree.Tree<A, B1> balanceLeft(boolean isBlack, A z, B zv, RedBlackTree.Tree<A, B1> l, RedBlackTree.Tree<A, B1> d) {
        return this.isRedTree(l) && this.isRedTree(l.left()) ? RedBlackTree$RedTree$.MODULE$.apply(l.key(), l.value(), RedBlackTree$BlackTree$.MODULE$.apply(l.left().key(), l.left().value(), l.left().left(), l.left().right()), RedBlackTree$BlackTree$.MODULE$.apply(z, zv, l.right(), d)) : (this.isRedTree(l) && this.isRedTree(l.right()) ? RedBlackTree$RedTree$.MODULE$.apply(l.right().key(), l.right().value(), RedBlackTree$BlackTree$.MODULE$.apply(l.key(), l.value(), l.left(), l.right().left()), RedBlackTree$BlackTree$.MODULE$.apply(z, zv, l.right().right(), d)) : this.mkTree(isBlack, z, zv, l, d));
    }

    private <A, B, B1> RedBlackTree.Tree<A, B1> balanceRight(boolean isBlack, A x, B xv, RedBlackTree.Tree<A, B1> a, RedBlackTree.Tree<A, B1> r) {
        return this.isRedTree(r) && this.isRedTree(r.left()) ? RedBlackTree$RedTree$.MODULE$.apply(r.left().key(), r.left().value(), RedBlackTree$BlackTree$.MODULE$.apply(x, xv, a, r.left().left()), RedBlackTree$BlackTree$.MODULE$.apply(r.key(), r.value(), r.left().right(), r.right())) : (this.isRedTree(r) && this.isRedTree(r.right()) ? RedBlackTree$RedTree$.MODULE$.apply(r.key(), r.value(), RedBlackTree$BlackTree$.MODULE$.apply(x, xv, a, r.left()), RedBlackTree$BlackTree$.MODULE$.apply(r.right().key(), r.right().value(), r.right().left(), r.right().right())) : this.mkTree(isBlack, x, xv, a, r));
    }

    private <A, B, B1> RedBlackTree.Tree<A, B1> upd(RedBlackTree.Tree<A, B> tree, A k, B1 v, boolean overwrite, Ordering<A> ordering) {
        int cmp;
        return tree == null ? RedBlackTree$RedTree$.MODULE$.apply(k, v, null, null) : ((cmp = ordering.compare(k, tree.key())) < 0 ? this.balanceLeft(this.isBlackTree(tree), tree.key(), tree.value(), this.upd(tree.left(), k, v, overwrite, ordering), tree.right()) : (cmp > 0 ? this.balanceRight(this.isBlackTree(tree), tree.key(), tree.value(), tree.left(), this.upd(tree.right(), k, v, overwrite, ordering)) : (overwrite || !BoxesRunTime.equals(k, tree.key()) ? this.mkTree(this.isBlackTree(tree), k, v, tree.left(), tree.right()) : tree)));
    }

    private <A, B, B1> RedBlackTree.Tree<A, B1> updNth(RedBlackTree.Tree<A, B> tree, int idx, A k, B1 v, boolean overwrite) {
        int rank;
        return tree == null ? RedBlackTree$RedTree$.MODULE$.apply(k, v, null, null) : (idx < (rank = this.count(tree.left()) + 1) ? this.balanceLeft(this.isBlackTree(tree), tree.key(), tree.value(), this.updNth(tree.left(), idx, k, v, overwrite), tree.right()) : (idx > rank ? this.balanceRight(this.isBlackTree(tree), tree.key(), tree.value(), tree.left(), this.updNth(tree.right(), idx - rank, k, v, overwrite)) : (overwrite ? this.mkTree(this.isBlackTree(tree), k, v, tree.left(), tree.right()) : tree)));
    }

    private <A, B> RedBlackTree.Tree<A, B> del(RedBlackTree.Tree<A, B> tree, A k, Ordering<A> ordering) {
        int cmp;
        return tree == null ? null : ((cmp = ordering.compare(k, tree.key())) < 0 ? this.delLeft$1(tree, k, ordering) : (cmp > 0 ? this.delRight$1(tree, k, ordering) : this.append$1(tree.left(), tree.right())));
    }

    private <A, B> RedBlackTree.Tree<A, B> doFrom(RedBlackTree.Tree<A, B> tree, A from, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lt(tree.key(), from)) {
            return this.doFrom(tree.right(), from, ordering);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doFrom(tree.left(), from, ordering);
        return newLeft == tree.left() ? tree : (newLeft == null ? this.upd(tree.right(), tree.key(), tree.value(), false, ordering) : this.rebalance(tree, newLeft, tree.right()));
    }

    private <A, B> RedBlackTree.Tree<A, B> doTo(RedBlackTree.Tree<A, B> tree, A to, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lt(to, tree.key())) {
            return this.doTo(tree.left(), to, ordering);
        }
        RedBlackTree.Tree<A, B> newRight = this.doTo(tree.right(), to, ordering);
        return newRight == tree.right() ? tree : (newRight == null ? this.upd(tree.left(), tree.key(), tree.value(), false, ordering) : this.rebalance(tree, tree.left(), newRight));
    }

    private <A, B> RedBlackTree.Tree<A, B> doUntil(RedBlackTree.Tree<A, B> tree, A until, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lteq(until, tree.key())) {
            return this.doUntil(tree.left(), until, ordering);
        }
        RedBlackTree.Tree<A, B> newRight = this.doUntil(tree.right(), until, ordering);
        return newRight == tree.right() ? tree : (newRight == null ? this.upd(tree.left(), tree.key(), tree.value(), false, ordering) : this.rebalance(tree, tree.left(), newRight));
    }

    private <A, B> RedBlackTree.Tree<A, B> doRange(RedBlackTree.Tree<A, B> tree, A from, A until, Ordering<A> ordering) {
        if (tree == null) {
            return null;
        }
        if (ordering.lt(tree.key(), from)) {
            return this.doRange(tree.right(), from, until, ordering);
        }
        if (ordering.lteq(until, tree.key())) {
            return this.doRange(tree.left(), from, until, ordering);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doFrom(tree.left(), from, ordering);
        RedBlackTree.Tree<A, B> newRight = this.doUntil(tree.right(), until, ordering);
        return newLeft == tree.left() && newRight == tree.right() ? tree : (newLeft == null ? this.upd(newRight, tree.key(), tree.value(), false, ordering) : (newRight == null ? this.upd(newLeft, tree.key(), tree.value(), false, ordering) : this.rebalance(tree, newLeft, newRight)));
    }

    private <A, B> RedBlackTree.Tree<A, B> doDrop(RedBlackTree.Tree<A, B> tree, int n) {
        if (n <= 0) {
            return tree;
        }
        if (n >= this.count(tree)) {
            return null;
        }
        int count = this.count(tree.left());
        if (n > count) {
            return this.doDrop(tree.right(), n - count - 1);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doDrop(tree.left(), n);
        return newLeft == tree.left() ? tree : (newLeft == null ? this.updNth(tree.right(), n - count - 1, tree.key(), tree.value(), false) : this.rebalance(tree, newLeft, tree.right()));
    }

    private <A, B> RedBlackTree.Tree<A, B> doTake(RedBlackTree.Tree<A, B> tree, int n) {
        if (n <= 0) {
            return null;
        }
        if (n >= this.count(tree)) {
            return tree;
        }
        int count = this.count(tree.left());
        if (n <= count) {
            return this.doTake(tree.left(), n);
        }
        RedBlackTree.Tree<A, B> newRight = this.doTake(tree.right(), n - count - 1);
        return newRight == tree.right() ? tree : (newRight == null ? this.updNth(tree.left(), n, tree.key(), tree.value(), false) : this.rebalance(tree, tree.left(), newRight));
    }

    private <A, B> RedBlackTree.Tree<A, B> doSlice(RedBlackTree.Tree<A, B> tree, int from, int until) {
        if (tree == null) {
            return null;
        }
        int count = this.count(tree.left());
        if (from > count) {
            return this.doSlice(tree.right(), from - count - 1, until - count - 1);
        }
        if (until <= count) {
            return this.doSlice(tree.left(), from, until);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doDrop(tree.left(), from);
        RedBlackTree.Tree<A, B> newRight = this.doTake(tree.right(), until - count - 1);
        return newLeft == tree.left() && newRight == tree.right() ? tree : (newLeft == null ? this.updNth(newRight, from - count - 1, tree.key(), tree.value(), false) : (newRight == null ? this.updNth(newLeft, until, tree.key(), tree.value(), false) : this.rebalance(tree, newLeft, newRight)));
    }

    private <A, B> Tuple4<RedBlackTree.NList<RedBlackTree.Tree<A, B>>, Object, Object, Object> compareDepth(RedBlackTree.Tree<A, B> left, RedBlackTree.Tree<A, B> right) {
        return this.unzipBoth$1(left, right, null, null, 0);
    }

    private <A, B> RedBlackTree.Tree<A, B> rebalance(RedBlackTree.Tree<A, B> tree2, RedBlackTree.Tree<A, B> newLeft, RedBlackTree.Tree<A, B> newRight) {
        RedBlackTree.Tree tree3;
        RedBlackTree.Tree<A, B> blkNewRight;
        RedBlackTree.Tree<A, B> blkNewLeft = this.blacken(newLeft);
        Tuple4<RedBlackTree.NList<RedBlackTree.Tree<A, B>>, Object, Object, Object> tuple4 = this.compareDepth(blkNewLeft, blkNewRight = this.blacken(newRight));
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        RedBlackTree.NList zipper = (RedBlackTree.NList)tuple4._1();
        boolean levelled = BoxesRunTime.unboxToBoolean((Object)tuple4._2());
        boolean leftMost = BoxesRunTime.unboxToBoolean((Object)tuple4._3());
        int smallerDepth = BoxesRunTime.unboxToInt((Object)tuple4._4());
        Tuple4 tuple42 = new Tuple4((Object)zipper, (Object)BoxesRunTime.boxToBoolean((boolean)levelled), (Object)BoxesRunTime.boxToBoolean((boolean)leftMost), (Object)BoxesRunTime.boxToInteger((int)smallerDepth));
        Tuple4 tuple43 = tuple42;
        RedBlackTree.NList zipper2 = (RedBlackTree.NList)tuple43._1();
        boolean levelled2 = BoxesRunTime.unboxToBoolean((Object)tuple43._2());
        boolean leftMost2 = BoxesRunTime.unboxToBoolean((Object)tuple43._3());
        int smallerDepth2 = BoxesRunTime.unboxToInt((Object)tuple43._4());
        if (levelled2) {
            tree3 = RedBlackTree$BlackTree$.MODULE$.apply(tree2.key(), tree2.value(), blkNewLeft, blkNewRight);
        } else {
            RedBlackTree.NList zipFrom = this.findDepth$1(zipper2, smallerDepth2);
            RedBlackTree.RedTree<A, B> union = leftMost2 ? RedBlackTree$RedTree$.MODULE$.apply(tree2.key(), tree2.value(), blkNewLeft, (RedBlackTree.Tree)zipFrom.head()) : RedBlackTree$RedTree$.MODULE$.apply(tree2.key(), tree2.value(), (RedBlackTree.Tree)zipFrom.head(), blkNewRight);
            RedBlackTree.Tree zippedTree = RedBlackTree$NList$.MODULE$.foldLeft(zipFrom.tail(), union, (Function2 & Serializable & scala.Serializable)(tree, node) -> leftMost2 ? MODULE$.balanceLeft(MODULE$.isBlackTree((RedBlackTree.Tree<?, ?>)node), node.key(), node.value(), (RedBlackTree.Tree)tree, node.right()) : MODULE$.balanceRight(MODULE$.isBlackTree((RedBlackTree.Tree<?, ?>)node), node.key(), node.value(), node.left(), (RedBlackTree.Tree)tree));
            tree3 = zippedTree;
        }
        return tree3;
    }

    private final RedBlackTree.Tree balance$1(Object x, Object xv, RedBlackTree.Tree tl, RedBlackTree.Tree tr) {
        return this.isRedTree(tl) ? (this.isRedTree(tr) ? RedBlackTree$RedTree$.MODULE$.apply(x, xv, tl.black(), tr.black()) : (this.isRedTree(tl.left()) ? RedBlackTree$RedTree$.MODULE$.apply(tl.key(), tl.value(), tl.left().black(), RedBlackTree$BlackTree$.MODULE$.apply(x, xv, tl.right(), tr)) : (this.isRedTree(tl.right()) ? RedBlackTree$RedTree$.MODULE$.apply(tl.right().key(), tl.right().value(), RedBlackTree$BlackTree$.MODULE$.apply(tl.key(), tl.value(), tl.left(), tl.right().left()), RedBlackTree$BlackTree$.MODULE$.apply(x, xv, tl.right().right(), tr)) : RedBlackTree$BlackTree$.MODULE$.apply(x, xv, tl, tr)))) : (this.isRedTree(tr) ? (this.isRedTree(tr.right()) ? RedBlackTree$RedTree$.MODULE$.apply(tr.key(), tr.value(), RedBlackTree$BlackTree$.MODULE$.apply(x, xv, tl, tr.left()), tr.right().black()) : (this.isRedTree(tr.left()) ? RedBlackTree$RedTree$.MODULE$.apply(tr.left().key(), tr.left().value(), RedBlackTree$BlackTree$.MODULE$.apply(x, xv, tl, tr.left().left()), RedBlackTree$BlackTree$.MODULE$.apply(tr.key(), tr.value(), tr.left().right(), tr.right())) : RedBlackTree$BlackTree$.MODULE$.apply(x, xv, tl, tr))) : RedBlackTree$BlackTree$.MODULE$.apply(x, xv, tl, tr));
    }

    private static final RedBlackTree.Tree subl$1(RedBlackTree.Tree t) {
        if (!(t instanceof RedBlackTree.BlackTree)) {
            throw package$.MODULE$.error("Defect: invariance violation; expected black, got " + t);
        }
        return t.red();
    }

    private final RedBlackTree.Tree balLeft$1(Object x, Object xv, RedBlackTree.Tree tl, RedBlackTree.Tree tr) {
        RedBlackTree.Tree tree;
        if (this.isRedTree(tl)) {
            tree = RedBlackTree$RedTree$.MODULE$.apply(x, xv, tl.black(), tr);
        } else if (this.isBlackTree(tr)) {
            tree = this.balance$1(x, xv, tl, tr.red());
        } else if (this.isRedTree(tr) && this.isBlackTree(tr.left())) {
            tree = RedBlackTree$RedTree$.MODULE$.apply(tr.left().key(), tr.left().value(), RedBlackTree$BlackTree$.MODULE$.apply(x, xv, tl, tr.left().left()), this.balance$1(tr.key(), tr.value(), tr.left().right(), RedBlackTree$.subl$1(tr.right())));
        } else {
            throw package$.MODULE$.error("Defect: invariance violation");
        }
        return tree;
    }

    private final RedBlackTree.Tree balRight$1(Object x, Object xv, RedBlackTree.Tree tl, RedBlackTree.Tree tr) {
        RedBlackTree.Tree tree;
        if (this.isRedTree(tr)) {
            tree = RedBlackTree$RedTree$.MODULE$.apply(x, xv, tl, tr.black());
        } else if (this.isBlackTree(tl)) {
            tree = this.balance$1(x, xv, tl.red(), tr);
        } else if (this.isRedTree(tl) && this.isBlackTree(tl.right())) {
            tree = RedBlackTree$RedTree$.MODULE$.apply(tl.right().key(), tl.right().value(), this.balance$1(tl.key(), tl.value(), RedBlackTree$.subl$1(tl.left()), tl.right().left()), RedBlackTree$BlackTree$.MODULE$.apply(x, xv, tl.right().right(), tr));
        } else {
            throw package$.MODULE$.error("Defect: invariance violation");
        }
        return tree;
    }

    private final RedBlackTree.Tree delLeft$1(RedBlackTree.Tree tree$1, Object k$1, Ordering ordering$1) {
        return this.isBlackTree(tree$1.left()) ? this.balLeft$1(tree$1.key(), tree$1.value(), this.del(tree$1.left(), k$1, ordering$1), tree$1.right()) : RedBlackTree$RedTree$.MODULE$.apply(tree$1.key(), tree$1.value(), this.del(tree$1.left(), k$1, ordering$1), tree$1.right());
    }

    private final RedBlackTree.Tree delRight$1(RedBlackTree.Tree tree$1, Object k$1, Ordering ordering$1) {
        return this.isBlackTree(tree$1.right()) ? this.balRight$1(tree$1.key(), tree$1.value(), tree$1.left(), this.del(tree$1.right(), k$1, ordering$1)) : RedBlackTree$RedTree$.MODULE$.apply(tree$1.key(), tree$1.value(), tree$1.left(), this.del(tree$1.right(), k$1, ordering$1));
    }

    private final RedBlackTree.Tree append$1(RedBlackTree.Tree tl, RedBlackTree.Tree tr) {
        RedBlackTree.Tree tree;
        if (tl == null) {
            tree = tr;
        } else if (tr == null) {
            tree = tl;
        } else if (this.isRedTree(tl) && this.isRedTree(tr)) {
            RedBlackTree.Tree bc = this.append$1(tl.right(), tr.left());
            tree = this.isRedTree(bc) ? RedBlackTree$RedTree$.MODULE$.apply(bc.key(), bc.value(), RedBlackTree$RedTree$.MODULE$.apply(tl.key(), tl.value(), tl.left(), bc.left()), RedBlackTree$RedTree$.MODULE$.apply(tr.key(), tr.value(), bc.right(), tr.right())) : RedBlackTree$RedTree$.MODULE$.apply(tl.key(), tl.value(), tl.left(), RedBlackTree$RedTree$.MODULE$.apply(tr.key(), tr.value(), bc, tr.right()));
        } else if (this.isBlackTree(tl) && this.isBlackTree(tr)) {
            RedBlackTree.Tree bc = this.append$1(tl.right(), tr.left());
            tree = this.isRedTree(bc) ? RedBlackTree$RedTree$.MODULE$.apply(bc.key(), bc.value(), RedBlackTree$BlackTree$.MODULE$.apply(tl.key(), tl.value(), tl.left(), bc.left()), RedBlackTree$BlackTree$.MODULE$.apply(tr.key(), tr.value(), bc.right(), tr.right())) : this.balLeft$1(tl.key(), tl.value(), tl.left(), RedBlackTree$BlackTree$.MODULE$.apply(tr.key(), tr.value(), bc, tr.right()));
        } else if (this.isRedTree(tr)) {
            tree = RedBlackTree$RedTree$.MODULE$.apply(tr.key(), tr.value(), this.append$1(tl, tr.left()), tr.right());
        } else if (this.isRedTree(tl)) {
            tree = RedBlackTree$RedTree$.MODULE$.apply(tl.key(), tl.value(), tl.left(), this.append$1(tl.right(), tr));
        } else {
            throw package$.MODULE$.error("unmatched tree on append: " + tl + ", " + tr);
        }
        return tree;
    }

    private final RedBlackTree.NList unzip$1(RedBlackTree.NList zipper, boolean leftMost) {
        while (true) {
            RedBlackTree.Tree next;
            RedBlackTree.Tree tree = next = leftMost ? ((RedBlackTree.Tree)zipper.head()).left() : ((RedBlackTree.Tree)zipper.head()).right();
            if (next == null) break;
            zipper = RedBlackTree$NList$.MODULE$.cons(next, zipper);
        }
        return zipper;
    }

    private final Tuple4 unzipBoth$1(RedBlackTree.Tree left, RedBlackTree.Tree right, RedBlackTree.NList leftZipper, RedBlackTree.NList rightZipper, int smallerDepth) {
        Tuple4 tuple4;
        while (true) {
            if (this.isBlackTree(left) && this.isBlackTree(right)) {
                ++smallerDepth;
                rightZipper = RedBlackTree$NList$.MODULE$.cons(right, rightZipper);
                leftZipper = RedBlackTree$NList$.MODULE$.cons(left, leftZipper);
                right = right.left();
                left = left.right();
                continue;
            }
            if (this.isRedTree(left) && this.isRedTree(right)) {
                rightZipper = RedBlackTree$NList$.MODULE$.cons(right, rightZipper);
                leftZipper = RedBlackTree$NList$.MODULE$.cons(left, leftZipper);
                right = right.left();
                left = left.right();
                continue;
            }
            if (this.isRedTree(right)) {
                rightZipper = RedBlackTree$NList$.MODULE$.cons(right, rightZipper);
                right = right.left();
                continue;
            }
            if (!this.isRedTree(left)) break;
            leftZipper = RedBlackTree$NList$.MODULE$.cons(left, leftZipper);
            left = left.right();
        }
        if (left == null && right == null) {
            tuple4 = new Tuple4(null, (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)smallerDepth));
        } else if (left == null && this.isBlackTree(right)) {
            boolean leftMost = true;
            tuple4 = new Tuple4((Object)this.unzip$1(RedBlackTree$NList$.MODULE$.cons(right, rightZipper), leftMost), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)leftMost), (Object)BoxesRunTime.boxToInteger((int)smallerDepth));
        } else if (this.isBlackTree(left) && right == null) {
            boolean leftMost = false;
            tuple4 = new Tuple4((Object)this.unzip$1(RedBlackTree$NList$.MODULE$.cons(left, leftZipper), leftMost), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)leftMost), (Object)BoxesRunTime.boxToInteger((int)smallerDepth));
        } else {
            throw package$.MODULE$.error("unmatched trees in unzip: " + left + ", " + right);
        }
        return tuple4;
    }

    private final RedBlackTree.NList findDepth$1(RedBlackTree.NList zipper, int depth) {
        while (true) {
            if (zipper == null) {
                throw package$.MODULE$.error("Defect: unexpected empty zipper while computing range");
            }
            if (this.isBlackTree((RedBlackTree.Tree)zipper.head())) {
                if (depth == 1) break;
                --depth;
                zipper = zipper.tail();
                continue;
            }
            zipper = zipper.tail();
        }
        return zipper;
    }

    private RedBlackTree$() {
        MODULE$ = this;
    }
}

