/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import com.sun.jna.LastErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import sbt.internal.NGUnixDomainSocketLibrary;
import sbt.internal.ReferenceCountedFileDescriptor;

public class NGUnixDomainSocket
extends Socket {
    private final ReferenceCountedFileDescriptor fd;
    private final InputStream is;
    private final OutputStream os;

    public NGUnixDomainSocket(String string) throws IOException {
        try {
            AtomicInteger atomicInteger = new AtomicInteger(NGUnixDomainSocketLibrary.socket(1, 1, 0));
            NGUnixDomainSocketLibrary.SockaddrUn sockaddrUn = new NGUnixDomainSocketLibrary.SockaddrUn(string);
            int n = atomicInteger.get();
            NGUnixDomainSocketLibrary.connect(n, sockaddrUn, sockaddrUn.size());
            this.fd = new ReferenceCountedFileDescriptor(n);
            this.is = new NGUnixDomainSocketInputStream();
            this.os = new NGUnixDomainSocketOutputStream();
        }
        catch (LastErrorException lastErrorException) {
            throw new IOException(lastErrorException);
        }
    }

    public NGUnixDomainSocket(int n) {
        this.fd = new ReferenceCountedFileDescriptor(n);
        this.is = new NGUnixDomainSocketInputStream();
        this.os = new NGUnixDomainSocketOutputStream();
    }

    @Override
    public InputStream getInputStream() {
        return this.is;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.os;
    }

    @Override
    public void shutdownInput() throws IOException {
        this.doShutdown(0);
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.doShutdown(1);
    }

    private void doShutdown(int n) throws IOException {
        try {
            int n2 = this.fd.acquire();
            if (n2 != -1) {
                NGUnixDomainSocketLibrary.shutdown(n2, n);
            }
        }
        catch (LastErrorException lastErrorException) {
            throw new IOException(lastErrorException);
        }
        finally {
            this.fd.release();
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        try {
            this.fd.close();
        }
        catch (LastErrorException lastErrorException) {
            throw new IOException(lastErrorException);
        }
    }

    private class NGUnixDomainSocketOutputStream
    extends OutputStream {
        private NGUnixDomainSocketOutputStream() {
        }

        @Override
        public void write(int n) throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.allocate(1);
            byteBuffer.put(0, (byte)(0xFF & n));
            this.doWrite(byteBuffer);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (n2 == 0) {
                return;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
            this.doWrite(byteBuffer);
        }

        private void doWrite(ByteBuffer byteBuffer) throws IOException {
            try {
                int n = NGUnixDomainSocket.this.fd.acquire();
                if (n == -1) {
                    return;
                }
                int n2 = NGUnixDomainSocketLibrary.write(n, byteBuffer, byteBuffer.remaining());
                if (n2 != byteBuffer.remaining()) {
                    throw new IOException("Could not write " + byteBuffer.remaining() + " bytes as requested (wrote " + n2 + " bytes instead)");
                }
            }
            catch (LastErrorException lastErrorException) {
                throw new IOException(lastErrorException);
            }
            finally {
                NGUnixDomainSocket.this.fd.release();
            }
        }
    }

    private class NGUnixDomainSocketInputStream
    extends InputStream {
        private NGUnixDomainSocketInputStream() {
        }

        @Override
        public int read() throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.allocate(1);
            int n = this.doRead(byteBuffer) == 0 ? -1 : 0xFF & byteBuffer.get();
            return n;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (n2 == 0) {
                return 0;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
            int n3 = this.doRead(byteBuffer);
            if (n3 == 0) {
                n3 = -1;
            }
            return n3;
        }

        private int doRead(ByteBuffer byteBuffer) throws IOException {
            try {
                int n = NGUnixDomainSocket.this.fd.acquire();
                if (n == -1) {
                    int n2 = -1;
                    return n2;
                }
                int n3 = NGUnixDomainSocketLibrary.read(n, byteBuffer, byteBuffer.remaining());
                return n3;
            }
            catch (LastErrorException lastErrorException) {
                throw new IOException(lastErrorException);
            }
            finally {
                NGUnixDomainSocket.this.fd.release();
            }
        }
    }
}

