/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import com.sun.jna.LastErrorException;
import java.io.IOException;
import sbt.internal.NGUnixDomainSocketLibrary;

public class ReferenceCountedFileDescriptor {
    private int fd;
    private int fdRefCount;
    private boolean closePending;

    public ReferenceCountedFileDescriptor(int n) {
        this.fd = n;
        this.fdRefCount = 0;
        this.closePending = false;
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public synchronized int acquire() {
        ++this.fdRefCount;
        return this.fd;
    }

    public synchronized void release() throws IOException {
        --this.fdRefCount;
        if (this.fdRefCount == 0 && this.closePending && this.fd != -1) {
            this.doClose();
        }
    }

    public synchronized void close() throws IOException {
        if (this.fd == -1 || this.closePending) {
            return;
        }
        if (this.fdRefCount == 0) {
            this.doClose();
        } else {
            this.closePending = true;
        }
    }

    private void doClose() throws IOException {
        try {
            NGUnixDomainSocketLibrary.close(this.fd);
            this.fd = -1;
        }
        catch (LastErrorException lastErrorException) {
            throw new IOException(lastErrorException);
        }
    }
}

