/*
 * Decompiled with CFR 0.152.
 */
package xsbti.compile;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import xsbti.compile.ClassFileManagerType;
import xsbti.compile.DefaultExternalHooks;
import xsbti.compile.ExternalHooks;

public final class IncOptions
implements Serializable {
    private int transitiveStep;
    private double recompileAllFraction;
    private boolean relationsDebug;
    private boolean apiDebug;
    private int apiDiffContextSize;
    private Optional<File> apiDumpDirectory;
    private Optional<ClassFileManagerType> classfileManagerType;
    private boolean useCustomizedFileManager;
    private Optional<Boolean> recompileOnMacroDef;
    private boolean useOptimizedSealed;
    private boolean storeApis;
    private boolean enabled;
    private Map<String, String> extra;
    private boolean logRecompileOnMacro;
    private ExternalHooks externalHooks;

    public static int defaultTransitiveStep() {
        return 3;
    }

    public static double defaultRecompileAllFraction() {
        return 0.5;
    }

    public static boolean defaultRelationsDebug() {
        return false;
    }

    public static boolean defaultApiDebug() {
        return false;
    }

    public static int defaultApiDiffContextSize() {
        return 5;
    }

    public static Optional<File> defaultApiDumpDirectory() {
        return Optional.empty();
    }

    public static Optional<ClassFileManagerType> defaultClassFileManagerType() {
        return Optional.empty();
    }

    public static Optional<Boolean> defaultRecompileOnMacroDef() {
        return Optional.empty();
    }

    public static boolean defaultUseOptimizedSealed() {
        return false;
    }

    public static boolean defaultRecompileOnMacroDefImpl() {
        return true;
    }

    public static boolean getRecompileOnMacroDef(IncOptions incOptions) {
        if (incOptions.recompileOnMacroDef().isPresent()) {
            return incOptions.recompileOnMacroDef().get();
        }
        return IncOptions.defaultRecompileOnMacroDefImpl();
    }

    public static boolean defaultUseCustomizedFileManager() {
        return false;
    }

    public static boolean defaultStoreApis() {
        return true;
    }

    public static boolean defaultEnabled() {
        return true;
    }

    public static Map<String, String> defaultExtra() {
        return new HashMap<String, String>();
    }

    public static ExternalHooks defaultExternal() {
        return new DefaultExternalHooks(Optional.empty(), Optional.empty());
    }

    public static boolean defaultLogRecompileOnMacro() {
        return true;
    }

    public static IncOptions create() {
        return new IncOptions();
    }

    public static IncOptions of() {
        return new IncOptions();
    }

    public static IncOptions create(int n, double d, boolean bl, boolean bl2, int n2, Optional<File> optional, Optional<ClassFileManagerType> optional2, boolean bl3, Optional<Boolean> optional3, boolean bl4, boolean bl5, boolean bl6, Map<String, String> map, boolean bl7, ExternalHooks externalHooks) {
        return new IncOptions(n, d, bl, bl2, n2, optional, optional2, bl3, optional3, bl4, bl5, bl6, map, bl7, externalHooks);
    }

    public static IncOptions of(int n, double d, boolean bl, boolean bl2, int n2, Optional<File> optional, Optional<ClassFileManagerType> optional2, boolean bl3, Optional<Boolean> optional3, boolean bl4, boolean bl5, boolean bl6, Map<String, String> map, boolean bl7, ExternalHooks externalHooks) {
        return new IncOptions(n, d, bl, bl2, n2, optional, optional2, bl3, optional3, bl4, bl5, bl6, map, bl7, externalHooks);
    }

    protected IncOptions() {
        this.transitiveStep = IncOptions.defaultTransitiveStep();
        this.recompileAllFraction = IncOptions.defaultRecompileAllFraction();
        this.relationsDebug = IncOptions.defaultRelationsDebug();
        this.apiDebug = IncOptions.defaultApiDebug();
        this.apiDiffContextSize = IncOptions.defaultApiDiffContextSize();
        this.apiDumpDirectory = IncOptions.defaultApiDumpDirectory();
        this.classfileManagerType = IncOptions.defaultClassFileManagerType();
        this.useCustomizedFileManager = IncOptions.defaultUseCustomizedFileManager();
        this.recompileOnMacroDef = IncOptions.defaultRecompileOnMacroDef();
        this.useOptimizedSealed = IncOptions.defaultUseOptimizedSealed();
        this.storeApis = IncOptions.defaultStoreApis();
        this.enabled = IncOptions.defaultEnabled();
        this.extra = IncOptions.defaultExtra();
        this.logRecompileOnMacro = IncOptions.defaultLogRecompileOnMacro();
        this.externalHooks = IncOptions.defaultExternal();
    }

    protected IncOptions(int n, double d, boolean bl, boolean bl2, int n2, Optional<File> optional, Optional<ClassFileManagerType> optional2, boolean bl3, Optional<Boolean> optional3, boolean bl4, boolean bl5, boolean bl6, Map<String, String> map, boolean bl7, ExternalHooks externalHooks) {
        this.transitiveStep = n;
        this.recompileAllFraction = d;
        this.relationsDebug = bl;
        this.apiDebug = bl2;
        this.apiDiffContextSize = n2;
        this.apiDumpDirectory = optional;
        this.classfileManagerType = optional2;
        this.useCustomizedFileManager = bl3;
        this.recompileOnMacroDef = optional3;
        this.useOptimizedSealed = bl4;
        this.storeApis = bl5;
        this.enabled = bl6;
        this.extra = map;
        this.logRecompileOnMacro = bl7;
        this.externalHooks = externalHooks;
    }

    public int transitiveStep() {
        return this.transitiveStep;
    }

    public double recompileAllFraction() {
        return this.recompileAllFraction;
    }

    public boolean relationsDebug() {
        return this.relationsDebug;
    }

    public boolean apiDebug() {
        return this.apiDebug;
    }

    public int apiDiffContextSize() {
        return this.apiDiffContextSize;
    }

    public Optional<File> apiDumpDirectory() {
        return this.apiDumpDirectory;
    }

    public Optional<ClassFileManagerType> classfileManagerType() {
        return this.classfileManagerType;
    }

    public boolean useCustomizedFileManager() {
        return this.useCustomizedFileManager;
    }

    public Optional<Boolean> recompileOnMacroDef() {
        return this.recompileOnMacroDef;
    }

    public boolean useOptimizedSealed() {
        return this.useOptimizedSealed;
    }

    public boolean storeApis() {
        return this.storeApis;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Map<String, String> extra() {
        return this.extra;
    }

    public boolean logRecompileOnMacro() {
        return this.logRecompileOnMacro;
    }

    public ExternalHooks externalHooks() {
        return this.externalHooks;
    }

    public IncOptions withTransitiveStep(int n) {
        return new IncOptions(n, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks);
    }

    public IncOptions withRecompileAllFraction(double d) {
        return new IncOptions(this.transitiveStep, d, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks);
    }

    public IncOptions withRelationsDebug(boolean bl) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, bl, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks);
    }

    public IncOptions withApiDebug(boolean bl) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, bl, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks);
    }

    public IncOptions withApiDiffContextSize(int n) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, n, this.apiDumpDirectory, this.classfileManagerType, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks);
    }

    public IncOptions withApiDumpDirectory(Optional<File> optional) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, optional, this.classfileManagerType, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks);
    }

    public IncOptions withClassfileManagerType(Optional<ClassFileManagerType> optional) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, optional, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks);
    }

    public IncOptions withUseCustomizedFileManager(boolean bl) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, bl, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks);
    }

    public IncOptions withRecompileOnMacroDef(Optional<Boolean> optional) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.useCustomizedFileManager, optional, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks);
    }

    public IncOptions withUseOptimizedSealed(boolean bl) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.useCustomizedFileManager, this.recompileOnMacroDef, bl, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks);
    }

    public IncOptions withStoreApis(boolean bl) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, bl, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks);
    }

    public IncOptions withEnabled(boolean bl) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, bl, this.extra, this.logRecompileOnMacro, this.externalHooks);
    }

    public IncOptions withExtra(Map<String, String> map) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, map, this.logRecompileOnMacro, this.externalHooks);
    }

    public IncOptions withLogRecompileOnMacro(boolean bl) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, bl, this.externalHooks);
    }

    public IncOptions withExternalHooks(ExternalHooks externalHooks) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, externalHooks);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IncOptions)) {
            return false;
        }
        IncOptions incOptions = (IncOptions)object;
        return this.transitiveStep() == incOptions.transitiveStep() && this.recompileAllFraction() == incOptions.recompileAllFraction() && this.relationsDebug() == incOptions.relationsDebug() && this.apiDebug() == incOptions.apiDebug() && this.apiDiffContextSize() == incOptions.apiDiffContextSize() && this.apiDumpDirectory().equals(incOptions.apiDumpDirectory()) && this.classfileManagerType().equals(incOptions.classfileManagerType()) && this.useCustomizedFileManager() == incOptions.useCustomizedFileManager() && this.recompileOnMacroDef().equals(incOptions.recompileOnMacroDef()) && this.useOptimizedSealed() == incOptions.useOptimizedSealed() && this.storeApis() == incOptions.storeApis() && this.enabled() == incOptions.enabled() && this.extra().equals(incOptions.extra()) && this.logRecompileOnMacro() == incOptions.logRecompileOnMacro() && this.externalHooks().equals(incOptions.externalHooks());
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (17 + "xsbti.compile.IncOptions".hashCode()) + new Integer(this.transitiveStep()).hashCode()) + new Double(this.recompileAllFraction()).hashCode()) + new Boolean(this.relationsDebug()).hashCode()) + new Boolean(this.apiDebug()).hashCode()) + new Integer(this.apiDiffContextSize()).hashCode()) + this.apiDumpDirectory().hashCode()) + this.classfileManagerType().hashCode()) + new Boolean(this.useCustomizedFileManager()).hashCode()) + this.recompileOnMacroDef().hashCode()) + new Boolean(this.useOptimizedSealed()).hashCode()) + new Boolean(this.storeApis()).hashCode()) + new Boolean(this.enabled()).hashCode()) + this.extra().hashCode()) + new Boolean(this.logRecompileOnMacro()).hashCode()) + this.externalHooks().hashCode());
    }

    public String toString() {
        return "IncOptions(transitiveStep: " + this.transitiveStep() + ", recompileAllFraction: " + this.recompileAllFraction() + ", relationsDebug: " + this.relationsDebug() + ", apiDebug: " + this.apiDebug() + ", apiDiffContextSize: " + this.apiDiffContextSize() + ", apiDumpDirectory: " + this.apiDumpDirectory() + ", classfileManagerType: " + this.classfileManagerType() + ", useCustomizedFileManager: " + this.useCustomizedFileManager() + ", recompileOnMacroDef: " + this.recompileOnMacroDef() + ", useOptimizedSealed: " + this.useOptimizedSealed() + ", storeApis: " + this.storeApis() + ", enabled: " + this.enabled() + ", extra: " + this.extra() + ", logRecompileOnMacro: " + this.logRecompileOnMacro() + ", externalHooks: " + this.externalHooks() + ")";
    }
}

