/*
 * Decompiled with CFR 0.152.
 */
package xsbti.compile;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import xsbti.Reporter;
import xsbti.T2;
import xsbti.compile.CompileProgress;
import xsbti.compile.GlobalsCache;
import xsbti.compile.IR;
import xsbti.compile.IncOptions;
import xsbti.compile.PerClasspathEntryLookup;

public final class Setup
implements Serializable {
    private PerClasspathEntryLookup perClasspathEntryLookup;
    private boolean skip;
    private File cacheFile;
    private GlobalsCache cache;
    private IncOptions incrementalCompilerOptions;
    private Reporter reporter;
    private Optional<CompileProgress> progress;
    private T2<String, String>[] extra;
    private CompletableFuture<IR[]> irPromise;

    public static CompletableFuture<IR[]> defaultIRPromise() {
        CompletableFuture<IR[]> completableFuture = new CompletableFuture<IR[]>();
        completableFuture.complete(new IR[0]);
        return completableFuture;
    }

    public static Setup create(PerClasspathEntryLookup perClasspathEntryLookup, boolean bl, File file, GlobalsCache globalsCache, IncOptions incOptions, Reporter reporter, Optional<CompileProgress> optional, T2<String, String>[] t2Array) {
        return new Setup(perClasspathEntryLookup, bl, file, globalsCache, incOptions, reporter, optional, t2Array);
    }

    public static Setup of(PerClasspathEntryLookup perClasspathEntryLookup, boolean bl, File file, GlobalsCache globalsCache, IncOptions incOptions, Reporter reporter, Optional<CompileProgress> optional, T2<String, String>[] t2Array) {
        return new Setup(perClasspathEntryLookup, bl, file, globalsCache, incOptions, reporter, optional, t2Array);
    }

    public static Setup create(PerClasspathEntryLookup perClasspathEntryLookup, boolean bl, File file, GlobalsCache globalsCache, IncOptions incOptions, Reporter reporter, Optional<CompileProgress> optional, T2<String, String>[] t2Array, CompletableFuture<IR[]> completableFuture) {
        return new Setup(perClasspathEntryLookup, bl, file, globalsCache, incOptions, reporter, optional, t2Array, completableFuture);
    }

    public static Setup of(PerClasspathEntryLookup perClasspathEntryLookup, boolean bl, File file, GlobalsCache globalsCache, IncOptions incOptions, Reporter reporter, Optional<CompileProgress> optional, T2<String, String>[] t2Array, CompletableFuture<IR[]> completableFuture) {
        return new Setup(perClasspathEntryLookup, bl, file, globalsCache, incOptions, reporter, optional, t2Array, completableFuture);
    }

    protected Setup(PerClasspathEntryLookup perClasspathEntryLookup, boolean bl, File file, GlobalsCache globalsCache, IncOptions incOptions, Reporter reporter, Optional<CompileProgress> optional, T2<String, String>[] t2Array) {
        this.perClasspathEntryLookup = perClasspathEntryLookup;
        this.skip = bl;
        this.cacheFile = file;
        this.cache = globalsCache;
        this.incrementalCompilerOptions = incOptions;
        this.reporter = reporter;
        this.progress = optional;
        this.extra = t2Array;
        this.irPromise = Setup.defaultIRPromise();
    }

    protected Setup(PerClasspathEntryLookup perClasspathEntryLookup, boolean bl, File file, GlobalsCache globalsCache, IncOptions incOptions, Reporter reporter, Optional<CompileProgress> optional, T2<String, String>[] t2Array, CompletableFuture<IR[]> completableFuture) {
        this.perClasspathEntryLookup = perClasspathEntryLookup;
        this.skip = bl;
        this.cacheFile = file;
        this.cache = globalsCache;
        this.incrementalCompilerOptions = incOptions;
        this.reporter = reporter;
        this.progress = optional;
        this.extra = t2Array;
        this.irPromise = completableFuture;
    }

    public PerClasspathEntryLookup perClasspathEntryLookup() {
        return this.perClasspathEntryLookup;
    }

    public boolean skip() {
        return this.skip;
    }

    public File cacheFile() {
        return this.cacheFile;
    }

    public GlobalsCache cache() {
        return this.cache;
    }

    public IncOptions incrementalCompilerOptions() {
        return this.incrementalCompilerOptions;
    }

    public Reporter reporter() {
        return this.reporter;
    }

    public Optional<CompileProgress> progress() {
        return this.progress;
    }

    public T2<String, String>[] extra() {
        return this.extra;
    }

    public CompletableFuture<IR[]> irPromise() {
        return this.irPromise;
    }

    public Setup withPerClasspathEntryLookup(PerClasspathEntryLookup perClasspathEntryLookup) {
        return new Setup(perClasspathEntryLookup, this.skip, this.cacheFile, this.cache, this.incrementalCompilerOptions, this.reporter, this.progress, this.extra, this.irPromise);
    }

    public Setup withSkip(boolean bl) {
        return new Setup(this.perClasspathEntryLookup, bl, this.cacheFile, this.cache, this.incrementalCompilerOptions, this.reporter, this.progress, this.extra, this.irPromise);
    }

    public Setup withCacheFile(File file) {
        return new Setup(this.perClasspathEntryLookup, this.skip, file, this.cache, this.incrementalCompilerOptions, this.reporter, this.progress, this.extra, this.irPromise);
    }

    public Setup withCache(GlobalsCache globalsCache) {
        return new Setup(this.perClasspathEntryLookup, this.skip, this.cacheFile, globalsCache, this.incrementalCompilerOptions, this.reporter, this.progress, this.extra, this.irPromise);
    }

    public Setup withIncrementalCompilerOptions(IncOptions incOptions) {
        return new Setup(this.perClasspathEntryLookup, this.skip, this.cacheFile, this.cache, incOptions, this.reporter, this.progress, this.extra, this.irPromise);
    }

    public Setup withReporter(Reporter reporter) {
        return new Setup(this.perClasspathEntryLookup, this.skip, this.cacheFile, this.cache, this.incrementalCompilerOptions, reporter, this.progress, this.extra, this.irPromise);
    }

    public Setup withProgress(Optional<CompileProgress> optional) {
        return new Setup(this.perClasspathEntryLookup, this.skip, this.cacheFile, this.cache, this.incrementalCompilerOptions, this.reporter, optional, this.extra, this.irPromise);
    }

    public Setup withExtra(T2<String, String>[] t2Array) {
        return new Setup(this.perClasspathEntryLookup, this.skip, this.cacheFile, this.cache, this.incrementalCompilerOptions, this.reporter, this.progress, t2Array, this.irPromise);
    }

    public Setup withIrPromise(CompletableFuture<IR[]> completableFuture) {
        return new Setup(this.perClasspathEntryLookup, this.skip, this.cacheFile, this.cache, this.incrementalCompilerOptions, this.reporter, this.progress, this.extra, completableFuture);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Setup)) {
            return false;
        }
        Setup setup = (Setup)object;
        return this.perClasspathEntryLookup().equals(setup.perClasspathEntryLookup()) && this.skip() == setup.skip() && this.cacheFile().equals(setup.cacheFile()) && this.cache().equals(setup.cache()) && this.incrementalCompilerOptions().equals(setup.incrementalCompilerOptions()) && this.reporter().equals(setup.reporter()) && this.progress().equals(setup.progress()) && Arrays.deepEquals(this.extra(), setup.extra()) && this.irPromise().equals(setup.irPromise());
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (17 + "xsbti.compile.Setup".hashCode()) + this.perClasspathEntryLookup().hashCode()) + new Boolean(this.skip()).hashCode()) + this.cacheFile().hashCode()) + this.cache().hashCode()) + this.incrementalCompilerOptions().hashCode()) + this.reporter().hashCode()) + this.progress().hashCode()) + Arrays.deepHashCode(this.extra())) + this.irPromise().hashCode());
    }

    public String toString() {
        return "Setup(perClasspathEntryLookup: " + this.perClasspathEntryLookup() + ", skip: " + this.skip() + ", cacheFile: " + this.cacheFile() + ", cache: " + this.cache() + ", incrementalCompilerOptions: " + this.incrementalCompilerOptions() + ", reporter: " + this.reporter() + ", progress: " + this.progress() + ", extra: " + this.extra() + ", irPromise: " + this.irPromise() + ")";
    }
}

