/*
 * Decompiled with CFR 0.152.
 */
package xsbti.compile;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import xsbti.Position;
import xsbti.compile.ClasspathOptions;
import xsbti.compile.CompileOrder;

public final class CompileOptions
implements Serializable {
    private File[] classpath;
    private File[] sources;
    private File classesDirectory;
    private String[] scalacOptions;
    private String[] javacOptions;
    private ClasspathOptions classpathOptions;
    private int maxErrors;
    private Function<Position, Position> sourcePositionMapper;
    private CompileOrder order;
    private Optional<File> temporaryClassesDirectory;

    public static CompileOptions create() {
        return new CompileOptions();
    }

    public static CompileOptions of() {
        return new CompileOptions();
    }

    public static CompileOptions create(File[] fileArray, File[] fileArray2, File file, String[] stringArray, String[] stringArray2, int n, Function<Position, Position> function, CompileOrder compileOrder) {
        return new CompileOptions(fileArray, fileArray2, file, stringArray, stringArray2, n, function, compileOrder);
    }

    public static CompileOptions of(File[] fileArray, File[] fileArray2, File file, String[] stringArray, String[] stringArray2, int n, Function<Position, Position> function, CompileOrder compileOrder) {
        return new CompileOptions(fileArray, fileArray2, file, stringArray, stringArray2, n, function, compileOrder);
    }

    public static CompileOptions create(File[] fileArray, File[] fileArray2, File file, String[] stringArray, String[] stringArray2, ClasspathOptions classpathOptions, int n, Function<Position, Position> function, CompileOrder compileOrder) {
        return new CompileOptions(fileArray, fileArray2, file, stringArray, stringArray2, classpathOptions, n, function, compileOrder);
    }

    public static CompileOptions of(File[] fileArray, File[] fileArray2, File file, String[] stringArray, String[] stringArray2, ClasspathOptions classpathOptions, int n, Function<Position, Position> function, CompileOrder compileOrder) {
        return new CompileOptions(fileArray, fileArray2, file, stringArray, stringArray2, classpathOptions, n, function, compileOrder);
    }

    public static CompileOptions create(File[] fileArray, File[] fileArray2, File file, String[] stringArray, String[] stringArray2, ClasspathOptions classpathOptions, int n, Function<Position, Position> function, CompileOrder compileOrder, Optional<File> optional) {
        return new CompileOptions(fileArray, fileArray2, file, stringArray, stringArray2, classpathOptions, n, function, compileOrder, optional);
    }

    public static CompileOptions of(File[] fileArray, File[] fileArray2, File file, String[] stringArray, String[] stringArray2, ClasspathOptions classpathOptions, int n, Function<Position, Position> function, CompileOrder compileOrder, Optional<File> optional) {
        return new CompileOptions(fileArray, fileArray2, file, stringArray, stringArray2, classpathOptions, n, function, compileOrder, optional);
    }

    protected CompileOptions() {
        this.classpath = new File[0];
        this.sources = new File[0];
        this.classesDirectory = new File("classes");
        this.scalacOptions = new String[0];
        this.javacOptions = new String[0];
        this.classpathOptions = ClasspathOptions.of(true, false, false, true, true);
        this.maxErrors = 100;
        this.sourcePositionMapper = new Function<Position, Position>(){

            @Override
            public Position apply(Position position) {
                return position;
            }
        };
        this.order = CompileOrder.Mixed;
        this.temporaryClassesDirectory = Optional.empty();
    }

    protected CompileOptions(File[] fileArray, File[] fileArray2, File file, String[] stringArray, String[] stringArray2, int n, Function<Position, Position> function, CompileOrder compileOrder) {
        this.classpath = fileArray;
        this.sources = fileArray2;
        this.classesDirectory = file;
        this.scalacOptions = stringArray;
        this.javacOptions = stringArray2;
        this.classpathOptions = ClasspathOptions.of(true, false, false, true, true);
        this.maxErrors = n;
        this.sourcePositionMapper = function;
        this.order = compileOrder;
        this.temporaryClassesDirectory = Optional.empty();
    }

    protected CompileOptions(File[] fileArray, File[] fileArray2, File file, String[] stringArray, String[] stringArray2, ClasspathOptions classpathOptions, int n, Function<Position, Position> function, CompileOrder compileOrder) {
        this.classpath = fileArray;
        this.sources = fileArray2;
        this.classesDirectory = file;
        this.scalacOptions = stringArray;
        this.javacOptions = stringArray2;
        this.classpathOptions = classpathOptions;
        this.maxErrors = n;
        this.sourcePositionMapper = function;
        this.order = compileOrder;
        this.temporaryClassesDirectory = Optional.empty();
    }

    protected CompileOptions(File[] fileArray, File[] fileArray2, File file, String[] stringArray, String[] stringArray2, ClasspathOptions classpathOptions, int n, Function<Position, Position> function, CompileOrder compileOrder, Optional<File> optional) {
        this.classpath = fileArray;
        this.sources = fileArray2;
        this.classesDirectory = file;
        this.scalacOptions = stringArray;
        this.javacOptions = stringArray2;
        this.classpathOptions = classpathOptions;
        this.maxErrors = n;
        this.sourcePositionMapper = function;
        this.order = compileOrder;
        this.temporaryClassesDirectory = optional;
    }

    public File[] classpath() {
        return this.classpath;
    }

    public File[] sources() {
        return this.sources;
    }

    public File classesDirectory() {
        return this.classesDirectory;
    }

    public String[] scalacOptions() {
        return this.scalacOptions;
    }

    public String[] javacOptions() {
        return this.javacOptions;
    }

    public ClasspathOptions classpathOptions() {
        return this.classpathOptions;
    }

    public int maxErrors() {
        return this.maxErrors;
    }

    public Function<Position, Position> sourcePositionMapper() {
        return this.sourcePositionMapper;
    }

    public CompileOrder order() {
        return this.order;
    }

    public Optional<File> temporaryClassesDirectory() {
        return this.temporaryClassesDirectory;
    }

    public CompileOptions withClasspath(File[] fileArray) {
        return new CompileOptions(fileArray, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.classpathOptions, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory);
    }

    public CompileOptions withSources(File[] fileArray) {
        return new CompileOptions(this.classpath, fileArray, this.classesDirectory, this.scalacOptions, this.javacOptions, this.classpathOptions, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory);
    }

    public CompileOptions withClassesDirectory(File file) {
        return new CompileOptions(this.classpath, this.sources, file, this.scalacOptions, this.javacOptions, this.classpathOptions, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory);
    }

    public CompileOptions withScalacOptions(String[] stringArray) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, stringArray, this.javacOptions, this.classpathOptions, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory);
    }

    public CompileOptions withJavacOptions(String[] stringArray) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, stringArray, this.classpathOptions, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory);
    }

    public CompileOptions withClasspathOptions(ClasspathOptions classpathOptions) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, classpathOptions, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory);
    }

    public CompileOptions withMaxErrors(int n) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.classpathOptions, n, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory);
    }

    public CompileOptions withSourcePositionMapper(Function<Position, Position> function) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.classpathOptions, this.maxErrors, function, this.order, this.temporaryClassesDirectory);
    }

    public CompileOptions withOrder(CompileOrder compileOrder) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.classpathOptions, this.maxErrors, this.sourcePositionMapper, compileOrder, this.temporaryClassesDirectory);
    }

    public CompileOptions withTemporaryClassesDirectory(Optional<File> optional) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.classpathOptions, this.maxErrors, this.sourcePositionMapper, this.order, optional);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CompileOptions)) {
            return false;
        }
        CompileOptions compileOptions = (CompileOptions)object;
        return Arrays.deepEquals(this.classpath(), compileOptions.classpath()) && Arrays.deepEquals(this.sources(), compileOptions.sources()) && this.classesDirectory().equals(compileOptions.classesDirectory()) && Arrays.deepEquals(this.scalacOptions(), compileOptions.scalacOptions()) && Arrays.deepEquals(this.javacOptions(), compileOptions.javacOptions()) && this.classpathOptions().equals(compileOptions.classpathOptions()) && this.maxErrors() == compileOptions.maxErrors() && this.sourcePositionMapper().equals(compileOptions.sourcePositionMapper()) && this.order().equals((Object)compileOptions.order()) && this.temporaryClassesDirectory().equals(compileOptions.temporaryClassesDirectory());
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (17 + "xsbti.compile.CompileOptions".hashCode()) + Arrays.deepHashCode(this.classpath())) + Arrays.deepHashCode(this.sources())) + this.classesDirectory().hashCode()) + Arrays.deepHashCode(this.scalacOptions())) + Arrays.deepHashCode(this.javacOptions())) + this.classpathOptions().hashCode()) + new Integer(this.maxErrors()).hashCode()) + this.sourcePositionMapper().hashCode()) + this.order().hashCode()) + this.temporaryClassesDirectory().hashCode());
    }

    public String toString() {
        return "CompileOptions(classpath: " + this.classpath() + ", sources: " + this.sources() + ", classesDirectory: " + this.classesDirectory() + ", scalacOptions: " + this.scalacOptions() + ", javacOptions: " + this.javacOptions() + ", classpathOptions: " + this.classpathOptions() + ", maxErrors: " + this.maxErrors() + ", sourcePositionMapper: " + this.sourcePositionMapper() + ", order: " + (Object)((Object)this.order()) + ", temporaryClassesDirectory: " + this.temporaryClassesDirectory() + ")";
    }
}

