/*
 * Decompiled with CFR 0.152.
 */
package bloop.integrations.gradle.tasks;

import bloop.config.Config;
import bloop.config.package$;
import bloop.integrations.gradle.BloopParameters;
import bloop.integrations.gradle.BloopParametersExtension;
import bloop.integrations.gradle.model.BloopConverter;
import bloop.integrations.gradle.syntax$;
import bloop.integrations.gradle.tasks.PluginUtils;
import bloop.integrations.gradle.tasks.TaskLogging;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import scala.Function1;
import scala.MatchError;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001%4A!\u0003\u0006\u0001'!)A\u0005\u0001C\u0001K!9q\u0005\u0001b\u0001\n\u0003B\u0003B\u0002\u0017\u0001A\u0003%\u0011\u0006C\u0004.\u0001\t\u0007I\u0011\u0002\u0018\t\rM\u0002\u0001\u0015!\u00030\u0011\u0015!\u0004\u0001\"\u00016\u0011\u0015\u0011\u0005\u0001\"\u00016\u0011\u0015\u0019\u0005\u0001\"\u0003E\u0005A\u0011En\\8q\u0013:\u001cH/\u00197m)\u0006\u001c8N\u0003\u0002\f\u0019\u0005)A/Y:lg*\u0011QBD\u0001\u0007OJ\fG\r\\3\u000b\u0005=\u0001\u0012\u0001D5oi\u0016<'/\u0019;j_:\u001c(\"A\t\u0002\u000b\tdwn\u001c9\u0004\u0001M!\u0001\u0001F\u000f\"!\t)2$D\u0001\u0017\u0015\t9\u0002$A\u0002ba&T!!D\r\u000b\u0003i\t1a\u001c:h\u0013\tabCA\u0006EK\u001a\fW\u000f\u001c;UCN\\\u0007C\u0001\u0010 \u001b\u0005Q\u0011B\u0001\u0011\u000b\u0005-\u0001F.^4j]V#\u0018\u000e\\:\u0011\u0005y\u0011\u0013BA\u0012\u000b\u0005-!\u0016m]6M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u00051\u0003C\u0001\u0010\u0001\u0003\u001d\u0001(o\u001c6fGR,\u0012!\u000b\t\u0003+)J!a\u000b\f\u0003\u000fA\u0013xN[3di\u0006A\u0001O]8kK\u000e$\b%A\u0005fqR,gn]5p]V\tq\u0006\u0005\u00021c5\tA\"\u0003\u00023\u0019\tA\"\t\\8paB\u000b'/Y7fi\u0016\u00148/\u0012=uK:\u001c\u0018n\u001c8\u0002\u0015\u0015DH/\u001a8tS>t\u0007%A\u0002sk:$\u0012A\u000e\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\u0005+:LG\u000f\u000b\u0002\u0007{A\u0011a\bQ\u0007\u0002\u007f)\u00111BF\u0005\u0003\u0003~\u0012!\u0002V1tW\u0006\u001bG/[8o\u00039\u0011XO\u001c\"m_>\u0004\b\u000b\\;hS:\f!dZ3oKJ\fG/\u001a\"m_>\u00048i\u001c8gS\u001e,(/\u0019;j_:$RAN#S/\u0006DQA\u0012\u0005A\u0002\u001d\u000b1\u0002\u001d:pU\u0016\u001cGOT1nKB\u0011\u0001j\u0014\b\u0003\u00136\u0003\"A\u0013\u001d\u000e\u0003-S!\u0001\u0014\n\u0002\rq\u0012xn\u001c;?\u0013\tq\u0005(\u0001\u0004Qe\u0016$WMZ\u0005\u0003!F\u0013aa\u0015;sS:<'B\u0001(9\u0011\u0015\u0019\u0006\u00021\u0001U\u0003%\u0019x.\u001e:dKN+G\u000f\u0005\u0002?+&\u0011ak\u0010\u0002\n'>,(oY3TKRDQ\u0001\u0017\u0005A\u0002e\u000b\u0011\u0002^1sO\u0016$H)\u001b:\u0011\u0005i{V\"A.\u000b\u0005qk\u0016AA5p\u0015\u0005q\u0016\u0001\u00026bm\u0006L!\u0001Y.\u0003\t\u0019KG.\u001a\u0005\u0006E\"\u0001\raY\u0001\nG>tg/\u001a:uKJ\u0004\"\u0001Z4\u000e\u0003\u0015T!A\u001a\u0007\u0002\u000b5|G-\u001a7\n\u0005!,'A\u0004\"m_>\u00048i\u001c8wKJ$XM\u001d")
public class BloopInstallTask
extends DefaultTask
implements PluginUtils,
TaskLogging {
    private final Project project;
    private final BloopParametersExtension extension;

    @Override
    public void debug(String msg) {
        TaskLogging.debug$(this, msg);
    }

    @Override
    public void info(String msg) {
        TaskLogging.info$(this, msg);
    }

    @Override
    public boolean canRunBloop() {
        return PluginUtils.canRunBloop$(this);
    }

    @Override
    public Project project() {
        return this.project;
    }

    private BloopParametersExtension extension() {
        return this.extension;
    }

    @TaskAction
    public void run() {
        if (this.canRunBloop()) {
            this.runBloopPlugin();
        } else {
            this.info(new StringBuilder(60).append("Ignoring 'bloopInstall' on non-Scala and non-Java project '").append(this.project().getName()).append("'").toString());
        }
    }

    public void runBloopPlugin() {
        Object object;
        BloopParameters parameters = this.extension().createParameters();
        BloopConverter converter = new BloopConverter(parameters);
        File targetDir = parameters.targetDir();
        this.info(new StringBuilder(34).append("Generating Bloop configuration to ").append(targetDir.getAbsolutePath()).toString());
        if (!targetDir.exists()) {
            this.debug(new StringBuilder(26).append("Creating target directory ").append(targetDir).toString());
            object = Files.createDirectory(targetDir.toPath(), new FileAttribute[0]);
        } else {
            object = BoxedUnit.UNIT;
        }
        syntax$.MODULE$.ProjectExtension(this.project()).allSourceSets().foreach((Function1 & Serializable & scala.Serializable)sourceSet -> {
            BloopInstallTask.$anonfun$runBloopPlugin$1(this, converter, targetDir, sourceSet);
            return BoxedUnit.UNIT;
        });
    }

    private void generateBloopConfiguration(String projectName, SourceSet sourceSet, File targetDir, BloopConverter converter) {
        File targetFile = syntax$.MODULE$.FileExtension(targetDir).$div(new StringBuilder(5).append(projectName).append(".json").toString());
        this.info(new StringBuilder(10).append("Generated ").append(targetFile.getAbsolutePath()).toString());
        Try<Config.File> try_ = converter.toBloopConfig(this.project(), sourceSet, targetDir);
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable reason = failure.exception();
            this.info(new StringBuilder(20).append("Skipping ").append(this.project().getName()).append("/").append(sourceSet.getName()).append(" because: ").append(reason).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            Config.File bloopConfig = (Config.File)success.value();
            package$.MODULE$.write(bloopConfig, targetFile.toPath());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(try_);
        }
    }

    public static final /* synthetic */ void $anonfun$runBloopPlugin$1(BloopInstallTask $this, BloopConverter converter$1, File targetDir$1, SourceSet sourceSet) {
        String projectName = converter$1.getProjectName($this.project(), sourceSet);
        $this.generateBloopConfiguration(projectName, sourceSet, targetDir$1, converter$1);
    }

    public BloopInstallTask() {
        PluginUtils.$init$(this);
        TaskLogging.$init$(this);
        this.project = this.getProject();
        this.extension = (BloopParametersExtension)syntax$.MODULE$.ProjectExtension(this.project()).getExtension(ClassTag$.MODULE$.apply(BloopParametersExtension.class));
    }
}

