/*
 * Decompiled with CFR 0.152.
 */
package bloop.integrations.gradle.tasks;

import bloop.integrations.gradle.BloopParameters;
import bloop.integrations.gradle.BloopParametersExtension;
import bloop.integrations.gradle.model.BloopConverter;
import bloop.integrations.gradle.syntax$;
import bloop.integrations.gradle.tasks.AndroidInstall$;
import bloop.integrations.gradle.tasks.PluginUtils;
import bloop.integrations.gradle.tasks.ScalaJavaInstall$;
import bloop.integrations.gradle.tasks.TaskLogging;
import java.io.File;
import java.io.Serializable;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import scala.Function1;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\t3A\u0001C\u0005\u0001%!)1\u0005\u0001C\u0001I!9a\u0005\u0001b\u0001\n\u0003:\u0003BB\u0016\u0001A\u0003%\u0001\u0006C\u0004-\u0001\t\u0007I\u0011B\u0017\t\rI\u0002\u0001\u0015!\u0003/\u0011\u0015\u0019\u0004\u0001\"\u00015\u0011\u0015\t\u0005\u0001\"\u00015\u0005A\u0011En\\8q\u0013:\u001cH/\u00197m)\u0006\u001c8N\u0003\u0002\u000b\u0017\u0005)A/Y:lg*\u0011A\"D\u0001\u0007OJ\fG\r\\3\u000b\u00059y\u0011\u0001D5oi\u0016<'/\u0019;j_:\u001c(\"\u0001\t\u0002\u000b\tdwn\u001c9\u0004\u0001M!\u0001a\u0005\u000f!!\t!\"$D\u0001\u0016\u0015\t1r#A\u0002ba&T!\u0001\u0004\r\u000b\u0003e\t1a\u001c:h\u0013\tYRCA\u0006EK\u001a\fW\u000f\u001c;UCN\\\u0007CA\u000f\u001f\u001b\u0005I\u0011BA\u0010\n\u0005-\u0001F.^4j]V#\u0018\u000e\\:\u0011\u0005u\t\u0013B\u0001\u0012\n\u0005-!\u0016m]6M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005)\u0003CA\u000f\u0001\u0003\u001d\u0001(o\u001c6fGR,\u0012\u0001\u000b\t\u0003)%J!AK\u000b\u0003\u000fA\u0013xN[3di\u0006A\u0001O]8kK\u000e$\b%A\u0005fqR,gn]5p]V\ta\u0006\u0005\u00020a5\t1\"\u0003\u00022\u0017\tA\"\t\\8paB\u000b'/Y7fi\u0016\u00148/\u0012=uK:\u001c\u0018n\u001c8\u0002\u0015\u0015DH/\u001a8tS>t\u0007%A\u0002sk:$\u0012!\u000e\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\u0005+:LG\u000f\u000b\u0002\u0007yA\u0011QhP\u0007\u0002})\u0011!\"F\u0005\u0003\u0001z\u0012!\u0002V1tW\u0006\u001bG/[8o\u00039\u0011XO\u001c\"m_>\u0004\b\u000b\\;hS:\u0004")
public class BloopInstallTask
extends DefaultTask
implements PluginUtils,
TaskLogging {
    private final Project project;
    private final BloopParametersExtension extension;

    @Override
    public void debug(String msg) {
        TaskLogging.debug$(this, msg);
    }

    @Override
    public void info(String msg) {
        TaskLogging.info$(this, msg);
    }

    @Override
    public boolean canRunBloop() {
        return PluginUtils.canRunBloop$(this);
    }

    @Override
    public boolean hasJavaScalaPlugin() {
        return PluginUtils.hasJavaScalaPlugin$(this);
    }

    @Override
    public boolean hasAndroidPlugin() {
        return PluginUtils.hasAndroidPlugin$(this);
    }

    @Override
    public Project project() {
        return this.project;
    }

    private BloopParametersExtension extension() {
        return this.extension;
    }

    @TaskAction
    public void run() {
        if (this.canRunBloop()) {
            this.runBloopPlugin();
        } else {
            this.info(new StringBuilder(70).append("Ignoring 'bloopInstall' on non-Scala, non-Java, non-Android project '").append(this.project().getName()).append("'").toString());
        }
    }

    public void runBloopPlugin() {
        block5: {
            Object object;
            BloopParameters parameters = this.extension().createParameters();
            BloopConverter converter = new BloopConverter(parameters, (Function1<String, BoxedUnit>)(Function1 & Serializable)msg -> {
                this.info(msg);
                return BoxedUnit.UNIT;
            });
            File targetDir = parameters.targetDir();
            this.info(new StringBuilder(34).append("Generating Bloop configuration to ").append(targetDir.getAbsolutePath()).toString());
            if (!targetDir.exists()) {
                this.debug(new StringBuilder(26).append("Creating target directory ").append(targetDir).toString());
                try {
                    object = Files.createDirectory(targetDir.toPath(), new FileAttribute[0]);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    object = BoxedUnit.UNIT;
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            if (this.hasJavaScalaPlugin()) {
                ScalaJavaInstall$.MODULE$.install(this.project(), targetDir, converter, (Function1<String, BoxedUnit>)(Function1 & Serializable)msg -> {
                    this.info(msg);
                    return BoxedUnit.UNIT;
                });
            }
            if (!this.hasAndroidPlugin()) break block5;
            AndroidInstall$.MODULE$.install(this.project(), targetDir, converter, (Function1<String, BoxedUnit>)(Function1 & Serializable)msg -> {
                this.info(msg);
                return BoxedUnit.UNIT;
            });
        }
    }

    public BloopInstallTask() {
        PluginUtils.$init$(this);
        TaskLogging.$init$(this);
        this.project = this.getProject();
        this.extension = (BloopParametersExtension)syntax$.MODULE$.ProjectExtension(this.project()).getExtension(ClassTag$.MODULE$.apply(BloopParametersExtension.class));
    }
}

